# Archives of 2020

## Contents
* [Sample Projects](#sample-projects)
* [Tutorials](#tutorials)
* [Libraries & Extensions](#libraries--extensions)
* [Videos](#videos)
* [Articles](#articles)
* [Podcasts](#podcasts)
* [Presentations slides](#presentations-slides)
* [Tooling](#tooling)


## Sample Projects
* [Pattern Maker](https://github.com/sapsari/website-blazor-demo) - ![last commit](https://img.shields.io/github/last-commit/sapsari/website-blazor-demo?style=flat-square&cacheSeconds=86400) C# code transformation demo that uses Roslyn and Monaco Editor. [Demo](https://patternmaker.netlify.com/), [Demo2](https://enchanter.netlify.app/).
* [CountDown Timer](https://github.com/ebattulga/TestCountDown) - ![last commit](https://img.shields.io/github/last-commit/ebattulga/TestCountDown?style=flat-square&cacheSeconds=86400) Count down timer with Browser notification and PWA using Blazor WebAssembly. [Demo](https://ebattulga.github.io/TestCountDown/).
* [BlazorMoonPhase](https://github.com/lohithgn/blazor-moonphase) - ![last commit](https://img.shields.io/github/last-commit/lohithgn/blazor-moonphase?style=flat-square&cacheSeconds=86400) Moon Phase Sighting app using Blazor WebAssembly, by Lohith GN. [Demo](https://blazormoonphase.surge.sh).
* [Send an Sms](https://github.com/nexmo-community/send-an-sms-with-blazor) - ![last commit](https://img.shields.io/github/last-commit/nexmo-community/send-an-sms-with-blazor?style=flat-square&cacheSeconds=86400) This demo shows how to send an Sms with Blazor using the [Vonage SMS API](https://developer.nexmo.com/messaging/sms/overview).
* [Ray Tracer](https://github.com/LucasHamera/raytracer.cs) - ![last commit](https://img.shields.io/github/last-commit/LucasHamera/raytracer.cs?style=flat-square&cacheSeconds=86400) Simple ray tracer in Blazor.
* [Blazor Web Camera Application Example](https://github.com/simutaroman/BlazorWebCamApp) - ![last commit](https://img.shields.io/github/last-commit/simutaroman/BlazorWebCamApp?style=flat-square&cacheSeconds=86400) Here is a fun example of using camera in the ASP.NET Core Blazor WebAssembly application. Complete description of how it was created on this blog's post [Using a web camera with fun filters in your ASP.NET Core Blazor WebAssembly application](https://romansimuta.com/posts/using-a-web-camera-with-fun-filters-in-your-asp-net-core-blazor-webassembly-application/).
* [BlazorContrib](https://github.com/miguelhasse/BlazorContrib) - ![last commit](https://img.shields.io/github/last-commit/miguelhasse/BlazorContrib?style=flat-square&cacheSeconds=86400) Experiment of a Blazor renderer for Markdig, a Markdown component.
* [Poker Odds Pro Calculator](https://github.com/dyh1213/PokerOddsPro) - ![last commit](https://img.shields.io/github/last-commit/dyh1213/PokerOddsPro?style=flat-square&cacheSeconds=86400) Responsive poker odds calculator using blazor WebAssembly and pure C#. [Demo](https://dyh1213.github.io/PokerOddsPro.io/).
* [BlazorOCR](https://github.com/daltskin/BlazorOCR) - ![Last commit](https://img.shields.io/github/last-commit/daltskin/BlazorOCR?style=flat-square&cacheSeconds=86400) A Blazor WebAssembly application for reading receipts.
* [Blazor.Console](https://github.com/ardacetinkaya/Blazor.Console) - ![last commit](https://img.shields.io/github/last-commit/ardacetinkaya/Blazor.Console?style=flat-square&cacheSeconds=86400) A simple component to mock CLI for ASP.NET Core 3.0 Blazor applications to execute some custom commands for an application.
* [Gjallarhorn](https://github.com/haavamoa/Gjallarhorn) - ![Last commit](https://img.shields.io/github/last-commit/haavamoa/Gjallarhorn?style=flat-square&cacheSeconds=86400) Compare packages on different NuGet-sources. Demonstrating Client-Side Blazor MVVM-style. 
* [C# Minifer](https://github.com/atifaziz/CSharpMinifierDemo) ![last-commit](https://img.shields.io/github/last-commit/atifaziz/CSharpMinifierDemo?style=flat-square&cacheSeconds=86400) A client-side Blazor application demonstrating live minification of C# code using the [C# Minifier](https://github.com/atifaziz/CSharpMinifier) library. [Demo](https://atifaziz.github.io/CSharpMinifierDemo/).
* [BlazorServerTree](https://github.com/ctrl-alt-d/BlazorServerTree) - ![GitHub stars](https://img.shields.io/github/stars/ctrl-alt-d/BlazorServerTree?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/ctrl-alt-d/BlazorServerTree?style=flat-square&cacheSeconds=86400) A simple Server-Side Blazor sample app to deal with hierarchical data.
* [Minimal ToDo by David Fowler](https://github.com/davidfowl/Todos/tree/davidfowl/todo-blazor/TodoBlazor) - ![stars](https://img.shields.io/github/stars/davidfowl/Todos?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/davidfowl/Todos?style=flat-square&cacheSeconds=86400) Minimal ToDo backend API implementation by David Fowler from Microsoft.
* [BlazorPages](https://github.com/fernandreu/blazor-pages) - ![stars](https://img.shields.io/github/stars/fernandreu/blazor-pages?style=flat-square&cacheSeconds=604800) ![last-commit](https://img.shields.io/github/last-commit/fernandreu/blazor-pages?style=flat-square&cacheSeconds=86400) A sample client-side Blazor app showcasing automatic deployment to GitHub Pages via Azure Pipelines.
* [BlazorGrpcWebCodeFirst](https://github.com/hakenr/BlazorGrpcWebCodeFirst) - ![last commit](https://img.shields.io/github/last-commit/hakenr/BlazorGrpcWebCodeFirst?style=flat-square&cacheSeconds=86400) Sample project that demonstrates how you can use gRPC-Web with Blazor WebAssembly hosted on ASP.NET Core. Publish and consume your services without having to create .proto files - with the code-first approach.
* [SignalR CLR](https://github.com/slorello89/SignalRClr) - ![last commit](https://img.shields.io/github/last-commit/slorello89/SignalRClr?style=flat-square&cacheSeconds=86400) This is a simple example of using SignalR and Blazor WebAssembly together to eliminate the need for any JavaScript when handling server event's. [Blog post](https://slorello.com/posts/signalr-without-javascript-using-blazor-webassembly) about this sample.
* [Serverless StreamR](https://github.com/anthonychu/serverless-streamr-blazor) - ![last commit](https://img.shields.io/github/last-commit/anthonychu/serverless-streamr-blazor?style=flat-square&cacheSeconds=86400) A serverless port of StreamR powered by Blazor WebAssembly and Azure.
* [TonClientBlazor](https://github.com/ton-actions/ton-client-blazor) - ![last commit](https://img.shields.io/github/last-commit/ton-actions/ton-client-blazor?style=flat-square&cacheSeconds=86400) Free TON network client. [Demo](https://ton-actions.github.io/ton-client-blazor/).
* [Blazor Server Firestore Integration](https://github.com/Swimburger/BlazorServerFirestore) ![last commit](https://img.shields.io/github/last-commit/Swimburger/BlazorServerFirestore?style=flat-square&cacheSeconds=86400) Source code of the article [Building Real-Time Applications with Blazor Server and Firestore](https://www.twilio.com/blog/building-real-time-applications-with-blazor-server-and-firestore).
* [BlazorWebView](https://github.com/jspuij/BlazorWebView) - ![stars](https://img.shields.io/github/stars/jspuij/BlazorWebView?style=flat-square&cacheSeconds=604800) ![last-commit](https://img.shields.io/github/last-commit/jspuij/BlazorWebView?style=flat-square&cacheSeconds=86400) A BlazorWebView "Control" that is easily embedded in (Native) UI frameworks.
* [CarChecker](https://github.com/SteveSandersonMS/CarChecker) - ![GitHub stars](https://img.shields.io/github/stars/SteveSandersonMS/CarChecker?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/SteveSandersonMS/CarChecker?style=flat-square&cacheSeconds=86400) This is a sample application for Blazor by Steve Sanderson which was presented at Build 2020. You can view the on-demand walk-through for this on Channel 9: [Modern Web UI with Blazor WebAssembly](https://channel9.msdn.com/Events/Build/2020/BOD104). This is a great sample which has a lot of Blazor + ASP.NET integrations such as: client-side debugging with Visual Studio, authentication / authorization, input validation, data integration/sync, Blazor components, code sharing, JavaScript interop, localization / internationalization, Progressive Web App (PWA) and more.
* [dotnet-podcasts](https://github.com/microsoft/dotnet-podcasts) - ![GitHub stars](https://img.shields.io/github/stars/dotnet-podcasts?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/dotnet-podcasts?style=flat-square&cacheSeconds=86400) .NET 6 reference application shown at .NET Conf 2021 featuring ASP.NET Core, Blazor, .NET MAUI, Microservices, and more.
* [Try F# on WebAssembly](https://github.com/fsbolero/TryFSharpOnWasm) - ![stars](https://img.shields.io/github/stars/fsbolero/TryFSharpOnWasm?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/fsbolero/TryFSharpOnWasm?style=flat-square&cacheSeconds=86400) The F# compiler running in WebAssembly with Bolero.
* [BlazorPoint](https://github.com/smjltd/BlazorPoint) - ![stars](https://img.shields.io/github/stars/smjltd/BlazorPoint?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/smjltd/BlazorPoint?style=flat-square&cacheSeconds=86400) Sample App to help you get started with hosting Blazor on SharePoint Pages, completely Client Side. 
* [gRPC-Web](https://github.com/waelkdouh/gRPC-Web) - ![stars](https://img.shields.io/github/stars/waelkdouh/gRPC-Web?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/waelkdouh/gRPC-Web?style=flat-square&cacheSeconds=86400) Sample about gRPC-Web and Blazor WebAssembly.
* [BlazorDungeon](https://github.com/alexandrelozano/BlazorDungeon) - ![last commit](https://img.shields.io/github/last-commit/alexandrelozano/BlazorDungeon?style=flat-square&cacheSeconds=86400) - Multiuser dungeon game. Text based graphics. Up to 5 simultaneous players. [Demo](http://13.48.11.221/BlazorDungeon).
* [Flappy Bird](https://github.com/blazorbuilds/Flappy-Bird) ![last commit](https://img.shields.io/github/last-commit/blazorbuilds/Flappy-Bird?style=flat-square&cacheSeconds=86400) A Blazor WebAssembly implementation of Flappy Bird.
* [Blazorships](https://github.com/bjorndaniel/Blazorships) - ![last commit](https://img.shields.io/github/last-commit/bjorndaniel/Blazorships?style=flat-square&cacheSeconds=86400) Battleship implementation built with Blazor and SignalR.
* [TicTacToe](https://github.com/ysflghou/Tic-Tac-Toe) - ![last commit](https://img.shields.io/github/last-commit/ysflghou/Tic-Tac-Toe?style=flat-square&cacheSeconds=86400) Tic Tac Toe game using blazor webassembly. Here is a [Demo](https://ysflghou.github.io/BlazorTicTacToe/) and a [Blog post](https://lghou.com/blog/blazor-webassembly).
* [AcBlog](https://github.com/acblog/acblog) - ![stars](https://img.shields.io/github/stars/acblog/acblog?style=flat-square&cacheSeconds=604800) ![Last commit](https://img.shields.io/github/last-commit/acblog/acblog?style=flat-square&cacheSeconds=86400) A blogging PWA that can be hosted as a full static website or as a server-prerender dynamic website. [GitHub Pages Demo](https://acblog.github.io).
* [BlazingOrchard](https://github.com/BlazingOrchard/Blazing-Orchard) - ![stars](https://img.shields.io/github/stars/BlazingOrchard/Blazing-Orchard?style=flat-square&cacheSeconds=604800) ![Last commit](https://img.shields.io/github/last-commit/BlazingOrchard/Blazing-Orchard?style=flat-square&cacheSeconds=86400) Blazing Orchard is a modular application framework that turns your Blazor project into a CMS-powered Blazor application by leveraging Orchard Core as a decoupled backend/CMS server using its REST & GraphQL APIs.
* [BlazorGhost](https://github.com/KageKirin/BlazorGhost) - ![Last commit](https://img.shields.io/github/last-commit/KageKirin/BlazorGhost?style=flat-square&cacheSeconds=86400) A Blazor frontend for Ghost blogs.
* [BlazorWPBlog](https://github.com/mizrael/BlazorWPBlog) - ![last commit](https://img.shields.io/github/last-commit/mizrael/BlazorWPBlog?style=flat-square&cacheSeconds=86400) Wordpress blog with Blazor.
* [BlazorForum](https://github.com/ElliottBrand/BlazorForum) - ![stars](https://img.shields.io/github/stars/ElliottBrand/BlazorForum?style=flat-square&cacheSeconds=604800) ![Last commit](https://img.shields.io/github/last-commit/ElliottBrand/BlazorForum?style=flat-square&cacheSeconds=86400) Forum application built with Blazor.
* [BlazorFile2Azure](https://github.com/daltskin/BlazorFile2Azure) - ![stars](https://img.shields.io/github/stars/daltskin/BlazorFile2Azure?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/daltskin/BlazorFile2Azure?style=flat-square&cacheSeconds=86400) Upload a file from Blazor WebAssembly to Azure Blob Storage.
* [Blazor WASM Deployment](https://github.com/timheuer/blazor-deploy-sample/) - ![last commit](https://img.shields.io/github/last-commit/timheuer/blazor-deploy-sample?style=flat-square&cacheSeconds=86400) Sample repo for showing Actions to deploy a Blazor app to Azure services.
* [Blazor.JobBoard](https://github.com/lohithgn/Blazor.JobBoard/) - ![last commit](https://img.shields.io/github/last-commit/lohithgn/Blazor.JobBoard?style=flat-square&cacheSeconds=86400) Blazor WebAssembly based jobboard application deployed to Azure Storage Static Site. [Demo](https://blazjobboard.azurewebsites.net/).
* [Blazor WebAssembly and Azure Active Directory](https://github.com/waelkdouh/BlazorWebAssemblyAADImplicitGrantFlow) - ![last commit](https://img.shields.io/github/last-commit/waelkdouh/BlazorWebAssemblyAADImplicitGrantFlow?style=flat-square&cacheSeconds=86400) Blazor WebAssembly application secured with Azure Active Directory. This source code is related to an article on Medium: [Securing a Blazor WebAssembly application with Azure Active Directory](https://medium.com/@waelkdouh/securing-a-blazor-webassembly-application-with-azure-active-directory-7822148f332b).
* [Blazor Authentication Extension for Azure Static Web Apps](https://github.com/anthonychu/blazor-auth-static-web-apps/tree/main/sample) - ![last commit](https://img.shields.io/github/last-commit/anthonychu/blazor-auth-static-web-apps?style=flat-square&cacheSeconds=86400) Blazor Authentication Extension for Azure Static Web Apps.
* [BlazorGraphApi](https://github.com/wmgdev/BlazorGraphApi) - ![stars](https://img.shields.io/github/stars/wmgdev/BlazorGraphApi?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/wmgdev/BlazorGraphApi?style=flat-square&cacheSeconds=86400) Blazor Server App with AD Authentication, that calls the MS Graph API on-behalf of the signed-in user using [Microsoft.Identity.Web](https://github.com/AzureAD/microsoft-identity-web).
* [Blazor and Identity Server](https://github.com/cradle77/BlazorSecurityDemo) - ![stars](https://img.shields.io/github/stars/cradle77/BlazorSecurityDemo?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/cradle77/BlazorSecurityDemo?style=flat-square&cacheSeconds=86400) This project demonstrates how to secure a Blazor WebAssembly application with a standalone Identity Server instance and use it to acquire a token for a protected API.
* [BlazorAuthenticationSample](https://github.com/christiansparre/BlazorAuthenticationSample) - ![stars](https://img.shields.io/github/stars/christiansparre/BlazorAuthenticationSample?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/christiansparre/BlazorAuthenticationSample?style=flat-square&cacheSeconds=86400) A sample showing some of the ASP.NET Core Blazor authentication features (also some testing...).
* [Blazor contacts](https://github.com/bradwellsb/blazor-contacts) - ![stars](https://img.shields.io/github/stars/bradwellsb/blazor-contacts?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/bradwellsb/blazor-contacts?style=flat-square&cacheSeconds=86400) A project template for OData API, IdentityServer4 auth, and server-side Blazor.
* [Toss.Blazor](https://github.com/RemiBou/Toss.Blazor) - ![stars](https://img.shields.io/github/stars/RemiBou/Toss.Blazor?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/RemiBou/Toss.Blazor?style=flat-square&cacheSeconds=86400) Twitter-like web application using Blazor.
* [PropertyPrices](https://github.com/jameschch/PropertyPrices) - ![last-commit](https://img.shields.io/github/last-commit/jameschch/PropertyPrices?style=flat-square&cacheSeconds=86400) A blazor front-end site that provides analysis and ensemble learning predictions (through SharpLearning) of property prices in the UK. [Demo (https://propertyprices.org.uk)](https://propertyprices.org.uk).
* [Runny](https://github.com/Suchiman/Runny) - ![GitHub stars](https://img.shields.io/github/stars/Suchiman/Runny?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/Suchiman/Runny?style=flat-square&cacheSeconds=86400) Prototype of running roslyn in the browser via Blazor. [Demo](https://runny.azurewebsites.net/).
* [Return](https://github.com/Sebazzz/Return) - ![GitHub stars](https://img.shields.io/github/stars/Sebazzz/Return?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/Sebazzz/Return?style=flat-square&cacheSeconds=86400) Realtime retrospective tool built in ASP.NET Core and Blazor.
* [BlazorChifoumi](https://github.com/aboudoux/BlazorChifoumi) - ![last-commit](https://img.shields.io/github/last-commit/aboudoux/BlazorChifoumi?style=flat-square&cacheSeconds=86400) Exploring machine learning with a Chifoumi game.
* [BlazorGrpc](https://github.com/razfriman/BlazorGrpc) - ![GitHub stars](https://img.shields.io/github/stars/razfriman/BlazorGrpc?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/razfriman/BlazorGrpc?style=flat-square&cacheSeconds=86400) Sample project that demonstrates how you can use the power of Blazor, ASP.NET Core, and gRPC to create a web application which can communicate with a backend that uses gRPC.
* [Blazor + Sitecore](https://github.com/GoranHalvarsson/SitecoreBlazor) - ![GitHub stars](https://img.shields.io/github/stars/GoranHalvarsson/SitecoreBlazor?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/GoranHalvarsson/SitecoreBlazor?style=flat-square&cacheSeconds=86400) Example of dynamic pages and routes with SiteCore and [Helix](https://helix.sitecore.net/). 
* [BlazorMobile](https://github.com/Daddoon/BlazorMobile) - ![stars](https://img.shields.io/github/stars/Daddoon/BlazorMobile?style=flat-square&cacheSeconds=604800) ![last-commit](https://img.shields.io/github/last-commit/Daddoon/BlazorMobile?style=flat-square&cacheSeconds=86400) Create full C# driven hybrid-apps for iOS, Android, UWP & Desktop with Blazor.
* [BlazeReport](https://github.com/LeoVen/BlazeReport) - ![last commit](https://img.shields.io/github/last-commit/LeoVen/BlazeReport?style=flat-square&cacheSeconds=86400) A minimal example of a Blazor App with NUnit, Selenium, SpecFlow and ExtentReports.
* [BlazorAnimate](https://github.com/BlazorGuy/BlazorAnimate) - ![last commit](https://img.shields.io/github/last-commit/BlazorGuy/BlazorAnimate?style=flat-square&cacheSeconds=86400) A simple example of animating text along a path using Blazor Canvas Extensions. [Demo](https://blazorguy.net/simple-text-animation/).
* [BlazorParallax](https://github.com/fingers10/BlazorParallax) - ![Last commit](https://img.shields.io/github/last-commit/fingers10/BlazorParallax?style=flat-square&cacheSeconds=86400) Simple Parallax Page sample with Blazor Server.
* [GTAVehicles](https://github.com/mytatuo/GTAVehicles) - ![last commit](https://img.shields.io/github/last-commit/mytatuo/GTAVehicles?style=flat-square&cacheSeconds=86400) Sample app to manage GTA vehicles. [Demo](https://gtavehicles.azurewebsites.net/).
* [Blazor Chat](https://github.com/DataJuggler/BlazorChat) - ![last commit](https://img.shields.io/github/last-commit/DataJuggler/BlazorChat?style=flat-square&cacheSeconds=86400) A sample project that demonstrates using a Singleton class to communicate to all subscribers. Site is also live at https://blazorchat.com.
* [BlazorWordGame](https://github.com/borakasmer/BlazorWordGame) ![last commit](https://img.shields.io/github/last-commit/borakasmer/BlazorWordGame?style=flat-square&cacheSeconds=86400) Online Multiplayer Word Game With Blazor and SignalR on .NetCore.
* [Gitter](https://github.com/Blazored/Gitter) - ![GitHub stars](https://img.shields.io/github/stars/Blazored/Gitter?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/Blazored/Gitter?style=flat-square&cacheSeconds=86400) A Blazor Gitter client.
* [BlazeDown](https://github.com/EdCharbeneau/BlazeDown) - ![GitHub stars](https://img.shields.io/github/stars/EdCharbeneau/BlazeDown?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/EdCharbeneau/BlazeDown?style=flat-square&cacheSeconds=86400) BlazeDown, online Markdown editor. [Demo](https://edcharbeneau.com/BlazeDown/).
* [BlazorElectronExperiment](https://github.com/SteveSandersonMS/BlazorElectronExperiment.Sample) - ![GitHub stars](https://img.shields.io/github/stars/SteveSandersonMS/BlazorElectronExperiment.Sample?style=flat-square&cacheSeconds=604800&logo=microsoft) ![last commit](https://img.shields.io/github/last-commit/SteveSandersonMS/BlazorElectronExperiment.Sample?style=flat-square&cacheSeconds=86400) ![Status](https://img.shields.io/static/v1?label=status&message=archived&color=lightgrey) Exploring how a Blazor could be used to build a cross-platform desktop application using [Electron](https://electronjs.org/).
* [BlazorDesktop](https://github.com/steveSandersonMS/BlazorDesktop) - ![GitHub stars](https://img.shields.io/github/stars/steveSandersonMS/BlazorDesktop?style=flat-square&cacheSeconds=604800&logo=microsoft) ![last commit](https://img.shields.io/github/last-commit/steveSandersonMS/BlazorDesktop?style=flat-square&cacheSeconds=86400) Native desktop Blazor app which not using Electron, by Steve Sanderson.
* [Blazor Weather](https://github.com/danroth27/BlazorWeather) - ![stars](https://img.shields.io/github/stars/danroth27/BlazorWeather?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/danroth27/BlazorWeather?style=flat-square&cacheSeconds=86400) A Blazor Weather sample app that shows the current weather for your current location and a collection of pinned locations. Demonstrated at .NET Conf 2019 by Daniel Roth. [Demo](https://aka.ms/blazorweather).
* [BlogCore](https://github.com/thangchung/blog-core) - ![GitHub stars](https://img.shields.io/github/stars/thangchung/blog-core?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/thangchung/blog-core?style=flat-square&cacheSeconds=86400) Modern CMS on Domain-driven Design and Clean Architecture patterns.
* [Blazor.JWTTest](https://github.com/shawty/blazor.jwttest) - ![stars](https://img.shields.io/github/stars/shawty/blazor.jwttest?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/shawty/blazor.jwttest?style=flat-square&cacheSeconds=86400) JWT authentication for a Blazor hosted (Client/Server-side) app with API and Authentication.
* [BlazorQuiz](https://github.com/Amine-Smahi/BlazorQuiz) - ![GitHub stars](https://img.shields.io/github/stars/Amine-Smahi/BlazorQuiz?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/Amine-Smahi/BlazorQuiz?style=flat-square&cacheSeconds=86400) Simple quiz using Blazor.NET and WebAssembly.
* [BlazorChess](https://github.com/Lupusa87/BlazorChess) - ![GitHub stars](https://img.shields.io/github/stars/Lupusa87/BlazorChess?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/Lupusa87/BlazorChess?style=flat-square&cacheSeconds=86400) Chess engine implemented with Blazor. [Demo](https://lupblazorchess.z20.web.core.windows.net/).
* [BlazorTasks](https://github.com/BorowskiKamil/blazor-tasks) - ![stars](https://img.shields.io/github/stars/BorowskiKamil/blazor-tasks?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/BorowskiKamil/blazor-tasks?style=flat-square&cacheSeconds=86000) To-Do App.
* [Tour of Heroes](https://github.com/lohithgn/blazor-tour-of-heroes) - ![GitHub stars](https://img.shields.io/github/stars/lohithgn/blazor-tour-of-heroes?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/lohithgn/blazor-tour-of-heroes?style=flat-square&cacheSeconds=86000) Blazor implementation of Angular Tour of Heroes.
* [BlazingPizza (server side)](https://github.com/ADefWebserver/BlazingPizza) - ![GitHub stars](https://img.shields.io/github/stars/ADefWebserver/BlazingPizza?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/ADefWebserver/BlazingPizza?style=flat-square&cacheSeconds=86000) A server side Blazor version of the Blazing Pizza project from the [Blazor - app building workshop](https://github.com/dotnet-presentations/blazor-workshop/) ![GitHub stars](https://img.shields.io/github/stars/dotnet-presentations/blazor-workshop?style=flat-square&cacheSeconds=604800).
* [BlazorConnectFour](https://github.com/exceptionnotfound/BlazorConnectFour) - ![last commit](https://img.shields.io/github/last-commit/exceptionnotfound/BlazorConnectFour?style=flat-square&cacheSeconds=86400) Classic childhood game ConnectFour in Blazor.
* [Memory Game Wasm/PWA](https://github.com/HillPhelmuth/MemoryEtcWasm) - ![last commit](https://img.shields.io/github/last-commit/HillPhelmuth/MemoryEtcWasm?style=flat-square&cacheSeconds=86400) Simple Memory game with PWA support. [Demo](https://memoryetcwasmserver20200329202745.azurewebsites.net/).
* [BlazorGame](https://github.com/jackpotdk/BlazorGame) - ![last commit](https://img.shields.io/github/last-commit/jackpotdk/BlazorGame?style=flat-square&cacheSeconds=86400) BlazorGame is a small proof-of-concept project to investigate the feasability of Blazor-based C# game development.
* [Lights out Blazor](https://github.com/bjorndaniel/lightsoutpuzzle) - ![last commit](https://img.shields.io/github/last-commit/bjorndaniel/lightsoutpuzzle?style=flat-square&cacheSeconds=86400) Clone based on the 1995 game [Lights Out](https://en.wikipedia.org/wiki/Lights_Out_(game)) by Tiger Electronics [Demo](https://lights-out-puzzle.bjorndaniel.se/).
* [TetrisBlazor](https://github.com/aboudoux/TetrisBlazor) - ![last commit](https://img.shields.io/github/last-commit/aboudoux/TetrisBlazor?style=flat-square&cacheSeconds=86400) Online Game With Blazor and SignalR on .NetCore. [Demo](http://tetris.boudoux.fr/).

## Tutorials
* [Run Blazor in a Docker container with Visual Studio Code Remote Development](https://cloudblogs.microsoft.com/industry-blog/en-gb/cross-industry/2020/12/15/run-blazor-in-a-docker-container-with-visual-studio-code-remote-development/) - December 15, 2020 - Run Blazor in a Docker container with Visual Studio Code Remote Development.
* [Using multiple APIs in Blazor with Azure AD Authentication](https://damienbod.com/2020/12/14/using-multiple-apis-in-blazor-with-azure-ad-authentication/) - December 14, 2020 - The post shows how to create a Blazor application which is hosted in an ASP.NET Core application and provides a public API which uses multiple downstream APIs. Both the Blazor client and the Blazor API are protected by Azure AD authentication. The Blazor UI Client is protected like any single page application. This is a public client which cannot keep a secret. [Source code](https://github.com/damienbod/AzureADAuthRazorUiServiceApiCertificate) ![stars](https://img.shields.io/github/stars/damienbod/AzureADAuthRazorUiServiceApiCertificate?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/damienbod/AzureADAuthRazorUiServiceApiCertificate?style=flat-square&cacheSeconds=86400).
* [Create a Blazor Server app that uses the Microsoft identity platform for authentication](https://docs.microsoft.com/azure/active-directory/develop/tutorial-blazor-server) - October 2020 - Tutorial by Microsoft. Blazor Server provides support for hosting Razor components on the server in an ASP.NET Core app. In this tutorial, you learn how to implement authentication and retrieve data from Microsoft Graph in a Blazor Server app with the Microsoft identity platform.
* [Building a Blazor farm animal soundboard](https://blog.jetbrains.com/dotnet/2020/10/22/building-a-blazor-farm-animal-soundboard/) - October 2020 - Building a Blazor farm animal soundboard, by JetBrains. [Source code](https://github.com/khalidabuhakmeh/Farm) ![stars](https://img.shields.io/github/stars/khalidabuhakmeh/Farm?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/khalidabuhakmeh/Farm?style=flat-square&cacheSeconds=86400).
* [Tour of Heroes in Blazor Wasm Playlist](https://www.youtube.com/playlist?list=PLdwMmKbrXPesoZoRgpO2xaoFuOclteZI7) - August 2020 - Using .Net 5 and Blazor WASM to create the Tour of Heroes app with the addition of how to create Unit Tests with bUnit. This tutorial counts 9 videos on YouTube.
* [Yahtzee in Blazor WebAssembly](https://exceptionnotfound.net/yahtzee-in-blazor-webassembly-part-1-the-csharp-model/) - August 2020 - Tutorial by Exception Not Found. [Part 1: the C# model](https://exceptionnotfound.net/yahtzee-in-blazor-webassembly-part-1-the-csharp-model/). [Source code](https://github.com/exceptionnotfound/BlazorGames) ![stars](https://img.shields.io/github/stars/exceptionnotfound/BlazorGames?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/exceptionnotfound/BlazorGames?style=flat-square&cacheSeconds=86400).
* [Build a video portal with Blazor](https://blazor.pticostarica.com/) - August 2020 - Website contains videos about building a video portal with Blazor.
* [Online Multiplayer Word Game With Blazor and SignalR on .NetCore](https://medium.com/@bora.kasmer78/word-game-with-blazor-and-signalr-on-netcore-e14e125233f2) - August 8, 2020 - Let's build a simple online multiplayer word game with Blazor using SignalR for realtime communication between two players. All the words will keep in MongoDB and it will supports multi-platforms with .Net Core. [Source code](https://github.com/borakasmer/BlazorWordGame) ![stars](https://img.shields.io/github/stars/borakasmer/BlazorWordGame?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/borakasmer/BlazorWordGame?style=flat-square&cacheSeconds=86400).
* [Build a Blazor WebAssembly line of business app](https://blog.jeremylikness.com/blog/build-a-blazor-webassembly-line-of-business-app/) - June, 2020 - Build a Blazor WebAssembly line of business app. [Part 1](https://blog.jeremylikness.com/blog/build-a-blazor-webassembly-line-of-business-app/). [Part 2](https://blog.jeremylikness.com/blog/build-a-blazor-webassembly-line-of-business-app-part-2/). [Part 3](https://blog.jeremylikness.com/blog/build-a-blazor-webassembly-line-of-business-app-part-3/). [Part 4](https://blog.jeremylikness.com/blog/build-a-blazor-webassembly-line-of-business-app-part-4/). [Source code](https://github.com/JeremyLikness/BlazorWasmEFCoreExample) ![stars](https://img.shields.io/github/stars/JeremyLikness/BlazorWasmEFCoreExample?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/JeremyLikness/BlazorWasmEFCoreExample?style=flat-square&cacheSeconds=86400).
* [Simple RPG with .NET and Azure technologies](https://darthpedro.net/tutorials-simple-rpg/) - Follow along with the Simple RPG tutorials as we learn new areas of .NET and Azure technologies focused around Blazor client applications and Azure Functions for web service backends. Source code: [https://dev.azure.com/d20Tek/SimpleRPG/_git/simple-rpg-game](https://dev.azure.com/d20Tek/SimpleRPG/_git/simple-rpg-game).
* [Create a 2D game with Blazor](https://www.davideguida.com/category/programming/gamedev/) - July 2020 - [Part 1: Intro](https://www.davideguida.com/blazor-and-2d-game-development-part-1-intro/). [Part 2: Canvas initialization](https://www.davideguida.com/blazor-gamedev-part-2-canvas-initialization/). [Part 3: Sprite rendering](https://www.davideguida.com/blazor-gamedev-part-3-sprite-rendering/). [Part 4: Moving a sprite](https://www.davideguida.com/blazor-gamedev-part-4-moving-a-sprite/). [Source code](https://github.com/mizrael/BlazorCanvas) ![stars](https://img.shields.io/github/stars/mizrael/BlazorCanvas?style=flat-square&cacheSeconds=604800) ![last-commit](https://img.shields.io/github/last-commit/mizrael/BlazorCanvas?style=flat-square&cacheSeconds=86400).
* [Build Tic Tac Toe game with Blazor WebAssembly](https://lghou.com/blog/blazor-webassembly) - July 2020 - Build Tic Tac Toe game with Blazor WebAssembly. [Source code](https://github.com/ysflghou/Tic-Tac-Toe) ![stars](https://img.shields.io/github/stars/ysflghou/Tic-Tac-Toe?style=flat-square&cacheSeconds=604800) ![last-commit](https://img.shields.io/github/last-commit/ysflghou/Tic-Tac-Toe?style=flat-square&cacheSeconds=86400). [Demo](https://ysflghou.github.io/BlazorTicTacToe/).
* [Create a small blog in Blazor](https://www.roundthecode.com/dotnet/blazor) - June, 2020 - Create a small blog in Blazor, by RoundTheCode. [Part 1: Create application in Visual Studio](https://www.roundthecode.com/dotnet/blazor/create-a-small-blog-in-blazor-create-application-in-visual-studio). [Part 2: Entity Framework integration](https://www.roundthecode.com/dotnet/blazor/create-a-small-blog-in-blazor-entity-framework-integration). [Part 3: Build Entity Framework queries](https://www.roundthecode.com/dotnet/blazor/create-a-small-blog-in-blazor-build-entity-framework-queries). [Part 4: Build Category and Page Razor Components](https://www.roundthecode.com/dotnet/blazor/create-a-small-blog-in-blazor-build-category-and-page-razor-components).
* [Custom Authentication in Blazor WebAssembly – Detailed Tutorial](https://www.codewithmukesh.com/blog/authentication-in-blazor-webassembly/) - June 12, 2020 - In this next part of the Blazor Blog Series, Let’s learn about implementing Custom Authentication in Blazor WebAssembly Project (Blazor.Learner). We will cover some core concepts that can get you familiar with how authentication works in Blazor Applications. [Source code](https://github.com/iammukeshm/Blazor.Learner) ![stars](https://img.shields.io/github/stars/iammukeshm/Blazor.Learner?style=flat-square&cacheSeconds=604800) ![last-commit](https://img.shields.io/github/last-commit/iammukeshm/Blazor.Learner?style=flat-square&cacheSeconds=86400).
* [Blazor CRUD with Entity Framework Core – Detailed Tutorial](https://www.codewithmukesh.com/blog/blazor-crud-with-entity-framework-core/) - June 4, 2020 - Building a CRUD Application is like the Hello World for Intermediate Developers. It helps you understand the most common operations of any particular stack. In this tutorial, let’s build a Client-side Blazor CRUD Application that uses Entity Framework Core as it’s Data Access Layer. [Source code](https://github.com/iammukeshm/Blazor.Learner/tree/blazor-blog-series-part-3) ![stars](https://img.shields.io/github/stars/iammukeshm/Blazor.Learner?style=flat-square&cacheSeconds=604800) ![last-commit](https://img.shields.io/github/last-commit/iammukeshm/Blazor.Learner?style=flat-square&cacheSeconds=86400).
* [Implementing Blazor CRUD using Mudblazor Component Library in .NET 5 – Detailed Guide](https://codewithmukesh.com/blog/blazor-crud-using-mudblazor/) - February 17, 2021 - In this article, we will demonstrate implementing Blazor CRUD using Mudblazor Component Library with a more polished way to achieve the CRUD functionalities. Mudblazor is without any doubt one of the coolest and complete looking Blazor Component Libraries out there. Kudos to the Mudblazor Team! [Source code](https://github.com/iammukeshm/MudblazorDemo.CRUD) ![stars](https://img.shields.io/github/stars/iammukeshm/MudblazorDemo.CRUD?style=flat-square&cacheSeconds=604800) ![last-commit](https://img.shields.io/github/last-commit/iammukeshm/MudblazorDemo.CRUD?style=flat-square&cacheSeconds=86400).
* [Integrating Tailwind CSS with Blazor – Detailed Guide](https://codewithmukesh.com/blog/integrating-tailwind-css-with-blazor/) - February 24, 2021 - In this article, we will be Integrating Tailwind CSS With Blazor Applications. This is a guide exclusively for the .NET devs like me who are not much into CSS, yet want to build clean-looking UIs. We will get started with building great UI components with just half (or even less than half) of the CSS knowledge you already have. [Source code](https://github.com/iammukeshm/BlazorWithTailwindCSS) ![stars](https://img.shields.io/github/stars/iammukeshm/BlazorWithTailwindCSS?style=flat-square&cacheSeconds=604800) ![last-commit](https://img.shields.io/github/last-commit/iammukeshm/BlazorWithTailwindCSS?style=flat-square&cacheSeconds=86400).
* [Creating Outlook Calendar Client from scratch](https://www.youtube.com/watch?v=5ouXHtzKL5o&list=PLFJQnCcZXWjv89uDubYW7NniK8mEl4sWQ) - May, 2020 - In this course you'll see how to develop a calendar application from scratch (design, structing and logic) then make it integrated with Microsoft Outlook so our events on the calendar being synced with Outlook. [Source code](https://github.com/aksoftware98/BlazorOutlookCalendar) ![stars](https://img.shields.io/github/stars/aksoftware98/BlazorOutlookCalendar?style=flat-square&cacheSeconds=604800) ![last-commit](https://img.shields.io/github/last-commit/aksoftware98/BlazorOutlookCalendar?style=flat-square&cacheSeconds=86400).
* [PlannerApp full client-side project with Blazor WebAssembly](https://www.youtube.com/playlist?list=PLFJQnCcZXWjtftgq0KID4oHk6wfJrRL1r) - March 2020 - Video tutorial that covers how to build a full client-side application using Blazor WebAssembly, The back-end is already done and hosted on Azure so we will take advantage of that to teach you how to develop full application from scratch. [Source code](https://github.com/aksoftware98/plannerapp_blazor).
* [Build an Authenticated Web App in C# with Blazor](https://morioh.com/p/97a53fe40f2e) - March, 2020 - Build an Authenticated Web App in C# with Blazor and [octa.com](https://www.okta.com) service.
* [Building an Application with Blazorade Bootstrap](https://mikaberglund.com/2020/02/17/building-an-application-with-blazorade-bootstrap-part-3/) - February 17, 2020 - Building an Application with Blazorade Bootstrap. [Part 3](https://mikaberglund.com/2020/02/17/building-an-application-with-blazorade-bootstrap-part-3/). [Part 2](https://mikaberglund.com/2020/01/08/building-an-application-with-blazor-bootstrap-part-2/). [Part 1](https://mikaberglund.com/2020/01/05/building-an-application-with-blazor-bootstrap-part-1/). [Source code](https://github.com/MikaBerglund/Blazor-Bootstrap-Demo).
* [Creating a step-by-step end-to-end database Client-Side (WebAssembly) Blazor application](http://blazorhelpwebsite.com/Blog/tabid/61/EntryId/4371/Creating-A-Step-By-Step-End-To-End-Database-Client-Side-Web-Assembly-Blazor-Application.aspx) - February 15, 2020 - This post covers how a list of Weather forecasts can be added to the database by each user. A user will only have the ability to see their own forecasts.
* [Getting started with Blorc.PatternFly](https://medium.com/patternfly/getting-started-with-blorc-patternfly-tutorial-cc71fed4bef6) - January 7, 2020 - Getting started with Blorc.PatternFly. What is Blorc.PatternFly? Standing for Blazor, Orc, and PatternFly, Blorc.PatternFly is a library with the ultimate goal of wrapping all PatternFly components and making them available as Blazor components. [Source code](https://github.com/alexfdezsauco/Blorc.PatternFly.QuickStart).

## Libraries & Extensions
* [NodaTimePicker](https://github.com/nheath99/NodaTimePicker) - ![GitHub stars](https://img.shields.io/github/stars/nheath99/NodaTimePicker?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/nheath99/NodaTimePicker?style=flat-square&cacheSeconds=86400) A Date/Time picker component library for Blazor using NodaTime. [Demo](https://nodatimepicker.z13.web.core.windows.net/).
* [Blazor Time](https://github.com/dustout/BlazorTime) - ![stars](https://img.shields.io/github/stars/dustout/BlazorTime?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/dustout/BlazorTime?style=flat-square&cacheSeconds=86400) Display dates and times in the users local time. [Demo](https://helpimstuckinatimeloop.com/time).
* [Blazor.FlexGrid](https://github.com/Mewriick/Blazor.FlexGrid) - ![stars](https://img.shields.io/github/stars/Mewriick/Blazor.FlexGrid?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/Mewriick/Blazor.FlexGrid?style=flat-square&cacheSeconds=86400) GridView component for Blazor.
* [Sve-Blazor-DataTable](https://github.com/SveNord/Sve-Blazor-DataTable) - ![stars](https://img.shields.io/github/stars/SveNord/Sve-Blazor-DataTable?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/SveNord/Sve-Blazor-DataTable?style=flat-square&cacheSeconds=86400) Blazor DataTable component with support for client/server side paging, filtering and sorting, build on top of bootstrap 4.
* [Table.Net](https://github.com/pablofrommars/TableNet) - ![last commit](https://img.shields.io/github/last-commit/pablofrommars/TableNet?style=flat-square&cacheSeconds=86400) Interactive and flexible Data Tables for Blazor Web Apps.
* [BlazorCss](https://github.com/tomlm/BlazorCss) - ![last commit](https://img.shields.io/github/last-commit/tomlm/BlazorCss?style=flat-square&cacheSeconds=86400) CSS Helper for BlazorStyled which provides auto complete CSS styles.
* [BlazorCssGrid](https://github.com/tomlm/BlazorCssGrid) - ![last commit](https://img.shields.io/github/last-commit/tomlm/BlazorCssGrid?style=flat-square&cacheSeconds=86400) Css Helper for defining Grid SPA layouts in BlazorStyled.
* [BlazorStyled](https://github.com/chanan/BlazorStyled) - ![stars](https://img.shields.io/github/stars/chanan/BlazorStyled?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/chanan/BlazorStyled?style=flat-square&cacheSeconds=86400) CSS in Blazor Components ([Demo](https://chanan.github.io/BlazorStyled)).
* [Blazor-Sparkline](https://github.com/Misfits-Rebels-Outcasts/Blazor-Sparkline) - ![last commit](https://img.shields.io/github/last-commit/Misfits-Rebels-Outcasts/Blazor-Sparkline?style=flat-square&cacheSeconds=86400) Sparkline Charts for Blazor using Fonts.
* [Blazor-Charts](https://github.com/Misfits-Rebels-Outcasts/Blazor-Charts) - ![GitHub stars](https://img.shields.io/github/stars/Misfits-Rebels-Outcasts/Blazor-Charts?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/Misfits-Rebels-Outcasts/Blazor-Charts?style=flat-square&cacheSeconds=86400) SVG charts for Blazor.
* [BlazorDependencies](https://github.com/redradist/BlazorDependencies) - ![last commit](https://img.shields.io/github/last-commit/redradist/BlazorDependencies?style=flat-square&cacheSeconds=86400) Js library that helps maintain dependencies of one Razor Class Library to another one without manually adding scripts and css-styles for each library.
* [BlazorWebFormsComponents](https://github.com/FritzAndFriends/BlazorWebFormsComponents) - ![stars](https://img.shields.io/github/stars/FritzAndFriends/BlazorWebFormsComponents?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/FritzAndFriends/BlazorWebFormsComponents?style=flat-square&cacheSeconds=86400) A collection of Blazor components that emulate the web forms components of the same name.
* [Skclusive.Material.Components](https://github.com/skclusive/Skclusive.Material.Component) - ![GitHub stars](https://img.shields.io/github/stars/skclusive/Skclusive.Material.Component?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/skclusive/Skclusive.Material.Component?style=flat-square&cacheSeconds=86400) Material Design components for Blazor ([Dashboard Demo](https://skclusive.github.io/Skclusive.Blazor.Samples/Dashboard/)),  ([Components](https://skclusive.github.io/Skclusive.Material.Docs/)).
* [Blazor.Ionic](https://github.com/kukks/Blazor.Ionic) - ![GitHub stars](https://img.shields.io/github/stars/kukks/Blazor.Ionic?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/kukks/Blazor.Ionic?style=flat-square&cacheSeconds=86400) Ionic framework integration for Blazor.
* [BlazorComponents](https://github.com/muqeet-khan/BlazorComponents) - ![GitHub stars](https://img.shields.io/github/stars/muqeet-khan/BlazorComponents?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/muqeet-khan/BlazorComponents?style=flat-square&cacheSeconds=86400) Reusable components for Blazor. Starting with ChartJS interop.
* [BlazorGrid](https://github.com/AnkitSharma-007/BlazorGrid) - ![GitHub stars](https://img.shields.io/github/stars/AnkitSharma-007/BlazorGrid?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/AnkitSharma-007/BlazorGrid?style=flat-square&cacheSeconds=86400) This is a reusable grid component for Blazor which also supports client side pagination.
* [BlazorBits](https://github.com/BlazorBits/BlazorBits) - ![GitHub stars](https://img.shields.io/github/stars/BlazorBits/BlazorBits?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/BlazorBits/BlazorBits?style=flat-square&cacheSeconds=86400) Components including [Monaco editor](https://github.com/Microsoft/monaco-editor) ![GitHub stars](https://img.shields.io/github/stars/Microsoft/monaco-editor?style=flat-square&cacheSeconds=604800).
* [BlazorVirtualScrolling](https://github.com/SamProf/BlazorVirtualScrolling) - ![stars](https://img.shields.io/github/stars/SamProf/BlazorVirtualScrolling?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/SamProf/BlazorVirtualScrolling?style=flat-square&cacheSeconds=86400) Virtual Scrolling Component for Blazor
 ([Demo](https://samprof.github.io/BlazorVirtualScrolling/)).
 * [BlazorVirtualGrid](https://github.com/Lupusa87/BlazorVirtualGrid) - ![GitHub stars](https://img.shields.io/github/stars/Lupusa87/BlazorVirtualGrid?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/Lupusa87/BlazorVirtualGrid?style=flat-square&cacheSeconds=86400) Reusable, fully configurable component with rows and columns fast virtualization ([Demo](https://lupblazorvirtualgrid.z13.web.core.windows.net/)).
* [Blazor Time Zone Kit](https://github.com/jsakamoto/Toolbelt.Blazor.TimeZoneKit) - ![GitHub stars](https://img.shields.io/github/stars/jsakamoto/Toolbelt.Blazor.TimeZoneKit?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/jsakamoto/Toolbelt.Blazor.TimeZoneKit?style=flat-square&cacheSeconds=86400) A library to provide system time zones and local time zone initialization in Blazor apps.
* [BlazorConfirm](https://github.com/ctrl-alt-d/BlazorConfirm) - ![last commit](https://img.shields.io/github/last-commit/ctrl-alt-d/BlazorConfirm?style=flat-square&cacheSeconds=86400) A Blazor Wrapper for JS's `Window.confirm()` and `onbeforeunload` as .Net Blazor Component ([Demo](https://ctrl-alt-d.github.io/BlazorConfirm/)).
* [BlazorScrollbar](https://github.com/Lupusa87/BlazorScrollbar) - ![last commit](https://img.shields.io/github/last-commit/Lupusa87/BlazorScrollbar?style=flat-square&cacheSeconds=86400) Reusable, fully configurable component with vertical and horizontal scrollbars ([Demo](https://lupblazorscrollbar.z20.web.core.windows.net/)).
* [BlazorSplitter](https://github.com/Lupusa87/BlazorSplitter) - ![last commit](https://img.shields.io/github/last-commit/Lupusa87/BlazorSplitter?style=flat-square&cacheSeconds=86400) Reusable, fully configurable component with vertical and horizontal splitters and diagonal resizer ([Demo](https://lupblazorsplitter.z20.web.core.windows.net/)).
* [Rudder](https://github.com/kjeske/rudder) - ![last commit](https://img.shields.io/github/last-commit/kjeske/rudder?style=flat-square&cacheSeconds=86400) Efficient state container for Blazor with concepts similar to the ones in redux, including reducers and sagas.
* [Sotsera.Blazor.Toaster](https://github.com/sotsera/sotsera.blazor.toaster) - ![GitHub stars](https://img.shields.io/github/stars/sotsera/sotsera.blazor.toaster?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/sotsera/sotsera.blazor.toaster?style=flat-square&cacheSeconds=86400) A Blazor port of Toastr.js. [Demo](https://blazor-toaster.sotsera.com/).
* [Blazor.SpinKit](https://github.com/faso/Faso.Blazor.SpinKit) - ![last commit](https://img.shields.io/github/last-commit/faso/Faso.Blazor.SpinKit?style=flat-square&cacheSeconds=86400) Blazor components for [SpinKit](https://tobiasahlin.com/spinkit/) spinners.
* [Localized Data Annotations Validator](https://github.com/jsakamoto/Toolbelt.Blazor.LocalizedDataAnnotationsValidator/) - ![last commit](https://img.shields.io/github/last-commit/jsakamoto/Toolbelt.Blazor.LocalizedDataAnnotationsValidator?style=flat-square&cacheSeconds=86400) The data annotations validator for Blazor to localize validation error messages. ([Demo](https://demo-blazor-localized-data-annotations-validator.azurewebsites.net/)).
* [LiquidTechnologies.Blazor.ModalDialog](https://github.com/LiquidTechnologies/blazor-modal-dialog) - ![last commit](https://img.shields.io/github/last-commit/LiquidTechnologies/blazor-modal-dialog?style=flat-square&cacheSeconds=86400) Turns Blazor components into Modal Dialogs, allows values to be returned from the dialogs (var result = await ShowDialogAsync(...)), includes simple MessageBox and data capture dialogs (for Blazor Client & Server).
* [BlazorContentEditable](https://github.com/austineric/BlazorContentEditable) - ![last commit](https://img.shields.io/github/last-commit/austineric/blazorcontenteditable?style=flat-square&cacheSeconds=86400) Provides contenteditable functionality for Blazor. ([Demo](https://austineric.github.io/BlazorContentEditable/)).
* [Blazor-Redux](https://github.com/torhovland/blazor-redux) - ![GitHub stars](https://img.shields.io/github/stars/torhovland/blazor-redux?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/torhovland/blazor-redux?style=flat-square&cacheSeconds=86400) Connecting a Redux state store with Blazor.
* [Flexor](https://github.com/DerekChasse/Flexor) - ![last commit](https://img.shields.io/github/last-commit/DerekChasse/Flexor?style=flat-square&cacheSeconds=86400) Highly configurable components which let you take full advantage of Flexbox CSS.([Demo](http://flexor.azurewebsites.net/)).
* [BlazorStorage](https://github.com/cloudcrate/BlazorStorage) - ![GitHub stars](https://img.shields.io/github/stars/cloudcrate/BlazorStorage?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/cloudcrate/BlazorStorage?style=flat-square&cacheSeconds=86400) Local and session storage support for Blazor.
* [Blazor.Auth0](https://github.com/Pegazux/Blazor.Auth0) - ![stars](https://img.shields.io/github/stars/Pegazux/Blazor.Auth0?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/Pegazux/Blazor.Auth0?style=flat-square&cacheSeconds=86400) The library for using [Auth0](https://auth0.com/) in Blazor applications.
* [Blazor.Geolocation](https://github.com/AspNetMonsters/Blazor.Geolocation) - ![stars](https://img.shields.io/github/stars/AspNetMonsters/Blazor.Geolocation?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/AspNetMonsters/Blazor.Geolocation?style=flat-square&cacheSeconds=86400) Blazor interop for browser Geolocation APIs.
* [BlazorSignalR](https://github.com/csnewman/BlazorSignalR) - ![GitHub stars](https://img.shields.io/github/stars/csnewman/BlazorSignalR?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/csnewman/BlazorSignalR?style=flat-square&cacheSeconds=86400) SignalR Core .NET client library for Blazor. It uses the C# client.
* [Blazored.Localisation](https://github.com/Blazored/Localisation) - ![stars](https://img.shields.io/github/stars/Blazored/Localisation?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/Blazored/Localisation?style=flat-square&cacheSeconds=86400) A library to provide localisation in client-side Blazor applications.
* [EmbeddedBlazorContent](https://github.com/SamProf/EmbeddedBlazorContent) - ![GitHub stars](https://img.shields.io/github/stars/SamProf/EmbeddedBlazorContent?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/SamProf/EmbeddedBlazorContent?style=flat-square&cacheSeconds=86400) Library to load embedded content files (js and css) from Blazor libraries in server-side Blazor mode.
* [Blazor.Payments](https://github.com/philipblaquiere/Blazor.Payments) - ![stars](https://img.shields.io/github/stars/philipblaquiere/Blazor.Payments?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/philipblaquiere/Blazor.Payments?style=flat-square&cacheSeconds=86400) Blazor Web Agent port of the Web Payment API standard developed by W3C.
* [BlazorLeaflet](https://github.com/Mehigh17/BlazorLeaflet) - ![last commit](https://img.shields.io/github/last-commit/Mehigh17/BlazorLeaflet?style=flat-square&cacheSeconds=86400) BlazorLeaflet is a wrapper offering easy-to-use Blazor components that expose the Leaflet API in C#.
* [PkcsExtensions.Blazor](https://github.com/harrison314/PkcsExtensions.Blazor) - ![last commit](https://img.shields.io/github/last-commit/harrison314/PkcsExtensions.Blazor?style=flat-square&cacheSeconds=86400) A library to provide crypto and digital signature functionality for Blazor WebAssembly and light WebCrypto interop.
* [BlazorMobile](https://github.com/Daddoon/BlazorMobile) - ![GitHub stars](https://img.shields.io/github/stars/Daddoon/BlazorMobile?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/Daddoon/BlazorMobile?style=flat-square&cacheSeconds=86400) Launch Blazor as a mobile application on iOS, Android & UWP.
* [NObservable](https://github.com/kekekeks/NObservable) - ![GitHub stars](https://img.shields.io/github/stars/kekekeks/NObservable?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/kekekeks/NObservable?style=flat-square&cacheSeconds=86400) MobX-like observables and component instrumentation.
* [Blazor-Dashboard](https://github.com/Misfits-Rebels-Outcasts/Blazor-Dashboard) - ![stars](https://img.shields.io/github/stars/Misfits-Rebels-Outcasts/Blazor-Dashboard?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/Misfits-Rebels-Outcasts/Blazor-Dashboard?style=flat-square&cacheSeconds=86400) Admin Dashboard Template Theme for Blazor.
* [BlazorEmbedLibrary](https://github.com/SQL-MisterMagoo/BlazorEmbedLibrary) - ![GitHub stars](https://img.shields.io/github/stars/SQL-MisterMagoo/BlazorEmbedLibrary?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/SQL-MisterMagoo/BlazorEmbedLibrary?style=flat-square&cacheSeconds=86400) Provides Blazor-style embedded static content files for Razor Components projects.
* [BlazorLazyLoad](https://github.com/MarekPokornyOva/BlazorLazyLoad) - ![stars](https://img.shields.io/github/stars/MarekPokornyOva/BlazorLazyLoad?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/MarekPokornyOva/BlazorLazyLoad?style=flat-square&cacheSeconds=86400) BlazorLazyLoad is a implementation of assembly lazy load feature in Blazor WASM application on both page and component level.
* [BrowserInterop](https://github.com/RemiBou/BrowserInterop) - ![GitHub stars](https://img.shields.io/github/stars/RemiBou/BrowserInterop?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/RemiBou/BrowserInterop?style=flat-square&cacheSeconds=86400) This library provides access to browser API in a Blazor App.
* [Sve-Blazor-InfiniteScroll](https://github.com/SveNord/Sve-Blazor-InfiniteScroll) - ![last commit](https://img.shields.io/github/last-commit/SveNord/Sve-Blazor-InfiniteScroll?style=flat-square&cacheSeconds=86400) Simplistic implementation of an infinite scroll component for Blazor.

## Videos
* [Blazor Train: Synchronicity 5.0](https://www.youtube.com/watch?v=fHzIWOfmqzg&feature=youtu.be) - December 18, 2020 - Carl Franklin shows how to develop both a Blazor Server and Blazor Wasm project simultaneously using .NET 5.
* [Blazor vs React/Angular](https://www.youtube.com/watch?v=__F3tgqZqsM) - ![duration](https://img.shields.io/badge/Duration:%20-62%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) December 11, 2020 - Debate about Blazor vs React/Angular, featuring Michael Washington on [The Growth Mindset Show](https://www.c-sharpcorner.com/events/growth-mindset-weekly-live-show3).
* [ASP.NET Community Standup - Material Design in Blazor with Material.Blazor](https://www.youtube.com/watch?v=yzLDvQ-bOw8&list=PLdo4fOcmZ0oX-DBuRG4u58ZTAJgBAeQ-t&index=2) - ![duration](https://img.shields.io/badge/Duration:%20-85%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) December 8, 2020 - We sit with Simon Ziegler and Mark Stega of Material.Blazor to discuss the project, Material.Blazor, a Material design component library for Blazor. [ASP.NET Community Standup](https://dotnet.microsoft.com/live/community-standup). [Url list](https://www.theurlist.com/community-links-december-8).
* [Blazor Train: Using SignalR for cross-user Communication](https://www.youtube.com/watch?v=QfUG-321K4s&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-17%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) December 4, 2020 - Carl Franklin shows you how to seamlessly add SignalR to any Blazor app.
* [Developing interactive websites with C# using Blazor with Jimmy Engstrom](https://www.youtube.com/watch?v=YvvKXRedVs0) - ![duration](https://img.shields.io/badge/Duration:%20-78%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 26, 2020 - Creating an interactive website today takes a lot of effort. You need to know a bunch of frameworks, languages and tools like Angular, React, JavaScript, Web pack, NPM, Bower, the list is long. What if there is a way to develop interactive websites without having to learn all these things? What if there is a way to develop in only one language, in C#? What if there is a way to do all that without using any Web Browser plugin? In this session Jimmy will show you what he believes to be the future of web development, Blazor. He will show how to get started and also share some of the new things in .NET5 so there be will be something for everybody. Also available on [Twitch](https://www.twitch.tv/videos/816560574).
* [How to Create RDLC Report in Blazor](https://www.youtube.com/watch?v=JSauWc5rauA) - ![duration](https://img.shields.io/badge/Duration:%20-23%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 24, 2020 - This video is about how to Create RDLC Report in Blazor Server application, how to use RDLC (.rdlc) report in Blazor.
* [Blazor Train: Adding Azure AD B2C to an existing app](https://www.youtube.com/watch?v=73qnhE9pW0E&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-48%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 20, 2020 - Carl Franklin welcomes back Joel Hulen to demystify Azure AD B2C.
* [Blazor: .NET 5 JavaScript interop modules revisited](https://www.twitch.tv/videos/809561739) - ![duration](https://img.shields.io/badge/Duration:%20-151%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=twitch) November 20, 2020 - Blazor: .NET 5 JavaScript interop modules revisited, by Ed Charbeneau. 
* [ASP.NET Community Standup - Unit Testing Blazor with bUnit](https://www.youtube.com/watch?v=LjGCPaP8DH8&list=PLdo4fOcmZ0oX-DBuRG4u58ZTAJgBAeQ-t&index=2) - ![duration](https://img.shields.io/badge/Duration:%20-66%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 17, 2020 - On this month's Blazor Community Spotlight, we'll be talking to Egil Hansen about unit testing Blazor components with bUnit.
* [Migrating a Windows Forms App to Blazor: The Amazing and True Story of GIFBot](https://www.youtube.com/watch?v=NRDdu67VJH0) - ![duration](https://img.shields.io/badge/Duration:%20-30%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 13, 2020 - In this talk, I will discuss the migration steps undertaken to go from a complex Desktop application to a robust ASP.NET-backed website with a Blazor front-end. The talk will highlight the ease at which I was able to translate functionality as a developer with very outdated web development skills.
* [Blazor Train: Basic Authentication and Authorization in Blazor Web Assembly](https://www.youtube.com/watch?v=I3A1R-oBK7c&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-16%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 13, 2020 - Carl shows you how to use ASP.NET Core Identity for basic authentication and authorization in a Blazor WebAssembly app.
* [Blazor Stability Testing Tools for Bullet Proof Applications](https://www.youtube.com/watch?v=WdB723tIWg0) - ![duration](https://img.shields.io/badge/Duration:%20-30%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 13, 2020 - .NET in the browser may sound like Blazor's strength, however the story of Blazor testing may just be its biggest potential upside. In this session we'll discuss what makes Blazor an ideal candidate for: Unit Testing, Integration Testing, and Automated System Testing. With Jon Galloway.
* [Building Real-time Applications with Blazor and GraphQL](https://www.youtube.com/watch?v=CrY8CF1gysA) - ![duration](https://img.shields.io/badge/Duration:%20-28%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 12, 2020 - Come see how Blazor and GraphQL combined will revolutionize how we build rich SPA applications with .NET. [.NET Conf 2020](https://www.dotnetconf.net/), Day #3.
* [Application State in Blazor Apps](https://www.youtube.com/watch?v=GIupo55GTro) - ![duration](https://img.shields.io/badge/Duration:%20-30%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 12, 2020 - Carl shows you the benefits of keeping application data outside components and pages, how to do cross-component change notifications, and how to persist that AppState to localstorage. [.NET Conf 2020](https://www.dotnetconf.net/), Day #3.
* [From Web Forms to Blazor - Introducing the Blazor Web Forms Components](https://www.youtube.com/watch?v=ceGzm-pBhx4) - ![duration](https://img.shields.io/badge/Duration:%20-29%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 12, 2020 - There are millions of ASP.NET Web Forms applications out there. How do you migrate them to .NET Core? With Blazor of course! In this talk, learn about the easy steps you can take to successfully migrate your application to Blazor with the BlazorWebFormComponents. [.NET Conf 2020](https://www.dotnetconf.net/), Day #3.
* [Components in Blazor](https://www.youtube.com/watch?v=bNrym4PqhgM) - ![duration](https://img.shields.io/badge/Duration:%20-29%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 12, 2020 - Blazor is the blazing word in the Microsoft Tech stack at the moment because you can run C# on the client. In this session, I will talk about what Razor components are, talk about their lifecycle, event handling, and how to pass information between Blazor Components. [.NET Conf 2020](https://www.dotnetconf.net/), Day #3.
* [Trailblazor: Building Dynamic Applications with Blazor](https://www.youtube.com/watch?v=gnYIqYNW54I) - ![duration](https://img.shields.io/badge/Duration:%20-31%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 12, 2020 - Underpinning Blazor's ability to create interactive web UIs using C# instead of JavaScript is a robust component model which offers exciting new opportunities for developers to create dynamic web applications. In this session we will explore a modular application framework for Blazor called Oqtane. [.NET Conf 2020](https://www.dotnetconf.net/), Day #3.
* [Microfrontends with Blazor: Welcome to the Party!](https://www.youtube.com/watch?v=npff2NjVXEE) - ![duration](https://img.shields.io/badge/Duration:%20-31%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 12, 2020 - In this talk, microfrontends expert Florian Rappl introduces an established architecture for a creating modular frontend applications. He will show how this architecture can be implemented together with Blazor to create dynamic user experiences. [.NET Conf 2020](https://www.dotnetconf.net/), Day #3.
* [Getting Started With Blazor](https://www.youtube.com/watch?v=TH0661ai_Mg) - ![duration](https://img.shields.io/badge/Duration:%20-31%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 12, 2020 - In this session, we will introduce the core concepts for Blazor development, both client and server side. Then we will dive in to a Blazor Web Assembly example and look at how we can build rich client side apps in C#. [.NET Conf 2020](https://www.dotnetconf.net/), Day #3.
* [Blazor: Client Side vs. Server Side: Hands on Development and Deployment](https://www.youtube.com/watch?v=-FDQX1jmj64) - ![duration](https://img.shields.io/badge/Duration:%20-30%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 11, 2020 - We will look at the main differences between Client Side Blazor, and Server Side Blazor. We will discuss situations and scenarios in which one should be favored over the other. We will develop a small app & deploy it twice on Azure: As a Client Side Blazor App, and as a Server Side Blazor App. [.NET Conf 2020](https://www.dotnetconf.net/), Day #2.
* [Migrating a Windows Forms App to Blazor: The Amazing and True Story of GIFBot](https://www.youtube.com/watch?v=NRDdu67VJH0) - ![duration](https://img.shields.io/badge/Duration:%20-30%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 11, 2020 - In this talk, I will discuss the migration steps undertaken to go from a complex Desktop application to a robust ASP.NET-backed website with a Blazor front-end. The talk will highlight the ease at which I was able to translate functionality as a developer with very outdated web development skills. [.NET Conf 2020](https://www.dotnetconf.net/), Day #2.
* [Modern Web Development with Blazor & .NET 5](https://www.youtube.com/watch?v=CEjqhTGrqDY) - ![duration](https://img.shields.io/badge/Duration:%20-29%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 10, 2020 - Blazor isn't just for new apps! Blazor in .NET 5 is integrated seamlessly with ASP.NET Core to enable modern full stack web development with .NET. In this session we'll show you how you can use Blazor and ASP.NET Core together to add rich client-side interactivity to both new and existing apps. You'll learn how to use Blazor components from your existing MVC views and Razor Pages, handle server-side prerendering, setup authentication & authorization, improve load time performance, and then deploy your app into production. [.NET Conf 2020](https://www.dotnetconf.net/), Day #1.
* [A talk for trailblazers: Blazor in .NET 5](https://www.youtube.com/watch?v=Nag6u5TxjIA) - ![duration](https://img.shields.io/badge/Duration:%20-30%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 10, 2020 - Wondering what's in store for Blazor in .NET 5? Wonder no more! This talk features the latest and greatest features to arrive in Blazor as part of .NET 5. From improved APIs for working with the browser to CSS isolation to a variety of performance improvements, you'll leave this presentation with rundown of everything you'll be able to do in the latest version of Blazor. [.NET Conf 2020](https://www.dotnetconf.net/), Day #1.
* [.NET Conf 2020: Day 1, full video](https://www.youtube.com/watch?v=mS6ykjdOVRg) - ![duration](https://img.shields.io/badge/Duration:%20-695%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 10, 2020 - Full video of the first day of the [.NET Conf 2020](https://www.dotnetconf.net).
* [Blazor Reporting with Thomas Smith](https://www.youtube.com/watch?v=cUAmYn16A18&list=PL8h4jt35t1wjvwFnvcB2LlYL4jLRzRmoz&index=65) - ![duration](https://img.shields.io/badge/Duration:%20-22%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 9, 2020 - Carl welcomes Blazor Train fan Thomas Smith  to show how he implemented reports in a real-world Blazor app. Carl Franklin's Blazor Train Ep 63.
* [Blazor + Xamarin == WHOA!](https://www.youtube.com/watch?v=Y0bEAy6yxMQ&list=PLdo4fOcmZ0oX-DBuRG4u58ZTAJgBAeQ-t&index=3) - ![duration](https://img.shields.io/badge/Duration:%20-70%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 5, 2020 - Xamarin Community Standup - Blazor + Xamarin == WHOA! with Eilon Lipton. Join the Xamarin Team as they discuss the latest and greatest for Xamarin. This week we sit down with Eilon Lipton to discuss the latest in the Mobile Blazor Bindings.
* [Blazor Train: Basic Authentication and Authorization](https://www.youtube.com/watch?v=mbNFscKBsy8&feature=youtu.be) - November 02, 2020 - Carl shows you how to use ASP.NET Core Identity for basic authentication and authorization using a SQL Server.
* [.NET 5 Migrating NuGet Packages](https://www.twitch.tv/videos/786558484) - ![duration](https://img.shields.io/badge/Duration:%20-116%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=twitch) October 31, 2020 - .NET 5 Migrating NuGet Packages, by Ed Charbeneau.
* [Blazor & Comet for Native Mobile Apps](https://www.youtube.com/watch?v=lzVZSKcC-oY&list=PLdo4fOcmZ0oWiLr2zVqfdsJjttPsBi-q4&index=1) - ![duration](https://img.shields.io/badge/Duration:%20-65%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) October 26, 2020 - Sam Basu from Telerik joins the panel to show us how to use Blazor and Comet in native mobile apps.
* [Run EF Core queries on SQL Server from Blazor WebAssembly](https://www.youtube.com/watch?v=GE8_E8-KxBY) - ![duration](https://img.shields.io/badge/Duration:%20-82%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) October 26, 2020 - Session of the Atlanta .Net User Group by Jeremy Likness, "Run Entity Framework Core queries on SQL Server from Blazor WebAssembly".
* [Blazor Train: MVVM Part 2](https://www.youtube.com/watch?v=PUm9P_pJZV0&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-23%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) October 26, 2020 - Carl shows more advanced MVVM patterns in Blazor.
* [ASP.NET Core Series: PWA's with Blazor](https://channel9.msdn.com/Shows/On-NET/ASPNET-Core-Series-PWAs-with-Blazor) - ![duration](https://img.shields.io/badge/Duration:%20-29%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=microsoft) October 15, 2020 - Progressive Web Applications (PWA) use modern browser APIs and capabilities to behave like a desktop app. Since Blazor WebAssembly is a standards-based client-side web app platform,  developers have the ability to leverage these browser APIs and create PWAs using .NET. In this episode, Jeremy is joined by Dan Roth to discuss the built in support for building PWAs with Blazor and show us a few demos of how get started.
* [On .NET Live - Diving into Azure Static Web Apps](https://www.youtube.com/watch?v=bVSq1rKcW-o) - ![duration](https://img.shields.io/badge/Duration:%20-60%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) October 15, 2020 - Azure Static Web Apps allows you to develop modern web applications that automatically publish from changes made in GitHub. You can build your frontends in your framework of choice and back them powerful APIs based on Azure Functions. In this session, Anthony Chu joins us to talk about this new service and what it means for .NET Developers building Blazor applications.
* [Blazor WebAssembly : Twitter Authentication/Login](https://www.youtube.com/watch?v=TZSwbey58CM&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-16%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) October 12, 2020 - Blazor WebAssembly : Twitter Authentication/Login, by Curious Drive.
* [Setup Your Blazor Wasm and ASP.NET Core Web API in Azure Devops: Dev To Azure - Part 1](https://www.youtube.com/watch?v=YLEa2Pr79Ho) - ![duration](https://img.shields.io/badge/Duration:%20-6%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) October 12, 2020 - Setup Your Blazor Wasm and ASP.NET Core Web API in Azure Devops: Dev To Azure - Part 1. [Article](https://www.roundthecode.com/dotnet/setup-your-blazor-wasm-and-asp-net-core-web-api-in-azure-devops).
* [Blazor Train: Daniel Roth on .NET 5 Blazor](https://www.youtube.com/watch?v=Yp1WmfjadMw&feature=youtu.be) - October 9, 2020 - Carl welcomes back Daniel Roth to demo what's new in .NET 5 Blazor.
* [Blazor: Our first impressions with Andrew Lock](https://www.youtube.com/watch?v=tCXYUcW-VBo) - October 9, 2020 - Blazor: Our first impressions with Andrew Lock, by Loosely Coupled Show. Are you on the Blazor train? Some of us are hesitant with scars from the past, even though they might not be warranted.
* [Telerik Reporting and Testing R3 2020 Release](https://www.youtube.com/watch?v=QcPq9xQFJio&feature=youtu.be) -  ![duration](https://img.shields.io/badge/Duration:%20-121%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) October 5, 2020 - Tech Is Evolving, and so Are Telerik & Kendo UI with R3 2020: Telerik Reporting & Test Studio Dev Edition Fully Integrate with All Suites, including Blazor.
* [Blazor Train: Adding Blazor to an Existing MVC Application](https://www.youtube.com/watch?v=rfPQytn7tfk&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-11%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) October 2, 2020 - Carl welcomes Brian MacKay who shows you how to add Blazor pages and components to an existing MVC app.
* [Blazor WebAssembly : Authentication State](https://www.youtube.com/watch?v=N8YoJRV19rw&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-10%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) September 26, 2020 - Blazor WebAssembly : Authentication State, by Curious Drive. [Source code](https://github.com/CuriousDrive/BlazingChat) ![stars](https://img.shields.io/github/stars/CuriousDrive/BlazingChat?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/CuriousDrive/BlazingChat?style=flat-square&cacheSeconds=86400).
* [Blazor Train: WebForms to Blazor with Jeff Fritz](https://www.youtube.com/watch?v=yzK-TqxLjbA&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-34%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) September 11, 2020 - Carl welcomes Microsoft’s Jeff Fritz to give hope to WebForms developers who want to move to Blazor.
* [Blazor WebAssembly : Custom Authentication](https://www.youtube.com/watch?v=B9jKf-Dn0Yg&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-32%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) September 3, 2020 - Blazor WebAssembly : Custom Authentication, by Curious Drive.
* [iJS London: Blazor WebAssembly](https://www.youtube.com/watch?v=mFBqThJQa0o&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-41%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) September 2, 2020 - Blazor WebAssembly by Rainer Stropek at the [International JavaScript Conference](https://javascript-conference.com/). This is an introduction to Blazor WebAssembly. Here the source code of the [Starship traveler demo](https://github.com/rstropek/StarshipTraveler) mentionned in the talk ![stars](https://img.shields.io/github/stars/rstropek/StarshipTraveler?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/rstropek/StarshipTraveler?style=flat-square&cacheSeconds=86400).
* [Rendering an Orchard Core Markdown Blog Post with Blazor WebAssembly](https://www.youtube.com/watch?v=G6CkEBNPhro&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-9%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) August 30, 2020 - Rendering an Orchard Core Markdown Blog Post with Blazor WebAssembly.
* [Write OnClick Events in C# using Blazor and Eliminate JavaScript](https://www.youtube.com/watch?v=vdvIz5QxFFU) - ![duration](https://img.shields.io/badge/Duration:%20-14%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) August 25, 2020 - JavaScript can be eliminated for implementing an OnClick event and many other HTML event attributes. With Blazor, we go ahead and write an OnClick event in C# without the need for JavaScript.
* [Blazor Train: Data Access](https://www.youtube.com/watch?v=VaX73p3JfV4&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-33%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) August 24, 2020 - Carl brings together an API layer, a generic data manager, and EF Core to create a complete solution.
* [The .NET Docs Show - .NET open-source projects](https://www.youtube.com/watch?v=12XAjpuwByo) - ![duration](https://img.shields.io/badge/Duration:%20-65%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) August 24, 2020 - Chat with Isaac Levin (@isaacrlevin) about some exciting .NET open source projects he's been working on. By [The .NET Docs show](https://dotnetdocs.dev/). Article on [Dev.to](https://dev.to/dotnet/the-net-docs-show-open-source-net-projects-2h39) about this episode.
* [Blazor Game Client + Working on GUI System](https://www.twitch.tv/videos/717583951) - ![duration](https://img.shields.io/badge/Duration:%20-205%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=twitch) August 23, 2020 - Blazor Game Client + Working on GUI System.
* [How to Create Services in Client Side Apps](https://www.youtube.com/watch?v=I74hkInjziM&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-17%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) August 21, 2020 - We are upgrading our Blazor App Tour Of Heroes with Services! This will allow the components to keep state even when we navigate away along with creating some reusable code for our apis. If you like this video please subscribe and let me know you would like to see more. Based of Tour of Heroes section 4.
* [Let's Build Flappy Bird](https://www.youtube.com/watch?v=wTmZCu16LNU&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-35%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) August 18, 2020 - Let's Build Flappy Bird with Blazor WebAssembly. [Source code](https://github.com/blazorbuilds/Flappy-Bird) ![stars](https://img.shields.io/github/stars/blazorbuilds/Flappy-Bird?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/blazorbuilds/Flappy-Bird?style=flat-square&cacheSeconds=86400).
* [Blazor WebAssembly, Azure AD B2C and Azure SDKs with Jon Gallant](https://www.youtube.com/watch?v=Yj4DJINTwjs) - ![duration](https://img.shields.io/badge/Duration:%20-305%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) August 11, 2020 - Blazor WebAssembly, Azure AD B2C and Azure SDKs with Jon Gallant.
* [Blazor Train: Modal Dialogs with Chris Sainty](https://www.youtube.com/watch?v=_SV2u8vp4Xo) - August 7, 2020 - Carl welcomes Chris Sainty back to BlazorTrain to show Blazored.Modal, his OSS Modal Dialog component.
* [Blazor WebAssembly : Open-source Project - EP10](https://www.youtube.com/watch?v=6T-l-lt28rs&list=PL4WEkbdagHIRjjBJvK_TSfddJSvEEAtnt&index=11&t=0s) - ![duration](https://img.shields.io/badge/Duration:%20-8%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) July 29, 2020 - Let's make the BlazingChat app Open-Source and walk through rest of MVVM code for Contacts and Settings page, by Curious Drive.
* [Blazor Train: Creating a Generic Data Manager](https://www.youtube.com/watch?v=7ve7nqk7kMI&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-16%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) July 24, 2020 - In this episode of BlazorTrain, Carl welcomes App vNext contractor Mateus de Carvalho. They show how to use the repository pattern to create two generic data managers: one for an in-memory store, and one for an Entity Framework dbContext.
* [Blazor Server with Azure AD authentication and MS Graph](https://www.youtube.com/watch?v=hOf9V5JfttM) - ![duration](https://img.shields.io/badge/Duration:%20-192%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) July 24, 2020 - For this week's stream, we decided to play with the latest hot topic in the .NET ecosystem, i.e Blazor. JP and me build a Blazor Server web app with .NET Core and then we add Azure AD authentication to enable users to login in the app with the new Microsoft.Identity.Web. In the end, we added a call to MS Graph to retrieve some messages. [video on YouTube](https://www.youtube.com/watch?v=hOf9V5JfttM). [video on Twitch](https://www.twitch.tv/425show).
* [Carl Franklin's Blazor Train: Creating an API Layer](https://www.youtube.com/watch?v=-48UHwxwv4g&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-35%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) July 20, 2020 - Carl shows you how to create APIs and access them from Blazor applications. Topics include CORS, and advanced JSON issues.
* [Visual Studio Remote Office Hours - Blazor and ASP.NET](https://www.youtube.com/watch?v=g8tAgdvxYzk&list=PLReL099Y5nRem6UA4w849hTfd0LzBIsAk&index=2&t=0s) - ![duration](https://img.shields.io/badge/Duration:%20-60%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) July 16, 2020 - Visual Studio Remote Office Hours - Blazor and ASP.NET, with Daniel Roth and Mads Kristensen. What is Blazor and what should I use it for? Dan Roth is here with answers and insights to share.
* [Common Data Services (CDS) and .NET](https://www.youtube.com/watch?v=TrLz0aEWMM8) - ![duration](https://img.shields.io/badge/Duration:%20-29%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) July 16, 2020 - From console to mobile to web apps to services, learn how to use the Common Data Service when building .NET apps. This will be a demo heavy session that include Azure Functions, using it in mobile apps written in Xamarin, and web apps written with Blazor.
* [.NET Virtual User Group - Blazor + Xamarin Code Sharing](https://www.youtube.com/watch?v=5P_rub2a4Eo) - ![duration](https://img.shields.io/badge/Duration:%20-96%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) July 15, 2020 - In this session Lachlan will be focusing on an approach to allow Models, ViewModels and Services to be shared across a Xamarin Forms App(for Android, iOS, UWP, etc.) and Blazor Web Assembly, with just a thin layer on top for user interface and platform specifics in each UI Framework.
* [Blazor & Electron.NET Managing Application Windows](https://www.youtube.com/watch?v=nFIZPV3nH0E) - ![duration](https://img.shields.io/badge/Duration:%20-11%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) July 9, 2020 - This video covers how to create a new windows and manage the window properties, retrieve windows and set the full screen mode.
* [FAST Framework](https://www.youtube.com/watch?v=sYTH_xYH3iA&list=PL1rZQsJPBU2St9-Mz1Kaa7rofciyrwWVx&index=2) - ![duration](https://img.shields.io/badge/Duration:%20-78%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) July 7, 2020 - [ASP.NET Community Standup](https://dotnet.microsoft.com/platform/community/standup): FAST Framework. Check out how to use the new FAST Web Components with .NET and Blazor. Guests: Daniel Roth, Steve Sanderson and Rob Eisenberg.
* [Blazor WebAssembly : Using HttpClient in MVVM](https://www.youtube.com/watch?v=To-GSKOac10&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-16%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) July 6, 2020 - Blazor WebAssembly : Using HttpClient in MVVM, by Curious Drive. This video is about how to use IHttpClientFactory in a Blazor WebAssembly application.
* [Blazor WebAssembly : Dependency Injection](https://www.youtube.com/watch?v=bxpSa0ZmwtY&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-14%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) July 3, 2020 - Blazor WebAssembly : Dependency Injection, by Curious Drive. 
* [Blazor Web Bluetooth ](https://www.youtube.com/watch?v=CFaijQhkAwg&t=45s)- ![duration](https://img.shields.io/badge/Duration:%20-22%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) July 1, 2020 - In this video Jimmy Engström demonstratres how to use Blazor and web bluetooth to  controls a bluetooth robot.
* [Blazor Train: Blazor Component Life Cycle](https://www.youtube.com/watch?v=dpyUcRdbAcc&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-19%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) June 26, 2020 - Blazor Train: Blazor Component Life Cycle. What is a Blazor Component? How long does it live? How can we hook it to make sure our app behaves properly? This episode of Blazor Train covers all about the component life cycle.
* [Blazing into Summer with Ed Charbeneau](https://www.twitch.tv/videos/661159908) - ![duration](https://img.shields.io/badge/Duration:%20-45%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=twitch) June 25, 2020 - Blazing into Summer with Ed Charbeneau, by [The DOT.NET Docs Show](https://dotnetdocs.dev/).
* [GameDev - Blazor with BabylonJS (Web Rendering)](https://www.twitch.tv/videos/660648746) - ![duration](https://img.shields.io/badge/Duration:%20-173%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=twitch) June 25, 2020 - Live development of a game with Blazor WebAssembly and BabylonJS.
* [ASP.NET Community Standup: Entity Framework Core in Blazor](https://www.youtube.com/watch?v=HNJYIqeBLQc&list=PL1rZQsJPBU2St9-Mz1Kaa7rofciyrwWVx&index=2) - ![duration](https://img.shields.io/badge/Duration:%20-60%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) June 24, 2020 - [ASP.NET Community Standup](https://dotnet.microsoft.com/platform/community/standup): EF Core in Blazor.
* [ASP.NET Community Standup: Blazor Mobile Bindings](https://www.youtube.com/watch?v=ibIl3mgH0LQ&list=PL1rZQsJPBU2St9-Mz1Kaa7rofciyrwWVx&index=5) - ![duration](https://img.shields.io/badge/Duration:%20-72%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) June 23, 2020 - [ASP.NET Community Standup](https://dotnet.microsoft.com/platform/community/standup): Blazor Mobile Bindings, with Eilon Lipton.
* [State of .NET Blazor with Markus Egger](https://www.youtube.com/watch?v=YoXVErXcL3U&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-95%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) June 23, 2020 - State of .NET Blazor with Markus Egger.
* [Blazor Day 2020: Building a PWA (Progressive Web App) with Blazor WebAssembly](https://www.youtube.com/watch?v=XoizucRjxgU&t=18130s) - ![duration](https://img.shields.io/badge/Duration:%20-34%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) June 18, 2020 - Building a PWA (Progressive Web App) with Blazor WebAssembly, by Vivien Fabing at [Blazor Day 2020](https://www.blazorday.net).
* [Blazor Day 2020: Getting started with Blazor and Clean Code principles](https://www.youtube.com/watch?v=XoizucRjxgU&t=16540s) - ![duration](https://img.shields.io/badge/Duration:%20-33%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) June 18, 2020 - Getting started with Blazor and Clean Code principles, by Bruno Barrette at [Blazor Day 2020](https://www.blazorday.net).
* [Blazor Day 2020: Authentication and Authorization in Blazor](https://www.youtube.com/watch?v=XoizucRjxgU&t=14700s) - ![duration](https://img.shields.io/badge/Duration:%20-30%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) June 18, 2020 - Authentication and Authorization in Blazor, by Marco De Sanctis at [Blazor Day 2020](https://www.blazorday.net).
* [Blazor Day 2020: Building Desktop Apps for Windows, Mac & Linux with Blazor & Electron](https://www.youtube.com/watch?v=XoizucRjxgU&t=12840s) - ![duration](https://img.shields.io/badge/Duration:%20-30%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) June 18, 2020 - Building Desktop Apps for Windows, Mac & Linux with Blazor & Electron, by Ahmad Mozaffar at [Blazor Day 2020](https://www.blazorday.net).
* [Blazor Day 2020: Create a cross-platform application with Blazor & BlazorMobile](https://www.youtube.com/watch?v=XoizucRjxgU&t=10879s) - ![duration](https://img.shields.io/badge/Duration:%20-33%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) June 18, 2020 - Create a cross-platform application with Blazor & BlazorMobile, by Guillaume Zahra at [Blazor Day 2020](https://www.blazorday.net).
* [Blazor Day 2020: Forms & Validation in Blazor](https://www.youtube.com/watch?v=XoizucRjxgU&t=8610s) - ![duration](https://img.shields.io/badge/Duration:%20-38%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) June 18, 2020 - Forms & Validation in Blazor, by Chris Sainty at [Blazor Day 2020](https://www.blazorday.net).
* [Blazor Day 2020: Razor: Into the Razor-Verse](https://www.youtube.com/watch?v=XoizucRjxgU&t=6873s) - ![duration](https://img.shields.io/badge/Duration:%20-29%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) June 18, 2020 - Razor: Into the Razor-Verse, by Ed Charbeneau at [Blazor Day 2020](https://www.blazorday.net).
* [Blazor Day 2020: Create An Optical Character Reader Using Blazor And Azure Computer Vision](https://www.youtube.com/watch?v=XoizucRjxgU&t=5474s) - ![duration](https://img.shields.io/badge/Duration:%20-23%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) June 18, 2020 - Create An Optical Character Reader Using Blazor And Azure Computer Vision, by Ankit Sharma at [Blazor Day 2020](https://www.blazorday.net).
* [Blazor Day 2020: Secrets of a Blazor Component Artisan](https://www.youtube.com/watch?v=XoizucRjxgU&t=3715s) - ![duration](https://img.shields.io/badge/Duration:%20-30%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) June 18, 2020 - Secrets of a Blazor Component Artisan, by Ed Charbeneau at [Blazor Day 2020](https://www.blazorday.net).
* [Blazor Day 2020: Bringing .NET to the Web and Beyond](https://www.youtube.com/watch?v=XoizucRjxgU&t=0s) - ![duration](https://img.shields.io/badge/Duration:%20-62%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) June 18, 2020 - Blazor: Bringing .NET to the Web and Beyond, by Dan Roth at [Blazor Day 2020](https://www.blazorday.net). 
* [Modern Web UI with Blazor WebAssembly](https://www.youtube.com/watch?v=kLhoRyLxwAE) - ![duration](https://img.shields.io/badge/Duration:%20-56%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) June 11, 2020 - Modern Web UI with Blazor WebAssembly by [Steve Sanderson at the NDC Oslo 2020](https://ndcoslo.com/speaker/steve-sanderson/). Client-side web development has long been the sole domain of JavaScript. WebAssembly is changing that by opening up the web to the full ecosystem of languages, frameworks, and tools. ASP.NET Blazor is all about building modern web applications be that on the server or the client. In this session I'll show you how to build beautiful and interactive client-side web UI, all with C# instead of JavaScript.
* [Blazor Chat Guided Tour](https://www.youtube.com/watch?v=e7vcmskJYqQ) - ![duration](https://img.shields.io/badge/Duration:%20-25%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) June 11, 2020 - This video demonstrates using a singleton class, shows the ValidationComponent and ProgressBar that are part of DataJuggler.Blazor.Components.
* [Blazor WebAssembly : Entity Framework Core - EP06](https://www.youtube.com/watch?v=rACHqnkaORA&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-25%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) June 10, 2020 - Blazor WebAssembly : Entity Framework Core - EP06, by Curious Drive. In this episode, he shows how you can integrate Entity Framework Core in a Blazor WebAssembly application.
* [Blazor Twitch Bot Examples for GitHub](https://www.twitch.tv/videos/645406357) - ![duration](https://img.shields.io/badge/Duration:%20-170%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=twitch) June 9, 2020 - Blazor Twitch Bot Examples for GitHub. [Source code](https://github.com/fiercekittenz/BlazorTwitchBotExample) ![stars](https://img.shields.io/github/stars/fiercekittenz/BlazorTwitchBotExample?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/fiercekittenz/BlazorTwitchBotExample?style=flat-square&cacheSeconds=86400).
* [Blazor WebAssembly : Debugging in VS Code, Chrome and Visual Studio](https://www.youtube.com/watch?v=4c2vli5567A&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-25%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) June 5, 2020 - Blazor WebAssembly : Debugging in VS Code, Chrome and Visual Studio, by Curious Drive. In this episode, he shows how you can debug your Blazor WebAssembly application using VS Code, Chrome or Visual Studio. He goes through all the files and the settings that you need to do before you debug your apps.
* [Blazor Beyond the Browser](https://www.twitch.tv/videos/640062859) - June 3, 2020 - Blazor Beyond the Browser, with Ed Charbeneau and Daniel Roth.
* [Blazor In-Depth: Full-Stack C# with Telerik UI for Blazor and Entity Framework](https://www.twitch.tv/videos/639152601) - ![duration](https://img.shields.io/badge/Duration:%20-102%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=twitch) June 2, 2020 - Blazor In-Depth: Full-Stack C# with Telerik UI for Blazor and Entity Framework.
* [Blazor: A Guided Tour with Ed Charbeneau](https://www.twitch.tv/videos/638236743) - June 1, 2020 - Blazor: A Guided Tour with Ed Charbeneau. [Part 1](https://www.twitch.tv/videos/638236743), [Part 2](https://www.twitch.tv/videos/638246011), [Part 3](https://www.twitch.tv/videos/638253970).
* [Blazor WebAssembly : Routing | NavigationManager, AdditionalAssemblies](https://www.youtube.com/watch?v=86vyb4vDGTk) - ![duration](https://img.shields.io/badge/Duration:%20-18%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=twitch) May 31, 2020 - Blazor WebAssembly : Routing | NavigationManager, AdditionalAssemblies, by Curious Drive. In this episode, he shows how navigate between pages in Blazor WebAssembly. He also talks about passing parameters across pages. In the end, he dives diving little deeper to show how you can add Razor Component assemblies to your Router navigate to pages which are into Third Party Components.
* [Blazor, Menus, the conclusion of May is for Macs with some !coffee](https://www.twitch.tv/videos/637316577) - ![duration](https://img.shields.io/badge/Duration:%20-124%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=twitch) May 31, 2020 - Blazor, Menus, the conclusion of May is for Macs with some !coffee.
* [Working with Pages and Components](https://www.twitch.tv/videos/635445401) - ![duration](https://img.shields.io/badge/Duration:%20-140%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=twitch) May 30, 2020 - Working with Pages and Components, by Ed Charbeneau.
* [Learn Studio Session: Build a WebAssembly app with Blazor & VS Code](https://www.youtube.com/watch?v=4pBcGmm6nCI) - ![duration](https://img.shields.io/badge/Duration:%20-74%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) May 27, 2020 - Join us for this guided online [Microsoft Learn workshop](https://aka.ms/Learn/Blazor). Learn how to setup your development environment and build your first WebAssembly app with Blazor, VS Code and C#. 
* [Learn Studio Session: Build a WebAssembly app with Blazor & VS Code](https://www.youtube.com/watch?v=2k74qoXTelM) - ![duration](https://img.shields.io/badge/Duration:%20-60%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) May 27, 2020 - Join us for this guided online [Microsoft Learn workshop](https://aka.ms/Learn/Blazor). Learn how to setup your development environment and build your first WebAssembly app with Blazor, VS Code and C#.
* [Modern Web UI with Blazor WebAssembly](https://www.youtube.com/watch?v=Pcyx48AgR40) - ![duration](https://img.shields.io/badge/Duration:%20-29%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) May 26, 2020 - Modern web development is here with Blazor! Be productive building beautiful interactive UI with .NET and C# that runs on any device via WebAssembly. PWAs, authentication, debugging, +more.
* [Blazor WebAssembly 3.2 Release Party!](https://www.youtube.com/watch?v=onI2_Q0wrdM&list=PL1rZQsJPBU2St9-Mz1Kaa7rofciyrwWVx&index=0) - ![duration](https://img.shields.io/badge/Duration:%20-84%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=microsoft) May 26, 2020 - ASP.NET Community Standup - Blazor WebAssembly 3.2 Release Party!
* [Blazor Train: A talk with Steve Sanderson and David Fowler](https://www.youtube.com/watch?v=4je1gmH6G7w&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-21%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) May 26, 2020 - Blazor Train, episode 5: In this episode Carl talks to the creators of Blazor, Steve Sanderson and David Fowler.
* [Blazor Train: Synchronicity - Develop Server and WASM Apps Simultaneously](https://www.youtube.com/watch?v=SkYQDPXw__c&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-17%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) May 26, 2020 - Blazor Train, episode 4: On this episode of Blazor Train I’ll show you how you can develop a Blazor WASM app AND a Blazor SERVER app -- at the same time -- from a single code base, and why you’d want to do that in the first place.
* [Blazor Train: WebAssembly](https://www.youtube.com/watch?v=zUgyq4zpgIU&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-12%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) May 26, 2020 - Blazor Train, episode 3: On this episode of Blazor Train, we’ll dive into WebAssembly. What is it? Is it secure? How does it work? What browsers support it? What languages can compile to it? Can it only run in the browser? And we’ll answer the question: Is Blazor Wasm the next Silverlight?
* [Blazor Train: Server vs WASM](https://www.youtube.com/watch?v=CUJP82uAU5Y&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-20%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) May 26, 2020 - Blazor Train, episode 2: Server vs WASM, by Carl Franklin. In this episode of Blazor Train, he compares the two hosting models: Blazor Server and Blazor WebAssembly. He creates an app using each model, and watch the network traffic in the browser. He talks about the maximum number of concurrent clients a Blazor Server app can handle, and how to scale it to meet demands. Most importantly, he weighs the pros and cons of each hosting model, so you can start thinking about which is appropriate for your next application.
* [Blazor Train: Introducing Blazor](https://www.youtube.com/watch?v=1FYhpL-JFY0&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-20%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) May 26, 2020 - Blazor Train, episode 1: Introducing Blazor, by Carl Franklin. In this episode of Blazor Train, he takes a first look at Microsoft Blazor - its history, how it evolved as a product and became part of ASP.NET Core. He looks at how the Blazor component model simplifies common tasks like binding and event handling.  He writes a simple demo to illustrate the power of Blazor and how it will make you a more productive web developer.
* [Blazor WebAssembly : Project Structure/Template](https://www.youtube.com/watch?v=S-skkhzcMmo) - ![duration](https://img.shields.io/badge/Duration:%20-16%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) May 25, 2020 - Blazor WebAssembly : Project Structure/Template, by Curious Drive. In this episode, he's going through the project structure for Blazor WebAssembly applications. Why do need we need Client, Server and Shared project when we get started. How you can run them separately? all sort of questions he have answered in this video.
* [Modern Web UI with Blazor WebAssembly](https://www.youtube.com/watch?v=My_XOzQWwc4) - ![duration](https://img.shields.io/badge/Duration:%20-45%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) May 25, 2020 - Modern web development is here with Blazor! Be productive building beautiful interactive UI with .NET and C# that runs on any device via WebAssembly. PWAs, authentication, debugging, +more.
* [Office hours, building a full stack Blazor app](https://www.twitch.tv/videos/628640130) - ![duration](https://img.shields.io/badge/Duration:%20-128%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=twitch) May 23, 2020 - Office hours, building a full stack Blazor app, by Ed Charbeneau.
* [Modern Web UI with Blazor WebAssembly](https://channel9.msdn.com/Events/Build/2020/BOD104) - ![duration](https://img.shields.io/badge/Duration:%20-45%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=microsoft) May 19, 2020 - Modern web development is here with Blazor! Be productive building beautiful interactive UI with .NET and C# that runs on any device via WebAssembly. PWAs, authentication, debugging and more. Video by Steve Sanderson from Microsoft.
* [Blazor WASM authentication](https://www.twitch.tv/videos/614895872) - ![duration](https://img.shields.io/badge/Duration:%20-99%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=twitch) May 8, 2020 - Blazor WASM authentication, by Ed Charbeneau.
* [Blazor Tutorial : Deploy to Azure App Services](https://www.youtube.com/watch?v=CFAE4_dwzAs&feature=youtu.be) - May 5, 2020 - Blazor Tutorial : Deploy to Azure App Services, by Curious Drive.
* [Blazor StateHasChanged: E-book samples, code-behind, and office hours](https://www.twitch.tv/videos/608126510) - May 1, 2020 - Blazor StateHasChanged: E-book samples, code-behind, and office hours.
* [Trains.NET - Lets pretend to be designers](https://www.twitch.tv/videos/599185198) - April 22, 2020 - Building a 2D game with .NET and C#, let's draw things with Blazor. [Trains.NET's Source code](https://github.com/davidwengier/Trains.NET).
* [Trains.NET - From SkiaSharp to HTML Canvas, and hopefully published to a website somewhere](https://www.twitch.tv/videos/592596855) - April 15, 2020 - Building a 2D game with .NET and C#, let's draw things with Blazor. [Trains.NET's Source code](https://github.com/davidwengier/Trains.NET).
* [Trains.NET - Let's draw things with Blazor](https://www.twitch.tv/videos/588019981) - April 10, 2020 - Building a 2D game with .NET and C#, let's draw things with Blazor. [Trains.NET's Source code](https://github.com/davidwengier/Trains.NET).
* [Trains.NET - Experimenting with Blazor](https://www.twitch.tv/videos/586349468) - April 8, 2020 - Building a 2D game with .NET and C#, experimenting with Blazor. [Trains.NET's Source code](https://github.com/davidwengier/Trains.NET).
* [Carl Franklin's Blazor Desk Show with Dan Roth](https://www.youtube.com/watch?v=xxIkh6GZdaM) - ![duration](https://img.shields.io/badge/Duration:%20-121%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) March 26, 2020 - Video of Carl Franklin (from .NET Rocks!) about architecture best practices, how to make and consume generic components, how to call JavaScript to enhance your apps, and how to implement authentication and authorization. This video also covers how to monitor the traffic going back and forth between the browser and the server, measure your app's memory footprint, and how to optimize it. It also introduces some exciting Blazor controls including a data grid and appointment scheduling component.
* [Quarantined Coding! with Ed Charbeneau](https://www.twitch.tv/videos/575953710) - March 26, 2020 - Ed Charbeneau about Blazor for CodeItLive.
* [Create a Blazor Server App and Add Syncfusion Blazor Components](https://www.youtube.com/watch?v=cQZYzOlTm0Q) - March 24, 2020 - Learn to create a new Blazor Server App and add Blazor Components of Syncfusion to it using Visual Studio 2019 and Visual Studio Code.
* [Minimal March - Linux and Blazor. PRs, Finishing the FormView, C#, HTML, and !coffee](https://www.twitch.tv/videos/572751843) - March 22, 2020 - Minimal March - Linux and Blazor. PRs, Finishing the FormView, C#, HTML, and !coffee, by Csharpfritz.
* [Blazor StateHasChanged: Hot take on hot questions](https://www.twitch.tv/videos/571259404) - March 20, 2020 - Blazor StateHasChanged: Hot take on hot questions, by Ed Charbeneau.
* [Minimal March - Linux and Blazor. PRs, Finishing the FormView, C#, HTML, and !coffee](https://www.twitch.tv/videos/571161098) - March 20, 2020 - Minimal March - Linux and Blazor. PRs, Finishing the FormView, C#, HTML, and !coffee, by Csharpfritz.
* [Minimal March - Linux and Blazor. PRs, Finishing the FormView, C#, HTML, and !coffee](https://www.twitch.tv/videos/570365905) - March 19, 2020 - Minimal March - Linux and Blazor. PRs, Finishing the FormView, C#, HTML, and !coffee, by Csharpfritz.
* [Minimal March - Linux and Blazor. PRs, Finishing the FormView, C#, HTML, and !coffee](https://www.twitch.tv/videos/569662576) - March 18, 2020 - Minimal March - Linux and Blazor. PRs, Finishing the FormView, C#, HTML, and !coffee, by Csharpfritz.
* [Building Chat App using Blazor WebAssembly](https://www.twitch.tv/curiousdrive/clip/BashfulSpeedyPuddingHeyGirl) - March 6, 2020 - Building Chat App using Blazor WebAssembly, day 10 by Curious Drive.
* [Blazor Tutorial : Event Handling](https://www.youtube.com/watch?v=wxU6wWTT4mQ&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-12%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) March 4, 2020 - Episode about event handling by Curious Drive.
* [Build your first Blazor app with Carl Franklin](https://www.youtube.com/watch?v=hAB4fHy6Cfo&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-71%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) March 3, 2020 - Build your first Blazor app with Carl Franklin, by DevExpress.
* [Blazor, GitHub CLI, Excel? and more](https://www.twitch.tv/videos/557921454) - ![duration](https://img.shields.io/badge/Duration:%20-106%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=twitch) February 26, 2020 - Blazor, GitHub CLI, Excel? and more by Michael Crump on Twitch.
* [Ed Charbeneau talks about Blazor components on CsharpFritz](https://www.twitch.tv/videos/544128754) - ![duration](https://img.shields.io/badge/Duration:%20-152%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) February 25, 2020 - Ed Charbeneau talks about Blazor components contributes BlazorComponentUtilities to our project.
* [Deep Dive on Server-Side Blazor](https://www.youtube.com/watch?v=JrA1cv5jvFA) - ![duration](https://img.shields.io/badge/Duration:%20-60%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) February 24, 2020 - Talk by Carl Franklin at the NDC London, "Deep Dive on Server-Side Blazor". Blazor has arrived on the server with .NET Core 3. In this demo-filled session, Carl shows you how you can integrate authentication, data access with Entity Framework Core, API endpoints, File Uploads, and SignalR to create a great experience for your users.
* [Deploying Blazor WebAssembly Backend](https://www.twitch.tv/videos/555713221) - February 21, 2020 - Deploying Blazor WebAssembly Backend, on Twitch.
* [Blazor Tutorial : Templated Components | Html Table](https://www.youtube.com/watch?v=BBFF2l1FlE0&feature=youtu.be) - February 20, 2020 - Blazor Tutorial : Templated Components | Html Table by CuriousDrive. [Source code](https://github.com/CuriousDrive/BookStores). 
* [Is Blazor the new Silverlight?](https://www.youtube.com/watch?v=s9Nkry1l5Tg&feature=youtu.be) - February 19, 2020 - Very short video (2min) by Carl Franklin from the [Blazor Road Show](http://www.blazorroadshow.com) who speaks about "Is Blazor the new Silverlight?".
* [Blazor Tutorial : Procedural Logic | Authentication & Authorization in C#](https://www.youtube.com/watch?v=EdnrUGmECS4&feature=youtu.be) - February 18, 2020 - Blazor Tutorial : Procedural Logic | Authentication & Authorization in C#, by Curious Drive. [Source code](https://github.com/CuriousDrive/BookStores).
* [Open Source C#, Blazor, and the DataBinder](https://www.twitch.tv/videos/552921602) - February 16, 2020 - Open Source C#, Blazor, and the DataBinder, by Jeffrey Fritz. [BlazorWebFormsComponents](https://github.com/FritzAndFriends/BlazorWebFormsComponents).
* [Coding with Squirrel - and Blazor !coffee](https://www.twitch.tv/videos/551829522) - February 14, 2020 - Coding with Squirrel, and Blazor !coffee, by Jeffrey Fritz. [BlazorWebFormsComponents](https://github.com/FritzAndFriends/BlazorWebFormsComponents).
* [Blazor TreeView GridLines and starting the FormView component](https://www.twitch.tv/videos/551327880) - February 13, 2020 - Blazor TreeView GridLines and starting the FormView component, by Jeffrey Fritz.
* [Blazor TreeView images and checkboxes](https://www.twitch.tv/videos/550829401) - February 12, 2020 - Blazor TreeView images and checkboxes, by Jeffrey Fritz. [BlazorWebFormsComponents](https://github.com/FritzAndFriends/BlazorWebFormsComponents).
* [How To Create a Blazor Component](https://www.youtube.com/watch?v=ijIjg2XAVK8) - February 11, 2020 - This video covers how to create a Blazor component for a Blazor application. Create a template and write C# code to connect the component with the application.
* [Ed Charbeneau of Progress: Why I'm Excited About Blazor in 2020](https://www.youtube.com/watch?v=rAiBaedDWpY) - February 10, 2020 - Ed Charbeneau of Progress talks about the technologies he's excited to learn more about in 2020 including Blazor.
* [Blazor Tutorial: Role-based Authorization](https://www.youtube.com/watch?v=rk5uIA6s574&feature=youtu.be) - February 7, 2020 - Blazor Tutorial: Role-based Authorization. [Source code](https://github.com/CuriousDrive/BookStores).
* [Building next generation web apps with Blazor](https://www.youtube.com/watch?v=-I54oAgTRC8&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-55%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) February 6, 2020 - Building next generation web apps with Blazor by Chris Sainty at the [DDD Europe 2020](https://dddeurope.com/2020).
* [Blazor Tutorial: Register User & Generate JWT](https://www.youtube.com/watch?v=kGbdWtxFhRI) - February 5, 2020 - Blazor Tutorial : Register User & Generate JWT.
* [Live from Stockholm - Pages, JavaScript, C# and Blazor components](https://www.twitch.tv/videos/546707126) - February 4, 2020 - Live from Stockholm - Pages, JavaScript, C# and Blazor components, by Jeffrey Fritz.
* [Live from Stockholm - MasterPages, Layouts, Blazor components and your pull-requests](https://www.twitch.tv/videos/545753950) - February 2, 2020 - Live from Stockholm - MasterPages, Layouts, Blazor components and your pull-requests, by Jeffrey Fritz.
* [Build modern data-driven Web Apps with Microsoft Blazor and Dapper](https://www.youtube.com/watch?v=W9xUUk_H_Ng) - February 2, 2020 - Build modern data-driven Web Apps with Microsoft Blazor and Dapper.
* [Blazor, a new framework for browser-based .NET apps](https://www.youtube.com/watch?v=Khn7sDUSEJM&feature=youtu.be) - January 29, 2020 - "Blazor, a new framework for browser-based .NET apps" session by Steve Sanderson at the [NDC London 2020](https://ndc-london.com/talk/blazor-a-new-framework-for-browser-based-net-apps-1/).
* [Blazor in more depth](https://www.youtube.com/watch?v=QnBYmTpugz0) - January 28, 2020 - Blazor in more depth by Steve Sanderson and Ryan Nowak at the [NDC London 2020](https://ndc-london.com/talk/blazor-in-more-depth/).
* [How to use BlazorStyled with Blazor to dynamically change CSS](https://youtu.be/frtetHgfdIo) - January 22, 2029 - I show how to install BlazorStyled for SSB and how I built a ProgressBar and Sprite Component to do simple animaitons.
* [Blazor Tutorial : HttpClient | Login User](https://www.youtube.com/watch?v=X6cBnOhaYhk&feature=youtu.be) - January 21, 2020 - This video covers how we can use HttpClient in your Blazor app to make API calls to login user into the system. [Source code](https://github.com/CuriousDrive/BlazorApp).
* [Let's add some auth to Blazor](https://www.twitch.tv/videos/533986300) - January 17, 2020 - Let's add some auth to Blazor, on Twitch.
* [Blazor Means Business](https://www.youtube.com/watch?v=0CS2xat4dBg) - January 16, 2020 - "Blazor Means Business" by Paul Schroeder at the Chicago .NET User Group.
* [Microsoft, Google and Cookie Authentication and Authorization](https://www.youtube.com/watch?v=v2OsI7qJdoc) - January 15, 2020 - This video by Microsoft covers how you can use authentication and authorization within your Blazor application.
* [Adding content management using Kentico Kontent](https://www.youtube.com/watch?v=DqdiYXg8gRs) - January 15, 2020 - Adding content management using Kentico Kontent to a Blazor app.
* [.NET Conf session: Blazor for Web Form and C# Developers](https://channel9.msdn.com/Events/dotnetConf/Focus-on-Blazor/Blazor-for-Web-Form-and-C-Developers) - January 14, 2020 - "Blazor for Web Form and C# Developers" by Jeff Fritz, session of the .NET Conf "Focus on Blazor". This session covers how you can use Blazor within your Web Form applications.
* [.NET Conf session: Build Serverless Apps with Blazor](https://channel9.msdn.com/Events/dotnetConf/Focus-on-Blazor/Build-Serverless-Apps-with-Blazor) - January 14, 2020 - "Build Serverless Apps with Blazor" by Daria Grigoriu and Fabio Cavalcante, session of the .NET Conf "Focus on Blazor". This session covers how you can build serverless Blazor applications.
* [.NET Conf session: Scaling Blazor Server Apps with Azure](https://channel9.msdn.com/Events/dotnetConf/Focus-on-Blazor/Scaling-Blazor-Server-Apps-with-Azure) - January 14, 2020 - "Scaling Blazor Server Apps with Azure" by Ryan Nowak, session of the .NET Conf "Focus on Blazor". This session covers how you can scale your Blazor applications with Azure.
* [.NET Conf session: Microsoft, Google and Cookie Authentication and Authorization](https://channel9.msdn.com/Events/dotnetConf/Focus-on-Blazor/Microsoft-Google-and-Cookie-Authentication-and-Authorization) - January 14, 2020 - "Microsoft, Google and Cookie Authentication and Authorization" by Michael Washington, session of the .NET Conf "Focus on Blazor". This session covers how you can use authentication and authorization within your Blazor application.
* [.NET Conf session: Authoring Custom Components](https://channel9.msdn.com/Events/dotnetConf/Focus-on-Blazor/Authoring-Custom-Components) - January 14, 2020 - "Authoring Custom Components" by Ed Charbeneau, session of the .NET Conf "Focus on Blazor". This session covers how you can create custom Blazor components.
* [.NET Conf session: Mobile Blazor Bindings - Using Blazor to build mobile apps](https://channel9.msdn.com/Events/dotnetConf/Focus-on-Blazor/Mobile-Blazor-Bindings-Using-Blazor-to-build-mobile-apps) - January 14, 2020 - "Mobile Blazor Bindings - Using Blazor to build mobile apps" by Eilon Lipton, session of the .NET Conf "Focus on Blazor". This session covers how you can use Blazor to build great mobile applications.
* [.NET Conf session: Testing Blazor Components](https://channel9.msdn.com/Events/dotnetConf/Focus-on-Blazor/Testing-Blazor-Components) - January 14, 2020 - "Testing Blazor Components" by Egil Hansen, session of the .NET Conf "Focus on Blazor". This session covers different ways to test the Blazor components.
* [.NET Conf session: JavaScript Two-Way Interop](https://channel9.msdn.com/Events/dotnetConf/Focus-on-Blazor/JavaScript-Two-Way-Interop) - January 14, 2020 - "JavaScript Two-Way Interop" by Javier Calvarro Nelson, session of the .NET Conf "Focus on Blazor". This session covers cover how you can use custom JavaScript within your Blazor components.
* [.NET Conf session: State Management in Blazor Apps](https://channel9.msdn.com/Events/dotnetConf/Focus-on-Blazor/State-Management-in-Blazor-Apps) - January 14, 2020 - "State Management in Blazor Apps" by Jeremy Likness, session of the .NET Conf "Focus on Blazor". This session covers how you can enable statement management within your Blazor applications.
* [.NET Conf session: Create a great UX with Blazor](https://channel9.msdn.com/Events/dotnetConf/Focus-on-Blazor/Create-a-great-UX-with-Blazor) - January 14, 2020 - "Create a great UX with Blazor" by Jimmy Engstrom, session of the .NET Conf "Focus on Blazor". This session covers how we can create a great UX flow with Blazor.
* [.NET Conf session: Routing A-Z](https://channel9.msdn.com/Events/dotnetConf/Focus-on-Blazor/Routing-A-Z) - January 14, 2020 - "Routing A-Z" by Chris Sainty, session of the .NET Conf "Focus on Blazor". This session covers how routing works within Blazor and its components.
* [.NET Conf session: Welcome to Blazor](https://channel9.msdn.com/Events/dotnetConf/Focus-on-Blazor/Welcome-to-Blazor) - January 14, 2020 - "Welcome to Blazor" by Dan Roth, session of the .NET Conf "Focus on Blazor".
* [.NET Conf "Focus on Blazor"](https://www.youtube.com/watch?v=fgneZz-4Foc) - Video of the complete event. 8 hours of great information about Blazor, enjoy!
* [.NET Conf: Focus on Blazor Teaser](https://channel9.msdn.com/Shows/Visual-Studio-Toolbox/NET-Conf-Focus-on-Blazor-Teaser) - January 9, 2020 - In this episode, Robert is joined by Daniel Roth, who provides a look at the upcoming (Tuesday January 14) .NET Conf: Focus on Blazor. This is a free, one-day livestream event that features speakers from the community and .NET product teams that are working on building web apps with C# and Blazor. He also gives a nice overview of Blazor.
* [Create new Blazor CRUD application with Radzen](https://www.youtube.com/watch?v=rTVspBBuAz4) - January 7, 2020 - How to create new Blazor CRUD application from Microsoft SQL Server database using Radzen.
* [Blazor Forms with Validation - Part IV](https://www.youtube.com/watch?v=SzlsRdV5z_8) - January 1, 2020 - This video will show you how to include a radio button, checkbox, and select/dropdown in a blazor form.  There are a couple of options when working with the select and this video takes you through them.
* [Blazor Forms with Validation - Part III](https://www.youtube.com/watch?v=fAwba0bpiSs) - January 1, 2020 - This video shows you how to add validation messages at the field level instead of or in addition to at the form level.

## Articles
* [Configure Alexa Skill to use Blazor backend](https://www.arjunkrishna.us/blog/alexa-backend-within-blazor/) - December 28, 2020 - Configure Alexa Skill to use Blazor backend. [Source code](https://github.com/arjunkrishna/Blazor-WASM-Identity-gRPC-Alexa/) ![stars](https://img.shields.io/github/stars/arjunkrishna/Blazor-WASM-Identity-gRPC-Alexa?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/arjunkrishna/Blazor-WASM-Identity-gRPC-Alexa?style=flat-square&cacheSeconds=86400).
* [MicroFrontends with Blazor WebAssembly](https://medium.com/@waelkdouh/microfrontends-with-blazor-webassembly-b25e4ba3f325) - December 22, 2020 - MicroFrontends with Blazor WebAssembly. [Source code](https://github.com/waelkdouh/BlazorMicroFrontend) ![stars](https://img.shields.io/github/stars/waelkdouh/BlazorMicroFrontend?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/waelkdouh/BlazorMicroFrontend?style=flat-square&cacheSeconds=86400).
* [Sitecore Power with ASP.NET Core and why it’s important](https://aceik.com.au/2020/12/18/sitecore-power-with-asp-net-core-and-why-its-important/) - December 18, 2020 - Sitecore has recently introduced a development SDK with ASP.NET Core. This article explains why it’s super important for the Business to start thinking about it and how it will change the way of Sitecore development.
* [10 Blazor Features You Probably Didn't Know](https://www.telerik.com/blogs/10-blazor-features-you-probably-didnt-know) - December 15, 2020 - As a relatively new framework, there's probably a lot you don't know about Blazor yet. Here are 10 great features about Blazor you should know.
* [Exploring Blazor Mobile Bindings](https://www.telerik.com/blogs/exploring-blazor-mobile-bindings) - December 13, 2020 - It's time to probe the promise of Blazor Mobile Bindings enticing web developers to come build mobile apps.
* [Polly and Blazor, Part 1 – Simple Wait and Retry](https://nodogmablog.bryanhogan.net/2020/12/polly-and-blazor-part-1-simple-wait-and-retry/) - December 8, 2020 - Polly and Blazor, Part 1 – Simple Wait and Retry.
* [Blazor WebAssembly (client-side) with AOT and SkiaSharp](https://platform.uno/blog/blazor-webassembly-client-side-with-aot-and-skiasharp/) - December 4, 2020 - Blazor WebAssembly (client-side) with AOT and SkiaSharp, by Uno Platform. [Live sample](https://blazor-aot.platform.uno/).
* [How to Pass Arguments to Your onclick Functions in Blazor](https://www.telerik.com/blogs/how-to-pass-arguments-to-your-onclick-functions-blazor) - December 3, 2020 - It's straightforward to wire up event handlers to HTML events like onClick in your Blazor components, but how can you pass additional information and different types of arguments?
* [Blazor Updates in .NET 5](https://www.codemag.com/article/2010102) - December 1, 2020 - Blazor Updates in .NET 5 by Daniel Roth on [Code Magazine](https://www.codemag.com/Magazine/Issue/DotNet5).
* [Developer decries WinForms-to-Blazor performance degradation](https://visualstudiomagazine.com/articles/2020/12/01/blazor-performance.aspx) - December 1, 2020 - Developer decries WinForms-to-Blazor performance degradation, on Visual Studio Magazine.
* [How to migrate Blazor Webassembly to .NET 5](https://dev.to/mizrael/how-to-migrate-blazor-webassembly-to-net-5-hmm) - November 30, 2020 - How to migrate Blazor Webassembly to .NET 5.
* [How to Deploy a Blazor Application in Azure App Service](https://www.syncfusion.com/blogs/post/deploy-blazor-application-in-azure-app-service.aspx) - November 30, 2020 - How to Deploy a Blazor Application in Azure App Service.
* [Blazor JavaScript Isolation, Modules, and Dynamic C#](https://khalidabuhakmeh.com/blazor-javascript-isolation-modules-and-dynamic-csharp) - November 24, 2020 - .NET 5 is here, and with the release comes a barrel of Blazor improvements. One of the upgrades Blazorinos should be most excited about is JavaScript isolation and object references within .NET. This post will describe enhancing the existing Blazor API using extension methods to make importing JavaScript modules clearer. We’ll create a new type that will allow us to write C# code that looks similar to its JavaScript counterparts. [Source code](https://github.com/khalidabuhakmeh/blazor-javascript-modules) ![stars](https://img.shields.io/github/stars/khalidabuhakmeh/blazor-javascript-modules?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/khalidabuhakmeh/blazor-javascript-modules?style=flat-square&cacheSeconds=86400).
* [Blazor WASM and Server in a Single Project Running on a Single Site](https://www.codeproject.com/Articles/5287009/Blazor-WASM-and-Server-in-a-Single-Project-running) - November 24, 2020 - This article looks at solving the challenges in creating a combined Blazor WASM and Server application - built in the same solution, and run on the same web site.
* [A Localization sample using Blazor WebAssembly](https://www.learmoreseekmore.com/2020/11/blazorwasm-localization.html) - November 24, 2020 - A Localization sample using Blazor WebAssembly
* [Custom Validation in Blazor WebAssembly](https://code-maze.com/custom-validation-in-blazor-webassembly/) - November 24, 2020 - This article is about custom form validation in Blazor WebAssembly. It shows how to add custom validation attributes and use them for our model objects. Also, it shows how to customize our error messages and how to customize the style of the input elements on the form. [Source code](https://github.com/CodeMazeBlog/blazor-wasm-custom-validation) ![stars](https://img.shields.io/github/stars/CodeMazeBlog/blazor-wasm-custom-validation?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/CodeMazeBlog/blazor-wasm-custom-validation?style=flat-square&cacheSeconds=86400).
* [Running a console application directly in your browser](https://plbonneville.com/blog/running-a-console-application-directly-in-your-browser/) - November 22, 2020 - Running a console application directly in your browser. [Source code](https://github.com/plbonneville/blog-examples/tree/master/running-a-console-application-directly-in-your-browser) ![stars](https://img.shields.io/github/stars/plbonneville/blog-examples?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/plbonneville/blog-examples?style=flat-square&cacheSeconds=86400).
* [.NET5 - A Unified Platform](https://dev.to/saeedgz98/net5-a-unified-platform-3l35) - November 20, 2020 - The official version of .NET5 was released last week and bringing huge improvements into the .NET ecosystem. .NET 5 is the next version of .NET Core, and Microsoft continues the journey of unifying the .NET platform.
* [Library Interop Generator 1.0 Release](https://codyanhorn.tech/blog/blazor/2020/11/19/Blazor-Library-Interop-Generator.html) - November 19, 2020 - The [Library Interop Generator](https://github.com/canhorn/EventHorizon.Blazor.TypeScript.Interop.Generator) ![stars](https://img.shields.io/github/stars/canhorn/EventHorizon.Blazor.TypeScript.Interop.Generator?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/canhorn/EventHorizon.Blazor.TypeScript.Interop.Generator?style=flat-square&cacheSeconds=86400) is quite simple to grasp, you give it a TypeScript definition file and it will create a C# interop library for easier usage with ASP.NET Core Blazor. You can see a working site at [Pirate Fort](https://wonderful-pond-05f7b3b10.azurestaticapps.net/pirate-fort), it includes click action callbacks, animations, pixel system running, and sounds, all triggered from C#.
* [Step Into .NET 5 with Telerik UI for ASP.NET Core Components](https://www.telerik.com/blogs/step-into-dotnet-5-telerik-ui-for-asp-dotnet-core-components) - November 18, 2020 - .NET 5 is here, and Telerik UI for ASP.NET Core is fully compatible. Check out what's new in .NET 5 and how you can take advantage today.
* [Write a WordPress blog with Blazor](https://www.davideguida.com/write-a-wordpress-blog-with-blazor/) - November 18, 2020 - Write a WordPress blog with Blazor. [Source code](https://github.com/mizrael/BlazorWPBlog) ![stars](https://img.shields.io/github/stars/mizrael/BlazorWPBlog?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/mizrael/BlazorWPBlog?style=flat-square&cacheSeconds=86400).
* [Blazor WebAssembly - Unleash The Power Of Dynamic Template-Based UIs With Razor Engine](https://www.thinktecture.com/en/blazor/webassembly-dynamic-template-engine-with-razor) - November 17, 2020 - In general, you can divide template engines into two types. The relatively simple ones are using template strings with placeholders to be replaced by some concrete values. The other template engines can do everything the simple ones can but additionally provide means for control of the code flow, like if-else statements, loops, and further. In this article, I will focus on the latter by using the Razor engine inside a Blazor WebAssembly application.
* [Visual Studio 2019 for Mac v8.8 Adds Blazor WebAssembly Debugging](https://visualstudiomagazine.com/articles/2020/11/16/vs-mac-update.aspx) - November 16, 2020 - Visual Studio 2019 for Mac v8.8 Adds Blazor WebAssembly Debugging, on Visual Studio Magazine.
* [Building Real-Time Applications with Blazor Server and Firestore](https://www.twilio.com/blog/building-real-time-applications-with-blazor-server-and-firestore) - November 16, 2020 - Building Real-Time Applications with Blazor Server and Firestore. [Source code](https://github.com/Swimburger/BlazorServerFirestore) ![stars](https://img.shields.io/github/stars/Swimburger/BlazorServerFirestore?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/Swimburger/BlazorServerFirestore?style=flat-square&cacheSeconds=86400).
* [Blazor and ASP.NET Core Get Faster in .NET 5](https://visualstudiomagazine.com/articles/2020/11/12/blazor-speed.aspx) - November 12, 2020 - Blazor and ASP.NET Core Get Faster in .NET 5.
* [Announcing ASP.NET Core in .NET 5](https://devblogs.microsoft.com/aspnet/announcing-asp-net-core-in-net-5/) - November 10, 2020 - .NET 5 is now released! .NET 5 is the next version of .NET Core and the future of the .NET platform. With .NET 5 you have everything you need to build rich, interactive front end web UI and powerful backend services. For a full list of everything that’s new in ASP.NET Core in this release, check out the [ASP.NET Core in .NET 5 release notes](https://docs.microsoft.com/aspnet/core/release-notes/aspnetcore-5.0). See also the [.NET 5 release notes](https://docs.microsoft.com/aspnet/core/release-notes/aspnetcore-5.0) for additional details and known issues.
* [Announcing .NET 5.0](https://devblogs.microsoft.com/dotnet/announcing-net-5-0/) - November 10, 2020 - Announcing .NET 5.0, by Microsoft.
* [Blazor Stability Testing Tools for Bulletproof Applications](https://www.telerik.com/blogs/blazor-stability-testing-tools-for-bulletproof-applications) - November 9, 2020 - Blazor testing may just be the biggest potential upside of the framework. Learn about the core concepts of Blazor testing that will help you make bulletproof apps.
* [Run Blazor Apps Within Electron Shell](https://blog.jetbrains.com/dotnet/2020/11/05/run-blazor-apps-within-electron-shell/) - November 5, 2020 - This post covers how to embed Blazor into an Electron app to ship Blazor on the desktop, and how to debug our Electron application using Rider.
* [Communicating between .NET and JavaScript in Blazor with in-browser samples](https://swimburger.net/blog/dotnet/communicating-between-dotnet-and-javascript-in-blazor-with-in-browser-samples) - November 5, 2020 - The success of Blazor relies heavily upon how well it can integrate with the existing rich JavaScript ecosystem. The way Blazor allows you to integrate, is by enabling you to call JavaScript functions from Blazor and .NET functions from JavaScript. This is also referred to as 'JavaScript interoperability'.
* [Sending IoT Hub telemetry to a Blazor Web App](https://sandervandevelde.wordpress.com/2020/11/04/sending-iot-hub-telemetry-to-a-blazor-web-app/) - November 4, 2020 - Integrate Azure Functions and Blazor Web App using an API Controller. Use it together with IoT Hub routing.
* [Implement a Blazor full text search using Azure Cognitive Search](https://damienbod.com/2020/11/02/implement-a-blazor-full-text-search-using-azure-cognitive-search/) - November 2, 2020 - This article shows how to implement a full text search in Blazor using [Azure Cognitive Search](https://docs.microsoft.com/azure/search/). The search results are returned using paging and the search index can be created, deleted from a Blazor application. [Source code](https://github.com/damienbod/AspNetCoreAzureSearch) ![stars](https://img.shields.io/github/stars/damienbod/AspNetCoreAzureSearch?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/damienbod/AspNetCoreAzureSearch?style=flat-square&cacheSeconds=86400).
* [Exploring lighter alternatives to Electron for hosting a Blazor desktop app](https://blog.stevensanderson.com/2019/11/01/exploring-lighter-alternatives-to-electron-for-hosting-a-blazor-desktop-app/) - November 1, 2020 - Can we get the benefits of Electron for desktop apps built with web technology, with far less resource consumption? By Steve Sanderson.
* [Unified Blazor UI in the Mobile Blazor Bindings Preview 5](https://devblogs.microsoft.com/aspnet/unified-ui-mobile-blazor-bindings-preview-5/) - October 30, 2020 - Unified Blazor UI in the Mobile Blazor Bindings Preview 5.
* [ARC-8: devlog #2 - Blazor](https://diegogiacomelli.com.br/arc-8-devlog-2/) - October 29, 2020 - This article is about how to implement the graphics, sound, input, and log systems for Blazor.
* [Should your enterprise pick Angular, React or Blazor?](https://www.telerik.com/blogs/should-enterprise-pick-angular-react-blazor) - October 27, 2020 - Should your enterprise pick Angular, React or Blazor, by Jon Hilton for Progress Telerik.
* [Blast Off with Blazor: Get to know Blazor and our project](https://daveabrock.com/2020/10/26/blast-off-blazor-intro) - October 26, 2020 - Building a website from the ground up with no Blazor experience required. All you’ll need is a passing knowledge of C# and .NET. [Source code](https://github.com/daveabrock/NASAImageOfDay) ![stars](https://img.shields.io/github/stars/daveabrock/NASAImageOfDay?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/daveabrock/NASAImageOfDay?style=flat-square&cacheSeconds=86400).
* [Is Blazor Safe for Your Enterprise to Bet On?](https://www.telerik.com/blogs/is-blazor-safe-enterprise-bet) - October 22, 2020 - As with any technology, you’d be foolish not to be concerned about moving your organization to Blazor. Let’s clarify what’s worth worrying about. Also: Why you shouldn’t worry.
* [Blazor FAST web components](https://benjaminvertonghen.medium.com/blazor-fast-webcomponents-4bae55d005ad) - October 22, 2020 - Interfaces built with FAST adapt to your design system and can be used with any modern UI Framework by leveraging industry standard Web Components. Let’s put this to the test using Blazor.
* [Using NPM Packages in Blazor](https://brianlagunas.com/using-npm-packages-in-blazor/) - October 19, 2020 - Using NPM Packages in Blazor.
* [Building Real-Time Applications with Blazor Server and Firestore](https://www.twilio.com/blog/building-real-time-applications-with-blazor-server-and-firestore) - October 16, 2020 - Building Real-Time Applications with Blazor Server and Firestore.
* [Blazor in depth — Create Blazor component without Lifecycle methods](https://dev.to/madhust/blazor-in-depth-create-blazor-component-without-lifecycle-methods-2786) - October 16, 2020 - Blazor in depth — Create Blazor component without Lifecycle methods.
* [How to Add gRPC to Your Blazor App](https://www.telerik.com/blogs/how-to-add-grpc-to-your-blazor-app) - October 14, 2020 - This post reivews how to get started with gRPC within your Blazor apps. We'll start with a basic Blazor WebAssembly app being hosted from an ASP.NET Core server, then modify it to use gRPC.
* [Combing through ComponentBase](https://safia.rocks/blog/combing-through-component-base/) - October 14, 2020 - Combing through ComponentBase.
* [ASP.NET Core updates in .NET 5 Release Candidate 2](https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-5-release-candidate-2/) - October 13, 2020 - .NET 5 Release Candidate 2 (RC2) is now available and is ready for evaluation. .NET 5 RC2 is a “go live” release, meaning it’s supported in production. This prerelease of .NET 5 is very close to what we expect to ship for the .NET 5 release. Some improvements for Blazor: [CSS isolation](https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-5-preview-8/#css-isolation-for-blazor-components), [component virtualization](https://docs.microsoft.com/aspnet/core/blazor/components/virtualization),  [support for toggle events](https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-5-release-candidate-1/#blazor-support-for-ontoggle-event), [IAsyncDisposable support for components](https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-5-release-candidate-1/#iasyncdisposable-support-for-blazor-components) and more!
* [Blazor Debugging Boosted in .NET 5 RC 2](https://visualstudiomagazine.com/articles/2020/10/13/blazor-net5-rc2.aspx) - October 13, 2020 - Blazor Debugging Boosted in .NET 5 RC 2, on Visual Studio Magazine.
* [Quick Helper For Blazor Performance](https://blog.mistermagoo.dev/quick-helper-for-blazor-performance-ckg790tsi02fz9cs1d6zze5ug) - October 13, 2020 - Quick Helper For Blazor Performance.
* [Render Blazor WASM components in your existing MVC/Razor Pages applications](https://jonhilton.net/blazor-wasm-in-razor-pages) - October 13, 2020 - Render Blazor WASM components in your existing MVC/Razor Pages applications.
* [Setup Your Blazor Wasm and ASP.NET Core Web API in Azure Devops: Dev To Azure - Part 1](https://www.roundthecode.com/dotnet/setup-your-blazor-wasm-and-asp-net-core-web-api-in-azure-devops) - October 12, 2020 - Setup Your Blazor Wasm and ASP.NET Core Web API in Azure Devops: Dev To Azure - Part 1. [Video](https://www.youtube.com/watch?v=YLEa2Pr79Ho).
* [Pushing UI changes from Blazor Server to browser on server raised events](https://swimburger.net/blog/dotnet/pushing-ui-changes-from-blazor-server-to-browser-on-server-raised-events) - October 12, 2020 - Pushing UI changes from Blazor Server to browser on server raised events. [Source code](https://github.com/Swimburger/BlazorServerEvents) ![stars](https://img.shields.io/github/stars/Swimburger/BlazorServerEvents?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/Swimburger/BlazorServerEvents?style=flat-square&cacheSeconds=86400).
* [Printing PDF’s in Blazor](https://medium.com/@benjaminvertonghen/printing-pdfs-in-blazor-8dff559101f9) - October 11, 2020 - Printing PDF’s in Blazor. [Source code](https://github.com/Append-IT/Blazor.Printing) ![stars](https://img.shields.io/github/stars/Append-IT/Blazor.Printing?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/Append-IT/Blazor.Printing?style=flat-square&cacheSeconds=86400).
* [Prerendering your Blazor WASM application with .NET 5](https://jonhilton.net/blazor-wasm-prerendering-missing-http-client/) - October 9, 2020 - Prerendering your Blazor WASM application with .NET 5 (part 2 - solving the missing HttpClient problem).
* [For ASP.NET Core in .NET 6, Devs want AOT Compilation](https://visualstudiomagazine.com/articles/2020/10/08/aspnet-core-net-6.aspx) - October 8, 2020 - For ASP.NET Core in .NET 6, Devs want AOT Compilation, on Visual Studio Magazine.
* [Retrieving Data "As You Need It" with the Telerik UI for Blazor DataGrid](https://www.telerik.com/blogs/retrieving-data-as-you-need-it-telerik-ui-for-blazor-datagrid) - October 6, 2020 - Retrieving Data "As You Need It" with the Telerik UI for Blazor DataGrid.
* [Building a simple tooltip component for Blazor in under 10 lines of code](https://chrissainty.com/building-a-simple-tooltip-component-for-blazor-in-under-10-lines-of-code/) - October 6, 2020 - Building a simple tooltip component for Blazor in under 10 lines of code. [Source code](https://github.com/chrissainty/SimpleBlazorTooltip) ![stars](https://img.shields.io/github/stars/chrissainty/SimpleBlazorTooltip?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/chrissainty/SimpleBlazorTooltip?style=flat-square&cacheSeconds=86400).
* [When does Blazor decide to render your UI?](https://jonhilton.net/when-does-blazor-render-your-ui) - October 3, 2020 - When does Blazor decide to render your UI?
* [Render diagrams on the fly in your Blazor apps](https://jonhilton.net/blazor-diagrams/) - October 1, 2020 - Render diagrams on the fly in your Blazor apps.
* [Creating Real-Time Charts with Blazor WebAssembly and SignalR](https://code-maze.com/creating-blazor-webassembly-signalr-charts/) - September 30, 2020 - Creating Real-Time Charts with Blazor WebAssembly and SignalR.
* [Blazor Guru Details Best Performance Practices](https://visualstudiomagazine.com/articles/2020/09/30/blazor-performance.aspx) - September 30, 2020 - Blazor Guru Details Best Performance Practices, on Visual Studio Magazine.
* [Blazor vs. Silverlight: Is Blazor Silverlight 2.0?](https://www.claudiobernasconi.ch/2020/09/29/blazor-vs-silverlight-is-blazor-silverlight-2/) - September 29, 2020 - Blazor vs. Silverlight: Is Blazor Silverlight 2.0?
* [Streaming an HTTP response in Blazor WebAssembly](https://www.meziantou.net/streaming-an-http-response-in-blazor-webassembly.htm) - September 28, 2020 - Streaming an HTTP response in Blazor WebAssembly.
* [How to deploy Blazor WASM & Azure Functions to Azure Static Web Apps](https://swimburger.net/blog/dotnet/how-to-deploy-aspnet-blazor-webassembly-to-azure-static-web-apps) - September 24, 2020 - How to deploy Blazor WASM & Azure Functions to Azure Static Web Apps.
* [Four Micro-Frontend Architecture yypes you can implement with Blazor](https://gorillalogic.com/blog/four-micro-frontend-architecture-types-you-can-implement-with-blazor/) - September 24, 2020 - Four Micro-Frontend Architecture yypes you can implement with Blazor.
* [EditForm - forms and validation in Blazor](https://dev.to/rineshpk/editform-forms-and-validation-in-blazor-54h7) - September 24, 2020 - ASP.Net Core Blazor ships some great components to get building web forms quickly and easily. The EditForm component allows us to manage forms, validations, and form submission events.
* [Blazor WebAssembly on Azure Static Web Apps](https://www.hanselman.com/blog/BlazorWebAssemblyonAzureStaticWebApps.aspx) - September 23, 2020 - Blazor WebAssembly on Azure Static Web Apps, by Scott Hanselman.
* [How to call isolated JavaScript code in .NET 5.0 Blazor projects with JSObjectReference](https://romansimuta.com/posts/how-to-call-isolated-javascript-code-in-net-5-0-blazor-projects-with-jsobjectreference/) - September 23, 2020 - How to call isolated JavaScript code in .NET 5.0 Blazor projects with JSObjectReference. [Source code](https://github.com/simutaroman/BlazorNet5JsInterOp) ![stars](https://img.shields.io/github/stars/simutaroman/BlazorNet5JsInterOp?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/simutaroman/BlazorNet5JsInterOp?style=flat-square&cacheSeconds=86400).
* [Azure Static Web Apps with .NET and Blazor](https://devblogs.microsoft.com/aspnet/azure-static-web-apps-with-blazor/) - September 22, 2020 - Azure Static Web Apps with .NET and Blazor, on the ASP.NET blog.
* [Deploy your Blazor app in minutes with Azure Static Web apps](https://dev.to/azure/deploy-your-blazor-app-in-minutes-with-azure-static-web-apps-40bh) - September 22, 2020 - Deploy your Blazor app in minutes with Azure Static Web apps.
* [Leaving Silverlight: Converting to the Web](https://www.telerik.com/blogs/leaving-silverlight-converting-to-the-web) - September 22, 2020 - If you’re migrating from Silverlight, the latest crop of technologies means that going to the web might be your best choice.
* [Run EF Core Queries on SQL Server From Blazor WebAssembly](https://blog.jeremylikness.com/blog/run-efcore-queries-against-sql-from-blazor-webassembly/) - September 20, 2020 - Run EF Core Queries on SQL Server From Blazor WebAssembly. What if I could write a LINQ query on a client the same way I would on a server, and execute it remotely with minimal configuration, setup, ritual and ceremony?
* [Creating Real-Time Charts with Blazor WebAssembly and SignalR](https://code-maze.com/creating-blazor-webassembly-signalr-charts/) - September 20, 2020 - Creating Real-Time Charts with Blazor WebAssembly and SignalR.
* [Calling public methods on Blazor component from another component](https://www.meziantou.net/calling-public-methods-on-blazor-component-from-another-component.htm) - September 18, 2020 - Calling public methods on Blazor component from another component.
* [CSS isolation in Blazor](https://www.meziantou.net/css-isolation-in-blazor.htm) - September 16, 2020 - CSS isolation in Blazor.
* [Making Scott Hanselman's Powerpoint Greenscreen trick work with RevealJS via Blazor Server](https://jonhilton.net/obs-revealjs-greenscreen) - September 15, 2020 - Making Scott Hanselman's Powerpoint Greenscreen trick work with RevealJS via Blazor Server. [Source code](https://github.com/jonhilt/RevealJSToOBSSceneSwitcher) ![stars](https://img.shields.io/github/stars/jonhilt/RevealJSToOBSSceneSwitcher?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/jonhilt/RevealJSToOBSSceneSwitcher?style=flat-square&cacheSeconds=86400).
* [The First Blazor Dock Manager](https://brianlagunas.com/the-first-blazor-dock-manager/) - September 15, 2020 - This article shows how to use the brand-new Dock Manager component in the [Ignite UI for Web Components product](https://www.infragistics.com/products/ignite-ui-web-components/web-components/components/dock-manager.html). [Source code](https://github.com/brianlagunas/BlazorDockManagerWC) ![stars](https://img.shields.io/github/stars/brianlagunas/BlazorDockManagerWC?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/brianlagunas/BlazorDockManagerWC?style=flat-square&cacheSeconds=86400).
* [Architecture of a C# game rendered with Blazor, Xamarin, UWP, WPF, and Winforms](https://blog.ndepend.com/architecture-of-a-c-game-rendered-with-blazor-xamarin-uwp-wpf-and-winforms/) - September 15, 2020 - Architecture of a C# game rendered with Blazor, Xamarin, UWP, WPF, and Winforms.
* [.NET 5 Hits 'Go Live' Status in RC1, Ready for Production](https://visualstudiomagazine.com/articles/2020/09/15/net-5-rc-1.aspx) - September 15, 2020 - .NET 5 Hits 'Go Live' Status in RC1, Ready for Production.
* [Blazor Gets Faster (Even Without AOT)](https://visualstudiomagazine.com/articles/2020/09/14/aspnet-5-rc1.aspx) - September 14, 2020 - Blazor Gets Faster (Even Without AOT).
* [ASP.NET Core updates in .NET 5 Release Candidate 1](https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-5-release-candidate-1/) - September 14, 2020 - ASP.NET Core updates in .NET 5 Release Candidate 1.
* [Lazy load assemblies in a Blazor WebAssembly application](https://www.meziantou.net/lazy-load-assemblies-in-a-blazor-webassembly-application.htm) - September 14, 2020 - Lazy load assemblies in a Blazor WebAssembly application.
* [.NET Blazor for Rails Developers](https://yagudaev.com/posts/dot-net-blazor-for-rails-developers) - September 12, 2020 - .NET Blazor for Rails Developers.
* [WebAssembly Beyond the Browser: Running WASM in .NET Core Applications With WASI & Wasmtime](https://www.thinktecture.com/en/webassembly/with-dotnet/) - September 10, 2020 - WebAssembly Beyond the Browser: Running WASM in .NET Core Applications With WASI & Wasmtime. [Source code](https://github.com/thinktecture-labs/article-webassembly-dotnet-server) ![stars](https://img.shields.io/github/stars/thinktecture-labs/article-webassembly-dotnet-server?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/thinktecture-labs/article-webassembly-dotnet-server?style=flat-square&cacheSeconds=86400).
* [Blazor.Animate adds support for running animations manually](https://mikaelkoskinen.net/post/blazor-animate-animations-manual-onclick) - September 10, 2020 - Blazor.Animate adds support for running animations manually.
* [Use CSS isolation in your Blazor projects](https://daveabrock.com/2020/09/10/blazor-css-isolation) - September 10, 2020 - We talk about scoping your CSS to your Blazor components—all without a stylesheet reference.
* [Blazor Server CRUD App Using Visual Studio Code](https://dev.to/rineshpk/blazor-server-crud-app-using-visual-studio-code-2b2g) - September 9, 2020 - Blazor Server CRUD App Using Visual Studio Code.
* [Working with Local Storage in a Blazor Progressive Web App](https://visualstudiomagazine.com/articles/2020/09/08/blazor-pwa-local-storage.aspx) - September 9, 2020 - Working with Local Storage in a Blazor Progressive Web App, on Visual Studio Magazine.
* [Copying text to the clipboard in a Blazor application](https://www.meziantou.net/copying-text-to-clipboard-in-a-blazor-application.htm) - September 9, 2020 - Copying text to the clipboard in a Blazor application.
* [Free e-book: Blazor for ASP.NET Web Forms Developers](https://devblogs.microsoft.com/aspnet/blazor-aspnet-webforms-ebook/) - September 8, 2020 - We are thrilled to announce the release of our new e-book: Blazor for ASP.NET Web Forms developers. This book caters specifically to ASP.NET Web Forms developers looking for guidelines. As well as strategies for migrating their existing apps to a modern, open-source, and cross-platform web framework. [Download PDF](https://aka.ms/blazor-ebook).
* [Anchor navigation in a Blazor application](https://www.meziantou.net/anchor-navigation-in-a-blazor-application.htm) - September 7, 2020 - Anchor navigation in a Blazor application.
* [Track Gps With Blazor Browserinterop](https://remibou.github.io/Track-GPS-with-Blazor-BrowserInterop/) - September 5, 2020 - Track Gps With Blazor Browserinterop. [Source code](https://github.com/RemiBou/remibou.github.io/tree/master/projects/RemiBou.BlogPost.Gps).
* [Blazor Wasm - Get Access Token for User](https://codyanhorn.tech/blog/blazor/2020/09/05/Blazor-Get-Access-Token-for-User.html) - September 5, 2020 - In this article Cody shows, using ASP.NET Core Blazor Wasm, a quick snippet to get the AccessToken for a logged in User. Not much to it just using the IAccessTokenProvider, and if the user is signed in and they have are using an authentication type that provides an access token, like OpenID.
* [Blazor - Page Animated Transitions](https://codyanhorn.tech/blog/blazor/2020/09/05/Blazor-Page-Animated-Transitions.html) - September 5, 2020 - This article is about how to use BlazorTransitionableRoute to create an animated transition between Blazor page transitions.
* [Using a web camera with fun filters in your ASP.NET Core Blazor WebAssembly application](https://romansimuta.com/posts/using-a-web-camera-with-fun-filters-in-your-asp-net-core-blazor-webassembly-application/) - September 4, 2020 - Using a web camera with fun filters in your ASP.NET Core Blazor WebAssembly application. [Source code](https://github.com/simutaroman/BlazorWebCamApp) ![stars](https://img.shields.io/github/stars/simutaroman/BlazorWebCamApp?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/simutaroman/BlazorWebCamApp?style=flat-square&cacheSeconds=86400).
* [Blazor Internals you need to know](https://blog.ndepend.com/blazor-internals-you-need-to-know/) - September 3, 2020 - Blazor Internals you need to know.
* [Microsoft offers new documentation for Blazor and gRPC in ASP.NET Core](https://visualstudiomagazine.com/articles/2020/09/03/blazor-grpc-docs.aspx) - September 3, 2020 - With .NET 5 release candidates on tap ahead of an official November GA debut, Microsoft has published new documentation for some of the hottest ASP.NET Core components, including Blazor and gRPC.
* [Why Blazor Wasm is the Best Choice for API Integration](https://www.roundthecode.com/dotnet/blazor/why-blazor-wasm-is-the-best-choice-for-api-integration) - August 31, 2020 - Why Blazor Wasm is the Best Choice for API Integration.
* [.NET 5 Now 'Feature Complete' with Preview 8, Go Live Release Candidates Up Next](https://visualstudiomagazine.com/articles/2020/08/26/net-5-preview-8.aspx) - August 26, 2020 - .NET 5 Now 'Feature Complete' with Preview 8, Go Live Release Candidates Up Next on Visual Studio Magazine.
* [Showing a confirm dialog before doing an action in Blazor](https://www.meziantou.net/showing-a-confirm-dialog-before-doing-an-action-in-blazor.htm) - August 26, 2020 - Showing a confirm dialog before doing an action in Blazor.
* [ASP.NET Core updates in .NET 5 Preview 8](https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-5-preview-8/) - August 25, 2020 - .NET 5 Preview 8 is now available and is ready for evaluation. Here’s what’s new in this release: CSS isolation for Blazor components, Lazy loading in Blazor WebAssembly, Updated Blazor WebAssembly globalization support, New InputRadio Blazor component, Set UI focus in Blazor apps, Influencing the HTML head in Blazor apps, IAsyncDisposable for Blazor components, Control Blazor component instantiation and much more.
* [Announcing .NET 5.0 Preview 8](https://devblogs.microsoft.com/dotnet/announcing-net-5-0-preview-8/) - August 25, 2020 - Today, we are releasing .NET 5.0 Preview 8. The .NET 5.0 release is now “feature complete”, meaning that very nearly all features are in their final form (with the exception of bug fixes still to come). Preview 8 is, appropriately, the last preview. We plan on releasing two go-live release candidates before the final .NET 5.0 release in November. This post describes a selection of features across the .NET 5.0 release.
* [Client/Server Dynamic Scripting](https://codyanhorn.tech/blog/blazor/2020/08/25/Blazor-Client_Server-Dynamic-Scripting.html) - August 25, 2020 - For my new Blazor Game Client I wanted a way to create scripts that could be written by the user of the platform, and automatically load them from Client, without having to pull down a new client or having to reload the client. This article will go over the project I created to show how this might be done.
* [The .NET Docs Show: Open source .NET projects](https://dev.to/dotnet/the-net-docs-show-open-source-net-projects-2h39) - August 24, 2020 - In this episode of The .NET Docs Show, Isaac Levin (@isaacrlevin) discusses several of his open source .NET projects. As part of this week's #CheckUp, we share an MS Learn module for building with Microsoft Graph as it related to the PresenceLight project. [Video on YouTube](https://www.youtube.com/watch?v=12XAjpuwByo).
* [How to prevent the UI from freezing while executing CPU intensive work in Blazor WebAssembly](https://www.meziantou.net/don-t-freeze-ui-while-executing-cpu-intensive-work-in-blazor-webassembly.htm) - August 24, 2020 - How to prevent the UI from freezing while executing CPU intensive work in Blazor WebAssembly.
* [How to Work With Client-Side Blazor](https://www.telerik.com/blogs/how-to-work-with-client-side-blazor) - August 20, 2020 - You’ve probably heard talk of Blazor Wasm, but what is it and how can you use it to rapidly build your web applications?
* [Blazor WebAssembly - Changing The Log Level At Runtime](https://www.thinktecture.com/en/blazor/webassembly-changing-log-level-at-runtime) - August 20, 2020 - Blazor WebAssembly - Changing The Log Level At Runtime.
* [Dynamically setting the page title in a Blazor application](https://www.meziantou.net/dynamically-setting-the-page-title-in-a-blazor-application.htm) - August 19, 2020 - Dynamically setting the page title in a Blazor application.
* [Blazor and Media events - Hard to handle?](https://blog.mistermagoo.dev/blazor-and-media-events-hard-to-handle-ckdup6yf1000mids1f36n6j8q) - August 14, 2020 - Blazor and Media events - Hard to handle?
* [What's New in Blazor Tooling Updates](https://visualstudiomagazine.com/articles/2020/08/11/blazor-tooling-updates.aspx) - August 11, 2020 - What's New in Blazor Tooling Updates, on Visual Studio Magazine.
* [Blazor vs Angular](https://www.telerik.com/blogs/blazor-vs-angular-web-developers) - August 10, 2020 - A comparison of Blazor and Angular when it comes to modern web development—a review of the pros and cons by Telerik.
* [Online Multiplayer Word Game With Blazor and SignalR on .NetCore](https://medium.com/@bora.kasmer78/word-game-with-blazor-and-signalr-on-netcore-e14e125233f2) - August 8, 2020 - Let's build a simple online multiplayer word game with Blazor using SignalR for realtime communication between two players. All the words will keep in MongoDB and it will supports multi-platforms with .Net Core. [Source code](https://github.com/borakasmer/BlazorWordGame) ![stars](https://img.shields.io/github/stars/borakasmer/BlazorWordGame?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/borakasmer/BlazorWordGame?style=flat-square&cacheSeconds=86400).
* [Blazor Components Deep Dive - Lifecycle Is Not Always Straightforward](https://www.thinktecture.com/de/blazor/blazor-components-lifecycle-is-not-always-straightforward) - August 5, 2020 - When starting with new frameworks that have a lifecycle for their artifacts like components, then you may assume that the lifecycle is strictly linear. In other words, step A comes before step B comes before step C, and so on. Usually, this is the case until it is not. The lifecycle of the Blazor components is not an exception in this matter.
* [Make a responsive Navbar with Blazor and Tailwind?](https://jonhilton.net/responsive-blazor-navbar/) - August 4, 2020 - Make a responsive Navbar with Blazor and Tailwind?
* [Xamarin Blazor Mobile Button Event Handlers](https://wellsb.com/csharp/xamarin/xamarin-blazor-mobile-button-event-handlers/) - August 3, 2020 - Using the Blazor programming model to handle button events, like OnClick, makes writing Xamarin mobile applications with form inputs a breeze.
* [Introducing Plugin Framework 1.0.0 – Plugins for .NET apps including Blazor and ASP.NET Core with built-in support for Nuget](https://mikaelkoskinen.net/post/plugin-framework-dotnet-core-blazor-nuget-roslyn) - August 3, 2020 - Plugin Framework is a new MIT-licensed plugin platform for .NET Core applications. It is light-weight and easy way to add a plugin-support into your application. It supports all the major types of .NET Core applications, including ASP.NET Core, Blazor, Console Apps and WPF & WinForms.
* [Creating a Progressive Web App with Blazor WebAssembly](https://visualstudiomagazine.com/articles/2020/08/03/blazor-pwa.aspx) - August 3, 2020 - Not surprisingly, it's dead easy to create an app in Blazor that runs outside of the browser window and (potentially) in an offline mode. Before you get carried away, though, there are some key design decisions to make, by Visual Studio Magazine.
* [Implement the "download file" feature on a Blazor WebAssembly app](https://dev.to/j_sakamoto/implement-the-download-file-feature-on-a-blazor-webassembly-app-2f8p) - August 2, 2020 - If we want to implement the "download file" feature (please imagine a picture that was posted on Facebook can be downloadable) on your Blazor WebAssembly app project, how can we implement that feature? [Source code](https://github.com/sample-by-jsakamoto/Blazor-DownloadFIles) ![stars](https://img.shields.io/github/stars/sample-by-jsakamoto/Blazor-DownloadFIles?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/sample-by-jsakamoto/Blazor-DownloadFIles?style=flat-square&cacheSeconds=86400).
* [Run Blazor-based .NET Web applications on AWS Serverless](https://aws.amazon.com/fr/blogs/developer/run-blazor-based-net-web-applications-on-aws-serverless/) - July 30, 2020 - Run Blazor-based .NET Web applications on AWS Serverless.
* [Authenticate Blazor WebAssembly with Azure Static Web Apps](https://anthonychu.ca/post/blazor-auth-azure-static-web-apps/) - July 28, 2020 - [Azure Static Web Apps](https://docs.microsoft.com/azure/static-web-apps/overview) is a great place to host Blazor WebAssembly apps. Among Static Web Apps' many features, it has built-in support for authentication using social logins. In this article, we'll look at how we can take advantage of Static Web Apps Authentication in our Blazor WebAssembly apps. [Source code](https://github.com/anthonychu/blazor-auth-static-web-apps/tree/main/sample) ![stars](https://img.shields.io/github/stars/anthonychu/blazor-auth-static-web-apps?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/anthonychu/blazor-auth-static-web-apps?style=flat-square&cacheSeconds=86400).
* [Role-based security with Blazor and Identity Server 4](https://medium.com/@marcodesanctis2/role-based-security-with-blazor-and-identity-server-4-aba12da70049) - July 28, 2020 - This article covers how to add a role-based security both on the API side and in the UI of a Blazor application. Note: this article is the next part of a [previous article](https://medium.com/@marcodesanctis2/securing-blazor-webassembly-with-identity-server-4-ee44aa1687ef). [Source code](https://github.com/cradle77/BlazorSecurityDemo) ![stars](https://img.shields.io/github/stars/cradle77/BlazorSecurityDemo?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/cradle77/BlazorSecurityDemo?style=flat-square&cacheSeconds=86400).
* [Project - EventHorizon Blazor Interop](https://codyanhorn.tech/blog/blazor/2020/07/28/EventHorizon-Blazor-Interop.html) - July 28, 2020 - I have been working on a project that will generate a C# Blazor WASM abstraction from a TypeScript definition file, as part of that project I needed a way to run the equivalent functionality in JavaScript. This article will go over that WASM Interop project I created, I also package it up in an easy to use NuGet package if you want to use it as well. [Source code](https://github.com/canhorn/EventHorizon.Blazor.Interop) ![stars](https://img.shields.io/github/stars/canhorn/EventHorizon.Blazor.Interop?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/canhorn/EventHorizon.Blazor.Interop?style=flat-square&cacheSeconds=86400).
* [Blazor Interop Generation Tool Release](https://codyanhorn.tech/blog/blazor/2020/07/28/Blazor-Interop-Generation-Tool-Release.html) - July 28, 2020 - This article is the Release post of my new Blazor Interop Generation Tool! Here I will do a quick overview of the tool and how to use it. [Source code](https://github.com/canhorn/EventHorizon.Blazor.Interop) ![stars](https://img.shields.io/github/stars/canhorn/EventHorizon.Blazor.Interop?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/canhorn/EventHorizon.Blazor.Interop?style=flat-square&cacheSeconds=86400).
* [Project - EventHorizon Blazor TypeScript Interop Generator](https://codyanhorn.tech/blog/blazor/2020/07/28/Project-EventHorizon-Blazor-TypeScript-Interop-Generator.html) - July 28, 2020 - This project’s name is a mouthful, but based on the name you should be able to get the gist of what the project does. The project generates a C# Blazor Interop abstraction from the Abstract Syntax Tree from a TypeScript definition file, giving the user a generated project that can make interfacing with JavaScript libraries easier from C#. [Source code](https://github.com/canhorn/EventHorizon.Blazor.TypeScript.Interop.Generator) ![stars](https://img.shields.io/github/stars/canhorn/EventHorizon.Blazor.TypeScript.Interop.Generator?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/canhorn/EventHorizon.Blazor.TypeScript.Interop.Generator?style=flat-square&cacheSeconds=86400).
* [Blazor WebAssembly authentication and authorization with IdentityServer4](https://nahidfa.com/posts/blazor-webassembly-authentication-and-authorization-with-identityserver4/) - July 27, 2020 - This about implementing authentication on a Blazor WebAssembly app via OpenId Connect using IdentityServer4(IDS4). And also authorization on Blazor WebAssembly app. IDS4 is a certified OpenId provider library.
* [Optimizing JS Interop in a Blazor WebAssembly application](https://www.meziantou.net/optimizing-js-interop-in-a-blazor-webassembly-application.htm) - July 27, 2020 - Optimizing JS Interop in a Blazor WebAssembly application.
* [Blazor WebAssembly Targets .NET 5 in Latest ASP.NET Core Update](https://visualstudiomagazine.com/articles/2020/07/27/blazor-targets-net-5.aspx) - July 27, 2020 - In announcing updates to web-focused ASP.NET Core development as part of a new .NET 5 Preview 7, Microsoft noted that Blazor WebAssembly -- the client-side component of the Blazor project that allows for C#-based web development instead of JavaScript -- now targets .NET 5.
* [Generating and efficiently exporting a file in a Blazor WebAssembly application](https://www.meziantou.net/generating-and-downloading-a-file-in-a-blazor-webassembly-application.htm) - July 27, 2020 - Generating and efficiently exporting a file in a Blazor WebAssembly application.
* [State Management with Blazor using Fluxor (Part 2)](https://betweentwobrackets.dev/posts/2020/07/state-management-with-blazor-using-fluxor-part-2/) - July 26, 2020 - Implementing additional CRUD operations with Fluxor, a continuation of [part 1](https://betweentwobrackets.dev/posts/2020/06/state-management-with-blazor-using-fluxor-part-1/). [Source code](https://github.com/JoeyMckenzie/StateManagementWithFluxor/tree/feature/todos-part-2) ![stars](https://img.shields.io/github/stars/JoeyMckenzie/StateManagementWithFluxor?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/JoeyMckenzie/StateManagementWithFluxor?style=flat-square&cacheSeconds=86400).
* [Blazor EditForms, an essential tool or too much magic?](https://jonhilton.net/why-use-blazor-edit-forms/) - July 23, 2020 - Blazor ships with something called an EditForm. But what is it, do you have to use it, and what if you don’t fancy relying on magic to make your application work?
* [Hybrid Blazor apps in the Mobile Blazor Bindings July update](https://devblogs.microsoft.com/aspnet/hybrid-blazor-mobile-blazor-bindings-july-update/) - July 22, 2020 - Mobile Blazor Bindings July update is released, which adds support for building Hybrid Blazor apps, which contain both native and web UI. [Documentation](https://docs.microsoft.com/fr-fr/mobile-blazor-bindings/). [Source code](https://github.com/xamarin/MobileBlazorBindings/) ![stars](https://img.shields.io/github/stars/xamarin/MobileBlazorBindings?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/xamarin/MobileBlazorBindings?style=flat-square&cacheSeconds=86400).
* [bUnit for Blazor and How to Integrate it in Azure Pipeline](https://www.syncfusion.com/blogs/post/bunit-for-blazor-and-how-to-integrate-it-in-azure-pipeline.aspx) - July 22, 2020 - bUnit for Blazor and How to Integrate it in Azure Pipeline.
* [ASP.NET Core Updates in .NET 5 Preview 7](https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-5-preview-7/) - July 21, 2020 - .NET 5 Preview 7 is now available and is ready for evaluation. Here’s what’s new in this release: Blazor WebAssembly apps now target .NET 5, updated debugging requirements for Blazor WebAssembly, Blazor accessibility improvements, Blazor performance improvements and more.
* [Securing Blazor WebAssembly Apps](https://auth0.com/blog/securing-blazor-webassembly-apps) - July 21, 2020 - Learn how to secure Blazor WebAssembly applications with Auth0. [Source code](https://github.com/auth0-blog/secure-blazor-wasm-quiz-manager) ![stars](https://img.shields.io/github/stars/auth0-blog/secure-blazor-wasm-quiz-manager?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/auth0-blog/secure-blazor-wasm-quiz-manager?style=flat-square&cacheSeconds=86400).
* [How to build a Blazor web app with Azure Active Directory authentication and Microsoft Graph](https://developer.microsoft.com/microsoft-365/blogs/how-to-build-a-blazor-web-app-with-azure-active-directory-authentication-and-microsoft-graph/) - July 21, 2020 - How to build a Blazor web app with Azure Active Directory authentication and Microsoft Graph.
* [Mobile Blazor Common App Layouts](https://wellsb.com/csharp/xamarin/mobile-blazor-common-app-layouts/) - July 20, 2020 - This tutorial explores different layouts you can use when designing native mobile apps using Blazor and some tricks for how you can customize them to get just the look and feel your customers need.
* [Blazor: Zero To Hero Real Time Implementation Part III](https://learnwithsundar.com/2020/07/20/blazor-zero-to-hero-real-time-implementation-part-iii/) - July 20, 2020 - This is part three of the “Blazor: Zero to Hero” article series. This article has a detailed look at the Project Structure.
* [SignalR without Javascript, the Promise of Blazor](https://slorello.com/posts/signalr-without-javascript-using-blazor-webassembly) - July 18, 2020 - SignalR has always had one major flaw: to use it, you needed to use JavaScript. But with the dawn of Blazor, this age of compromise is over. We can manage all of the data transfers between our servers and clients straight out of CLR types! [Source code](https://github.com/slorello89/SignalRClr) ![stars](https://img.shields.io/github/stars/slorello89/SignalRClr?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/slorello89/SignalRClr?style=flat-square&cacheSeconds=86400).
* [Blazor WebAssembly Forms, Form Validation, and @ref Directive](https://code-maze.com/blazor-webassembly-forms-form-validation/) - July 17, 2020 - Blazor WebAssembly Forms, Form Validation, and @ref Directive, by Code Maze. [Source code](https://github.com/CodeMazeBlog/blazor-series/tree/blazor-webassembly-forms) ![stars](https://img.shields.io/github/stars/CodeMazeBlog/blazor-series?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/CodeMazeBlog/blazor-series?style=flat-square&cacheSeconds=86400). [Documentation](https://jskeet.github.io/DemoCode/Drums/).
* [Visual Studio Gets Experimental Razor Editor for Blazor, Other Projects](https://visualstudiomagazine.com/articles/2020/07/16/vs-razor-editor.aspx) - July 16, 2020 - The latest preview of Visual Studio 2019 16.7 adds an experimental Razor editor for working with Blazor, boosting web development with C#/.NET instead of JavaScript.
* [New experimental Razor editor for Visual Studio](https://devblogs.microsoft.com/aspnet/new-experimental-razor-editor-for-visual-studio/) - July 15, 2020 - With the release of Visual Studio 2019 16.7 Preview 4, you can now try out our new experimental Razor editor for local development with MVC, Razor Pages, and Blazor.
* [Blazor and Dragons: How to consume gRPC-web from Blazor](https://dev.to/mizrael/blazor-and-dragons-how-to-consume-grpc-web-from-blazor-5d59) - July 14, 2020 - Blazor and Dragons: how to consume gRPC-web from Blazor.
* [How to Build a CORS Proxy for Client-side Blazor](https://darnton.co.nz/2020/07/13/cors-proxy-for-client-side-blazor/) - July 13, 2020 - How to Build a CORS Proxy for Client-side Blazor.
* [V-Drum Explorer: Blazor and the Web MIDI API](https://codeblog.jonskeet.uk/2020/07/12/v-drum-explorer-blazor-and-the-web-midi-api/) - July 12, 2020 - Blazor and the [Web MIDI API](https://www.w3.org/TR/webmidi/), a way of accessing local MIDI devices from a browser. [Source code](https://github.com/jskeet/DemoCode/tree/master/Drums) ![stars](https://img.shields.io/github/stars/jskeet/DemoCode?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/jskeet/DemoCode?style=flat-square&cacheSeconds=86400). [Documentation](https://jskeet.github.io/DemoCode/Drums/).
* [Getting Started with Mobile Blazor Bindings](https://wellsb.com/csharp/xamarin/getting-started-mobile-blazor-bindings/) - July 9, 2020 - This is the first in a tutorial series about developing native Android and iOS apps using Xamarin and Blazor. This lesson will help you set up your development environment.
* [How to send an SMS with Blazor](https://www.nexmo.com/blog/2020/07/08/how-to-send-an-sms-with-blazor) - July 8, 2020 - This article covers how to send an SMS using Blazor and the [Vonage SMS API](https://developer.nexmo.com/messaging/sms/overview). [Source code](https://github.com/nexmo-community/send-an-sms-with-blazor) ![stars](https://img.shields.io/github/stars/nexmo-community/send-an-sms-with-blazor?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/nexmo-community/send-an-sms-with-blazor?style=flat-square&cacheSeconds=86400).
* [Securing a Blazor WebAssembly application with Azure Active Directory](https://medium.com/@waelkdouh/securing-a-blazor-webassembly-application-with-azure-active-directory-7822148f332b) - July 7, 2020 - Securing a Blazor WebAssembly application with Azure Active Directory. [Source code](https://github.com/waelkdouh/BlazorWebAssemblyAADImplicitGrantFlow) ![stars](https://img.shields.io/github/stars/waelkdouh/BlazorWebAssemblyAADImplicitGrantFlow?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/waelkdouh/BlazorWebAssemblyAADImplicitGrantFlow?style=flat-square&cacheSeconds=86400).
* [Custom validation logic on client AND server with Blazor](https://jonhilton.net/blazor-client-server-validation-with-fluentvalidation/) - July 7, 2020 - Custom validation logic on client AND server with Blazor.
* [Conway's Game of Life (With Emojis!) in C# and Blazor WebAssembly](https://exceptionnotfound.net/conways-game-of-life-with-emojis-in-csharp-and-blazor-webassembly/) - July 6, 2020 - Conway's Game of Life (With Emojis!) in C# and Blazor WebAssembly. [Code source](https://github.com/exceptionnotfound/BlazorGames) ![stars](https://img.shields.io/github/stars/exceptionnotfound/BlazorGames?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/exceptionnotfound/BlazorGames?style=flat-square&cacheSeconds=86400).
* [The .NET Stacks #6](https://daveabrock.com/2020/07/05/dotnet-stacks-6) - July 5, 2020 - A rundown on mobile Blazor bindings, EF updates, ASP.NET Core A-Z, and more.
* [Understanding about Cascading Values and Cascading Parameters in Blazor](https://justdebug.net/blazor/understanding-about-cascading-values-and-cascading-parameters-in-blazor/) - July 4, 2020 - Understanding about Cascading Values and Cascading Parameters in Blazor. [Source code](https://github.com/rahul230691/Blazor-Cascading-Values-and-Cascading-Parameters) ![stars](https://img.shields.io/github/stars/rahul230691/Blazor-Cascading-Values-and-Cascading-Parameters?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/rahul230691/Blazor-Cascading-Values-and-Cascading-Parameters?style=flat-square&cacheSeconds=86400).
* [Understanding about Cascading Values and Cascading Parameters in Blazor](https://justdebug.net/blazor/understanding-about-cascading-values-and-cascading-parameters-in-blazor/) - July 4, 2020 - Understanding about Cascading Values and Cascading Parameters in Blazor.
* [Blazor WebAssembly HttpClient – Consuming Web API](https://code-maze.com/blazor-webassembly-httpclient/) - July 3, 2020 - This article from Code Maze covers the Blazor WebAssembly HttpClient and how to use it to fetch data from the ASP.NET Core Web API server.
* [Go faster with your own re-usable Blazor components](https://jonhilton.net/build-your-own-re-usable-blazor-components/) - June 30, 2020 - Go faster with your own re-usable Blazor components.
* [Creating a Custom Validation Message Component for Blazor Forms](https://chrissainty.com/creating-a-custom-validation-message-component-for-blazor-forms/) - June 30, 2020 - Creating a Custom Validation Message Component for Blazor Forms, by Chris Sainty.
* [Blazor Upload File to Azure Blob Storage](https://wellsb.com/csharp/aspnet/blazor-upload-file-azure-blob-storage/) - June 29, 2020 - Blazor Upload File to Azure Blob Storage, by Bradley Wells.
* [Deploying a .NET Core Blazor App to Netlify using GitHub Actions](https://exceptionnotfound.net/deploying-a-net-core-blazor-app-to-netlify-using-github-actions/) - June 29, 2020 - Deploying a .NET Core Blazor App to Netlify using GitHub Actions.
* [Hosting both Blazor Server and WebAssembly in single website](http://www.duracellko.net/posts/2020/06/hosting-both-blazor-server-and-webassembly) - June 27, 2020 - Hosting both Blazor Server and WebAssembly in single website.
* [State Management with Blazor using Fluxor](https://betweentwobrackets.dev/posts/2020/06/state-management-with-blazor-using-fluxor-part-1/) - June 26, 2020 - Implementing the flux spec with Fluxor for Blazor applications. [Source code](https://github.com/JoeyMckenzie/StateManagementWithFluxor/tree/feature/todos-part-1) ![stars](https://img.shields.io/github/stars/JoeyMckenzie/StateManagementWithFluxor?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/JoeyMckenzie/StateManagementWithFluxor?style=flat-square&cacheSeconds=86400).
* [ASP.NET Core updates in .NET 5 Preview 6](https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-5-preview-6/) - June 25, 2020 - .NET 5 Preview 6 is now available and is ready for evaluation. Here’s what’s new in this release: Blazor WebAssembly template now included, JSON extension methods for HttpRequest and HttpResponse, extension method to allow anonymous access to an endpoint, custom handling of authorization failures and SignalR Hub filters.
* [Blazor WebAssembly Template Lands in .NET 5 Preview 6](https://visualstudiomagazine.com/articles/2020/06/25/net-5-blazor-template.aspx) - June 25, 2020 - Blazor WebAssembly Template Lands in .NET 5 Preview 6, by David Ramel on Visual Studio Magazine.
* [Convert DateTime to user's time zone with server-side Blazor](https://www.meziantou.net/convert-datetime-to-user-s-time-zone-with-server-side-blazor.htm) - June 25, 2020 - Convert DateTime to user's time zone with server-side Blazor.
* [State Management and Error Recovery in Blazor WebAssembly](http://www.dotnet-programming.com/post/2020/06/24/State-Management-and-Error-Recovery-in-Blazor-WebAssembly-part-2.aspx) - June 24, 2020 - Centralized state management with serialization in localStorage when application crashes or user leaves the application. [Source code](https://github.com/frankabbruzzese/StateManagement).
* [Learn how you manage routing in Blazor for .NET Core and VS Code](https://softchris.github.io/pages/dotnet-blazor-routing.html) - June 24, 2020 - Learn how you manage routing in Blazor for .NET Core and VS Code. [on Chris Noring's blog](https://softchris.github.io/pages/dotnet-blazor-routing.html). [on Dev.to](https://dev.to/dotnet/learn-how-you-manage-routing-in-blazor-for-net-core-and-vs-code-4m2e).
* [Telerik UI for Blazor 2.15.0](https://www.telerik.com/blogs/telerik-ui-for-blazor-2-15-0-new-buttongroup-togglebutton-grid-updates-more) - June 24, 2020 - Telerik UI for Blazor 2.15.0 includes new ButtonGroup, ToggleButton, Grid Updates and more.
* [Move Over, JSON, Here's gRPC-Web for .NET (& Blazor)](https://visualstudiomagazine.com/articles/2020/06/23/grpc-web-for-net.aspx) - June 23, 2020 - Move Over, JSON, Here's gRPC-Web for .NET (& Blazor) by David Ramel, on Visual Studio Magazine.
* [3+1 ways to manage state in your Blazor application](https://jonhilton.net/blazor-state-management/) - June 23, 2020 - 3+1 ways to manage state in your Blazor application.
* [Partial Classes, RenderFragment and Lifecycle in Blazor WebAssembly](https://code-maze.com/partial-classes-renderfragment-lifecycle-blazor-wasm/) - June 22, 2020 - Partial Classes, RenderFragment and Lifecycle in Blazor WebAssembly. [Source code](https://github.com/CodeMazeBlog/blazor-series/tree/Branch_blazor-webassembly-partial-classes-renderfragment-lifecycle) ![stars](https://img.shields.io/github/stars/CodeMazeBlog/blazor-series?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/CodeMazeBlog/blazor-series?style=flat-square&cacheSeconds=86400). This article is part of the [Blazor series](https://code-maze.com/blazor-webassembly-series/).
* [Creating a Repeater component with Blazor](https://www.meziantou.net/creating-a-repeater-component-with-blazor.htm) - June 22, 2020 - If you are familiar with the old ASP.NET, you know the <asp:Repeater> control, a control that iterates on a collection (may comes from any kind of DataSource) and use a template to generate the page. This article shows how to create a control like that with Blazor.
* [Setting the Page Title in a Blazor App](https://exceptionnotfound.net/setting-the-page-title-in-a-blazor-app-net-core) - June 22, 2020 - Let's set the page title using a Blazor component and a bit of JavaScript.
* [Build an Azure AD Secured Blazor Server Line of Business App](https://blog.jeremylikness.com/blog/build-a-blazor-server-azure-ad-secured-lob-app) - June 20, 2020 - Build an Azure AD Secured Blazor Server Line of Business App. [Source code](https://github.com/JeremyLikness/BlazorServerEFCoreExample) ![stars](https://img.shields.io/github/stars/JeremyLikness/BlazorServerEFCoreExample?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/JeremyLikness/BlazorServerEFCoreExample?style=flat-square&cacheSeconds=86400).
* [How to utilize gRPC-Web from a Blazor WebAssembly application](https://medium.com/@waelkdouh/how-to-utilize-grpc-web-from-a-blazor-webassembly-application-e8313444f75b) - June 19, 2020 - How to utilize gRPC-Web from a Blazor WebAssembly application. [Source code](https://github.com/waelkdouh/gRPC-Web) ![stars](https://img.shields.io/github/stars/waelkdouh/gRPC-Web?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/waelkdouh/gRPC-Web?style=flat-square&cacheSeconds=86400).
* [7 Things to Enjoy in MAUI](https://www.telerik.com/blogs/7-things-to-enjoy-maui-and-dotnet-maui) - June 19, 2020 - .NET Multi-platform App UI (MAUI) is the next evolution of cross-platform UI solution for .NET developers. Just like the island, MAUI will have plenty to offer for developers. Let's explore the promise of .NET MAUI.
* [Minesweeper in Blazor WebAssembly Part 2: The Blazor Component](https://exceptionnotfound.net/minesweeper-in-blazor-webassembly-part-2-the-blazor-component/) - June 18, 2020 - Let's build a Blazor Component so we can play Minesweeper with it.
* [Hosting Blazor Web Assembly App on Azure Static Web App](https://devkimchi.com/2020/06/17/hosting-blazor-web-assembly-app-on-azure-static-webapp/) - June 17, 2020 - Hosting Blazor Web Assembly App on Azure Static Web App.
* [Minesweeper in Blazor WebAssembly Part 1: C# Implementation](https://exceptionnotfound.net/minesweeper-in-blazor-webassembly-part-1-csharp-implementation) - June 15, 2020 - Let's build the computer game Minesweeper using C# and Blazor WebAssembly. [Source code](https://github.com/exceptionnotfound/BlazorGames) ![stars](https://img.shields.io/github/stars/exceptionnotfound/BlazorGames?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/exceptionnotfound/BlazorGames?style=flat-square&cacheSeconds=86400).
* [Build a Blazor WebAssembly line of business app part 1: Intro and data access](https://blog.jeremylikness.com/blog/build-a-blazor-webassembly-line-of-business-app/) - June 13, 2020 - Build a Blazor WebAssembly line of business app part 1: Intro and data access. [Source code](https://github.com/JeremyLikness/BlazorWasmEFCoreExample) ![stars](https://img.shields.io/github/stars/JeremyLikness/BlazorWasmEFCoreExample?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/JeremyLikness/BlazorWasmEFCoreExample?style=flat-square&cacheSeconds=86400).
* [Secure Stripe Checkout with Blazor JSInterop](https://wellsb.com/csharp/aspnet/secure-stripe-checkout-blazor-jsinterop/) - June 12, 2020 - Secure Stripe Checkout with Blazor JSInterop. [Source code](https://github.com/bradwellsb/blazor-stripe) ![stars](https://img.shields.io/github/stars/bradwellsb/blazor-stripe?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/bradwellsb/blazor-stripe?style=flat-square&cacheSeconds=86400).
* [Blazor vs React](https://www.telerik.com/blogs/blazor-vs-react-web-developers) - June 9, 2020 - A comparison of Blazor and React when it comes to modern web development—a review of the pros and cons.
* [Blazor UI Components - An Update with New Controls & Features, and Blazor Reports! (available in v20.1)](https://community.devexpress.com/blogs/aspnet/archive/2020/06/09/blazor-ui-components-official-release-with-new-controls-amp-features-and-blazor-reports-available-in-v20-1.aspx) - June 9, 2020 - Blazor UI Components - An Update with New Controls & Features, and Blazor Reports! (available in v20.1).
* [Avoiding AccessTokenNotAvailableException when using the Blazor WebAssembly Hosted template with individual user accounts](https://chrissainty.com/avoiding-accesstokennotavailableexception-when-using-blazor-webassembly-hosted-template-with-individual-user-accounts/) - June 9, 2020 - Avoiding AccessTokenNotAvailableException when using the Blazor WebAssembly Hosted template with individual user accounts.
* [How to detect unsupported browsers under a Blazor WebAssembly application?](https://medium.com/@waelkdouh/how-to-detect-unsupported-browsers-under-a-blazor-webassembly-application-bc11ab0ee015) - June 8, 2020 - How to detect unsupported browsers under a Blazor WebAssembly application?
* [Blazor vs. React / Angular / Vue.js](https://christianfindlay.com/2020/06/04/blazor-vs-react-angular-vue-js/) - June 4, 2020 - Blazor is a new Microsoft technology that allows developers to write code for browsers in C#. This article compares Blazor to three other common SPA frameworks: React, Angular, and Vue.js.
* [Adding React UI components to Blazor Web Assembly app](https://devkimchi.com/2020/06/03/adding-react-components-to-blazor-webassembly-app/) - June 3, 2020 - Adding React UI components to Blazor Web Assembly app.
* [Custom connection details display](https://codyanhorn.tech/blog/blazor/2020/06/03/Blazor-Custom-Connection-Details-Display.html) - June 3, 2020 - Custom connection details display.
* [Blazor How-Tos: create a chat application - part 1: Introduction](https://dzone.com/articles/blazor-how-tos-create-a-chat-application-part-1-in) - June 1, 2020 - Blazor How-Tos: create a chat application - part 1: Introduction. [Source code](https://github.com/mizrael/BlazorChat) ![stars](https://img.shields.io/github/stars/mizrael/BlazorChat?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/mizrael/BlazorChat?style=flat-square&cacheSeconds=86400).
* [Introducing Blazor WebAssembly – a client-side alternative to JavaScript](https://www.grapecity.com/blogs/working-with-blazor-webassembly-clientside-dotnet-in-a-browser) - May 29, 2020 - Introducing Blazor WebAssembly – a client-side alternative to JavaScript.
* [The best samples to teach yourself Blazor](https://medium.com/young-coder/the-best-samples-to-teach-yourself-blazor-4d29cec607f5) - May 27, 2020 - The best samples to teach yourself Blazor. Now that Microsoft’s C#-in-a-browser platform is an official release, it’s safe to dig in.
* [Announcing Experimental Mobile Blazor Bindings May update](https://devblogs.microsoft.com/aspnet/announcing-experimental-mobile-blazor-bindings-may-update/) - May 26, 2020 - Announcing Experimental Mobile Blazor Bindings May update.
* [Blazor news from Build 2020](https://chrissainty.com/blazor-news-from-build-2020/) - May 26, 2020 - Blazor news from Build 2020.
* [Azure AD Secured Serverless Cosmos DB from Blazor WebAssembly](https://blog.jeremylikness.com/blog/azure-ad-secured-serverless-cosmosdb-from-blazor-webassembly) - May 25, 2020 - Azure AD Secured Serverless Cosmos DB from Blazor WebAssembly, an authentic look at static sites with dynamic attitudes.
* [Using Blazor WebAssembly and C# to build Tic-Tac-Toe in .NET Core](https://exceptionnotfound.net/using-blazor-webassembly-and-csharp-to-play-tic-tac-toe-in-dotnet-core) - May 25, 2020 - Let's build the classic kids' game using Blazor, C#,and .NET Core! As always, there's a sample project included.
* [Realtime update with Blazor Wasm Signalr and Mediatr](https://remibou.github.io/Realtime-update-with-Blazor-WASM-SignalR-and-MediatR/) - May 24, 2020 - Realtime update with Blazor Wasm Signalr and Mediatr.
* [How to create Blazor components with custom JavaScript and CSS in the components library and properly consume them from WebAssembly application](https://romansimuta.com/posts/how-to-create-blazor-components-with-custom-javascript-and-css-in-the-components-library-and-properly-consume-them-from-webassembly-application/) - May 24, 2020 - How to create Blazor components with custom JavaScript and CSS in the components library and properly consume them from WebAssembly application.
* [Next for Blazor: AOT for 'Massive Speed Gains'](https://visualstudiomagazine.com/articles/2020/05/22/blazor-future.aspx) - May 23, 2020 - Next for Blazor: AOT for 'Massive Speed Gains', from Visual Studio Magazine.
* [Writing Applications, Not Web Sites, in Microsoft Blazor](https://medium.com/swlh/writing-applications-not-web-sites-in-microsoft-blazor-5f123b17cb05) - May 23, 2020 - Let’s examine the possibilities of creating an application with Blazor instead of a SPA based website.
* [Microsoft Build 2020 – Highlights](https://csharp.christiannagel.com/2020/05/21/build2020/) - May 21, 2020 - This Microsoft Build 2020 conference was very different from all the previous ones as a digital experience event because of the COVID-19 Coronavirus. Microsoft made it a great experience – with announcements on Microsoft Azure, .NET 5, Windows, and more.
* [Chatting about Blazor UI Controls with Microsoft at the Build Post Show](https://www.grapecity.com/blogs/chatting-about-blazor-ui-controls-with-microsoft-build) - May 20, 2020 - Chatting about Blazor UI Controls with Microsoft at the Build Post Show.
* [ASP.NET Core Blazor with SignalR breaks when used with Cloudflare's HTML minification](https://zimmergren.net/solved-asp-net-core-blazor-web-sites-does-not-work-with-cloudflare-html-minification/) - May 20, 2020 - ASP.NET Core Blazor with SignalR breaks when used with Cloudflare's HTML minification.
* [Hosting Blazor WebAssembly in Azure Static Web Apps (Preview)](https://timheuer.com/blog/hosting-blazor-in-azure-static-web-apps/) - May 19, 2020 - Hosting Blazor WebAssembly in Azure Static Web Apps (Preview).
* [Blazor WebAssembly 3.2.0 now available](https://devblogs.microsoft.com/aspnet/blazor-webassembly-3-2-0-now-available/) - May 19, 2020 - Blazor WebAssembly 3.2.0 now available.
* [Using three.js with ASP.NET Core Blazor Server application](https://romansimuta.com/posts/using-three-js-with-asp-net-core-blazor-server-application/) - May 19, 2020 - Using three.js with ASP.NET Core Blazor Server application. [Source code](https://github.com/simutaroman/Blazor3D) ![last commit](https://img.shields.io/github/last-commit/simutaroman/Blazor3D?style=flat-square&cacheSeconds=86400).
* [Blazor finally complete as WebAssembly joins server-side component](https://visualstudiomagazine.com/articles/2020/05/19/blazor-webassembly-3-2.aspx) - May 19, 2020 - Blazor finally complete as WebAssembly joins server-side component.
* [EF Core and Cosmos DB with Blazor WebAssembly](https://blog.jeremylikness.com/blog/ef-core-and-cosmosdb-with-blazor-webassembly) - May 14, 2020 - EF Core and Cosmos DB with Blazor WebAssembly.
* [Blazor interview questions and answer](https://tutorialslink.com/Articles/Blazor-Interview-Questions-and-Answer/1413) - May 14, 2020 - Blazor interview questions and answer.
* [Building a Progressive Web App with Blazor](https://devblogs.microsoft.com/visualstudio/building-a-progressive-web-app-with-blazor/) - May 13, 2020 - Building a Progressive Web App with Blazor.
* [Telerik UI for Blazor: 40+ Native Components with Telerik R2 2020 Release](https://www.telerik.com/blogs/telerik-ui-for-blazor-40-native-components-telerik-r2-2020-release) - May 13, 2020 - Telerik UI for Blazor: 40+ Native Components with Telerik R2 2020 Release.
* [Unit Testing Blazor Components with bUnit and JustMock](https://www.telerik.com/blogs/unit-testing-blazor-components-bunit-justmock) - May 11, 2020 - Unit Testing Blazor Components with bUnit and JustMock.
* [Auto saving form data in Blazor](https://chrissainty.com/auto-saving-form-data-in-blazor/) - May 5, 2020 - Auto saving form data in Blazor.
* [Attach Blazor to Azure IoT Edge routing, showing live message feed](https://sandervandevelde.wordpress.com/2020/05/03/attach-blazor-to-azure-iot-edge-routing-showing-live-message-feed/) - May 3, 2020 - Attach Blazor to Azure IoT Edge routing, showing live message feed.
* [Blazor WebAssembly 3.2.0 Release Candidate now available](https://devblogs.microsoft.com/aspnet/blazor-webassembly-3-2-0-release-candidate-now-available) - April 30, 2020 - Blazor WebAssembly 3.2.0 Release Candidate now available. The Blazor WebAssembly Release Candidate is here! This release contains all of the features and improvements that we expect to release for the upcoming Blazor WebAssembly release. There are no more breaking changes planned at this point.
* [Quickly transform any mockup or design into a working Blazor prototype](https://jonhilton.net/build-anything-using-blazor-components/) - April 29, 2020 - Quickly transform any mockup or design into a working Blazor prototype.
* [Copy to Clipboard in Blazor](https://chrissainty.com/copy-to-clipboard-in-blazor/) - April 29, 2020 - Copy to Clipboard in Blazor.
* [Stripe customer credit card payment with Blazor](https://wellsb.com/csharp/aspnet/stripe-customer-credit-card-payment-with-blazor/) - April 27, 2020 - In the [previous tutorial](https://wellsb.com/csharp/aspnet/stripe-connect-express-and-blazor/), you learned how to link a Stripe Connect account with a local user store in a Blazor application. If, instead, you need a way to collect payment information from your customers, this tutorial will help you understand the Stripe customer flow. [Source code](https://github.com/bradwellsb/blazor-stripe).
* [Blazor WebAssembly 3.2.0 Preview 5 release now available](https://devblogs.microsoft.com/aspnet/blazor-webassembly-3-2-0-preview-5-release-now-available/) - April 23, 2020 - Blazor WebAssembly 3.2.0 Preview 5 release now available.
* [CSS is hard, Blazor and Tailwind CSS makes it easier](https://jonhilton.net/re-usable-components-with-blazor-and-tailwind-css/) - April 22, 2020 - CSS is hard, Blazor and Tailwind CSS makes it easier.
* [Telerik UI for Blazor 2.11.0](https://www.telerik.com/blogs/telerik-ui-for-blazor-2-11-0-grid-features-scheduler-improvements-wasm-3-2-0-preview-4-more) - April 22, 2020 - Telerik UI for Blazor 2.11.0: New Grid Features, Scheduler Improvements, Wasm 3.2.0 Preview 4 and More.
* [Mobile Blazor Bindings - Navigation and Xamarin Essentials](https://chrissainty.com/mobile-blazor-bindings-xamarin-essentials/) - April 21, 2020 - Mobile Blazor Bindings - Navigation and Xamarin Essentials.
* [Playing audio files in a Blazor application](http://www.appvnext.com/blog/2020/4/20/playing-audio-files-in-a-blazor-application) - April 20, 2020 - Playing audio files in a Blazor application.
* [Stripe Connect Express and Blazor](https://wellsb.com/csharp/aspnet/stripe-connect-express-and-blazor/) - April 20, 2020 - Stripe Connect Express and Blazor. [Source code](https://github.com/bradwellsb/blazor-stripe).
* [Blazor WebAssembly 3.2.0 Preview 4 release now available](https://devblogs.microsoft.com/aspnet/blazor-webassembly-3-2-0-preview-4-release-now-available/) - April 16, 2020 - Blazor WebAssembly 3.2.0 Preview 4 release now available.
* [Debugging problems persist in Blazor WebAssembly 3.2 Preview 4](https://visualstudiomagazine.com/articles/2020/04/16/blazor-preview-4.aspx) - April 16, 2020 - Debugging problems persist in Blazor WebAssembly 3.2 Preview 4.
* [Mobile Blazor Bindings - State Management and Data](https://chrissainty.com/mobile-blazor-bindings-state-management-and-data/) - April 14, 2020 - Mobile Blazor Bindings - State Management and Data.
* [Stripe.NET Create Stripe Webhooks Receiver](https://wellsb.com/csharp/aspnet/stripe-net-create-stripe-webhooks-receiver/) - April 13, 2020 - Stripe.NET Create Stripe Webhooks Receiver.
* [Blazor: Handling 404s with IIS](https://medium.com/@jonny.ollifflee/blazor-handling-404s-with-iis-666920a4a60) - April 9, 2020 - Blazor: Handling 404s with IIS.
* [Top 3 Blazor Extensions for Visual Studio Code](https://visualstudiomagazine.com/articles/2020/04/08/vs-code-blazor.aspx) - April 8, 2020 - Some developers prefer to create applications with Microsoft's open-source Blazor tooling from within the open-source, cross-platform Visual Studio Code editor. Here are the top tools in the VS Code Marketplace for those folk, as measured by the number of installations.
* [Mobile Blazor Bindings - Layout and Styling](https://chrissainty.com/mobile-blazor-bindings-layout-and-styling/) - April 7, 2020 - Second post in the series: Mobile Blazor Bindings for Web Developers by Chris Sainty.
* [Securing Blazor WebAssembly with Identity Server 4](https://levelup.gitconnected.com/securing-blazor-webassembly-with-identity-server-4-ee44aa1687ef) - April 6, 2020 - Securing Blazor WebAssembly with Identity Server 4.
* [Mobile Blazor Bindings - Getting Started](https://chrissainty.com/getting-started-with-mobile-blazor-bindings/) - April 1, 2020 - Introduction by Chris Sainty to the Mobile Blazor Bindings (MBB) project, what it is, why you might be interesting in trying it, what is and isn't available and we'll finish with creating our first app.
* [Routing in Blazor Apps](https://devblogs.microsoft.com/premier-developer/routing-in-blazor-apps/) - March 30, 2020 - In this post, App Dev Manager Billy Sun compares routing of popular web frameworks and Blazor.
* [Updating JSON Validate to Blazor 3.2.0 Preview 3](https://dev.to/marcusturewicz/updating-json-validate-to-blazor-3-2-0-preview-3-59oa) - March 29, 2020 - Updating JSON Validate to Blazor 3.2.0 Preview 3.
* [Blazor WebAssembly Marches On to GA: Now Debug from Visual Studio, VS Code](https://visualstudiomagazine.com/articles/2020/03/27/blazor-debugging.aspx) - March 27, 2020 - Blazor WebAssembly Marches On to GA: Now Debug from Visual Studio, VS Code, on Visual Studio Magazine.
* [Blazor WebAssembly 3.2.0 Preview 3 release now available](https://devblogs.microsoft.com/aspnet/blazor-webassembly-3-2-0-preview-3-release-now-available/) - March 26, 2020 - Official post from Microsoft, by Dan Roth. Blazor WebAssembly 3.2.0 Preview 3 release now available.
* [Adventures with Blazor: my first component, a busy button](http://www.mattruma.com/adventures-with-blazor-my-first-component-a-busy-button/) - March 26, 2020 - Adventures with Blazor: my first component, a busy button.
* [Mocking Injected Types in Blazor](https://magenic.com/thinking/mocking-injected-types-in-blazor) - March 26, 2020 - Mocking Injected Types in Blazor.
* [Working with Query Strings in Blazor](https://chrissainty.com/working-with-query-strings-in-blazor/) - March 25, 2020 - This post covers how to deal with Query Strings in Blazor.
* [Why you should use Blazor over JavaScript Frameworks](https://www.telerik.com/blogs/why-you-should-use-blazor-over-javascript-frameworks-to-build-your-single-page-application) - March 24, 2020 - Why you should use Blazor over JavaScript Frameworks to build your single-page application.
* [Replacing AJAX calls in Razor Pages with Razor Components and Blazor](https://andrewlock.net/replacing-ajax-calls-in-razor-pages-using-razor-components-and-blazor/) - March 24, 2020 - Replacing AJAX calls in Razor Pages with Razor Components and Blazor.
* [Introduction to .NET 5 for ASP.NET Developers](http://www.binaryintellect.net/articles/567c6c06-a2aa-44da-a443-78dafedebe65.aspx) - March 23, 2020 - Introduction to .NET 5 for ASP.NET Developers.
* [How To Keep Js Object Reference In Blazor](https://remibou.github.io/How-to-keep-js-object-reference-in-Blazor/) - March 21, 2020 - How to keep Javascript object reference in Blazor on .NET side?
* [Using Highcharts with Blazor](http://engstromjimmy.se/post/2020-03-21-UsingHighchartsWithBlazor) - March 21, 2020 - Using Highcharts with Blazor.
* [CSS live reloading on Blazor](https://dev.to/j_sakamoto/css-live-reloading-on-blazor-27nc) - March 20, 2020 - CSS live reloading on Blazor.
* [Unifying .NET 5 arrives in Preview 1](https://visualstudiomagazine.com/articles/2020/03/17/net-5-preview.aspx) - March 17, 2020 - Microsoft released .NET 5 Preview 1, the first iteration of what will become one framework to handle all .NET development projects.
* [Blazor - Reload the browser on disconnect](http://engstromjimmy.se/post/2020-03-14-ReloadBlazor%20-%20Copy) - March 14, 2020 - Blazor - Reload the browser on disconnect.
* [The Open Source Project that Wants to Reboot Silverlight](https://medium.com/young-coder/the-open-source-project-that-wants-to-reboot-silverlight-74817b430ee7) - March 13, 2020 - OpenSilver uses impressive tech to run Microsoft’s stone-dead app platform, Silverlight.
* [Blazor WebAssembly 3.2.0 Preview 2 release now available](https://devblogs.microsoft.com/aspnet/blazor-webassembly-3-2-0-preview-2-release-now-available/) - March 11, 2020 - Blazor WebAssembly 3.2.0 Preview 2 release now available, by Daniel Roth from Microsoft.
* [Blazor WebAssembly tackles progressive web apps](https://visualstudiomagazine.com/articles/2020/03/11/blazor-pwa.aspx) - March 11, 2020 - Blazor WebAssembly tackles progressive web apps, by David Ramel for Visual Studio Magazine.
* [New Blazor and CSLA .NET Book](https://blog.lhotka.net/2020/03/11/New-Blazor-and-CSLA-Book) - March 11, 2020 - New Blazor and CSLA .NET Book. [Link to buy it](https://store.lhotka.net/using-csla-5-blazor-and-webassembly).
* [Blazor Shopping Cart Sample using Local Storage to Persist State](http://www.appvnext.com/blog/2020/3/7/blazor-shopping-cart-sample-using-local-storage-to-persist-state) - March 10, 2020 - Blazor Shopping Cart Sample using Local Storage to Persist State, by Carl Franklin.
* [Open Source Silverlight replacement powered by WebAssembly debuts](https://visualstudiomagazine.com/articles/2020/03/09/opensilver.aspx) - March 9, 2020 - Open Source Silverlight replacement powered by WebAssembly debuts.
* [Event Aggregator for Blazor updated to 2.0.0](https://mikaelkoskinen.net/post/blazor-eventaggregator-2-0-0-auto-refresh) - March 8, 2020 - Event Aggregator for Blazor updated to 2.0.0.
* [Blazor WASM Debugging Planned for Visual Studio](https://visualstudiomagazine.com/articles/2020/03/03/vs-roadmap.aspx?m=1) - March 3, 2020 - Blazor WASM Debugging Planned for Visual Studio, on Visual Studio Magazine.
* [Integrating Tailwind CSS with Blazor using Gulp - Part 2](https://chrissainty.com/integrating-tailwind-css-with-blazor-using-gulp-part-2/) - March 3, 2020 - Integrating Tailwind CSS with Blazor using Gulp - Part 2.
* [What's the Difference Between Blazor vs Razor](https://www.telerik.com/blogs/difference-between-blazor-vs-razor) - March 2, 2020 - What is Razor? How does it relate to Blazor, and which should you be using? Learn the difference between Blazor and Razor and how to use them in your web applications.
* [Re-Using Angular Components In A Blazor WebAssembly Application Using Angular Elements](https://www.thinktecture.com/en/blazor/integration-angular-elements-web-components) - March 2, 2020 - Re-Using Angular Components In A Blazor WebAssembly Application Using Angular Elements - Web Components Custom Elements.
* [How to send callback method to JSInterop in Blazor?](https://remibou.github.io/How-to-send-callback-to-JS-Interop-in-Blazor/) - February 29, 2020 - How to send callback method to JSInterop in Blazor?
* [Yet another way to changing the page title in Blazor, and more](https://dev.to/j_sakamoto/yet-another-way-to-changing-the-page-title-in-blazor-and-more-43k) - February 2020, 27 - Yet another way to changing the page title in Blazor, and more.
* [GitHub Project Provides 300-Plus Samples of ASP.NET Core/Blazor Fundamentals](https://visualstudiomagazine.com/articles/2020/02/27/aspnet-core-fundamentals.aspx) - February 27, 2020 - A GitHub project providing more than 300 code samples to illustrate ASP.NET Core fundamentals has amassed more than 4,100 stars.
* [Organizing and Naming Components in Blazor](https://mariomucalo.com/organizing-and-naming-components-in-blazor/) - February 27, 2020 - Organizing and Naming Components in Blazor.
* [What’s behind the hype about Blazor?](https://stackoverflow.blog/2020/02/26/whats-behind-the-hype-about-blazor/) - February 26, 2020 - Blazor is a new client-side UI framework from the ASP.NET team. Its big selling point is the ability to write rich web UI experiences using HTML, CSS, and C# instead of JavaScript—something a lot of developers have been dreaming of. By Chris Sainty.
* [Use Blazor and C# to host a static website in Azure Storage](https://dev.to/azure/use-blazor-and-c-to-host-a-static-website-in-azure-storage-b1d) - February 24, 2020 - Use Blazor and C# to host a static website in Azure Storage by Michael Crump.
* [From WebForms to Blazor?](https://jonhilton.net/migrate-webforms-to-blazor/) - February 24, 2020 - From WebForms to Blazor?.
* [Blazor live reload preview](https://medium.com/@MartinPocius/blazor-live-reload-preview-4505015fd589) - February 23, 2020 - In react we have hot module replacement this feature allows us to change code and see changes immediately in your browser. We can make a similar feature in blazor using Roslyn compiler. Compiling down razor components in runtime and serving with WebSockets on every file change using file watcher. [Source code](https://github.com/martasp/BlazorLiveReload).
* [TeeChart for .NET with Razor and Blazor under Net.Core 3](http://steema.com/wp/blog/2020/02/20/teechart-for-net-with-razor-and-blazor-under-net-core-3/) - February 20, 2020 - TeeChart for .NET with Razor and Blazor under Net.Core 3.
* [Hundreds of practical ASP.NET Core samples to learn the fundamentals](https://www.hanselman.com/blog/HundredsOfPracticalASPNETCoreSamplesToLearnTheFundamentals.aspx) - February 19, 2020 - Hundreds of practical ASP.NET Core samples to learn the fundamentals, and there are great samples about Blazor.
* [Is Blazor For Everyone?](http://www.appvnext.com/blog/2020/2/18/is-blazor-for-everyone) - February 18, 2020 - Is Blazor For Everyone?, by Carl Franklin.
* [Hosting a Blazor App in WinUI 3 with WebView2 and call a Blazor Component Method from WinUI](https://www.thomasclaudiushuber.com/2020/02/18/hosting-blazor-app-in-winui-3-with-webview-2-and-call-blazor-component-method-from-winui/) - February 18, 2020 - Hosting a Blazor App in WinUI 3 with WebView2 and call a Blazor Component Method from WinUI.
* [Running Your ASP.NET Core Blazor WebAssembly Application As A Progressive Web App (PWA)](https://www.thinktecture.com/en/blazor/progressive-web-apps-pwa) - February 18, 2020 - Running Your ASP.NET Core Blazor WebAssembly Application As A Progressive Web App (PWA).
* [Integrating Tailwind CSS with Blazor using Gulp - Part 1](https://chrissainty.com/integrating-tailwind-css-with-blazor-using-gulp-part-1/) - February 18, 2020 - Integrating Tailwind CSS with Blazor using Gulp - Part 1.
* [Splitting a monolith reporting web app with Blazor](https://www.grapecity.com/blogs/splitting-monolith-reporting-web-app-with-blazor) - February 18, 2020 - Splitting a monolith reporting web app with Blazor.
* [Dashboard for Blazor - How to use Web Dashboard within your Blazor Apps](https://community.devexpress.com/blogs/analytics/archive/2020/02/17/dashboard-for-blazor-how-to-use-web-dashboard-within-your-blazor-apps.aspx) - February 17, 2020 - Dashboard for Blazor - How to use Web Dashboard within your Blazor Apps, by DevExpress. This post covers how to integrate the [HTML JavaScript Dashboard](https://docs.devexpress.com/Dashboard/119108/designer-and-viewer-applications/web-dashboard/html-javascript-dashboard-control) into a Blazor applications and focus on integration details and create a sample dashboard application as well.
* [Creating a multi-language translator using Blazor and Azure Cognitive Services](https://www.c-sharpcorner.com/article/creating-a-multi-language-translator-using-blazor-and-azure-cognitive-services/) - February 17, 2020 - Creating a multi-language translator using Blazor and Azure Cognitive Services.
* [Initializing Web Components in Blazor via JS Interop](https://www.thomasclaudiushuber.com/2020/02/14/initializing-web-components-in-blazor-via-js-interop/) - February 14, 2020 - Initializing Web Components in Blazor via JS Interop. [Source code](https://github.com/thomasclaudiushuber/Blazor-Using-Custom-Web-Component).
* [Blazor WebAssembly Rest Client](https://christianfindlay.com/2020/02/14/blazor-webassembly-rest-client/) - February 14, 2020 - This article focuses on client-side rendering and explains how to use [RestClient.Net](https://github.com/MelbourneDeveloper/RestClient.Net) to make calls to a RESTful API. [Source code](https://github.com/MelbourneDeveloper/RestClient.Net/tree/master/RestClient.Net.Samples.Blazor).
* [Mono: From Xamarin to WebAssembly, Blazor, and .NET 5 - Q&A with Miguel de Icaza](https://www.infoq.com/articles/mono-xamarin-webassembly-net5/) - February 13, 2020 - Mono: From Xamarin to WebAssembly, Blazor, and .NET 5 - Q&A with Miguel de Icaza.
* [Profiling in Blazor](https://remibou.github.io/Profiling-in-Blazor/) - February 12, 2020 - How to profile a production Blazor client-side app?
* [Microsoft Blazor Enables Native App Development in C# and .NET](https://www.semaphore-software.com/blog/microsoft-blazor-enables-native-app-development-in-c-and-net/) - February 12, 2020 - Microsoft Blazor Enables Native App Development in C# and .NET.
* [Rider 2019.3.2 is available](https://blog.jetbrains.com/dotnet/2020/02/12/rider-2019-3-2/) - February 12, 2020 - Rider 2019.3.2 by JetBrains is available, with improved Blazor support.
* [Tinkering with client-side Blazor and the AWS SDK for .NET](https://matteo.tech.blog/2020/02/11/tinkering-with-client-side-blazor-and-the-aws-sdk-for-net/amp/) - February 11, 2020 - Tinkering with client-side Blazor and the AWS SDK for .NET.
* [Why Blazor, via WebAssembly, is the future](https://www.linkedin.com/pulse/why-blazor-via-webassembly-future-akash-limbani/) - February 11, 2020 - Why Blazor, via WebAssembly, is the future.
* [Announcing Experimental Mobile Blazor Bindings February update](https://devblogs.microsoft.com/aspnet/mobile-blazor-bindings-feb-2020-update/) - February 10, 2020 - Announcing Experimental Mobile Blazor Bindings February update.
* [Experimental Mobile Blazor Bindings gets new components](https://visualstudiomagazine.com/articles/2020/02/10/blazor-mobile-update.aspx) - February 10, 2020 - Experimental Mobile Blazor Bindings gets new components.
* [Blazor by Example - A spot of refactoring](https://jonhilton.net/blazor-traffic-light-refactor/) - February 10, 2020 - Blazor by Example - A spot of refactoring. [Source code](https://github.com/jonhilt/BlazorExamples/).
* [Multi-Language Translator Using Blazor And Azure Cognitive Services](https://ankitsharmablogs.com/multi-language-translator-using-blazor-and-azure-cognitive-services/) - February 10, 2020 - Multi-Language Translator Using Blazor And Azure Cognitive Services.
* [Mobile Blazor Bindings – Getting Started + Why You Should Care](https://www.dylanberry.com/2020/02/05/mobile-blazor-bindings-getting-started-why-you-should-care/) - February 5, 2020 - Mobile Blazor Bindings – Getting Started + Why You Should Care.
* [Fragment Routing with Blazor](https://chrissainty.com/fragment-routing-with-blazor/) - February 4, 2020 - Fragment routing, or linking, is the term given when linking to a specific element on a page, say a header for example. This technique is often used in FAQ pages or technical documentation and links using this technique look like this, www.mysite.com/faq#some-header. This post covers how to do this with Blazor.
* [Blazor WebAssembly, Monaco and Antlr – Building the AutoStep Editor as a Blazor App](https://alistairevans.co.uk/2020/02/03/blazor-webassembly-monaco-and-antlr-building-the-autostep-editor-as-a-blazor-app/) - February 3, 2020 - Blazor WebAssembly, Monaco and Antlr – Building the AutoStep Editor as a Blazor App.
* [Blazor by Example - Build a simple traffic light](https://jonhilton.net/blazor-traffic-light/) - February 3, 2020 - Blazor by Example - Build a simple traffic light. [Source code](https://github.com/jonhilt/BlazorExamples/tree/0c620bd5183086c03bc1820d2331e6894099100b).
* [Intro to Blazor and Creating a Blazor App from Scratch](https://www.roundthecode.com/dotnet/intro-to-blazor-and-creating-a-blazor-app-from-scratch) - February 3, 2020 - Intro to Blazor and Creating a Blazor App from Scratch. [Source code](https://github.com/RoundTheCode/RoundTheCode.Blazor/releases/tag/CreateBlazor).
* [Reuse Blazor WASM UI in Blazor Server](http://www.appvnext.com/blog/2020/2/2/reuse-blazor-wasm-ui-in-blazor-server) - February 2, 2020 - Reuse Blazor WASM UI in Blazor Server using a technique showed by Steve Sanderson at the NDC London.
* [Containerizing Blazor Apps](https://www.pluralsight.com/tech-blog/containerizing-blazor-apps/) - January 31, 2020 - Containerizing Blazor Apps.
* [Building experimental hybrid Blazor WebAssembly application](https://gunnarpeipman.com/blazor-hybrid-application-experimental/) - January 30, 2020 - Building experimental hybrid Blazor WebAssembly application, by Gunnar Peipman.
* [Telerik UI for Blazor 2.7.0](https://www.telerik.com/blogs/telerik-ui-for-blazor-270-multiselect-grid-webassembly-more) - January 30, 2020 - Telerik UI for Blazor 2.7.0 - MultiSelect, New Grid Features, WebAssembly Support and More.
* [Microsoft Blazor to become mainstream in 2020](https://jaxenter.com/blazor-2020-167525.html) - January 29, 2020 - Microsoft Blazor to become mainstream in 2020.
* [What's New in Third-Party Blazor Tooling](https://visualstudiomagazine.com/articles/2020/01/29/blazor-tooling.aspx) - January 29, 2020 - What's New in Third-Party Blazor Tooling.
* [Exploring WebWindow examples for Blazor on desktop](https://gunnarpeipman.com/blazor-on-desktop-webwindow-experiment) - January 29, 2020 - Exploring WebWindow examples for Blazor on desktop.
* [Test Your Jsinterop Code With Cypress](https://remibou.github.io/Test-your-JSInterop-code-with-cypress/) - January 29, 2020 - Test your JSInterop code with cypress.io.
* [Blazor WebAssembly 3.2.0 Preview 1 release now available](https://devblogs.microsoft.com/aspnet/blazor-webassembly-3-2-0-preview-1-release-now-available/) - January 28, 2020 - Blazor WebAssembly 3.2.0 Preview 1 release now available.
* [How to implement plug-in on C# Blazor for native JavaScript application](https://www.c-sharpcorner.com/article/how-to-implement-plug-in-on-c-sharp-blazor-for-native-javascript-application-open-ap/) - January 28, 2020 - How to implement plug-in on C# Blazor for native JavaScript application. Open API Scheme Diagram For Draw.io.
* [Blazor by Example - Build a simple markdown editor](https://jonhilton.net/blazor-markdown-editor/) - January 27, 2020 - Blazor by Example - Build a simple markdown editor.
* [Suppressing Events in Blazor and ASP.NET Core Version 3.1](https://visualstudiomagazine.com/articles/2020/01/27/suppressing-events-blazor.aspx) - January 27, 2020 - ASP.NET Core Version 3.1 adds some new features for managing events in Blazor. You may think you'll never need them, but there may be a time when you'll be glad to know about at least one of them.
* [Getting Started with Blazor Server Apps in Visual Studio for Mac](https://devblogs.microsoft.com/visualstudio/getting-started-with-blazor-server-apps-in-visual-studio-for-mac/) - January 22, 2020 - Getting Started with Blazor Server Apps in Visual Studio for Mac.
* [Blazor's Future: gRPC Is Key](https://visualstudiomagazine.com/articles/2020/01/17/blazor-future.aspx) - January 21, 2020 - Blazor's Future: gRPC Is Key, by the Visual Studio Magazine.
* [Embedding Power BI in Blazor](http://blazorhelpwebsite.com/Blog/tabid/61/EntryId/4373/Embedding-Power-BI-in-Blazor.aspx) - January 21, 2020 - You can embed Power BI reports into a Server Side Blazor Application. This method allows you to display a Power BI report without requiring the user to have a Power BI account.
* [Avoiding Parking Fines with Blazor and Geolocation](https://dev.to/ondrabus/avoiding-parking-fines-with-blazor-and-geolocation-572o) - January 20, 2020 - Avoiding Parking Fines with Blazor and Geolocation. [Source code](https://github.com/ondrabus/dont-park-here-client).
* [6 Blazor component libraries to speed up your development](https://jonhilton.net/blazor-component-libraries/) - January 20, 2020 - 6 Blazor component libraries to speed up your development.
* [Using NSwag to Generate Blazor Server Client for an ASP.NET Core 3.1 API](https://elanderson.net/2020/01/using-nswag-to-generate-blazor-server-client-for-an-asp-net-core-3-1-api/) - January 19, 2020 - Using NSwag to Generate Blazor Server Client for an ASP.NET Core 3.1 API.
* [The Future of Blazor is Native Apps](https://medium.com/young-coder/the-future-of-blazor-is-native-apps-9f4a510acdd5) - January 18, 2020 - Microsoft imagines a future where Blazor runs on desktop and mobile — without WebAssembly.
* [Should I Peek Blazor?](https://remibou.github.io/Should-I-peek-Blazor/) - January 16, 2020 - Should I Peek Blazor?
* [Web developers: Microsoft Blazor lets you build native iOS, Android apps in C#, .NET](https://www.zdnet.com/article/web-developers-microsoft-blazor-lets-you-build-native-ios-android-apps-in-c-net/) - January 16, 2020 - Microsoft offers a new tool for building native iOS and Android apps in programming language C# and .NET.
* [Using gRPC-Web with Blazor WebAssembly](https://blog.stevensanderson.com/2020/01/15/2020-01-15-grpc-web-in-blazor-webassembly/) - January 15, 2020 - gRPC-Web is a convenient, high-performance alternative to JSON-over-HTTP for single-page applications, by Steve Sanderson.
* [Announcements from .NET Conf: Focus on Blazor](https://gunnarpeipman.com/focus-on-blazor-announcements/) - January 15, 2019 - Announcements from .NET Conf: Focus on Blazor.
* [Announcing Experimental Mobile Blazor Bindings](https://devblogs.microsoft.com/aspnet/mobile-blazor-bindings-experiment/) - January 14, 2020 - Announcing Experimental Mobile Blazor Bindings.
* [Blazor State Management](https://blog.jeremylikness.com/blog/blazor-state-management) - January 14, 2020 - Blazor State Management, don't forget to add memory to your Blazor apps.
* [Blazor Azure AD B2C Custom URL](https://wellsb.com/csharp/aspnet/blazor-azure-ad-b2c-custom-url/) - January 13, 2020 - Blazor Azure AD B2C Custom URL.
* [OData API, EF Core, and Blazor](https://wellsb.com/csharp/aspnet/odata-api-ef-core-blazor/) - January 7, 2020 - Learn how to configure an OData API, integrate it with Entity Framework Core, and call the API from a server-side Blazor front-end targeting .NET Core 3.1.
* [Integrating Blazor Components into Existing Asp.Net Core MVC Applications](https://medium.com/@waelkdouh/integrating-blazor-components-into-existing-asp-net-core-mvc-applications-b1a2aec4ac1f) - January 7, 2020 - Integrating Blazor Components into Existing Asp.Net Core MVC Applications.
* [What’s Old is New Again – Web Forms meets Blazor](https://jeffreyfritz.com/2020/01/whats-old-is-new-again-web-forms-meets-blazor/) - January 6, 2020 - What’s Old is New Again – Web Forms meets Blazor.
* [Re-Using Angular components in a Blazor WebAssembly application using Angular Elements](https://www.thinktecture.com/blazor/integrations/angular-elements-web-components/) - January 2, 2020 - Re-Using Angular components in a Blazor WebAssembly application using Angular Elements - Web Components custom elements, FTW!
* [Display spinner on each API call automatically in Blazor](https://bipinpaul.com/posts/display-spinner-on-each-api-call-automatically-in-blazor) - January 2, 2020 - Display spinner on each API call automatically in Blazor. [Source code here](https://github.com/iAmBipinPaul/BlazorDisplaySpinnerAutomatically).
* [gRPC With Blazor, C# And .Net Core](https://www.c-sharpcorner.com/article/grpc-with-c-sharp-net-core-calling-grpc-service-with-blazor-server-side-applicati/) - January 2, 2020 - gRPC With Blazor, C# And .Net Core.

## Podcasts
* [.NET 5 with Scott Hunter](https://www.dotnetrocks.com/default.aspx?ShowNum=1719) - December 24, 2020 - .NET 5 is shipped! What happens now? As part of the .BLD() Tech Talks XXL event in the Netherlands, Carl and Richard streamed interviewing Scott Hunter about .NET 5. The conversation turns to how the scope of .NET 5 focused in on how to help projects move from the standard framework onto .NET 5. Scott also dives into the ever-improving performance of .NET, the latest version of Blazor, and the adoption of WinForms in .NET 5 - and what's coming for .NET 6. Duration: 53 minutes.
* [Building a Flight Simulator in C# with Laura Laban](https://www.dotnetrocks.com/default.aspx?ShowNum=1718) - December 17, 2020 - What does it take to make a flight simulator in C#? On a smartphone? Carl and Richard talk to Laura Laban about her experiences building Infinite Flight - starting with the Windows Phone in 2011! The conversation follows the history of using C# in smartphones, from WinPhone 7 through to MonoTouch, MonoGame, and Xamarin! Laura Laban discusses the challenges of tooling getting deprecated, platforms going away, and the vagaries of app stores. Duration: 54 minutes.
* [Building a TwitchBot in Blazor with Georgia Nelson](https://www.dotnetrocks.com/default.aspx?ShowNum=1717) - December 10, 2020 - What can you use Blazor for? Carl and Richard talk to Georgia Nelson about GifBot, a Twitch bot Georgia has built using a variety of tools and languages (including Java) and today is C# and Blazor. Georgia talks about evolving the bot from version to version, looking for ways to make it easier for Twitch streamers to use. From WinForms to WPF to Blazor, the UI has taken a few turns, but Blazor works great in the role of user interface. Duration: 55 minutes.
* [bUnit: A Blazor Testing Lib](https://6figuredev.com/podcast/episode-173-bunit-a-blazor-testing-library-w-egil-hansen) - December 7, 2020 - bUnit: A Blazor Testing Lib; with Egil Hansen in The 6th Figure Developer podcast, episode 173. Duration: 41 minutes.
* [Blazor in Action with Chris Sainty](https://expect-exception.fail/podcast/3) - November 17, 2020 - In this episode of expect(Exception) we talk with Chris Sainty, author of the book Blazor in Action. We talk about what Blazor actually is, why we like it and of course, how to test it. [Blazor in Action](https://www.manning.com/books/blazor-in-action)'s book.
* [Merge Conflict: .NET Conf 2020 & Apple M1 Event Recap](https://www.mergeconflict.fm/228) - November 16, 2020 - Episode 228 of Merge Conflict's podcast: .NET Conf 2020 & Apple M1 Event Recap. This last week was crazy! .NET Conf 2020, .NET 5, Visual Studio 16.8, XAML Hot Reload 2.0, Xbox Series S/X launch, Apple M1 Events, and so much more. Duration: 62 minutes.
* [Oqtane and OSS with Shaun Walker](https://6figuredev.com/podcast/episode-168-oqtane-and-oss-with-shaun-walker/) - November 2, 2020 - Shaun Walker is the original creator of Oqtane and DotNetNuke, web application frameworks which have the earned the recognition of being among the largest, most successful, pioneering Open Source projects native to the Microsoft platform. He was recognized by Business In Vancouver in 2011 as a leading entrepreneur in their Forty Under 40 business awards, and is currently the Chair of the Project Committee for the .NET Foundation. Shaun is currently a Technical Director and Enterprise Guildmaster at Cognizant Softvision. Shaun joined [The 6 Figure Developer](https://6figuredev.com) to talk about his newest project, Oqtane, a Modular Application Framework for Blazor, as well as Open Source Software, and The .NET Foundation. Duration: 44 minutes.
* [The One About Blazor](https://www.mergeconflict.fm/218) - September 7, 2020 - Merge conflict, episode 218: The One About Blazor. Duration: 49 minutes.
* [OpenSilver with Giovanni Albani](https://www.dotnetrocks.com/default.aspx?ShowNum=1698) - July 30, 2020 - OpenSilver with Giovanni Albani, on .NET Rocks. Got Silverlight apps? Carl and Richard talk to Giovanni Albani about the OpenSilver project - building an open-source version of Silverlight that runs without a plugin, using WebAssembly. Giovanni talks about companies he has communicate with that have Silverlight apps with hundreds of thousands of lines of code - not a simple thing to rewrite. The goal of OpenSilver is to let you migrate those applications.
* [.NET Multi-Platform App UI with Scott Hunter](https://www.dotnetrocks.com/default.aspx?ShowNum=1692) - Ready to go to Maui? Carl and Richard talk to Scott Hunter about the .NET Multi-Platform App UI or MAUI for short. Scott talks about how the next versions of .NET are focused on unifying the elements that go into .NET to make One .NET. And that includes the UI stacks - including Xamarin! The evolution of Xamarin into .NET means that all UI stacks will be treated equally. And that leads to the .NET Multi-Platform App UI, letting you make a single project that covers Windows, OS/X, iOS and Android.
* [Testing Blazor Apps with Egil Hansen](https://www.dotnetrocks.com/?show=1690) - June 4, 2020 - Testing Blazor Apps with Egil Hansen, on .NET Rocks. How do you test your Blazor app? Carl Franklin and Richard Campbell talk to Egil Hansen about [bUnit](https://github.com/egil/bunit) ![stars](https://img.shields.io/github/stars/egil/bunit?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/egil/bunit?style=flat-square&cacheSeconds=86400), an open-source testing framework designed to work with Blazor - both the server-side Razor components and the WebAssembly client. Egil talks about building [bUnit](https://github.com/egil/bunit) to allow for robust testing, that is, tolerant to the normal changes that come to an application without breaking all the tests. The conversation also turns to growing the bUnit project with more contributors, a wider set of features, and perhaps being part of the .NET Foundation.
* [Michael Washington on the State of Blazor](http://azuredevopspodcast.clear-measure.com/michael-washington-on-the-state-of-blazor-episode-88) - May 11, 2020 - In this episode of Azure DevOps Podcast, Jeffrey Palermo is speaking with Michael Washington about Blazor in-depth. They discuss the current state of Blazor; Oqtane, a modular application framework for Blazor; server-side Blazor apps; Radzen, a low-code, RAD solution; his books on the topic of Blazor; and his advice, tips, recommendations, and resources for Blazor as well.
* [Blazor with guest Carl Franklin](https://weeklydevtips.com/episodes/blazor-with-guest-carl-franklin) - March 9, 2020 - Carl Franklin is the guest to Weekly Dev Tips. Carl Franklin and Steve Smith (aka Ardalis) discuss Blazor in general and look at how to create a generic object picker control for Blazor.
* [Podcast: Occam’s Blazor](https://stackoverflow.blog/2020/01/14/podcast-occams-blazor/) - January 14, 2020 - Podcast by Stack Overflow.

## Presentations slides
* [Focus on Blazor](https://github.com/dotnet-presentations/dotNETConf/tree/master/2020/FocusOnBlazor) - January 2020 - All the materials of the .NET Conf "Focus on Blazor". The videos are on [YouTube](https://www.youtube.com/playlist?list=PLdo4fOcmZ0oWlP1Qpzg7Dwzxr298ewdUQ).
* [Blazor, a new framework for browser-based .NET apps](https://github.com/SteveSandersonMS/presentation-2020-01-NDCLondon) - January 29, 2020 - Source code of the session by Steve Sanderson at the NDC London, "Blazor, a new framework for browser-based .NET apps".
* [Blazor in more depth](https://github.com/SteveSandersonMS/presentation-2020-01-NdcBlazorComponentLibraries) - January 28, 2020 - Blazor in more depth by Steve Sanderson and Ryan Nowak at the NDC London 2020. [Presentation of Steve Sanderson](https://github.com/SteveSandersonMS/presentation-2020-01-NdcBlazorComponentLibraries). [Presentation of Ryan Nowak](https://github.com/rynowak/Presentations/tree/master/2020/NDCLondon/blazor).
* [Authoring custom components - .NET Conf "Focus on Blazor"](https://github.com/EdCharbeneau/DotnetConfBlazor) - January 14, 2020 - Slides and demo of the presentation by Ed Charbeneau at the .NET Conf "Focus on Blazor".
* [Routing A-Z - .NET Conf "Focus on Blazor"](https://github.com/chrissainty/Talks-DotNetConf-01-2020) - January 14, 2020 - Slides and demo of the presentation by Chris Sainty at the .NET Conf "Focus on Blazor" about routing.

## Tooling
* [Blazor Dev Server with CSS Live Reloader](https://github.com/jsakamoto/Toolbelt.Blazor.DevServer.WithCssLiveReloader) - ![stars](https://img.shields.io/github/stars/jsakamoto/Toolbelt.Blazor.DevServer.WithCssLiveReloader?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/jsakamoto/Toolbelt.Blazor.DevServer.WithCssLiveReloader?style=flat-square&cacheSeconds=86400) Alternative Blazor Dev Server to be available CSS live reloading.
* [BlazorSourceMangler](https://github.com/Lupusa87/BlazorSourceMangler) - ![GitHub stars](https://img.shields.io/github/stars/Lupusa87/BlazorSourceMangler?style=flat-square&cacheSeconds=604800) ![GitHub last commit](https://img.shields.io/github/last-commit/Lupusa87/BlazorSourceMangler?style=flat-square&cacheSeconds=86400) A console app to mangle Blazor DLLs. Check this [YouTube video](https://www.youtube.com/watch?v=nlXax81b1UE) for more details. You can also check this [Blazor TODO app](https://lupblazortodo.z20.web.core.windows.net/) to see result of this app (downloaded blazortodos.dll is mangled and decompilation shows uglyfied code).
