* [BlazorShop](https://github.com/kalintsenkov/BlazorShop) - ![stars](https://img.shields.io/github/stars/kalintsenkov/BlazorShop?style=flat-square&cacheSeconds=604800) ![Last commit](https://img.shields.io/github/last-commit/kalintsenkov/BlazorShop?style=flat-square&cacheSeconds=86400) Simple shop application built with Blazor WebAssembly.
* [Quiz manager secured by Auth0](https://github.com/auth0-blog/secure-blazor-wasm-quiz-manager) - ![last commit](https://img.shields.io/github/last-commit/auth0-blog/secure-blazor-wasm-quiz-manager?style=flat-square&cacheSeconds=86400) This repository contains a Blazor WebAssembly application implementing a simple Quiz manager secured by [Auth0](https://auth0.com/). The implementation details are described in the following article: [Securing Blazor WebAssembly Apps](https://auth0.com/blog/securing-blazor-webassembly-apps/).
* [Blazor-WASM-AzureAD-gRPC](https://github.com/StefH/BlazorWasmGrpcWithAADAuth) - ![last commit](https://img.shields.io/github/last-commit/StefH/BlazorWasmGrpcWithAADAuth?style=flat-square&cacheSeconds=86400) Blazor WASM, Azure AD, REST & gRPC.
* [Umbraco9 & Blazor WASM Starter Site](https://github.com/cornehoskam/Umbraco9-Blazor-Starterkit) - ![last commit](https://img.shields.io/github/last-commit/cornehoskam/Umbraco9-Blazor-Starterkit?style=flat-square&cacheSeconds=86400) A simple starter site for Umbraco v9, making use of Blazor WebAssembly with Tailwind CSS/UI. A project that I use to play around and experiment with Umbraco 9, Blazor WebAssembly, TailwindCSS, the Block List Editor, and several other concepts.

## Samples projects
* [Nethereum Playground](https://github.com/Nethereum/Nethereum.Playground) - ![last commit](https://img.shields.io/github/last-commit/Nethereum/Nethereum.Playground?style=flat-square&cacheSeconds=86400) Compile and run Nethereum snippets on the browser. You can run it here: http://playground.nethereum.com/.
* [TypinExamples](https://github.com/adambajguz/Typin/tree/master/src/TypinExamples) - ![last commit](https://img.shields.io/github/last-commit/adambajguz/Typin?style=flat-square&cacheSeconds=86400) A sample project that demonstrates the usage of [Typin](https://github.com/adambajguz/Typin/) framework with a Blazor SPA application (Xterm.js and custom web workers implementation in C# to emulate terminal experience in browser). [Live demo](https://adambajguz.github.io/Typin/).
* [NethereumBlazor](https://github.com/Nethereum/NethereumBlazor) - ![GitHub stars](https://img.shields.io/github/stars/Nethereum/NethereumBlazor?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/Nethereum/NethereumBlazor?style=flat-square&cacheSeconds=86400) Ethereum blockchain explorer and simple wallet.
* [Blazor Weather](https://github.com/danroth27/BlazorWeather) - ![stars](https://img.shields.io/github/stars/danroth27/BlazorWeather?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/danroth27/BlazorWeather?style=flat-square&cacheSeconds=86400) A Blazor Weather sample app that shows the current weather for your current location and a collection of pinned locations. Demonstrated at .NET Conf 2019 by Daniel Roth. [Demo](https://aka.ms/blazorweather).
* [Bolero.TodoMVC](https://github.com/fsbolero/TodoMVC) - ![GitHub stars](https://img.shields.io/github/stars/fsbolero/TodoMVC?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/fsbolero/TodoMVC?style=flat-square&cacheSeconds=86400) A TodoMVC clone using Bolero.

## Articles
* [Blazor Custom Elements in HTML or React](https://dvoituron.com/2022/12/22/blazor-custom-elements-react/) - December 22, 2022 - Since version 7.0 of .NET, Microsoft has enhanced and integrated the ability to create [HTML Custom Elements](https://html.spec.whatwg.org/multipage/custom-elements.html). These custom elements offer developers a way to create their own full-featured DOM elements. In Blazor, this allows publishing these components to other SPA Frameworks, such as Angular or React. More info in the Microsoft documentation.
* [Build Your Own Podcast App with .NET 7, Blazor, and .NET MAUI](https://devblogs.microsoft.com/dotnet/build-your-own-podcast-app-with-dotnet-blazor-and-dotnet-maui/) - December 19, 2022 - The .NET Podcast app was first introduced at .NET Conf 2021 and recently updated to highlight new features in .NET 7 at the .NET Conf 2022 keynote. The podcast app is ready to use sample application that showcases .NET, ASP.NET Core, Blazor, .NET MAUI, Azure Container Apps, Orleans, Power Platform, Playwright, and more. This post explains all the new features and show how we upgraded the .NET Podcast app to take advantage of them.
* [The Future of .NET with WASM](https://blog.jetbrains.com/dotnet/2022/12/15/the-future-of-net-with-wasm/) - December 15, 2022 - This post is about the benefits of using WASM outside the browser and its potential as a transformative technology on the server. 
* [Use Keycloak as Identity Provider from Blazor WebAssembly (WASM) applications](https://dev.to/nikiforovall/use-keycloak-as-identity-provider-from-blazor-webassembly-wasm-applications-3an6) - December 8, 2022 - Learn how to integrate with Keycloak from Blazor WASM. Create a public client and use built-in capabilities of Microsoft.AspNetCore.Components.WebAssembly.Authentication that integrates with OpenId Connect compliant providers. [Source code](https://github.com/NikiforovAll/keycloak-authorization-services-dotnet/blob/main/samples/Blazor) ![stars](https://img.shields.io/github/stars/NikiforovAll/keycloak-authorization-services-dotnet?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/NikiforovAll/keycloak-authorization-services-dotnet?style=flat-square&cacheSeconds=86400) Brings [ChartJs](https://github.com/chartjs/Chart.js).
* [What’s new in the Microsoft Fluent UI library for Blazor version 2.0](https://medium.com/fast-design/whats-new-in-the-microsoft-fluent-ui-library-for-blazor-version-2-0-b3ac0eb5d02c) - December 5, 2022 - What’s new in the Microsoft Fluent UI library for Blazor version 2.0.
* [Build a web app to manage a custom provider in Viva Learning with Blazor](https://techcommunity.microsoft.com/t5/windows-dev-appconsult/build-a-web-app-to-manage-a-custom-provider-in-viva-learning/ba-p/3686343#M679) - November 29, 2022 - In this post, we're going to reuse the concepts we have learned to build a better experience: a web application, that we can use to manage our custom learning provider and its contents. We'll focus on how to implement in a real application some of the peculiar features we have learned about these APIs, like the fact that a different set of permissions is required based on the type of content you're working with.
* [Maintenance release: Blazorise 1.1.4](https://blazorise.com/news/release-notes/114) - November 24, 2022 - This new Blazorise 1.1.4 is a hotfix release to solve this and a few other minor issues that were fixed in the meantime. Blazorise 1.1.4 is a recommended upgrade for all Blazorise 1.1 and Blazorise 1.1.3 users.
* [Blazor WebAssembly: Debugging gRPC-Web with Custom Chrome Developer Tools](https://www.thinktecture.com/blazor/blazor-wasm-debugging-grpc-web/) - November 17, 2022 - If you are working with Blazor, gRPC is a big issue for transferring data from APIs to clients. One issue of developing with gRPC-Web is debugging the transmitted data because the data is in an efficient binary message format. This article shows you how to solve this problem with the help of my NuGet. 
* [Release: Blazorise 1.1.3](https://blazorise.com/news/release-notes/113) - November 8, 2022 - This Blazorise version was supposed to be just a minor maintenance release. Instead, we got a few relatively large features and announcements, with .NET 7 support. 
* [Containerized Blazor: Microsoft Ponders New Client-Side Hosting](https://visualstudiomagazine.com/articles/2022/11/02/blazor-docker.aspx) - November 2, 2022 - Microsoft is exploring built-in container support for client-side Blazor WebAssembly apps. Article on Visual Studio Magazine.
* [Resize images before uploading in Blazor Web Assembly](https://www.mikesdotnetting.com/article/361/resize-images-before-uploading-in-blazor-web-assembly) - October 31, 2022 - Resize images before uploading in Blazor Web Assembly.
* [Experimenting with .NET 7, WASM, and WASI on Docker](https://laurentkempe.com/2022/10/31/experimenting-with-dotnet-7-wasm-and-wasi-on-docker/) - October 31, 2022 - On October 24th, Docker announced the support of WASM and WASI in a new technical preview release. This articles tries it out and sees how it works with .NET 7.
* [How to run Blazor project everywhere using Razor Class Library ?](https://chandradev819.com/2022/10/29/how-to-run-blazor-project-everywhere-using-razor-class-library/) - October 29, 2022 - One of the cool features of Blazor is code reusability. Using Razor Class Library, we can use our Razor component in all blazor type project like Blazor Server, WASM and MAUI Hybrid.
* [Using WASM and WASI to run .NET 7 on a Raspberry PI Zero 2 W](https://laurentkempe.com/2022/10/29/using-wasm-and-wasi-to-run-dotnet-7-on-a-raspberry-pi-zero-2-w/) - October 29, 2022 - This post will show you how to run .NET 7 on a Raspberry PI Zero 2 W using WASM and WASI.
* [Introducing the Docker+Wasm Technical Preview](https://www.docker.com/blog/docker-wasm-technical-preview/) - October 24, 2022 - The Technical Preview of Docker+Wasm is now available! Wasm has been producing a lot of buzz recently, and this feature will make it easier for you to quickly build applications targeting Wasm runtimes.
* [Part 1 - UI driven by Elsa Workflows](https://medium.com/@fanekkie/part-1-ui-driven-by-elsa-workflows-6d0e868ea6c) - October 12, 2022 - This series describes the implementation of a User Interface driven by an Elsa workflow engine.
* [ASP.NET Core updates in .NET 7 Release Candidate 2](https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-7-rc-2/) - October 11, 2022 - .NET 7 Release Candidate 2 (RC2) is now available and includes many great new improvements to ASP.NET Core and Blazor: improved diagnostics for authentication in Blazor WebAssembly and WebAssembly multithreading (experimental).
* [No Need to Wait for .NET 8 to Try Experimental WebAssembly Multithreading](https://visualstudiomagazine.com/articles/2022/10/11/blazor-webassembly-net7.aspx) - October 11, 2022 - Multithreading support for client-side Blazor WebAssembly apps is planned for .NET 8 in November 2023, but developers can try it out now for .NET apps thanks to experimental functionality in the brand-new .NET 7 Release Candidate 2. 
* [Using .NET 7's Blazor Custom Elements to render dynamic content](https://jonhilton.net/blazor-custom-elements/) - October 5, 2022 - Using .NET 7's Blazor Custom Elements to render dynamic content, by Jon Hilton.
* [Creating a Generic Tree View Blazor Component](https://techcommunity.microsoft.com/t5/healthcare-and-life-sciences/creating-a-generic-tree-view-blazor-component/ba-p/3640237) - October 4, 2022 - This article shows off a Blazor component that can display an object recursively in a tree view. The component was made as part as a project, FHIR Watch, a tool for comparing FHIR data from two different data sources: FHIR API Service and Dataverse. As such, it is particularly useful for displaying FHIR data.
* [Clean Architecture Solution Template for Blazor WebAssembly](https://jasontaylor.dev/clean-architecture-solution-template-for-blazor-webassembly/) - September 30, 2022 - This post shows how to install the new template, create and run a new app using the template, and then I’ll share some recommended resources.
* [WebAssembly Steals the ASP.NET Core Show in .NET 7 RC1](https://visualstudiomagazine.com/articles/2022/09/20/aspnet-core-updates.aspx) - September 20, 2022 - WebAssembly, the open source tech that makes client-side Blazor work, was the star of the ASP.NET Core show in the new [ASP.NET Core updates in .NET 7 Release Candidate 1](https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-7-rc-1/).
* [C# / Blazor Wolfenstein - Part 7 - Solid Walls, Doors and C# Observations](https://www.jamesdrandall.com/posts/csharp_blazor_wolfenstein_part_7_sold_walls_doors_and_csharp_observations/) - September 20, 2022 - Part 7 of the articles explaining how port the game Wolfenstein 3D on C# and Blazor. [Source code](https://github.com/JamesRandall/csharp-wolfenstein) ![stars](https://img.shields.io/github/stars/JamesRandall/csharp-wolfenstein?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/JamesRandall/csharp-wolfenstein?style=flat-square&cacheSeconds=86400).
* [C# / Blazor Wolfenstein - Part 6 - The Basic Raycaster](https://www.jamesdrandall.com/posts/csharp_blazor_wolfenstein_part_6_the_basic_raycaster/) - September 18, 2022 - Part 6 of the articles explaining how port the game Wolfenstein 3D on C# and Blazor. [Source code](https://github.com/JamesRandall/csharp-wolfenstein) ![stars](https://img.shields.io/github/stars/JamesRandall/csharp-wolfenstein?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/JamesRandall/csharp-wolfenstein?style=flat-square&cacheSeconds=86400).
* [ASP.NET Core updates in .NET 7 Release Candidate 1](https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-7-rc-1/) - September 14, 2022 - .NET 7 Release Candidate 1 (RC1) is now available and includes many great new improvements to ASP.NET Core.
* [Why can't your Blazor WebAssembly PWA with offline support update even though you reload it?](https://dev.to/j_sakamoto/why-cant-your-blazor-webassembly-pwa-with-offline-support-update-even-though-you-reload-it-31ho) - September 7, 2022 - Please imagine the case that you have a Blazor WebAssembly PWA site that supports offline mode, and you've been opening that PWA by a web browser. If you published a new version of that PWA, you might want to verify it, I guess. In this case, you will reload the page on that web browser. However, you might never see the contents of the new version unexpectedly even though you hard-reload it.
* [Implement OpenAPI Support for Blazor WebAssembly](https://jasontaylor.dev/implement-openapi-support-for-blazor-webassembly/) - September 2, 2022 - OpenAPI is a language-agnostic specification for documenting RESTful APIs. It allows both humans and computers to understand the capabilities of a service without accessing code, docs, or using other methods. Hosted Blazor WebAssembly apps include an ASP.NET Core backend for file and API access, and so implementing support for OpenAPI provides numerous benefits.
* [Troubleshooting .NET Blazor WASM Debugging](https://khalidabuhakmeh.com/troubleshooting-dotnet-blazor-wasm-debugging) - August 30, 2022 - Troubleshooting .NET Blazor WASM Debugging.
* [ClassFly UI - XAML vs Blazor - Part 1 - XAML](https://kymphillpotts.com/maui-ui-july.html) - July 23, 2022 - This serie of article compares the approaches of XAML vs Blazor. The same application will be create using XAML and Blazor to discover the pros and cons. The part 1 focuses on XAML. 
* [Authenticate Blazor WebAssembly with Azure Static Web Apps](https://anthonychu.ca/post/blazor-auth-azure-static-web-apps/) - July 22, 2022 - Azure Static Web Apps is a great place to host Blazor WebAssembly apps. Among Static Web Apps' many features, it has built-in support for authentication using social logins. In this article, we'll look at how we can take advantage of Static Web Apps Authentication in our Blazor WebAssembly apps. By Anthony Chu, from Microsoft.
* [Share Blazor components using dependency injection](https://engstromjimmy.com/post/2022-07-21-ShareBlazorComponentsUsingDi) - July 19, 2022 - Share Blazor components using dependency injection.
* [Using IAsyncEnumerable in a Razor component](https://www.meziantou.net/using-iasyncenumerable-in-a-razor-component.htm) - July 18, 2022 - Using IAsyncEnumerable in a Razor component.
* [Blazor Sticker Giveaway](https://dev.to/dotnet/blazor-sticker-giveaway-try-the-new-blazor-guide-in-visual-studio-4c8b) - July 15, 2022 - Try the new Blazor Guide in Visual Studio. Read on to learn about how to give it a try and for a chance to receive a sticker.
* [ASP.NET Core updates in .NET 7 Preview 6](https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-7-preview-6/) - July 12, 2022 - .NET 7 Preview 6 is now available and includes many great new improvements to ASP.NET Core. Blazor custom elements no longer experimental, experimental QuickGrid component for Blazor, System.Security.Cryptography support on WebAssembly, empty Blazor project templates and more. For more details on the ASP.NET Core work planned for .NET 7 see the full [ASP.NET Core roadmap for .NET 7](https://aka.ms/aspnet/roadmap) on GitHub.
* [Uno Platform Does WebAssembly Threading Months Ahead of .NET 7](https://visualstudiomagazine.com/articles/2022/06/29/uno-platform-4-4.aspx) - June 29, 2022 - Uno Platform Does WebAssembly Threading Months Ahead of .NET 7, by David Ramel for Visual Studio Magazine.
* [3 reasons why I've created yet another library for the downloading on Blazor apps](https://dev.to/j_sakamoto/3-reasons-why-ive-created-yet-another-library-for-the-downloading-on-blazor-apps-2cpk) - June 29, 2022 - 3 reasons why I've created yet another library for the downloading on Blazor apps.
* [Blazor Posts Biggest Gain in WebAssembly Usage: Report](https://visualstudiomagazine.com/articles/2022/06/24/blazor-webassembly.aspx) - June 24, 2022 - Blazor Posts Biggest Gain in WebAssembly Usage: Report, by David Ramel for Visual Studio Magazine.
* [Implementing RavenDB time series in a Blazor project](https://engstromjimmy.com/post/2022-06-21-RavenTimeseries) - June 21, 2022 - Implementing RavenDB time series in a Blazor project.
* [What’s new in the Microsoft Fluent UI library for Blazor versions 1.3 and 1.4](https://medium.com/fast-design/whats-new-in-the-microsoft-fluent-ui-library-for-blazor-versions-1-3-and-1-4-4c3ea55a4b56) - June 9, 2022 - The FAST team and friends have been hard at work not only on Microsoft’s core Web Components platform, but also on Fluent UI integrations for Blazor. This post will give you an overview of what’s new and changed in versions 1.3 and 1.4 of the [Microsoft Fluent UI Blazor library](https://www.nuget.org/packages/Microsoft.Fast.Components.FluentUI/).
* [A Full-Stack Web App Using Blazor WebAssembly and GraphQL: Part 3](https://www.syncfusion.com/blogs/post/a-full-stack-web-app-using-blazor-webassembly-and-graphql-part-3.aspx) - June 8, 2022 - A Full-Stack Web App Using Blazor WebAssembly and GraphQL: Part 3. [Part 1](https://www.syncfusion.com/blogs/post/a-full-stack-web-app-using-blazor-webassembly-and-graphql-part-1.aspx).
* [Dependency Injection Scopes in Blazor](https://www.thinktecture.com/blazor/dependency-injection-scopes-in-blazor/) - May 31, 2022 - The dependency injection system is a big part of how modern ASP.NET Core works internally: It provides a flexible solution for developers to structure their projects, decouple their dependencies, and control the lifetimes of the components within an application. In Blazor - a new part of ASP.NET Core - however, the DI system feels a bit odd, and things seem to work a bit differently than expected. This article will explain why this is not only a feeling but indeed the case in the first place and how to handle the differences in order to not run into problems later on.
* [ASP.NET Core updates in .NET 7 Preview 4](https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-7-preview-4) - May 10, 2022 - .NET 7 Preview 4 is now available and includes many great new improvements to ASP.NET Core. Article by Dan Roth from Microsoft.
* [Q&A: Deep Dive on Blazor](https://visualstudiomagazine.com/articles/2022/05/09/qa-blazor-deep-dive.aspx) - May 9, 2022 - Q&A: Deep Dive on Blazor, on Visual Studio Magazine.
* [Syncfusion Essential Studio Release Enhances .NET MAUI, WinUI, Blazor and More](https://visualstudiomagazine.com/articles/2022/05/06/syncfusion-v1.aspx) - May 6, 2022 - Syncfusion Essential Studio Release Enhances .NET MAUI, WinUI, Blazor and More, on Visual Studio Magazine.
* [Use the Query String to pass an array of selected values between Blazor Pages](https://jonhilton.net/blazor-deep-linking/) - April 28, 2022 - Use the Query String to pass an array of selected values between Blazor Pages.
* [Containerizing Blazor WASM, ASPNET Core WebApi, NGINX & Let's Encrypt](https://www.ledjonbehluli.com/posts/blazor_wasm_nginx_docker/) - April 26, 2022 - Guide on containerizing a complex system composed from multiple Blazor WASM apps, ASPNET Core Web Api, NGINX & Let's Encrypt SSL certificates.
* [Blazor WebAssembly: The Power Of EF Core And SQLite In The Browser](https://www.thinktecture.com/blazor/ef-core-and-sqlite-in-browser/) - April 12, 2022 - Sneak Preview how to use SQLite and EF Core in the browser with Blazor WebAssembly.
* [Mastering Blazor - Part 1: DOM Integration](https://dev.to/florianrappl/mastering-blazor-part-1-dom-integration-5591) - March 31, 2022 - Mastering Blazor - Part 1: DOM Integration.
* [Conditional Blazor Styles (without the if statements)](https://jonhilton.net/conditional-blazor-css/) - March 24, 2022 - Conditional Blazor Styles (without the if statements).
* [Securing a Blazor WebAssembly Hosted Apps with Azure Active Directory](https://dev.to/kasuken/securing-a-blazor-webassembly-hosted-apps-with-azure-active-directory-part-1-382d) - March 18, 2022 - Securing a Blazor WebAssembly Hosted Apps with Azure Active Directory. [Part 2](https://dev.to/kasuken/securing-a-blazor-webassembly-hosted-apps-with-azure-active-directory-part-2-1ppd).
* [A Full-Stack Web App Using Blazor WebAssembly and GraphQL: Part 1](https://www.syncfusion.com/blogs/post/a-full-stack-web-app-using-blazor-webassembly-and-graphql-part-1.aspx) - February 17, 2022 - This article shows how to create a full-stack web application using Blazor WebAssembly and GraphQL with SQL Server as our database.
* [What's Coming for Blazor Hybrid in .NET 7](https://visualstudiomagazine.com/articles/2022/02/10/blazor-hybrid-net-7.aspx) - February 10, 2022 - What's Coming for Blazor Hybrid in .NET 7, Visual Studio Magazine.
* [Use Tailwind's new JIT mode when developing Blazor applications](https://jonhilton.net/tailwind3-blazor/) - January 19, 2022 - Use Tailwind's new JIT mode when developing Blazor applications.

## Videos
* [Run a Blazor component inside React](https://www.youtube.com/watch?v=jIlSfgQiWTQ) - ![duration](https://img.shields.io/badge/Duration:%20-19%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) December 21, 2022 - Are you tired of slow and clunky web applications? Look no further than Blazor running in React! Blazor is a powerful framework for building interactive client-side web apps with C#, and when combined with the speed and flexibility of React, you get a winning combination for stunning, high-performance web experiences. In this video, we will use the new Custom Elements feature to run Blazor in React, and demonstrate some of the other exciting features and benefits of this dynamic duo. Don't miss out on the future of web development.
* [ASP.NET Community Standup - Blazor .NET 8 Planning](https://www.youtube.com/watch?v=QVkxusemLoo&list=PLdo4fOcmZ0oX-DBuRG4u58ZTAJgBAeQ-t&index=1) - ![duration](https://img.shields.io/badge/Duration:%20-74%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) December 13, 2022 - Find out our early plans for Blazor in .NET 8. [Community links](https://www.theurlist.com/blazor-community-links).
* [Use the IDE to make a Fluxor CRUD Application | Blazor IDE Part 2](https://www.youtube.com/watch?v=r2XaCISF4dQ) - ![duration](https://img.shields.io/badge/Duration:%20-147%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 18, 2022 - Use the IDE to make a Fluxor CRUD Application.
* [What's new for Blazor in .NET 7 | .NET Conf 2022](https://www.youtube.com/watch?v=evW4Gj4sHsk) - ![duration](https://img.shields.io/badge/Duration:%20-29%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 10, 2022 - Blazor in .NET 7 is loaded with many new improvements to make building beautiful interactive web UI easier and more productive. In this session we'll take a look at the new support for custom elements, improved data binding, handling location changing events, showing loading progress, dynamic authentication requests, and more.
* [Build an Audio Browser app with Blazor | .NET Conf 2022](https://www.youtube.com/watch?v=2t4VwBeQ9DY) - ![duration](https://img.shields.io/badge/Duration:%20-28%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 10, 2022 - So you’ve heard about new features in .NET 7, but how does it all fit together when you build an app? Join Steve as he quickly builds an end-to-end audio manager app with Blazor WebAssembly using features old and new. This is a moderately advanced talk (it assumes existing Blazor knowledge) full of hints and tips including: cleaner ways to organize JS interop, directly accessing files on an end user’s filesystem, dynamically generating SVGs, creating an elegant “loading” experience, and the performance impact of AOT compilation. Full source code is provided!
* [.NET ❤️’s WebAssembly in .NET 7 | .NET Conf 2022](https://www.youtube.com/watch?v=Ru-kO77d3F8) - ![duration](https://img.shields.io/badge/Duration:%20-27%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 10, 2022 - .NET 7 introduces powerful new capabilities for running .NET code on WebAssembly. In this session we’ll show how you can run .NET from any JavaScript code using the new and improved JavaScript interop support. We’ll look at debugging and hot reload improvements for .NET on WebAssembly  and show how the .NET WebAssembly build tools in .NET 7 take advantage of the latest WebAssembly features like SIMD and Exception Handling to improve performance. We’ll also check out some upcoming and experimental .NET WebAssembly capabilities like support for multithreading.
* [Testing Blazor Applications with Playwright | .NET Conf 2022](https://www.youtube.com/watch?v=gBky9_AskNQ) - ![duration](https://img.shields.io/badge/Duration:%20-24%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 10, 2022 - Testing is hard, testing takes time to learn and to write, and time is money. As developers we want to test. We know we should but we don't have time. So how can we get more developers to do testing? We can create better tools. Let me introduce you to Playwright - Reliable end-to-end cross browser testing for modern web apps, by Microsoft and fully open source. Playwright's codegen generates tests for you so now you really have no excuses. It's time to play your tests wright.
* [Create native desktop & mobile apps using web skills in Blazor Hybrid | .NET Conf 2022](https://www.youtube.com/watch?v=ojcvL8KCOwo) - ![duration](https://img.shields.io/badge/Duration:%20-30%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 10, 2022 - Are you a web developer and need to target iOS, Android, macOS, and Windows? Ship directly to the store and build world class apps with native API access with .NET MAUI and Blazor Hybrid.
* [Modernize your WPF and Windows Forms application with Blazor | .NET Conf 2022](https://www.youtube.com/watch?v=niX1DbFwgq4) - ![duration](https://img.shields.io/badge/Duration:%20-24%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 10, 2022 - Desktop is not dead and there are a lot of applications written in WPF and Windows Forms that need to be ported to Web, or reuse ready components written by the web team. Blazor can be the answer for both the requirements thanks to Blazor Hybrid. Let’s see how you can use it.
* [CSS Techniques for Blazor Developers | .NET Conf 2022](https://www.youtube.com/watch?v=w_x1keHyXAY) - ![duration](https://img.shields.io/badge/Duration:%20-29%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 10, 2022 - Does your CSS code remind you of an episode of Hoarders? In this session we’ll explore a variety of CSS related architecture decisions that Blazor developers face. Attendees will learn how and when to use plain CSS, Sass or CSS Isolation with Blazor. Modern CSS techniques like custom CSS properties will be discussed. We’ll explore techniques to build modular and intelligent CSS by leveraging CSS principals and incorporating helper libraries. This session aims to break the dependency on CSS systems like Bootstrap and Tailwind.
* [Azure Static Web Apps with Blazor and .NET | .NET Conf 2022](https://www.youtube.com/watch?v=FjGjguW1Xa0) - ![duration](https://img.shields.io/badge/Duration:%20-30%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 10, 2022 - Are you a .NET developer who wants to quickly build and deploy full-stack .NET serverless applications? Then this talk is for you! In this session, we will learn how to use Azure Static Web Apps with Blazor and .NET. First, we will explore Azure Static Web Apps. Then take a look at getting started with Blazor WebAssembly paired with the serverless power of .NET Azure Functions or Azure Container Apps. We will continue on to explore other .NET API options now available. And finally, we will discover how to automatically build and deploy to Azure directly from our code repository. 
* [Localization in Blazor: Carl Franklin's Blazor Train Ep 90](https://www.youtube.com/watch?v=e8IkSFQmonE) - ![duration](https://img.shields.io/badge/Duration:%20-14%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 3, 2022 - Carl shows how to easily support multiple languages in a Blazor WebAssembly application.
* [Building "Next Tech Event" using Blazor and RavenDB Part 12](https://www.youtube.com/watch?v=tpF61oKd3-I) - ![duration](https://img.shields.io/badge/Duration:%20-129%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) November 2, 2022 - Part 12 of the project "NextTechEvent", a site that will help speakers, organizers, and attendees find their next tech event. In this stream, we add search functionality using RavenDB by adding an index. A way for organizers to filter conferences by name, country, location, city, and tags or a combination of them. This way we can see how many conferences are happening in "Stockholm" or all the conferences named "NDC". ![GitHub stars](https://img.shields.io/github/stars/CodingAfterWork/NextTechEvent?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/CodingAfterWork/NextTechEvent?style=flat-square&cacheSeconds=86400)  [Source code](https://github.com/CodingAfterWork/NextTechEvent).
* [MAUI Blazor Podcast Client Part 2: The .NET Show with Carl Franklin Ep 30](https://www.youtube.com/watch?v=csWkVlB3GQo) - ![duration](https://img.shields.io/badge/Duration:%20-31%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) October 20, 2022 - Adding guests and links, and playlist functionality.
* [ASP.NET Community Standup - Blazor in .NET 7 Part III](https://www.youtube.com/watch?v=YR3O3ktuYCw&list=PLdo4fOcmZ0oX-DBuRG4u58ZTAJgBAeQ-t&index=1) - ![duration](https://img.shields.io/badge/Duration:%20-60%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) October 11, 2022 - Learn more about the latest multithreading and MSAL developments for Blazor in .NET 7. [Community links](https://www.theurlist.com/blazor_community_standup_october_2022).
* [MSAL Auth in Blazor Server](https://www.youtube.com/watch?v=AlRxwIOq4jQ&list=PL8h4jt35t1wjvwFnvcB2LlYL4jLRzRmoz&index=92) - ![duration](https://img.shields.io/badge/Duration:%20-26%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) September 22, 2022 - Carl shows how to use MSAL and Azure AD B2C to authenticate users and call a secure API.
* [ASP.NET Community Standup - Blazor in .NET 7 Part II](https://www.youtube.com/watch?v=-ZSscIhQaRk&list=PLdo4fOcmZ0oX-DBuRG4u58ZTAJgBAeQ-t&index=2) - ![duration](https://img.shields.io/badge/Duration:%20-87%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) September 13, 2022 - Learn more about the exciting runtime changes in Blazor for .NET 7. [Community links](https://www.theurlist.com/blazor_community_standup_september_2022). [Part 1](https://www.youtube.com/watch?v=mDKvgpD8YM0&feature=emb_imp_woyt).
* [Make a Text Editor in Blazor from scratch, Blazor Text Editor Part 1.](https://www.youtube.com/watch?v=D5PdeRsV-Hk&list=PLG4PTDe2qc0i0COivTxn_rjSN96Xq-_K1&index=2) - ![duration](https://img.shields.io/badge/Duration:%20-44%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) September 8, 2022 - Make a Text Editor in Blazor from scratch, Blazor Text Editor Part 1.
* [Roslyn Syntax Highlighting | Blazor Text Editor Part 2](https://www.youtube.com/watch?v=ZIt0-mbCgG8&list=PLG4PTDe2qc0i0COivTxn_rjSN96Xq-_K1&index=2) - ![duration](https://img.shields.io/badge/Duration:%20-36%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) September 8, 2022 - Roslyn Syntax Highlighting | Blazor Text Editor Part 2.
* [Make a Text Editor in Blazor from scratch | Blazor Text Editor Part 1](https://www.youtube.com/watch?v=D5PdeRsV-Hk&t=0s) - ![duration](https://img.shields.io/badge/Duration:%20-44%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) September 8, 2022 - Make a Text Editor in Blazor from scratch | Blazor Text Editor Part 1.
* [.NET MAUI & Blazor - Sharing code between app and web](https://www.youtube.com/watch?v=A_C8X-b2qXE) - September 2, 2022 - In this video, Daniel will show you how to create a project for .NET MAUI and Blazor and how to structure the code so it can be shared between the app and the web. ![GitHub stars](https://img.shields.io/github/stars/dhindrik/MauiBlazorHybridDemo?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/dhindrik/MauiBlazorHybridDemo?style=flat-square&cacheSeconds=86400) [Source code](https://github.com/dhindrik/MauiBlazorHybridDemo).
* [Blazor in 100 Seconds](https://www.youtube.com/watch?v=QXxNlpjnulI) - ![duration](https://img.shields.io/badge/Duration:%20-2%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) September 1, 2022 - Short presentation of Blazor. Blazor is a framework that can build frontend web applications with HTML, CSS, and C#. It leverages web assembly to eliminate JavaScript from the usual client-side tech stack.
* [Build an interactive todo list with Blazor in minutes](https://www.youtube.com/watch?v=YhAxMpOtVQU) - ![duration](https://img.shields.io/badge/Duration:%20-16%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) August 28, 2022 - In this tutorial we'll learn how to create a todo list with Blazor and improve the page using Bootstrap.
* [Blazor in .NET 7 - .NET Community Standup](https://www.youtube.com/watch?v=mDKvgpD8YM0&feature=emb_imp_woyt) - ![duration](https://img.shields.io/badge/Duration:%20-85%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) August 23, 2022 - Overview of Blazor in .NET 7 with Daniel Roth, Jon Galloway, Mackinnon Buck and Tanay Parikh. Learn more about the great new features coming to Blazor in .NET 7.
* [Blazor for ABSOLUTE beginners in 21 Minutes](https://www.youtube.com/watch?v=MhQpGbLxeF0) - ![duration](https://img.shields.io/badge/Duration:%20-21%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) August 22, 2022 - In this tutorial you will learn the basics of building a website with Blazor and how the default Blazor project template works. If you have any problems feel free to leave a comment and I will try and get back to you. I've also added some notes below that you might find useful.
* [Implementing Main Page Headers in Blazor](https://www.youtube.com/watch?v=YAgMdsdWzAc) - ![duration](https://img.shields.io/badge/Duration:%20-101%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) July 18, 2022 - In this session, Josh and I are back again to continue building a decentralizaed social media platform in the open-source space. This session in particular we will be discussing, designing and implementing a main page header in Blazor using SharpStyles.
* [Blazor: Flavors of State Management with Blazor WebAssembly](https://www.youtube.com/watch?v=ovgNl_ck22w) - ![duration](https://img.shields.io/badge/Duration:%20-85%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) July 12, 2022 - ASP.NET Community Standup - Blazor: Flavors of State Management with Blazor WebAssembly. Working with Blazor WebAssembly applications we often overlook the importance of appropriate state management. Without a good understanding and the right strategy, our applications can end up polluted with components that behave badly and we end up regretting the bad choices.- This session covers the simple state management flavours and then progress towards something more tasty like the Redux pattern. We will see what there is to like and dislike about each flavour. Next, we will take a step back and determine the appropriate seasoning of state management to pair with our application. You will leave this session having sampled all the wonderful flavours and be able to make great decisions to have the best development experience. [Community links](https://www.theurlist.com/blazor_community_standup_july_2022).
* [Securing Blazor & Web APIs with AAD](https://www.youtube.com/watch?v=wYptdN-P5zU) - ![duration](https://img.shields.io/badge/Duration:%20-30%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) July 11, 2022 - This video shows how to secure your Blazor application and a Web API using Azure Active Directory (AAD).
* [What’s next for Blazor, and .NET on WASI](https://www.youtube.com/watch?v=lP_qdhAHFlg) - ![duration](https://img.shields.io/badge/Duration:%20-61%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) July 7, 2022 - What’s next for Blazor, and .NET on WASI, talk by Steve Sanderson at the NDC Porto. In this demo-centric talk, Microsoft developer/architect Steve will show the current state-of-the-art in Blazor for building rich web-based UI for browsers and native apps. This will include powerful new features shipped in .NET 6, as well as upcoming enhancements under development for .NET 7 and .NET MAUI. We’ll also look at more experimental future possibilities, including running .NET Core on WASI (WebAssembly on the server) which creates entirely new cloud and edge hosting options and lets you bring .NET code to places it’s never been before.
* [Test the new Blazor experimental tutorial INSIDE Visual Studio](https://www.youtube.com/watch?v=NXtaepJsWp8) - ![duration](https://img.shields.io/badge/Duration:%20-9%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) June 29, 2022 - Grace Taylor from the Visual Studio team joins James to talk about a new experiment that they are running to improve tutorial inside of Visual Studio! Their first experiment is going to help developers get started learning and building web apps with Blazor. Install Visual Studio, and you may have the opportunity to test out this new experimental feature from the team.
* [Test-Driving CSS Styles in Blazor](https://www.youtube.com/watch?v=06chSzVeuls) - ![duration](https://img.shields.io/badge/Duration:%20-32%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=microsoft) June 20, 2022 - This video is about test-driving CSS styles in Blazor.
* [Should I Focus on Blazor or ASP.NET Core?](https://www.youtube.com/watch?v=YbH2n4FZAP4) - ![duration](https://img.shields.io/badge/Duration:%20-13%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=microsoft) June 16, 2022 - Should I learn Blazor in more depth or should I better understand ASP.NET Core? Which one is the better one to learn well first? Should I bounce back and forth or specialize in one?
* [Persisting Data in Blazor WebAssembly](https://www.youtube.com/watch?v=9i7XPpMcztM) - June 3, 2022 - Carl uses a client-side repository based on IndexedDB to persist data even without an Internet connection.
* [Using TypeScript with Blazor](https://www.youtube.com/watch?v=I_zFlBKgl5s) - ![duration](https://img.shields.io/badge/Duration:%20-20%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=microsoft) May 27, 2022 - Carl shows you how to use TypeScript when creating a Blazor component.
* [Build native apps for any device with .NET and Visual Studio](https://mybuild.microsoft.com/en-US/sessions/599c82b6-0c5a-4add-9961-48b85d9ffde0) - ![duration](https://img.shields.io/badge/Duration:%20-51%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=microsoft) May 25, 2022 - See how you can quickly and iteratively build modern, native and hybrid web apps for any device with Visual Studio and .NET Multi-platform App UI (.NET MAUI). We’ll take you on a tour of the tools and frameworks that can speed up your development time to create powerful, native desktop and mobile apps for Windows, macOS, iOS, and Android from a single codebase with .NET MAUI. We’ll also show you how to enhance your Blazor web apps with native device capabilities.
* [Native client apps with Blazor Hybrid](https://mybuild.microsoft.com/en-US/sessions/d2a86fe6-abb9-4939-a44d-ed660f9bb675?source=sessions) - ![duration](https://img.shields.io/badge/Duration:%20-27%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=microsoft) May 25, 2022 - Blazor uses the latest open web standards to enable full stack web development with .NET. But what if you need to build a native client app? Blazor is expanding beyond the web to enable support for building native client apps using a hybrid of web technologies and .NET. In this session we’ll look at the new  Blazor Hybrid support in .NET MAUI for building cross platform native client apps for mobile and desktop as well as Blazor Hybrid support for modernizing WPF and Windows Forms apps.
* [Future Possibilities for .NET Core and WASI (WebAssembly on the Server)](https://mybuild.microsoft.com/en-US/sessions/ddf48da7-d3e6-4ba5-affd-b5735ce205fa?source=sessions) - ![duration](https://img.shields.io/badge/Duration:%20-28%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=microsoft) May 25, 2022 - WebAssembly is moving beyond the browser and is pitched to become a foundational element of modern cloud-native architecture. It lets any language compile to universal binaries that run on any OS or processor, robustly sandboxed and with great performance. This session covers a new approach to running .NET in WASI environments. You’ll see how your existing .NET code could be built into WASI-compliant modules, plus the opportunities this opens. This is experimental, not yet a committed product. 
* [Learn .NET MAUI - Full Course for Beginners | Tutorial for iOS, Android, Mac, Windows in C#](https://www.youtube.com/watch?v=DuNLR_NJv8U) - May 23, 2022 - Let's start our journey together to build beautiful native cross-platform apps for iOS, Android, macOS, and Windows with [.NET MAUI](https://dotnet.microsoft.com/en-us/apps/maui), C#, and Visual Studio! In this full workshop, I will walk you through everything you need to know about [.NET MAUI](https://dotnet.microsoft.com/en-us/apps/maui) and building your very first app. You will learn the basics including how to build user interfaces with XAML, how MVVM and data binding simplify development, how to navigate between pages, access platform features like geolocation, optimize data collections, and theme your app for light theme and dark theme. This course has everything you need to learn the basics and set you up for success when building apps with [.NET MAUI](https://dotnet.microsoft.com/en-us/apps/maui).
* [Displaying Custom Reports in Blazor using Syncfusion](https://www.youtube.com/watch?v=CA8waGMYHbY) - ![duration](https://img.shields.io/badge/Duration:%20-50%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) May 20, 2022 - In the last video, we created a custom report using the Bold Reports Designer. We could use the provided Bold Reports Viewer to display the reports, but that does not always fit with what you want to accomplish. That is why today we will implement a report viewer in a Blazor Server application. That way, we can show our custom report to our clients directly inside of our site instead of sending them to a separate application.
* [Bringing WebAssembly to the .NET Mainstream - Steve Sanderson](https://www.youtube.com/watch?v=PIeYw7kJUIg) - ![duration](https://img.shields.io/badge/Duration:%20-30%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) May 19, 2022 - Many developers still consider WebAssembly to be a leading-edge, niche technology tied to low-level systems programming languages. However, C# and .NET have run on WebAssembly since 2017. Blazor WebAssembly brought .NET into the browser on open standards, and is now one of the fastest-growing parts of .NET across enterprises, startups, and hobbyists. Next, with WASI we could let you run .NET in even more places, introducing cloud-native tools and techniques to a wider segment of the global developer community. This is a technical talk showing how we bring .NET to WebAssembly. Steve will demonstrate how it runs both interpreted and AOT-compiled, how an IDE debugger can attach, performance tradeoffs, and how a move from Emscripten to WASI SDK lets it run in Wasmtime/Wasmer or higher-level runtimes like wasmCloud. Secondly, you'll hear lessons learned from Blazor as an open-source project - challenges and misconceptions faced bringing WebAssembly beyond early adopters.
* [Rapid development model for Blazor Web Assembly and typed end-to-end services](https://www.youtube.com/watch?v=BcQqCzm4tK0) - ![duration](https://img.shields.io/badge/Duration:%20-10%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) May 19, 2022 - In this video we use the [ServiceStack](https://servicestack.net/) Blazor WASM template to show how the combination of typed end-to-end services and Blazor is great for building line of business applications. The template provides a clean separation of concerns, typed end-to-end safety and rapid iteration thanks to shared C# language, Visual Studio Hot Reload and [ServiceStack](https://servicestack.net/) message centric design.
* [ASP.NET Community Standup - Let's build an app with .NET MAUI and Blazor](https://www.youtube.com/watch?v=7BDBLyADq7s&list=PLdo4fOcmZ0oX-DBuRG4u58ZTAJgBAeQ-t&index=2) - ![duration](https://img.shields.io/badge/Duration:%20-92%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) May 17, 2022 - Showcasing migrating a Blazor WASM PWA to .NET MAUI and Blazor Hybrid. [Community links](https://www.theurlist.com/blazor_community_standup_may_2022).
* [Making Blazor work with everything, plus WebAssembly on the server](https://www.youtube.com/watch?v=RevmsFXVJ5Q) - ![duration](https://img.shields.io/badge/Duration:%20-60%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) May 13, 2022 - Talk by Steve Sanderson at the NDC London 2022. Real-world software projects often involve combining many technologies. So, is modern Blazor powerful and flexible enough for your team's needs? In this demo-heavy talk, Steve will show how Blazor WebAssembly/Server can seamlessly embed libraries and logic written in other languages such as Rust or C/C++, how Blazor WebAssembly/Server components can be used inside other SPA frameworks such as React or Angular (or vice-versa) and how Blazor components can be used not only for web projects, but also shared with native apps for macOS, iOS, Android, and Windows (including WPF and WinForms) These capabilities should equip your team to take on the most ambitious projects with confidence. We'll then look further into the future and consider how WebAssembly is moving beyond the browser and is pitched to become a foundational element of cloud-native server apps. You'll be among the first to see an experimental new approach to compiling .NET applications into WASI-compliant universal binaries that can run on any OS or processor, robustly sandboxed and with great performance.
* [Creating Office Files in Blazor using Syncfusion - PDF, Word, Excel, and PowerPoint](https://www.youtube.com/watch?v=wyoCxzRLUsQ) - ![duration](https://img.shields.io/badge/Duration:%20-19%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) May 13, 2022 - Creating office files in C# has always been a popular solution. You can generate reports in formats that users are comfortable with. With the Syncfusion file controls, you can not only create Excel files, you can also create Microsoft Word documents, PowerPoint presentations, and PDF documents. In this video, we will look at the office file controls in Syncfusion and how to use them.
* [Building apps for Teams in .NET & Blazor](https://www.youtube.com/watch?v=3fLoxkuzzqo) - ![duration](https://img.shields.io/badge/Duration:%20-17%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) May 11, 2022 - John Miller joins James on this week's On .NET to chat about how .NET developers can build Microsoft Teams apps and bots completely with C#, .NET, and Blazor! John walks us through everything we need to know to get started and how to even publish apps for Teams.
* [Intro to Blazor Controls in Syncfusion](https://www.youtube.com/watch?v=eQ9S9rt-rKc) - ![duration](https://img.shields.io/badge/Duration:%20-42%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) May 11, 2022 - The Blazor controls in Syncfusion are pretty impressive. In this video, we will look at the DataGrid, charts, a Kanban-style board, a dashboard, autocomplete textboxes, context menus, signature pads, menu bars, toast messages, and more. There are so many controls to look at, in fact, that we are going to purposefully ignore the office file creation and display controls, as well as reporting. That way, we can spend more time on the other controls today and then focus on the office files in another video. The reporting will actually have two different videos dedicated to it.
* [Securing SPAs and Blazor Applications using the BFF (Backend for Frontend) Pattern](https://www.youtube.com/watch?v=DdNssiaIY_Q) - ![duration](https://img.shields.io/badge/Duration:%20-99%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) May 10, 2022 - Modern web development means that more and more application code is running in the browser. Traditionally this has been JavaScript but more recently there has been the trend to use C#/WASM with Blazor. These modern applications typically also need authentication and single-sign-on as well as token-based security for calling APIs – in other words OpenID Connect and OAuth 2. There are different patterns for securing such applications and this session covers some of the pitfalls of the various approaches, especially given the ever-changing browser landscape. We will conclude with the “backend for frontend” (or BFF) pattern which has become the most secure and stable of these approaches.
* [Multi-environment deployments with Azure DevOps and Static Web Apps](https://www.youtube.com/watch?v=4JkfeZp7aDk) - ![duration](https://img.shields.io/badge/Duration:%20-11%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) May 5, 2022 - App walkthrough, Create a static web app with an Azure DevOps pipeline, Add Azure DevOps environments and configure approvals, Configure a multi-stage pipeline, Static Web Apps named preview environments, Playwright tests, Manual approval before production deployment, Secure staging environments with a password. [Source code](https://github.com/anthonychu/swa-devops-pipeline-demo/blob/main/azure-pipelines.yml).
* [On .NET Live - Wrapping browser APIs in Blazor WASM](https://www.youtube.com/watch?v=ttXb-gIiRoE) - ![duration](https://img.shields.io/badge/Duration:%20-61%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) May 2, 2022 - In this week's episode, Kristoffer Strube joins the panel to show us a Blazor WASM wrapper for the browser File System Access API. He's bringing demos and code to share, so this is an episode you won't want to miss.
* [Securing SPAs and Blazor Applications using the BFF Pattern](https://www.youtube.com/watch?v=xzRhabmlc8M) - ![duration](https://img.shields.io/badge/Duration:%20-57%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) April 29, 2022 - Securing SPAs and Blazor Applications using the BFF (Backend for Frontend) Pattern at the NDC Porto, by Dominick Baier.
* [State management in Blazor](https://www.youtube.com/watch?v=L9p-9dGp-98) - ![duration](https://img.shields.io/badge/Duration:%20-63%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) April 29, 2022 - State management in Blazor, at the NDC Porto 2022. When developing a Single Page Application, a very important aspect is state management. Since Blazer is a component-based UI framework, how do we manage to update the UI when the state of the application changes.
* [Streaming three ways with Blazor: REST, gRPC, and SignalR](https://www.youtube.com/watch?v=cYP8TcokSFI) - ![duration](https://img.shields.io/badge/Duration:%20-45%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) April 29, 2022 - Streaming three ways with Blazor: REST, gRPC, and SignalR, by Carl Franklin at the NDC Porto 2022. Learn how to stream data from server to client to improve perceived performance and increase scalability. Carl shows how streaming works in general, and then how to implement using each of these three transports.
* [Intro to SignalR in C# Part 1 - using Blazor, WPF, best practices, and more](https://www.youtube.com/watch?v=RaXx_f3bIRU) - ![duration](https://img.shields.io/badge/Duration:%20-72%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) April 25, 2022 - SignalR is an excellent way to connect two or more clients together for real-time communication. The best part is that this library is just a wrapper around web-standard technologies such as Web Sockets and Long-Polling. It just makes them easier to use. That means we can even use SignalR with other clients such as Java or JavaScript. In this video, we are going to learn how to set up SignalR and how to connect to it using web clients and desktop clients. Throughout the video, we will cover best practices, as well as how to use this in the real world.
* [Revisiting MVVM](https://www.youtube.com/watch?v=M4tgU-V7peI) - ![duration](https://img.shields.io/badge/Duration:%20-20%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) April 21, 2022 - Carl revisits the topic of MVVM with Blazor, clarifying your options.
* [Queryable Repositories](https://www.youtube.com/watch?v=5q21Olur050) - ![duration](https://img.shields.io/badge/Duration:%20-28%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) April 14, 2022 - Build a generic repository that the client can query.
* [ASP.NET Community Standup - Blazorators: Blazor C# Source Generators](https://www.youtube.com/watch?v=U8XriF2zxS0) - ![duration](https://img.shields.io/badge/Duration:%20-57%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) April 12, 2022 - David Pine introduces Blazorators, Blazor C# Source Generators on this month's Blazor Community Standup. [Community links](https://www.theurlist.com/blazor_community_standup_april_2022).
* [.NET MAUI Blazor - Build Hybrid Mobile, Desktop, and Web apps](https://www.youtube.com/watch?v=qkzyqDUjPHs) - ![duration](https://img.shields.io/badge/Duration:%20-47%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) April 1, 2022 - Blazor enables building client-side web UI with .NET, but sometimes you need more than what the web platform offers. Sometimes you need full access to the native capabilities of the device. You can now host Blazor components in .NET MAUI apps to build cross-platform native apps using web UI. The components run natively in the .NET process and render web UI to an embedded web view control using a local interop channel. This hybrid approach gives you the best of native and the web. Your components can access native functionality through the .NET platform, and they render standard web UI. .NET MAUI Blazor apps can run anywhere .NET MAUI can (Windows, Mac, iOS, and Android).
* [Managing App State with Fluxor](https://www.youtube.com/watch?v=Vn6dKN_hTrs) - ![duration](https://img.shields.io/badge/Duration:%20-23%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) March 31, 2022 - pp State Management using Fluxor, a Flux/Redux library for Blazor.
* [Blazor Basics with Identity](https://www.youtube.com/watch?v=lGabdG5Ge8Y) - ![duration](https://img.shields.io/badge/Duration:%20-128%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) Mars 14, 2022 - Fritz shows you how to connect authentication and authorization to your Blazor app.  We'll focus on how to connect a properly configured Microsoft Identity application to your Blazor framework.
* [ASP.NET Community Standup - Native client apps with Blazor Hybrid](https://www.youtube.com/watch?v=7UM6s0QPvRQ) - ![duration](https://img.shields.io/badge/Duration:%20-88%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) Mars 8, 2022 - Join this Blazor Community Standup to learn more about using Blazor Hybrid to create cross-platform native client apps for Windows, iOS, Android & Mac. [Community links](https://www.theurlist.com/blazor_community_standup_march_2022).
* [Building beautiful Blazor apps with Tailwind CSS](https://www.youtube.com/watch?v=zS0y9krXO6E) - ![duration](https://img.shields.io/badge/Duration:%20-55%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) Mars 2, 2022 - Tailwind CSS has been growing in popularity for some time. It’s fast becoming one of the top frameworks to use when styling applications. It offers a different approach to the traditional frameworks like Bootstrap—utility based styling. Rather than using prebuilt components—which result in your application looking like a lot of others on the web—you can tailor your design by applying small focused CSS classes resulting in a unique style for your app. In this talk, you will learn how to bring the power of Tailwind CSS to your Blazor applications. We’ll start off with an introduction to Tailwind and how it differs from other CSS frameworks. Then we’ll get into some code and see how we can integrate Tailwind with Blazor. For the rest of the time, we’ll explore the various features of Tailwind and see how just how beautiful we can make our Blazor app. By Chris Sainty, at the NDC Oslo 2021.
* [Best practices unit testing Blazor components with bUnit](https://www.youtube.com/watch?v=Co7QetPYiO4) - ![duration](https://img.shields.io/badge/Duration:%20-54%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) Mars 1, 2022 - Why create tests of UI components? Isn’t UI tests inherently brittle, run slowly, and hard to maintain? By Egil Hansen, at the NDC Oslo 2021.
* [Learn C# with CSharpFritz - Blazor Application Hosting](https://www.youtube.com/watch?v=AYXx5vPFzFo) - ![duration](https://img.shields.io/badge/Duration:%20-124%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) February 28, 2022 - You've built your Blazor application, now where do you run it?  In this demo filled session, Fritz will talk through Progressive Web Apps, packaging with Docker, and deploying your Blazor application to Azure. [Community links](https://github.com/csharpfritz/csharp_with_csharpfritz).
* [Blazor, NET 6, and WebAssembly](https://www.youtube.com/watch?v=Rn8psTi8FBk) - ![duration](https://img.shields.io/badge/Duration:%20-60%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) February 21, 2022 - Talk by Steve Sanderson at the NDC Oslo 2021. .NET 6 is a huge release for Blazor, adding a ton of powerful new features for .NET web developers. This talk will be full of demos to get you up-to-speed on this hot framework.
* [Building a classic adventure game with Blazor](https://www.youtube.com/watch?v=WG4Pp1NGXUw) - ![duration](https://img.shields.io/badge/Duration:%20-88%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) ![duration](https://img.shields.io/badge/Duration:%20-61%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) February 14, 2022 - Blazor is a free and open-source web framework that enables developers to create web apps using C# and HTML. Being a .NET developer as well as a big fan of classic point-and-click adventure games, I’ve ported my Game-a-Tron 4000 adventure game engine to Blazor.
* [ASP.NET Community Standup - Blazor .NET 7 Roadmap](https://www.youtube.com/watch?v=3o91I6lD-Bo) - ![duration](https://img.shields.io/badge/Duration:%20-88%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) February 8, 2022 - Find out what's being planned for Blazor in .NET 7. [Community links](https://www.theurlist.com/blazor_community_standup_february_2022).
* [C# Corner .NET Conference Day 1](https://www.youtube.com/watch?v=LpoYTZSMeG0) - ![duration](https://img.shields.io/badge/Duration:%20-390%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) January 24, 2022 - The first day of the conference kicks off with a keynote session by Scott Hunter. Day one is focused on front-end technologies (Blazor). [Conference website](https://dotnetconference.com).
* [ASP.NET Community Standup - Blazor WebAssembly on .NET 6](https://www.youtube.com/watch?v=8gwSU3oaMV8) - ![duration](https://img.shields.io/badge/Duration:%20-78%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) January 11, 2022 - Join Blazor creator Steve Sanderson for a special look at Blazor WebAssembly on .NET 6. [Community links](https://www.theurlist.com/blazor_community_standup_january_2022).
