# Contribution Guidelines

Please note that this project is released with a [Contributor Code of Conduct](CODE-OF-CONDUCT.md). By participating in this project you agree to abide by its terms.

## Contents

- [Adding to This List](#adding-to-this-list)
- [Updating Your Pull Request](#updating-your-pull-request)

## Adding to This List

Please ensure your pull request adheres to the following guidelines:

- Search open and closed PRs to avoid duplicate suggestions.
- Only submit CSS tips that you think would be useful to others. This implies each tip has enough succinct content to describe why it's useful.
- Add your tip at the bottom of the [README](https://github.com/AllThingsSmitty/css-protips/blob/master/README.md) document. Add a link to your tip at the bottom of the table of contents.
- Use [title-case](https://titlecaseconverter.com/).
- Code formatting should follow standard [CSSLint](http://www.csslint.net) default settings, including:
  - Indent with two spaces
  - Use shorthand, e.g., `margin: 10px 10px 0.5rem;`
  - Use double quotes, e.g., `background: url("logo.svg");`
  - Use leading zeros with numberic values, e.g., `padding: 0.75rem;`
  - Sort properties alphabetically
  - **Avoid letting your code formatter format other section of the README file.**
- Make sure your text editor is set to remove trailing whitespace.
- Check your spelling and grammar.
- The PR should have a useful title.

Thank you for your suggestions!

## Updating Your Pull Request

Sometimes a maintainer will ask you to edit your pull request before it's included. This is normally due to spelling errors or because your PR didn't match the above guidelines. [This write-up](https://github.com/RichardLitt/knowledge/blob/master/github/amending-a-commit-guide.md) covers the different ways you can change a pull request.
