<p align="center">
  <img src="../../assets/img/bulb.svg" width="200" alt="light bulb icon">
</p>

# Εξελιγμένες συμβουλές για CSS [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

Μια συλλογή από συμβουλές για να φτάσατε τις CSS ικανότητές σας σε επαγγελματικό επίπεδο

> Για άλλες ωραίες λίστες με συμβουλές δείτε την λίστα του [@sindresorhus](https://github.com/sindresorhus/) με [τέλειες λίστες](https://github.com/sindresorhus/awesome/).


## Πίνακας περιεχομένων

* [Προχωρημένες Συμβουλές](#προχωρημένες-συμβουλές)
* [Υποστήριξη](#υποστήριξη)
* [Μεταφράσεις](../../CONTRIBUTING.md)


## Προχωρημένες Συμβουλές

1. [Χρήση μίας CSS επαναφοράς](#χρήση-μίας-CSS-επαναφοράς)
1. [Κληρονόμιση του 'box-sizing'](#κληρονόμιση-του-box-sizing)
1. [Χρήση `unset` Αντί Για Επαναφορά Όλων Των Ιδιοτήτων](#χρήση-unset-αντί-για-επαναφορά-όλων-των-ιδιοτήτων)
1. [Χρήση `:not()` για Εφαρμόσεις/Βγάλεις τα Πλαίσια κατά την Περιήγηση](#χρήση-not-για-εφαρμόσειςβγάλεις-τα-πλαίσια-κατά-την-περιήγηση)
1. [Überprüfen Sie, ob die Schriftart lokal installiert ist](#Überprüfen-sie-ob-die-schriftart-lokal-installiert-ist)
1. [Προσθήκη `line-height` στο `body`](#προσθήκη-line-height-στο-body)
1. [Θέσε `:focus` για Στοιχεία της Φόρμας](#θέσε-focus-για-στοιχεία-της-φόρμας)
1. [Κάθετο-Κεντράρισμα Όλων](#κάθετο-κεντράρισμα-όλων)
1. [Λίστες που Χωρίζονται-με-Κόμμα](#λίστες-που-χωρίζονται-με-κόμμα)
1. [Επίλογη Αντικειμένων με Χρήση Αρνητικού `nth-child`](#επίλογη-αντικειμένων-με-χρήση-αρνητικού-nth-child)
1. [Χρήση SVG για Εικονίδια](#χρήση-SVG-για-εικονίδια)
1. [Χρήση της "Λοβοτομημένης Κουκουβάγιας" για Διαλέκτη](#χρήση-της-λοβοτομημένης-κουκουβάγιας-για-διαλέκτη)
1. [Χρήση `max-height` για Αγνούς CSS Ολισθητές](#χρήση-max-height-για-αγνούς-CSS-ολισθητές)
1. [Ίσου-Πλάτους Κελία Πίνακα](#ίσου-πλάτους-κελία-πίνακα)
1. [Απέβαλλε τα Hacks των Περιθωρίων Με Flexbox](#απέβαλλε-τα-hacks-των-περιθωρίων-με-flexbox)
1. [Χρήση Επιλογής Χαρακτηριστικών με Κένα Links](#χρήση-επιλογής-χαρακτηριστικών-με-κένα-links)
1. [Δώσε στυλ στα "Προκαθορισμένα" Links](#δώσε-στυλ-στα-προκαθορισμένα-links)
1. [Εσωτερικά Κουτία Αναλογιών](#εσωτερικά-κουτία-αναλογιών)
1. [Εικόνες με Χαλασμένο Στυλ](#εικόνες-με-χαλασμένο-στυλ)
1. [Χρήση `rem` για Προσαρμογή Μεγέθους Παντού; Χρήση `em` για Τοπική Προσαρμογή Μεγέθους](#χρήση-rem-για-προσαρμογή-μεγέθους-παντού-χρήση-em-για-τοπική-προσαρμογή-μεγέθους)
1. [Απόκριψη Βίντεο με Αυτόματη Αναπαραγωγή Που Δεν Είναι σε Σίγαση](#απόκριψη-βίντεο-με-αυτόματη-αναπαραγωγή-που-δεν-είναι-σε-σίγαση)
1. [Χρήση `:root` για Ευέλικτη Γραφή](#χρήση-root-για-ευέλικτη-γραφή)
1. [Ανάθεση `font-size` στα Στοιχεία της Φόρμας για Καλύτερη Εμπειρία από Κινητό](#ανάθεση-font-size-στα-στοιχεία-της-φόρμας-για-καλύτερη-εμπειρία-από-κινητό)
1. [Χρήση Γεγονότων Δείκτη για Έλεγχο Γεγονότων του Ποντικιού](#χρήση-γεγονότων-δείκτη-για-έλεγχο-γεγονότων-του-ποντικιού)
1. [Ανάθεση `display: none` στο Τέλος των Γραμμών που Χρησιμοποιείται σαν Κενό](#ανάθεση-display-none-στο-τέλος-των-γραμμών-που-χρησιμοποιείται-σαν-κενό)


### Χρήση μίας CSS επαναφοράς

Η επαναφορά του CSS βοηθάει στο στυλ αλλά καί στην σταθερότητα ανάμεσα σε διαφορετικόυς περιηγητές αναζήτησης με καθαρό πίνακα για στυλιστικά στοιχεία.Μπορείτε να χρησιμοποιήσετε μια βιβλιοθήκη CSS επαναφοράς ετσι [Normalize](http://necolas.github.io/normalize.css/), _και αλλα._, η μπορείτε να χρησιμοποιήσετε μια πιο απλοποιημένη προσέγγιση επαναφοράς:

```css
*,
*::before,
*::after {
  box-sizing: border-box;
  margin: 0;
  padding: 0;
}
```

Τωρα τα στοιχεία θα βγουν από τα περιθώρια και από την επένδυση, και το `box-sizing` σε αφήνει να διαχειριστείς τις διατάξεις με το CSS box model.

#### [Demo](http://codepen.io/AllThingsSmitty/pen/kkrkLL)

**Σημείωση:** Αν ακολουθήσετε την [Κληρονόμιση του 'box-sizing'](#κληρονόμιση-του-box-sizing) σαν tip θα πρέπει να μην συμπεριληφθεί το 'box-sizing' στην CSS επαναφορά.

<sup>[πίσω στον πίνακα περιεχομένων](#πίνακας-περιεχομένων)</sup>


### Κληρονόμιση του 'box-sizing'

Ας κληρονομιθεί το `box-sizing` από `html`:

```css
html {
  box-sizing: border-box;
}

*,
*::before,
*::after {
  box-sizing: inherit;
}
```

Αυτό κάνει πιο εύκολο να αλλάξει το `box-sizing` σε πρόσθετα η σε άλλα συστατικά που μοχλεύουν άλλη συμπεριφορά.

#### [Démo](https://css-tricks.com/inheriting-box-sizing-probably-slightly-better-best-practice/)

<sup>[πίσω στον πίνακα περιεχομένων](#πίνακας-περιεχομένων)</sup>


### Χρήση `unset` Αντί Για Επαναφορά Όλων Των Ιδιοτήτων

Όταν επαναφέρεις τις ιδιότητες ενός στοιχείου δεν είναι απαραίτητο να επαναφέρεις τις ιδιότητες κάθε ξεχωριστού στοιχείου:

```css
button {
  background: none;
  border: none;
  color: inherit;
  font: inherit;
  outline: none;
  padding: 0;
}
```

Μπορείς να καθορίσεις όλες τις ιδιότητες ενός στοιχείου χρησιμοποιόντας το `all` στενογραφημένο. Αν θέσεις την τιμή σε `unset` άλλαζει τις ιδιότητες ενός στοιχείου στις αρχικές:

```css
button {
  all: unset;
}
```

<sup>[πίσω στον πίνακα περιεχομένων](#πίνακας-περιεχομένων)</sup>


### Χρήση `:not()` για Εφαρμόσεις/Βγάλεις τα Πλαίσια κατά την Περιήγηση

Αντί να θέσεις το περιθώριο...

```css
/* add border */
.nav li {
  border-right: 1px solid #666;
}
```

...και μετά να το βγάλεις από το τελευταίο στοιχείο...

```css
/* remove border */
.nav li:last-child {
  border-right: none;
}
```

...χρησιμοποίησε το `:not()` μια ψευδοκλάση που εφαρμόζεται μόνο στα στοιχεία που θες:

```css
.nav li:not(:last-child) {
  border-right: 1px solid #666;
}
```

Εδώ, ο CSS επιλέκτης διαβάστηκε όπως αν το περιέγραφε ένας άνθρωπος.

#### [Demo](http://codepen.io/AllThingsSmitty/pen/LkymvO)

<sup>[πίσω στον πίνακα περιεχομένων](#πίνακας-περιεχομένων)</sup>


### Überprüfen Sie, ob die Schriftart lokal installiert ist

Sie können überprüfen, ob eine Schriftart lokal installiert ist, bevor Sie sie remote abrufen. Dies ist auch ein guter Leistungstipp.

```css
@font-face {
  font-family: "Dank Mono";
  src:
    /* Full name */
    local("Dank Mono"),
    /* Postscript name */
    local("Dank-Mono"),
    /* Otherwise, download it! */
    url("//...a.server/fonts/DankMono.woff");
}

code {
  font-family: "Dank Mono", system-ui-monospace;
}
```

Hutspitze an Adam Argyle für das Teilen dieses Protips und dieser [Demo](https://codepen.io/argyleink/pen/VwYJpgR).

<sup>[πίσω στον πίνακα περιεχομένων](#πίνακας-περιεχομένων)</sup>


### Προσθήκη `line-height` στο `body`

Δεν χρειάζεται να προσθέσεις `line-height`σε κάθε `<p>`, `<h*>`, _et al_. ξεχωριστά. Αντ'αυτού, πρόσθεσέ το `body`:

```css
body {
  line-height: 1.5;
}
```

Με αυτόν τον τρόπο τα στοιχεία κειμένου μπορούν να κληρονομήσουν από το `body` έυκολα.

#### [Demo](http://codepen.io/AllThingsSmitty/pen/VjbdYd)

<sup>[πίσω στον πίνακα περιεχομένων](#πίνακας-περιεχομένων)</sup>


### Θέσε `:focus` για Στοιχεία της Φόρμας

Όσοι χρήστες έχουν όραση και χρησιμοποιούν πληκτρολογιο μπορούν να βασιστούν στην συγκέντωση για να αποφασίσουν
που πηγαίνουν τα γεγονότα του πληκτρολογίου στην σελίδα.Κάντε τα στοίχεια συγκέντρωσης να ξεχωρίζουν και σταθερά
σε μια προκαθορισμένη εφαρμογή του browser:

```css
a:focus,
button:focus,
input:focus,
select:focus,
textarea:focus {
  box-shadow: none;
  outline: #000 dotted 2px;
  outline-offset: .05em;
}
```

#### [Demo](https://codepen.io/AllThingsSmitty/pen/ePzoOP/)

<sup>[πίσω στον πίνακα περιεχομένων](#πίνακας-περιεχομένων)</sup>


### Κάθετο-Κεντράρισμα Όλων

Όχι δεν είναι μαύρη μαγεία, μπορείτε όντως να κεντράρετε τα στοιχεία κάθετα. Μπορείτε να το κάνετε αυτό με flexbox...

```css
html,
body {
  height: 100%;
  margin: 0;
}

body {
  -webkit-align-items: center;
  -ms-flex-align: center;
  align-items: center;
  display: -webkit-flex;
  display: flex;
}
```

...και επίσης με CSS Grid:

```css
body {
  display: grid;
  height: 100vh;
  margin: 0;
  place-items: center center;
}
```


Θέλετε να κεντραρίσετε κάτι άλλο? Vertically, Κάθετα, οριζόντια...όπως θέλετε,όποτε θέλετε, παντού? Το CSS-Tricks έχει [a nice write-up](https://css-tricks.com/centering-css-complete-guide/) on doing all of that.

#### [Demo](http://codepen.io/AllThingsSmitty/pen/GqmGqZ)

<sup>[πίσω στον πίνακα περιεχομένων](#πίνακας-περιεχομένων)</sup>


### Λίστες που Χωρίζονται-με-Κόμμα

Κάντε τα αντικείμενα λίστας να φαίνονται σαν πραγματικές, χωρισμένες-με-κόμμα λίστες:

```css
ul > li:not(:last-child)::after {
  content: ",";
}
```

Χρησιμοποιείστε την `:not()` ψευδοκλάση και κανένα κόμμα δεν θα προσθεθεί στο τελευταίο αντικείμενο.

**Σημείωση:** Αυτο το tip μπορεί να μην είναι ιδανικό για προσβασιμότητα, ειδικά για αυτούς που διαβάζουν απο οθόνη. Και το copy/paste από τον browser δεν δουλεύει με περιεχόμενο CSS-generated.Συνεχίστε με προσοχή.

<sup>[πίσω στον πίνακα περιεχομένων](#πίνακας-περιεχομένων)</sup>


### Επίλογη Αντικειμένων με Χρήση Αρνητικού `nth-child`

Χρηιμοποιείστε το αρνητικό `nth-child` στην CSS για να επιλέξετε 1 αντικείμενο από τα n.

```css
li {
  display: none;
}

/* select items 1 through 3 and display them */
li:nth-child(-n+3) {
  display: block;
}
```

Η, αφού ήδη μάθατε να σχετικά με το [using `:not()`](#use-not-to-applyunapply-borders-on-navigation), δοκιμάστε:

```css
/* select all items except the first 3 and display them */
li:not(:nth-child(-n+3)) {
  display: block;
}
```

#### [Demo](http://codepen.io/AllThingsSmitty/pen/WxjKZp)

<sup>[πίσω στον πίνακα περιεχομένων](#πίνακας-περιεχομένων)</sup>


### Χρήση SVG για Εικονίδια

Δεν υπάρχει λόγος να μην χρησιμοποιήσετε SVG για εικονίδια:

```css
.logo {
  background: url("logo.svg");
}
```

το SVG κλιμακώνεται ωραία με για όλους τους τύπους ανάλυσης και υποστηρίζεται από όλους του περιηγητές [back to IE9](http://caniuse.com/#search=svg). Ρίξτε τα .png, .jpg, or .gif-jif-whatev αρχεία σας.

**Σημείωση:** Αν έχετε μόνο SVG εικονίδια για κουμπιά για τους χρήστες με όραση και το SVG αποτύχει να φορτωθεί, αυτό θα βοηθήσει να διατηρηθεί η προσβασιμότητα:

```css
.no-svg .icon-only::after {
  content: attr(aria-label);
}
```

<sup>[πίσω στον πίνακα περιεχομένων](#πίνακας-περιεχομένων)</sup>


### Χρήση της "Λοβοτομημένης Κουκουβάγιας" για Διαλέκτη

Μπορεί να έχει περίεργο όνομα αλλά το να χρησιμοποιείς τον καθολικό επιλέκτη (`*`) μαζί με τον παρακείμενο επιλέκτη (`+`) μπορεί να παρέχει μια ισχυρή CSS δυνατότητα:

```css
* + * {
  margin-top: 1.5em;
}
```

Σε αυτό το παράδειγμα, όλα τα στοιχεία στην ροή του αρχείου που ακολουθεί άλλα στοιχεία θα παραλάβει `margin-top: 1.5em`.

Για περισσότερα πάνω στον επιλέκτη της "Λοβοτομημένης Κουκουβάγιας", διαβάστε [Heydon Pickering's post](http://alistapart.com/article/axiomatic-css-and-lobotomized-owls) πάνω στο *A List Apart*.

#### [Demo](http://codepen.io/AllThingsSmitty/pen/grRvWq)

<sup>[πίσω στον πίνακα περιεχομένων](#πίνακας-περιεχομένων)</sup>


### Χρήση `max-height` για Αγνούς CSS Ολισθητές

Εφαρμογή σε CSS-only διαφάνεις με χρήση `max-height` με την υπερχύλιση κρυμμένη:

```css
.slider {
  max-height: 200px;
  overflow-y: hidden;
  width: 300px;
}

.slider:hover {
  max-height: 600px;
  overflow-y: scroll;
}
```

Το στοιχείο επεκτείνεται στην `max-height` τιμή σε περίπτωση αιώρησης του δέικτη από πάνω και οι η διαφάνεια προβάλλει σας αποτέλεμα υπερχύλισης.

<sup>[πίσω στον πίνακα περιεχομένων](#πίνακας-περιεχομένων)</sup>


### Ίσου-Πλάτους Κελία Πίνακα

Οι πίνακες μπορεί να είναι δύσκολοι να δουλέψει κανείς. Προσπαθήστε να χρησιμοποιήσετε το `table-layout: fixed` για να διατηρίσετε τα κελία με ίδιο πλάτος:

```css
.calendar {
  table-layout: fixed;
}
```

Χωρίς-κόπο διατάξεις πινάκων.

#### [Demo](http://codepen.io/AllThingsSmitty/pen/jALALm)

<sup>[πίσω στον πίνακα περιεχομένων](#πίνακας-περιεχομένων)</sup>


### Απέβαλλε τα Hacks των Περιθωρίων Με Flexbox

Οτάν δουλέυεις με αυλάκια στήλης μπορείς να ξεφορτοθείς το `nth-`, `first-`, και `last-child` hacks με την χρήση της ιδιότητας του flexbox `space-between` :

```css
.list {
  display: flex;
  justify-content: space-between;
}

.list .person {
  flex-basis: 23%;
}
```

Τώρα τα αυλάκια των στηλών φαίνονται ίσα κατανεμημένα.

<sup>[πίσω στον πίνακα περιεχομένων](#πίνακας-περιεχομένων)</sup>


### Χρήση Επιλογής Χαρακτηριστικών με Κένα Links

Εμφανίστε τα links όταν το `<a>` στοιχείο δεν έχει τιμή αλλά το `href` πεδίο εχει ενα link:

```css
a[href^="http"]:empty::before {
  content: attr(href);
}
```

Αυτό είναι πολύ βολικό.

#### [Demo](http://codepen.io/AllThingsSmitty/pen/zBzXRx)

<sup>[πίσω στον πίνακα περιεχομένων](#πίνακας-περιεχομένων)</sup>


### Δώσε στυλ στα "Προκαθορισμένα" Links

Προσθέστε στυλ στα "προκαθορισμένα" links:

```css
a[href]:not([class]) {
  color: #008000;
  text-decoration: underline;
}
```

Τωρα τα link που εισχωρήθηκαν μεσω CMS, που συνήθς δεν έχουν πεδίο `class` , θα διαφοροποιούνται χωρίς να επηρεάζουν την γενική αλληλουχία.

<sup>[πίσω στον πίνακα περιεχομένων](#πίνακας-περιεχομένων)</sup>


### Εσωτερικά Κουτία Αναλογιών

Για να φτιάξετε ενα κουτί με εσωτερική αναλογία, το μόνο που πρέπει να κάνετε είναι να εφαρμόσετε ενα top η bottom γέμισμα  σε ένα div:

```css
.container {
  height: 0;
  padding-bottom: 20%;
  position: relative;
}

.container div {
  border: 2px dashed #ddd;
  height: 100%;
  left: 0;
  position: absolute;
  top: 0;
  width: 100%;
}
```
Το να χρησιμοποιείς το 20% του γεμίσματος κάνει το ύψος του κουτιού ίσο με 20% απο το πλάτος του. Άσχετα με το πλάτος της θέας, το παιδί div θα κρατήσει την κλίμακά του (100% / 20% = 5:1).

#### [Demo](http://codepen.io/AllThingsSmitty/pen/jALZvE)

<sup>[πίσω στον πίνακα περιεχομένων](#πίνακας-περιεχομένων)</sup>

### Εικόνες με Χαλασμένο Στυλ

Κάντε τις χαλασμένες εικόνες πιο αισθητικά όμορφες με λίγο CSS:

```css
img {
  display: block;
  font-family: sans-serif;
  font-weight: 300;
  height: auto;
  line-height: 2;
  position: relative;
  text-align: center;
  width: 100%;
}
```

Τώρα προσθέστε ψευδόστοιχείων κανόνες για να εμφανίσετε ένα μύνημα χρήστη και μια αναφορά σε URL από την χαλασμένη εικόνα:

```css
img::before {
  content: "We're sorry, the image below is broken :(";
  display: block;
  margin-bottom: 10px;
}

img::after {
  content: "(url: " attr(src) ")";
  display: block;
  font-size: 12px;
}
```

Μάθετε περισσότερα σχετικά με το στυλ για αυτό το μοτίβο στού [Ire Aderinokun](https://github.com/ireade/)'s [αρχικό ποστ](http://bitsofco.de/styling-broken-images/).

<sup>[πίσω στον πίνακα περιεχομένων](#πίνακας-περιεχομένων)</sup>


### Χρήση `rem` για Προσαρμογή Μεγέθους Παντού; Χρήση `em` για Τοπική Προσαρμογή Μεγέθους

Αφού θέσετε το βασικό μέγεθος γραμματοσειράς στο root (`html { font-size: 100%; }`), θέστε το μέγεθος γραμματοσειράς για στοιχεία κειμένου σε `em`:

```css
h2 {
  font-size: 2em;
}

p {
  font-size: 1em;
}
```

Έπειτα θέστε το μέγεθος γραμματοσειράς για τις ενότητες σε `rem`:

```css
article {
  font-size: 1.25rem;
}

aside .module {
  font-size: .9rem;
}
```

Τώρα κάθε ενότητα διαχωρίζεται και είναι ευκολότερο να της δώσεις στυλ, πιο συντιρίσιμη, και ευπροσάρμοστη.

<sup>[πίσω στον πίνακα περιεχομένων](#πίνακας-περιεχομένων)</sup>


### Απόκριψη Βίντεο με Αυτόματη Αναπαραγωγή Που Δεν Είναι σε Σίγαση

Αυτό είναι ένα ωραίο κόλπο για έναν στυλ συνιθισμένου χρήστη. Αποφυγή κατακλυσμού χρήστη με ήχους από ενα βίντεο το οποίο παίζει αυτόματα όταν φορτωθεί η σελίδα. Αν ο ήχος δεν είναι σε σίγαση, μήν δείχνεις το βίντεο:

```css
video[autoplay]:not([muted]) {
  display: none;
}
```

Για άλλη μία φορά,εκμεταλλευόμαστε την χρήση της [`:not()`](#χρήση-not-για-εφαρμόσεις-βγάλεις-τα-πλαίσια-κατά-την-περιήγηση) ψευδοκλάσης.

<sup>[πίσω στον πίνακα περιεχομένων](#πίνακας-περιεχομένων)</sup>


### Χρήση `:root` για Ευέλικτη Γραφή

Ο τύπος της γραμματοσειράς σε μια αποκρίσιμη διαρρύθμιση θα πρέπει να είναι ικάνος να προσαρμόζεται με κάθε θέαση. Μπορείτε να υπολογίσετε το μέγεθος γραμματοσειράς με βάση το ύψος και το πλάτος της θέασης χρησιμοποιόντας το `:root`:

```css
:root {
  font-size: calc(1vw + 1vh + .5vmin);
}
```

Τώρα μπορείτε να χρησιμοποιήσετε την `root em` μονάδα βασισμένη στην τιμή που υπολογίστηκε από το `:root`:

```css
body {
  font: 1rem/1.6 sans-serif;
}
```

#### [Demo](http://codepen.io/AllThingsSmitty/pen/XKgOkR)

<sup>[πίσω στον πίνακα περιεχομένων](#πίνακας-περιεχομένων)</sup>


### Ανάθεση `font-size` στα Στοιχεία της Φόρμας για Καλύτερη Εμπειρία από Κινητό

Για να αποτρέψετε τους περιηγητές των κινητών (iOS Safari, _et al_.) απο το να μεγεθύνουν στα στοιχεία της HTML φόρμας όταν ένα `<select>` αναπτυσόμενο μενού επιλεχθέι στην οθόνη, προσθέστο το `font-size` στον κανόνα του επιλέκτη:

```css
input[type="text"],
input[type="number"],
select,
textarea {
  font-size: 16px;
}
```

:dancer:

<sup>[πίσω στον πίνακα περιεχομένων](#πίνακας-περιεχομένων)</sup>


### Χρήση Γεγονότων Δείκτη για Έλεγχο Γεγονότων του Ποντικιού


[Γεγονότα ποντικού](https://developer.mozilla.org/en-US/docs/Web/CSS/pointer-events) σου επιτρέπουν να καθορίσεις πώς το ποντίκι αλληλεπιδρά με ένα στοιχείο που ακουμπάει. Για να απενεργοποιήσετε το προκαθορισμένο γεγονός ποντικιου πάνω σε ένα κουμπί, για παράδειγμα:

```css
button:disabled {
  opacity: .5;
  pointer-events: none;
}
```

Είναι τόσο απλό.

<sup>[πίσω στον πίνακα περιεχομένων](#πίνακας-περιεχομένων)</sup>


### Ανάθεση `display: none` στο Τέλος των Γραμμών που Χρησιμοποιείται σαν Κενό

Καθώς ο [Harry Roberts επισήμανε](https://twitter.com/csswizardry/status/1170835532584235008), αυτό μπορει να βοηθήσει τους CMS χρήστες να αποφύγουν την χρήση παραπάνω νέων γραμμών αντί για κένο :

```css
br + br {
  display: none;
}
```

<sup>[πίσω στον πίνακα περιεχομένων](#πίνακας-περιεχομένων)</sup>


## Υποστήριξη

Οι τωρινές εκδόσεις των Chrome, Firefox, Safari, καθώς και Edge.

<sup>[πίσω στον πίνακα περιεχομένων](#πίνακας-περιεχομένων)</sup>
