# Contribution Guidelines

Please note that this project is released with a [Contributor Code of Conduct](CODE-OF-CONDUCT.md). By participating in this project you agree to abide by its terms.

## Table of Contents

- [Adding to This List](#adding-to-this-list)
- [Updating Your Pull Request](#updating-your-pull-request)

## Adding to This List

Please ensure your pull request adheres to the following guidelines:

- Search open and closed PR's to avoid duplicate suggestions.
- Only submit jQuery tips that you think would be useful to others. This implies each tip has enough succinct content to describe why it's useful.
- Add your tip at the bottom of the [README](https://github.com/AllThingsSmitty/jquery-tips-everyone-should-know/blob/master/README.md) document. Add a link to your tip at the bottom of the table of contents.
- Use [title-casex](https://titlecaseconverter.com/).
- Code formatting should follow standard [JSLint](http://www.jslint.com/) default settings, including:
  - Indent with two spaces
  - Use single quotes, e.g., `$.preloadImages('img/hover-on.png');`
- Make sure your text editor is set to remove trailing whitespace.
- Check your spelling and grammar.
- The PR should have a useful title.

Thank you for your suggestions!

### Language Translations

If you fluently speak another language and want to contribute by translating this list into that language, please submit a PR using the following guidelines:

- Add a new folder to the [`translations`](https://github.com/AllThingsSmitty/jquery-tips-everyone-should-know/tree/master/translations) folder
- The new folder should be labeled the language culture name, e.g, `es-ES`, `ru-RU`, `zh-CN`, etc.

Additionally, feel free to review already translated content for accuracy.

## Updating Your Pull Request

Sometimes a maintainer will ask you to edit your pull request before it's included. This is normally due to spelling errors or because your PR didn't match the above guidelines. [This write-up](https://github.com/RichardLitt/knowledge/blob/master/github/amending-a-commit-guide.md) covers the different ways you can change a pull request
