# fastapp


<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

This module provides the
[`fast_app`](https://AnswerDotAI.github.io/fasthtml/api/fastapp.html#fast_app)
convenience wrapper. Usage can be summarized as:

``` python
from fasthtml.common import *

app, rt = fast_app()

@rt('/')
def get(): return Titled("A demo of fast_app()@")

serve()
```

------------------------------------------------------------------------

<a
href="https://github.com/AnswerDotAI/fasthtml/blob/main/fasthtml/fastapp.py#L36"
target="_blank" style="float:right; font-size:smaller">source</a>

### fast_app

>      fast_app (db_file:Optional[str]=None, render:Optional[<built-
>                infunctioncallable>]=None, hdrs:Optional[tuple]=None,
>                ftrs:Optional[tuple]=None, tbls:Optional[dict]=None,
>                before:Union[tuple,NoneType,fasthtml.core.Beforeware]=None,
>                middleware:Optional[tuple]=None, live:bool=False,
>                debug:bool=False, routes:Optional[tuple]=None,
>                exception_handlers:Optional[dict]=None,
>                on_startup:Optional[<built-infunctioncallable>]=None,
>                on_shutdown:Optional[<built-infunctioncallable>]=None,
>                lifespan:Optional[<built-infunctioncallable>]=None,
>                default_hdrs=True, pico:Optional[bool]=None,
>                surreal:Optional[bool]=True, htmx:Optional[bool]=True,
>                ws_hdr:bool=False, secret_key:Optional[str]=None,
>                key_fname:str='.sesskey', session_cookie:str='session_',
>                max_age:int=31536000, sess_path:str='/', same_site:str='lax',
>                sess_https_only:bool=False, sess_domain:Optional[str]=None,
>                htmlkw:Optional[dict]=None, bodykw:Optional[dict]=None,
>                reload_attempts:Optional[int]=1,
>                reload_interval:Optional[int]=1000, **kwargs)

*Create a FastHTML or FastHTMLWithLiveReload app.*

|                    | **Type** | **Default** | **Details**                                                                      |
|--------------------|----------|-------------|----------------------------------------------------------------------------------|
| db_file            | Optional | None        | Database file name, if needed                                                    |
| render             | Optional | None        | Function used to render default database class                                   |
| hdrs               | Optional | None        | Additional FT elements to add to                                                 |
| ftrs               | Optional | None        | Additional FT elements to add to end of                                          |
| tbls               | Optional | None        | Experimental mapping from DB table names to dict table definitions               |
| before             | Union    | None        | Functions to call prior to calling handler                                       |
| middleware         | Optional | None        | Standard Starlette middleware                                                    |
| live               | bool     | False       | Enable live reloading                                                            |
| debug              | bool     | False       | Passed to Starlette, indicating if debug tracebacks should be returned on errors |
| routes             | Optional | None        | Passed to Starlette                                                              |
| exception_handlers | Optional | None        | Passed to Starlette                                                              |
| on_startup         | Optional | None        | Passed to Starlette                                                              |
| on_shutdown        | Optional | None        | Passed to Starlette                                                              |
| lifespan           | Optional | None        | Passed to Starlette                                                              |
| default_hdrs       | bool     | True        | Include default FastHTML headers such as HTMX script?                            |
| pico               | Optional | None        | Include PicoCSS header?                                                          |
| surreal            | Optional | True        | Include surreal.js/scope headers?                                                |
| htmx               | Optional | True        | Include HTMX header?                                                             |
| ws_hdr             | bool     | False       | Include HTMX websocket extension header?                                         |
| secret_key         | Optional | None        | Signing key for sessions                                                         |
| key_fname          | str      | .sesskey    | Session cookie signing key file name                                             |
| session_cookie     | str      | session\_   | Session cookie name                                                              |
| max_age            | int      | 31536000    | Session cookie expiry time                                                       |
| sess_path          | str      | /           | Session cookie path                                                              |
| same_site          | str      | lax         | Session cookie same site policy                                                  |
| sess_https_only    | bool     | False       | Session cookie HTTPS only?                                                       |
| sess_domain        | Optional | None        | Session cookie domain                                                            |
| htmlkw             | Optional | None        | Attrs to add to the HTML tag                                                     |
| bodykw             | Optional | None        | Attrs to add to the Body tag                                                     |
| reload_attempts    | Optional | 1           | Number of reload attempts when live reloading                                    |
| reload_interval    | Optional | 1000        | Time between reload attempts in ms                                               |
| kwargs             |          |             |                                                                                  |
| **Returns**        | **Any**  |             |                                                                                  |

------------------------------------------------------------------------

<a
href="https://github.com/AnswerDotAI/fasthtml/blob/main/fasthtml/fastapp.py#L96"
target="_blank" style="float:right; font-size:smaller">source</a>

### PageX

>      PageX (title, *con)

------------------------------------------------------------------------

<a
href="https://github.com/AnswerDotAI/fasthtml/blob/main/fasthtml/fastapp.py#L95"
target="_blank" style="float:right; font-size:smaller">source</a>

### ContainerX

>      ContainerX (*cs, **kwargs)
