# Pico.css components


<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

`picocondlink` is the class-conditional css `link` tag, and `picolink`
is the regular tag.

``` python
show(picocondlink)
```

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@picocss/pico@latest/css/pico.conditional.min.css">
&#10;<style>:root { --pico-font-size: 100%; }</style>

------------------------------------------------------------------------

<a
href="https://github.com/AnswerDotAI/fasthtml/blob/main/fasthtml/pico.py#L28"
target="_blank" style="float:right; font-size:smaller">source</a>

### set_pico_cls

>      set_pico_cls ()

Run this to make jupyter outputs styled with pico:

``` python
set_pico_cls()
```

    <IPython.core.display.Javascript object>

------------------------------------------------------------------------

<a
href="https://github.com/AnswerDotAI/fasthtml/blob/main/fasthtml/pico.py#L47"
target="_blank" style="float:right; font-size:smaller">source</a>

### Card

>      Card (*c, header=None, footer=None, target_id=None, hx_vals=None,
>            id=None, cls=None, title=None, style=None, accesskey=None,
>            contenteditable=None, dir=None, draggable=None, enterkeyhint=None,
>            hidden=None, inert=None, inputmode=None, lang=None, popover=None,
>            spellcheck=None, tabindex=None, translate=None, hx_get=None,
>            hx_post=None, hx_put=None, hx_delete=None, hx_patch=None,
>            hx_trigger=None, hx_target=None, hx_swap=None, hx_include=None,
>            hx_select=None, hx_indicator=None, hx_push_url=None,
>            hx_confirm=None, hx_disable=None, hx_replace_url=None, hx_on=None,
>            **kwargs)

*A PicoCSS Card, implemented as an Article with optional Header and
Footer*

``` python
show(Card('body', header=P('head'), footer=P('foot')))
```

<article>
  <header><p>head</p>
</header>
body
  <footer><p>foot</p>
</footer>
</article>

------------------------------------------------------------------------

<a
href="https://github.com/AnswerDotAI/fasthtml/blob/main/fasthtml/pico.py#L55"
target="_blank" style="float:right; font-size:smaller">source</a>

### Group

>      Group (*c, target_id=None, hx_vals=None, id=None, cls=None, title=None,
>             style=None, accesskey=None, contenteditable=None, dir=None,
>             draggable=None, enterkeyhint=None, hidden=None, inert=None,
>             inputmode=None, lang=None, popover=None, spellcheck=None,
>             tabindex=None, translate=None, hx_get=None, hx_post=None,
>             hx_put=None, hx_delete=None, hx_patch=None, hx_trigger=None,
>             hx_target=None, hx_swap=None, hx_include=None, hx_select=None,
>             hx_indicator=None, hx_push_url=None, hx_confirm=None,
>             hx_disable=None, hx_replace_url=None, hx_on=None, **kwargs)

*A PicoCSS Group, implemented as a Fieldset with role ‘group’*

``` python
show(Group(Input(), Button("Save")))
```

<fieldset role="group">
  <input>
  <button>Save</button>
</fieldset>

------------------------------------------------------------------------

<a
href="https://github.com/AnswerDotAI/fasthtml/blob/main/fasthtml/pico.py#L61"
target="_blank" style="float:right; font-size:smaller">source</a>

### Search

>      Search (*c, target_id=None, hx_vals=None, id=None, cls=None, title=None,
>              style=None, accesskey=None, contenteditable=None, dir=None,
>              draggable=None, enterkeyhint=None, hidden=None, inert=None,
>              inputmode=None, lang=None, popover=None, spellcheck=None,
>              tabindex=None, translate=None, hx_get=None, hx_post=None,
>              hx_put=None, hx_delete=None, hx_patch=None, hx_trigger=None,
>              hx_target=None, hx_swap=None, hx_include=None, hx_select=None,
>              hx_indicator=None, hx_push_url=None, hx_confirm=None,
>              hx_disable=None, hx_replace_url=None, hx_on=None, **kwargs)

*A PicoCSS Search, implemented as a Form with role ‘search’*

``` python
show(Search(Input(type="search"), Button("Search")))
```

<form enctype="multipart/form-data" role="search">
  <input type="search">
  <button>Search</button>
</form>

------------------------------------------------------------------------

<a
href="https://github.com/AnswerDotAI/fasthtml/blob/main/fasthtml/pico.py#L67"
target="_blank" style="float:right; font-size:smaller">source</a>

### Grid

>      Grid (*c, cls='grid', target_id=None, hx_vals=None, id=None, title=None,
>            style=None, accesskey=None, contenteditable=None, dir=None,
>            draggable=None, enterkeyhint=None, hidden=None, inert=None,
>            inputmode=None, lang=None, popover=None, spellcheck=None,
>            tabindex=None, translate=None, hx_get=None, hx_post=None,
>            hx_put=None, hx_delete=None, hx_patch=None, hx_trigger=None,
>            hx_target=None, hx_swap=None, hx_include=None, hx_select=None,
>            hx_indicator=None, hx_push_url=None, hx_confirm=None,
>            hx_disable=None, hx_replace_url=None, hx_on=None, **kwargs)

*A PicoCSS Grid, implemented as child Divs in a Div with class ‘grid’*

``` python
colors = [Input(type="color", value=o) for o in ('#e66465', '#53d2c5', '#f6b73c')]
show(Grid(*colors))
```

<div class="grid">
  <div><input type="color" value="#e66465">
</div>
  <div><input type="color" value="#53d2c5">
</div>
  <div><input type="color" value="#f6b73c">
</div>
</div>

------------------------------------------------------------------------

<a
href="https://github.com/AnswerDotAI/fasthtml/blob/main/fasthtml/pico.py#L74"
target="_blank" style="float:right; font-size:smaller">source</a>

### DialogX

>      DialogX (*c, open=None, header=None, footer=None, id=None,
>               target_id=None, hx_vals=None, cls=None, title=None, style=None,
>               accesskey=None, contenteditable=None, dir=None, draggable=None,
>               enterkeyhint=None, hidden=None, inert=None, inputmode=None,
>               lang=None, popover=None, spellcheck=None, tabindex=None,
>               translate=None, hx_get=None, hx_post=None, hx_put=None,
>               hx_delete=None, hx_patch=None, hx_trigger=None, hx_target=None,
>               hx_swap=None, hx_include=None, hx_select=None,
>               hx_indicator=None, hx_push_url=None, hx_confirm=None,
>               hx_disable=None, hx_replace_url=None, hx_on=None, **kwargs)

*A PicoCSS Dialog, with children inside a Card*

``` python
hdr = Div(Button(aria_label="Close", rel="prev"), P('confirm'))
ftr = Div(Button('Cancel', cls="secondary"), Button('Confirm'))
d = DialogX('thank you!', header=hdr, footer=ftr, open=None, id='dlgtest')
# use js or htmx to display modal
```

------------------------------------------------------------------------

<a
href="https://github.com/AnswerDotAI/fasthtml/blob/main/fasthtml/pico.py#L81"
target="_blank" style="float:right; font-size:smaller">source</a>

### Container

>      Container (*args, target_id=None, hx_vals=None, id=None, cls=None,
>                 title=None, style=None, accesskey=None, contenteditable=None,
>                 dir=None, draggable=None, enterkeyhint=None, hidden=None,
>                 inert=None, inputmode=None, lang=None, popover=None,
>                 spellcheck=None, tabindex=None, translate=None, hx_get=None,
>                 hx_post=None, hx_put=None, hx_delete=None, hx_patch=None,
>                 hx_trigger=None, hx_target=None, hx_swap=None,
>                 hx_include=None, hx_select=None, hx_indicator=None,
>                 hx_push_url=None, hx_confirm=None, hx_disable=None,
>                 hx_replace_url=None, hx_on=None, **kwargs)

*A PicoCSS Container, implemented as a Main with class ‘container’*
