# FAQ


<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

*Frequently Asked Questions*

## Why is FastHTML developed using notebooks?

Some people are under the impression that writing software in notebooks
is bad.

[Watch this
video](https://www.youtube.com/watch?v=9Q6sLbz37gk&ab_channel=JeremyHoward).
We’ve used Jupyter notebooks exported via `nbdev` to write a wide range
of “very serious” software projects over the last three years. This
includes deep learning libraries, API clients, Python language
extensions, terminal user interfaces, web frameworks, and more!

[nbdev](https://nbdev.fast.ai/) is a Jupyter-powered tool for writing
software. Traditional programming environments throw away the result of
your exploration in REPLs or notebooks. `nbdev` makes exploration an
integral part of your workflow, all while promoting software engineering
best practices.

## Why not pyproject.toml for packaging?

FastHTML uses a `setup.py` module instead of a `pyproject.toml` file to
configure itself for installation. The reason for this is
`pyproject.toml` is not compatible with [nbdev](https://nbdev.fast.ai/),
which is what is used to write and build FastHTML.

The nbdev project spent around a year trying to move to pyproject.toml
but there was insufficient functionality in the toml-based approach to
complete the transition. We invite those interested in moving this
project `pyproject.toml` to contribute their efforts to making
[nbdev](https://nbdev.fast.ai/) work with that format.

## Why not JSX?

Many have asked! We think there’s no benefit… Python’s positional and kw
args precisely 1:1 map already to html/xml children and attrs, so
there’s no need for a new syntax.

We wrote some more thoughts on Why Python HTML components over Jinja2,
Mako, or JSX
[here](https://www.answer.ai/posts/2024-08-03-fasthtml.html#why).

## Why use `import *`

First, through the use of the
[`__all__`](https://docs.python.org/3/tutorial/modules.html#importing-from-a-package)
attribute in our Python modules we control what actually gets imported.
So there’s no risk of namespace pollution.

Second, our style lends itself to working in rather compact Jupyter
notebooks and small Python modules. Hence we know about the source code
whose libraries we `import *` from. This terseness means we can develop
faster. We’re a small team, and any edge we can gain is important to us.

Third, for external libraries, be it core Python, SQLAlchemy, or other
things we do tend to use explicit imports. In part to avoid namespace
collisions, and also as reference to know where things are coming from.

We’ll finish by saying a lot of our users employ explicit imports. If
that’s the path you want to take, we encourage the use of
`from fasthtml import common as fh`. The acronym of `fh` makes it easy
to recognize that a symbol is from the FastHTML library.

## Can FastHTML be used for dashboards?

Yes it can. In fact, it excels at building dashboards. In addition to
being great for building static dashboards, because of its
[foundation](https://about.fastht.ml/foundation) in ASGI and [tech
stack](https://about.fastht.ml/tech), FastHTML natively supports
Websockets. That means using FastHTML we can create dashboards that
autoupdate.

## Why the distinctive coding style?

FastHTML coding style is the [fastai coding
style](https://docs.fast.ai/dev/style.html).

If you are coming from a data science background the **fastai coding
style** may already be your preferred style.

If you are coming from a PEP-8 background where the use of ruff is
encouraged, we won’t deny there is a learning curve. However, once you
get used to the **fastai coding style** you may discover yourself
appreciating the concise nature of this style. It also encourages using
more functional programming tooling, which is both productive and fun.
