---
name: Bug report
about: Github issues are primarily for bugs
title: ''
labels: ''
assignees: ''

---

## Checklist

* [ ] Does your title concisely summarize the problem?
* [ ] Did you include a minimal, reproducible example?
* [ ] What OS are you using?
* [ ] What version of Python are you using?
* [ ] What version of Dramatiq are you using?
* [ ] What Broker are you using?
* [ ] What did you do?
* [ ] What did you expect would happen?
* [ ] What happened?


## What OS are you using?

<!-- For example: Ubuntu 16.04 or macOS 10.13.3 -->


## What version of Python are you using?

<!-- Run this command to find out: python --version -->


## What version of Dramatiq are you using?

<!-- Run this command to find out: python -c 'import dramatiq; print(dramatiq.__version__)' -->


## What Broker are you using?

<!-- RabbitMQ, Redis or a broker from a third-party package (include the version of the package). 
     What version of the broker service are you running? (e.g. the version of RabbitMQ/Redis itself)
-->


## What did you do?

<!-- Be descriptive, but succinct.
     Try to include a minimal reproducable example as a single python file.
     Ideally your file can be used to start a worker,
     and enqueues messages for the worker when run as a script.
     e.g. https://github.com/Bogdanp/dramatiq/blob/master/examples/basic/example.py
     If relevant, include the parameters you use to start Dramatiq.
-->


## What did you expect would happen?

<!-- Be descriptive, but succinct. -->


## What happened?

<!-- Be descriptive, but succinct.
     If an error or exception happend,
     try to include as much of the error message and/or stack trace as possible.
-->
