# Awesome Ionic [![Awesome](https://awesome.re/badge-flat2.svg)](https://awesome.re)

<div align="center">
	<img width="100%" src="https://raw.githubusercontent.com/Cap-go/awesome-ionic/main/awesome_ionic.png" alt="Awesome ionic">
	<br>
</div>
<br/>
<div align="center">
⚡ A curated list of awesome resources related to the <a href='https://www.ionicframework.com/'>Ionic</a> Framework.
<br />
Ionic is an open-source mobile application framework that makes it easy to build cross-platform mobile apps with web technologies.
<br/>
</div>
<div align="center">
  <h2><a href="https://capgo.app/?ref=awesomelist_ionic"> ➡️ Get Instant updates for your Capacitor App with Capgo 🚀</a></h2>
  <h2><a href="https://capgo.app/consulting/?ref=awesomelist_ionic"> Fix your annoying bug now, Hire a Capacitor expert 💪</a></h2>
</div>
<br>

## Contents

- [Current Ionic version](#current-ionic-version)
- [Official Resources](#official-resources)
- [Ionic Fundamentals](#ionic-fundamentals)
- [Theming](#theming)
- [Components tutorials](#components-tutorials)
- [Authentication](#authentication)
- [Unit Testing](#unit-testing)
- [Ionic Native / Cordova Plugins](#ionic-native--cordova-plugins)
- [Payment Gateway Integrations](#payment-gateway-integrations)
- [Backend as a Service](#backend-as-a-service)
- [i18n & l10n](#i18n--l10n)
- [Tools](#tools)
- [Video Tutorials](#video-tutorials)
- [Books](#books)
- [Boilerplate/Demo Apps](#boilerplatedemo-apps)
- [Components](#components)
  - [Libraries](#libraries)
  - [Animations](#animations)
  - [UI Library](#ui-library)
  - [Menu, Tabs](#menu-tabs)
  - [Form / Input](#form--input)
  - [Input - Date/Calendar](#input---datecalendar)
  - [Lists/Table](#liststable)
  - [Images](#images)
  - [Charts/Diagram](#chartsdiagram)
  - [Video/Audio](#videoaudio)
  - [Keyboards](#keyboards)
  - [Dialog](#dialog)
  - [Frames](#frames)
- [Open Source Projects](#open-source-projects)
- [Contribute](#contribute)
- [Author](#author)

## Current Ionic version
[![npm version](https://badge.fury.io/js/@ionic%2Fangular.svg)](https://badge.fury.io/js/@ionic%2Fangular)


## Official Resources
- [Site](http://ionicframework.com/)
- [Blog](http://blog.ionic.io/)
- [Documentation](https://ionicframework.com/docs)
- [Getting Started Guide](https://ionicframework.com/docs/developing/starting)
- [Ionic Native](https://github.com/driftyco/ionic-native/)
- [Community Forum](http://forum.ionicframework.com/)
- [Ionic YouTube Channel](https://www.youtube.com/channel/UChYheBnVeCfhCmqZfCUdJQw)
- [Showcase](http://showcase.ionicframework.com/)
- [GitHub Repo](https://github.com/ionic-team/ionic-framework)
- [Awesome Capacitor](https://github.com/riderx/awesome-capacitor)

## Ionic Fundamentals
- [Beginners Guide to Getting Started with Ionic](http://www.joshmorony.com/beginners-guide-to-getting-started-with-ionic-2/)
- [Ionic First Look Series: Your First Ionic App Explained](http://www.joshmorony.com/ionic-2-first-look-series-your-first-ionic-2-app-explained/)
- [How to Convert an Ionic 1 Application to Ionic](http://www.joshmorony.com/how-to-convert-an-ionic-1-application-to-ionic-2/)
- [A Simple Guide to Navigation in Ionic](http://www.joshmorony.com/a-simple-guide-to-navigation-in-ionic-2/)
- [10 Minutes with Ionic: Adding Pages and Navigation](http://blog.ionic.io/10-minutes-with-ionic-2-adding-pages-and-navigation/)
- [How to Create a Data Model in Ionic](http://www.joshmorony.com/how-to-create-a-data-model-in-ionic-2/)
- [Ionic and External Libraries](http://mhartington.io/post/ionic2-external-libraries/)
- [Understanding Zones and Change Detection in Ionic & Angular 2](http://www.joshmorony.com/understanding-zones-and-change-detection-in-ionic-2-angular-2/)
- [Understanding Ionic: Pipe](http://mcgivery.com/understanding-ionic-2-pipe/)
- [How to Manipulate Data in Ionic: Part 1](http://www.joshmorony.com/how-to-manipulate-data-in-ionic-2-part-1/)
- [How to Manipulate Data in Ionic: Part 2](http://www.joshmorony.com/how-to-manipulate-data-in-ionic-2-part-2/)
- [Filtering, Mapping, and Reducing Arrays in Ionic](https://www.youtube.com/watch?v=A-4CLa05tp0)
- [Build a basic mobile app with Ionic 4](https://enappd.com/blog/how-to-create-an-ionic-4-app-for-beginners/13)
- [Read SMS in Ionic 4 apps](https://enappd.com/blog/automatically-read-sms-in-ionic-4-apps/42)
- [Geolocation, geocoding and reverse geocoding in Ionic 4](https://enappd.com/blog/using-geolocation-geocoding-and-reverse-geocoding-in-ionic-4/45)
- [RTL (right-to-left) layout in Ionic 4 apps](https://enappd.com/blog/rtl-right-to-left-use-in-ionic-4/50)
- [Push notifications in Ionic 4 apps](https://enappd.com/blog/implement-ionic-4-firebase-push/34)
- [Google Vision in Ionic 4 apps](https://enappd.com/blog/implement-google-vision-in-ionic-4/43)
- [Add headless ButterCMS to your Ionic App by Mike Hartington](https://buttercms.com/blog/integrating-buttercms-with-ionic)


## Theming
- [A Guide to Styling an Ionic Application](http://www.joshmorony.com/a-guide-to-styling-an-ionic-2-application/)
- [Best practice when adding FontAwesome to an ionic2 app](http://luiscabrera.site/tech/2017/01/09/fontawesome-in-ionic2.html)
- [A List of Common CSS Utility Attributes in Ionic](http://www.joshmorony.com/a-list-of-common-css-utility-attributes-in-ionic-2/)
- [5 Animation Packages You Can Immediately Use Inside Your Ionic App](https://devdactic.com/5-animation-packages-ionic/)

## Components tutorials
- [How to Create a Sliding Delete Button for Lists](http://www.joshmorony.com/ionic-2-how-to-create-a-sliding-delete-button-for-lists/)
- [Creating a Sliding Introduction Component in Ionic](http://www.joshmorony.com/creating-a-sliding-introduction-component-in-ionic-2/)
- [How to Create a Custom Loading Component in Ionic](http://www.joshmorony.com/how-to-create-a-custom-loading-component-in-ionic-2/)
- [Build a Simple Progress Bar Component in Ionic](http://www.joshmorony.com/build-a-simple-progress-bar-component-in-ionic-2/)
- [Create a News Feed with 360-Degree Photo Viewing in Ionic](http://www.joshmorony.com/create-a-news-feed-with-360-degree-photo-viewing-in-ionic-2/)
- [Build a Tap to Reveal Component in Ionic](https://www.joshmorony.com/build-a-tap-to-reveal-component-in-ionic-2/)

## Authentication
- [Twitter Login in Ionic 4 App using Firebase](https://enappd.com/blog/twitter-login-in-ionic-4-apps-using-firebase/24)
- [Facebook Login in Ionic 4 App using Firebase](https://enappd.com/blog/facebook-login-in-ionic-4-apps-using-firebase/25)
- [Google Login in Ionic 4 App using Firebase](https://enappd.com/blog/google-login-in-ionic-4-apps-using-firebase/39)
- [Anonymous Login in Ionic 4 App using Firebase](https://enappd.com/blog/firebase-anonymous-login-in-ionic-4/37)
- [Basic Email Login in Ionic 4 App using Firebase](https://enappd.com/blog/email-authentication-with-firebase-in-ionic-4/38)
- [Add Touch ID Authentication To An Ionic Mobile App](https://www.thepolyglotdeveloper.com/2016/03/add-touch-id-authentication-ionic-2-mobile-app/)
- [Using An Oauth 2.0 Service Within An Ionic Mobile App](https://www.thepolyglotdeveloper.com/2016/01/using-an-oauth-2-0-service-within-an-ionic-2-mobile-app/)
- [Ionic and Auth0](http://blog.ionic.io/ionic-2-and-auth0/)
- [Authenticate Ionic with WordPress](https://auth0.com/authenticate/ionic2/wordpress)

## Unit Testing
- [How to Unit Test an Ionic Application](http://www.joshmorony.com/how-to-unit-test-an-ionic-2-application/)
- [Test Driven Development in Ionic: An Introduction to TDD](https://www.joshmorony.com/test-driven-development-in-ionic-2-an-introduction-to-tdd/)

## Ionic Native / Cordova Plugins
- [Playing music in Ionic 4 apps](https://enappd.com/blog/spotify-like-music-in-ionic-4-apps/48)
- [How to implement health plugin - Pedometer in Ionic 4](https://enappd.com/blog/best-fitness-plugins-for-ionic-4-how-to-use-pedometer/15)
- [Using Cordova Plugins in Ionic with Ionic Native](http://www.joshmorony.com/using-cordova-plugins-in-ionic-2-with-ionic-native/)
- [10 Minutes with Ionic: Using the Camera with Ionic Native](http://blog.ionic.io/10-minutes-with-ionic-2-using-the-camera-with-ionic-native/)
- [Determine Network Availability](https://www.thepolyglotdeveloper.com/2016/01/determine-network-availability-in-an-ionic-2-mobile-app/)
- [Monetize With Google Admob In An Ionic Mobile App](https://www.thepolyglotdeveloper.com/2016/02/monetize-google-admob-ionic-2-mobile-app/)
- [Show Native Toast Notifications In An Ionic Mobile App](https://www.thepolyglotdeveloper.com/2016/01/show-native-toast-notifications-in-an-ionic-2-mobile-app/)
- [Use SQLite In Ionic Instead Of Local Storage](https://www.thepolyglotdeveloper.com/2015/12/use-sqlite-in-ionic-2-instead-of-local-storage/)
- [Launch Websites With Ionic Using The InAppBrowser](https://www.thepolyglotdeveloper.com/2016/01/launch-websites-with-ionic-2-using-the-inappbrowser/)
- [Add Barcode Scanning Functionality To Your Ionic App](https://www.thepolyglotdeveloper.com/2016/02/add-barcode-scanning-functionality-to-your-ionic-2-app/)
- [Use Google Analytics In An Ionic Android And iOS App](https://www.thepolyglotdeveloper.com/2016/03/use-google-analytics-in-an-ionic-2-android-and-ios-app/)
- [Share Things On Social Media Via An Ionic Mobile App](https://www.thepolyglotdeveloper.com/2016/02/share-things-on-social-media-via-an-ionic-2-mobile-app/)
- [How To Use PouchDB + SQLite For Local Storage In Ionic](http://gonehybrid.com/how-to-use-pouchdb-sqlite-for-local-storage-in-ionic-2/)
- [Adding Background Geolocation to an Ionic Application](http://www.joshmorony.com/adding-background-geolocation-to-an-ionic-2-application/)
- [Getting Familiar with Local Notifications in Ionic](http://www.joshmorony.com/getting-familiar-with-local-notifications-in-ionic-2/)
- [Create a Nearby Places List with Google Maps in Ionic – Part 1](http://www.joshmorony.com/create-a-nearby-places-list-with-google-maps-in-ionic-2-part-1/)
- [Create a Nearby Places List with Google Maps in Ionic – Part 2](http://www.joshmorony.com/create-a-nearby-places-list-with-google-maps-in-ionic-2-part-2/)

## Payment Gateway Integrations
- [Ionic 4 Stripe Payment Integration](https://enappd.com/blog/ionic-4-stripe-payment-integration-with-firebase-for-apps-and-pwa/17)
- [Ionic 4 PayPal Payment Integration](https://enappd.com/blog/ionic-4-paypal-payment-integration-for-apps-and-pwa/16)
- [Ionic 4 Apple Pay Payment Integration](https://enappd.com/blog/how-to-integrate-apple-pay-in-ionic-4-apps/21)
- [Ionic 4 Razorpay Payment Integration](https://enappd.com/blog/how-to-integrate-razorpay-in-ionic-4-apps-and-pwa/20)

## Backend as a Service
- [10 Minutes with Ionic: Calling an API](http://blog.ionic.io/10-minutes-with-ionic-2-calling-an-api/)
- [Using Http to Fetch Remote Data from a Server in Ionic](http://www.joshmorony.com/using-http-to-fetch-remote-data-from-a-server-in-ionic-2/)
- [Posting data from Ionic app to a PHP server](http://www.nikola-breznjak.com/blog/ionic2/posting-data-from-ionic-2-app/)
- [Make HTTP Requests In An Ionic Android And iOS App](https://www.thepolyglotdeveloper.com/2016/01/make-http-requests-in-an-ionic-2-android-and-ios-app/)

## i18n & l10n
- [Internationalize and Localize Your Ionic 4 App](https://enappd.com/blog/how-to-translate-in-ionic-4-globalization-internationalization-and-localization/11)
- [attranslate](https://github.com/fkirc/attranslate) - Semi-automated translation of JSON and other resource files.

## Tools
- [Ionic2-vscode](https://marketplace.visualstudio.com/items?itemName=jgw9617.ionic2-vscode)
- [Vim-ionic2](https://github.com/akz92/vim-ionic2)
- [Capacitor safe area simulator](https://chromewebstore.google.com/detail/capacitor-safe-area-simul/ddaaodgcccedhjbjeollookhompnlfhi) - Chrome extension to simulate safe area in the browser, it support Ionic, Knsta UI and Tailwind Capacitor.

## Video Tutorials
- [Build a Todo App from Scratch with Ionic](http://www.joshmorony.com/build-a-todo-app-from-scratch-with-ionic-2-video-tutorial/)
- [Ionic: How to Use Google Maps & Geolocation](http://www.joshmorony.com/ionic-2-how-to-use-google-maps-geolocation-video-tutorial/)
- [Build a Custom Flash Card Component in Ionic](https://www.youtube.com/watch?v=BKFQKywl_GM)
- [Hacking CSS in Ionic](https://www.youtube.com/watch?v=sXFmkdhOEVc)
- [Learn Ionic 3 From Scratch](https://www.youtube.com/watch?v=JcEGTektejA&list=PLYxzS__5yYQng-XnJhB21Jc7NW1OIaqct)

## Books
- [Building Mobile Apps with Ionic](https://www.joshmorony.com/building-mobile-apps-with-ionic-2/)
- [Ionic Blueprints](https://www.packtpub.com/web-development/ionic-2-blueprints)
- [Hybrid Mobile Development with Ionic](https://www.packtpub.com/application-development/hybrid-mobile-development-ionic)

## Boilerplate/Demo Apps 
- [Ionic 4 Full Starter App and PWA](https://ionicthemes.com/product/ionic4-full-starter-app)
- [Ionic 3 Starter App Template](https://ionicthemes.com/product/ion2fullapp-full-ionic2-app-template-elite-version)
- [Ion2FullApp - Ionic 3 Template](https://ionicthemes.com/templates/ion2fullapp-full-ionic2-app-template)
- [Ionic Boilerplate](https://github.com/marcoturi/ionic-boilerplate)
- [Cordova File Transfer](https://github.com/dsgriffin/ionic-2-file-transfer-example)
- [Update your App](https://github.com/NextFaze/ionic-manup)
- [NFC Demo](https://github.com/RedFroggy/ionic2-nfc-app)
- [Fullscreen Content](https://github.com/sebaferreras/Ionic2-FullscreenContent)
- [Card Layout](https://github.com/joshuamorony/ionic2-card-layout)
- [Ionic 2](https://github.com/marcoturi/ionic2-boilerplate)
- [Ionic 2 Advanced Components](https://github.com/yannbf/ionic2-components)
- [OCR Scan App](https://github.com/matiastucci/ionic-ocr-example)
- [Ionic 4 Payment Gateway Starter - Stripe](https://store.enappd.com/product/ionic-4-stripe-payment-starter/)
- [Ionic 4 Payment Gateway Starter - Paypal](https://store.enappd.com/product/ionic-4-paypal-payment-starter/)
- [Ionic 4 Payment Gateway Starter - Razorpay](https://store.enappd.com/product/ionic-4-razorpay-payment-starter/)
- [Ionic 4 Payment Gateway Starter - Apple Pay](https://store.enappd.com/product/ionic-4-apple-pay-starter/)
- [Ionic 5 Complete App and PWA Starter](https://store.enappd.com/product/ionic-4-full-app/)
- [Ionic 5 Complete Taxi Booking Platform Starter](https://store.enappd.com/product/taxi-booking-complete-platform/)
- [Ionic 5 Grocery Shopping Starter with Admin Panel](https://store.enappd.com/product/ionic-4-grocery-complete-platform-app-and-admin-dashboard/)
- [Ionic 5 Tinder Starter](https://store.enappd.com/product/dating-app-starter-ionic4-tinder-clone/)
- [Ionic 5 Spotify Starter](https://store.enappd.com/product/ionic-4-spotify-app-starter/)
- [Ionic 5 Food Delivery App Starter](https://store.enappd.com/product/ionic-4-food-ordering-app-starter/)
- [Ionic 5 Carpooling App Starter](https://store.enappd.com/product/carpool-app-starter/)
- [Ionic 5 Google Vision Starter](https://store.enappd.com/product/ionic-4-google-vision-starter/)
- [Ionic 5 Firebase Full App Starter](https://store.enappd.com/product/ionic-4-firebase-full-app-starter/)
- [Ionic 6 vue Firebase Full App Starter](https://store.enappd.com/product/ionic-vue-firebase-full-app/)
- [Ionic 6 React Full App Starter](https://store.enappd.com/product/ionic-react-full-app-capacitor/)
- [Ionic 6 Capacitor Full App Starter](https://store.enappd.com/product/capacitor-full-app-with-ionic-angular/)

## Components

### Libraries
- [Capacitor Tailwind](https://github.com/Cap-go/tailwind-capacitor) - A Tailwind CSS plugin for Capacitor.
- [Ionic Blocks](https://ionicblocks.com/) - A collection of free and premium Ionic components.

### Animations
- [Lottie Animation](https://github.com/chenqingspring/ng-lottie) 
- [Lottie Animation](https://github.com/fivethree-team/lottie) 

### UI Library
- [Ionic 4 UI Component Library](https://github.com/fivethree-team/ionic-4-components) 

### Menu, Tabs
- [Scrollabel Tabs](https://github.com/SinoThomas/Ionic2-ScrollableTabs) 
- [Circular Tabs](https://github.com/SinoThomas/Ionic2-CircularTabs) 
- [Fab Toolbar](https://github.com/ekhmoi/fab-toolbar) 
- [Multi Level Sidemenu](https://github.com/sebaferreras/Ionic2-MultiLevelSideMenu) 
- [Popover Sidemenu](https://github.com/philipbrack/ionic2-menu-alternative-popover) 
- [Drop down Title](https://github.com/Mohd-PH/ionic-drop-down-title) 

### Form / Input
- [Autocomplete](https://github.com/kadoshms/ionic2-autocomplete) 
- [Form Generator based on JSON](https://github.com/makinacorpus/angular2-schema-form) 
- [Dynamic Forms](https://github.com/udos86/ng2-dynamic-forms/) 
- [Form Builder](https://github.com/rohitg7/ionic2-form-builder) 
- [Sidemenu tabs](https://github.com/seanmavley/ionic2-sidemenu-tabs)
- [Selectable](https://github.com/eakoriakin/ionic-selectable)
- [Masks](https://github.com/amarkes/br-mask)

### Input - Date/Calendar
- [Calendar](https://github.com/twinssbc/Ionic2-Calendar) 
- [Calendar](https://github.com/alexandretok/easy-ionic2-calendar) 
- [Calendar](https://github.com/redpandatronicsuk/ionic2calendar) 
- [Calendar](https://github.com/mattlewis92/angular-calendar)  (very powerful)
- [Calendar - Fullcalendar](https://github.com/nekken/ng2-fullcalendar) 
- [Datepicker](https://github.com/misha130/datepicker-ionic2) 
- [Datepicker (selectable range dates calendar)](https://github.com/HsuanXyz/ion2-calendar) 
- [Datepicker](https://github.com/rajeshwarpatlolla/ionic2-datepicker) 
- [Rating](https://github.com/andrucz/ionic2-rating) 
- [Inputfield Mask](https://github.com/text-mask/text-mask)

### Lists/Table
- [Sortable/Filter Tables](https://github.com/valor-software/ng2-table) 
- [Smart table (sorting, filtering)](https://github.com/akveo/ng2-smart-table) 
- [Flexible and Light Table](https://github.com/swimlane/ngx-datatable) 

### Images
- [Signatur](https://github.com/wulfsolter/angular2-signaturepad) - Works perfect with Ionic. 
- [Image Fallback](https://github.com/VadimDez/ng2-img-fallback) 
- [Lazy Load](https://github.com/tjoskar/ng2-lazyload-image)  
- [Image Loader](https://github.com/zyramedia/ionic-image-loader) 
- [Facebook Gallery](https://github.com/skyfloyd/ionic2-fb-gallery) 
- [Image Viewer](https://github.com/Riron/ionic-img-viewer) 
- [Gallery Modal](https://github.com/nikini/ionic-gallery-modal) 
- [Image Zoom](https://github.com/brtnshrdr/angular2-image-zoom) 

### Charts/Diagram
- [Charts](https://github.com/valor-software/ng2-charts) 
- [D3 Service](https://github.com/tomwanzek/d3-ng2-service) 
- [D3 Barchart](https://github.com/keathmilligan/angular2-d3-v4) 
- [D3 Line/Bar/Pie Charts](https://github.com/datencia/d3js-angular2-example) 

### Video/Audio
- [Video Editor](https://github.com/rossmartin/video-editor-ionic2) 
- [Simple Audioplayer](https://github.com/arielfaur/ionic-audio) 

### Keyboards
- [Digit Keyboard](https://github.com/skol-pro/ion-digit-keyboard-v2) 

### Dialog
- [Dialogbox with Counter](https://github.com/HsuanXyz/ionic2-extend-alert) 

### Frames
- [ng Lightning (for Salesforce Apps)](https://github.com/ng-lightning/ng-lightning) 

## Open Source Projects
- [Ionic Conference App](https://github.com/driftyco/ionic-conference-app)
- [IonicRealty](https://github.com/ccoenraets/ionic2-realty)
- [Ionic Firebase Chat App](https://github.com/ionic2blueprints/firebase-chat)
- [Ionic Ecommerce App](https://github.com/ionic2blueprints/ionic2-marketcloud)
- [Ionic Conference App based on Lanyrd API](https://github.com/ionic2blueprints/conference-app)
- [Ionic Stock Tracking App](https://github.com/ionic2blueprints/ionic2-stockmarket)
- [Ionic Wordpress Client](https://github.com/ionic2blueprints/ionic2-wp-client)
- [Ionic Media Player](https://github.com/ionic2blueprints/media-player)
- [Ionic Social App](https://github.com/ionic2blueprints/social-app)
- [Ionic 5 WhatsApp clone](https://github.com/thenaim/ionic-whatsapp-clone)
- [Ionic 5 Social Network Starter](https://github.com/thenaim/ion-tk-social-network)
- [Ionic Push Notification](https://github.com/aggarwalankush/ionic2-push-base)
- [Ionic Weather app](https://github.com/aggarwalankush/ionic2-mosum)
- [Ionic Reddit Reader](https://github.com/smartapant/ionic2-reddit-reader)
- [Ionic aiEyes - Azure Computer Vision API](https://github.com/brenopolanski/aiEyes)
- [Ionic Soundboard](https://github.com/rkalis/ionic-soundboard)
- [Firebase push notifications in Ionic 4](https://github.com/enappd/ionic-4-push)
- [Receive SMS automatically in Ionic 4](https://github.com/enappd/Ionic-4-sms-receive)
- [Playing music in Ionic 4](https://github.com/enappd/ionic-4-music)
- [Ionic 4 Stripe Payment Integration](https://github.com/enappd/ionic4-stripe)
- [Ionic 4 PayPal Payment Integration](https://github.com/enappd/ionic4-paypal)
- [Ionic 4 Apple Pay Payment Integration](https://github.com/enappd/ionic4-applepay)
- [Ionic 4 Razorpay Payment Integration](https://github.com/enappd/ionic4-razorpay)
- [Ionic 4 Twitter login with Firebase](https://github.com/enappd/Ionic-4-Twitter-auth)
- [Ionic 4 Facebook login with Firebase](https://github.com/enappd/ionic4-facebookAuth)
- [Translation in Ionic 4 - Internationalization and localization](https://github.com/enappd/ionic4-i18n)
- [Ionic 4 Free chat themes](https://store.enappd.com/product/free-chat-themes-ionic4/)

## Contribute
Contributions welcome! Read the [contribution guidelines](CONTRIBUTING.md) first.

## Author

<a href="https://capgo.app/">Capgo — Live updates for capacitor</a>
