# Contributing to CONTRIBUTING.md

First off, thanks for taking the time to contribute! ❤️

All types of contributions are encouraged and valued. See the [Table of Contents](#table-of-contents) for different ways to help and details about how this project handles them. Please make sure to read the relevant section before making your contribution. It will make it a lot easier for us maintainers and smooth out the experience for all involved. The community looks forward to your contributions. 🎉

> And if you like the project, but just don't have time to contribute, that's fine. There are other easy ways to support the project and show your appreciation, which we would also be very happy about:
> - Star the project
> - Tweet about it
> - Refer this project in your project's readme
> - Mention the project at local meetups and tell your friends/colleagues


## Table of Contents

- [I Have a Question](#i-have-a-question)
- [I Want To Contribute](#i-want-to-contribute)
- [Reporting Bugs](#reporting-bugs)
- [Suggesting Enhancements](#suggesting-enhancements)
- [Your First Code Contribution](#your-first-code-contribution)
- [Improving The Documentation](#improving-the-documentation)
- [Styleguides](#styleguides)
- [Commit Messages](#commit-messages)
- [Join The Project Team](#join-the-project-team)



## I Have a Question

> If you want to ask a question, we assume that you have read the [available](https://github.com/CleanCut/green/) [documentation](https://github.com/CleanCut/green/blob/main/cli-options.txt).

Before you ask a question, it is best to search for existing [Issues](https://github.com/CleanCut/green/issues) and [Discussions](https://github.com/CleanCut/green/discussions) that might help you. In case you have found a suitable issue and still need clarification, you can write your question in this issue. It is also advisable to search the Internet for answers first.

If you then still feel the need to ask a question and need clarification, we recommend the following:

- Open an [Issue](https://github.com/CleanCut/green/issues/new) or [Discussion](https://github.com/CleanCut/green/discussions) as appropriate.
- Provide as much context as you can about what you're running into.
- Provide project and platform versions (nodejs, npm, etc), depending on what seems relevant.

We will respond to you as we are able to. However, please be aware that this project is maintained by volunteers in their spare time. Consider opening a pull request with bug fixes or changes that you wish to see.



## I Want To Contribute

> ### Legal Notice 
> When contributing to this project, you must have authored the content, have the necessary rights to the content and agree the content you contribute may be provided under the project license.

### Reporting Bugs


#### Before Submitting a Bug Report

A good bug report shouldn't leave others needing to chase you up for more information. Investigate carefully, collect information and describe the issue in detail in your report. Please complete the following steps in advance to help us fix any potential bug as fast as possible.

- Make sure that you are using the latest version of green.
- Determine if your bug is really a bug and not an error on your side e.g. using incompatible environment components/versions. If you are looking for support, you might want to check [this section](#i-have-a-question)).
- To see if other users have experienced (and potentially already solved) the same issue you are having, check if there is not already an [open issue]((https://github.com/CleanCut/green/issues)) for what you are experiencing.
- Also make sure to search the Internet (including Stack Overflow) to see if users outside of the GitHub community have discussed the issue.
- Collect information about the bug:
  - Stack trace (Traceback)
  - OS, Platform and Version (Windows, Linux, macOS, x86, ARM)
  - Version of the Python, pip, and other things depending on what seems relevant.
  - Possibly your input and the output.
  - Can you reliably reproduce the issue? And can you also reproduce it with older versions?


#### How Do I Submit a Good Bug Report?

We use GitHub issues to track bugs and errors. If you run into an issue with the project:

- Open an [Issue](https://github.com/CleanCut/green/issues/new).
- Explain the behavior you would expect and the actual behavior.
- Please provide as much context as possible and describe the *reproduction steps* that someone else can follow to recreate the issue on their own. This usually includes your code. For good bug reports you should isolate the problem and create a reduced test case.
- Provide the information you collected in the previous section.

Once it's filed:

- The project team will label the issue accordingly.
- A team member will try to reproduce the issue with your provided steps. If there are no reproduction steps or no obvious way to reproduce the issue, the team will ask you for those steps and mark the issue as `needs-repro`. Bugs with the `needs-repro` tag will not be addressed until they are reproduced.



### Suggesting Enhancements

Follow these guidelines for suggesting enhancements.


#### Before Submitting an Enhancement

- Make sure that you are using the latest version of green.
- Read the [documentation](#i-have-a-question) carefully and find out if the functionality is already covered, maybe by an individual configuration.
- Perform a search of [issues](https://github.com/CleanCut/green/issues) and [discussions](https://github.com/CleanCut/green/discussions) to see if the enhancement has already been suggested. If it has, add a comment to the existing issue instead of opening a new one.
- Find out whether your idea fits with the scope and aims of the project. It's up to you to make a strong case to convince the project's developers of the merits of this feature. Keep in mind that we want features that will be useful to the majority of our users and not just a small subset. If you're just targeting a minority of users, consider maintaining your own fork.


#### How Do I Submit a Good Enhancement Suggestion?

Enhancement suggestions are tracked as [GitHub Discussions](/discussions).

- Use a **clear and descriptive title** for the issue to identify the suggestion.
- Provide a **step-by-step description of the suggested enhancement** in as many details as possible.
- **Describe the current behavior** and **explain which behavior you expected to see instead** and why. At this point you can also tell which alternatives do not work for you.
- You may want to **include screenshots or screen capture videos** which help you demonstrate the steps or point out the part which the suggestion is related to. 
- **Explain why this enhancement would be useful** to most users. You may also want to point out the other projects that solved it better and which could serve as inspiration.


## Join The Project Team

Would you like to become a member of the team? It's pretty straightforward. Make a few contributions first to make it clear that you are comfortable interacting with the project, then open an issue asking to become a member of the team. In the issue, make it clear why you would like to be a member of the team, and what you would like to do with the increased privileges of a team member. What permissions are granted will be handled on a case-by-case basis. Right now, @CleanCut is the [BDFL](https://en.wikipedia.org/wiki/Benevolent_dictator_for_life), but quite frankly he'd be happy to share the load more broadly, or even hand off the project entirely if he finds a worthy successor.
