<!--lint disable remark-lint:awesome-list-item-->

#

<!-- [![Awesome](https://awesome.re/badge-flat2.svg)](https://awesome.re) -->
<div align="center">
  <img src="./.refs/imgs/awesome-github-copilot.svg" alt="Awesome Copilot Instructions" height="300">
</div>

<h4 align="center">✨ A curated list of awesome GitHub instructions, prompt, skills and custom agent markdown files for enhancing your GitHub Copilot AI experience.</h4>

<!--lint enable remark-lint:awesome-badge-->

<p align="center">
  <a href="https://awesome.re">
    <img src="https://awesome.re/badge-flat2.svg" alt="Awesome">
  </a>
</p>

<hr>

<p align="center">
 <a href="CONTRIBUTING.md">📖 Contribution Guide</a>
</p>
<br>

## Contents

- [Why Copilot Instructions](#why-copilot-instructions)
- [Instructions](#instructions)
  - [Boilerplates & Templates](#boilerplates--templates)
  - [Language & Stack](#language--stack)
  - [Framework / Library](#framework--library)
  - [Tools](#tools)
  - [Workflows](#workflows)
- [Prompts](#prompts)
  - [AI Development Tasks](#ai-development-tasks)
- [Custom Agents](#custom-agents)
  - [AI Development Mode](#ai-development-mode)
- [Agent Skills](#agent-skills)
- [How to Use](#how-to-use)

## Why Copilot Instructions

`copilot-instructions.md` and `*.instructions.md` files help guide GitHub Copilot by providing contextual details about your repository such as the type of workflow your team follows, tools and other project specific details such as coding style, frameworks used or project specific rules.

**Tip**: Learn more about Copilot Instructions in the [VS Code documentation](https://code.visualstudio.com/docs/copilot/copilot-customization).

## Instructions

Instructions provides Copilot with repository-specific context, such as coding standards, frameworks, or workflows, to improve code suggestions.

### Boilerplates & Templates

#### Templates

- [General Language](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/instructions/boilerplate-and-templates/standard-language.instructions.md) - Standard language template to build instruction files.

#### Boilerplate

- [Standard IaC Tools Boilerplate](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/instructions/boilerplate-and-templates/standard-iac-tools.instructions.md) - Standard tool boilerplate for infrastructure-as-code tools.

### Language & Stack

#### C

- [Standard Focus](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/instructions/languages/c/c.instructions.md) - System libraries, CLI tools, and embedded applications with POSIX/GNU libc.

#### C-Sharp

- [Standard Focus](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/instructions/languages/csharp/csharp.instructions.md) - .NET applications with modern C# patterns and best practices.

#### C++

- [Standard Focus](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/instructions/languages/cplusplus/cplusplus.instructions.md) - Modern C++ development with STL, RAII, and performance optimization.

#### Go

- [Standard Focus](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/instructions/languages/go/go.instructions.md) - Go for microservices, CLI tools, and concurrent applications.

#### Java

- [Standard Focus](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/instructions/languages/java/java.instructions.md) - Enterprise Java development with Spring framework and modern patterns.

#### JavaScript

- [Standard Focus](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/instructions/languages/javascript/javascript.instructions.md) - Modern JavaScript with ES6+, Node.js, and browser development.

#### Kotlin

- [Standard Focus](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/instructions/languages/kotlin/kotlin.instructions.md) - Kotlin for Android development and multi-platform projects.

#### Lua

- [Standard Focus](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/instructions/languages/lua/lua.instructions.md) - Lua scripting for embedded systems, game development, and automation.

#### Python

- [Standard Focus](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/instructions/languages/python/python.instructions.md) - Python development for web applications, data science, and automation.

#### Rust

- [Standard Focus](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/instructions/languages/rust/rust.instructions.md) - Systems programming with Rust's ownership model and memory safety.

#### Swift

- [Standard Focus](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/instructions/languages/swift/swift.instructions.md) - iOS and macOS development with Swift and SwiftUI.

#### TypeScript

- [Standard Focus](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/instructions/languages/typescript/typescript.instructions.md) - TypeScript development for web and Node.js applications.

### Framework / Library

#### Cobra CLI (Go)

- [Charmbracelet Bubbles CLI](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/instructions/frameworks/cobra-cli-go/charmbracelet-cli.instructions.md) - Interactive terminal applications with Charm's Bubble Tea framework and Golang Cobra CLI.

#### Node.js (TypeScript)

- [Azure Function App](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/instructions/frameworks/nodejs-typescript/azure-function-app.instructions.md) - Azure Function Apps using TypeScript Node.js.
- [Express API](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/instructions/frameworks/nodejs-typescript/express-api.instructions.md) - REST API development with Express.js and TypeScript Node.js.

### Tools

#### Content Management Systems (CMS)

##### Drupal

- [Standard Focus for Drupal 11](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/instructions/tools/cms/drupal/drupal-11.instructions.md) - Drupal 11 module and theme development.

#### Infra as Code (IaC)

##### Terraform

- [Standard Focus](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/instructions/tools/infra-as-code/terraform/terraform.instructions.md) - Standard Terraform instructions.
- [Atmos](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/instructions/tools/infra-as-code/terraform/atmos-terraform.instructions.md) - Terraform workflow orchestration with Atmos framework.

### Workflows

#### AI Development Instructions

A comprehensive workflow for AI-assisted development featuring structured approaches to planning, task generation, and execution.

- [PRD Creation](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/instructions/workflows/ai-development-instructions/prd-creation.instructions.md) - Create detailed Product Requirements Documents.
- [Task Generation](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/instructions/workflows/ai-development-instructions/task-generation.instructions.md) - Break PRDs into actionable development tasks.
- [Task Execution](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/instructions/workflows/ai-development-instructions/task-execution.instructions.md) - Systematic task execution with proper testing and Git practices.

## Prompts

Prompts are reusable tasks or workflow instructions that help guide Copilot to perform specific actions or generate certain outputs.

### AI Development Tasks

A comprehensive workflow for AI-assisted development featuring structured approaches to planning, task generation, and execution.

- [PRD Creation Prompt](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/prompts/ai-development-tasks/prd-creation.prompt.md) - Create detailed Product Requirements Documents using prompt tasks.
- [Task Generation Prompt](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/prompts/ai-development-tasks/task-generation.prompt.md) - Break PRDs into actionable development tasks using prompt tasks.
- [Task Execution Prompt](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/prompts/ai-development-tasks/task-execution.prompt.md) - Systematic task execution with proper testing and Git practices using prompt tasks.

## Custom Agents

[Custom agents](https://code.visualstudio.com/docs/copilot/customization/custom-agents) let you set up different AI personas in VS Code for specific dev roles (like security reviewer, planner, or architect), each with its own instructions, tools, and behavior. You can also use handoffs to move between these specialized agents in a guided workflow (e.g., planning → implementation → review) with relevant context carried over.

The built-in available custom agents are:

- Agent
- Ask
- Edit
- Plan
- AIAgentExpert
- Configure Custom Agents (create your own)

### AI Development Mode

- [Architect](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/agents/ai-development-mode/architect.agent.md) - Design and plan software systems.
- [Clean Code](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/agents/ai-development-mode/clean-code.agent.md) - Write clean, readable, and maintainable code using clean code best practices.
- [Debugger](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/agents/ai-development-mode/debugger.agent.md) - Debug your application code to find a fix.
- [PRD Creation](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/agents/ai-development-mode/prd-creation.agent.md) - Build Product Requirements Document (PRD).

## Agent Skills

Agent Skills are portable, [open standard](https://agentskills.io/home), version-controlled folders of instructions, scripts, and resources that agents can discover and load on demand to do tasks more accurately and efficiently. They let agents gain domain expertise, new capabilities, and repeatable workflows—while making those same skills reusable across different compatible agent products and teams.

### General

- [Calculator](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/skills/calculator/SKILL.md) - Performs arbitrary-precision arithmetic calculations including addition, subtraction, multiplication, division, and exponents.
- [Jira CLI](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/skills/jira-cli/SKILL.md) - Interact with Jira from the command line to create, list, view, edit, and transition issues, manage sprints and epics, and perform common Jira workflows.

### Documents

- [docx](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/skills/documents/docx/README.md) - Document creation, editing, and analysis with support for tracked changes, comments, formatting preservation, and text extraction.
- [pdf](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/skills/documents/pdf/README.md) - PDF manipulation toolkit for extracting text and tables, creating new PDFs, merging/splitting documents, and handling forms.
- [pptx](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/skills/documents/pptx/README.md) - Presentation creation, editing, and analysis.
- [xlsx](https://github.com/Code-and-Sorts/awesome-copilot-agents/tree/main/skills/documents/xlsx/README.md) - Spreadsheet creation, editing, and analysis with support for formulas, formatting, data analysis, and visualization.

## How to Use

### Setup Copilot in VSCode

1. Hover over the Copilot icon in the Status Bar and select Set up Copilot.
2. Select **Sign in** to sign in to your GitHub account or **Use Copilot** if you're already signed in.

**Tip**: Read more about setting up [VS Code Copilot](https://code.visualstudio.com/docs/copilot/setup).

### Setup Instructions

1. Create instruction files using the latest naming conventions:
    1. Workspace instructions (place `*.instructions.md` files in `.github/instructions/` directory).
    2. Workspace prompts (place `*.prompt.md` files in `.github/prompts/` directory).
    3. Workspace custom agents (place `*.agent.md` files in `.github/agents` directory).
    4. Workspace custom skills (skills are stored in directories with a `SKILL.md` file that defines the skill's behavior).
    5. Workspace single instruction (place `copilot-instructions.md` in `.github` directory).

#### File Types

##### Instruction Files

`.instructions.md` - Contextual instructions that apply to specific files or file types.

##### Prompt Files

`.prompt.md` - Reusable prompts for specific tasks or workflows.

##### Custom Agent Files

`.agent.md` - Predefined AI personas behavior in VS Code for specific dev roles.

##### Custom Agent Skills

`SKILLS.md` - Portable, version-controlled folders of instructions, scripts, and resources that agents can discover and load on demand.

##### Formatting

Use YAML front matter to specify metadata like `applyTo`, `mode`, and `description`.

## Contributing

All contributions are welcome! If you would like to share instruction files (`.instructions.md`), prompt files (`.prompt.md`), skills (`SKILL.md` in a skill folder) or custom agents (`.agent.md`), see the [contribution guide](CONTRIBUTING.md) for details.
