# Awesome EOSIO [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

[<img src="eos-logo.png" alt="EOSIO" align="right" width="100">](https://eos.io/)

> A curated list of awesome **EOSIO** resources for users and developers.

<p>
  EOSIO is the most powerful infrastructure for decentralized applications and open source smart contract platform.
  EOSIO software enables businesses to rapidly build and deploy high-performance and high-security blockchain-based applications.
</p>

<p>Contributions welcome. Add links through pull requests or create an issue to start a discussion. Please read the <a href="https://github.com/DanailMinchev/awesome-eosio/blob/main/contributing.md">contribution guidelines</a> first.</p>

## Contents

- [Official](#official)
- [Learn](#learn)
  - [Websites](#websites)
  - [Books](#books)
  - [Interactive learning, labs](#interactive-learning-labs)
  - [Courses, workshops, webinars, videos and others](#courses-workshops-webinars-videos-and-others)
- [Tools](#tools)
  - [Wallets and Toolkits](#wallets-and-toolkits)
  - [Account services](#account-services)
  - [Block explorers, Voting portals](#block-explorers-voting-portals)
  - [General](#general)
- [Block Producers](#block-producers)
- [Developers](#developers)
  - [Environment](#environment)
  - [Testnets](#testnets)
  - [Libraries and Frameworks](#libraries-and-frameworks)
  - [Developer Tools](#developer-tools)
  - [Code examples](#code-examples)
  - [Block Producer tools](#block-producer-tools)
  - [Other in Developers](#other-in-developers)
- [Community](#community)
  - [Blogs](#blogs)
  - [YouTube Channels](#youtube-channels)
  - [Forums](#forums)
- [EOSIO Ecosystem](#eosio-ecosystem)
- [DApps](#dapps)
  - [DApp directories](#dapp-directories)
  - [Leasing platforms](#leasing-platforms)
  - [Games](#games)
  - [Other in DApps](#other-in-dapps)

## Official

Official resources.

- [EOS Network Foundation](https://eosnetwork.com/)
- [GitHub](https://github.com/AntelopeIO/spring)
- [Blue Paper](https://eosnetwork.com/blog/category/eos-blue-papers/n)
- [StackExchange for Q&A](https://eosio.stackexchange.com/)
- [YouTube](https://www.youtube.com/@EOSNetworkFoundation)

## Learn

EOSIO learning resources.

### Websites

- [EOSIO Developer Portal](https://developers.eos.io/) - A great place to begin your EOSIO blockchain journey.
- [EOS Smart Contract Development Security Best Practices](https://github.com/slowmist/eos-smart-contract-security-best-practices/blob/master/README_EN.md)
- [EOS Learning Resources - EOS Costa Rica](https://guide.eoscostarica.io/)
- [ESC - EOS Study Center](https://eosvenezuela.io/esc.html)

### Books

- [Learn EOS Development](https://learneos.dev/) - The up-to-date, in-depth, complete guide to dapps on the EOS blockchain.

### Interactive learning, labs

- [Elemental Battles](https://battles.eos.io/) - Build a blockchain game. Learn EOSIO.
  - [Announcing Elemental Battles: Block.one's New Tutorial for On-boarding Aspiring Blockchain Developers](https://medium.com/eosio/announcing-elemental-battles-block-ones-3215a8e2cdee)
- [Block.one: Getting Started with the EOSIO Blockchain and Smart Contracts](https://google.qwiklabs.com/catalog_lab/3743) - Google Cloud training lab.

### Courses, workshops, webinars, videos and others

- [EOSIO Training & Certification](https://training.eos.io/) - Official EOSIO Training & Certification.
- [EOSIO Webinars](https://eos.io/event-category/webinar/) - Official EOSIO Webinars.
- [EOSIO Resource Library](https://eos.io/resources/) - Official EOSIO Resources. Videos, case studies, and other resources to help you learn and grow with EOSIO.
- [Learning Blockchain Development with EOS and C++](https://www.udemy.com/learning-blockchain-development-with-eos-and-cpp/) - Udemy Course.
- [Starting with EOS Blockchain for Developers](https://www.udemy.com/starting-with-eos/) - Udemy Course.
- [Learn EOS Blockchain Smart Contracts & DApps with C++, EOSJS](https://www.udemy.com/course/learn-eos-blockchain-smart-contracts-dapps-with-c-eosjs/) - Udemy course.
- [Building DApps on EOS: A Hands-On Workshop](https://objectcomputing.com/services/training/catalog/blockchain/building-dapps-with-eos-workshop) - Workshop.
- [EOSIO Blockchain Developer Workshop](https://medium.com/@theblockstalk/the-eosio-blockchain-developer-workshop-now-available-on-youtube-ddeba54f0d94) - Free course on YouTube.
- [EOS Programming 101](https://academy.moralis.io/courses/eos-programming-101) - Ivan on Tech video course.
- [Introduction to EOSIO for Developers](https://academy.b9lab.com/courses/course-v1:B9lab+EOSIO-FREE+2018-09/about) - Free B1 Labs video course.

## Tools

Various software and tools.

### Wallets and Toolkits

#### Desktop

- [cleos](https://developers.eos.io/eosio-cleos/docs)
  - [EOSIO/eos](https://github.com/EOSIO/eos/tree/master/programs/cleos) - Official GitHub (part of EOSIO).
- [Anchor Wallet](https://greymass.com/en/anchor/)
  - [greymass/anchor](https://github.com/greymass/anchor) - Official GitHub.
- [Scatter](https://get-scatter.com/)
  - [GetScatter/ScatterDesktop](https://github.com/GetScatter/ScatterDesktop) - Official GitHub.
- [EOS Toolkit](https://eostoolkit.io/)
  - [eostoolkit/eostoolkit](https://github.com/eostoolkit/eostoolkit) - Official GitHub.
- [SimplEOS](https://eosrio.io/simpleos/)
  - [eosrio/simpleos](https://github.com/eosrio/simpleos) - Official GitHub.
- [EOS Authority Web Wallet](https://eosauthority.com/dashboard)
- [eoscanada/eosc](https://github.com/eoscanada/eosc)
- [Wax Cloud Wallet](https://all-access.wax.io/)

#### Mobile

- [OracleChain/PocketEOS-Android](https://github.com/OracleChain/PocketEOS-Android)
- [OracleChain/PocketEOS-IOS](https://github.com/OracleChain/PocketEOS-IOS)
- [Android client for EOS.IO](https://github.com/playerone-id/EosCommander)

### Account services

- [Get alerts for transactions on an account - EOS Authority](https://eosauthority.com/alerts)
- [EOS PowerUp](https://eospowerup.io/)

### Block explorers, Voting portals

- [EOS Network Monitor](http://eosnetworkmonitor.io/) - EOSIO Network Monitor by "CryptoLions". Useful for developers. Scatter friendly.
- [eosflare](https://eosflare.io/) - Popular block explorer includes resource statistics, latest profile actions and statistics about "Top Name Bids" and "Top Voters".
- [EOS Tracker](https://eostracker.io/) - Open Source block explorer includes producers information and account information.
  - [EOSEssentials/EOSTracker](https://github.com/EOSEssentials/EOSTracker) - Official GitHub.
- [Bloks](https://bloks.io/) - Fast block explorer, can be used for voting. Includes information about block producers and tokens.
<!--lint disable awesome-spell-check-->
- [EOSX](https://www.eosx.io/) - Block explorer. Various side chains are supported.
<!--lint enable awesome-spell-check-->
- [EOS Vote Proxy Research Portal](https://www.alohaeos.com/vote/proxy) - Vote Proxy explorer.
- [EOS GO](https://www.eosgo.io/)
- [bdata.one](https://bdata.one/) - Blockchain data about accounts and tokens for several EOSIO chains.

### General

- [All Things EOS](http://allthingseos.com)
- [Tools from EOS Authority](https://eosauthority.com/tools)
- [EOSIO Tools and Info](https://www.alohaeos.com/tools)

## Block Producers

Block Producers related software and resources.

- [GLASS](https://glass.cypherglass.com/) - EOSIO Block Producer Map.
  - [cypherglassdotcom/glass](https://github.com/cypherglassdotcom/glass) - Official GitHub.
- [EOS Block Producer Research Portal](https://www.alohaeos.com/vote)

## Developers

All about development on EOSIO platform.

### Environment

- [EOS Studio](https://www.eosstudio.io/) - Graphic IDE for EOSIO Development.
- [EOSIO Web IDE](https://github.com/EOSIO/eosio-web-ide) - The Web IDE provides developers with a personal single-node EOSIO blockchain for development and testing purposes, running in the [Gitpod.io](https://www.gitpod.io/) cloud – and accessible from your web browser.
- [Helm charts for EOSIO](https://github.com/EOSIO/eosio.helm) - EOSIO Nodeos Helm Charts.

### Testnets

- [The EOSIO Testnet](https://testnet.eos.io/) - Block.one's official EOSIO Testnet. Test on fully-featured EOSIO stable releases.
- [Jungle Testnet](https://jungletestnet.io/) - The Jungle TestNet was initiated by and has served as sandbox for many development teams and EOS Block Producers since the birth of EOSIO.
- [CryptoKylin Testnet](https://www.cryptokylin.io/) - CryptoKylin Testnet is a developer-friendly testnet maintained by a group of EOS Mainnet Block Producers.
- [Wax Testnet](https://wax-testnet.eosio.online/) - Wax's official Testnet. 
  - [Account Creation and Faucet](https://waxsweden.org/testnet/) - Wax Sweden's testnet page.

### Libraries and Frameworks

#### Core

- [EOSIO/eos](https://github.com/EOSIO/eos) - Official EOSIO GitHub repository.
- [EOSIO/eos-vm](https://github.com/EOSIO/eos-vm) - A Low-Latency, High Performance and Extensible WebAssembly Backend Library.

#### API libraries

- [EOSIO/eosjs](https://github.com/EOSIO/eosjs) - Official JavaScript SDK.
- [EOSIO/eosio-java](https://github.com/EOSIO/eosio-java) - Official Java SDK.
  - [eosiojava API](https://eosio.github.io/eosio-java/) - API documentation.
  - [EOSIO™ Software Release: Native SDKs for Swift and Java](https://eos.io/news/eosio-software-release-native-sdks-for-swift-and-java/) - Article.
- [EOSIO/eosio-swift](https://github.com/EOSIO/eosio-swift) - Official Swift SDK.
  - [EOSIO SDK for Swift](https://eosio.github.io/eosio-swift/) - API documentation.
- [EOS.IO Go API library](https://github.com/eoscanada/eos-go) - Go library.
- [EOS Java API Wrapper](https://github.com/EOSEssentials/eos-java-rpc-wrapper) - Java library.
- [memtrip/eosreach-android](https://github.com/memtrip/eosreach-android) - Kotlin / Android library.
- [eosnet](https://github.com/SNIKO/eosnet) - .NET library.
- [EOSRPC API Wrapper for Elixir](https://github.com/cambiatus/eosrpc-elixir-wrapper) - Elixir library.
- [React Native EOS](https://github.com/EvaCoop/react-native-eos) - Native implementation of client to eos blockchain communication.
- [Transit API for EOS](https://www.eostransit.com/) - Connecting signature providers and dApps through an open-source, modular, and simple standard for EOSIO-based blockchains.
  - [eosnewyork/eos-transit](https://github.com/eosnewyork/eos-transit) - Official GitHub.
  - [The Transit API: Connecting dApps & Signature Providers](https://medium.com/eos-new-york/the-transit-api-connecting-dapps-signature-providers-5d816c056f7f) - Article.
- [greymass/eosio](https://github.com/greymass/eosio-core/) - Strongly typed JavaScript library.
- [greymass/swift-eosio](https://github.com/greymass/swift-eosio) - Swift SDK with ESR support.
- [SwiftyEOS](https://github.com/ProChain/SwiftyEOS) - Framework for interacting with EOS, written in Swift.

#### Authentication and Wallet Signing libraries

- [EOSIO/universal-authenticator-library](https://github.com/EOSIO/universal-authenticator-library) - A library for allowing apps to easily use different auth providers.
  - [EOSIO Labs™ Release: The Universal Authenticator Library (UAL) — Increasing the Accessibility of Blockchain Applications](https://eos.io/news/eosio-labs-release-the-universal-authenticator-library-ual%e2%80%8a-%e2%80%8aincreasing-the-accessibility-of-blockchain-applications/) - Article.
- [EOSIO/eosio-webauthn-example-app](https://github.com/EOSIO/eosio-webauthn-example-app) - Example web app demonstrating EOSIO signing via WebAuthn.
  - [EOSIO Labs™ Release: WebAuthn Example Web App for EOSIO YubiKey Support](https://eos.io/news/eosio-labs-release-webauthn-example-web-app-for-eosio-yubikey-support/) - Article.
- [EOSIO/eosio-reference-chrome-extension-authenticator-app](https://github.com/EOSIO/eosio-reference-chrome-extension-authenticator-app) - Chrome extension reference app demonstrating how users could sign transactions using various EOSIO Labs tools.
  - [EOSIO Labs™ Release: iOS and Chrome Extension Authenticator Reference Applications](https://eos.io/news/eosio-labs-release-ios-and-chrome-extension-authenticator-reference-applications/) - Article.
- [EOSIO/eosio-reference-ios-authenticator-app](https://github.com/EOSIO/eosio-reference-ios-authenticator-app) - iOS reference app demonstrating inter-application transaction signing for EOSIO blockchain apps.
- [EOSIO/ual-scatter](https://github.com/EOSIO/ual-scatter) - Authenticator meant to be used with Scatter and Universal Authenticator Library.
- [greymass/ual-anchor](https://github.com/greymass/ual-anchor) - Authenticator meant to be used with Anchor and Universal Authenticator Library.
- [greymass/anchor-link](https://github.com/greymass/anchor-link) - Persistent, fast and secure signature provider for EOSIO chains built on top of EOSIO Signing Requests (EEP-7).
- [greymass/eosio-signing-request](https://github.com/greymass/eosio-signing-request) - Library to assist in creating and digesting EOSIO Signing Requests (ESR).
- [greymass/eosio-signing-request-java](https://github.com/greymass/eosio-signing-request-java) - Java wrapper for the EOSIO Signing Request protocol.
- [eosdac/ual-wax](https://github.com/eosdac/ual-wax) - UAL authenticator for Wax Cloud Wallet.

#### History

[Intro blog by @cc32d9](https://cc32d9.medium.com/history-and-notifications-in-eosio-blockchain-8255194af93)

- [EOSIO/history-tools](https://github.com/EOSIO/history-tools) - Official EOSIO history API plugin.
- [Hyperion History API](https://github.com/eosrio/Hyperion-History-API) - Scalable Full History API Solution for EOSIO based blockchains.
- [EOSIO Light API](https://github.com/cc32d9/eosio_light_api) - Historic information about EOSIO blockchain accounts and token balances.

#### Testing
- [EOSIO/eosio.contracts](https://github.com/EOSIO/eosio.contracts/tree/master/tests) - Official C++ system contract test suite (notoriously difficult to use).
- [tokenika/eosfactory](https://github.com/tokenika/eosfactory) - Python-based EOSIO smart-contract development & unit testing framework.
- [infeos](https://github.com/infiniteXLabs/infeos) - JavaScript based framework for development, building, deploying and unit testing EOSIO dApps.
- [EOSLIME](https://github.com/LimeChain/eoslime) - Truffle like framework for development, deployment and testing on EOS blockchains.
- [Hydra](https://docs.klevoya.com/hydra/about/getting-started/) - JavaScript framework for testing EOSIO smart contracts.
- [haderech/vert](https://github.com/haderech/vert) - JavaScript EOS-VM emulation RunTime for WASM-based blockchain contracts. Run and test smart contracts.

#### Services
- [Demux](https://github.com/EOSIO/demux-js) - Demux is a backend infrastructure pattern for sourcing blockchain events to deterministically update queryable datastores and trigger side effects.
- [Introducing Demux — Deterministic Databases Off-Chain Verified by the EOSIO Blockchain](https://medium.com/eosio/introducing-demux-deterministic-databases-off-chain-verified-by-the-eosio-blockchain-bd860c49b017) - Article.
- [Liquid Apps](https://docs.liquidapps.io) - Smart contract services vRAM, oracles, cron, IPFS and ICB.
- [WAX Random Number Generator](https://developer.wax.io/es/tutorials/wax-rng)
- [DelphiOracle](https://github.com/eostitan/delphioracle) - A multi-party source of truth, designed to provide the near-realtime price of the asset pairs to other smart contracts or to external users.

### Developer Tools

- [EOSIO/eosio.cdt](https://github.com/EOSIO/eosio.cdt) - EOSIO.CDT (Contract Development Toolkit) is a suite of tools used to build EOSIO contracts.
- [Blanc](https://github.com/haderech/blanc) - A toolchain for building WebAssembly-based blockchain contracts. Currently, Blanc supports EOSIO and CosmWasm (experimental).
- [EOSIO/ricardian-template-toolkit](https://github.com/EOSIO/ricardian-template-toolkit) - Renderer for the Ricardian Contract specification.
- [EOSIO Ethereum Virtual Machine (EVM)](https://github.com/jafri/eosio.evm) - Ethereum Virtual Machine on EOSIO.
- [Elliptic curve cryptography functions (ECC)](https://github.com/EOSIO/eosjs-ecc) - Private Key, Public Key, Signature, AES, Encryption / Decryption.
  - [Securely Generating an EOS Key Pair Using Official EOS.IO Code](https://www.youtube.com/watch?v=G1GUpjc5hkw) - YouTube.
- [EOSEssentials/EOSDrops](https://github.com/EOSEssentials/EOSDrops) - Airdropping tool for the EOSIO blockchain.
- [Octopus](https://github.com/pventuzelo/octopus) - Security Analysis tool for WebAssembly and Blockchain Smart Contracts (BTC/ETH/NEO/EOS).
- [greymass/eosio-resources](https://github.com/greymass/eosio-resources) - Tool to assist in network resource calculations.
- [greymass/abi2core](https://github.com/greymass/abi2core) - Command line utility to convert ABI definitions to greymass/eosio type definitions.
- [maxifom/eos-abigen](https://github.com/maxifom/eos-abigen) - Typescript and Golang code generator for generating type-safe client and tables for EOS-compatible contracts.
- [manh-vv/eosjs-name](https://github.com/manh-vv/eosjs-name) - Convert an Eosio name to uint64 and back.
- [blockchain-etl/eos-etl](https://github.com/blockchain-etl/eos-etl) - Connector for Google's BigQuery Public Datasets.

### Code examples

- [EOSIO/eosio.contracts](https://github.com/EOSIO/eosio.contracts) - Smart contracts that provide some of the basic functions of the EOSIO blockchain.
- [Eosfinex Custody Smart Contract](https://github.com/bitfinexcom/eosfinex-custody-contract) - Eosfinex exchange smart contract.
  - [Bitfinex blog post about eosfinex](https://www.bitfinex.com/posts/616) - Article.
- [EOSIO/eosio-java-android-example-app](https://github.com/EOSIO/eosio-java-android-example-app) - Application demonstrating integration with EOSIO-based blockchains using EOSIO SDK for Java.
- [poorman.token](https://github.com/generEOS/poorman.token) - EOSIO Token with burning and signup (for making the token RAM cheap).
- [EOSEssentials/Scatter-Demos](https://github.com/EOSEssentials/Scatter-Demos) - A set of integration demos using eosjs and Scatter.
- [ping-eos](https://github.com/eosasia/ping-eos) - Implementing ping between EOSIO / React.js.
- [ipfs-eos-demo](https://github.com/wpuricz/ipfs-eos-demo) - Demo saving text and images to ipfs and storing the hash on the EOSIO blockchain.
- [eosnewyork/erp](https://github.com/eosnewyork/erp) - EOS Resource Planner.
- [greymass/anchor-link-demo](https://github.com/greymass/anchor-link-demo) - Example VueJS application integrating greymass/anchor-link.
- [greymass/anchor-link-demo-multipass](https://github.com/greymass/anchor-link-demo-multipass) - Example ReactJS application integrating greymass/anchor-link.
- [greymass/ual-anchor-demo](https://github.com/greymass/ual-anchor-demo) - Example ReactJS application integrating greymass/ual-anchor.
- [greymass/eosio-signing-request-demo](https://github.com/greymass/eosio-signing-request-demo) - Example generating transactions using greymass/eosio-signing-request.
- [theblockstalk/eosio-contracts](https://github.com/theblockstalk/eosio-contracts) - Example smart contracts, dapps and system contract templates.

### Block Producer tools

- [GoogleCloudPlatform/eos-block-producer](https://github.com/GoogleCloudPlatform/eos-block-producer) - Terraform module to create an EOS Block Producer (BP) node on Google Cloud Platform (GCP).
- [Patroneos](https://github.com/EOSIO/patroneos) - RPC Checkpoint for EOSIO nodes.
- [Cypherglass WINDSHIELD](https://github.com/cypherglassdotcom/windshield) - A dashboard tool for monitoring internal Block Producer infrastructure.
- [pete001/eos-bp-failover](https://github.com/pete001/eos-bp-failover) - EOSIO Block Producer Failover Scripts.
- [eosdetroit/bp-playbook](https://github.com/eosdetroit/bp-playbook) - A set of playbooks to make managing EOS.IO nodes easier.
- [eoseoul/eos-ramcost](https://github.com/eoseoul/eos-ramcost) - Adjusting supply of a token and connector balance of bancor during final phase of boot.
- [eosdetroit/nodesuite](https://github.com/eosdetroit/nodesuite) - Nodesuite is a tool to simplify the management and configuration of eosio nodes through the use of Ansible playbooks.

### Other in Developers

- [Community Developer Tools](https://developers.eos.io/welcome/latest/community-developer-tools/index) - Official EOSIO "Community Developer Tools" page.
- [cleos-auto-completion](https://github.com/hexlant/cleos-auto-completion) - Command auto-completion for EOSIO cleos.
- [EOS-Sync](https://github.com/EOSpace/eos-sync) - Syncing the EOSIO blockchain data to mongodb database.
- [OracleChain/EOSBenchTool](https://github.com/OracleChain/EOSBenchTool) - A client side tool for EOS performance testing.
- [breakstring/savemyeosram](https://github.com/breakstring/savemyeosram) - Saving RAM on EOS.
- [clsdk](https://github.com/gofractally/Eden/releases?q=clsdk&expanded=true) - EOSIO smart contract C++ testing framework including in-contract debugging during wasm execution with VS code.

## Community

### Blogs

- [Daniel Larimer](https://moreequalanimals.com/) - Blog of Daniel Larimer, founder of EOSIO.
- [cc32d9](https://medium.com/@cc32d9) - cc32d9 blog, EOSIO developer related publications.
- [cmichel](https://cmichel.io/categories/EOS) - Christoph Michel blog, EOSIO developer related publications.
- [Blockgenic](https://medium.com/@blockgenic) - Blockgenic blog, firm focused on Enterprise adoption of blockchain technology. Learning resources.
- [Dallas Rushing](https://steemit.com/@dallasrushing) - Blog of Dallas Rushing, EOSIO user related content.
- [Iang](https://steemit.com/@iang) - Blog of Iang, EOSIO user and developer related content.
- [EOS Canada](https://steemit.com/@eos-canada) - EOS Canada blog, user related content and videos.
- [Cypherglass](https://steemit.com/@cypherglass) - Cypherglass blog, user related content and videos. News.
- [EOS New York](https://medium.com/@eosnewyork) - EOS New York blog, user and developer related content.
- [Jack Tanner](https://theblockstalk.medium.com) - Jack Tanner blog, EOSIO developer, education and related content.
- [David Williamson](https://www.varilink.co.uk/) - David Williamson blog, EOSIO node management articles.

### YouTube Channels

- [EOS Nation](https://www.youtube.com/channel/UCXgAY9DyooykrubRXw3xK1g) - EOS Hot Sauce, ENF, tech, and community content.
- [Helios](https://www.youtube.com/c/HeliosEOSIO) - Dedicated to growing EOS, interviews and spotlights.
- [EOS Go](https://www.youtube.com/c/EOSGo) - ESO Go community meetings, podcasts, live streams. News and discussions.
- [Investing with a difference](https://www.youtube.com/channel/UC6SxkB3kM4uNs_yIU0Lqo_w) - EOSIO ecosystem overview, news and market discussions.
- [nsjames](https://www.youtube.com/user/grandmoren1) - Scatter related content.
- [Crypto Dunker](https://www.youtube.com/user/clamantfever) - Crypto Dunker channel. EOSIO DApps related content and news.
- [EOS Authority](https://www.youtube.com/channel/UCCBylil96ibgcBC1FDcMouw) - EOS Authority. Useful tutorials, developers related.
- [Jackson Kelley](https://www.youtube.com/user/jackodwhacko) - Developer related content.
- [CodingWithCrypto](https://www.youtube.com/user/magicmanxpress) - Developer related content.
- [Filip Martinsson](https://www.youtube.com/channel/UCyZyNVYEN-54HPYkVVHnRTA) - Developer related content.

### Forums

- [EOSCommunity.org Forums](https://forums.eoscommunity.org/)
- [EOS - Reddit](https://www.reddit.com/r/eos/)
- [EOSDev - Reddit](https://www.reddit.com/r/EOSDev/)
- [EOSIO Developers Telegram](https://t.me/joinchat/0uhWYfXVpPlkNTA1)
- [WAX developers Telegram](https://t.me/waxdevelopers)
- [Teloso developers Telegram](https://t.me/dappstelos)

## EOSIO Ecosystem

- [EOS infographic](https://twitter.com/EOS_Bees/status/1518996327664918531/photo/1) - Infographic for EOS ecosystem.
- [Public EOSIO chains and their telegram chats](https://github.com/eosio-ecosystem/chains)
- [EOSIO Ecosystem](https://github.com/eosio-ecosystem/eosio-ecosystem-resources) - EOSIO multi-chain ecosystem information.

## DApps

DApp resources.

### DApp directories

- [EOSindex](https://eosindex.io/)
- [DappRadar](https://dappradar.com/eos-dapps)
- [State of the Dapps](https://www.stateofthedapps.com/platforms/eos)

### Leasing platforms

- [Chintai](https://chintai.io/)

### Games

- [King Of EOS](https://kingofeos.com/)
  - [MrToph/KingOfEos](https://github.com/MrToph/KingOfEos) - Official GitHub.
  - [Introducing King of EOS](https://cmichel.io/introducing-king-of-eos) - Article.
  - [Learnings from building my first dapp on EOS blockchain](https://cmichel.io/releasing-my-first-eos-dapp) - Article.
- [MonsterEOS](https://monstereos.io/)
  - [MonsterEOS/monstereos](https://github.com/MonsterEOS/monstereos) - Official GitHub.

### Other in DApps

- [EveripediaNetwork/Everipedia](https://github.com/EveripediaNetwork/Everipedia) - The Everipedia Network protocol.
- [eosfilestore](https://github.com/grigio/eosfilestore) - Immutable, censorship resistant, cheap, file storage on EOSIO blockchain.
- [kesar/decentwitter](https://github.com/kesar/decentwitter) - Decentralized Twitter on EOS.
