# Contribution Guidelines

Please note that this project is released with a
[Contributor Code of Conduct](code-of-conduct.md). By participating in this
project you agree to abide by its terms.

---

Ensure your pull request adheres to the following guidelines:

- Search previous suggestions before making a new one, as yours may be a duplicate.
- Make an individual pull request for each suggestion.
- Check your spelling and grammar.
- The pull request and commit should have a useful title (please
  use [Conventional Commits](https://www.conventionalcommits.org/)).
- Make sure your text editor is set to remove trailing whitespace.
- This project is using [Prettier](https://prettier.io/)
  and [awesome-lint](https://github.com/sindresorhus/awesome-lint) to format the source code. You can run following
  commands to format and lint your changes:
  ```shell
  npm ci
  npm run format
  npm run lint
  ```

Thank you for your suggestions!

## Updating your PR

A lot of times, making a PR adhere to the standards above can be difficult.
If the maintainers notice anything that we'd like changed, we'll ask you to
edit your PR before we merge it. There's no need to open a new PR, just edit
the existing one.
