# Awesome Payload [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

> A curated list of awesome Payload resources for users and developers.

[<img src="./media/payload-logo.jpg" alt="Payload" width="300" align="right" />](https://payloadcms.com/)

<p>
<a href="https://payloadcms.com/">Payload</a> is a free and open-source full-stack Next.js framework and headless CMS aimed sharply at providing the best, developer-first experience possible to build out APIs and admin UI.<br />
Payload is natively integrated with Next.js and is installed directly into your Next.js app.
</p>

## Contents

- [Official](#official)
- [Education](#education)
- [Templates](#templates)
- [Plugins](#plugins)

## Official

Official resources.

- [GitHub](https://github.com/payloadcms/payload) - Official GitHub repository of the Payload framework.
- [Blog](https://payloadcms.com/blog) - Official blog. Announcements.
- [Payload Guides & Tutorials](https://payloadcms.com/posts/guides) - High-quality guides and articles.
- [YouTube](https://www.youtube.com/@payloadcms) - Official YouTube channel with learning materials.
- [Discord](https://discord.gg/payload) - Official Discord. Community chat and support.
- [X (Twitter)](https://twitter.com/payloadcms) - Official X account. Payload news and announcements.
- [Reddit](https://www.reddit.com/r/PayloadCMS/) - Discuss and share anything Payload related on Reddit.

## Education

Learning resources in various formats.

### YouTube channels

- [Aaron Saunders](https://www.youtube.com/@AaronSaundersCI) - Payload videos related to integrations and custom components.
- [All About Payload](https://www.youtube.com/@AllAboutPayload) - Tutorials, tips and tricks.
- [Danail Minchev](https://www.youtube.com/@DanailMinchev) - Practical Payload tutorials.
- [Learn Payload with Colyn](https://www.youtube.com/@LearnPayload) - Payload series.
- [NLV Codes](https://www.youtube.com/@nlv_codes) - Channel dedicated to Payload, starting with beginner lessons.
- [Sam Thoyre](https://www.youtube.com/@SamThoyre) - Full courses related to Payload.
- [Studio Monty](https://www.youtube.com/watch?v=MIJRgfRYHSU&list=PLmIBeoKTwgwlVxmmzU3L03v4Iq2mZ_tcR) - Custom components for Payload and useful tips.

### Examples

- [Official examples](https://github.com/payloadcms/payload/tree/main/examples) - Examples from the official repository.
- [Payload website](https://github.com/payloadcms/website) - This is the repository for Payload's official website. It was built completely in public using Payload itself.
- [DanailMinchev / payload-clerk-example](https://github.com/DanailMinchev/payload-clerk-example) - Payload and Clerk example.
  - [Payload and Clerk example](https://www.youtube.com/watch?v=7PNGNqqFlu0) - Part 1. Role-based access control and custom components.
  - [Payload and Clerk advanced integration](https://www.youtube.com/watch?v=egKaeOuddFA) - Part 2. Advanced integration with Clerk webhooks and custom components tested with Playwright.

### Blogs

- [Adrian Maj](https://adrianmaj.com/en/blog) - Practical guides for Payload.

### Articles

- [The Listener Pattern in Payload](https://thelastcode.substack.com/p/the-listener-pattern-in-payloadcms) - Using React principles to create useful behavior for your Payload admin panel.
- [Payload: 2FA Implementation](https://zarif.dev/blogs/payload-cms-2fa-implementation) - Two-factor authentication (2FA) for Payload.
- [Creating a Color Picker](https://medium.com/@mleg1234/creating-a-color-picker-for-payload-cmss-rich-text-editor-lexical-a2ec3528669c) - How to create a custom color picker for Payload's rich-text editor (Lexical).

## Templates

Begin your next project by starting with a pre-made template. These are production-ready, end-to-end solutions.

- [Official templates](https://github.com/payloadcms/payload/tree/main/templates) - Templates from the official repository.
- [ShopNex](https://github.com/shopnex-ai/shopnex) - An open-source Shopify alternative built with Payload.

## Plugins

List of interesting community plugins.

- [r1tsuu / payload-enchants](https://github.com/r1tsuu/payload-enchants) - A collection of enhancement packages for Payload.
- [authsmith / payload-auth-plugin](https://github.com/authsmith/payload-auth-plugin) - This plugin extends the Payload authentication process and implements OAuth- and Passkey-based authentication features.
- [payload-auth / payload-auth](https://github.com/payload-auth/payload-auth) - A monorepo for integrating Payload with various authentication providers.
- [CrawlerCode / payload-authjs](https://github.com/CrawlerCode/payload-authjs) - A Payload plugin for Auth.js.
- [ashbuilds / payload-ai](https://github.com/ashbuilds/payload-ai) - The Payload AI Plugin is a powerful extension, integrating advanced AI capabilities to enhance content creation and management.
- [elliott-w / imageAspectRatios.ts](https://gist.github.com/elliott-w/19676d9373d79ee20b9195601dc45808) - Payload image aspect ratios plugin.
- [AdrianMaj / payload-lexical-typography](https://github.com/AdrianMaj/payload-lexical-typography) - Payload plugin for extending lexical typography options (Text color, Font size, Letter spacing, Line height, Font Family etc.)
- [rilrom / payload-bites](https://github.com/rilrom/payload-bites) - Collection of various bite-sized Payload v3 plugins including image-search, fullscreen-editor, audit-fields, soft-delete and activity-log.
- [shefing / payload-tools](https://github.com/shefing/payload-tools) - Contains a set of powerful plugins designed to enhance your Payload projects (Authorization, Authors Info, Rich-text Comments, Right Panel, Custom Version View, Cross-Collection Config, Field-type Component Override, Color Picker Field, Icon Select, Quick Filter, Reset List View, etc).
- [Crayonan / payload-plugin-ai-localization](https://github.com/Crayonan/payload-plugin-ai-localization) - Adds an AI-powered "Translate" button to non-primary localized fields in Payload. Automatically translates content from the primary language using OpenAI or other models.

## Contributing

Contributions welcome! Read the [contribution guidelines](contributing.md) first.
