# List of Free Learning Resources In Many Languages

<div align="center" markdown="1">

[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)&#160;
[![License: CC BY 4.0](https://img.shields.io/github/license/EbookFoundation/free-programming-books)](https://creativecommons.org/licenses/by/4.0/)&#160;
[![Hacktoberfest 2025 stats](https://img.shields.io/github/hacktoberfest/2025/EbookFoundation/free-programming-books?label=Hacktoberfest+2025)](https://github.com/EbookFoundation/free-programming-books/pulls?q=is%3Apr+is%3Amerged+created%3A2025-10-01..2025-10-31)

</div>

Search the list at [https://ebookfoundation.github.io/free-programming-books-search/](https://ebookfoundation.github.io/free-programming-books-search/) [![https://ebookfoundation.github.io/free-programming-books-search/](https://img.shields.io/website?style=flat&logo=www&logoColor=whitesmoke&label=Dynamic%20search%20site&down_color=red&down_message=down&up_color=green&up_message=up&url=https%3A%2F%2Febookfoundation.github.io%2Ffree-programming-books-search%2F)](https://ebookfoundation.github.io/free-programming-books-search/).

This page is available as an easy-to-read website. Access it by clicking on [![https://ebookfoundation.github.io/free-programming-books/](https://img.shields.io/website?style=flat&logo=www&logoColor=whitesmoke&label=Static%20site&down_color=red&down_message=down&up_color=green&up_message=up&url=https%3A%2F%2Febookfoundation.github.io%2Ffree-programming-books%2F)](https://ebookfoundation.github.io/free-programming-books/).

<div align="center">
  <form action="https://ebookfoundation.github.io/free-programming-books-search">
    <input type="text" id="fpbSearch" name="search" required placeholder="Search Book or Author"/>
    <label for="submit"> </label>
    <input type="submit" id="submit" name="submit" value="Search" />
  </form>
</div>

## Intro

This list was originally a clone of [StackOverflow - List of Freely Available Programming Books](https://web.archive.org/web/20140606191453/http://stackoverflow.com/questions/194812/list-of-freely-available-programming-books/392926) with contributions from Karan Bhangui and George Stocker.

The list was moved to GitHub by Victor Felder for collaborative updating and maintenance. It has grown to become one of [GitHub's most popular repositories](https://octoverse.github.com/).

<div align="center" markdown="1">

[![GitHub repo forks](https://img.shields.io/github/forks/EbookFoundation/free-programming-books?style=flat&logo=github&logoColor=whitesmoke&label=Forks)](https://github.com/EbookFoundation/free-programming-books/network)&#160;
[![GitHub repo stars](https://img.shields.io/github/stars/EbookFoundation/free-programming-books?style=flat&logo=github&logoColor=whitesmoke&label=Stars)](https://github.com/EbookFoundation/free-programming-books/stargazers)&#160;
[![GitHub repo contributors](https://img.shields.io/github/contributors-anon/EbookFoundation/free-programming-books?style=flat&logo=github&logoColor=whitesmoke&label=Contributors)](https://github.com/EbookFoundation/free-programming-books/graphs/contributors)    
[![GitHub org sponsors](https://img.shields.io/github/sponsors/EbookFoundation?style=flat&logo=github&logoColor=whitesmoke&label=Sponsors)](https://github.com/sponsors/EbookFoundation)&#160;
[![GitHub repo watchers](https://img.shields.io/github/watchers/EbookFoundation/free-programming-books?style=flat&logo=github&logoColor=whitesmoke&label=Watchers)](https://github.com/EbookFoundation/free-programming-books/watchers)&#160;
[![GitHub repo size](https://img.shields.io/github/repo-size/EbookFoundation/free-programming-books?style=flat&logo=github&logoColor=whitesmoke&label=Repo%20Size)](https://github.com/EbookFoundation/free-programming-books/archive/refs/heads/main.zip)

</div>

The [Free Ebook Foundation](https://ebookfoundation.org) now administers the repo, a not-for-profit organization devoted to promoting the creation, distribution, archiving, and sustainability of free ebooks. [Donations](https://ebookfoundation.org/contributions.html) to the Free Ebook Foundation are tax-deductible in the US.


## How To Contribute

Please read [CONTRIBUTING](docs/CONTRIBUTING.md). If you're new to GitHub, [welcome](docs/HOWTO.md)! Remember to abide by our adapted from ![Contributor Covenant 1.3](https://img.shields.io/badge/Contributor%20Covenant-1.3-4baaaa.svg) [Code of Conduct](docs/CODE_OF_CONDUCT.md) too ([translations](#translations) also available).

Click on these badges to see how you might be able to help:

<div align="center" markdown="1">

[![GitHub repo Issues](https://img.shields.io/github/issues/EbookFoundation/free-programming-books?style=flat&logo=github&logoColor=red&label=Issues)](https://github.com/EbookFoundation/free-programming-books/issues)&#160;
[![GitHub repo Good Issues for newbies](https://img.shields.io/github/issues/EbookFoundation/free-programming-books/good%20first%20issue?style=flat&logo=github&logoColor=green&label=Good%20First%20issues)](https://github.com/EbookFoundation/free-programming-books/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+issue%22)&#160;
[![GitHub Help Wanted issues](https://img.shields.io/github/issues/EbookFoundation/free-programming-books/help%20wanted?style=flat&logo=github&logoColor=b545d1&label=%22Help%20Wanted%22%20issues)](https://github.com/EbookFoundation/free-programming-books/issues?q=is%3Aopen+is%3Aissue+label%3A%22help+wanted%22)    
[![GitHub repo PRs](https://img.shields.io/github/issues-pr/EbookFoundation/free-programming-books?style=flat&logo=github&logoColor=orange&label=PRs)](https://github.com/EbookFoundation/free-programming-books/pulls)&#160;
[![GitHub repo Merged PRs](https://img.shields.io/github/issues-search/EbookFoundation/free-programming-books?style=flat&logo=github&logoColor=green&label=Merged%20PRs&query=is%3Amerged)](https://github.com/EbookFoundation/free-programming-books/pulls?q=is%3Apr+is%3Amerged)&#160;
[![GitHub Help Wanted PRs](https://img.shields.io/github/issues-pr/EbookFoundation/free-programming-books/help%20wanted?style=flat&logo=github&logoColor=b545d1&label=%22Help%20Wanted%22%20PRs)](https://github.com/EbookFoundation/free-programming-books/pulls?q=is%3Aopen+is%3Aissue+label%3A%22help+wanted%22)

</div>

## How To Share

<div align="left" markdown="1">
<a href="https://www.facebook.com/share.php?u=https%3A%2F%2Fgithub.com%2FEbookFoundation%2Ffree-programming-books&p[images][0]=&p[title]=Free%20Programming%20Books&p[summary]=">Share on Facebook</a><br>
<a href="http://www.linkedin.com/shareArticle?mini=true&url=https://github.com/EbookFoundation/free-programming-books&title=Free%20Programming%20Books&summary=&source=">Share on LinkedIn</a><br>
<a href="https://toot.kytta.dev/?text=https://github.com/EbookFoundation/free-programming-books">Share on Mastodon/Fediverse</a><br>    
<a href="https://t.me/share/url?url=https://github.com/EbookFoundation/free-programming-books">Share on Telegram</a><br>
<a href="https://twitter.com/intent/tweet?text=https://github.com/EbookFoundation/free-programming-books%0AFree%20Programming%20Books">Share on 𝕏 (Twitter)</a><br>
</div>

## Resources

This project lists books and other resources grouped by genres:

### Books

[English, By Programming Language](books/free-programming-books-langs.md)

[English, By Subject](books/free-programming-books-subjects.md)

#### Other Languages

+ [Arabic / al arabiya / العربية](books/free-programming-books-ar.md)
+ [Armenian / Հայերեն](books/free-programming-books-hy.md)
+ [Azerbaijani / Азәрбајҹан дили / آذربايجانجا ديلي](books/free-programming-books-az.md)
+ [Bengali / বাংলা](books/free-programming-books-bn.md)
+ [Bulgarian / български](books/free-programming-books-bg.md)
+ [Burmese / မြန်မာဘာသာ](books/free-programming-books-my.md)
+ [Chinese / 中文](books/free-programming-books-zh.md)
+ [Czech / čeština / český jazyk](books/free-programming-books-cs.md)
+ [Catalan / catalan / català](books/free-programming-books-ca.md)
+ [Danish / dansk](books/free-programming-books-da.md)
+ [Dutch / Nederlands](books/free-programming-books-nl.md)
+ [Estonian / eesti keel](books/free-programming-books-et.md)
+ [Finnish / suomi / suomen kieli](books/free-programming-books-fi.md)
+ [French / français](books/free-programming-books-fr.md)
+ [German / Deutsch](books/free-programming-books-de.md)
+ [Greek / ελληνικά](books/free-programming-books-el.md)
+ [Hebrew / עברית](books/free-programming-books-he.md)
+ [Hindi / हिन्दी](books/free-programming-books-hi.md)
+ [Hungarian / magyar / magyar nyelv](books/free-programming-books-hu.md)
+ [Indonesian / Bahasa Indonesia](books/free-programming-books-id.md)
+ [Italian / italiano](books/free-programming-books-it.md)
+ [Japanese / 日本語](books/free-programming-books-ja.md)
+ [Korean / 한국어](books/free-programming-books-ko.md)
+ [Latvian / Latviešu](books/free-programming-books-lv.md)
+ [Malayalam / മലയാളം](books/free-programming-books-ml.md)
+ [Norwegian / Norsk](books/free-programming-books-no.md)
+ [Persian / Farsi (Iran) / فارسى](books/free-programming-books-fa_IR.md)
+ [Polish / polski / język polski / polszczyzna](books/free-programming-books-pl.md)
+ [Portuguese (Brazil)](books/free-programming-books-pt_BR.md)
+ [Portuguese (Portugal)](books/free-programming-books-pt_PT.md)
+ [Romanian (Romania) / limba română / român](books/free-programming-books-ro.md)
+ [Russian / Русский язык](books/free-programming-books-ru.md)
+ [Serbian / српски језик / srpski jezik](books/free-programming-books-sr.md)
+ [Slovak / slovenčina](books/free-programming-books-sk.md)
+ [Slovenian / Slovenščina](books/free-programming-books-sl.md)
+ [Spanish / español / castellano](books/free-programming-books-es.md)
+ [Swedish / Svenska](books/free-programming-books-sv.md)
+ [Tamil / தமிழ்](books/free-programming-books-ta.md)
+ [Telugu / తెలుగు](books/free-programming-books-te.md)
+ [Thai / ไทย](books/free-programming-books-th.md)
+ [Turkish / Türkçe](books/free-programming-books-tr.md)
+ [Ukrainian / Українська](books/free-programming-books-uk.md)
+ [Urdu / اردو](books/free-programming-books-ur.md)
+ [Vietnamese / Tiếng Việt](books/free-programming-books-vi.md)

### Cheat Sheets

+ [All Languages](more/free-programming-cheatsheets.md)

### Free Online Courses

+ [Arabic / al arabiya / العربية](courses/free-courses-ar.md)
+ [Bengali / বাংলা](courses/free-courses-bn.md)
+ [Bulgarian / български](courses/free-courses-bg.md)
+ [Burmese / မြန်မာဘာသာ](courses/free-courses-my.md)
+ [Chinese / 中文](courses/free-courses-zh.md)
+ [English](courses/free-courses-en.md)
+ [Finnish / suomi / suomen kieli](courses/free-courses-fi.md)
+ [French / français](courses/free-courses-fr.md)
+ [German / Deutsch](courses/free-courses-de.md)
+ [Greek / ελληνικά](courses/free-courses-el.md)
+ [Hebrew / עברית](courses/free-courses-he.md)
+ [Hindi / हिंदी](courses/free-courses-hi.md)
+ [Indonesian / Bahasa Indonesia](courses/free-courses-id.md)
+ [Italian / italiano](courses/free-courses-it.md)
+ [Japanese / 日本語](courses/free-courses-ja.md)
+ [Kannada / ಕನ್ನಡ](courses/free-courses-kn.md)
+ [Kazakh / қазақша](courses/free-courses-kk.md)
+ [Khmer / ភាសាខ្មែរ](courses/free-courses-km.md)
+ [Korean / 한국어](courses/free-courses-ko.md)
+ [Malayalam / മലയാളം](courses/free-courses-ml.md)
+ [Marathi / मराठी](courses/free-courses-mr.md)
+ [Nepali / नेपाली](courses/free-courses-ne.md)
+ [Norwegian / Norsk](courses/free-courses-no.md)
+ [Persian / Farsi (Iran) / فارسى](courses/free-courses-fa_IR.md)
+ [Polish / polski / język polski / polszczyzna](courses/free-courses-pl.md)
+ [Portuguese (Brazil)](courses/free-courses-pt_BR.md)
+ [Portuguese (Portugal)](courses/free-courses-pt_PT.md)
+ [Punjabi / ਪੰਜਾਬੀ / پنجابی](courses/free-courses-pa.md)
+ [Romanian (Romania) / limba română / român](courses/free-courses-ro.md)
+ [Russian / Русский язык](courses/free-courses-ru.md)
+ [Sinhala / සිංහල](courses/free-courses-si.md)
+ [Spanish / español / castellano](courses/free-courses-es.md)
+ [Swedish / svenska](courses/free-courses-sv.md)
+ [Tamil / தமிழ்](courses/free-courses-ta.md)
+ [Telugu / తెలుగు](courses/free-courses-te.md)
+ [Thai / ภาษาไทย](courses/free-courses-th.md)
+ [Turkish / Türkçe](courses/free-courses-tr.md)
+ [Ukrainian / Українська](courses/free-courses-uk.md)
+ [Urdu / اردو](courses/free-courses-ur.md)
+ [Vietnamese / Tiếng Việt](courses/free-courses-vi.md)


### Interactive Programming Resources

+ [Chinese / 中文](more/free-programming-interactive-tutorials-zh.md)
+ [English](more/free-programming-interactive-tutorials-en.md)
+ [German / Deutsch](more/free-programming-interactive-tutorials-de.md)
+ [Japanese / 日本語](more/free-programming-interactive-tutorials-ja.md)
+ [Russian / Русский язык](more/free-programming-interactive-tutorials-ru.md)


### Problem Sets and Competitive Programming

+ [Problem Sets](more/problem-sets-competitive-programming.md)


### Podcast - Screencast

Free Podcasts and Screencasts:

+ [Arabic / al Arabiya / العربية](casts/free-podcasts-screencasts-ar.md)
+ [Burmese / မြန်မာဘာသာ](casts/free-podcasts-screencasts-my.md)
+ [Chinese / 中文](casts/free-podcasts-screencasts-zh.md)
+ [Czech / čeština / český jazyk](casts/free-podcasts-screencasts-cs.md)
+ [Dutch / Nederlands](casts/free-podcasts-screencasts-nl.md)
+ [English](casts/free-podcasts-screencasts-en.md)
+ [Finnish / Suomi](casts/free-podcasts-screencasts-fi.md)
+ [French / français](casts/free-podcasts-screencasts-fr.md)
+ [German / Deutsch](casts/free-podcasts-screencasts-de.md)
+ [Hebrew / עברית](casts/free-podcasts-screencasts-he.md)
+ [Indonesian / Bahasa Indonesia](casts/free-podcasts-screencasts-id.md)
+ [Persian / Farsi (Iran) / فارسى](casts/free-podcasts-screencasts-fa_IR.md)
+ [Polish / polski / język polski / polszczyzna](casts/free-podcasts-screencasts-pl.md)
+ [Portuguese (Brazil)](casts/free-podcasts-screencasts-pt_BR.md)
+ [Portuguese (Portugal)](casts/free-podcasts-screencasts-pt_PT.md)
+ [Russian / Русский язык](casts/free-podcasts-screencasts-ru.md)
+ [Sinhala / සිංහල](casts/free-podcasts-screencasts-si.md)
+ [Spanish / español / castellano](casts/free-podcasts-screencasts-es.md)
+ [Swedish / Svenska](casts/free-podcasts-screencasts-sv.md)
+ [Turkish / Türkçe](casts/free-podcasts-screencasts-tr.md)
+ [Ukrainian / Українська](casts/free-podcasts-screencasts-uk.md)


### Programming Playgrounds

Write, compile, and run your code within a browser. Try it out!

+ [Chinese / 中文](more/free-programming-playgrounds-zh.md)
+ [English](more/free-programming-playgrounds.md)
+ [German / Deutsch](more/free-programming-playgrounds-de.md)

## Translations

Volunteers have translated many of our Contributing, How-to, and Code of Conduct documents into languages covered by our lists.

+ English
  + [Code of Conduct](docs/CODE_OF_CONDUCT.md)
  + [Contributing](docs/CONTRIBUTING.md)
  + [How-to](docs/HOWTO.md)
+ ... *[More languages](docs/README.md#translations)* ...

You might notice that there are [some missing translations here](docs/README.md#translations) - perhaps you would like to help out by [contributing a translation](docs/CONTRIBUTING.md#help-out-by-contributing-a-translation)?


## License

Each file included in this repository is licensed under the [CC BY License](LICENSE).
