### Index

* [0 - Language Agnostic](#0---language-agnostic)
    * [Архитектура приложений](#архитектура-приложений)
    * [Облачные Вычисления](#облачные-вычисления)
    * [Парадигмы Программирования](#парадигмы-программирования)
    * [Производительность](#производительность)
    * [Работа c cетью](#работа-с-сетью)
    * [Управление конфигурациями](#управление-конфигурациями)
    * [Экосистема открытого исходного кода](#экосистема-открытого-исходного-кода)
    * [IDE and editors](#ide-and-editors)
* [Arduino](#arduino)
* [Assembly](#assembly)
* [Bash](#bash)
* [C](#c)
* [C#](#csharp)
* [C++](#cpp)
* [Clojure](#clojure)
* [CoffeeScript](#coffeescript)
* [Elasticsearch](#elasticsearch)
* [Elixir](#elixir)
* [Erlang](#erlang)
* [Git](#git)
* [Go](#go)
* [Haskell](#haskell)
* [HTML and CSS](#html-and-css)
    * [Bootstrap](#bootstrap)
* [Java](#java)
    * [Android](#android)
    * [EasyMock](#easymock)
    * [Hibernate](#hibernate)
    * [JDBC](#jdbc)
    * [JUnit](#junit)
    * [Maven](#maven)
    * [Spring](#spring)
    * [Swing UI](#swing-ui)
* [JavaScript](#javascript)
    * [AngularJS](#angularjs)
    * [jQuery](#jquery)
    * [Node.js](#nodejs)
    * [nuxt.js](#nuxtjs)
    * [React](#react)
    * [vue.js](#vuejs)
* [Kotlin](#kotlin)
* [LaTeX](#latex)
* [Lisp](#lisp)
* [MetaPost](#metapost)
* [.NET](#net)
* [NoSQL](#nosql)
* [Objective-C](#objective-c)
* [Perl](#perl)
* [PHP](#php)
    * [CakePHP](#cakephp)
    * [CodeIgniter](#codeigniter)
    * [Laravel](#laravel)
    * [Symfony](#symfony)
    * [Yii](#yii)
* [Python](#python)
    * [Django](#django)
    * [Jupyter Notebook](#jupyter-notebook)
    * [NumPy](#numpy)
    * [Pycharm](#pycharm)
* [R](#r)
* [Ruby](#ruby)
    * [RSpec](#rspec)
    * [Ruby on Rails](#ruby-on-rails)
* [Rust](#rust)
* [Scala](#scala)
* [Scilab](#scilab)
* [Scratch](#scratch)
* [Smalltalk](#smalltalk)
* [SQL](#sql)
    * [FirebirdSQL](#firebirdsql)
    * [PostgreSQL](#postgresql)
* [Swift](#swift)
* [Symbian](#symbian)
* [TypeScript](#typescript)
    * [Angular](#angular)
* [Unix](#unix)


### 0 - Language Agnostic

* [Введение в методы машинной обработки данных](https://mkurnosov.net/docs/dsa-book-2020.pdf) - Курносов М.Г. (PDF)
* [Операционные системы](https://vseloved.github.io/pdf/os-ru.pdf) - Всеволод Дёмкин (PDF)
* [Параллельные технологии](http://www.inp.nsk.su/~baldin/Parallel/index.html)
* [Программирование: введение в профессию](http://stolyarov.info/books/programming_intro) - Столяров Андрей Викторович (PDF)
* [Руководство по HTTP](http://proselyte.net/tutorials/http-tutorial) - Евгений Сулейманов
* [Руководство по SOAP](http://proselyte.net/tutorials/soap-tutorial) - Евгений Сулейманов
* [Структура и интерпретация компьютерных программ](http://newstar.rinet.ru/~goga/sicp/sicp-ru-screen.pdf) - Гарольд Абельсон, Джералд Джей Сассман (PDF)
* [Тестирование программного обеспечения. Базовый курс.](http://svyatoslav.biz/software_testing_book/) - Святослав Куликов (PDF)
* [Эффективные алгоритмы и сложность вычислений](http://discopal.ispras.ru/Ru.book-advanced-algorithms.htm) - Кузюрин Н.Н., Фомин С.А.
* [E-maxx.ru: Сборник алгоритмов с примерами на C++](http://e-maxx.ru/upload/e-maxx_algo.pdf) (PDF)
* [Scrum и XP: заметки с передовой](http://scrum.org.ua/wp-content/uploads/2008/12/scrum_xp-from-the-trenches-rus-final.pdf) (PDF)


#### Архитектура приложений

* [The API](https://twirl.github.io/The-API-Book/index.ru.html) - Сергей Константинов (HTML, PDF, EPUB)


#### Облачные вычисления

* [Программирование Cloud Native. Микросервисы, Docker и Kubernetes](https://ipsoftware.ru/books/cloud-k8s/) - Иван Портянкин (PDF, EPUB, MOBI)
* [Разработка мультитенантных приложений для облака, издание 3-е](http://www.microsoft.com/ru-ru/download/details.aspx?id=29263)


#### Парадигмы программирования

* [Введение в функциональное программирование](http://funprog-ru.github.io) - John Harrison
* [Практика функционального программирования](https://www.fprog.ru) - журнал
* [Рефакторинг на максималках](https://github.com/bespoyasov/refactor-like-a-superhero-online-book/blob/main/manuscript-ru/README.md) - Александр Беспоясов


#### Производительность

* [Продуманная оптимизация](https://optimization.guide) - Карлос Буэно


#### Работа с сетью

* [Наука о Сетях](http://networksciencebook.com) - Альберто Лазло-Барабаси *( :construction: в процессе написания)*
* [Разъяснение HTTP2](https://github.com/vlet/http2-explained/blob/master/http2.ru.pdf?raw=true) - Даниэль Штенберг (PDF)
* [IPv6 для знатоков IPv4](https://sites.google.com/site/yartikhiy/home/ipv6book) - Ярослав Тихий (PDF, HTML, EPUB)


#### Управление конфигурациями

* [Пособие по Ansible](https://github.com/freetonik/ansible-tuto-rus) - Michel Blanc


#### Экосистема открытого исходного кода

* [Архитектура приложений с открытым исходным кодом](http://rus-linux.net/MyLDP/BOOKS/Architecture-Open-Source-Applications/index.html)


#### IDE and editors

* [Поваренная Книга Vim](http://www.opennet.ru/docs/RUS/vim_cookbook) - Steve Oualline
* [Просто о Vim](http://rus-linux.net/MyLDP/BOOKS/Vim/prosto-o-vim.pdf) - Swaroop (PDF)


### Arduino

* [Автомато-программато-компарадио-кружок](https://github.com/artyom-poptsov/SPARC/blob/master/README.ru.org) - Artyom V. Poptsov (PDF) (CC BY-SA)


### Assembly

* [Ассемблер в Linux для программистов C](https://ru.wikibooks.org/wiki/Ассемблер_в_Linux_для_программистов_C) - Викиучебник
* [Ассемблер для чайников](http://av-assembler.ru/asm/afd/assembler-for-dummy.htm)
* [Программирование на языке ассемблера NASM для ОС Unix](http://www.stolyarov.info/books/pdf/nasm_unix.pdf) - Андрей Столяров (PDF)


### Bash

* [Advanced Bash-Scripting Guide](http://rus-linux.net/MyLDP/BOOKS/abs-guide/flat/abs-book.html)


### C

* [Заметки о языке программирования Си/Си++](https://yurichev.com/writings/C-notes-ru.pdf) - Денис Юричев (PDF)
* [Краткое руководство Beej к GDB](https://paintingvalley.com/ru-bggdb) - Brian "Beej Jorgensen" Hall (HTML)
* [Особенности языка C. Учебное пособие](https://younglinux.info/c) - C. Шапошникова (PDF)
* [Разработка сетевых приложений](http://zed.karelia.ru/mmedia/docs/nets.pdf) (PDF)
* [Руководство по языку программирования C](https://metanit.com/cpp/c) - Евгений Попов
* [Сетевое программирование от Биджа - Использование Интернет Сокетов](http://beej.us/guide/bgnet/translations/bgnet_A4_rus.pdf) - Brian "Beej Jorgensen" Hall, Перевод Андрея Косенко (PDF)
* [Си/Си++. От дилетанта до профессионала](http://ermak.cs.nstu.ru/cprog/html) - Романов Е.Л.
* [Язык Си в примерах](https://ru.wikibooks.org/wiki/Язык_Си_в_примерах) - Викиучебник


### <a id="csharp"></a>C\#

* [Паттерны проектирования в C# и .NET](https://metanit.com/sharp/patterns) - Евгений Попов
* [Полное руководство по языку программирования С# 7.0 и платформе .NET 4.7](https://metanit.com/sharp/tutorial) - Евгений Попов
* [Сетевое программирование в С# и .NET](https://metanit.com/sharp/net) - Евгений Попов
* [Design Patterns via C#](http://itvdn.com/ru/patterns) - Александр Шевчук, Дмитрий Охрименко, Андрей Касьянов (PDF) *(Требуется аккаунт)*


### <a id="cpp"></a>C++

* [Введение в язык программирования С++](http://lib.ru/CPPHB/cpptut.txt_with-big-pictures.html) - Бьерн Страуструп
* [Введение в язык Си++](http://stolyarov.info/books/cppintro) - Андрей Столяров (PDF)
* [Вводный курс по объектно-ориентированному программированию на языке Си++](http://ru.wikibooks.org/wiki/Си-плюс-плюс) - Викиучебник
* [Руководство по языку программирования C++](https://metanit.com/cpp/tutorial) - Евгений Попов
* [Справочное руководство по C++](http://lib.ru/CPPHB/cppref.txt_with-big-pictures.html) - Бьерн Страуструп
* [Уроки по OpenGL 3](https://code.google.com/archive/p/gl33lessons/) - Гуревич Артём


### Clojure

* [Введение в Clojure](http://alexott.net/ru/clojure/clojure-intro) - Алексей Отт


### CoffeeScript

* [Документация CoffeeScript](http://cidocs.ru/coffeescript) - Jeremy Ashkenas
* [The Little Book on CoffeeScript](https://github.com/andrew--r/the-little-book-on-coffeescript) - перевод Андрея Романова


### Elasticsearch

* [Уроки по Elasticsearch](https://codedzen.ru/category/uroki/elasticsearch)


### Elixir

* [Уроки программирования на языке Elixir](http://elixirschool.com/ru)


### Erlang

* [Программирование на Эрланге](https://github.com/dyp2000/Russian-Armstrong-Erlang) - Джо Армстронг


### Git

* [Волшебство Git](http://www-cs-students.stanford.edu/~blynn/gitmagic/intl/ru) - Ben Lynn, `trl.:` Tikhon Tarnavsky, `trl.:` Mikhail Dymskov, et al. (HTML)
* [Простое руководство по работе с Git](https://rogerdudler.github.io/git-guide/index.ru.html) - Roger Dudler, `trl.:` Dmitry Wolf (HTML)
* [Руководство по Git](https://proselyte.net/tutorials/git) - Евгений Сулейманов (HTML)
* [Pro Git](http://git-scm.com/book/ru/) - Scott Chacon, Ben Straub, et al. (HTML, PDF, EPUB, Kindle)


### Go

* [Введение в программирование на Go](http://golang-book.ru) - Калеб Докси
* [Руководство по языку Go](https://metanit.com/go/tutorial) - Евгений Попов
* [Эффективный Go](https://github.com/Konstantin8105/Effective_Go_RU)
* [Go в примерах](https://web.archive.org/web/20210727024101/https://gobyexample.ru) *( :card_file_box: archived)*
* [Go для PHP-разработчиков](https://pahanini.gitbooks.io/golang-for-php-developers/content/) - Pavel Tetyaev (gitbook)
* [The Little Go Book (перевод)](https://sefus.ru/little-go-book) - Karl Seguin, `trl.:` Roman Dolgolopov, Evgeny Popov, Alexander Dunin ([HTML](https://github.com/sefus/the-little-go-book/blob/master/ru/go.md), [EPUB](https://sefus.ru/dl/go.epub))


### Haskell

* [О Haskell по-человечески](https://www.ohaskell.guide) - Денис Шевченко
* [Учебник по Haskell](http://anton-k.github.io/ru-haskell-book/book/home.html) - Антон Холомьёв
* [Язык и библиотеки Haskell 98](http://www.haskell.ru) - Simon Peyton Jones
* [Язык программирования Haskell: Учимся быть ленивыми](https://github.com/Number571/Haskell/tree/master/Book) - Г. Коваленко
* [Haskell: введение в функциональное программирование](https://wiki.nsunc.com/_export/html/haskell) - В.Н. Власов


### HTML and CSS

* [Руководство по HTML5 и CSS3](https://metanit.com/web/html5) - Евгений Попов
* [Справочник по HTML](http://htmlbook.ru/html) - Влад Мержевич
* [Справочник CSS](http://htmlbook.ru/css) - Влад Мержевич
* [CSS и CSS3](https://html5book.ru/css-css3) - Елена Назарова
* [HTML и HTML5](https://html5book.ru/html-html5) - Елена Назарова


#### Bootstrap

* [Bootstrap 4](http://getbootstrap.ru/docs/v4-alpha)


### Java

* [Руководство по языку программирования Java](https://metanit.com/java/tutorial) - Евгений Попов
* [Руководство по Java Core](http://proselyte.net/tutorials/java-core) - Евгений Сулейманов
* [Руководство по Servlets](http://proselyte.net/tutorials/servlets) - Евгений Сулейманов
* [Самоучитель по Java с нуля](https://vertex-academy.com/tutorials/ru/samouchitel-po-java-s-nulya/) - Vertex Academy
* [Собеседование по Java Core](http://javastudy.ru/interview/list-of-question-java-interview)
* [Собеседование по Java EE](http://javastudy.ru/interview/list-of-questions-javaee-interview)
* [Учебник по Java 8](https://vertex-academy.com/tutorials/ru/java-8-uchebnik/) - Vertex Academy
* [Учебник по Java 9](https://vertex-academy.com/tutorials/ru/java-9-uchebnik-teoriya-primery/) - Vertex Academy
* [Учебник Java 8](https://urvanov.ru/2016/03/23/%D1%83%D1%87%D0%B5%D0%B1%D0%BD%D0%B8%D0%BA-java-8) - Фёдор Урванов
* [Язык Java 8](https://easyjava.ru/java/yazyk-java/)
* [Java Basics](http://www.fandroid.info/tutorial-po-osnovam-yazyka-programmirovaniya-java-dlya-nachinayushhih/)
* [Java Programming for Kids, Parents and Grandparents](http://myflex.org/books/java4kids/java4kids.htm) - Yakov Fain


#### Android

* [Программирование под Android](https://metanit.com/java/android) - Евгений Попов
* [Уроки по Android](http://startandroid.ru/ru/uroki/vse-uroki-spiskom.html)


#### EasyMock

* [EasyMock 3](https://easyjava.ru/testirovanie/easymock/)


#### Hibernate

* [Руководство по Hibernate](http://proselyte.net/tutorials/hibernate-tutorial) - Евгений Сулейманов
* [Hibernate](https://easyjava.ru/data/hibernate/)


#### JDBC

* [Руководство по JDBC](http://proselyte.net/tutorials/jdbc) - Евгений Сулейманов
* [JDBC и Spring JDBC](https://easyjava.ru/data/jdbc/)


#### JUnit

* [Руководство по JUnit](http://proselyte.net/tutorials/junit) - Евгений Сулейманов
* [JUnit 4](https://easyjava.ru/testirovanie/junit-2/)


#### Maven

* [Руководство по Maven](http://proselyte.net/tutorials/maven) - Евгений Сулейманов
* [Apache Maven](https://easyjava.ru/ekosistema/sredstva-sborki/apache-maven/)
* [Maven Tutorial](https://coderlessons.com/tutorials/java-tekhnologii/uchitsia-maven/maven-nastroika-sredy) - CoderLessons.com


#### Spring

* [Руководство по Spring](http://proselyte.net/tutorials/spring-tutorial-full-version) - Евгений Сулейманов
* [Spring Framework](https://easyjava.ru/spring/)
* [Spring MVC Tutorial](https://coderlessons.com/tutorials/java-tekhnologii/uchis-spring-mvc/spring-mvc-tutorial) - CoderLessons.com


#### Swing UI

* [Java Swing: Эффектные пользовательские интерфейсы - Издание второе](https://ipsoftware.ru/books/swing_book_2/) - Иван Портянкин (PDF, EPUB)


### JavaScript

* [Вы не знаете JS (серия книг)](https://github.com/azat-io/you-dont-know-js-ru) - Кайл Симпсон
* [Выразительный JavaScript](https://github.com/karmazzin/eloquentjavascript_ru) - Marijn Haverbeke
* [Онлайн-книга по WebGL](https://metanit.com/web/webgl) - Евгений Попов
* [Паттерны для масштабируемых JavaScript-приложений](http://largescalejs.ru) - Эдди Османи
* [Руководство по JavaScript](https://metanit.com/web/javascript) - Евгений Попов
* [Современный учебник JavaScript](http://learn.javascript.ru) - Илья Кантор
* [Учебник по Javascript](https://coderlessons.com/tutorials/veb-razrabotka/uchit-javascript/uchebnik-po-javascript) - CoderLessons.com
* [JavaScript и jQuery](https://html5book.ru/javascript-jquery) - Елена Назарова


#### AngularJS

> :information_source: See also &#8230; [Angular](#angular)

* [Онлайн-руководство по AngularJS](https://metanit.com/web/angular) - Евгений Попов
* [AngularJS Tutorial](https://coderlessons.com/tutorials/veb-razrabotka/vyuchit-angularjs/angularjs-tutorial) - CoderLessons.com


#### jQuery

* [Онлайн-книга "Изучаем jQuery"](https://metanit.com/web/jquery) - Евгений Попов
* [Русская документация по API jQuery](https://jquery-docs.ru)
* [jQuery для начинающих](http://anton.shevchuk.name/jquery-book) - Антон Шевчук
* [JQuery Tutorial](https://coderlessons.com/tutorials/veb-razrabotka/jquery/jquery-tutorial) - CoderLessons.com


#### Node.js

* [Руководство по Node.js](https://metanit.com/web/nodejs) - Евгений Попов
* [Учебник Node.js](https://coderlessons.com/tutorials/veb-razrabotka/uchebnik-node-js/uchebnik-node-js) - CoderLessons.com


#### Nuxt.js

* [Перевод документации](https://ru.nuxtjs.org)


#### React

* [Перевод документации](https://ru.reactjs.org/docs/getting-started.html)
* [Руководство по React](https://metanit.com/web/react) - Евгений Попов
* [Уроки по React](https://codedzen.ru/category/uroki/react)
* [Учебник по фреймворку React](http://old.code.mu/books/advanced/javascript/react/)
* [Учебник ReactJS](https://coderlessons.com/tutorials/veb-razrabotka/uznaite-reactjs/uchebnik-reactjs) - CoderLessons.com


#### Vue.js

* [Перевод документации](https://v3.ru.vuejs.org)
* [Руководство по Vue.js](https://metanit.com/web/vuejs) - Евгений Попов
* [VueJS Учебник](https://coderlessons.com/tutorials/veb-razrabotka/vyuchit-vuejs/vuejs-uchebnik) - CoderLessons.com


### Kotlin

* [Руководство по языку Kotlin](http://kotlinlang.ru)
* [Руководство по языку Kotlin](https://metanit.com/java/kotlin) - Евгений Попов
* [Учебник по Котлину](https://coderlessons.com/tutorials/mobilnaia-razrabotka/uchebnik-kotlin/1-uchebnik-po-kotlinu) - CoderLessons.com


### LaTeX

* [LaTeX за три дня](http://www.stolyarov.info/books/pdf/latex3days.pdf) - Андрей Столяров (PDF)
* [LaTeX, GNU/Linux и русский стиль (сборник статей)](http://www.inp.nsk.su/~baldin/LaTeX/index.html)


### Lisp

* [Lisp In Small Pieces (translation)](https://github.com/ilammy/lisp)
* [Practical Common Lisp (перевод)](https://web.archive.org/web/20220130051228/http://lisper.ru/pcl/) (HTML) *( :card_file_box: archived)*


### MetaPost

* [Создание иллюстраций в MetaPost](http://www.inp.nsk.su/~baldin/mpost/index.html)


### .NET

* [Руководство по ADO.NET и работе с базами данных](https://metanit.com/sharp/adonet) - Евгений Попов
* [Руководство по ASP.NET Core 2.0](https://metanit.com/sharp/aspnet5) - Евгений Попов
* [Руководство по ASP.NET MVC 5](https://metanit.com/sharp/mvc5) - Евгений Попов
* [Руководство по ASP.NET Web API 2](https://metanit.com/sharp/aspnet_webapi) - Евгений Попов
* [Руководство по EF Core](https://metanit.com/sharp/entityframeworkcore) - Евгений Попов
* [Руководство по Entity Framework](https://metanit.com/sharp/entityframework) - Евгений Попов


### NoSQL

* [Маленькая книга о MongoDB](http://www.pvsm.ru/download/mongodb-ru.pdf) - Карл Сегуин (PDF)
* [Маленькая книга о Redis](https://github.com/kondratovich/the-little-redis-book/blob/master/ru/redis.md) - Карл Сегуин
* [Руководство по MongoDB](http://proselyte.net/tutorials/mongodb) - Евгений Сулейманов


### Objective-C

* [Хрестоматия iOS паттернов](https://maleevdimka.files.wordpress.com/2013/04/ios-patterns-cliff-notes2.pdf) (PDF)
* [Цикл статей разработки под Apple iOS](http://habrahabr.ru/post/149090/)
* [Become an XCoder](https://yadi.sk/d/ugz7jW4RXLGTN)


### Perl

* [Введение в Perl](http://www.opennet.ru/docs/RUS/perl-maslov/) - Маслов Владимир Викторович
* [Краткий экскурс в Perl-программирование](http://www.opennet.ru/docs/RUS/perl_help/) - Докучаев Дмитрий
* [Pragmatic Perl](http://pragmaticperl.com) - журнал


### PHP

* [Архитектура сложных веб-приложений. С примерами на Laravel](https://github.com/adelf/acwa_book_ru) - Adel Faizrakhmanov (PDF, EPUB, Kindle)
* [Руководство по PHP](http://docs.php.net/manual/ru)
* [Руководство по PHPUnit](https://phpunit.readthedocs.io/ru/latest/)
* [Самоучитель (учебник) по PHP](http://www.php-s.ru/self-teacher)
* [Учебник по PHP](https://coderlessons.com/tutorials/veb-razrabotka/vyuchit-php/uchebnik-po-php)
* [Учебник по PHP 7](https://coderlessons.com/tutorials/veb-razrabotka/vyuchit-php-7/uchebnik-po-php-7)
* [PHP: Правильный Путь](http://getjump.github.io/ru-php-the-right-way)


#### CakePHP

* [Руководство](https://book.cakephp.org/3.0/ru/index.html)
* [CakePHP Учебное пособие](https://coderlessons.com/tutorials/veb-razrabotka/uznaite-cakephp/cakephp-uchebnoe-posobie)


#### CodeIgniter

* [CodeIgniter](http://codeigniter3.info) - Игорь Букша
* [CodeIgniter — Основные понятия](https://coderlessons.com/tutorials/veb-razrabotka/vyuchit-codeigniter/codeigniter-osnovnye-poniatiia)
* [CodeIgniter фреймворк](https://coderlessons.com/tutorials/veb-razrabotka/codeigniter-freimvork/codeigniter-freimvork)


#### Laravel

* [Документация 5.x](https://laravel.ru/docs/v5)
* [Перевод документации](http://laravel.su/docs)
* [Учебник Laravel](https://coderlessons.com/tutorials/veb-razrabotka/vyuchi-laravel/uchebnik-laravel)


#### Symfony

* [Учебник по Symfony](https://coderlessons.com/tutorials/veb-razrabotka/uchit-symfony/uchebnik-po-symfony)
* [Symfony 5.4: Быстрый старт](https://symfony.com/doc/5.4/the-fast-track/ru/index.html)
* [Symfony 6.2: Быстрый старт](https://symfony.com/doc/6.2/the-fast-track/ru/index.html)


#### Yii

* [Полное руководство по Yii 2.0](https://www.yiiframework.com/doc/download/yii-guide-2.0-ru.pdf) - Yii Software (PDF)


### Python

* [Вглубь языка Python](https://web.archive.org/web/20170630204729/ru.diveintopython.net/toc.html) *( :card_file_box: archived)*
* [Основы программирования на Python](http://dfedorov.spb.ru/python3) - Дмитрий Фёдоров (PDF)
* [Пишем Telegram-ботов на Python (v2)](https://mastergroosha.github.io/telegram-tutorial-2/) - MasterGroosha
* [Руководство по языку программирования Python](https://metanit.com/python/tutorial) - Евгений Попов
* [Самоучитель Python](https://pythonworld.ru/samouchitel-python) (PDF)
* [Укус Питона](http://wombat.org.ua/AByteOfPython) - Swaroop C H
* [Учебник Python 2.6](https://ru.wikibooks.org/wiki/Учебник_Python_2.6) - Викиучебник
* [Problem Solving with Algorithms and Data Structures](https://aliev.github.io/runestone)
* [Python. Введение в объектно-ориентированное программирование](https://younglinux.info/oopython.php) - C. Шапошникова
* [Python. Введение в программирование](https://younglinux.info/python.php) - C. Шапошникова
* [Python. Уроки](https://devpractice.ru/book-python-lessons) - Абдрахманов М.И.
* [Python. unittest](https://devpractice.ru/book-python-unittest) - Абдрахманов М.И
* [Tkinter. Программирование графического интерфейса](https://younglinux.info/tkinter.php) - C. Шапошникова


#### Django

* [Руководство по веб-фреймворку Django](https://metanit.com/python/django) - Евгений Попов
* [Руководство Django Girls](https://tutorial.djangogirls.org/ru) (1.11) (HTML) *( :construction: в процессе написания)*


#### Jupyter Notebook

* [Учебник по Jupyter](https://coderlessons.com/tutorials/python-technologies/jupyter/uchebnik-po-jupyter) - CoderLessons.com


#### NumPy

* [NumPy Tutorial](https://coderlessons.com/tutorials/python-technologies/uchitsia-numpy/numpy-tutorial) - CoderLessons.com


#### Pycharm

* [Pycharm — Введение](https://coderlessons.com/tutorials/python-technologies/uznaite-pycharm/pycharm-vvedenie) - CoderLessons.com


### R

* [Анализ данных с R](http://www.inp.nsk.su/~baldin/DataAnalysis/index.html)
* [Наглядная статистика. Используем R!](https://cran.r-project.org/doc/contrib/Shipunov-rbook.pdf) (PDF)
* [Рандомизация и бутстреп: статистический анализ в биологии и экологии с использованием R.](http://www.ievbras.ru/ecostat/Kiril/Article/A32/Starb.pdf) (PDF)


### Ruby

* [Руководство пользователя](http://linux.yaroslavl.ru/docs/prog/ruby.html) - matz
* [Учись программировать](http://www.shokhirev.com/mikhail/ruby/ltp/title.html) - Крис Пайн
* [Ruby](https://ru.wikibooks.org/wiki/Ruby) - Викиучебник
* [Ruby за двадцать минут](https://www.ruby-lang.org/ru/documentation/quickstart)
* [Ruby Book](https://github.com/Krugloff/rus_ruby_book) - Круглов А.


#### RSpec

* [Better Specs (RSpec Guidelines with Ruby)](http://betterspecs.org/ru)


#### Ruby on Rails

* [Ruby on Rails по-русски](http://rusrails.ru)
* [Ruby on Rails Tutorial. Изучение Rails на Примерах](https://web.archive.org/web/20181124010958/railstutorial.ru/chapters/4_0/beginning) - Майкл Хартл *( :card_file_box: archived)*


### Rust

* [Растономикон](https://github.com/ruRust/rustonomicon)
* [Язык программирования Rust](https://doc.rust-lang.ru/book/)
* [Rust на примерах](https://doc.rust-lang.ru/stable/rust-by-example/index.html)
* [Rust Tutorial](https://coderlessons.com/tutorials/kompiuternoe-programmirovanie/nauchitsia-programmirovaniiu-na-rust/rust-tutorial) - CoderLessons.com


### Scala

* [Путеводитель неофита по Scala (перевод серии статей Даниеля Вестсайда)](https://github.com/anton-k/ru-neophyte-guide-to-scala) - Антон Холомьёв
* [Руководство по Scala](http://proselyte.net/tutorials/scala) - Евгений Сулейманов
* [Effective Scala](http://twitter.github.io/effectivescala/index-ru.html) - Marius Eriksen
* [Scala Школа!](http://twitter.github.io/scala_school/ru) - Twitter


### Scilab

* [Введение в Scilab](http://forge.scilab.org/index.php/p/docintrotoscilab/downloads)
* [Программирование в Scilab](http://forge.scilab.org/index.php/p/docprogscilab/downloads)


### Scratch

* [Креативное программирование](https://www.dropbox.com/s/qsthpk5r6gqmi6u/CreativeComputing_RUS_june2016.pdf?dl=0) (PDF)


### Smalltalk

* [Смолток: Язык и его реализация](https://sites.google.com/site/polyglotsqueak) - Адэль Голдберг, Дэвид Робсон


### SQL

* [Работа с MySQL, MS SQL Server и Oracle в примерах](http://svyatoslav.biz/database_book/) - Святослав Куликов (PDF)
* [Руководство по MS SQL Server 2017](https://metanit.com/sql/sqlserver) - Евгений Попов
* [Руководство по SQL](http://proselyte.net/tutorials/sql) - Евгений Сулейманов
* [Язык SQL. Базовый курс](https://postgrespro.ru/education/books/sqlprimer) (PDF)


#### FirebirdSQL

* [Краткое руководство по миграции на Firebird 4.0](https://github.com/sim1984/fbmigrgd40/releases/download/1.0/doc.rus.pdf) - Denis Simonov (PDF)
* [Руководство по аппаратному обеспечению для Firebird](http://www.ibase.ru/files/firebird/Firebird_Hardware_Guide_2015_rus.pdf) - IBSurgeon (PDF)
* [Руководство по написанию UDR на Pascal](https://github.com/sim1984/udr-book) - Denis Simonov ([PDF](https://github.com/sim1984/udr-book/releases/download/1/udr.pdf), [:package: code examples](https://github.com/sim1984/udr-book/tree/master/examples))
* [Руководство по языку Firebird 3.0](http://www.ibase.ru/files/firebird/Firebird_3_0_Language_Reference_RUS.pdf) - Denis Simonov, Paul Vinkenug, Dmitry Filippov, Dmitry Emanov, Alexander Karpeikin, Dmitry Kuzmenko, Alexey Kovyazin (PDF)
* [Руководство по языку Firebird 4.0](http://www.ibase.ru/files/firebird/Firebird_4_0_Language_Reference_RUS.pdf) - Dmitry Filippov, Alexander Karpeikin, Alexey Kovyazin, Dmitry Kuzmenko, Denis Simonov, Paul Vinkenoog, Dmitry Emanov, Mark Rotteveel (PDF)


#### PostgreSQL

* [Документация](https://postgrespro.ru/docs/postgresql) (PDF)
* [История о PostgreSQL](http://www.inp.nsk.su/~baldin/PostgreSQL/index.html) - Linux Format
* [Работа с PostgreSQL - настройка и масштабирование](http://postgresql.leopard.in.ua) - А. Ю. Васильев
* [PostgreSQL для начинающих](https://postgrespro.ru/education/books/introbook) - Luzanov Pavel Veniaminovich, Rogov Yegor Valerievich, Levshin Igor Viktorovich (PDF)
* [PostgreSQL. Основы языка SQL](https://postgrespro.ru/education/books/sqlprimer) - Моргунов Евгений Павлович (PDF)


### Swift

* [Документация и туториалы](https://swiftbook.ru)
* [Swift Tutorial](https://coderlessons.com/tutorials/kompiuternoe-programmirovanie/nauchites-programmirovaniiu-swift/swift-tutorial) - CoderLessons.com


### Symbian

* [Symbian C++](https://github.com/trufanov-nok/SymbianBook_ru) -  А. Н Труфанов


### TypeScript

* [Карманная книга по TypeScript](https://typescript-handbook.ru) - Igor Agapov
* [Руководство по TypeScript](https://metanit.com/web/typescript) - Евгений Попов


#### Angular

> :information_source: See also &#8230; [AngularJS](#angularjs)

* [Руководство по Angular](https://metanit.com/web/angular2) - Евгений Попов
* [Русская версия документация Angular 10](https://angular24.ru) - Alexey Okhrimenko
* [Angular 5. Полное руководство](https://bxnotes.ru/conspect/angular-5-the-complete-guide/) - Maximilian Schwarzmüller


### Unix

* [Архитектура операционной системы Unix](http://lib.ru/BACH) - Maurice J. Bach, `trl.:` Крюкова А. В.
* [Введение в системное администрирование UNIX](http://lib.ru/unixhelp) - Мошков Максим Евгеньевич
* [Внутреннее устройство Ядра Linux 2.4](http://www.opennet.ru/docs/RUS/lki) - Tigran Aivazian
* [Перевод Linux kernel and C library.](http://man-pages-ru.sourceforge.net)
* [Программирование в Linux с нуля](http://www.opennet.ru/docs/RUS/zlp) - Nikolay N. Ivanov
* [Руководство программиста для Linux](http://www.opennet.ru/docs/RUS/Lpg) - Sven Goldt, Matt Welsh
* [Энциклопедия программиста Linux](http://www.opennet.ru/docs/RUS/lpg) - Алексей Паутов
* [Энциклопедия разработчика модулей ядра Linux](http://www.opennet.ru/docs/RUS/lkmpg) - Ori Pomerantz
* [Beyond Linux From Scratch (version 2011-12-30)](http://rus-linux.net/nlib.php?name=/MyLDP/BOOKS/BLFS-ru/blfs-ru-index.html) - The BLFS Development Team, `trl.:` Н.Ромоданов, `trl.:` Сергея Каминского, `trl.:` Александра Андреева
* [Linux From Scratch (version 6.8)](http://rus-linux.net/nlib.php?name=/MyLDP/BOOKS/LFS-BOOK-6.8-ru/lfs-6.8-ru-index.html)
* [The Linux Kernel Module Programming Guide](http://www.opennet.ru/docs/RUS/lkmpg26) - Peter Jay Salzman, Michael Burian, Ori Pomerantz
