﻿## 目录

* [语言无关](#语言无关)
    * [版本控制](#版本控制)
    * [编程艺术](#编程艺术)
    * [编译原理](#编译原理)
    * [操作系统](#操作系统)
    * [程序员杂谈](#程序员杂谈)
    * [大数据](#大数据)
    * [分布式系统](#分布式系统)
    * [管理和监控](#管理和监控)
    * [函数式概念](#函数式概念)
    * [计算机图形学](#计算机图形学)
    * [其它](#其它)
    * [人工智能](#人工智能)
    * [软件开发方法](#软件开发方法)
    * [设计模式](#设计模式)
    * [数据库](#数据库)
    * [项目相关](#项目相关)
    * [在线教育](#在线教育)
    * [正则表达式](#正则表达式)
    * [智能系统](#智能系统)
    * [IDE and editors](#ide-and-editors)
    * [Web](#web)
    * [WEB服务器](#web服务器)
* [语言相关](#语言相关)
    * [Android](#android)
    * [Assembly](#assembly)
    * [AWK](#awk)
    * [C](#c)
    * [C#](#csharp)
    * [C++](#cpp)
    * [CoffeeScript](#coffeescript)
    * [Dart](#dart)
    * [Elasticsearch](#elasticsearch)
    * [Elixir](#elixir)
    * [Erlang](#erlang)
    * [Fortran](#fortran)
    * [Golang](#golang)
    * [Haskell](#haskell)
    * [HTML and CSS](#html-and-css)
    * [HTTP](#http)
    * [iOS](#ios)
    * [Java](#java)
    * [JavaScript](#javascript)
        * [AngularJS](#angularjs)
        * [Backbone.js](#backbonejs)
        * [D3.js](#d3js)
        * [Electron.js](#electronjs)
        * [ExtJS](#extjs)
        * [jQuery](#jquery)
        * [Node.js](#nodejs)
        * [React.js](#reactjs)
        * [Vue.js](#vuejs)
        * [Zepto.js](#zeptojs)
    * [LaTeX](#latex)
    * [Lisp](#lisp)
    * [Lua](#lua)
    * [Markdown](#markdown)
    * [MySQL](#mysql)
    * [NoSQL](#nosql)
    * [Perl](#perl)
    * [PHP](#php)
        * [Laravel](#laravel)
        * [Symfony](#symfony)
        * [Yii](#yii)
    * [PostgreSQL](#postgresql)
    * [Python](#python)
        * [Django](#django)
    * [R](#r)
    * [reStructuredText](#restructuredtext)
    * [Ruby](#ruby)
    * [Rust](#rust)
    * [Scala](#scala)
    * [Scheme](#scheme)
    * [Scratch](#scratch)
    * [Shell](#shell)
    * [Swift](#swift)
    * [TypeScript](#typescript)
        * [Angular](#angular)
        * [Deno](#deno)
    * [VBA](#vba-microsoft-visual-basic-applications)
    * [Visual Prolog](#visual-prolog)


## 语言无关

### <a id="version-control-systems"></a><a id="git"></a><a id="svn"></a><a id="subversion"></a><a id="mercurial"></a>版本控制

* [沉浸式学 Git](https://web.archive.org/web/20191004044726/http://igit.linuxtoy.org:80/index.html) - Jim Weirich, `trl.:` 徐小东 a.k.a toy *( :card_file_box: archived)*
* [猴子都能懂的GIT入门](http://backlogtool.com/git-guide/cn/) - Nulab Inc.
* [Git - 简易指南](https://rogerdudler.github.io/git-guide/index.zh.html) - Roger Dudler, `trl.:` 罗杰·杜德勒 (HTML)
* [Git 参考手册](http://gitref.justjavac.com) - CHEN Yangjian
* [Git-Cheat-Sheet](https://github.com/flyhigher139/Git-Cheat-Sheet) - flyhigher139
* [git-flow 备忘清单](http://danielkummer.github.io/git-flow-cheatsheet/index.zh_CN.html) - Daniel Kummer, et al.
* [Git Magic](http://www-cs-students.stanford.edu/~blynn/gitmagic/intl/zh_cn/) - Ben Lynn, `trl.:` 俊杰, 萌和江薇, et al. (HTML)
* [Git教程](https://www.liaoxuefeng.com/wiki/896043488029600) - 廖雪峰
* [Github帮助文档](https://github.com/waylau/github-help) - Way Lau
* [GitHub秘籍](https://snowdream86.gitbooks.io/github-cheat-sheet/content/zh/) - snowdream86
* [Got GitHub](https://github.com/gotgit/gotgithub) - Jiang Xin, The GotGit community
* [GotGitHub](http://www.worldhello.net/gotgithub/index.html) - Jiang Xin, The GotGit community
* [HgInit (中文版)](https://zh-hginit.readthedocs.io/en/latest/) - The HgInit team, `trl.:` Brant Young
* [Mercurial 使用教程](https://www.mercurial-scm.org/wiki/ChineseTutorial) - The Mercurial team
* [Pro Git](https://git-scm.com/book/zh/) - Scott Chacon, Ben Straub, `trl.:` Alan Wang, `trl.:` 啊咪咪小熊, et al. (HTML, PDF, EPUB)
* [Pro Git 第二版 中文版](https://bingohuang.gitbooks.io/progit2/content) - Bingo Huang
* [Subversion 版本控制](http://svnbook.red-bean.com/nightly/zh/index.html) - Ben Collins-Sussman, Brian W. Fitzpatrick, C. Michael Pilato


### 编程艺术

* [编程入门指南](http://www.kancloud.cn/kancloud/intro-to-prog/52592)
* [程序员编程艺术](https://github.com/julycoding/The-Art-Of-Programming-by-July)
* [每个程序员都应该了解的内存知识 (第一部分)](http://www.oschina.net/translate/what-every-programmer-should-know-about-memory-part1)


### 编译原理

* [《计算机程序的结构和解释》公开课 翻译项目](https://github.com/DeathKing/Learning-SICP)


### 操作系统

* [开源世界旅行手册](http://i.linuxtoy.org/docs/guide/index.html)
* [理解Linux进程](https://github.com/tobegit3hub/understand_linux_process)
* [命令行的艺术](https://github.com/jlevy/the-art-of-command-line/blob/master/README-zh.md)
* [鸟哥的 Linux 私房菜 服务器架设篇](http://cn.linux.vbird.org/linux_server/)
* [鸟哥的 Linux 私房菜 基础学习篇](http://cn.linux.vbird.org/linux_basic/linux_basic.php)
* [嵌入式 Linux 知识库 (eLinux.org 中文版)](https://tinylab.gitbooks.io/elinux/content/zh/)
* [Docker — 从入门到实践](https://github.com/yeasy/docker_practice)
* [Docker 入门实战](http://yuedu.baidu.com/ebook/d817967416fc700abb68fca1)
* [Docker 中文指南](https://github.com/widuu/chinese_docker)
* [FreeBSD 从入门到跑路](https://book.bsdcn.org)
* [FreeBSD 使用手册](http://www.freebsd.org/doc/zh_CN.UTF-8/books/handbook/)
* [Linux 构建指南](http://works.jinbuguo.com/lfs/lfs62/index.html)
* [Linux 系统高级编程](http://sourceforge.net/projects/elpi/)
* [Linux Documentation (中文版)](https://tinylab.gitbooks.io/linux-doc/content/zh-cn/)
* [Linux Guide for Complete Beginners](http://happypeter.github.io/LGCB/book/)
* [Linux工具快速教程](https://github.com/me115/linuxtools_rst)
* [Mac 开发配置手册](https://aaaaaashu.gitbooks.io/mac-dev-setup/content/)
* [Operating Systems: Three Easy Pieces](http://pages.cs.wisc.edu/~remzi/OSTEP/)
* [The Linux Command Line](http://billie66.github.io/TLCL/index.html)
* [Ubuntu 参考手册](http://wiki.ubuntu.org.cn/UbuntuManual)
* [uCore Lab: Operating System Course in Tsinghua University](https://www.gitbook.com/book/objectkuan/ucore-docs/details)
* [UNIX TOOLBOX](https://web.archive.org/web/20210812021003/cb.vu/unixtoolbox_zh_CN.xhtml) *( :card_file_box: archived)*


### 程序员杂谈

* [程序员的自我修养](http://www.kancloud.cn/kancloud/a-programmer-prepares)


### 大数据

* [面向程序员的数据挖掘指南](http://dataminingguide.books.yourtion.com)
* [数据挖掘中经典的算法实现和详细的注释](https://github.com/linyiqun/DataMiningAlgorithm)
* [Spark 编程指南简体中文版](https://aiyanbo.gitbooks.io/spark-programming-guide-zh-cn/content/)


### 分布式系统

* [走向分布式](http://dcaoyuan.github.io/papers/pdfs/Scalability.pdf) (PDF)


### 管理和监控

* [ElasticSearch 权威指南](https://www.gitbook.com/book/fuxiaopang/learnelasticsearch/details)
* [Elasticsearch 权威指南（中文版）](https://web.archive.org/web/20200415002735/https://es.xiaoleilu.com/) *( :card_file_box: archived)*
* [ELKstack 中文指南](http://kibana.logstash.es)
* [Logstash 最佳实践](https://github.com/chenryn/logstash-best-practice-cn)
* [Mastering Elasticsearch(中文版)](http://udn.yyuap.com/doc/mastering-elasticsearch/)
* [Puppet 2.7 Cookbook 中文版](https://www.gitbook.com/book/wizardforcel/puppet-27-cookbook/details)


### 函数式概念

* [傻瓜函数编程](https://github.com/justinyhuang/Functional-Programming-For-The-Rest-of-Us-Cn)


### 计算机图形学

* [LearnOpenGL CN](https://learnopengl-cn.github.io)
* [OpenGL 教程](https://github.com/zilongshanren/opengl-tutorials)


### 其它

* [深入理解并行编程](http://ifeve.com/perfbook/)
* [SAN 管理入门系列](https://community.emc.com/docs/DOC-16067)
* [Sketch 中文手册](http://sketchcn.com/sketch-chinese-user-manual.html#introduce)


### 人工智能

* [动手实战人工智能](https://aibydoing.com) - huhuhang


### 软件开发方法

* [傻瓜函数编程](https://github.com/justinyhuang/Functional-Programming-For-The-Rest-of-Us-Cn) (《Functional Programming For The Rest of Us》中文版)
* [硝烟中的 Scrum 和 XP](http://www.infoq.com/cn/minibooks/scrum-xp-from-the-trenches)


### 设计模式

* [深入设计模式](https://refactoringguru.cn/design-patterns)
* [史上最全设计模式导学目录](http://blog.csdn.net/lovelion/article/details/17517213)
* [图说设计模式](https://github.com/me115/design_patterns)


### 数据库

<!-- Waiting to add in -->


### 项目相关

* [编码规范](https://github.com/ecomfe/spec)
* [开源软件架构](http://www.ituring.com.cn/book/1143)
* [让开发自动化系列专栏](https://wizardforcel.gitbooks.io/ibm-j-ap)
* [追求代码质量](https://wizardforcel.gitbooks.io/ibm-j-cq)
* [GNU make 指南](http://docs.huihoo.com/gnu/linux/gmake.html)
* [Gradle 2 用户指南](https://github.com/waylau/Gradle-2-User-Guide)
* [Gradle 中文使用文档](http://yuedu.baidu.com/ebook/f23af265998fcc22bcd10da2)
* [Joel谈软件](https://web.archive.org/web/20170616013024/http://local.joelonsoftware.com/wiki/Chinese_(Simplified))
* [selenium 中文文档](https://einverne.gitbook.io/selenium-doc/)


### 在线教育

* [51CTO学院](http://edu.51cto.com)
* [黑马程序员](http://yun.itheima.com)
* [汇智网](http://www.hubwiz.com)
* [极客学院](http://www.jikexueyuan.com)
* [计蒜客](http://www.jisuanke.com)
* [慕课网](http://www.imooc.com/course/list)
* [Codecademy](https://www.codecademy.com/?locale_code=zh)
* [CodeSchool](https://www.codeschool.com)
* [Coursera](https://www.coursera.org/courses?orderby=upcoming&lngs=zh)
* [Learn X in Y minutes](https://learnxinyminutes.com)
* [shiyanlou](https://www.shiyanlou.com)
* [TeamTreeHouse](https://teamtreehouse.com)
* [Udacity](https://www.udacity.com)
* [xuetangX](https://www.xuetangx.com)


### 正则表达式

* [正则表达式-菜鸟教程](http://www.runoob.com/regexp/regexp-tutorial.html)
* [正则表达式30分钟入门教程](https://web.archive.org/web/20161119141236/http://deerchao.net:80/tutorials/regex/regex.htm)


### 智能系统

* [一步步搭建物联网系统](https://github.com/phodal/designiot)


### IDE and editors

* [大家來學 VIM](http://www.study-area.org/tips/vim/index.html) - Edward Lee
* [所需即所获：像 IDE 一样使用 vim](https://github.com/yangyangwithgnu/use_vim_as_ide) - yangyangwithgnu
* [exvim--vim 改良成IDE项目](http://exvim.github.io/docs-zh/intro/)
* [IntelliJ IDEA 简体中文专题教程](https://github.com/judasn/IntelliJ-IDEA-Tutorial) - Judas.n
* [Vim中文文档](https://github.com/vimcn/vimcdoc) - Vim 中文计划, Yian Willis


### Web

* [浏览器开发工具的秘密](http://jinlong.github.io/2013/08/29/devtoolsecrets/)
* [前端代码规范 及 最佳实践](http://coderlmn.github.io/code-standards/)
* [前端开发体系建设日记](https://github.com/fouber/blog/issues/2)
* [前端资源分享（二）](https://github.com/hacke2/hacke2.github.io/issues/3)
* [前端资源分享（一）](https://github.com/hacke2/hacke2.github.io/issues/1)
* [移动前端开发收藏夹](https://github.com/hoosin/mobile-web-favorites)
* [移动Web前端知识库](https://github.com/AlloyTeam/Mars)
* [正则表达式30分钟入门教程](http://deerchao.net/tutorials/regex/regex.htm)
* [Chrome 开发者工具中文手册](https://github.com/CN-Chrome-DevTools/CN-Chrome-DevTools)
* [Chrome扩展及应用开发](http://www.ituring.com.cn/minibook/950)
* [Chrome扩展开发文档](http://open.chrome.360.cn/extension_dev/overview.html)
* [Growth: 全栈增长工程师指南](https://github.com/phodal/growth-ebook)
* [Grunt中文文档](http://www.gruntjs.net)
* [Gulp 入门指南](https://github.com/nimojs/gulp-book)
* [gulp中文文档](http://www.gulpjs.com.cn/docs/)
* [HTTP 接口设计指北](https://github.com/bolasblack/http-api-guide)
* [JSON风格指南](https://github.com/darcyliu/google-styleguide/blob/master/JSONStyleGuide.md)
* [Wireshark用户手册](https://web.archive.org/web/20200415002730/http://man.lupaworld.com/content/network/wireshark/index.html)


### WEB服务器

* [Apache 中文手册](http://works.jinbuguo.com/apache/menu22/index.html)
* [Nginx教程从入门到精通](http://www.ttlsa.com/nginx/nginx-stu-pdf/) - 运维生存时间 (PDF)
* [Nginx开发从入门到精通](http://tengine.taobao.org/book/index.html) - 淘宝团队


## 语言相关

### Android

* [Android Note(开发过程中积累的知识点)](https://github.com/CharonChui/AndroidNote)
* [Android开发技术前线(android-tech-frontier)](https://github.com/bboyfeiyu/android-tech-frontier)
* [Google Material Design 正體中文版](https://wcc723.gitbooks.io/google_design_translate/content/style-icons.html) - Tillonter, 陳世能, Sean Chen, et al.
* [Google Material Design 中文协同翻译](https://github.com/1sters/material_design_zh) - 1sters 极客实验室, 四勾 4J, IceskYsl, et al.
* [Point-of-Android](https://github.com/FX-Max/Point-of-Android)


### Assembly

* 逆向工程权威指南 《Reverse Engineering for Beginners》 - Dennis Yurichev, Antiy Labs, Archer
    * [逆向工程权威指南 《Reverse Engineering for Beginners》 Vol.1](https://beginners.re/RE4B-CN-vol1.pdf) - Dennis Yurichev, Antiy Labs, Archer (PDF)
    * [逆向工程权威指南 《Reverse Engineering for Beginners》 Vol.2](https://beginners.re/RE4B-CN-vol2.pdf) - Dennis Yurichev, Antiy Labs, Archer (PDF)
* [C/C++面向WebAssembly编程](https://github.com/3dgen/cppwasm-book/tree/master/zh) - Ending, Chai Shushan (HTML, [:package: examples](https://github.com/3dgen/cppwasm-book/tree/master/examples))


### AWK

* [awk程序设计语言](https://github.com/wuzhouhui/awk)
* [awk中文指南](http://awk.readthedocs.org/en/latest/index.html)


### C

* [新概念 C 语言教程](https://github.com/limingth/NCCL)
* [Beej's Guide to Network Programming 簡體中文版](https://beej-zhtw-gitbook.netdpi.net) - Brian "Beej Jorgensen" Hall, 廖亚伦译
* [C 语言常见问题集](http://c-faq-chn.sourceforge.net/ccfaq/ccfaq.html)
* [C 语言教程](https://wangdoc.com/clang/)
* [C 语言入门教程](https://www.dotcpp.com/course/c/)
* [Linux C 编程一站式学习](https://web.archive.org/web/20210514225440/http://docs.linuxtone.org/ebooks/C&CPP/c/) *( :card_file_box: archived)*


### <a id="csharp"></a>C\#

* [精通C#(第6版)](http://book.douban.com/subject/24827879/)


### <a id="cpp"></a>C++

* [100个gcc小技巧](https://github.com/hellogcc/100-gcc-tips/blob/master/src/index.md)
* [100个gdb小技巧](https://github.com/hellogcc/100-gdb-tips/blob/master/src/index.md)
* [简单易懂的C魔法](https://web.archive.org/web/20210413213859/http://www.nowamagic.net/librarys/books/contents/c) *( :card_file_box: archived)*
* [現代 C++ 101](https://hackmd.io/@lumynou5/CppTutorial-zh-tw) - Lumynous ( :construction: *in process*)
* [像计算机科学家一样思考（C++版)](http://www.ituring.com.cn/book/1203) (《How To Think Like a Computer Scientist: C++ Version》中文版)
* [C 语言编程透视](https://tinylab.gitbooks.io/cbook/content/)
* [C/C++ Primer](https://github.com/andycai/cprimer) - andycai
* [C++ 并发编程指南](https://github.com/forhappy/Cplusplus-Concurrency-In-Practice)
* [C++ FAQ LITE(中文版)](http://www.sunistudio.com/cppfaq/)
* [C++ Primer 5th Answers](https://github.com/Mooophy/Cpp-Primer)
* [C++ Template 进阶指南](https://github.com/wuye9036/CppTemplateTutorial)
* [CGDB中文手册](https://github.com/leeyiw/cgdb-manual-in-chinese)
* [Cmake 实践](https://web.archive.org/web/20170615174144/http://sewm.pku.edu.cn/src/paradise/reference/CMake%20Practice.pdf) (PDF)
* [GNU make 指南](http://docs.huihoo.com/gnu/linux/gmake.html)
* [Google C++ 风格指南](http://zh-google-styleguide.readthedocs.org/en/latest/google-cpp-styleguide/contents/)
* [ZMQ 指南](https://github.com/anjuke/zguide-cn)


### CoffeeScript

* [CoffeeScript 编程风格指南](https://github.com/elrrrrrrr/coffeescript-style-guide/blob/master/README-ZH.md)
* [CoffeeScript 编码风格指南](https://github.com/geekplux/coffeescript-style-guide)
* [CoffeeScript 中文](http://coffee-script.org)


### Dart

* [Dart 语言导览](https://web.archive.org/web/20200415002731/dart.lidian.info/wiki/Language_Tour) *( :card_file_box: archived)*


### Elasticsearch

* [Elasticsearch 权威指南](https://github.com/looly/elasticsearch-definitive-guide-cn) （《Elasticsearch the definitive guide》中文版）
* [Mastering Elasticsearch(中文版)](http://udn.yyuap.com/doc/mastering-elasticsearch/)


### Elixir

* [Elixir 编程语言教程](https://elixirschool.com/zh-hans) (Elixir School)
* [Elixir Getting Started 中文翻译](https://github.com/Ljzn/ElixrGettingStartedChinese)
* [Elixir元编程与DSL 中文翻译](https://github.com/Ljzn/MetaProgrammingInElixirChinese)
* [Phoenix 框架中文文档](https://mydearxym.gitbooks.io/phoenix-doc-in-chinese/content/)


### Erlang

* [Erlang 并发编程](https://github.com/liancheng/cpie-cn) (《Concurrent Programming in Erlang (Part I)》中文版)


### Fortran

* [Fortran77和90/95编程入门](http://micro.ustc.edu.cn/Fortran/ZJDing/)


### Golang

* [深入解析 Go](https://tiancaiamao.gitbooks.io/go-internals/content/zh) - tiancaiamao
* [学习Go语言](http://mikespook.com/learning-go/)
* [Go 编程基础](https://github.com/Unknwon/go-fundamental-programming)
* [Go 官方文档翻译](https://github.com/golang-china/golangdoc.translations)
* [Go 简易教程](https://github.com/songleo/the-little-go-book_ZH_CN) - Karl Seguin, `trl.:` Song Song Li (《[The Little Go Book](https://github.com/karlseguin/the-little-go-book) - Karl Seguin》中文版)
* [Go 命令教程](https://github.com/hyper-carrot/go_command_tutorial)
* [Go 入门指南](https://github.com/Unknwon/the-way-to-go_ZH_CN) (《The Way to Go》中文版)
* [Go 语法树入门](https://github.com/chai2010/go-ast-book)
* [Go 语言标准库](https://github.com/polaris1119/The-Golang-Standard-Library-by-Example)
* [Go 语言高级编程（Advanced Go Programming）](https://github.com/chai2010/advanced-go-programming-book)
* [Go 语言设计与实现](https://draveness.me/golang) - draveness
* [Go 语言实战笔记](https://github.com/rujews/go-in-action-notes)
* [Go 指南](https://tour.go-zh.org/list) (《A Tour of Go》中文版)
* [Go Web 编程](https://astaxie.gitbooks.io/build-web-application-with-golang/content/zh/) - astaxie
* [Go实战开发](https://github.com/astaxie/go-best-practice)
* [Go语言博客实践](https://github.com/achun/Go-Blog-In-Action)
* [Java程序员的Golang入门指南](http://blog.csdn.net/dc_726/article/details/46565241)
* [Network programming with Go 中文翻译版本](https://github.com/astaxie/NPWG_zh)
* [Revel 框架手册](https://web.archive.org/web/20190610030938/https://gorevel.cn/docs/manual/index.html) *( :card_file_box: archived)*
* [The Little Go Book 繁體中文翻譯版](https://github.com/kevingo/the-little-go-book) - Karl Seguin, `trl.:` KevinGo, Jie Peng ([HTML](https://kevingo.gitbooks.io/the-little-go-book/))


### Groovy

* [Groovy 教程](https://www.w3cschool.cn/groovy) - W3Cschool


### Haskell

* [Haskell 趣学指南](https://learnyouahaskell.mno2.org)
* [Real World Haskell 中文版](http://cnhaskell.com)


### HTML and CSS

* [前端代码规范](http://alloyteam.github.io/CodeGuide/) - 腾讯AlloyTeam团队
* [通用 CSS 笔记、建议与指导](https://github.com/chadluo/CSS-Guidelines/blob/master/README.md)
* [学习CSS布局](http://zh.learnlayout.com)
* [Bootstrap 4 繁體中文手冊](https://bootstrap.hexschool.com) - 六角學院
* [Bootstrap 5 繁體中文手冊](https://bootstrap5.hexschool.com) - 六角學院
* [CSS3 Tutorial 《CSS3 教程》](https://github.com/waylau/css3-tutorial)
* [CSS参考手册](http://css.doyoe.com)
* [Emmet 文档](http://yanxyz.github.io/emmet-docs/)
* [HTML5 教程](http://www.w3school.com.cn/html5/index.asp)
* [HTML和CSS编码规范](http://codeguide.bootcss.com)
* [Sass Guidelines 中文](http://sass-guidelin.es/zh/)


### iOS

* [网易斯坦福大学公开课：iOS 7应用开发字幕文件](https://github.com/jkyin/Subtitle)
* [Apple Watch开发初探](http://nilsun.github.io/apple-watch/)
* [Google Objective-C Style Guide 中文版](http://zh-google-styleguide.readthedocs.org/en/latest/google-objc-styleguide/)
* [iOS开发60分钟入门](https://github.com/qinjx/30min_guides/blob/master/ios.md)
* [iPhone 6 屏幕揭秘](http://wileam.com/iphone-6-screen-cn/)


### Java

* [阿里巴巴 Java 开发手册](https://raw.githubusercontent.com/alibaba/p3c/HEAD/Java%E5%BC%80%E5%8F%91%E6%89%8B%E5%86%8C(%E9%BB%84%E5%B1%B1%E7%89%88).pdf) (PDF)
* [用jersey构建REST服务](https://github.com/waylau/RestDemo)
* [Activiti 5.x 用户指南](https://github.com/waylau/activiti-5.x-user-guide)
* [Apache MINA 2 用户指南](https://github.com/waylau/apache-mina-2.x-user-guide)
* [Apache Shiro 用户指南](https://github.com/waylau/apache-shiro-1.2.x-reference)
* [Google Java编程风格指南](http://hawstein.com/2014/01/20/google-java-style/)
* [H2 Database 教程](https://github.com/waylau/h2-database-doc)
* [Java 编程思想](https://java.quanke.name) - quanke
* [Java 编码规范](https://github.com/waylau/java-code-conventions)
* [Java 教程 - 廖雪峰的官方网站](https://www.liaoxuefeng.com/wiki/1252599548343744)
* [Java Servlet 3.1 规范](https://github.com/waylau/servlet-3.1-specification)
* [Jersey 2.x 用户指南](https://github.com/waylau/Jersey-2.x-User-Guide)
* [JSSE 参考指南](https://github.com/waylau/jsse-reference-guide)
* [MyBatis中文文档](http://mybatis.github.io/mybatis-3/zh/index.html)
* [Netty 4.x 用户指南](https://github.com/waylau/netty-4-user-guide)
* [Netty 实战(精髓)](https://github.com/waylau/essential-netty-in-action)
* [Nutz-book Nutz烹调向导](http://nutzbook.wendal.net)
* [Nutz文档](https://nutzam.com/core/nutz_preface.html)
* [REST 实战](https://github.com/waylau/rest-in-action)
* [Spring 2.0核心技术与最佳实践](https://michaelliao.github.io/download/pdf/Spring%202.0%E6%A0%B8%E5%BF%83%E6%8A%80%E6%9C%AF%E4%B8%8E%E6%9C%80%E4%BD%B3%E5%AE%9E%E8%B7%B5.pdf) (PDF)
* [Spring Boot参考指南](https://github.com/qibaoguang/Spring-Boot-Reference-Guide) ( :construction: *翻译中*)
* [Spring Framework 4.x参考文档](https://github.com/waylau/spring-framework-4-reference)


### JavaScript

* [命名函数表达式探秘](http://justjavac.com/named-function-expressions-demystified.html) - kangax、为之漫笔(翻译) (原始地址无法打开，所以此处地址为justjavac博客上的备份)
* [你不知道的JavaScript](https://github.com/getify/You-Dont-Know-JS/tree/1ed-zh-CN)
* [现代 JavaScript 教程](https://zh.javascript.info) - Ilya Kantor
* [学用 JavaScript 设计模式](http://www.oschina.net/translate/learning-javascript-design-patterns) - 开源中国
* [Airbnb JavaScript 规范](https://github.com/adamlu/javascript-style-guide)
* [ECMAScript 6 入门](http://es6.ruanyifeng.com) - 阮一峰
* [Google JavaScript 代码风格指南](https://web.archive.org/web/20200415002735/bq69.com/blog/articles/script/868/google-javascript-style-guide.html) *( :card_file_box: archived)*
* [JavaScript 标准参考教程（alpha）](http://javascript.ruanyifeng.com)
* [javascript 的 12 个怪癖](https://github.com/justjavac/12-javascript-quirks)
* [JavaScript 教程 - 廖雪峰的官方网站](https://www.liaoxuefeng.com/wiki/1022910821149312)
* [《JavaScript 模式》](https://github.com/jayli/javascript-patterns) (《JavaScript patterns》译本)
* [JavaScript 原理](https://web.archive.org/web/20170112164945/http://typeof.net/s/jsmech/)
* [JavaScript Promise迷你书](http://liubin.github.io/promises-book/)


#### AngularJS

> :information_source: See also &#8230; [Angular](#angular)

* [构建自己的AngularJS](https://github.com/xufei/Make-Your-Own-AngularJS/blob/master/01.md) - Xu Fei (HTML)
* [在Windows环境下用Yeoman构建AngularJS项目](http://www.waylau.com/build-angularjs-app-with-yeoman-in-windows/) - Way Lau (HTML)
* [AngularJS入门教程](https://github.com/zensh/AngularjsTutorial_cn) - Yan Qing, Hou Zhenyu, 速冻沙漠 (HTML) ( :card_file_box: *archived*)
* [AngularJS最佳实践和风格指南](https://github.com/mgechev/angularjs-style-guide/blob/master/README-zh-cn.md) - Minko Gechev, Xuefeng Zhu, Shintaro Kaneko, et al. (HTML)


#### Backbone.js

* [Backbone.js入门教程](http://www.the5fire.com/backbone-js-tutorials-pdf-download.html) (PDF)
* [Backbone.js入门教程第二版](https://github.com/the5fire/backbonejs-learning-note)
* [Backbone.js中文文档](https://web.archive.org/web/20200916085144/https://www.html.cn/doc/backbone/) *( :card_file_box: archived)*


#### D3.js

* [楚狂人的D3教程](http://www.cnblogs.com/winleisure/tag/D3.js/)
* [官方API文档](https://github.com/mbostock/d3/wiki/API--%E4%B8%AD%E6%96%87%E6%89%8B%E5%86%8C)
* [Learning D3.JS](http://d3.decembercafe.org) - 十二月咖啡馆


#### Electron.js

* [Electron 中文文档](https://wizardforcel.gitbooks.io/electron-doc/content) - WizardForcel
* [Electron 中文文档](https://www.w3cschool.cn/electronmanual) - W3Cschool


#### ExtJS

* [Ext4.1.0 中文文档](http://extjs-doc-cn.github.io/ext4api/)


#### jQuery

* [简单易懂的JQuery魔法](https://web.archive.org/web/20201127045453/http://www.nowamagic.net/librarys/books/contents/jquery) *( :card_file_box: archived)*
* [How to write jQuery plugin](http://i5ting.github.io/How-to-write-jQuery-plugin/build/jquery.plugin.html)


#### Node.js

* [七天学会NodeJS](http://nqdeng.github.io/7-days-nodejs/) - 阿里团队
* [使用 Express + MongoDB 搭建多人博客](https://github.com/nswbmw/N-blog)
* [express.js 中文文档](http://expressjs.jser.us)
* [Express框架](http://javascript.ruanyifeng.com/nodejs/express.html)
* [koa 中文文档](https://github.com/guo-yu/koa-guide)
* [Learn You The Node.js For Much Win! (中文版)](https://www.npmjs.com/package/learnyounode-zh-cn)
* [Node debug 三法三例](http://i5ting.github.io/node-debug-tutorial/)
* [Node.js 包教不包会](https://github.com/alsotang/node-lessons)
* [Node.js Fullstack《從零到一的進撃》](https://github.com/jollen/nodejs-fullstack-lessons)
* [Node入门](http://www.nodebeginner.org/index-zh-cn.html)
* [Nodejs Wiki Book](https://github.com/nodejs-tw/nodejs-wiki-book) (繁体中文)
* [nodejs中文文档](https://www.gitbook.com/book/0532/nodejs/details)
* [The NodeJS 中文文档](https://www.gitbook.com/book/0532/nodejs/details) - 社区翻译


#### React.js

* [Learn React & Webpack by building the Hacker News front page](https://github.com/theJian/build-a-hn-front-page)
* [React-Bits 中文文档](https://github.com/hateonion/react-bits-CN)
* [React webpack-cookbook](https://github.com/fakefish/react-webpack-cookbook)
* [React.js 入门教程](http://fraserxu.me/intro-to-react/)
* [React.js 中文文档](https://discountry.github.io/react/)


#### Vue.js

* [Vue3.0学习教程与实战案例](https://vue3.chengpeiquan.com) - chengpeiquan


#### Zepto.js

* [Zepto.js 中文文档](https://web.archive.org/web/20210303025214/https://www.css88.com/doc/zeptojs_api/) *( :card_file_box: archived)*


### LaTeX

* [大家來學 LaTeX](https://github.com/49951331/graduate-project-102pj/blob/master/docs/latex123.pdf) (PDF)
* [一份不太简短的 LaTeX2ε 介绍](http://ctan.org/pkg/lshort-zh-cn)


### Lisp

* [ANSI Common Lisp 中文翻译版](http://acl.readthedocs.org/en/latest/)
* [Common Lisp 高级编程技术](http://www.ituring.com.cn/minibook/862) (《On Lisp》中文版)


### Lua

* [Lua 5.3 参考手册](https://www.runoob.com/manual/lua53doc/)


### Markdown

* [献给写作者的 Markdown 新手指南](http://www.jianshu.com/p/q81RER)
* [Markdown 語法說明](https://markdown.tw)


### MySQL

* [21分钟MySQL入门教程](http://www.cnblogs.com/mr-wid/archive/2013/05/09/3068229.html)
* [MySQL索引背后的数据结构及算法原理](http://blog.codinglabs.org/articles/theory-of-mysql-index.html)


### NoSQL

* [带有详细注释的 Redis 2.6 代码](https://github.com/huangz1990/annotated_redis_source)
* [带有详细注释的 Redis 3.0 代码](https://github.com/huangz1990/redis-3.0-annotated)
* [Disque 使用教程](http://disque.huangz.me)
* [Redis 命令参考](http://redisdoc.com)
* [Redis 设计与实现](http://redisbook.com)
* [The Little MongoDB Book](https://github.com/justinyhuang/the-little-mongodb-book-cn/blob/master/mongodb.md)
* [The Little Redis Book](https://github.com/JasonLai256/the-little-redis-book/blob/master/cn/redis.md)


### Perl

* [Master Perl Today](https://github.com/fayland/chinese-perl-book)
* [Perl 5 教程](https://web.archive.org/web/20150326073235/http://net.pku.edu.cn/~yhf/tutorial/perl/perl.html)
* [Perl 教程](http://www.yiibai.com/perl)


### PHP

* [CodeIgniter 使用手冊](https://web.archive.org/web/20210624143822/https://codeigniter.org.tw/userguide3/) *( :card_file_box: archived)*
* [Composer中文文档](http://docs.phpcomposer.com)
* [Phalcon7中文文档](https://web.archive.org/web/20220330065727/myleftstudio.com/) *( :card_file_box: archived)*
* [PHP 之道](http://wulijun.github.io/php-the-right-way/)
* [PHP标准规范中文版](https://psr.phphub.org)
* [PHP中文手册](http://php.net/manual/zh/)
* [Yii2中文文档](http://www.yiichina.com/doc/guide/2.0)


#### Laravel

* [Laravel 5.4 中文文档](http://d.laravel-china.org/docs/5.4)
* [Laravel 6 中文文档](https://learnku.com/docs/laravel/6.x)
* [Laravel 7 中文文档](https://learnku.com/docs/laravel/7.x)
* [Laravel 8 中文文档](https://learnku.com/docs/laravel/8.x)
* [Laravel 9 中文文档](https://learnku.com/docs/laravel/9.x)
* [Laravel 入门到精通教程](https://laravelacademy.org/books/laravel-tutorial)


#### Symfony

* [Symfony 2 实例教程](https://wusuopu.gitbooks.io/symfony2_tutorial/content)
* [Symfony 5 快速开发](https://web.archive.org/web/20210812222957/symfony.com/doc/current/the-fast-track/zh_CN/index.html) *( :card_file_box: archived)*


#### Yii

* [Yii 2.0 权威指南](https://www.yiiframework.com/doc/download/yii-guide-2.0-zh-cn.pdf) - Yii Software (PDF)


### PostgreSQL

* [PostgreSQL 8.2.3 中文文档](http://works.jinbuguo.com/postgresql/menu823/index.html)
* [PostgreSQL 9.3.1 中文文档](http://www.postgres.cn/docs/9.3/index.html)
* [PostgreSQL 9.4.4 中文文档](http://www.postgres.cn/docs/9.4/index.html)
* [PostgreSQL 9.5.3 中文文档](http://www.postgres.cn/docs/9.5/index.html)
* [PostgreSQL 9.6.0 中文文档](http://www.postgres.cn/docs/9.6/index.html)


### Python

* [简明 Python 教程](https://web.archive.org/web/20200822010330/https://bop.mol.uno/) - Swaroop C H、沈洁元(翻译)、漠伦(翻译) *( :card_file_box: archived)*
* [人生苦短，我用python](https://www.cnblogs.com/derek1184405959/p/8579428.html) - zhang_derek *(内含丰富的笔记以及各类教程)*
* [深入 Python 3](https://github.com/jiechic/diveintopython3)
* [Matplotlib 3.0.3 中文文档](http://www.osgeo.cn/matplotlib/) (Online)
* [Numpy 1.16 中文文档](http://www.osgeo.cn/numpy/) (Online)
* [Python 3 文档(简体中文) 3.2.2 documentation](http://docspy3zh.readthedocs.org/en/latest/)
* [Python 3.8.0a3中文文档](http://www.osgeo.cn/cpython/) (Online) *(目前在线最全的中文文档了)*
* [Python 最佳实践指南](https://pythonguidecn.readthedocs.io/zh/latest/)
* [Python Cookbook第三版](http://python3-cookbook.readthedocs.io/zh_CN/latest/) - David Beazley、Brian K.Jones、熊能(翻译)
* [Python教程 - 廖雪峰的官方网站](https://www.liaoxuefeng.com/wiki/1016959663602400)
* [Python进阶](https://interpy.eastlakeside.com) - eastlakeside
* [Python之旅](https://web.archive.org/web/20191217091745/http://funhacks.net/explore-python/) - Ethan *( :card_file_box: archived)*
* [Tornado 6.1 中文文档](http://www.osgeo.cn/tornado/) (Online) *(网络上其他的都是较旧版本的)*


#### Django

* [Django 1.11.6 中文文档](https://www.yiyibooks.cn/xx/Django_1.11.6/index.html)
* [Django 2.2.1 中文文档](http://www.osgeo.cn/django/) (Online) *(这个很新，也很全)*
* [Django 搭建个人博客教程 (2.1)](https://www.dusaiphoto.com/article/detail/2) - 杜赛 (HTML)
* [Django book 2.0](http://djangobook.py3k.cn/2.0/)
* [Django Girls 教程 (1.11)](https://tutorial.djangogirls.org/zh/) (HTML)


### R

* [153分钟学会 R](http://cran.r-project.org/doc/contrib/Liu-FAQ.pdf) (PDF)
* [统计学与 R 读书笔记](http://cran.r-project.org/doc/contrib/Xu-Statistics_and_R.pdf) (PDF)
* [用 R 构建 Shiny 应用程序](https://web.archive.org/web/20200220023703/yanping.me/shiny-tutorial/) (《Building 'Shiny' Applications with R》中文版) *( :card_file_box: archived)*
* [R 导论](http://cran.r-project.org/doc/contrib/Ding-R-intro_cn.pdf) (《An Introduction to R》中文版) (PDF)


### reStructuredText

* [reStructuredText 入门](http://www.pythondoc.com/sphinx/rest.html)


### Ruby

* [笨方法学 Ruby](http://lrthw.github.io)
* [Rails 风格指南](https://github.com/JuanitoFatas/rails-style-guide/blob/master/README-zhCN.md)
* [Ruby 风格指南](https://github.com/JuanitoFatas/ruby-style-guide/blob/master/README-zhCN.md)
* [Ruby on Rails 实战圣经](https://ihower.tw/rails4/)
* [Ruby on Rails 指南](https://ruby-china.github.io/rails-guides/)
* [Sinatra](http://www.sinatrarb.com/intro-zh.html)


### Rust

* [通过例子学习 Rust](https://github.com/rustcc/rust-by-example/)
* [Rust 官方教程](https://github.com/KaiserY/rust-book-chinese)
* [Rust 宏小册](https://zjp-cn.github.io/tlborm/)
* [Rust 语言圣经](https://course.rs)
* [Rust 语言学习笔记](https://github.com/photino/rust-notes)
* [RustPrimer](https://github.com/rustcc/RustPrimer)
* [Tour of Rust](https://tourofrust.com/00_zh-cn.html)


### Scala

* [Effective Scala](http://twitter.github.io/effectivescala/index-cn.html)
* [Scala 课堂](http://twitter.github.io/scala_school/zh_cn/index.html) (Twitter的Scala中文教程)


### Scheme

* [Scheme 入门教程](http://deathking.github.io/yast-cn/) (《Yet Another Scheme Tutorial》中文版)


### Scratch

* [创意计算课程指南](http://cccgchinese.strikingly.com)


### Shell

* [Shell 编程范例](https://tinylab.gitbooks.io/shellbook/content) - 泰晓科技
* [Shell 编程基础](http://wiki.ubuntu.org.cn/Shell%E7%BC%96%E7%A8%8B%E5%9F%BA%E7%A1%80)
* [Shell 脚本编程30分钟入门](https://github.com/qinjx/30min_guides/blob/master/shell.md)
* [shell-book](http://me.52fhy.com/shell-book/)
* [The Linux Command Line 中文版](http://billie66.github.io/TLCL/book/)


### Swift

* [《The Swift Programming Language》中文版](https://www.gitbook.com/book/numbbbbb/-the-swift-programming-language-/details)


### TypeScript

* [TypeScript 教程](https://www.runoob.com/typescript/ts-tutorial.html) - runoob (HTML)
* [TypeScript 入门教程](https://www.runoob.com/w3cnote/getting-started-with-typescript.html) - runoob (HTML)
* [TypeScript 中文网](https://www.tslang.cn) (HTML)
* [TypeScript Deep Dive 中文版](https://github.com/jkchao/typescript-book-chinese) - 三毛 (HTML)
* [TypeScript Handbook（中文版）](https://www.runoob.com/manual/gitbook/TypeScript/_book/) - Patrick Zhong (HTML)


#### Angular

> :information_source: See also &#8230; [AngularJS](#angularjs)

* [Angular 文档简介](https://angular.cn/docs) - Wang Zhicheng, Ye Zhimin, Yang Lin et al. (HTML)
* [Angular Material 组件库](https://material.angular.cn) - Wang Zhicheng, Ye Zhimin, Yang Lin, et al. (HTML)
* [Angular Tutorial (教程：英雄之旅)](https://angular.cn/tutorial) - Wang Zhicheng, Ye Zhimin, Yang Lin, et al. (HTML)


#### Deno

* [Deno 钻研之术](https://deno-tutorial.js.org)
* [Deno进阶开发笔记](https://chenshenhai.com/deno_note) - 大深海


### VBA (Microsoft Visual Basic Applications)

* [简明Excel VBA](https://github.com/Youchien/concise-excel-vba)


### Visual Prolog

* [Visual Prolog 7边练边学](http://wiki.visual-prolog.com/index.php?title=Visual_Prolog_for_Tyros_in_Chinese)
* [Visual Prolog 7初学指南](http://wiki.visual-prolog.com/index.php?title=A_Beginners_Guide_to_Visual_Prolog_in_Chinese)
