*[Διαβάστε το σε διαφορετικές γλώσσες](README.md#translations)*


<!----><a id="contributor-license-agreement"></a>
## Συμφωνία Άδειας Χρήσης Συνεισφερόντων

Συνεισφέροντας συμφωνείτε με την [ΑΔΕΙΑ](../LICENSE) αυτού του αποθετηρίου.


<!----><a id="contributor-code-of-conduct"></a>
## Κώδικας Δεοντολογίας Συνεισφερόντων

Συνεισφέροντας συμφωνείτε να σέβεστε τον [Κώδικα Δεοντολογίας](CODE_OF_CONDUCT-el.md) αυτού του αποθετηρίου. ([translations](README.md#translations))


<!----><a id="in-a-nutshell"></a>
## Με λίγα λόγια

1. "Ένας σύνδεσμος για να κατεβάσω εύκολα ένα βιβλίο" δεν είναι πάντα ένας σύνδεσμος για *δωρεάν* βιβλίο. Παρακαλούμε να συνεισφέρετε μόνο δωρεάν περιεχόμενο. Να σιγουρεύετε ότι είναι δωρεάν. Δεν δεχόμαστε συνδέσμους για σελίδες που *απαιτούν* λειτουργικές ηλεκτρονικές διευθύνσεις για να αποκτηθούν βιβλία, αλλά είναι ευπρόσδεκτες καταχωρήσεις που τις ζητούν προαιρετικά.

2. Δεν χρειάζεται να γνωρίζετε Git: αν βρήκατε κάτι ενδιαφέρον που *δεν βρίσκεται ήδη σε αυτό το αποθετήριο*, παρακαλώ ανοίξτε ένα [Issue](https://github.com/EbookFoundation/free-programming-books/issues) με τις προτάσεις σας για συνδέσμους.
    - Αν γνωρίζετε Git, παρακαλούμε να κάνετε Fork αυτό το αποθετήριο και να στέλνετε Pull Requests (PR).

3. Έχουμε 6 τύπους λιστών. Επιλέξτε την κατάλληλη:

    - *Βιβλία* : PDF, HTML, ePub, ένας ιστότοπος που βασίζεται στο gitbook.io, ένα αποθετήριο Git, κλπ.
    - *Μαθήματα* : Ένα μάθημα είναι εκπαιδευτικό υλικό που δεν είναι βιβλίο. [Αυτό είναι ένα μάθημα](http://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-006-introduction-to-algorithms-fall-2011/).
    - *Διαδραστικά σεμινάρια* : Μια διαδραστική ιστοσελίδα που επιτρέπει στον χρήστη να γράψει κώδικα ή εντολές και αξιολογεί τα αποτελέσματα (με το "αξιολογεί" δεν εννοούμε "βαθμολογεί"). π.χ. [Try Haskell](http://tryhaskell.org), [Try GitHub](http://try.github.io).
    - *Playgrounds* : are online and interactive websites, games or desktop software for learning programming. Write, compile (or run), and share code snippets. Playgrounds often allow you to fork and get your hands dirty by playing with code.
    - *Podcasts και Screencasts*: Podcasts και screencasts.
    - *Προβλήματα και Ανταγωνιστικός Προγραμματισμός*: Ένας ιστότοπος ή ένα λογισμικό που σου επιτρέπει να αξιολογήσεις τις προγραμματιστικές σου ικανότητες λύνοντας απλά ή περίπλοκα προβλήματα, με ή χωρίς επιθεώρηση του κώδικα, συγκρίνοντας ή όχι τα αποτελέσματα με άλλους χρήστες.

4. Σιγουρευτείτε ότι ακολουθείτε τις [παρακάτω κατευθυντήριες γραμμές](#guidelines) και σέβεστε τη [μορφοποίηση Markdown](#formatting) των αρχείων.

5. Το GitHub Actions τρέχει δοκιμές για να ελέγξει ότι **οι λίστες σας είναι σε αλφαβητική σειρά** και **τηρούνται οι κανόνες μορφοποίησης**. **Να θυμάστε να** ελέγχετε ότι οι αλλαγές σας περνούν τις δοκιμές.


<!----><a id="guidelines"></a>
### Κατευθυντήριες Γραμμές

- σιγουρευτείτε ότι το βιβλίο είναι δωρεάν. Επανελέγξτε αν χρειάζεται. Βοηθάει τους διαχειριστές αν σχολιάζετε στο PR τον λόγο που πιστεύετε ότι αυτό το βιβλίο είναι δωρεάν.
- δεν δεχόμαστε αρχεία που φιλοξενούνται στα Google Drive, Dropbox, Mega, Scribd, Issuu και άλλες παρόμοιες πλατφόρμες ανεβάσματος αρχείων
- εισάγετε τους συνδέσμους σας σε αλφαβητική σειρά, as described [below](#alphabetical-order).
- χρησιμοποιήστε έναν σύνδεσμο με την πιο έγκυρη πηγή (που σημαίνει ότι η ιστοσελίδα του συγγραφέα είναι καλύτερη από τη σελίδα του εκδότη, η οποία είναι καλύτερη από μια τρίτη ιστοσελίδα)
    - δεν επιτρέπονται υπηρεσίες φιλοξενίας αρχείων (αυτό περιλαμβάνει (αλλά δεν περιορίζεται στους) συνδέσμους από Dropbox και Google Drive)
- να προτιμάτε ένα σύνδεσμο `https` από έναν `http` -- αρκεί να είναι στο ίδιο domain και να εξυπηρετούν τον ίδιο περιεχόμενο
- στα root domains, αφαιρέστε την τελευταία κάθετο: `http://example.com` αντί για `http://example.com/`
- να προτιμάτε πάντα τους μικρότερους συνδέσμους: `http://example.com/dir/` είναι καλύτερα από `http://example.com/dir/index.html`
    - δεν επιτρέπονται περικομμένοι σύνδεσμοι (URL shortener)
- να προτιμάτε συνήθως τους "τρέχοντες" συνδέσμους από τους συνδέσμους "εκδόσεων": `http://example.com/dir/book/current/` είναι καλύτερα από `http://example.com/dir/book/v1.0.0/index.html`
- αν ένας σύνδεσμος έχει ληγμένο πιστοποιητικό/αυτοϋπογεγραμμένο πιστοποιητικό/κάποια θέμα άλλου είδους με SSL:
    1. *αντικαταστήστε το* με το `http` αντίστοιχό του αν είναι δυνατό (επειδή το να γίνονται αποδεκτές εξαιρέσεις μπορεί να είναι περίπλοκο σε φορητές συσκευές).
    2. *αφήστε το* αν δεν υπάρχει διαθέσιμη έκδοση για `http` αντίστοιχο αλλά ο σύνδεσμος είναι ακόμα προσβάσιμος από `https` προσθέτοντας εξαίρεση στον browser ή αγνοώντας της προειδοποίηση
    3. *αφαιρέστε το* σε κάθε άλλη περίπτωση
- αν ένας σύνδεσμος υπάρχει σε διαφορετικά format, προσθέστε διαφορετικό σύνδεσμο με μια σημείωση για κάθε format
- αν κάποιο υλικό υπάρχει σε διαφορετικά μέρη στο Internet
    - χρησιμοποιείστε τον σύνδεσμο με την πιο έγκυρη πηγή (που σημαίνει ότι η ιστοσελίδα του συγγραφέα είναι καλύτερη από τη σελίδα του εκδότη, η οποία είναι καλύτερη από μια τρίτη ιστοσελίδα)
    - αν οδηγούν σε διαφορετικές εκδόσεις, και θεωρείτε πως αυτές οι εκδόσεις είναι αρκετά διαφορετικές ώστε να έχει αξία η διατήρησή τους, προσθέστε διαφορετικό σύνδεσμο με μια σημείωση για κάθε έκδοση (δείτε το [Issue #2353](https://github.com/EbookFoundation/free-programming-books/issues/2353) για να συνεισφέρετε στη συζήτηση για τη μορφοποίηση)
- προτιμήστε ατομικά commits (ένα commit ανά προσθήκη/διαγραφή/τροποποίηση) αντί για μεγαλύτερα commits. Δεν υπάρχει ανάγκη να συνενώνετε τα commits πριν υποβάλλετε ένα PR. (Δεν θα επιβάλλουμε ποτέ αυτόν τον κανόνα εφ' όσον είναι απλά ζήτημα διευκόλυνσης για τους διατηρητές)
- αν το βιβλίο είναι παλιό, περιλαμβάνετε την ημερομηνία δημοσίευσης με τον τίτλο
- συμπεριλαμβάνετε το όνομα ή τα ονόματα του συγγραφέα όπου είναι απαραίτητο. Μπορείτε να μικρύνετε τις λίστες συγγραφέων με το "`et al.`".
- αν το βιβλίο δεν έχει τελειώσει, και βρίσκεται ακόμα υπό συγγραφή, προσθέστε τη σημείωση "`in process`", όπως περιγράφεται [παρακάτω](#in_process).
- αν το υλικό έχει ανακτηθεί χρησιμοποιώντας το [*Internet Archive's Wayback Machine*](https://web.archive.org) (ή παρόμοια), προσθέτε την ένδειξη "`αρχείοθετημένο`" (στα αγγλικά: "`archived`"), όπως περιγράφεται [παρακάτω](#archived). Οι καλύτερες εκδοχές για να χρησιμοποιήσετε είναι οι πρόσφατες και πλήρεις.
- αν ζητείται διεύθυνση ηλεκτρονικού ταχυδρομείου ή δημιουργία λογαριασμού πριν την ενεργοποίηση της λήψης, προσθέστε κατάλληλες σημειώσεις ανάλογα με τη γλώσσα σε παρένθεση, π.χ. `(διεύθυνση email *ζητείται*, δεν είναι απαραίτητη)`.


<!----><a id="formatting"></a>
### Μορφοποίηση

- Όλες οι λίστες είναι αρχεία `.md`. Προσπαθήστε να μάθετε τη σύνταξη του [Markdown](https://guides.github.com/features/mastering-markdown/). Είναι απλή!
- Όλες οι λίστες ξεκινούν με τα Περιεχόμενα (Index). Η ιδέα είναι να υπάρχουν σύνδεσμοι για κάθε ενότητα και υποενότητα εκεί. Διατηρήστε την αλφαβητική σειρά.
- Οι ενότητες χρησιμοποιούν επικεφαλίδες επιπέδου 3 (`###`), και οι υποενότητες είναι επικεφαλίδες επιπέδου 4 (`####`).

Η ιδέα είναι να έχουμε:

- `2` κενές γραμμές μεταξύ τελευταίου συνδέσμου και νέας ενότητας
- `1` κενή γραμμή μεταξύ επικεφαλίδας & πρώτου συνδέσμου της ενότητάς του
- `0` κενές γραμμές μεταξύ δύο συνδέσμων
- `1` κενή γραμμή στο τέλος κάθε αρχείου `.md`.

Παράδειγμα:

```text
[..].
* [Ένα Φοβερό Βιβλίο](http://example.com/example.html)
                                (κενή γραμμή)
                                (κενή γραμμή)
### Παράδειγμα
                                (κενή γραμμή)
* [Άλλο Φοβερό Βιβλίο](http://example.com/book.html)
* [Κάποιο Άλλο Βιβλίο](http://example.com/other.html)
```

- Μη βάζετε κενό μεταξύ `]` και `(`:

    ```text
    ΚΑΚΟ: * [Άλλο Φοβερό Βιβλίο] (http://example.com/book.html)
    ΚΑΛΟ: * [Άλλο Φοβερό Βιβλίο](http://example.com/book.html)
    ```

- Αν συμπεριλαμβάνετε συγγραφέα, χρησιμοποιήστε ` - ` (μια παύλα που περιβάλλεται από κενά):

    ```text
    ΚΑΚΟ: * [Άλλο Φοβερό Βιβλίο](http://example.com/book.html)- John Doe
    ΚΑΛΟ: * [Άλλο Φοβερό Βιβλίο](http://example.com/book.html) - John Doe
    ```

- Εισάγετε ένα κενό μεταξύ του συνδέσμου και του format του:

    ```text
    ΚΑΚΟ: * [Ένα Πολύ Φοβερό Βιβλίο](https://example.org/book.pdf)(PDF)
    ΚΑΛΟ: * [Ένα Πολύ Φοβερό Βιβλίο](https://example.org/book.pdf) (PDF)
    ```

- Ο συγγραφέας μπαίνει πριν το format

    ```text
    ΚΑΚΟ: * [Ένα Πολύ Φοβερό Βιβλίο](https://example.org/book.pdf)- (PDF) Jane Roe
    ΚΑΛΟ: * [Ένα Πολύ Φοβερό Βιβλίο](https://example.org/book.pdf) - Jane Roe (PDF)
    ```

- Πολλαπλά formats:

    ```text
    ΚΑΚΟ: * [Ένα Πολύ Φοβερό Βιβλίο](http://example.com/)- John Doe (HTML)
    ΚΑΚΟ: * [Ένα Πολύ Φοβερό Βιβλίο](https://downloads.example.org/book.html)- John Doe (download site)
    ΚΑΛΟ: * [Ένα Πολύ Φοβερό Βιβλίο](http://example.com/) - John Doe (HTML) [(PDF, EPUB)](https://downloads.example.org/book.html)
    ```

- Συμπεριλαμβάνετε χρονιά δημοσιεύσης στον τίτλο για παλαιότερα βιβλία:

    ```text
    ΚΑΚΟ: * [Ένα Πολύ Φοβερό Βιβλίο](https://example.org/book.html) - Jane Roe - 1970
    ΚΑΛΟ: * [Ένα Πολύ Φοβερό Βιβλίο (1970)](https://example.org/book.html) - Jane Roe
    ```

- <a id="in_process"></a>Βιβλία σε εξέλιξη:

    ```text
    ΚΑΛΟ: * [Θα Είναι Σύντομα Ένα Φοβερό Βιβλίο](http://example.com/book2.html) - John Doe (HTML) *( :construction: σε εξέλιξη)*
    ```

- <a id="archived"></a>Αρχειοθετημένοι σύνδεσμοι:

    ```text
    ΚΑΛΟ: * [Ένα Ενδιαφέρον Way-backed Βιβλίο](https://web.archive.org/web/20211016123456/http://example.com/) - John Doe (HTML) *( :card_file_box: αρχειοθετημένο)*
    ```

### Alphabetical order

- When there are multiple titles beginning with the same letter order them by the second, and so on. For example: `aa` comes before `ab`.
- `one two` comes before `onetwo`

If you see a misplaced link, check the linter error message to know which lines should be swapped.


<!----><a id="notes"></a>
### Σημειώσεις

Αν και τα βασικά είναι σχετικά απλά, υπάρχει μεγάλη ποικιλία στο υλικό που παρουσιάζουμε. Ορίστε μερικές σημειώσεις για το πως να αντιμετωπίσετε αυτή την ποικιλία


#### Metadata

Οι λίστες μας παρέχουν ένα ελάχιστο σύνολο από metadata: τίτλους, URLs, δημιουργούς, πλατφόρμες, και σημειώσεις πρόσβασης


#### Τίτλοι

- Όχι δικοί σας τίτλοι. Προσπαθούμε να πάρουμε τους τίτλους από τις ίδιες τις πηγές· οι συνεισφέροντες επιβάλλεται να μη εφευρίσκουν τίτλους ή να τους χρησιμοποιούν εκδοτικά αν αυτό μπορεί να αποφευχθεί. Μια εξαίρεση είναι για παλαιότερα έργα· αν είναι παρουσιάζουν κυρίως ιστορικό ενδιαφέρον, το έτος στην παρένθεση προσαρτημένο με τον τίτλο βοηθά τους χρήστες να γνωρίζουν αν τους ενδιαφέρει.
- Όχι τίτλοι αποκλειστικά σε ΚΕΦΑΛΑΙΑ. Η συνήθης κεφαλαιοποίηση τίτλων (title case) είναι κατάλληλη, αλλά όταν υπάρχουν αμφιβολίες χρησιμοποιήστε την κεφαλαιοποίηση της πηγής
- No emojis.


##### URLs

- Δεν επιτρέπουμε περικομμένα URLs.
- Κωδικοί ανίχνευσης πρέπει να αφαιρεθούν από το URL.
- Τα διεθνή URLs πρέπει να είναι escaped. Οι browsers τυπικά τα μετατρέπουν σε Unicode, αλλά χρησιμοποιήστε αντιγραφή και επικόλληση, παρακαλούμε.
- Ασφαλή (`https`) URLs προτιμώνται πάντα αντί για μη ασφαλή (`http`) urls για τα οποία έχει υλοποιηθεί HTTPS.
- Δεν μας αρέσουν URLs που οδηγούν σε ιστοσελίδες που δεν φιλοξενούν το υλικό που αναφέρεται, αλλά αντ' αυτού οδηγούν αλλού.


##### Δημιουργοί

- Θέλουμε να αναφέρονται τα ονόματα των δημιουργών δωρεάν υλικού όπου κρίνεται κατάλληλο, συμπεριλαμβανομένων των μεταφραστών!
- Για μεταφρασμένα έργα, θα πρέπει να αναφέρεται το όνομα του αρχικού συγγραφέα. We recommend using [MARC relators](https://loc.gov/marc/relators/relaterm.html) to credit creators other than authors, as in this example:

    ```markdown
    * [A Translated Book](http://example.com/book-el.html) - John Doe, `trl.:` Mike The Translator
    ```

    here, the annotation `trl.:` uses the MARC relator code for "translator".
- Use a comma `,` to delimit each item in the author list.
- You can shorten author lists with "`et al.`".
- Δεν επιτρέπουμε συνδέσμους για Δημιουργούς.
- Για συλλεγμένα ή επεξεργασμένα έργα, ο "δημιουργός" ίσως χρειάζεται περιγραφή. Για παράδειγμα, τα βιβλία από το "GoalKicker" ή "RIP Tutorial" αναφέρονται ως "`Συντάχθηκαν από documentation του StackOverflow`" (στα αγγλικά: "`Compiled from StackOverflow documentation`").


##### Πλατφόρμες και Σημειώσεις Πρόσβασης

- Μαθήματα. Ειδικά για τις λίστες μαθημάτων μας, η πλατφόρμα είναι ένα σημαντικό κομμάτι της περιγραφής του υλικού. Αυτό επειδή οι πλατφόρμες με μαθήματα έχουν διαφορετική προσβασιμότητα και μοντέλα πρόσβασης. Ενώ συνήθως δεν θα προσθέσουμε ένα βιβλίο που απαιτεί εγγραφή, πολλές πλατφόρμες μαθημάτων έχουν χαρακτηριστικά που δεν θα δουλέψουν χωρίς κάποιο τύπο λογαριασμού. Παραδείγματα πλατφορμών μαθημάτων περιλαμβάνουν τα Coursera, EdX, Udacity και Udemy. Όταν ένα μάθημα εξαρτάται από την πλατφόρμα, το όνομα της πλατφόρμας θα πρέπει να αναφέρεται σε παρένθεση.
- YouTube. Έχουμε πολλά μαθήματα που αποτελούνται από playlists στο YouTube. Δεν παραθέτουμε το YouTube σαν πλατφόρμα, προσπαθούμε να αναφέρουμε τον δημιουργό στο YouTube, που είναι συνήθως υπό-πλατφόρμα.
- Βίντεο στο YouTube. Συνήθως δεν δεχόμαστε σε ατομικά βίντεο του YouTube εκτός αν είναι περισσότερο από μια ώρα και έχουν δομή σαν μάθημα ή σεμινάριο.
- Leanpub. Το Leanpub φιλοξενεί βιβλία με διαφορετικά μοντέλα πρόσβασης. Κάποιες φορές ένα βιβλίο μπορεί να διαβαστεί εγγραφή· κάποιες φορές ένα βιβλίο απαιτεί λογαριασμό στο Leanpub για δωρεάν πρόσβαση. Δεδομένης της ποιότητας των βιβλίων και του μίγματος και της ρευστότητας των μοντέλων πρόσβασης του Leanpub, επιτρέπουμε την παράθεση του τελευταίου με τη σημείωση πρόσβασης `*(Ζητείται λογαριασμός Leanpub ή έγκυρο email)*`.


<!----><a id="genres"></a>
#### Είδη

Ο πρώτος κανόνας στην απόφαση για το σε ποια λίστα ανήκει το υλικό είναι να δείτε πώς περιγράφει τον εαυτό του. Αν αυτοαποκαλείται βιβλίο, τότε ίσως είναι βιβλίο.


##### Είδη που δεν παραθέτουμε

Επειδή το Internet είναι μεγάλο, δεν περιέχουμε στις λίστες μας:

- blogs
- blog posts
- άρθρα
- ιστοσελίδες (εκτός από αυτές που φιλοξενούν ΠΟΛΛΑ από τα αντικείμενα που παραθέτουμε).
- βίντεο που δεν είναι μαθήματα ή screencasts.
- κεφάλαια βιβλίων
- δείγματα από βιβλία
- κανάλια από το IRC ή το Telegram
- Slacks ή λίστες mailing

Οι λίστες μας ανταγωνιστικού προγραμματισμού δεν είναι το ίδιο αυστηρές με αυτούς τους αποκλεισμούς. Τα περιθώρια αυτού του αποθετηρίου αποφασίζονται από την κοινότητα· αν θέλετε να προτείνετε μια αλλαγή ή μια προσθήκη στον σκοπό, παρακαλούμε χρησιμοποιήστε ένα issue για να κάνετε μια πρόταση.


##### Βιβλία vs. Άλλα Πράγματα

Δεν είμαστε τόσο γκρινιάρηδες για την βιβλιό-τητα. Ορίστε μερικά χαρακτηριστικά που εκφράζουν ότι το υλικό είναι βιβλίο:

- έχει ISBN (International Standard Book Number)
- έχει Περιεχόμενα
- παρέχεται μια έκδοση για κατέβασμα, ιδιαίτερα αρχεία ePub.
- έχει διαφορετικές εκδόσεις
- δεν εξαρταίται από διαδραστικό περιεχόμενο ή βίντεο
- προσπαθεί να καλύψει ολοκληρωτικά ένα θέμα
- είναι αυτοτελές

Υπάρχουν πολλά βιβλία που παραθέτουμε που δεν έχουν αυτά τα χαρακτηριστικά· μπορεί να εξαρτάται από την περίπτωση.


##### Βιβλία vs. Μαθήματα

Μερικές φορές μπορεί να είναι δύσκολο να τα ξεχωρίσουμε!

Τα μαθήματα έχουν συχνά σχετιζόμενα βιβλία, τα οποία πρέπει να παραθέτουμε στη λίστα μας με τα βιβλία. Τα μαθήματα έχουν διαλέξεις, ασκήσεις, τεστ, σημειώσεις και άλλα διδακτικά βοηθήματα. Μια και μοναδική διάλεξη ή βίντεο δεν είναι από μόνο του μάθημα. Ένα powerpoint δεν είναι μάθημα.


##### Διαδραστικά Σεμνάρια vs. Άλλα Πράγματα

Αν μπορείτε να το τυπώσετε και να διατηρήσετε την ουσία του, δεν είναι Διαδραστικό Σεμινάριο.


<!----><a id="automation"></a>
### Αυτοματισμός

- Η επιβολή των κανόνων μορφοποίησης αυτοματοποιείται από το [GitHub Actions](https://github.com/features/actions) χρησιμοποιώντας [fpb-lint](https://github.com/vhf/free-programming-books-lint) (βλ. [`.github/workflows/fpb-lint.yml`](../.github/workflows/fpb-lint.yml))
- Η επικύρωση των URL χρησιμοποιεί το [awesome_bot](https://github.com/dkhamsing/awesome_bot)
- Για να ενεργοποιήσετε την επικύρωση του URL, κάντε push ένα commit που περιέχει ένα μήνυμα στο οποίο υπάρχει το `check_urls=file_to_check`:

    ```properties
    check_urls=free-programming-books.md free-programming-books-el.md
    ```

- Μπορείτε να προσδιορίσετε πάνω από ένα αρχείο για έλεγχο, χρησιμοποιώντας ένα κενό για να ξεχωρίσετε κάθε καταχώρηση.
- Αν προσδιορίσετε πάνω από ένα αρχείο, τα αποτελέσματα του build βασίζονται στα αποτελέσματα του τελευταίου αρχείου που ελέγχθηκε. Θα πρέπει να γνωρίζετε ότι ενδέχεται να πάρετε επικυρωμένα builds εξαιτίας αυτού οπότε να είστε σίγουροι ότι επιβλέπετε το αρχείο του build στο τέλος του Pull Request πατώντας στο "Show all checks" -> "Details".
