* [इसको अन्य भाषाओं में पढ़ें](README.md#translations)*

## योगदानकर्ता लाइसेंस समझौता

योगदान करके, आप इस रिपॉजिटरी के [लाइसेंस](../LICENSE) से सहमत होते हैं।

## योगदानकर्ता आचार संहिता

योगदान करके, आप इस रिपॉजिटरी के [आचार संहिता](CODE_OF_CONDUCT.md) का सम्मान करने के लिए सहमत होते हैं। ([अनुवाद](README.md#translations))

## संक्षेप में

1. "किसी किताब को आसानी से डाउनलोड करने के लिए एक लिंक" हमेशा एक *नि:शुल्क* किताब का लिंक नहीं होता। कृपया केवल मुफ्त सामग्री का योगदान करें। सुनिश्चित करें कि यह मुफ्त है। हम उन पृष्ठों के लिंक स्वीकार नहीं करते जो किताबें प्राप्त करने के लिए *कार्यशील* ईमेल पते की आवश्यकता होती है, लेकिन हम उन सूचियों का स्वागत करते हैं जो उनसे अनुरोध करते हैं।

2. आपको Git जानने की आवश्यकता नहीं है: यदि आपको कुछ रुचिकर मिला है जो *पहले से इस रिपॉजिटरी में नहीं है*, तो कृपया अपनी लिंक प्रस्तावों के साथ एक [Issue](https://github.com/EbookFoundation/free-programming-books/issues) खोलें।  
    - यदि आप Git जानते हैं, तो कृपया रिपॉजिटरी को Fork करें और Pull Requests (PR) भेजें।

3. हमारे पास 6 प्रकार की सूचियाँ हैं। सही का चयन करें:

    - *Books* : PDF, HTML, ePub, एक gitbook.io आधारित साइट, एक Git रिपॉ, आदि।  
    - *Courses* : एक कोर्स वह शिक्षण सामग्री है जो एक किताब नहीं है। [यह एक कोर्स है](http://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-006-introduction-to-algorithms-fall-2011/)।  
    - *Interactive Tutorials* : एक इंटरैक्टिव वेबसाइट जो उपयोगकर्ता को कोड या कमांड टाइप करने देती है और परिणाम का मूल्यांकन करती है (यहाँ "मूल्यांकन" का अर्थ "ग्रेड" नहीं है)। उदाहरण: [Try Haskell](http://tryhaskell.org), [Try Git](https://learngitbranching.js.org)।  
    - *Playgrounds* : ये ऑनलाइन और इंटरैक्टिव वेबसाइट्स, गेम्स या डेस्कटॉप सॉफ़्टवेयर हैं जो प्रोग्रामिंग सीखने के लिए हैं। कोड स्निपेट लिखें, संकलित करें (या चलाएं), और साझा करें। Playgrounds आमतौर पर आपको कोड के साथ खेलने का मौका देते हैं।  
    - *Podcasts and Screencasts* : पॉडकास्ट और स्क्रीनकास्ट।  
    - *Problem Sets & Competitive Programming* : एक वेबसाइट या सॉफ़्टवेयर जो आपको सरल या जटिल समस्याओं को हल करके अपनी प्रोग्रामिंग कौशल का आकलन करने देता है, कोड समीक्षा के साथ या बिना, अन्य उपयोगकर्ताओं के साथ परिणामों की तुलना के साथ या बिना।

4. सुनिश्चित करें कि आप [नीचे दिए गए दिशानिर्देशों](#guidelines) का पालन करें और फ़ाइलों के [Markdown स्वरूपण](#formatting) का सम्मान करें।

5. GitHub Actions परीक्षण चलाएगा ताकि **आपकी सूचियाँ वर्णानुक्रमित हों** और **स्वरूपण नियमों का पालन किया गया हो**। **परीक्षण पास करने के लिए** सुनिश्चित करें कि आपके परिवर्तनों ने परीक्षण पास किए हैं।

### दिशानिर्देश

- सुनिश्चित करें कि कोई किताब मुफ्त है। यदि आवश्यक हो तो दोबारा जांचें। यह एडमिन्स की मदद करता है अगर आप PR में टिप्पणी करते हैं कि आपको क्यों लगता है कि किताब मुफ्त है।  
- हम Google Drive, Dropbox, Mega, Scribd, Issuu और अन्य समान फ़ाइल अपलोड प्लेटफ़ॉर्म पर होस्ट की गई फ़ाइलें स्वीकार नहीं करते।  
- अपने लिंक को वर्णमाला क्रम में डालें, जैसा कि [नीचे](#alphabetical-order) बताया गया है।  
- सबसे अधिक अधिकारिक स्रोत वाला लिंक उपयोग करें (अर्थात लेखक की वेबसाइट संपादक की वेबसाइट से बेहतर है, जो तृतीय-पक्ष वेबसाइट से बेहतर है)  
    - कोई फ़ाइल होस्टिंग सेवाएं नहीं (इसमें (लेकिन सीमित नहीं है) Dropbox और Google Drive लिंक शामिल हैं)  
- हमेशा `https` लिंक को `http` पर प्राथमिकता दें -- बशर्ते वे एक ही डोमेन पर हों और एक ही सामग्री प्रदान करें।  
- रूट डोमेन्स पर, अंतिम स्लैश को हटा दें: `http://example.com` की बजाय `http://example.com/`।  
- हमेशा सबसे छोटा लिंक पसंद करें: `http://example.com/dir/` `http://example.com/dir/index.html` से बेहतर है।  
    - कोई URL शॉर्टनर लिंक नहीं।  
- आमतौर पर "वर्तमान" लिंक को "संस्करण" लिंक पर प्राथमिकता दें: `http://example.com/dir/book/current/` `http://example.com/dir/book/v1.0.0/index.html` से बेहतर है।  
- यदि किसी लिंक में कोई समाप्त प्रमाणपत्र/स्व-हस्ताक्षरित प्रमाणपत्र/SSL समस्या है:  
    1. *इसे* इसके `http` समकक्ष से बदलें यदि संभव हो (क्योंकि मोबाइल उपकरणों पर अपवाद स्वीकार करना जटिल हो सकता है)।  
    2. *इसे छोड़ें* यदि कोई `http` संस्करण उपलब्ध नहीं है लेकिन लिंक अभी भी ब्राउज़र में अपवाद जोड़ने या चेतावनी को अनदेखा करके `https` के माध्यम से सुलभ है।  
    3. *इसे हटा दें* अन्यथा।  
- यदि कोई लिंक एक से अधिक प्रारूपों में उपलब्ध है, तो प्रत्येक प्रारूप के बारे में एक नोट के साथ एक अलग लिंक जोड़ें।  
- यदि एक संसाधन इंटरनेट पर विभिन्न स्थानों पर मौजूद है  
    - सबसे अधिकारिक स्रोत वाला लिंक उपयोग करें (अर्थात लेखक की वेबसाइट संपादक की वेबसाइट से बेहतर है, जो तृतीय-पक्ष वेबसाइट से बेहतर है)  
    - यदि वे विभिन्न संस्करणों से लिंक करते हैं, और आप इन संस्करणों को अलग रखने के लिए पर्याप्त रूप से अलग मानते हैं, तो प्रत्येक संस्करण के बारे में एक नोट के साथ एक अलग लिंक जोड़ें।  
- परमाणु कमिट्स (प्रत्येक जोड़/हटाने/संशोधन के लिए एक कमिट) को बड़े कमिट्स से अधिक प्राथमिकता दें। PR सबमिट करने से पहले अपने कमिट्स को मर्ज करने की कोई आवश्यकता नहीं है।  
- यदि किताब पुरानी है, तो शीर्षक के साथ प्रकाशन तिथि शामिल करें।  
- जहां उपयुक्त हो, लेखक का नाम या नाम शामिल करें। आप लेखक सूचियों को "`et al.`" के साथ छोटा कर सकते हैं।  
- यदि किताब पूरी नहीं है, और उस पर अभी भी काम चल रहा है, तो "`in process`" नोटेशन जोड़ें।  
- यदि कोई संसाधन [इंटरनेट आर्काइव के वेबैक मशीन](https://web.archive.org) का उपयोग करके पुनर्स्थापित किया गया है, तो "`archived`" नोटेशन जोड़ें। उपयोग करने के लिए सबसे अच्छे संस्करण हाल के और संपूर्ण हैं।  
- यदि डाउनलोड सक्षम होने से पहले ईमेल पता या खाता सेटअप अनुरोध किया जाता है, तो भाषा-उपयुक्त नोट्स जोड़ें।

### स्वरूपण

- सभी सूचियाँ `.md` फाइलें हैं। [Markdown](https://guides.github.com/features/mastering-markdown/) सिंटैक्स सीखने का प्रयास करें। यह सरल है!  
- सभी सूचियाँ एक इंडेक्स से शुरू होती हैं। विचार यह है कि वहाँ सभी अनुभागों और उप-खंडों की सूची और लिंक बनाएं। इसे वर्णानुक्रम में रखें।  
- अनुभाग स्तर 3 शीर्षक (`###`) का उपयोग कर रहे हैं, और उप-खंड स्तर 4 शीर्षक (`####`) हैं।

विचार यह है कि:

- पिछले लिंक और नए अनुभाग के बीच `2` खाली लाइनें हों।  
- शीर्षक और इसके अनुभाग के पहले लिंक के बीच `1` खाली लाइन हो।  
- दो लिंक के बीच `0` खाली लाइन हो।  
- प्रत्येक `.md` फ़ाइल के अंत में `1` खाली लाइन हो।

Example:

```text  
[...]  
* [An Awesome Book](http://example.com/example.html)  
                                (खाली लाइन)  
                                (खाली लाइन)  
### Example  
                                (खाली लाइन)  
* [Another Awesome Book](http://example.com/book.html)  
* [Some Other Book](http://example.com/other.html)  
```

- `]` और `(` के बीच में कोई स्पेस न डालें:

    ```text  
    खराब: * [Another Awesome Book] (http://example.com/book.html)  
    अच्छा: * [Another Awesome Book](http://example.com/book.html)  
    ```

- यदि आप लेखक को शामिल करते हैं, तो ` - ` (एक डैश जिसमें सिंगल स्पेस शामिल हैं) का उपयोग करें:

    ```text  
    खराब : * [Another Awesome Book](http://example.com/book.html)- John Doe  
    अच्छा: * [Another Awesome Book](http://example.com/book.html) - John Doe  
    ```

- लिंक और उसके फॉर्मेट के बीच एक स्पेस डालें:

    ```text

    खराब : * [A Very Awesome Book]([https://example.org/book.pdf](https://example.org/book.pdf))(PDF)

    अच्छा: * [A Very Awesome Book\](https://example.org/book.pdf) (PDF)

    ```

- लेखक प्रारूप से पहले आता है:

    ```text

    खराब : * [A Very Awesome Book](https://example.org/book.pdf)- (PDF) Jane Roe

    अच्छा: * [A Very Awesome Book](https://example.org/book.pdf) - Jane Roe (PDF)

    ```

- कई प्रारूप (हम प्रत्येक संसाधन के लिए एक ही लिंक पसंद करते हैं। जब विभिन्न प्रारूपों तक आसान पहुँच के लिए एकल लिंक नहीं होता, तो कई लिंक समझ में आ सकते हैं। लेकिन हर लिंक जो हम जोड़ते हैं, रखरखाव का भार बढ़ाता है इसलिए हम इसे टालने की कोशिश करते हैं।):

    ```text

    खराब : * [Another Awesome Book](http://example.com/)- John Doe (HTML)

    खराब : * [Another Awesome Book](https://downloads.example.org/book.html)- John Doe            (डाउनलोड साइट)

    अच्छा: * [Another Awesome Book](http://example.com/) - John Doe (HTML) [(PDF, EPUB)](https://downloads.example.org/book.html)

    ```

- पुराने पुस्तकों के लिए शीर्षक में प्रकाशन वर्ष शामिल करें:

    ```text

    खराब : \* \[A Very Awesome Book\](https://example.org/book.html) \- Jane Roe \- 1970

    अच्छा: \* \[A Very Awesome Book (1970)\](https://example.org/book.html) \- Jane Roe

    ```

- <a id="in_process"></a>प्रक्रियाधीन पुस्तकें:

    ```text

    अच्छा: * [Will Be An Awesome Book Soon](http://example.com/book2.html) - John Doe (HTML) *( :construction: प्रक्रियाधीन)*

    ```

- <a id="archived"></a>संरक्षित लिंक:

    ```text

    अच्छा: * [A Way-backed Interesting Book](https://web.archive.org/web/20211016123456/http://example.com/) - John Doe (HTML) *( :card_file_box: संरक्षित)*

    ```

### वर्णमाला क्रम

- जब एक ही अक्षर से शुरू होने वाले कई शीर्षक होते हैं, तो उन्हें दूसरे अक्षर और आगे के अनुसार क्रमबद्ध करें। उदाहरण के लिए: `aa` `ab` से पहले आता है।

- `one two` `onetwo` से पहले आता है।

यदि आप कोई गलत लिंक देखते हैं, तो यह जानने के लिए लिंटर त्रुटि संदेश की जाँच करें कि किन पंक्तियों को स्वैप किया जाना चाहिए।

### नोट्स

हालांकि बुनियादी बातें अपेक्षाकृत सरल हैं, लेकिन हमारे द्वारा सूचीबद्ध संसाधनों में बहुत विविधता है। यहां बताया गया है कि हम इस विविधता से कैसे निपटते हैं।

#### मेटाडाटा

हमारी सूचियाँ न्यूनतम मेटाडाटा प्रदान करती हैं: शीर्षक, यूआरएल, निर्माता, प्लेटफ़ॉर्म और एक्सेस नोट्स।

##### शीर्षक

- कोई आविष्कृत शीर्षक नहीं। हम संसाधनों से ही शीर्षक लेते हैं; योगदानकर्ताओं को निर्देश दिया जाता है कि जब तक इसे टाला जा सकता है, तब तक शीर्षक न बनाएं या उन्हें संपादकीय रूप से उपयोग न करें। एक अपवाद पुराने कार्यों के लिए है; यदि वे मुख्य रूप से ऐतिहासिक रुचि के हैं, तो शीर्षक के बाद कोष्ठक में वर्ष जोड़ने से उपयोगकर्ताओं को यह पता चल जाता है कि वे रुचि के हैं या नहीं।

- कोई ALLCAPS शीर्षक नहीं। आमतौर पर शीर्षक मामला उपयुक्त होता है, लेकिन जब संदेह हो तो स्रोत से पूंजीकरण का उपयोग करें।

- कोई इमोजी नहीं।

##### यूआरएल

- हम संक्षिप्त यूआरएल की अनुमति नहीं देते।

- यूआरएल से ट्रैकिंग कोड हटा दिए जाने चाहिए।

- अंतर्राष्ट्रीय यूआरएल को एस्केप किया जाना चाहिए। ब्राउज़र बार आमतौर पर इन्हें यूनिकोड में प्रस्तुत करते हैं, लेकिन कृपया कॉपी और पेस्ट का उपयोग करें।

- गैर-सुरक्षित (`http`) यूआरएल की तुलना में हमेशा सुरक्षित (`https`) यूआरएल को प्राथमिकता दी जाती है जहां HTTPS लागू किया गया है।

- हमें ऐसे यूआरएल पसंद नहीं हैं जो सूचीबद्ध संसाधन की मेजबानी करने वाले वेबपृष्ठों की ओर इंगित नहीं करते बल्कि कहीं और इंगित करते हैं।

##### निर्माता

- जहां उपयुक्त हो वहां निःशुल्क संसाधनों के निर्माताओं को श्रेय देना हम चाहते हैं, इसमें अनुवादक भी शामिल हैं!

- अनुवादित कार्यों के लिए मूल लेखक को श्रेय दिया जाना चाहिए। हम अनुशंसा करते हैं कि लेखकों के अलावा अन्य निर्माताओं को श्रेय देने के लिए [MARC रिलेटर](https://loc.gov/marc/relators/relaterm.html) का उपयोग करें, जैसा कि इस उदाहरण में है:

    ```markdown

    * [एक अनुवादित पुस्तक](http://example.com/book.html) - जॉन डो, `trl.:` माइक द ट्रांसलेटर

    ```

    यहाँ, एनोटेशन `trl.:` "अनुवादक" के लिए MARC रिलेटर कोड का उपयोग करता है।

- लेखक सूची में प्रत्येक आइटम को सीमांकित करने के लिए अल्पविराम `,` का उपयोग करें।

- आप लेखक सूचियों को "`et al.`" के साथ छोटा कर सकते हैं।

- हम निर्माताओं के लिए लिंक की अनुमति नहीं देते।

- संकलन या मिश्रित कार्यों के लिए, "निर्माता" को विवरण की आवश्यकता हो सकती है। उदाहरण के लिए, "GoalKicker" या "RIP ट्यूटोरियल" पुस्तकों को श्रेय दिया जाता है "`StackOverflow प्रलेखन से संकलित किया गया`"।

- हम निर्माता नामों में "प्रोफ़ेसर" या "डॉ." जैसे उपाधियों को शामिल नहीं करते।

##### समय-सीमित पाठ्यक्रम और परीक्षण

- हम ऐसी चीज़ों को सूचीबद्ध नहीं करते जिन्हें हमें छह महीने में हटाना पड़ेगा।

- यदि किसी पाठ्यक्रम में सीमित नामांकन अवधि या अवधि है, तो हम इसे सूचीबद्ध नहीं करेंगे।

- हम उन संसाधनों को सूचीबद्ध नहीं कर सकते जो सीमित अवधि के लिए निःशुल्क हैं।

##### प्लेटफ़ॉर्म और एक्सेस नोट्स

- पाठ्यक्रम। विशेष रूप से हमारी पाठ्यक्रम सूचियों के लिए, प्लेटफ़ॉर्म संसाधन विवरण का एक महत्वपूर्ण हिस्सा है। ऐसा इसलिए है क्योंकि पाठ्यक्रम प्लेटफ़ॉर्म के पास अलग-अलग एक्सेस मॉडल और सुविधाएं होती हैं। जबकि हम आम तौर पर ऐसे पुस्तक को सूचीबद्ध नहीं करेंगे जिसके लिए पंजीकरण की आवश्यकता हो, कई पाठ्यक्रम प्लेटफ़ॉर्म के पास ऐसी सुविधाएं होती हैं जो किसी प्रकार के खाते के बिना काम नहीं करतीं। उदाहरण पाठ्यक्रम प्लेटफ़ॉर्म में Coursera, EdX, Udacity और Udemy शामिल हैं। जब कोई पाठ्यक्रम किसी प्लेटफ़ॉर्म पर निर्भर करता है, तो प्लेटफ़ॉर्म का नाम सूचीबद्ध किया जाना चाहिए।

- YouTube। हमारे पास कई पाठ्यक्रम हैं जिनमें YouTube प्लेलिस्ट शामिल हैं। हम YouTube को प्लेटफ़ॉर्म के रूप में सूचीबद्ध नहीं करते, हम YouTube निर्माता को सूचीबद्ध करने का प्रयास करते हैं, जो अक्सर एक उप-प्लेटफ़ॉर्म होता है।

- YouTube वीडियो। हम आमतौर पर व्यक्तिगत YouTube वीडियो को लिंक नहीं करते जब तक कि वे एक घंटे से अधिक लंबे न हों और पाठ्यक्रम या ट्यूटोरियल की तरह संरचित न हों। यदि ऐसा है, तो सुनिश्चित करें कि इसे पीआर विवरण में नोट करें।

- संक्षिप्त (अर्थात youtu.be/xxxx) लिंक नहीं!

- Leanpub। Leanpub विभिन्न एक्सेस मॉडल के साथ पुस्तकों की मेजबानी करता है। कभी-कभी किसी पुस्तक को बिना पंजीकरण के पढ़ा जा सकता है; कभी-कभी किसी पुस्तक के लिए मुफ़्त एक्सेस के लिए Leanpub खाता आवश्यक होता है। Leanpub एक्सेस मॉडल की गुणवत्ता और मिश्रण और तरलता को देखते हुए, हम बाद वाले को एक्सेस नोट के साथ सूचीबद्ध करने की अनुमति देते हैं `*(Leanpub खाता या मान्य ईमेल अनुरोधित)*`।

 

