*[他の言語で読む](README.md#translations)*。


## 投稿者ライセンス契約

投稿することで、あなたはこのリポジトリの [LICENSE](../LICENSE) に同意したことになります。


## 投稿者の行動規範

貢献することで、あなたはこのリポジトリの[行動規範](CODE_OF_CONDUCT-ja.md)を尊重することに同意します。([翻訳](README.md#translations))


## 一言で言えば

1. 「本を簡単にダウンロードできるリンク」は、必ずしも*無料*の本へのリンクとは限りません。無料のコンテンツだけを投稿してください。無料であることを確認してください。私たちは、本を入手するために作業用メールアドレスを要求*するページへのリンクは受け付けませんが、要求するリストは歓迎します。

2. 2.Gitを知らなくてもかまいません。このレポに*まだ*入っていない*興味深いものを見つけたら、リンクの提案を添えて[Issue](https://github.com/EbookFoundation/free-programming-books/issues)を開いてください。
    - Gitを知っているなら、レポをフォークして、プルリクエスト（PR）を送ってください。

3. リストには6種類あります。適切なものを選んでください：

    - *書籍* ： PDF、HTML、ePub、gitbook.ioベースのサイト、Gitレポなど。
    - *コース* ： コースは、本ではない学習教材です。[これはコースです](http://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-006-introduction-to-algorithms-fall-2011/)。
    - インタラクティブなチュートリアル ユーザーがコードやコマンドを入力し、その結果を評価する（「評価する」というのは「採点する」という意味ではない）インタラクティブなウェブサイト： [Haskellを試す](http://tryhaskell.org)、[Gitを試す](https://learngitbranching.js.org)。
    - Playgrounds*：プログラミング学習のためのオンラインかつインタラクティブなウェブサイト、ゲーム、またはデスクトップソフトウェアです。コードの断片を書いたり、コンパイル（または実行）したり、共有したりすることができる。プレイグラウンドでは多くの場合、フォークしてコードで遊んで手を汚すことができます。
    - ポッドキャストとスクリーンキャスト* ： ポッドキャストとスクリーンキャスト。
    - 問題集と競技プログラミング* ： 簡単な問題や複雑な問題を解くことで、自分のプログラミング・スキルを評価することができるウェブサイトやソフトウェア。

4. [以下のガイドライン](#ガイドライン)を必ず守り、ファイルの[Markdown フォーマット](#フォーマット)を尊重してください。

5. GitHub Actionsは、**リストがアルファベット順に並んでいるか**、**フォーマットルールが守られているか**を確認するためのテストを実行します。**必ず**テストに合格していることを確認してください。


### ガイドライン

- 本が無料であることを確認する。必要であればダブルチェックしてください。なぜその本が無料だと思うのか、PRにコメントしていただけると管理者が助かります。
- Google Drive、Dropbox、Mega、Scribd、Issuu、その他類似のファイルアップロードプラットフォームでホストされているファイルは受け付けません。
- [下記](#アルファベット順)のように、アルファベット順にリンクを挿入してください。
- 最も権威のあるソース（編集者のウェブサイトよりも著者のウェブサイト、第三者のウェブサイトよりも著者のウェブサイトの方が良いという意味）のリンクを使用してください。
    - ファイルホスティングサービスは使用しない（DropboxやGoogle Driveのリンクがこれに該当します。
- 同じドメインにあり、同じコンテンツを提供するのであれば、`http`のリンクよりも`https`のリンクの方が常に好ましい。
- ルートドメインでは、末尾のスラッシュを取り除く：`http://example.com/`の代わりに`http://example.com`。
- 常に最短のリンクを選ぶ： http://example.com/dir/index.html`よりも`http://example.com/dir/`の方がよい。
    - URL短縮リンクは使わない
- 通常、"バージョン "リンクよりも "最新 "リンクを好む： `http://example.com/dir/book/v1.0.0/index.html` よりも `http://example.com/dir/book/current/` の方がよい。
- リンクに期限切れの証明書、自己署名証明書、SSL問題などがある場合：
    1. *1.可能であれば、`http`に置き換える*（モバイルデバイスでは例外を受け入れるのが複雑になる可能性があるため）。
    2. *ブラウザに例外を追加するか、警告を無視することで、`http` バージョンが利用できなくても、リンクが `https` 経由でアクセスできる場合は、そのままにしておく。
    3. *そうでない場合は削除する。
- リンクが複数のフォーマットで存在する場合、それぞれのフォーマットについての注意書きを添えて別のリンクを追加する。
- リソースがインターネット上のさまざまな場所に存在する場合
    - 最も権威のあるソースのリンクを使用する（第三者のウェブサイトよりも編集者のウェブサイトよりも著者のウェブサイトがよいという意味）。
    - 異なるエディションへのリンクがあり、それらのエディションが保持する価値があるほど異なると判断される場合、それぞれのエディションについての注釈とともに別のリンクを追加する（フォーマットに関する議論に貢献するために、[Issue #2353](https://github.com/EbookFoundation/free-programming-books/issues/2353)を参照してください）。
- より大きなコミットよりもアトミックなコミット（追加/削除/変更で1回のコミット）を優先します。PRを提出する前にコミットをつぶす必要はありません。(このルールは単なるメンテナの利便性の問題なので、私たちは決して強制しません)
- もしその本が古いものであれば、タイトルと一緒に出版日を書いてください。
- 適切な場合には、著者名を含めてください。著者リストは"`et al.`"で短縮できます。
- 本が完成しておらず、まだ作業中である場合は、[下記](#in_process)のように「`in process`」の表記を加えてください。
- リソースが[*Internet Archive's Wayback Machine*](https://web.archive.org)(または同様のもの)を使って復元された場合は、[下記](#archived)のように"`archived`"表記を追加してください。使用するのに最適なバージョンは、最近の完全なものです。
- ダウンロードを有効にする前に、メールアドレスやアカウントの設定が必要な場合は、括弧の中に言語に適した注釈を追加してください： メールアドレスは必須ではありません。


### フォーマット

- すべてのリストは `.md` ファイルです。[Markdown](https://guides.github.com/features/mastering-markdown/)の構文を覚えてください。簡単です！
- すべてのリストはインデックスから始まります。そこですべてのセクションとサブセクションをリストアップし、リンクすることです。アルファベット順にしてください。
- セクションはレベル3の見出し (`###`) を使い、サブセクションはレベル4の見出し (`###`) を使います。

アイデアとしては

- 最後のリンクと新しいセクションの間は2行空ける。
- 見出しとそのセクションの最初のリンクの間に`1`の空行。
- 2つのリンクの間に`0`の空行。
- 各`.md`ファイルの末尾に`1`の空行。

例

```text
[...]
* 素晴らしい本(http://example.com/example.html)
                                (空行)
                                (空白行)
### 例
                                (空白行)
* 別のすごい本(http://example.com/book.html)
* その他の本(http://example.com/other.html)
```

- `]` と `(`の間にスペースを入れないでください：

    ```text
    BAD ： * [Another Awesome Book] (http://example.com/book.html)
    GOOD： * [Another Awesome Book](http://example.com/book.html)
    ```

- 著者を含める場合は、` - `（ダッシュを半角スペースで囲む）を使用する：

    ```text
    BAD ： * [Another Awesome Book](http://example.com/book.html)- John Doe
    GOOD： * [Another Awesome Book](http://example.com/book.html) - John Doe
    ```

- リンクとその形式の間に半角スペースを入れる：

    ```text
    BAD ： * [とても素晴らしい本](https://example.org/book.pdf)(PDF)
    GOOD： * [とても素晴らしい本](https://example.org/book.pdf) (PDF)
    ```

- 著者はフォーマットの前に来る：

    ```text
    BAD ： * [A Very Awesome Book](https://example.org/book.pdf)- (PDF) ジェーン・ロー
    GOOD： * [A Very Awesome Book](https://example.org/book.pdf) - ジェーン・ロー (PDF)
    ```

- 複数のフォーマット（各リソースには1つのリンクが望ましい。When there is no single link with easy access to different formats, multiple links may make sense. But every link we add creates maintenance burden so we try to avoid it.:

    ```text
    BAD : * [Another Awesome Book](http://example.com/)- John Doe (HTML)
    BAD : * [Another Awesome Book](https://downloads.example.org/book.html)- John Doe (download site)
    GOOD: * [Another Awesome Book](http://example.com/) - John Doe (HTML) [(PDF, EPUB)](https://downloads.example.org/book.html)
    ```

- Include publication year in title for older books:

    ```text
    BAD : * [A Very Awesome Book](https://example.org/book.html) - Jane Roe - 1970
    GOOD: * [A Very Awesome Book (1970)](https://example.org/book.html) - Jane Roe
    ```

- <a id="in_process"></a>In-process books:

    ```text
    GOOD: * [Will Be An Awesome Book Soon](http://example.com/book2.html) - John Doe (HTML) ( :construction: *in process*)
    ```

- <a id="archived"></a>Archived link:

    ```text
    GOOD： * [ウェイバックされた面白い本](https://web.archive.org/web/20211016123456/http://example.com/) - John Doe (HTML) *( :card_file_box: archived)*
     ```

### アルファベット順

- 同じ文字で始まるタイトルが複数ある場合は、2番目から順に並べる。例：`aa`は`ab`の前。
- `one two`は`onetwo`の前。

リンクがずれている場合は、リンターのエラーメッセージを確認して、どの行を入れ替えるべきか確認してください。


### 注意事項

基本は比較的シンプルですが、掲載するリソースには非常に多様性があります。ここでは、この多様性にどのように対処するかについて、いくつか注意点を示します。


#### メタデータ

タイトル、URL、作成者、プラットフォーム、アクセスノート。


##### タイトル

- 創作タイトルはありません。投稿者は、避けられるのであれば、タイトルを捏造したり、編集的に使用したりしないよう勧められます。古い作品については例外で、主に歴史的な興味を引くものであれば、タイトルに括弧書きで年号を付記することで、利用者が興味を引くものであるかどうかを知ることができます。
- ALLCAPSタイトルは使わない。通常、タイトルの大文字と小文字の区別は適切ですが、疑問がある場合は、出典元の大文字と小文字の区別を使用してください。
- 絵文字は使わない。


##### URL

- 短縮URLは許可しません。
- トラッキングコードはURLから削除してください。
- 国際URLはエスケープしてください。ブラウザバーは通常これらをユニコードにレンダリングしますが、コピー＆ペーストを使用してください。
- HTTPSが実装されている場合、セキュア（`https`）なURLは常に非セキュア（`http`）なURLよりも優先されます。
- 私たちは、リストされたリソースをホストしていないウェブページを指すURLは好みません。


##### クリエイター

- 私たちは、翻訳者を含め、適切な場合、フリーリソースの作成者をクレジットしたいと思います！
- 翻訳された作品については、原著者がクレジットされるべきです。この例のように、著者以外のクリエイターをクレジットするには、[MARC relators](https://loc.gov/marc/relators/relaterm.html)を使うことをお勧めします：

    ```markdown
    * [翻訳本](http://example.com/book.html) - John Doe, `trl.:` Mike The Translator
    ```

    この例では、`trl.:`という注釈にMARCのリレータコードを使用しています。
- コンマ`,`で著者リストの各項目を区切ります。
- 著者リストは"`et al.`"で短縮できます。
- クリエイターへのリンクは許可しません。
- コンピレーションやリミックス作品の場合、"creator "には説明が必要な場合があります。例えば、"GoalKicker "や "RIP Tutorial "の本は、"`Compiled from StackOverflow documentation`"とクレジットされます。
- 「Prof.」や「Dr.」のような敬称はクリエイター名に含めません。


##### 期間限定のコースとトライアル

- 6ヶ月以内に削除する必要のあるものは掲載しません。
- コースの受講期間や期間が限定されている場合、掲載しません。
- 期間限定の無料リソースを掲載することはできません。


##### プラットフォームとアクセスノート

- コース。特にコースリストでは、プラットフォームはリソース説明の重要な部分です。なぜなら、コースのプラットフォームには異なるアフォーダンスとアクセスモデルがあるからです。通常、登録が必要な書籍はリストアップしませんが、多くのコースプラットフォームは何らかのアカウントがないと利用できないようになっています。コースプラットフォームの例として、Coursera、EdX、Udacity、Udemyが挙げられます。コースがプラットフォームに依存している場合、プラットフォーム名を括弧内に記載する必要があります。
- YouTube。YouTubeプレイリストで構成されたコースが多数あります。YouTubeをプラットフォームとして記載するのではなく、YouTubeクリエータを記載するようにしています。
- YouTubeの動画。私たちは通常、1時間以上の長さがあり、コースやチュートリアルのように構成されていない限り、個々のYouTubeビデオにリンクしません。その場合は、PRの説明文に必ずその旨を明記してください。
- 短縮リンク（例：youtu.be/xxxx）は禁止！
- Leanpub. Leanpubは様々なアクセスモデルの書籍をホストしています。登録なしで読める本もあれば、無料アクセスのためにLeanpubアカウントが必要な本もある。書籍の品質とLeanpubのアクセスモデルの混合性と流動性を考慮し、後者についてはアクセスノート`*(Leanpubアカウントまたは有効な電子メールが必要です)*`の掲載を許可しています。


#### ジャンル

リソースがどのリストに属するかを決める最初のルールは、リソースが自分自身をどのように説明しているかを見ることです。自らを本と呼ぶのであれば、それは本なのかもしれません。


##### リストに載せないジャンル

インターネットは広大なため、リストには含めません：

- ブログ
- ブログ記事
- 記事
- ウェブサイト（私たちがリストアップしている多くの項目をホストしているものを除く）。
- コースやスクリーンキャスト以外のビデオ
- 本の章
- 本のティーザー・サンプル
- IRCまたはTelegramチャンネル
- Slacksやメーリングリスト

私たちの競争的なプログラミング・リストは、これらの除外についてそれほど厳密ではありません。レポジトリのスコープはコミュニティによって決定されます。スコープの変更や追加を提案したい場合は、issueを使って提案してください。


##### 本とその他のもの

私たちは、本であることにそれほどこだわっていません。以下は、リソースが本であることを示すいくつかの属性です：

- ISBN（国際標準図書番号）がある。
- 目次がある
- ダウンロード版、特にePubファイルが提供されている。
- エディションがある
- インタラクティブコンテンツやビデオに依存していない。
- トピックを包括的にカバーしようとしている
- 自己完結している

私たちがリストアップする書籍の中には、これらの属性を持たないものもたくさんあります。


##### 書籍とコースの違い

これらの区別が難しい場合もあります！

コースには関連する教科書があることが多く、私たちはそれを書籍リストに掲載します。コースには、講義、練習問題、テスト、ノートやその他の教材があります。単一の講義やビデオだけではコースとは言えません。パワーポイントはコースではありません。


##### インタラクティブ・チュートリアルとその他のもの

プリントアウトしてそのエッセンスを保持できるなら、それはインタラクティブ・チュートリアルではない。


### 自動化

- フォーマットルールの適用は、[fpb-lint](https://github.com/vhf/free-programming-books-lint) を使って [GitHub Actions](https://github.com/features/actions) 経由で自動化されています（[`.github/workflows/fpb-lint.yml`](../.github/workflows/fpb-lint.yml) を参照）。
- URLバリデーションは[awesome_bot](https://github.com/dkhamsing/awesome_bot)を使います。
- URL バリデーションを起動するには、`check_urls=file_to_check` を含むコミットメッセージを含むコミットをプッシュします：

    ```properties
    check_urls=free-programming-books.md free-programming-books-ja.md
    ```

- チェックするファイルを複数指定することもできます。
- 複数のファイルを指定した場合、ビルドの結果は最後にチェックしたファイルの結果に基づいて行われます。このため、Pull Request の最後にある "Show all checks" -> "Details" をクリックしてビルドログを確認してください。
