*[ഇത് മറ്റ് ഭാഷകളിൽ വായിക്കുക](README.md#translations)*

## സംഭാവന നൽകുന്നതിനുള്ള ലൈസൻസ് ഉടമ്പടി

സംഭാവന ചെയ്യുന്നതിലൂടെ, നിങ്ങൾ ഈ റിപ്പോസിറ്ററിയുടെ [ലൈസൻസ്](../LICENSE) അംഗീകരിക്കുന്നു.

## സംഭാവന നൽകുന്നവർക്കുള്ള പെരുമാറ്റച്ചട്ടം

സംഭാവന ചെയ്യുന്നതിലൂടെ, നിങ്ങൾ ഈ റിപ്പോസിറ്ററിയുടെ [പെരുമാറ്റച്ചട്ടം](CODE_OF_CONDUCT-ml.md) പാലിക്കാൻ സമ്മതിക്കുന്നു. ([വിവർത്തനങ്ങൾ](README.md#translations))

## ചുരുക്കത്തിൽ

1.  "ഒരു പുസ്തകം എളുപ്പത്തിൽ ഡൗൺലോഡ് ചെയ്യാനുള്ള ലിങ്ക്" എന്നത് എല്ലായ്പ്പോഴും ഒരു *സൗജന്യ* പുസ്തകത്തിലേക്കുള്ള ലിങ്ക് ആകണമെന്നില്ല. ദയവായി സൗജന്യമായ ഉള്ളടക്കം മാത്രം സംഭാവന ചെയ്യുക. അത് സൗജന്യമാണെന്ന് ഉറപ്പാക്കുക. പുസ്തകങ്ങൾ ലഭിക്കുന്നതിന് ഇമെയിൽ വിലാസം *നിർബന്ധമായും* നൽകേണ്ട പേജുകളിലേക്കുള്ള ലിങ്കുകൾ ഞങ്ങൾ സ്വീകരിക്കുന്നതല്ല, എന്നാൽ ഇമെയിൽ വിലാസം അഭ്യർത്ഥിക്കുന്ന ലിങ്കുകൾ സ്വീകരിക്കുന്നതാണ്.

2.  നിങ്ങൾ Git അറിഞ്ഞിരിക്കണമെന്നില്ല: ഈ റിപ്പോസിറ്ററിയിൽ *ഇതിനകം ഇല്ലാത്ത* താൽപ്പര്യമുള്ള എന്തെങ്കിലും നിങ്ങൾ കണ്ടെത്തുകയാണെങ്കിൽ, നിങ്ങളുടെ ലിങ്ക് നിർദ്ദേശങ്ങളുമായി ഒരു [ഇഷ്യൂ (Issue)](https://github.com/EbookFoundation/free-programming-books/issues) തുറക്കുക.

      - നിങ്ങൾക്ക് Git അറിയാമെങ്കിൽ, ദയവായി ഈ റിപ്പോസിറ്ററി ഫോർക്ക് (Fork) ചെയ്ത് പുൾ റിക്വസ്റ്റുകൾ (PR) അയക്കുക.

3.  ഞങ്ങൾക്ക് 6 തരം ലിസ്റ്റുകളുണ്ട്. ശരിയായത് തിരഞ്ഞെടുക്കുക:

      - *പുസ്തകങ്ങൾ* : PDF, HTML, ePub, a gitbook.io അടിസ്ഥാനമാക്കിയുള്ള സൈറ്റ്, ഒരു Git റിപ്പോസിറ്ററി, മുതലായവ.
      - *കോഴ്‌സുകൾ* : ഒരു കോഴ്‌സ് എന്നത് പുസ്തകമല്ലാത്ത ഒരു പഠന സാമഗ്രിയാണ്. [ഇതൊരു കോഴ്‌സാണ്](http://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-006-introduction-to-algorithms-fall-2011/).
      - *ഇന്ററാക്ടീവ് ട്യൂട്ടോറിയലുകൾ* : ഉപയോക്താവിന് കോഡോ കമാൻഡുകളോ ടൈപ്പ് ചെയ്യാനും ഫലം വിലയിരുത്താനും അനുവദിക്കുന്ന ഒരു ഇന്ററാക്ടീവ് വെബ്സൈറ്റ് ("വിലയിരുത്തുക" എന്നതുകൊണ്ട് ഞങ്ങൾ "ഗ്രേഡ് ചെയ്യുക" എന്ന് അർത്ഥമാക്കുന്നില്ല). ഉദാഹരണത്തിന്: [Try Haskell](http://tryhaskell.org), [Try Git](https://learngitbranching.js.org).
      - *പ്ലേഗ്രൗണ്ടുകൾ* : പ്രോഗ്രാമിംഗ് പഠിക്കുന്നതിനുള്ള ഓൺലൈനും ഇന്ററാക്ടീവുമായ വെബ്സൈറ്റുകൾ, ഗെയിമുകൾ അല്ലെങ്കിൽ ഡെസ്ക്ടോപ്പ് സോഫ്റ്റ്‌വെയറുകൾ. കോഡ് സ്നിപ്പെറ്റുകൾ എഴുതുക, കംപൈൽ ചെയ്യുക (അല്ലെങ്കിൽ പ്രവർത്തിപ്പിക്കുക), പങ്കിടുക. പ്ലേഗ്രൗണ്ടുകൾ പലപ്പോഴും കോഡുമായി കളിക്കാനും പരിശീലിക്കാനും നിങ്ങളെ അനുവദിക്കുന്നു.
      - *പോഡ്‌കാസ്റ്റുകളും സ്ക്രീൻകാസ്റ്റുകളും* : പോഡ്‌കാസ്റ്റുകളും സ്ക്രീൻകാസ്റ്റുകളും.
      - *പ്രോബ്ലം സെറ്റുകളും കോമ്പറ്റീറ്റീവ് പ്രോഗ്രാമിംഗും* : ലളിതമോ സങ്കീർണ്ണമോ ആയ പ്രശ്നങ്ങൾ പരിഹരിച്ച്, കോഡ് റിവ്യൂവോടെയോ അല്ലാതെയോ, മറ്റ് ഉപയോക്താക്കളുമായി ഫലങ്ങൾ താരതമ്യം ചെയ്തുകൊണ്ടോ അല്ലാതെയോ നിങ്ങളുടെ പ്രോഗ്രാമിംഗ് കഴിവുകൾ വിലയിരുത്താൻ നിങ്ങളെ അനുവദിക്കുന്ന ഒരു വെബ്സൈറ്റ് അല്ലെങ്കിൽ സോഫ്റ്റ്‌വെയർ.

4.  [താഴെക്കൊടുത്തിരിക്കുന്ന മാർഗ്ഗനിർദ്ദേശങ്ങൾ](https://www.google.com/search?q=%23guidelines) പാലിക്കുകയും ഫയലുകളുടെ [മാർക്ക്ഡൗൺ ഫോർമാറ്റിംഗ്](https://www.google.com/search?q=%23formatting) മാനിക്കുകയും ചെയ്യുക.

5.  നിങ്ങളുടെ ലിസ്റ്റുകൾ **അക്ഷരമാലാക്രമത്തിലാണെന്നും** **ഫോർമാറ്റിംഗ് നിയമങ്ങൾ പാലിക്കുന്നുണ്ടെന്നും** ഉറപ്പാക്കാൻ GitHub Actions ടെസ്റ്റുകൾ പ്രവർത്തിപ്പിക്കും. നിങ്ങളുടെ മാറ്റങ്ങൾ ടെസ്റ്റുകളിൽ വിജയിക്കുന്നുണ്ടോയെന്ന് **ഉറപ്പാക്കുക**.

-----

### മാർഗ്ഗനിർദ്ദേശങ്ങൾ

  - പുസ്തകം സൗജന്യമാണെന്ന് ഉറപ്പാക്കുക. ആവശ്യമെങ്കിൽ ഒന്നുകൂടി പരിശോധിക്കുക. പുസ്തകം സൗജന്യമാണെന്ന് നിങ്ങൾ എന്തുകൊണ്ട് കരുതുന്നു എന്ന് PR-ൽ കമന്റ് ചെയ്യുന്നത് അഡ്മിൻമാർക്ക് സഹായകമാകും.
  - Google Drive, Dropbox, Mega, Scribd, Issuu തുടങ്ങിയ ഫയൽ അപ്‌ലോഡ് പ്ലാറ്റ്‌ഫോമുകളിൽ ഹോസ്റ്റ് ചെയ്ത ഫയലുകൾ ഞങ്ങൾ സ്വീകരിക്കില്ല.
  - നിങ്ങളുടെ ലിങ്കുകൾ [താഴെ](https://www.google.com/search?q=%23alphabetical-order) വിവരിച്ചിരിക്കുന്നതുപോലെ അക്ഷരമാലാക്രമത്തിൽ ചേർക്കുക.
  - ഏറ്റവും ആധികാരികമായ ഉറവിടമുള്ള ലിങ്ക് ഉപയോഗിക്കുക (അതായത്, എഡിറ്ററുടെ വെബ്സൈറ്റിനേക്കാൾ നല്ലത് മൂന്നാം കക്ഷി വെബ്സൈറ്റാണ് , അതിനേക്കാൾ നല്ലത് രചയിതാവിൻ്റെ വെബ്സൈറ്റാണ്).
      - ഫയൽ ഹോസ്റ്റിംഗ് സേവനങ്ങൾ പാടില്ല (ഇവയിൽ Dropbox, Google Drive ലിങ്കുകൾ ഉൾപ്പെടുന്നു, എന്നാൽ ഇവയിൽ മാത്രം പരിമിതപ്പെടുന്നില്ല).
  - ഒരേ ഡൊമെയ്‌നിലും ഒരേ ഉള്ളടക്കം നൽകുന്നിടത്തോളം കാലം, ഒരു `http` ലിങ്കിനേക്കാൾ എല്ലായ്പ്പോഴും ഒരു `https` ലിങ്കിന് മുൻഗണന നൽകുക.
  - റൂട്ട് ഡൊമെയ്‌നുകളിൽ, അവസാനമുള്ള സ്ലാഷ് (`/`) ഒഴിവാക്കുക: `http://example.com/` എന്നതിന് പകരം `http://example.com` എന്ന് ഉപയോഗിക്കുക.
  - എല്ലായ്പ്പോഴും ഏറ്റവും ചെറിയ ലിങ്കിന് മുൻഗണന നൽകുക: `http://example.com/dir/index.html` എന്നതിനേക്കാൾ നല്ലത് `http://example.com/dir/` ആണ്.
      - URL ഷോർട്ട്നർ ലിങ്കുകൾ പാടില്ല.
  - സാധാരണയായി "പതിപ്പ്" ലിങ്കിനേക്കാൾ "നിലവിലുള്ള" ലിങ്കിന് മുൻഗണന നൽകുക: `http://example.com/dir/book/v1.0.0/index.html` എന്നതിനേക്കാൾ നല്ലത് `http://example.com/dir/book/current/` ആണ്.
  - ഒരു ലിങ്കിന് കാലാവധി കഴിഞ്ഞ സർട്ടിഫിക്കറ്റ്/സെൽഫ്-സൈൻഡ് സർട്ടിഫിക്കറ്റ്/മറ്റേതെങ്കിലും SSL പ്രശ്നമുണ്ടെങ്കിൽ:
    1.  സാധ്യമെങ്കിൽ അതിനെ `http` പതിപ്പ് ഉപയോഗിച്ച് *മാറ്റിസ്ഥാപിക്കുക* (കാരണം മൊബൈൽ ഉപകരണങ്ങളിൽ എക്സെപ്ഷനുകൾ സ്വീകരിക്കുന്നത് സങ്കീർണ്ണമായേക്കാം).
    2.  `http` പതിപ്പ് ലഭ്യമല്ലെങ്കിലും ബ്രൗസറിൽ ഒരു എക്സെപ്ഷൻ ചേർത്തോ മുന്നറിയിപ്പ് അവഗണിച്ചോ `https` വഴി ലിങ്ക് ആക്‌സസ് ചെയ്യാൻ കഴിയുമെങ്കിൽ അത് *അതുപോലെ നിലനിർത്തുക*.
    3.  അല്ലെങ്കിൽ *നീക്കം ചെയ്യുക*.
  - ഒരു ലിങ്ക് ഒന്നിലധികം ഫോർമാറ്റുകളിൽ നിലവിലുണ്ടെങ്കിൽ, ഓരോ ഫോർമാറ്റിനെക്കുറിച്ചും ഒരു കുറിപ്പോടെ ഒരു പ്രത്യേക ലിങ്ക് ചേർക്കുക.
  - ഒരു റിസോഴ്സ് ഇന്റർനെറ്റിൽ പലയിടത്തും നിലവിലുണ്ടെങ്കിൽ
      - ഏറ്റവും ആധികാരികമായ ഉറവിടമുള്ള ലിങ്ക് ഉപയോഗിക്കുക (അതായത് രചയിതാവിൻ്റെ വെബ്സൈറ്റാണ് എഡിറ്ററുടെ വെബ്സൈറ്റിനേക്കാൾ നല്ലത്, അതാണ് ഒരു മൂന്നാം കക്ഷി വെബ്സൈറ്റിനേക്കാൾ നല്ലത്).
      - അവ വ്യത്യസ്ത എഡിഷനുകളിലേക്ക് ലിങ്ക് ചെയ്യുകയും, ആ എഡിഷനുകൾ സൂക്ഷിക്കാൻ മാത്രം വ്യത്യസ്തമാണെന്ന് നിങ്ങൾ കരുതുകയും ചെയ്യുന്നുവെങ്കിൽ, ഓരോ എഡിഷനെക്കുറിച്ചും ഒരു കുറിപ്പോടെ ഒരു പ്രത്യേക ലിങ്ക് ചേർക്കുക (ഫോർമാറ്റിംഗിനെക്കുറിച്ചുള്ള ചർച്ചയിൽ സംഭാവന നൽകാൻ [Issue \#2353](https://github.com/EbookFoundation/free-programming-books/issues/2353) കാണുക).
  - വലിയ കമ്മിറ്റുകളേക്കാൾ ആറ്റോമിക് കമ്മിറ്റുകൾക്ക് (ഓരോ കൂട്ടിച്ചേർക്കലിനും/ഇല്ലാതാക്കലിനും/മാറ്റത്തിനും ഒരു കമ്മിറ്റ്) മുൻഗണന നൽകുക. PR സമർപ്പിക്കുന്നതിന് മുമ്പ് നിങ്ങളുടെ കമ്മിറ്റുകൾ സ്ക്വാഷ് ചെയ്യേണ്ട ആവശ്യമില്ല. (ഈ നിയമം ഞങ്ങൾ ഒരിക്കലും നിർബന്ധിക്കില്ല, കാരണം ഇത് മെയിന്റനർമാരുടെ സൗകര്യത്തിന് മാത്രമുള്ളതാണ്).
  - പുസ്തകം പഴയതാണെങ്കിൽ, തലക്കെട്ടിനൊപ്പം പ്രസിദ്ധീകരിച്ച തീയതിയും ചേർക്കുക.
  - ഉചിതമായ സ്ഥലങ്ങളിൽ രചയിതാവിൻ്റെ പേരോ പേരുകളോ ഉൾപ്പെടുത്തുക. "`et al.`" ഉപയോഗിച്ച് രചയിതാക്കളുടെ പട്ടിക ചെറുതാക്കാം.
  - പുസ്തകം പൂർത്തിയായിട്ടില്ലെങ്കിൽ, ഇപ്പോഴും പണിപ്പുരയിലാണെങ്കിൽ, [താഴെ](https://www.google.com/search?q=%23in_process) വിവരിച്ചിരിക്കുന്നതുപോലെ "`in process`" എന്ന കുറിപ്പ് ചേർക്കുക.
  - ഒരു റിസോഴ്സ് [*Internet Archive's Wayback Machine*](https://web.archive.org) (അല്ലെങ്കിൽ സമാനമായത്) ഉപയോഗിച്ച് പുനഃസ്ഥാപിച്ചതാണെങ്കിൽ, [താഴെ](https://www.google.com/search?q=%23archived) വിവരിച്ചിരിക്കുന്നതുപോലെ "`archived`" എന്ന കുറിപ്പ് ചേർക്കുക. ഉപയോഗിക്കാൻ ഏറ്റവും നല്ലത് പുതിയതും പൂർണ്ണവുമായ പതിപ്പുകളാണ്.
  - ഡൗൺലോഡ് പ്രവർത്തനക്ഷമമാക്കുന്നതിന് മുമ്പ് ഒരു ഇമെയിൽ വിലാസമോ അക്കൗണ്ട് സജ്ജീകരണമോ ആവശ്യപ്പെടുകയാണെങ്കിൽ, ഭാഷയ്ക്ക് അനുയോജ്യമായ കുറിപ്പുകൾ ബ്രാക്കറ്റിൽ ചേർക്കുക, ഉദാ: `(ഇമെയിൽ വിലാസം *അഭ്യർത്ഥിച്ചത്*, ആവശ്യമില്ല)`.

-----

### ഫോർമാറ്റിംഗ്

  - എല്ലാ ലിസ്റ്റുകളും `.md` ഫയലുകളാണ്. [മാർക്ക്ഡൗൺ](https://guides.github.com/features/mastering-markdown/) സിന്റാക്സ് പഠിക്കാൻ ശ്രമിക്കുക. ഇത് ലളിതമാണ്\!
  - എല്ലാ ലിസ്റ്റുകളും ഒരു സൂചികയോടെ (Index) ആരംഭിക്കുന്നു. എല്ലാ വിഭാഗങ്ങളെയും ഉപവിഭാഗങ്ങളെയും അവിടെ ലിസ്റ്റ് ചെയ്യുകയും ലിങ്ക് ചെയ്യുകയുമാണ് ആശയം. ഇത് അക്ഷരമാലാക്രമത്തിൽ സൂക്ഷിക്കുക.
  - വിഭാഗങ്ങൾ ലെവൽ 3 ഹെഡിംഗുകളും (`###`), ഉപവിഭാഗങ്ങൾ ലെവൽ 4 ഹെഡിംഗുകളും (`####`) ആണ് ഉപയോഗിക്കുന്നത്.

ആശയം ഇതാണ്:

  - അവസാന ലിങ്കിനും പുതിയ വിഭാഗത്തിനും ഇടയിൽ `2` ശൂന്യമായ വരികൾ.
  - ഹെഡിംഗിനും അതിൻ്റെ വിഭാഗത്തിലെ ആദ്യ ലിങ്കിനും ഇടയിൽ `1` ശൂന്യമായ വരി.
  - രണ്ട് ലിങ്കുകൾക്കിടയിൽ `0` ശൂന്യമായ വരി.
  - ഓരോ `.md` ഫയലിൻ്റെയും അവസാനം `1` ശൂന്യമായ വരി.

ഉദാഹരണം:

```text
[...]
* [An Awesome Book](http://example.com/example.html)
                               (ഒഴിവ് വരി)
                               (ഒഴിവ് വരി)
### Example
                               (ഒഴിവ് വരി)
* [Another Awesome Book](http://example.com/book.html)
* [Some Other Book](http://example.com/other.html)
```

  - `]` നും `(` നും ഇടയിൽ സ്പെയ്സ് ഇടരുത്:

    ```text
    തെറ്റ്: * [Another Awesome Book] (http://example.com/book.html)
    ശരി: * [Another Awesome Book](http://example.com/book.html)
    ```

  - രചയിതാവിനെ ഉൾപ്പെടുത്തുകയാണെങ്കിൽ, `-` (ഇരുവശത്തും ഓരോ സ്പെയ്സുള്ള ഒരു ഡാഷ്) ഉപയോഗിക്കുക:

    ```text
    തെറ്റ്: * [Another Awesome Book](http://example.com/book.html)- John Doe
    ശരി: * [Another Awesome Book](http://example.com/book.html) - John Doe
    ```

  - ലിങ്കിനും അതിൻ്റെ ഫോർമാറ്റിനും ഇടയിൽ ഒരു സ്പെയ്സ് ഇടുക:

    ```text
    തെറ്റ്: * [A Very Awesome Book](https://example.org/book.pdf)(PDF)
    ശരി: * [A Very Awesome Book](https://example.org/book.pdf) (PDF)
    ```

  - രചയിതാവ് ഫോർമാറ്റിന് മുമ്പ് വരണം:

    ```text
    തെറ്റ്: * [A Very Awesome Book](https://example.org/book.pdf)- (PDF) Jane Roe
    ശരി: * [A Very Awesome Book](https://example.org/book.pdf) - Jane Roe (PDF)
    ```

  - ഒന്നിലധികം ഫോർമാറ്റുകൾ (ഓരോ റിസോഴ്സിനും ഒരൊറ്റ ലിങ്ക് നൽകാനാണ് ഞങ്ങൾ താൽപ്പര്യപ്പെടുന്നത്. വ്യത്യസ്ത ഫോർമാറ്റുകളിലേക്ക് എളുപ്പത്തിൽ ആക്‌സസ് ഉള്ള ഒരൊറ്റ ലിങ്ക് ഇല്ലാത്തപ്പോൾ, ഒന്നിലധികം ലിങ്കുകൾക്ക് അർത്ഥമുണ്ടാകാം. എന്നാൽ ഞങ്ങൾ ചേർക്കുന്ന ഓരോ ലിങ്കും പരിപാലന ഭാരം വർദ്ധിപ്പിക്കുന്നു, അതിനാൽ ഞങ്ങൾ അത് ഒഴിവാക്കാൻ ശ്രമിക്കുന്നു.):

    ```text
    തെറ്റ്: * [Another Awesome Book](http://example.com/)- John Doe (HTML)
    തെറ്റ്: * [Another Awesome Book](https://downloads.example.org/book.html)- John Doe (download site)
    ശരി: * [Another Awesome Book](http://example.com/) - John Doe (HTML) [(PDF, EPUB)](https://downloads.example.org/book.html)
    ```

  - പഴയ പുസ്തകങ്ങൾക്ക് തലക്കെട്ടിൽ പ്രസിദ്ധീകരണ വർഷം ഉൾപ്പെടുത്തുക:

    ```text
    തെറ്റ്: * [A Very Awesome Book](https://example.org/book.html) - Jane Roe - 1970
    ശരി: * [A Very Awesome Book (1970)](https://example.org/book.html) - Jane Roe
    ```

  - \<a id="in\_process"\>\</a\>പണിപ്പുരയിലുള്ള പുസ്തകങ്ങൾ:

    ```text
    ശരി: * [Will Be An Awesome Book Soon](http://example.com/book2.html) - John Doe (HTML) *( :construction: in process)*
    ```

  - \<a id="archived"\>\</a\>ആർക്കൈവ് ചെയ്ത ലിങ്ക്:

    ```text
    ശരി: * [A Way-backed Interesting Book](https://web.archive.org/web/20211016123456/http://example.com/) - John Doe (HTML) *( :card_file_box: archived)*
    ```

  - \<a id="license"\>\</a\>സൗജന്യ ലൈസൻസുകൾ (വായിക്കാൻ സൗജന്യമായതും എന്നാൽ "എല്ലാ അവകാശങ്ങളും നിക്ഷിപ്‌തവുമാണ്" എന്ന വിഭാഗത്തിൽ വരുന്നതുമായ റിസോഴ്‌സുകൾ ഞങ്ങൾ ഉൾപ്പെടുത്തുന്നുണ്ടെങ്കിലും, ക്രിയേറ്റീവ് കോമൺസ് പോലുള്ള സൗജന്യ ലൈസൻസുകളുടെ ഉപയോഗത്തെ ഞങ്ങൾ പ്രോത്സാഹിപ്പിക്കുന്നു):

    ```text
    ശരി: * [A Very Awesome Book](https://example.org/book.pdf) - Jane Roe (PDF) (CC BY-SA)
    ```

    പിന്തുണയ്ക്കുന്ന ലൈസൻസുകൾ (പതിപ്പ് നമ്പർ ഇല്ലാതെ):

      - `CC BY` 'ക്രിയേറ്റീവ് കോമൺസ് ആട്രിബ്യൂഷൻ'
      - `CC BY-NC` 'ക്രിയേറ്റീവ് കോമൺസ് നോൺ-കൊമേർഷ്യൽ'
      - `CC BY-SA` 'ക്രിയേറ്റീവ് കോമൺസ് ഷെയർ-എലൈക്ക്'
      - `CC BY-NC-SA` 'ക്രിയേറ്റീവ് കോമൺസ് നോൺ-കൊമേർഷ്യൽ, ഷെയർ-എലൈക്ക്'
      - `CC BY-ND` 'ക്രിയേറ്റീവ് കോമൺസ് നോ-ഡെറിവേറ്റീവ്സ്'
      - `CC BY-NC-ND` 'ക്രിയേറ്റീവ് കോമൺസ് നോൺ-കൊമേർഷ്യൽ, നോ-ഡെറിവേറ്റീവ്സ്'
      - `GFDL` 'ഗ്നു ഫ്രീ ഡോക്യുമെന്റേഷൻ ലൈസൻസ്'

#### ഒരു ലൈസൻസ് കുറിപ്പ് ചേർക്കുന്നു (ഘട്ടം ഘട്ടമായി)

ഒരു റിസോഴ്സ് സൗജന്യ/ഓപ്പൺ ലൈസൻസിന് കീഴിൽ വിതരണം ചെയ്യുമ്പോൾ, ഫോർമാറ്റ് കുറിപ്പിന് ശേഷം ബ്രാക്കറ്റിൽ ഒരു ചെറിയ ലൈസൻസ് കുറിപ്പ് ചേർക്കുക. ഈ ഘട്ടങ്ങൾ പാലിക്കുക:

1.  റിസോഴ്സ് പേജിൽ ലൈസൻസ് സ്ഥിരീകരിക്കുക.
      - സൈറ്റിന്റെ അടിക്കുറിപ്പ്, "ഞങ്ങളെപ്പറ്റി" (About) പേജ്, അല്ലെങ്കിൽ ഒരു LICENSE/Legal വിഭാഗം എന്നിവ നോക്കുക.
      - സൗജന്യ/ഓപ്പൺ ഉള്ളടക്ക ലൈസൻസുകൾക്ക് മാത്രം ലൈസൻസ് കുറിപ്പുകൾ ചേർക്കുക (മുകളിലുള്ള പിന്തുണയ്ക്കുന്ന ലിസ്റ്റ് കാണുക). "എല്ലാ അവകാശങ്ങളും നിക്ഷിപ്‌തം" (All Rights Reserved) പോലുള്ള കുറിപ്പുകൾ ചേർക്കരുത്.
2.  ലൈസൻസ് സ്ട്രിംഗ്, പതിപ്പ് നമ്പർ ഇല്ലാതെ പിന്തുണയ്ക്കുന്ന ഷോർട്ട് കോഡുകളിലൊന്നിലേക്ക് മാറ്റുക.
      - ഉദാഹരണങ്ങൾ: "Creative Commons Attribution 4.0" → `CC BY`; "CC BY-SA 3.0" → `CC BY-SA`; "GNU Free Documentation License" → `GFDL`.
3.  ലൈസൻസ് ഫോർമാറ്റി(കൾ)ന് ശേഷവും മറ്റേതെങ്കിലും കുറിപ്പുകൾക്ക് മുമ്പും സ്ഥാപിക്കുക.
      - ഒരൊറ്റ ഫോർമാറ്റ്:
        ```markdown
        * [A Very Awesome Book](https://example.org/book-ml.pdf) - Jane Roe (PDF) (CC BY-SA)
        ```
      - ഒന്നിലധികം ഫോർമാറ്റുകൾ:
        ```markdown
        * [Awesome Guide](https://example.org/) - Jane Roe (HTML, PDF) (CC BY)
        ```
      - ഒരു അധിക കുറിപ്പോടൊപ്പം (ഉദാ., ആർക്കൈവ് ചെയ്തത് അല്ലെങ്കിൽ പണിപ്പുരയിലുള്ളത്):
        ```markdown
        * [Old but Gold](https://web.archive.org/web/20211016123456/http://example.com/) - John Doe (HTML) (CC BY) *( :card_file_box: archived)*
        ```
4.  വ്യത്യസ്ത എഡിഷനുകൾക്കോ ഫോർമാറ്റുകൾക്കോ വ്യത്യസ്ത ലൈസൻസുകളുണ്ടെങ്കിൽ, അവയെ പ്രത്യേക ഇനങ്ങളായി ലിസ്റ്റ് ചെയ്യുകയും ഓരോ എൻട്രിയിലും ശരിയായ ലൈസൻസ് രേഖപ്പെടുത്തുകയും ചെയ്യുക.
5.  നിങ്ങൾക്ക് ഉറപ്പില്ലെങ്കിൽ, എന്തുകൊണ്ടാണ് റിസോഴ്സ് ഒരു സൗജന്യ ലൈസൻസിന് കീഴിലാണെന്ന് നിങ്ങൾ വിശ്വസിക്കുന്നതെന്നും എവിടെ നിന്നാണ് നിങ്ങൾക്ക് വിവരം ലഭിച്ചതെന്നും വിശദീകരിച്ച് നിങ്ങളുടെ PR-ൽ ഒരു കമന്റ് ചേർക്കുക.

-----

### അക്ഷരമാലാക്രമം

  - ഒരേ അക്ഷരത്തിൽ തുടങ്ങുന്ന ഒന്നിലധികം തലക്കെട്ടുകളുണ്ടെങ്കിൽ, അവയെ രണ്ടാമത്തെ അക്ഷരം അനുസരിച്ച് ക്രമീകരിക്കുക, അങ്ങനെ തുടരുക. ഉദാഹരണത്തിന്: `ab`-ക്ക് മുമ്പ് `aa` വരുന്നു.
  - `onetwo`-ക്ക് മുമ്പ് `one two` വരുന്നു.

ഒരു ലിങ്ക് തെറ്റായ സ്ഥാനത്ത് കണ്ടാല്‍, ഏത് വരികളാണ് പരസ്പരം മാറ്റേണ്ടതെന്ന് അറിയാൻ ലിൻറ്റർ പിശക് സന്ദേശം പരിശോധിക്കുക.

-----

### കുറിപ്പുകൾ

അടിസ്ഥാനകാര്യങ്ങൾ താരതമ്യേന ലളിതമാണെങ്കിലും, ഞങ്ങൾ ലിസ്റ്റ് ചെയ്യുന്ന റിസോഴ്‌സുകളിൽ വലിയ വൈവിധ്യമുണ്ട്. ഈ വൈവിധ്യത്തെ ഞങ്ങൾ എങ്ങനെ കൈകാര്യം ചെയ്യുന്നു എന്നതിനെക്കുറിച്ചുള്ള ചില കുറിപ്പുകൾ ഇതാ.

#### മെറ്റാഡാറ്റ

ഞങ്ങളുടെ ലിസ്റ്റുകൾ ഒരു മിനിമം മെറ്റാഡാറ്റ നൽകുന്നു: തലക്കെട്ടുകൾ, URL-കൾ, രചയിതാക്കൾ, പ്ലാറ്റ്‌ഫോമുകൾ, ആക്‌സസ് കുറിപ്പുകൾ.

##### തലക്കെട്ടുകൾ

  - കൃത്രിമമായ തലക്കെട്ടുകൾ വേണ്ട. ഞങ്ങൾ റിസോഴ്‌സുകളിൽ നിന്ന് തന്നെ തലക്കെട്ടുകൾ എടുക്കാൻ ശ്രമിക്കുന്നു; സാധിക്കുമെങ്കിൽ തലക്കെട്ടുകൾ ഉണ്ടാക്കാനോ എഡിറ്റോറിയലായി ഉപയോഗിക്കാനോ സംഭാവന ചെയ്യുന്നവരെ ഞങ്ങൾ അനുവദിക്കുന്നില്ല. പഴയ കൃതികൾക്ക് ഒരു അപവാദമുണ്ട്; അവയ്ക്ക് പ്രധാനമായും ചരിത്രപരമായ താൽപ്പര്യമാണെങ്കിൽ, തലക്കെട്ടിനോട് ചേർന്ന് ബ്രാക്കറ്റിൽ വർഷം നൽകുന്നത് ഉപയോക്താക്കൾക്ക് താൽപ്പര്യമുണ്ടോ എന്ന് ತಿಳಿಯാൻ സഹായിക്കുന്നു.
  - എല്ലാം വലിയക്ഷരത്തിലുള്ള (ALLCAPS) തലക്കെട്ടുകൾ വേണ്ട. സാധാരണയായി ടൈറ്റിൽ കേസ് ആണ് ഉചിതം, എന്നാൽ സംശയമുണ്ടെങ്കിൽ ഉറവിടത്തിൽ നിന്നുള്ള വലിയക്ഷരം ഉപയോഗിക്കുക.
  - ഇമോജികൾ വേണ്ട.

##### URL-കൾ

  - ചുരുക്കിയ URL-കൾ ഞങ്ങൾ അനുവദിക്കുന്നില്ല.
  - ട്രാക്കിംഗ് കോഡുകൾ URL-ൽ നിന്ന് നീക്കം ചെയ്യണം.
  - അന്താരാഷ്ട്ര URL-കൾ എസ്കേപ്പ് ചെയ്യണം. ബ്രൗസർ ബാറുകൾ സാധാരണയായി ഇവ യൂണിക്കോഡിലേക്ക് റെൻഡർ ചെയ്യുന്നു, പക്ഷേ ദയവായി കോപ്പി പേസ്റ്റ് ഉപയോഗിക്കുക.
  - HTTPS നടപ്പിലാക്കിയിട്ടുള്ളയിടങ്ങളിൽ സുരക്ഷിതമല്ലാത്ത (`http`) URL-കളേക്കാൾ എല്ലായ്പ്പോഴും സുരക്ഷിതമായ (`https`) URL-കൾക്ക് മുൻഗണന നൽകുന്നു.
  - ലിസ്റ്റ് ചെയ്ത റിസോഴ്സ് ഹോസ്റ്റ് ചെയ്യാത്തതും പകരം മറ്റെവിടെയെങ്കിലും പോയിന്റ് ചെയ്യുന്നതുമായ വെബ്‌പേജുകളിലേക്കുള്ള URL-കൾ ഞങ്ങൾക്ക് ഇഷ്ടമല്ല.

##### രചയിതാക്കൾ

  - പരിഭാഷകർ ഉൾപ്പെടെ, സൗജന്യ റിസോഴ്സുകളുടെ രചയിതാക്കൾക്ക് ക്രെഡിറ്റ് നൽകാൻ ഞങ്ങൾ ആഗ്രഹിക്കുന്നു\!

  - വിവർത്തനം ചെയ്ത കൃതികൾക്ക് യഥാർത്ഥ രചയിതാവിന് ക്രെഡിറ്റ് നൽകണം. രചയിതാക്കൾക്ക് പുറമെയുള്ളവരെ ക്രെഡിറ്റ് ചെയ്യാൻ [MARC റിലേറ്ററുകൾ](https://loc.gov/marc/relators/relaterm.html) ഉപയോഗിക്കാൻ ഞങ്ങൾ ശുപാർശ ചെയ്യുന്നു, ഈ ഉദാഹരണത്തിലെന്നപോലെ:

    ```markdown
    * [A Translated Book](http://example.com/book.html) - John Doe, `trl.:` Mike The Translator
    ```

    ഇവിടെ, `trl.:` എന്ന വ്യാഖ്യാനം "പരിഭാഷകൻ" (translator) എന്നതിനായുള്ള MARC റിലേറ്റർ കോഡ് ഉപയോഗിക്കുന്നു.

  - രചയിതാക്കളുടെ പട്ടികയിലെ ഓരോ ഇനത്തെയും വേർതിരിക്കാൻ കോമ (`,`) ഉപയോഗിക്കുക.

  - "`et al.`" ഉപയോഗിച്ച് രചയിതാക്കളുടെ പട്ടിക ചെറുതാക്കാം.

  - രചയിതാക്കൾക്ക് ലിങ്കുകൾ ഞങ്ങൾ അനുവദിക്കുന്നില്ല.

  - സമാഹാരങ്ങൾക്കോ റീമിക്സ് ചെയ്ത കൃതികൾക്കോ, "രചയിതാവിന്" ഒരു വിവരണം ആവശ്യമായി വന്നേക്കാം. ഉദാഹരണത്തിന്, "GoalKicker" അല്ലെങ്കിൽ "RIP Tutorial" പുസ്തകങ്ങൾക്ക് "`Compiled from StackOverflow documentation`" എന്ന് ക്രെഡിറ്റ് നൽകുന്നു.

  - "പ്രൊഫ." അല്ലെങ്കിൽ "ഡോ." പോലുള്ള ബഹുമതികൾ രചയിതാക്കളുടെ പേരുകളിൽ ഞങ്ങൾ ഉൾപ്പെടുത്തുന്നില്ല.

##### സമയബന്ധിതമായ കോഴ്‌സുകളും ട്രയലുകളും

  - ആറുമാസത്തിനുള്ളിൽ നീക്കം ചെയ്യേണ്ട കാര്യങ്ങൾ ഞങ്ങൾ ലിസ്റ്റ് ചെയ്യുന്നില്ല.
  - ഒരു കോഴ്സിന് പരിമിതമായ എൻറോൾമെന്റ് കാലയളവോ ദൈർഘ്യമോ ഉണ്ടെങ്കിൽ, ഞങ്ങൾ അത് ലിസ്റ്റ് ചെയ്യില്ല.
  - ഒരു നിശ്ചിത കാലയളവിലേക്ക് സൗജന്യമായ റിസോഴ്സുകൾ ഞങ്ങൾക്ക് ലിസ്റ്റ് ചെയ്യാൻ കഴിയില്ല.

##### പ്ലാറ്റ്‌ഫോമുകളും ആക്‌സസ് കുറിപ്പുകളും

  - കോഴ്‌സുകൾ. പ്രത്യേകിച്ച് ഞങ്ങളുടെ കോഴ്‌സ് ലിസ്റ്റുകൾക്ക്, പ്ലാറ്റ്‌ഫോം റിസോഴ്സ് വിവരണത്തിന്റെ ഒരു പ്രധാന ഭാഗമാണ്. കാരണം കോഴ്‌സ് പ്ലാറ്റ്‌ഫോമുകൾക്ക് വ്യത്യസ്ത സൗകര്യങ്ങളും ആക്‌സസ് മാതൃകകളുമുണ്ട്. രജിസ്ട്രേഷൻ ആവശ്യമുള്ള ഒരു പുസ്തകം ഞങ്ങൾ സാധാരണയായി ലിസ്റ്റ് ചെയ്യില്ലെങ്കിലും, പല കോഴ്‌സ് പ്ലാറ്റ്‌ഫോമുകൾക്കും ഒരുതരം അക്കൗണ്ട് ഇല്ലാതെ പ്രവർത്തിക്കാത്ത സൗകര്യങ്ങളുണ്ട്. ഉദാഹരണ കോഴ്‌സ് പ്ലാറ്റ്‌ഫോമുകളിൽ Coursera, EdX, Udacity, Udemy എന്നിവ ഉൾപ്പെടുന്നു. ഒരു കോഴ്‌സ് ഒരു പ്ലാറ്റ്‌ഫോമിനെ ആശ്രയിക്കുമ്പോൾ, പ്ലാറ്റ്‌ഫോമിന്റെ പേര് ബ്രാക്കറ്റിൽ ലിസ്റ്റ് ചെയ്യണം.
  - YouTube. YouTube പ്ലേലിസ്റ്റുകൾ അടങ്ങുന്ന നിരവധി കോഴ്‌സുകൾ ഞങ്ങൾക്കുണ്ട്. ഞങ്ങൾ YouTube-നെ ഒരു പ്ലാറ്റ്‌ഫോമായി ലിസ്റ്റ് ചെയ്യുന്നില്ല, പകരം YouTube സ്രഷ്ടാവിനെ ലിസ്റ്റ് ചെയ്യാൻ ഞങ്ങൾ ശ്രമിക്കുന്നു, അത് പലപ്പോഴും ഒരു ഉപ-പ്ലാറ്റ്‌ഫോമാണ്.
  - YouTube വീഡിയോകൾ. ഒരു മണിക്കൂറിൽ കൂടുതൽ ദൈർഘ്യമുള്ളതും ഒരു കോഴ്‌സ് അല്ലെങ്കിൽ ട്യൂട്ടോറിയൽ പോലെ ഘടനാപരമല്ലാത്തതുമായ വ്യക്തിഗത YouTube വീഡിയോകളിലേക്ക് ഞങ്ങൾ സാധാരണയായി ലിങ്ക് ചെയ്യാറില്ല. അങ്ങനെയെങ്കിൽ, PR വിവരണത്തിൽ അത് കുറിക്കുന്നത് ഉറപ്പാക്കുക.
  - ചുരുക്കിയ (അതായത് youtu.be/xxxx) ലിങ്കുകൾ പാടില്ല\!
  - Leanpub. Leanpub വൈവിധ്യമാർന്ന ആക്‌സസ് മാതൃകകളുള്ള പുസ്തകങ്ങൾ ഹോസ്റ്റ് ചെയ്യുന്നു. ചിലപ്പോൾ ഒരു പുസ്തകം രജിസ്ട്രേഷൻ ഇല്ലാതെ വായിക്കാം; ചിലപ്പോൾ സൗജന്യ ആക്‌സസ്സിനായി ഒരു Leanpub അക്കൗണ്ട് ആവശ്യമാണ്. പുസ്തകങ്ങളുടെ ഗുണനിലവാരവും Leanpub ആക്‌സസ് മാതൃകകളുടെ മിശ്രിതവും ചാഞ്ചാട്ടവും കണക്കിലെടുത്ത്, `*(Leanpub അക്കൗണ്ട് അല്ലെങ്കിൽ സാധുവായ ഇമെയിൽ ആവശ്യപ്പെട്ടേക്കാം)*` എന്ന ആക്‌സസ് കുറിപ്പോടെ രണ്ടാമത്തേത് ലിസ്റ്റ് ചെയ്യാൻ ഞങ്ങൾ അനുവദിക്കുന്നു.

#### വിഭാഗങ്ങൾ

ഒരു റിസോഴ്സ് ഏത് ലിസ്റ്റിൽ പെടുന്നു എന്ന് തീരുമാനിക്കുന്നതിനുള്ള ആദ്യ നിയമം, ആ റിസോഴ്സ് സ്വയം എങ്ങനെ വിവരിക്കുന്നു എന്ന് നോക്കുക എന്നതാണ്. അത് സ്വയം ഒരു പുസ്തകം എന്ന് വിളിക്കുന്നുവെങ്കിൽ, ഒരുപക്ഷേ അതൊരു പുസ്തകമായിരിക്കും.

##### ഞങ്ങൾ ലിസ്റ്റ് ചെയ്യാത്ത വിഭാഗങ്ങൾ

ഇന്റർനെറ്റ് വിശാലമായതിനാൽ, ഞങ്ങളുടെ ലിസ്റ്റുകളിൽ ഞങ്ങൾ ഇവ ഉൾപ്പെടുത്തുന്നില്ല:

  - ബ്ലോഗുകൾ
  - ബ്ലോഗ് പോസ്റ്റുകൾ
  - ലേഖനങ്ങൾ
  - വെബ്സൈറ്റുകൾ (ഞങ്ങൾ ലിസ്റ്റ് ചെയ്യുന്ന ധാരാളം ഇനങ്ങൾ ഹോസ്റ്റ് ചെയ്യുന്നവ ഒഴികെ).
  - കോഴ്‌സുകളോ സ്ക്രീൻകാസ്റ്റുകളോ അല്ലാത്ത വീഡിയോകൾ.
  - പുസ്തക അധ്യായങ്ങൾ
  - പുസ്തകങ്ങളിൽ നിന്നുള്ള ടീസർ സാമ്പിളുകൾ
  - IRC അല്ലെങ്കിൽ ടെലിഗ്രാം ചാനലുകൾ
  - സ്ലാക്കുകൾ അല്ലെങ്കിൽ മെയിലിംഗ് ലിസ്റ്റുകൾ

ഞങ്ങളുടെ കോമ്പറ്റീറ്റീവ് പ്രോഗ്രാമിംഗ് ലിസ്റ്റുകൾ ഈ ഒഴിവാക്കലുകളെക്കുറിച്ച് അത്ര കർശനമല്ല. റിപ്പോസിറ്ററിയുടെ വ്യാപ്തി കമ്മ്യൂണിറ്റിയാണ് നിർണ്ണയിക്കുന്നത്; വ്യാപ്തിയിൽ മാറ്റമോ കൂട്ടിച്ചേർക്കലോ നിർദ്ദേശിക്കാൻ നിങ്ങൾ ആഗ്രഹിക്കുന്നുവെങ്കിൽ, ദയവായി നിർദ്ദേശം നൽകാൻ ഒരു ഇഷ്യൂ ഉപയോഗിക്കുക.

##### പുസ്തകങ്ങളും മറ്റുള്ളവയും

പുസ്തകത്തിന്റെ കാര്യത്തിൽ ഞങ്ങൾ അത്ര കർശനക്കാരല്ല. ഒരു റിസോഴ്സ് ഒരു പുസ്തകമാണെന്ന് സൂചിപ്പിക്കുന്ന ചില ഗുണവിശേഷങ്ങൾ ഇതാ:

  - അതിന് ഒരു ISBN (ഇന്റർനാഷണൽ സ്റ്റാൻഡേർഡ് ബുക്ക് നമ്പർ) ഉണ്ട്
  - അതിന് ഒരു ഉള്ളടക്ക പട്ടികയുണ്ട്
  - ഡൗൺലോഡ് ചെയ്യാവുന്ന ഒരു പതിപ്പ് വാഗ്ദാനം ചെയ്യുന്നു, പ്രത്യേകിച്ച് ePub ഫയലുകൾ.
  - അതിന് പതിപ്പുകളുണ്ട്
  - അത് ഇന്ററാക്ടീവ് ഉള്ളടക്കത്തെയോ വീഡിയോകളെയോ ആശ്രയിക്കുന്നില്ല
  - അത് ഒരു വിഷയത്തെ സമഗ്രമായി ഉൾക്കൊള്ളാൻ ശ്രമിക്കുന്നു
  - അത് സ്വയം പൂർണ്ണമാണ്

ഈ ഗുണവിശേഷങ്ങൾ ഇല്ലാത്ത ധാരാളം പുസ്തകങ്ങൾ ഞങ്ങൾ ലിസ്റ്റ് ചെയ്യുന്നുണ്ട്; അത് സാഹചര്യത്തെ ആശ്രയിച്ചിരിക്കും.

##### പുസ്തകങ്ങളും കോഴ്‌സുകളും

ചിലപ്പോൾ ഇവയെ വേർതിരിച്ചറിയാൻ പ്രയാസമാണ്\!

കോഴ്‌സുകൾക്ക് പലപ്പോഴും അനുബന്ധ പാഠപുസ്തകങ്ങൾ ഉണ്ടാകും, അവ ഞങ്ങൾ ഞങ്ങളുടെ പുസ്തക ലിസ്റ്റുകളിൽ ഉൾപ്പെടുത്തും. കോഴ്‌സുകൾക്ക് പ്രഭാഷണങ്ങൾ, വ്യായാമങ്ങൾ, ടെസ്റ്റുകൾ, കുറിപ്പുകൾ അല്ലെങ്കിൽ മറ്റ് ഉപദേശപരമായ സഹായങ്ങൾ എന്നിവയുണ്ട്. ഒരൊറ്റ പ്രഭാഷണമോ വീഡിയോയോ ഒരു കോഴ്‌സല്ല. ഒരു പവർപോയിന്റ് ഒരു കോഴ്‌സല്ല.

##### ഇന്ററാക്ടീവ് ട്യൂട്ടോറിയലുകളും മറ്റുള്ളവയും

അത് പ്രിന്റ് ചെയ്‌തെടുത്തിട്ടും അതിന്റെ സത്ത നിലനിർത്താൻ കഴിയുമെങ്കിൽ, അതൊരു ഇന്ററാക്ടീവ് ട്യൂട്ടോറിയൽ അല്ല.

-----

### ഓട്ടോമേഷൻ

  - ഫോർമാറ്റിംഗ് നിയമങ്ങൾ നടപ്പിലാക്കുന്നത് [GitHub Actions](https://github.com/features/actions) വഴി [fpb-lint](https://github.com/vhf/free-programming-books-lint) ഉപയോഗിച്ച് ഓട്ടോമേറ്റ് ചെയ്തിരിക്കുന്നു (കാണുക [`.github/workflows/fpb-lint.yml`](https://www.google.com/search?q=../.github/workflows/fpb-lint.yml))

  - URL മൂല്യനിർണ്ണയത്തിന് [awesome\_bot](https://github.com/dkhamsing/awesome_bot) ഉപയോഗിക്കുന്നു

  - URL മൂല്യനിർണ്ണയം ട്രിഗർ ചെയ്യുന്നതിന്, `check_urls=file_to_check` എന്ന് അടങ്ങുന്ന ഒരു കമ്മീറ്റ് സന്ദേശമുള്ള ഒരു കമ്മീറ്റ് പുഷ് ചെയ്യുക:

    ```properties
    check_urls=free-programming-books.md free-programming-books-ml.md
    ```

  - ഓരോ എൻട്രിയും വേർതിരിക്കാൻ ഒരൊറ്റ സ്പെയ്സ് ഉപയോഗിച്ച്, പരിശോധിക്കാൻ ഒന്നിലധികം ഫയലുകൾ നിങ്ങൾക്ക് വ്യക്തമാക്കാം.

  - നിങ്ങൾ ഒന്നിലധികം ഫയലുകൾ വ്യക്തമാക്കുകയാണെങ്കിൽ, ബിൽഡിന്റെ ഫലങ്ങൾ അവസാനമായി പരിശോധിച്ച ഫയലിന്റെ ഫലത്തെ അടിസ്ഥാനമാക്കിയുള്ളതായിരിക്കും. ഇത് കാരണം നിങ്ങൾക്ക് പാസാകുന്ന പച്ച ബിൽഡുകൾ ലഭിച്ചേക്കാം എന്നതിനെക്കുറിച്ച് നിങ്ങൾ ബോധവാനായിരിക്കണം, അതിനാൽ പുൾ റിക്വസ്റ്റിന്റെ അവസാനം "Show all checks" -\> "Details" ക്ലിക്ക് ചെയ്ത് ബിൽഡ് ലോഗ് പരിശോധിക്കുന്നത് ഉറപ്പാക്കുക.

-----

### RTL/LTR ലിൻറ്റർ പിശകുകൾ തിരുത്തുന്നു

നിങ്ങൾ RTL/LTR മാർക്ക്ഡൗൺ ലിൻറ്റർ (`*-ar.md`, `*-he.md`, `*-fa.md`, `*-ur.md` ഫയലുകളിൽ) പ്രവർത്തിപ്പിക്കുകയും പിശകുകളോ മുന്നറിയിപ്പുകളോ കാണുകയാണെങ്കിൽ:

  - RTL ടെക്സ്റ്റിലെ **LTR വാക്കുകൾ** (ഉദാ. “HTML”, “JavaScript”): ഓരോ LTR സെഗ്‌മെന്റിനും ശേഷം ഉടൻ `&rlm;` ചേർക്കുക;
  - **LTR ചിഹ്നങ്ങൾ** (ഉദാ. “C\#”, “C++”): ഓരോ LTR ചിഹ്നത്തിനും ശേഷം ഉടൻ `&lrm;` ചേർക്കുക;

#### ഉദാഹരണങ്ങൾ

**തെറ്റ്**

```html
<div dir="rtl" markdown="1">
* [كتاب الأمثلة في R](URL) - John Doe (PDF)
</div>
```

**ശരി**

```html
<div dir="rtl" markdown="1">
* [كتاب الأمثلة في R&rlm;](URL) - John Doe&rlm; (PDF)
</div>
```

-----

**തെറ്റ്**

```html
<div dir="rtl" markdown="1">
* [Tech Podcast - بودكاست المثال](URL) – Ahmad Hasan, محمد علي
</div>
```

**ശരി**

```html
<div dir="rtl" markdown="1">
* [Tech Podcast - بودكاست المثال](URL) – Ahmad Hasan,&rlm; محمد علي
</div>
```

-----

**തെറ്റ്**

```html
<div dir="rtl" markdown="1">
* [أساسيات C#](URL)
</div>
```

**ശരി**

```html
<div dir="rtl" markdown="1">
* [أساسيات C#&lrm;](URL)
</div>
```