*[यसलाई अन्य भाषाहरूमा पढ्नुहोस्](README.md#translations)*


## योगदानकर्ता लाइसेन्स सम्झौता

योगदान गरेर तपाईं यस भण्डारको [लाइसेन्स](../LICENSE) मा सहमत हुनुहुन्छ।


## योगदानकर्ता आचार संहिता

योगदान गरेर तपाईं यस भण्डारको [आचार संहिता](CODE_OF_CONDUCT.md) को सम्मान गर्न सहमत हुनुहुन्छ। ([अनुवाद](README.md#translations))


## संक्षेपमा

1. "पुस्तक सजिलै डाउनलोड गर्ने लिङ्क" सधैं *नि:शुल्क* पुस्तकको लिङ्क होइन। कृपया नि:शुल्क सामग्री मात्र योगदान गर्नुहोस्। सुनिश्चित गर्नुहोस् कि यो निःशुल्क छ। हामी पुस्तकहरू प्राप्त गर्न *आवश्यक* काम गर्ने इमेल ठेगानाहरू पृष्ठहरूमा लिङ्कहरू स्वीकार गर्दैनौं, तर हामी तिनीहरूलाई अनुरोध गर्ने सूचीहरूलाई स्वागत गर्दछौं।

2. तपाईंले Git जान्न आवश्यक छैन: यदि तपाईंले चासोको केहि फेला पार्नुभयो जुन * यस रिपोमा पहिले नै छैन *, कृपया एउटा [समस्या](https://github.com/EbookFoundation/free-programming-books/issues) खोल्नुहोस् तपाईंको लिङ्क प्रस्तावहरूको साथ।
    - यदि तपाइँ Git जान्नुहुन्छ भने, कृपया रिपो फोर्क गर्नुहोस् र पुल अनुरोधहरू (PR) पठाउनुहोस्।

3. हामीसँग 6 प्रकारका सूचीहरू छन्। सही एक छान्नुहोस्:

    - *पुस्तकहरू* : PDF, HTML, ePub, एक gitbook.io आधारित साइट, एक Git repo, आदि।
    - *पाठ्यक्रम* : पाठ्यक्रम एउटा सिकाइ सामग्री हो जुन किताब होइन। [यो पाठ्यक्रम हो](http://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-006-introduction-to-algorithms-fall-2011/).
    - *अन्तर्क्रियात्मक ट्यूटोरियल* : एक अन्तरक्रियात्मक वेबसाइट जसले प्रयोगकर्ता टाइप कोड वा आदेशहरू र परिणाम मूल्याङ्कन गर्न दिन्छ ("मूल्याङ्कन" द्वारा हामीले "ग्रेड" भनेको होइन)। जस्तै: [हास्केल प्रयास गर्नुहोस्](http://tryhaskell.org), [GitHub प्रयास गर्नुहोस्](http://try.github.io).
    - *प्लेग्राउन्डहरू* : अनलाइन र अन्तरक्रियात्मक वेबसाइटहरू, गेमहरू वा डेस्कटप सफ्टवेयरहरू प्रोग्रामिङ सिक्नका लागि हुन्। कोड स्निपेटहरू लेख्नुहोस्, कम्पाइल गर्नुहोस् (वा चलाउनुहोस्), र साझेदारी गर्नुहोस्। खेल मैदानहरूले प्राय: तपाईंलाई फोर्क गर्न र कोडसँग खेलेर आफ्ना हातहरू फोहोर गर्न अनुमति दिन्छ।
    - *पोडकास्टहरू र स्क्रिनकास्टहरू*: पोडकास्टहरू र स्क्रिनकास्टहरू।
    - *समस्या सेट र प्रतिस्पर्धात्मक प्रोग्रामिङ* : एउटा वेबसाइट वा सफ्टवेयर जसले तपाईंलाई सरल वा जटिल समस्याहरू समाधान गरेर, कोड समीक्षाको साथ वा बिना, परिणामहरू अन्य प्रयोगकर्ताहरूसँग तुलना नगरी आफ्नो प्रोग्रामिङ कौशल मूल्याङ्कन गर्न दिन्छ।

4. [तलका दिशानिर्देशहरू](#दिशानिर्देश) पालना गर्न र फाइलहरूको [मार्कडाउन ढाँचा](#ढाँचा) लाई सम्मान गर्न सुनिश्चित गर्नुहोस्।

5. GitHub कार्यहरूले **तपाईँका सूचीहरू वर्णमालाबद्ध छन्** र **फर्म्याटिङ नियमहरू पालना गरिएको छ भनी सुनिश्चित गर्न परीक्षणहरू चलाउनेछ। **निश्चित हुनुहोस्** जाँच गर्नुहोस् कि तपाइँका परिवर्तनहरूले परीक्षणहरू पास गर्दछ।


### दिशानिर्देश

- सुनिश्चित गर्नुहोस् कि एक पुस्तक निःशुल्क छ। आवश्यक भएमा डबल-जाँच गर्नुहोस्। तपाईंले पुस्तक नि:शुल्क छ भनी किन PR मा टिप्पणी गर्नुभयो भने यसले प्रशासकहरूलाई मद्दत गर्छ।
- हामी Google Drive, Dropbox, Mega, Scribd, Issuu र अन्य समान फाइल अपलोड प्लेटफर्महरूमा होस्ट गरिएका फाइलहरू स्वीकार गर्दैनौं।
- वर्णमाला क्रम मा आफ्नो लिङ्क सम्मिलित, वर्णन [तल](#वर्णमाला-क्रममा).
- सबैभन्दा आधिकारिक स्रोतको साथ लिङ्क प्रयोग गर्नुहोस् (अर्थ लेखकको वेबसाइट सम्पादकको वेबसाइट भन्दा राम्रो छ, जुन तेस्रो पक्ष वेबसाइट भन्दा राम्रो छ)
    - कुनै फाइल होस्टिङ सेवाहरू (यसमा ड्रपबक्स र गुगल ड्राइभ लिङ्कहरू समावेश छन् (तर सीमित छैन)
- सधैं `http` एकमा `https` लिङ्कलाई प्राथमिकता दिनुहोस् -- जबसम्म तिनीहरू एउटै डोमेनमा छन् र उही सामग्री सेवा गर्छन्।
- रूट डोमेनहरूमा, `http://example.com/` को सट्टा ट्रेलिङ स्ल्याश स्ट्रिप गर्नुहोस्: `http://example.com`
- जहिले पनि छोटो लिङ्कलाई प्राथमिकता दिनुहोस्: `http://example.com/dir/` `http://example.com/dir/index.html` भन्दा राम्रो छ
    - कुनै URL छोटो लिंक छैन
- सामान्यतया "संस्करण" मा "वर्तमान" लिङ्कलाई प्राथमिकता दिनुहोस्: `http://example.com/dir/book/current/` `http://example.com/dir/book/v1.0.0 भन्दा राम्रो छ। /index.html`
- यदि लिङ्कसँग म्याद सकिएको प्रमाणपत्र/स्व-हस्ताक्षरित प्रमाणपत्र/SSL कुनै अन्य प्रकारको मुद्दा छ भने:
    1. *यदि सम्भव भएमा यसलाई यसको `http` समकक्षसँग बदल्नुहोस् (किनकि मोबाइल उपकरणहरूमा अपवादहरू स्वीकार गर्न जटिल हुन सक्छ)।
    2. *यसलाई छोड्नुहोस्* यदि कुनै `http` संस्करण उपलब्ध छैन तर लिङ्क अझै पनि ब्राउजरमा अपवाद थपेर वा चेतावनीलाई बेवास्ता गरेर `https` मार्फत पहुँचयोग्य छ।
    3. *हटाउनुहोस्* अन्यथा।
- यदि एक लिङ्क धेरै ढाँचामा अवस्थित छ भने, प्रत्येक ढाँचाको बारेमा नोटको साथ छुट्टै लिङ्क थप्नुहोस्
- यदि इन्टरनेटमा विभिन्न स्थानहरूमा स्रोत अवस्थित छ
    - सबैभन्दा आधिकारिक स्रोतको साथ लिङ्क प्रयोग गर्नुहोस् (अर्थ लेखकको वेबसाइट सम्पादकको वेबसाइट भन्दा राम्रो छ तेस्रो पक्ष वेबसाइट भन्दा राम्रो छ)
    - यदि तिनीहरू विभिन्न संस्करणहरूमा लिङ्क हुन्छन्, र तपाईंले यी संस्करणहरू राख्न लायकको रूपमा फरक छन् भनेर न्याय गर्नुहुन्छ भने, प्रत्येक संस्करणको बारेमा नोटको साथ छुट्टै लिङ्क थप्नुहोस् (हेर्नुहोस् [अंक #2353](https://github.com/EbookFoundation/free-programming-books/issues/2353) ढाँचामा छलफलमा योगदान दिन)।
- ठूला कमिटहरू भन्दा परमाणु कमिटहरू (एउटा कमिट थप/मेटाउने/परिमार्जन) लाई प्राथमिकता दिनुहोस्। PR पेश गर्नु अघि आफ्नो कमिटहरू स्क्वाश गर्न आवश्यक छैन। (हामी यो नियम कहिल्यै लागू गर्दैनौं किनकि यो मर्मतकर्ताहरूको सुविधाको कुरा हो)
- यदि पुस्तक पुरानो छ भने, शीर्षक सहित प्रकाशन मिति समावेश गर्नुहोस्।
- उपयुक्त भएमा लेखकको नाम वा नामहरू समावेश गर्नुहोस्। तपाइँ "`et al.`" को साथ लेखक सूचीहरू छोटो बनाउन सक्नुहुन्छ।
- यदि पुस्तक समाप्त भएको छैन, र अझै काम भइरहेको छ भने, "`इन प्रक्रिया`" नोटेशन थप्नुहोस्, [तल](#वर्णमाला-क्रममा) वर्णन गरिए अनुसार।
- यदि कुनै स्रोत [Internet Archive's Wayback Machine*](https://web.archive.org) (वा समान) को प्रयोग गरेर पुनर्स्थापना गरिएको छ भने, वर्णन गरिए अनुसार "`संग्रहित`" सङ्केत थप्नुहोस् [तल](#archived). प्रयोग गर्नका लागि उत्तम संस्करणहरू भर्खरका र पूर्ण छन्।
- यदि डाउनलोड सक्षम हुनु अघि इमेल ठेगाना वा खाता सेटअप अनुरोध गरिएको छ भने, कोष्ठकहरूमा भाषा-उपयुक्त टिप्पणीहरू थप्नुहोस्, जस्तै: `(इमेल ठेगाना *अनुरोध गरिएको*, आवश्यक छैन)`।


### ढाँचा

- सबै सूचीहरू `.md` फाइलहरू हुन्। [मार्कडाउन](https://guides.github.com/features/mastering-markdown/) सिन्ट्याक्स सिक्ने प्रयास गर्नुहोस्। यो सरल छ!
- सबै सूचीहरू अनुक्रमणिकाबाट सुरु हुन्छ। त्यहाँ सबै खण्ड र उपखण्डहरू सूचीबद्ध र लिङ्क गर्ने विचार हो। यसलाई वर्णमाला क्रममा राख्नुहोस्।
- खण्डहरूले स्तर 3 शीर्षकहरू (`###`) प्रयोग गर्दैछन्, र उपखण्डहरू स्तर 4 शीर्षकहरू (`####`) हुन्।

विचार हुनु पर्छ:

- अन्तिम लिङ्क र नयाँ खण्ड बीचको `2` खाली रेखाहरू।
- शीर्षक र यसको खण्डको पहिलो लिङ्क बीचको `1` खाली रेखा।
- दुई लिङ्कहरू बीच `0` खाली रेखा।
- प्रत्येक `.md` फाइलको अन्त्यमा `1` खाली रेखा।

उदाहरण:

```text
[...]
* [एक अद्भुत पुस्तक](http://example.com/example.html)
                                (खाली रेखा)
                                (खाली रेखा)
### उदाहरण
                                (खाली रेखा)
* [अर्को अद्भुत पुस्तक](http://example.com/book.html)
* [केही अन्य पुस्तक](http://example.com/other.html)
```

- `]` र `(` बीचमा खाली ठाउँहरू नराख्नुहोस्:

    ```text
    खराब : * [अर्को अद्भुत पुस्तक] (http://example.com/book.html)
    राम्रो: * [अर्को अद्भुत पुस्तक](http://example.com/book.html)
    ```

- यदि तपाइँ लेखक समावेश गर्नुहुन्छ भने, ` - ` (एकल खाली ठाउँहरूले घेरिएको ड्यास) प्रयोग गर्नुहोस्:

    ```text
    खराब : * [अर्को अद्भुत पुस्तक](http://example.com/book.html)- जोन डो
    राम्रो: * [अर्को अद्भुत पुस्तक](http://example.com/book.html) - जोन डो
    ```

- लिङ्क र यसको ढाँचा बीच एकल स्पेस राख्नुहोस्:

    ```text
    खराब : * [एक धेरै अद्भुत पुस्तक](https://example.org/book.pdf)(PDF)
    राम्रो: * [एक धेरै अद्भुत पुस्तक](https://example.org/book.pdf) (PDF)
    ```

- लेखक ढाँचा अघि आउँछ:

    ```text
    खराब : * [एक धेरै अद्भुत पुस्तक](https://example.org/book.pdf)- (PDF) जेन रो
    राम्रो: * [एक धेरै अद्भुत पुस्तक](https://example.org/book.pdf) - जेन रो (PDF)
    ```

- बहु ढाँचाहरू (हामी प्रत्येक स्रोतको लागि एउटै लिङ्कलाई प्राथमिकता दिन्छौं। जब त्यहाँ विभिन्न ढाँचाहरूमा सजिलो पहुँचको साथ कुनै एक लिङ्क छैन, धेरै लिङ्कहरूले अर्थ बनाउन सक्छ। तर हामीले थप्ने प्रत्येक लिङ्कले मर्मत बोझ सिर्जना गर्दछ त्यसैले हामी यसलाई बेवास्ता गर्ने प्रयास गर्छौं।):

    ```text
    खराब : * [अर्को अद्भुत पुस्तक](http://example.com/)- जोन डो (HTML)
    खराब : * [अर्को अद्भुत पुस्तक](https://downloads.example.org/book.html)- जोन डो (डाउनलोड साइट)
    राम्रो: * [अर्को अद्भुत पुस्तक](http://example.com/) - जोन डो (HTML) [(PDF, EPUB)](https://downloads.example.org/book.html)
    ```

- पुराना पुस्तकहरूको लागि शीर्षकमा प्रकाशन वर्ष समावेश गर्नुहोस्:

    ```text
    खराब : * [एक धेरै अद्भुत पुस्तक](https://example.org/book.html) - जेन रो - 1970
    राम्रो: * [एक धेरै अद्भुत पुस्तक (1970)](https://example.org/book.html) - जेन रो
    ```

- <a id="in_process"></a>प्रक्रियामा रहेका पुस्तकहरू:

```text
    राम्रो: * [चाँडै नै उत्कृष्ट पुस्तक हुनेछ](http://example.com/book2.html) - जोन डो (HTML) (:निर्माण: *प्रक्रियामा*)
``` 

- <a id="archived"></a>संग्रहित लिङ्क:

```text
    राम्रो: * [A Way-backed Interesting Book](https://web.archive.org/web/20211016123456/http://example.com/) - जोन डो (HTML) *( :card_file_box: archived)*
```

### वर्णमाला क्रममा

- जब एउटै अक्षरबाट सुरु हुने धेरै शीर्षकहरू छन् भने तिनीहरूलाई दोस्रो क्रमबद्ध गर्नुहोस्, र यस्तै। उदाहरणका लागि: `ab` अघि `aa` आउँछ।
- `एक दुई` `एक दुई` अघि आउँछ

यदि तपाईंले गलत स्थानमा लिङ्क देख्नुभयो भने, कुन लाइनहरू स्वैप गर्नुपर्छ भनेर जान्न लिन्टर त्रुटि सन्देश जाँच गर्नुहोस्।


### नोटहरू

जबकि आधारभूतहरू अपेक्षाकृत सरल छन्, त्यहाँ हामीले सूचीबद्ध गर्ने स्रोतहरूमा ठूलो विविधता छ। हामी यस विविधतासँग कसरी व्यवहार गर्छौं भन्ने बारे यहाँ केही टिप्पणीहरू छन्।


#### मेटाडेटा

हाम्रा सूचीहरूले मेटाडेटाको न्यूनतम सेट प्रदान गर्दछ: शीर्षकहरू, URL हरू, सिर्जनाकर्ताहरू, प्लेटफर्महरू, र पहुँच नोटहरू।


##### शीर्षकहरू

- आविष्कार गरिएका शीर्षकहरू छैनन्। हामी स्रोतहरू आफैंबाट शीर्षकहरू लिने प्रयास गर्छौं; योगदानकर्ताहरूलाई शीर्षकहरू आविष्कार गर्न वा सम्पादकीय रूपमा प्रयोग नगर्न सल्लाह दिइन्छ यदि यसबाट बच्न सकिन्छ। एक अपवाद पुराना कामहरूको लागि हो; यदि तिनीहरू मुख्य रूपमा ऐतिहासिक चासोका छन् भने, शीर्षकमा जोडिएको कोष्ठकमा एक वर्षले प्रयोगकर्ताहरूलाई उनीहरूको रुचि छ कि छैन भनेर जान्न मद्दत गर्दछ।
- कुनै ALLCAPS शीर्षकहरू छैनन्। सामान्यतया शीर्षक केस उपयुक्त हुन्छ, तर शङ्का हुँदा स्रोतबाट क्यापिटलाइजेशन प्रयोग गर्नुहोस्
- कुनै इमोजी छैन।


##### URL हरू

- हामी छोटो URL लाई अनुमति दिदैनौं।
- ट्र्याकिङ कोडहरू URL बाट हटाउनु पर्छ।
- अन्तर्राष्ट्रिय URL हरू बचाउनु पर्छ। ब्राउजर बारहरूले सामान्यतया यी युनिकोडमा रेन्डर गर्छन्, तर कृपया प्रतिलिपि र टाँस्नुहोस् प्रयोग गर्नुहोस्।
- सुरक्षित (`https`) URL हरू सधैं गैर-सुरक्षित (`http`) urlहरूमा प्राथमिकता दिइन्छ जहाँ HTTPS लागू गरिएको छ।
- हामीलाई सूचीबद्ध स्रोतहरू होस्ट नगर्ने वेबपृष्ठहरूलाई देखाउने URL हरू मन पर्दैन, तर यसको सट्टा अन्यत्र पोइन्ट गर्नुहोस्।


##### रचनाकारहरू

- हामी अनुवादकहरू सहित उपयुक्त ठाउँमा नि:शुल्क स्रोतहरूको सिर्जनाकर्ताहरूलाई क्रेडिट दिन चाहन्छौं!
- अनुवादित कृतिहरूको लागि मूल लेखकलाई श्रेय दिनुपर्छ। हामी यस उदाहरणमा जस्तै लेखकहरू बाहेक अन्य क्रेडिट सिर्जनाकर्ताहरूलाई [MARC relators](https://loc.gov/marc/relators/relaterm.html) प्रयोग गर्न सिफारिस गर्छौं:

```markdown
    * [एक अनुवादित पुस्तक](http://example.com/book.html) - जोन डो, `trl.:` माइक द अनुवादक
```

यहाँ, एनोटेसन `trl.:` ले "अनुवादक" को लागि MARC रिलेटर कोड प्रयोग गर्दछ।
- लेखक सूचीमा प्रत्येक वस्तुलाई सीमित गर्न अल्पविराम `,` प्रयोग गर्नुहोस्।
- तपाइँ "`et al.`" को साथ लेखक सूचीहरू छोटो गर्न सक्नुहुन्छ।
- हामी सृष्टिकर्ताहरूको लागि लिङ्कहरूलाई अनुमति दिँदैनौं।
- संकलन वा रिमिक्स गरिएका कार्यहरूको लागि, "सिर्जनाकर्ता" लाई विवरण चाहिन्छ। उदाहरणका लागि, "GoalKicker" वा "RIP Tutorial" पुस्तकहरूलाई "`StackOverflow कागजातबाट संकलित`" को रूपमा श्रेय दिइन्छ।
- हामीले सम्मानितहरू समावेश गर्दैनौं जस्तै "प्रो." वा "डा. सृष्टिकर्ताको नाममा।


##### समय-सीमित पाठ्यक्रमहरू र परीक्षणहरू

- हामीले छ महिनामा हटाउन आवश्यक पर्ने चीजहरू सूचीबद्ध गर्दैनौं।
- यदि पाठ्यक्रमको नामांकन अवधि वा अवधि सीमित छ भने, हामी यसलाई सूचीबद्ध गर्दैनौं।
- हामी सीमित अवधिको लागि नि:शुल्क स्रोतहरू सूचीबद्ध गर्न सक्दैनौं।


##### प्लेटफर्म र पहुँच नोटहरू

- पाठ्यक्रमहरू। विशेष गरी हाम्रो पाठ्यक्रम सूचीहरूको लागि, प्लेटफर्म स्रोत विवरणको महत्त्वपूर्ण भाग हो। यो किनभने पाठ्यक्रम प्लेटफर्महरूमा फरक क्षमता र पहुँच मोडेलहरू छन्। हामी सामान्यतया दर्ता आवश्यक पर्ने पुस्तकलाई सूचीबद्ध गर्दैनौं, तर धेरै पाठ्यक्रम प्लेटफर्महरूमा कुनै प्रकारको खाता बिना काम गर्दैन। उदाहरण पाठ्यक्रम प्लेटफर्महरू Coursera, EdX, Udacity, र Udemy समावेश छन्। जब कुनै पाठ्यक्रम प्लेटफर्ममा निर्भर हुन्छ, प्लेटफर्मको नाम कोष्ठकहरूमा सूचीबद्ध हुनुपर्छ।
- YouTube। हामीसँग धेरै पाठ्यक्रमहरू छन् जसमा YouTube प्लेलिस्टहरू छन्। हामी YouTube लाई प्लेटफर्मको रूपमा सूचीबद्ध गर्दैनौं, हामी YouTube सिर्जनाकर्तालाई सूचीबद्ध गर्ने प्रयास गर्छौं, जुन प्रायः उप-प्लेटफर्म हो।
- YouTube भिडियोहरू। हामी सामान्यतया व्यक्तिगत YouTube भिडियोहरूमा लिङ्क गर्दैनौं जबसम्म तिनीहरू एक घण्टा भन्दा लामो हुन्छन् र पाठ्यक्रम वा ट्यूटोरियल जस्तै संरचित हुन्छन्। यदि यो मामला हो भने, PR विवरणमा यसलाई नोट गर्न निश्चित हुनुहोस्।
- कुनै छोटो (जस्तै youtu.be/xxxx) लिङ्कहरू छैनन्!
- लीनपब। Leanpub ले विभिन्न पहुँच मोडेलहरू भएका पुस्तकहरू होस्ट गर्छ। कहिलेकाहीँ एक पुस्तक दर्ता बिना पढ्न सकिन्छ; कहिलेकाहीँ पुस्तकलाई निःशुल्क पहुँचको लागि Leanpub खाता चाहिन्छ। पुस्तकहरूको गुणस्तर र Leanpub पहुँच मोडेलहरूको मिश्रण र तरलतालाई ध्यानमा राख्दै, हामी पछिल्लोको पहुँच नोट `*(Leanpub खाता वा मान्य इमेल अनुरोध गरिएको)*` को साथ सूचीकरण गर्न अनुमति दिन्छौं।


#### विधाहरू

स्रोत कुन सूचीमा पर्दछ भन्ने निर्णय गर्ने पहिलो नियम भनेको स्रोतले आफूलाई कसरी वर्णन गर्छ भनेर हेर्नु हो। यदि यो आफैंलाई एक पुस्तक भनिन्छ भने, त्यसपछि यो एक किताब हो।

##### हामीले सूचीबद्ध नगर्ने विधाहरू

किनभने इन्टरनेट विशाल छ, हामी हाम्रो सूचीमा समावेश गर्दैनौं:

- ब्लगहरू
- ब्लग पोस्टहरू
- लेखहरू
- वेबसाइटहरू (हामीले सूचीबद्ध गर्ने धेरै वस्तुहरू होस्ट गर्ने बाहेक)।
- पाठ्यक्रम वा स्क्रिनकास्ट नभएका भिडियोहरू।
- पुस्तक अध्यायहरू
- पुस्तकहरूबाट टिजर नमूनाहरू
- आईआरसी वा टेलिग्राम च्यानलहरू
- ढिलो वा मेलिङ सूची

हाम्रा प्रतिस्पर्धी प्रोग्रामिङ सूचीहरू यी बहिष्करणहरूको बारेमा त्यति कडा छैनन्। रिपोको दायरा समुदाय द्वारा निर्धारण गरिन्छ; यदि तपाईं स्कोपमा परिवर्तन वा थप सुझाव दिन चाहनुहुन्छ भने, कृपया सुझाव दिनको लागि मुद्दा प्रयोग गर्नुहोस्।


##### किताबहरू बनाम अन्य सामग्री

हामी किताबीपनको बारेमा उग्र छैनौं। यहाँ केही विशेषताहरू छन् जसले सङ्केत गर्छ कि स्रोत एउटा पुस्तक हो:

- यसमा ISBN (अन्तर्राष्ट्रिय मानक पुस्तक नम्बर) छ।
- यसमा सामग्रीको तालिका छ
- डाउनलोड योग्य संस्करण प्रस्ताव गरिएको छ, विशेष गरी ePub फाइलहरू।
- यो संस्करण छ
- यो अन्तरक्रियात्मक सामग्री वा भिडियोहरूमा निर्भर गर्दैन
- यसले विषयलाई व्यापक रूपमा समेट्ने प्रयास गर्छ
- यो आत्म-निहित छ

त्यहाँ धेरै पुस्तकहरू छन् जुन हामीले सूचीबद्ध गर्छौं जसमा यी विशेषताहरू छैनन्; यो सन्दर्भमा निर्भर हुन सक्छ।


##### पुस्तकहरू बनाम पाठ्यक्रमहरू

कहिलेकाहीँ यी छुट्याउन गाह्रो हुन सक्छ!

पाठ्यक्रमहरूमा प्राय: सम्बन्धित पाठ्यपुस्तकहरू हुन्छन्, जसलाई हामी हाम्रा पुस्तकहरूको सूचीमा सूचीबद्ध गर्नेछौं। पाठ्यक्रमहरूमा व्याख्यानहरू, अभ्यासहरू, परीक्षणहरू, नोटहरू वा अन्य शिक्षात्मक सहायताहरू छन्। एकल व्याख्यान वा भिडियो आफैमा पाठ्यक्रम होइन। पावरपोइन्ट पाठ्यक्रम होइन।

##### अन्तर्क्रियात्मक ट्यूटोरियल बनाम अन्य सामान

यदि तपाइँ यसलाई प्रिन्ट गर्न सक्नुहुन्छ र यसको सार कायम राख्न सक्नुहुन्छ, यो अन्तरक्रियात्मक ट्यूटोरियल होइन।


### स्वचालन

- ढाँचा नियम प्रवर्तन [GitHub कार्यहरू](https://github.com/features/actions) मार्फत [fpb-lint](https://github.com/vhf/free-programming-books-lint) प्रयोग गरेर स्वचालित हुन्छ। हेर्नुहोस् [`.github/workflows/fpb-lint.yml`](../.github/workflows/fpb-lint.yml))
- URL प्रमाणीकरणले [awesome_bot](https://github.com/dkhamsing/awesome_bot) प्रयोग गर्दछ
- URL प्रमाणीकरण ट्रिगर गर्न, कमिट पुश गर्नुहोस् जसमा `check_urls=file_to_check` समावेश भएको कमिट सन्देश समावेश छ:

    ```properties
    check_urls=free-programming-books.md free-programming-books-en.md
    ```

- तपाईंले प्रत्येक प्रविष्टि अलग गर्न एकल स्पेस प्रयोग गरेर जाँच गर्न एक भन्दा बढी फाइल निर्दिष्ट गर्न सक्नुहुन्छ।
- यदि तपाईंले एक भन्दा बढी फाइल निर्दिष्ट गर्नुभयो भने, निर्माणको परिणामहरू जाँच गरिएको अन्तिम फाइलको परिणाममा आधारित हुन्छन्। तपाइँ सचेत हुनुपर्दछ कि तपाइँ यस कारणले हरियो बिल्डहरू पास गर्न सक्नुहुन्छ त्यसैले "सबै जाँचहरू देखाउनुहोस्" -> "विवरणहरू" मा क्लिक गरेर पुल अनुरोधको अन्त्यमा निर्माण लग निरीक्षण गर्न निश्चित हुनुहोस्।