*[Доступно на других языках](README.md#translations)*


<!----><a id="contributor-license-agreement"></a>
## Лицензионное соглашение с участником

Принимая участие, вы соглашаетесь с [ЛИЦЕНЗИЕЙ](../LICENSE) этого репозитория.


<!----><a id="contributor-code-of-conduct"></a>
## Кодекс поведения автора

Принимая участие, вы соглашаетесь соблюдать [Кодекс поведения](CODE_OF_CONDUCT-ru.md) этого репозитория. ([translations](README.md#translations)*


<!----><a id="in-a-nutshell"></a>
## В двух словах

1. «Ссылка для легкой загрузки книги» не всегда является ссылкой на *бесплатную* книгу. Пожалуйста, размещайте только бесплатный контент. Убедитесь, что это бесплатно. Мы не принимаем ссылки на страницы, которым *требуются* адреса электронной почты на рабочем домене для получения книг. Однако мы приветствуем списки, которые запрашивают их.

2. Вам необязательно знать Git: если вы нашли что-то интересное, чего *еще нет в этом репозитории*, пожалуйста, откройте [Issue](https://github.com/EbookFoundation/free-programming-books/issues) с вашими предложениями.
    - Если вы знакомы с Git, пожалуйста форкните репозиторий и пришлите пулреквест (PR).

3. У нас есть 6 видов списков. Выберите подходящий:

    - *Книги*: PDF, HTML, ePub, сайт на основе gitbook.io, репозиторий Git и т. Д.
    - *Курсы*: курс - это учебный материал, который не является книгой. [Это курс](http://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-006-introduction-to-algorithms-fall-2011/).
    - *Интерактивные учебные пособия*: интерактивный веб-сайт, который позволяет пользователю вводить код или команды и оценивать результат (под «результатом» мы не подразумеваем «оценку»). например: [Попробуйте Haskell](http://tryhaskell.org), [Попробуйте GitHub](http://try.github.io).
    - *Playgrounds* : are online and interactive websites, games or desktop software for learning programming. Write, compile (or run), and share code snippets. Playgrounds often allow you to fork and get your hands dirty by playing with code.
    - *Подкасты и скринкасты*: подкасты и скринкасты.
    - *Наборы задач и соревновательное программирование*: веб-сайт или программа, которое позволяет вам оценить свои навыки программирования, решая простые или сложные задачи, с проверкой кода или без нее, со сравнением результатов с результатами других пользователей или без него.

4. Обязательно следуйте [Руководству, приведённому ниже](#guidelines) и соблюдайте [Markdown форматирование](#formatting) файлов.

5. GitHub Actions запустит тесты, чтобы убедиться, что ваши **списки отсортированы по алфавиту** и **соблюдаются правила форматирования**. **Обязательно проверьте**, чтобы ваши изменения прошли проверку.


<!----><a id="guidelines"></a>
### Руководство

- Убедитесь что книга бесплатна. При необходимости проверьте еще раз. Администраторам помогает, если вы описываете в PR, почему вы думаете, что книга бесплатная.
- Мы не принимаем файлы, размещенные на Google Drive, Dropbox, Mega, Scribd, Issuu и других подобных платформах для загрузки файлов.
- Вставляйте ссылки в алфавитном порядке, as described [below](#alphabetical-order).
- Используйте ссылку с наиболее авторитетным источником (то есть сайт автора лучше, чем сайт редактора, что лучше, чем сторонний сайт)
    - не с файловых хостингов (включая (но не ограничиваясь) ссылками на Dropbox и Google Drive)
- всегда предпочитайте ссылку `https` вместо ссылки `http` - если они находятся в одном домене и обслуживают один и тот же контент
- в корневых доменах удалите косую черту в конце: `http://example.com` вместо `http://example.com/`
- всегда предпочитайте самую короткую ссылку: `http://example.com/dir/` лучше, чем `http://example.com/dir/index.html`
    - избегайте сервисы сокращения ссылок
- Обычно предпочитают ссылку на "актуальную" версию, чем на конкретную: `http://example.com/dir/book/current/` лучше, чем `http://example.com/dir/book/v1.0.0/index.html`
- Если ссылка имеет просроченный сертификат/самоподписанный сертификат/SSL-сертификат любого другого типа:
    1. *замените её* его эквивалентом http, если это возможно (поскольку принятие исключений может быть затруднено на мобильных устройствах).
    2. *оставьте её*, если версия http недоступна, но ссылка все еще доступна через `https` путем добавления исключения в браузер или игнорирования предупреждения.
    3. *удалите* в противном случае.
- Если ссылка существует в нескольких форматах, добавьте отдельную ссылку с примечанием о каждом формате
- Если ресурс существует в разных местах в Интернете
    - используйте ссылку с наиболее авторитетным источником (это означает, что сайт автора лучше, чем сайт редактора, лучше, чем сторонний сайт)
    - если они ссылаются на разные выпуски и вы считаете, что эти выпуски достаточно разные, чтобы их стоило сохранить, добавьте отдельную ссылку с примечанием о каждом выпуске (см. [Issue #2353](https://github.com/EbookFoundation/free-programming-books/issues/2353), чтобы обсудить форматирование).
- Предпочитайте атомарные коммиты (по одному коммиту на каждое добавление/удаление/модификацию) большим коммитам. Не нужно собирать все коммиты в один перед тем, как отправить PR. (Мы никогда не будем настаивать на этом, поскольку это просто вопрос удобства для сопровождающих)
- Если книга более старая, укажите дату публикации в названии.
- Укажите имя автора или имена там, где это необходимо. Вы можете сократить списки авторов с помощью «`и др.`» («`et al.`»).
- если книга не закончена, и работа над ней продолжается, добавьте пометку «`в процессе`», как описано [ниже](#in_process).
- if a resource is restored using the [*Internet Archive's Wayback Machine*](https://web.archive.org) (or similar), add the "`archived`" notation, as described [below](#archived). The best versions to use are recent and complete.
- если перед загрузкой запрашивается адрес электронной почты или настройка учетной записи, добавьте в скобки примечания на соответствующем языке, например: `(адрес электронной почты *запрашивают*, но он не требуется для загрузки)`.


<!----><a id="formatting"></a>
### Форматирование

- Все списки представляют собой файлы с расширением `.md`. Попробуйте изучить синтаксис [Markdown](https://guides.github.com/features/mastering-markdown/). Это просто!
- Все списки начинаются с индекса. Идея состоит в том, чтобы перечислить и связать там все разделы и подразделы. Храните их в алфавитном порядке.
- В разделах используются заголовки уровня 3 (`###`), а в подразделах используются заголовки уровня 4 (`####`).

Идея состоит в том, чтобы иметь:

- `2` пустые строки между последней ссылкой и новым разделом.
- `1` пустую строку между заголовком и первой ссылкой его раздела.
- `0` пустых ссылок между двумя ссылками.
- `1` пустую строку в конце каждого `.md` файла.

Пример:

```text
[...]
* [Шикарная книга](http://example.com/example.html)
                                (пустая строка)
                                (пустая строка)
### Пример
                                (пустая строка)
* [Другая шикарная книга](http://example.com/book.html)
* [Ещё одна другая книга](http://example.com/other.html)
```

- Не вставляйте пробел между `]` и `(`:

    ```text
    ПЛОХО : * [Другая шикарная книга] (http://example.com/book.html)
    ХОРОШО: * [Другая шикарная книга](http://example.com/book.html)
    ```

- Если вы указываете автора, используйте ` - ` (тире, окруженное одиночными пробелами):

    ```text
    ПЛОХО : * [Другая шикарная книга](http://example.com/book.html)- Джон Доу
    ХОРОШО: * [Другая шикарная книга](http://example.com/book.html) - Джон Доу
    ```

- Отбейте ссылку и её формат пробелом:

    ```text
    ПЛОХО : * [Очень хорошая книга](https://example.org/book.pdf)(PDF)
    ХОРОШО: * [Очень хорошая книга](https://example.org/book.pdf) (PDF)
    ```

- Сперва автор, потом формат:

    ```text
    ПЛОХО : * [Очень хорошая книга](https://example.org/book.pdf)- (PDF) Джейн Роу
    ХОРОШО: * [Очень хорошая книга](https://example.org/book.pdf) - Джейн Роу (PDF)
    ```

- Несколько форматов:

    ```text
    ПЛОХО : * [Другая шикарная книга](http://example.com/)- Джон Доу (HTML)
    ПЛОХО : * [Другая шикарная книга](https://downloads.example.org/book.html)- Джон Доу (cайт для загрузки)
    ХОРОШО: * [Другая шикарная книга](http://example.com/) - Джон Доу (HTML) [(PDF, EPUB)](https://downloads.example.org/book.html)
    ```

- Включите год публикации в заголовок для старых книг:

    ```text
    ПЛОХО : * [Очень хорошая книга](https://example.org/book.html) - Джейн Роу - 1970
    ХОРОШО: * [Очень хорошая книга (1970)](https://example.org/book.html) - Джейн Роу
    ```

- <a id="in_process"></a>Незавершенные книги:

    ```text
    ХОРОШО: * [Скоро будет отличная книга](http://example.com/book2.html) - Джон Доу (HTML) *( :construction: in process)*
    ```

- <a id="archived"></a>Archived link:

    ```text
    ХОРОШО: * [A Way-backed Interesting Book](https://web.archive.org/web/20211016123456/http://example.com/) - John Doe (HTML) *( :card_file_box: archived)*
    ```

### Алфавитный порядок

- Если есть несколько названий, начинающихся на одну и ту же букву, упорядочьте их (названия) по второй букве, и так далее. Например: `aa` должно располагаться перед `ab`.
- `one two` должно располагаться перед `onetwo`

Если вы видите неправильную ссылку, то проверьте сообщение линтера об ошибке, чтобы знать, какие строки следует поменять местами.


<!----><a id="notes"></a>
### Примечания

Хотя основы относительно просты, перечисленные нами ресурсы очень разнообразны. Вот несколько замечаний о том, как мы справляемся с этим разнообразием.


<!----><a id="metadata"></a>
#### Метаданные

Наши списки предоставляют минимальный набор метаданных: заголовки, URL-адреса, создателей, платформы и примечания к доступу.


<!----><a id="titles"></a>
##### Заголовки

- Никаких вымышленных названий. Мы стараемся брать названия с самих ресурсов; призываем авторов пулреквестов не придумывать заголовки и не использовать их в редакционных целях, если этого можно избежать. Исключение составляют более старые работы; если они представляют в первую очередь исторический интерес, год в скобках, добавленный к названию, помогает пользователям узнать, представляют ли они интерес.
- Избегайте заголовков ПОЛНОСТЬЮ ЗАГЛАВНЫМИ БУКВАМИ. Обычно уместен регистр заголовка, но в случае сомнений используйте заглавные буквы из источника.
- Не используйте эмодзи (смайлики).


<!----><a id="urls"></a>
##### URL-адреса

- Мы не разрешаем сокращенные URL-адреса.
- Коды отслеживания должны быть удалены из URL.
- Международные URL-адреса должны быть экранированы. Адресная панель браузера обычно отображают их в Unicode, но, пожалуйста, используйте копирование и вставку.
- Безопасные (`https`) URL-адреса всегда предпочтительнее небезопасных (`http`) URL-адресов, в которых реализован HTTPS.
- Нам не нравятся URL-адреса, которые указывают на страницы со ссылкой на другое место вместо указанного ресурса.


<!----><a id="creators"></a>
##### Создатели

- Хотим поблагодарить создателей бесплатных ресурсов, где это возможно, в том числе переводчиков!
- Для переведенных работ следует указать оригинального автора. Мы рекомендуем использовать [MARC relators](https://loc.gov/marc/relators/relaterm.html) чтобы отблагодарить других создателей, кроме авторов, как в этом примере:

    ```markdown
    * [A Translated Book](http://example.com/book-ru.html) - John Doe, `trl.:` Mike The Translator
    ```

    здесь сокращение `trl.:` используется MARC relator code для слова "translator" ("переводчик").
- Используйте запятые `,` для разграничения каждого элемента в списке авторов.
- Вы можете сокращать списки авторов с помощью "`et al.`".
- Мы не разрешаем ссылки на авторов.
- Для подборок и смешенных изданий «создателю» может потребоваться описание. Например, книги «GoalKicker» или «RIP Tutorial» считаются «`Скомпилированными из документации StackOverflow`» ("на английском: «`Compiled from StackOverflow documentation`»).


<!----><a id="platforms-and-access-notes"></a>
##### Платформы и примечания к доступу

- Курсы. Платформа является важной частью описания ресурсов, особенно для наших списков курсов. Это связано с тем, что платформы курсов имеют разные возможности и модели доступа. Хотя мы обычно не перечисляем книги, требующие регистрации, на многих платформах курсов есть возможности, которые не работают без какой-либо учетной записи. Например, как на Coursera, EdX, Udacity и Udemy. Если курс зависит от платформы, название платформы должно быть указано в скобках.
- YouTube. У нас есть много курсов, состоящих из плейлистов YouTube. Мы не указываем YouTube как платформу, мы пытаемся указать автора на YouTube, который часто является под-платформой.
- YouTube видео. Обычно мы не ссылаемся на отдельные видео YouTube, если они не длится более часа или не структурированы как курс или учебное пособие.
- Leanpub. Leanpub размещает книги с различными моделями доступа. Иногда книгу можно прочитать без регистрации; иногда для бесплатного доступа к книге требуется учетная запись Leanpub. Учитывая качество книг, а также сочетание и гибкость моделей доступа к Leanpub, мы разрешаем перечисление последних с указанием доступа `*(требуется учетная запись Leanpub или действующий адрес электронной почты)*`.


<!----><a id="genres"></a>
#### Жанры

Первое правило при принятии решения, к какому списку принадлежит ресурс, — это посмотреть, как ресурс описывает себя. Если он называет себя книгой, то, возможно, это книга.


<!----><a id="genres-we-dont-list"></a>
##### Жанры, которые мы не вносим в списки

Поскольку Интернет огромен, мы не включаем в наши списки:

- блоги
- Сообщения в блоге
- статьи
- веб-сайты (за исключением тех, размещающих МНОГО элементов которые мы перечисляем).
- видео, не являющиеся курсами или скринкастами.
- главы книги
- ознакомительные образцы из книг
- IRC или Telegram каналы
- Slacks или списки рассылки

В наших списках соревновательного программирования эти исключения не так строги. Объем репо определяется сообществом; если вы хотите предложить изменение или дополнение к области, пожалуйста, используйте Issue, чтобы сделать предложение.


<!----><a id="books-vs-other-stuff"></a>
##### Книги против прочих ресурсов

Мы не так привередливы в "книжности" ресурса. Вот некоторые атрибуты, которые указывают на то, что ресурс - это книга:

- имеет ISBN (международный стандартный книжный номер)
- имеет Оглавление
- предлагается загружаемая версия, особенно ePub
- есть редакции
- не зависит от интерактивного контента или видео
- пытается всесторонне осветить тему
- он самодостаточен

Мы перечисляем множество книг, у которых нет этих атрибутов; это может зависеть от контекста.


<!----><a id="books-vs-courses"></a>
#####  Книги против курсов

Иногда их бывает трудно отличить!

С курсами часто связаны учебники, которые мы перечисляем в наших списках книг. В курсах есть лекции, упражнения, тесты, заметки или другие дидактические пособия. Отдельная лекция или видео - это не курс. PowerPoint - это не курс.


<!----><a id="interactive-tutorials-vs-other-stuff"></a>
##### Интерактивные учебники и другие материалы

Если вы можете распечатать его и сохранить его суть, это не интерактивное руководство.


<!----><a id="automation"></a>
### Автоматизация

- Применение правил форматирования автоматизировано с помощью [GitHub Actions](https://github.com/features/actions) с использованием [fpb-lint](https://github.com/vhf/free-programming-books-lint) (см. [`.github/workflows/fpb-lint.yml`](../.github/workflows/fpb-lint.yml))
- Для проверки URL используется [awesome_bot](https://github.com/dkhamsing/awesome_bot)
- Чтобы запустить проверку URL, нажмите фиксацию, которая включает сообщение фиксации, содержащее `check_urls=ссылка_для_проверки`:

    ```properties
    check_urls=free-programming-books.md free-programming-books-ru.md
    ```

- Вы можете указать более одного файла для проверки, используя один пробел для разделения каждой записи.
- Если вы укажете более одного файла, результаты сборки будут основаны на результате последнего проверенного файла. Вы должны знать, что из-за этого вы можете получить проходящие зеленые сборки, поэтому обязательно проверьте журнал сборки в конце пулреквеста, нажав "Show all checks" -> "Details".
