*[இதனை மற்ற மொழிகளில் படிக்கவும்](README.md#translations)*


## பங்களிப்பாளர் உரிம ஒப்பந்தம்

பங்களிப்பதன் மூலம், இந்த repository-இன் [உரிமத்தை](../LICENSE) நீங்கள் ஒப்புக்கொள்கிறீர்கள்.


## பங்களிப்பாளர் நடத்தை நெறிமுறைகள்

பங்களிப்பதன் மூலம், இந்த repository-இன் [நடத்தை நெறிமுறைகளை](CODE_OF_CONDUCT.md) மதிக்க நீங்கள் ஒப்புக்கொள்கிறீர்கள். ([மொழிபெயர்ப்புகள்](README.md#translations))


## சுருக்கமாக

1. "ஒரு புத்தகத்தை எளிதாக பதிவிறக்கம் செய்வதற்கான இணைப்பு" என்பது எப்போதும் ஒரு *இலவச* புத்தகத்திற்கான இணைப்பு அல்ல. தயவுசெய்து இலவச உள்ளடக்கத்தை மட்டுமே பங்களிக்கவும். அது இலவசமாக இருப்பதை உறுதிசெய்யுங்கள். புத்தகங்களைப் பெறுவதற்கு *கட்டாயம் செயல்படும்* மின்னஞ்சல் முகவரிகளைக் கோரும் பக்கங்களுக்கான இணைப்புகளை நாங்கள் ஏற்றுக்கொள்வதில்லை, ஆனால் அவற்றை கோரும் பட்டியல்களை நாங்கள் வரவேற்கிறோம்.

2. நீங்கள் Git-ஐ தெரிந்திருக்க வேண்டிய அவசியமில்லை: *இந்த repository-இல் இல்லாத* ஆர்வமுள்ள ஒன்றை நீங்கள் கண்டறிந்தால், தயவுசெய்து உங்கள் இணைப்பு முன்மொழிவுகளுடன் ஒரு [Issue](https://github.com/EbookFoundation/free-programming-books/issues)-ஐ திறக்கவும்.
    - நீங்கள் Git-ஐ அறிந்திருந்தால், தயவுசெய்து repository-ஐ Fork செய்து Pull Requests (PR) அனுப்பவும்.

3. எங்களிடம் 6 வகையான பட்டியல்கள் உள்ளன. சரியானதைத் தேர்ந்தெடுங்கள்:

    - *Books* : PDF, HTML, ePub, gitbook.io அடிப்படையிலான தளம், ஒரு Git repository, முதலியன.
    - *Courses* : ஒரு கோர்ஸ் என்பது புத்தகம் அல்லாத கற்றல் பொருள். [இது ஒரு கோர்ஸ்](http://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-006-introduction-to-algorithms-fall-2011/).
    - *Interactive Tutorials* : ஒரு ஊடாடும் இணையதளம் பயனரை குறியீடு அல்லது கட்டளைகளை தட்டச்சு செய்ய அனுமதிக்கிறது மற்றும் முடிவை மதிப்பீடு செய்கிறது ("மதிப்பீடு" என்று நாங்கள் கூறும்போது "தரம்" என்று அர்த்தமல்ல). எ.கா.: [Try Haskell](http://tryhaskell.org), [Try Git](https://learngitbranching.js.org).
    - *Playgrounds* : நிரலாக்கத்தைக் கற்றுக்கொள்வதற்கான ஆன்லைன் மற்றும் ஊடாடும் இணையதளங்கள், விளையாட்டுகள் அல்லது டெஸ்க்டாப் மென்பொருள். குறியீட்டை எழுதி, தொகுத்து (அல்லது இயக்கி), மற்றும் குறியீட்டுத் துணுக்குகளைப் பகிரலாம். Playgrounds பெரும்பாலும் குறியீட்டை விளையாடுவதன் மூலம் Fork செய்து கைகளை அழுக்காக்க உங்களை அனுமதிக்கிறது.
    - *Podcasts and Screencasts* : Podcasts மற்றும் screencasts.
    - *Problem Sets & Competitive Programming* : குறியீடு மதிப்பாய்வுடன் அல்லது இல்லாமல், மற்ற பயனர்களுடன் முடிவுகளை ஒப்பிடுவதன் மூலம் அல்லது இல்லாமல், எளிமையான அல்லது சிக்கலான பிரச்சினைகளைத் தீர்ப்பதன் மூலம் உங்கள் நிரலாக்கத் திறன்களை மதிப்பிட அனுமதிக்கும் ஒரு இணையதளம் அல்லது மென்பொருள்.

4. [வழிகாட்டுதல்களை](#guidelines) பின்பற்றுவதையும், கோப்புகளின் [Markdown வடிவமைப்பை](#formatting) மதிப்பதையும் உறுதிப்படுத்தவும்.

5. GitHub Actions **உங்கள் பட்டியல்கள் அகரவரிசைப்படுத்தப்பட்டுள்ளதா** மற்றும் **வடிவமைப்பு விதிகள் பின்பற்றப்படுகின்றனவா** என்பதை உறுதிசெய்ய சோதனைகளை இயக்கும். **உங்கள்** மாற்றங்கள் சோதனைகளைத் தாண்டுகின்றனவா என்பதை சரிபார்க்க உறுதிசெய்யுங்கள்.


### வழிகாட்டுதல்கள்

- ஒரு புத்தகம் இலவசமாக இருப்பதை உறுதிசெய்யுங்கள். தேவைப்பட்டால் இரண்டு முறை சரிபார்க்கவும். புத்தகம் ஏன் இலவசம் என்று நீங்கள் நினைக்கிறீர்கள் என்பது பற்றி PR-இல் கருத்து தெரிவிப்பது நிர்வாகிகளுக்கு உதவுகிறது.
- Google Drive, Dropbox, Mega, Scribd, Issuu மற்றும் அதே போன்ற கோப்பு பதிவேற்ற தளங்களில் ஹோஸ்ட் செய்யப்பட்ட கோப்புகளை நாங்கள் ஏற்றுக்கொள்வதில்லை
- உங்கள் இணைப்புகளை [கீழே](#alphabetical-order) விவரிக்கப்பட்டுள்ளபடி, அகரவரிசையில் செருகவும்.
- மிகவும் அதிகாரபூர்வ ஆதாரத்துடன் இணைப்பைப் பயன்படுத்தவும் (அதாவது ஆசிரியரின் இணையதளம் பதிப்பகத்தின் இணையதளத்தை விட சிறந்தது, அது மூன்றாம் தரப்பு இணையதளத்தை விட சிறந்தது)
    - கோப்பு ஹோஸ்டிங் சேவைகள் இல்லை (இதில் Dropbox மற்றும் Google Drive இணைப்புகள் உள்ளடங்கும் ஆனால் அவை மட்டும் அல்ல)
- அவை ஒரே டொமைனில் இருந்து ஒரே உள்ளடக்கத்தை வழங்கும் வரை, `http` இணைப்பை விட `https` இணைப்பை எப்போதும் விரும்பவும்
- ரூட் டொமைனில், பின்தொடரும் ஸ்லாஷை நீக்கவும்: `http://example.com` என்பது `http://example.com/` ஐ விட சிறந்தது
- எப்போதும் குறுகிய இணைப்பை விரும்பவும்: `http://example.com/dir/` என்பது `http://example.com/dir/index.html` ஐ விட சிறந்தது
    - URL குறுக்கி இணைப்புகள் இல்லை
- பொதுவாக "நடப்பு" இணைப்பை "பதிப்பு" இணைப்பை விட விரும்பவும்: `http://example.com/dir/book/current/` என்பது `http://example.com/dir/book/v1.0.0/index.html` ஐ விட சிறந்தது
- ஒரு இணைப்பில் காலாவதியான சான்றிதழ்/சுய-கையொப்பமிடப்பட்ட சான்றிதழ்/வேறு எந்த வகையான SSL சிக்கலும் இருந்தால்:
    1. சாத்தியமிருந்தால் அதன் `http` சகோதரத்துடன் *அதை மாற்றவும்* (ஏனெனில் மொபைல் சாதனங்களில் விதிவிலக்குகளை ஏற்றுக்கொள்வது சிக்கலாக இருக்கலாம்).
    2. `http` பதிப்பு இல்லை என்றால் ஆனால் இணைப்பு இன்னும் `https` மூலம் உலாவியில் விதிவிலக்கைச் சேர்ப்பதன் மூலம் அல்லது எச்சரிக்கையைப் புறக்கணிப்பதன் மூலம் அணுகக்கூடியதாக இருந்தால் *அதை விடவும்*.
    3. இல்லையெனில் *அதை நீக்கவும்*.
- ஒரு இணைப்பு பல வடிவங்களில் இருந்தால், ஒவ்வொரு வடிவம் பற்றிய குறிப்புடன் தனி இணைப்பைச் சேர்க்கவும்
- ஒரு வளம் இணையத்தில் பல இடங்களில் இருந்தால்
    - மிகவும் அதிகாரபூர்வ ஆதாரத்துடன் இணைப்பைப் பயன்படுத்தவும் (அதாவது ஆசிரியரின் இணையதளம் பதிப்பாளரின் இணையதளத்தை விட சிறந்தது, அது மூன்றாம் தரப்பு இணையதளத்தை விட சிறந்தது)
    - அவை வெவ்வேறு பதிப்புகளுக்கு இணைக்கப்பட்டிருந்தால், மற்றும் இந்த பதிப்புகள் வேறுபட்டவை என்று நீங்கள் தீர்மானிக்கும் போது அவற்றை வைத்திருப்பது மதிப்புமிக்கதாக இருக்கும், ஒவ்வொரு பதிப்பு பற்றிய குறிப்புடன் தனி இணைப்பைச் சேர்க்கவும் (வடிவமைப்பு பற்றிய விவாதத்தில் பங்களிக்க [Issue #2353](https://github.com/EbookFoundation/free-programming-books/issues/2353) ஐப் பார்க்கவும்).
- பெரிய கமிட்களை விட அணு கமிட்களை (ஒரு சேர்த்தல்/நீக்குதல்/மாற்றம் மூலம் ஒரு கமிட்) விரும்பவும். PR சமர்ப்பிப்பதற்கு முன் உங்கள் கமிட்களை squeeze செய்ய வேண்டியதில்லை. (பராமரிப்பாளர்களுக்கு இது வெறும் வசதி மட்டுமே என்பதால் நாங்கள் இந்த விதியை ஒருபோதும் அமல்படுத்த மாட்டோம்)
- புத்தகம் பழையதாக இருந்தால், தலைப்புடன் வெளியீட்டுத் தேதியைச் சேர்க்கவும்.
- பொருத்தமான இடங்களில் ஆசிரியரின் பெயர் அல்லது பெயர்களைச் சேர்க்கவும். "`et al.`" கொண்டு ஆசிரியர் பட்டியலைச் சுருக்கலாம்.
- புத்தகம் முடிக்கப்படவில்லை என்றால், இன்னும் அதில் வேலை நடைபெற்றுக்கொண்டிருக்கிறது என்றால், [கீழே](#in_process) விவரிக்கப்பட்டுள்ளபடி "`in process`" குறிப்பைச் சேர்க்கவும்.
- ஒரு வளம் [*இணைய காப்பக வேபேக் மெஷின்*](https://web.archive.org) (அல்லது அதே போன்றவை) பயன்படுத்தி மீட்டமைக்கப்பட்டால், [கீழே](#archived) விவரிக்கப்பட்டுள்ளபடி "`archived`" குறிப்பைச் சேர்க்கவும். பயன்படுத்த சிறந்த பதிப்புகள் சமீபத்தியவை மற்றும் முழுமையானவை.
- பதிவிறக்கம் செயல்படுவதற்கு முன் மின்னஞ்சல் முகவரி அல்லது கணக்கு அமைப்பு கோரப்பட்டால், அடைப்புக்குறிகளில் மொழி-பொருத்தமான குறிப்புகளைச் சேர்க்கவும், எ.கா.: `(மின்னஞ்சல் முகவரி *கோரப்பட்டது*, தேவையில்லை)`.


### வடிவமைப்பு

- அனைத்து பட்டியல்களும் `.md` கோப்புகள். [Markdown](https://guides.github.com/features/mastering-markdown/) தொடரியலைக் கற்க முயற்சிக்கவும். அது எளிமையானது!
- அனைத்து பட்டியல்களும் அட்டவணையுடன் தொடங்குகின்றன. அனைத்துப் பிரிவுகளையும் உட்பிரிவுகளையும் பட்டியலிட்டு இணைப்பதே யோசனை. அதை அகரவரிசையில் வைத்திருங்கள்.
- பிரிவுகள் மூன்றாம் நிலை தலைப்புகளைப் (`###`) பயன்படுத்துகின்றன, மற்றும் உப பிரிவுகள் நான்காம் நிலை தலைப்புகள் (`####`).

யோசனை இருக்க வேண்டும்:

- கடைசி இணைப்பு மற்றும் புதிய பிரிவுக்கு இடையில் `2` வெற்று வரிகள்.
- தலைப்பு & அதன் பிரிவின் முதல் இணைப்புக்கு இடையில் `1` வெற்று வரி.
- இரண்டு இணைப்புகளுக்கு இடையில் `0` வெற்று வரி.
- ஒவ்வொரு `.md` கோப்பின் முடிவிலும் `1` வெற்று வரி.

உதாரணம்:

```text
[...]
* [அற்புதமான புத்தகம்](http://example.com/example.html)

                                
### உதாரணம்
                                
* [மற்றொரு அற்புதமான புத்தகம்](http://example.com/book.html)
* [வேறு ஒரு புத்தகம்](http://example.com/other.html)
```

- `]` மற்றும் `(` க்கு இடையில் இடைவெளிகளை வைக்க வேண்டாம்:

    ```text
    தவறு : * [மற்றொரு அற்புதமான புத்தகம்] (http://example.com/book.html)
    சரி  : * [மற்றொரு அற்புதமான புத்தகம்](http://example.com/book.html)
    ```

- நீங்கள் ஆசிரியரை சேர்த்தால், ` - ` (ஒற்றை இடைவெளிகளால் சூழப்பட்ட கோடு) ஐப் பயன்படுத்தவும்:

    ```text
    தவறு : * [மற்றொரு அற்புதமான புத்தகம்](http://example.com/book.html)- ஜான் டோ
    சரி  : * [மற்றொரு அற்புதமான புத்தகம்](http://example.com/book.html) - ஜான் டோ
    ```

- இணைப்பு மற்றும் அதன் வடிவத்திற்கு இடையில் ஒரு இடைவெளியை வைக்கவும்:

    ```text
    தவறு : * [மிக அற்புதமான புத்தகம்](https://example.org/book.pdf)(PDF)
    சரி  : * [மிக அற்புதமான புத்தகம்](https://example.org/book.pdf) (PDF)
    ```

- ஆசிரியர் வடிவத்திற்கு முன் வருகிறார்:

    ```text
    தவறு : * [மிக அற்புதமான புத்தகம்](https://example.org/book.pdf)- (PDF) ஜேன் ரோ
    சரி  : * [மிக அற்புதமான புத்தகம்](https://example.org/book.pdf) - ஜேன் ரோ (PDF)
    ```

- பல வடிவங்கள் (ஒவ்வொரு ஆதாரத்திற்கும் ஒற்றை இணைப்பை நாங்கள் விரும்புகிறோம். பல்வேறு வடிவங்களுக்கு எளிதாக அணுகக்கூடிய ஒற்றை இணைப்பு இல்லாதபோது, பல இணைப்புகள் பொருள்படலாம். ஆனால் நாங்கள் சேர்க்கும் ஒவ்வொரு இணைப்பும் பராமரிப்புச் சுமையை உருவாக்குவதால் நாங்கள் அதைத் தவிர்க்க முயற்சிக்கிறோம்.):

    ```text
    தவறு : * [மற்றொரு அற்புதமான புத்தகம்](http://example.com/)- ஜான் டோ (HTML)
    தவறு : * [மற்றொரு அற்புதமான புத்தகம்](https://downloads.example.org/book.html)- ஜான் டோ (பதிவிறக்க தளம்)
    சரி  : * [மற்றொரு அற்புதமான புத்தகம்](http://example.com/) - ஜான் டோ (HTML) [(PDF, EPUB)](https://downloads.example.org/book.html)
    ```

- பழைய புத்தகங்களுக்கு தலைப்பில் வெளியீட்டு ஆண்டைச் சேர்க்கவும்:

    ```text
    தவறு : * [மிக அற்புதமான புத்தகம்](https://example.org/book.html) - ஜேன் ரோ - 1970
    சரி  : * [மிக அற்புதமான புத்தகம் (1970)](https://example.org/book.html) - ஜேன் ரோ
    ```

- <a id="in_process"></a>செயல்பாட்டில் உள்ள புத்தகங்கள்:

    ```text
    சரி  : * [விரைவில் ஒரு அற்புதமான புத்தகமாக இருக்கும்](http://example.com/book2.html) - ஜான் டோ (HTML) *(:construction: செயலில் உள்ளது)*
    ```

- <a id="archived"></a>காப்பகப்படுத்தப்பட்ட இணைப்பு:

    ```text
    சரி  : * [பழைய சுவாரஸ்யமான புத்தகம்](https://web.archive.org/web/20211016123456/http://example.com/) - ஜான் டோ (HTML) *(:card_file_box: காப்பகப்படுத்தப்பட்டது)*
    ```

- <a id="license"></a>இலவச உரிமங்கள் ("அனைத்து உரிமைகளும் கொண்ட" ஆனால் படிக்க இலவசமான வளங்களை நாங்கள் சேர்க்கும் அதே நேரத்தில், கிரியேட்டிவ் காமன்ஸ் போன்ற இலவச உரிமங்களின் பயன்பாட்டை நாங்கள் ஊக்குவிக்கிறோம்):

    ```text
    சரி  : * [மிக அற்புதமான புத்தகம்](https://example.org/book.pdf) - ஜேன் ரோ (PDF) (CC BY-SA)
    ```

    ஆதரிக்கப்படும் உரிமங்கள் (பதிப்பு இல்லை):

    - `CC BY` 'Creative Commons attribution'
    - `CC BY-NC` 'Creative Commons non-commercial'
    - `CC BY-SA` 'Creative Commons share-alike'
    - `CC BY-NC-SA` 'Creative Commons non-commercial, share-alike'
    - `CC BY-ND` 'Creative Commons no-derivatives'
    - `CC BY-NC-ND` 'Creative Commons non-commercial, no-derivatives'
    - `GFDL` 'Gnu Free Documentation License'

#### உரிமக் குறிப்பைச் சேர்த்தல் (படிப்படியாக)

ஒரு வளம் இலவச/திறந்த உரிமத்தின் கீழ் விநியோகிக்கப்படும்போது, வடிவக் குறிப்புக்குப் பிறகு அடைப்புக்குறிகளில் ஒரு குறுகிய உரிமக் குறிப்பைச் சேர்க்கவும். இந்த படிகளைப் பின்பற்றவும்:

1. வள பக்கத்தில் உரிமத்தை உறுதிப்படுத்தவும்.
   - தளத்தின் அடிக்குறிப்பு, "பற்றி" பக்கம் அல்லது உரிமம்/சட்ட பிரிவைத் தேடுங்கள்.
   - இலவச/திறந்த உள்ளடக்க உரிமங்களுக்கு மட்டுமே உரிம குறிப்புகளைச் சேர்க்கவும் (மேலே ஆதரிக்கப்படும் பட்டியலைப் பார்க்கவும்). "அனைத்து உரிமைகளும் உள்ளன" போன்ற குறிப்புகளைச் சேர்க்க வேண்டாம்.
2. பதிப்பு எண் இல்லாமல் ஆதரிக்கப்படும் சுருக்கக் குறியீடுகளில் ஒன்றாக உரிம சரத்தை நிலைப்படுத்தவும்.
   - உதாரணங்கள்: "Creative Commons Attribution 4.0" → `CC BY`; "CC BY-SA 3.0" → `CC BY-SA`; "GNU Free Documentation License" → `GFDL`.
3. வடிவம் (வடிவங்கள்) மற்றும் வேறு எந்த குறிப்புகளுக்கும் இடையில் உரிமத்தை வைக்கவும்.
   - ஒற்றை வடிவம்:
     ```markdown
     * [மிக அற்புதமான புத்தகம்](https://example.org/book.pdf) - ஜேன் ரோ (PDF) (CC BY-SA)
     ```
   - பல வடிவங்கள்:
     ```markdown
     * [அருமையான வழிகாட்டி](https://example.org/) - ஜேன் ரோ (HTML, PDF) (CC BY)
     ```
   - கூடுதல் குறிப்புடன் (எ.கா., காப்பகப்படுத்தப்பட்டது அல்லது செயல்பாட்டில் உள்ளது):
     ```markdown
     * [பழையது ஆனால் பொன்னானது](https://web.archive.org/web/20211016123456/http://example.com/) - ஜான் டோ (HTML) (CC BY) *(:card_file_box: காப்பகப்படுத்தப்பட்டது)*
     ```
4. வெவ்வேறு பதிப்புகள்/வடிவங்களுக்கு வெவ்வேறு உரிமங்கள் இருந்தால், அவற்றை தனி உருப்படிகளாகப் பட்டியலிட்டு ஒவ்வொரு உள்ளீட்டிலும் சரியான உரிமத்தைக் குறிப்பிடவும்.
5. உங்களுக்கு உறுதியாகத் தெரியவில்லை என்றால், வளம் இலவச உரிமத்தின் கீழ் உள்ளது என்று நீங்கள் ஏன் நம்புகிறீர்கள் மற்றும் தகவலைக் கண்டுபிடித்த இடம் பற்றி விளக்கும் கருத்தை உங்கள் PR-இல் சேர்க்கவும்.


### அகரவரிசை வரிசை

- அதே எழுத்தில் தொடங்கும் பல தலைப்புகள் இருக்கும்போது இரண்டாவது எழுத்தின்படி, மேலும் அதே போல வரிசைப்படுத்தவும். உதாரணமாக: `aa` என்பது `ab`-க்கு முன் வரும்.
- `one two` என்பது `onetwo` க்கு முன் வரும்

தவறான இடத்தில் உள்ள இணைப்பை நீங்கள் பார்த்தால், எந்த வரிகள் மாற்றப்பட வேண்டும் என்பதை அறிய linter பிழை செய்தியைச் சரிபார்க்கவும்.


### குறிப்புகள்

அடிப்படைகள் ஒப்பீட்டளவில் எளிமையானவை என்றாலும், நாங்கள் பட்டியலிடும் வளங்களில் பெரும் பன்முகத்தன்மை உள்ளது. இந்த வேறுபாட்டை நாங்கள் எவ்வாறு கையாளுகிறோம் என்பதைப் பற்றிய சில குறிப்புகள் இங்கே.


#### மெட்டாடேட்டா

எங்கள் பட்டியல்கள் குறைந்தபட்ச மெட்டாடேட்டா தொகுப்பை வழங்குகின்றன: தலைப்புகள், URL கள், படைப்பாளிகள், தளங்கள் மற்றும் அணுகல் குறிப்புகள்.


##### தலைப்புகள்

- சுயமாக தலைப்புகளை உருவாக்க வேண்டாம். வளங்களிலிருந்து தலைப்புகளை எடுக்க நாங்கள் முயற்சிக்கிறோம்; பங்களிப்பாளர்களுக்கு இதைத் தவிர்க்க முடிந்தால் தலைப்புகளைக் கண்டுபிடிக்கவோ அல்லது ஆசிரியராகப் பயன்படுத்தவோ கூடாது என்று எச்சரிக்கப்படுகிறது. பழைய படைப்புகளுக்கு ஒரு விதிவிலக்கு; அவை முதன்மையாக வரலாற்று ஆர்வமாக இருந்தால், தலைப்புடன் இணைக்கப்பட்ட ஒரு ஆண்டு அடைப்புக்குறிகளில், பயனர்களுக்கு அவை ஆர்வமாக உள்ளதா என்பதை அறிய உதவுகிறது.
- ALLCAPS தலைப்புகள் இல்லை. வழக்கமாக தலைப்பு எழுத்து முறை பொருத்தமானது, ஆனால் சந்தேகம் இருக்கும்போது ஆதாரத்திலிருந்து பெரிய எழுத்தைப் பயன்படுத்தவும்
- எமோஜிகள் இல்லை.


##### URL கள்

- குறுக்கப்பட்ட URL களை நாங்கள் அனுமதிக்கவில்லை.
- கண்காணிப்பு குறியீடுகள் URL இலிருந்து நீக்கப்பட வேண்டும்.
- சர்வதேச URL கள் குறியேற்றம் செய்யப்பட வேண்டும். உலாவி பட்டிகள் பொதுவாக இவற்றை யூனிகோடிற்கு காட்சியளிக்கின்றன, ஆனால் நகலெடுத்து ஒட்டவும், தயவுசெய்து.
- பாதுகாப்பான (`https`) URL கள் HTTPS செயல்படுத்தப்பட்ட இடங்களில் பாதுகாப்பற்ற (`http`) url களை விட எப்போதும் விரும்பப்படுகின்றன.
- பட்டியலிடப்பட்ட வளத்தை ஹோஸ்ட் செய்யாத, ஆனால் வேறு இடத்தைச் சுட்டிக்காட்டும் வலைப்பக்கங்களைச் சுட்டிக்காட்டும் URL களை நாங்கள் விரும்புவதில்லை.


##### படைப்பாளிகள்

- மொழிபெயர்ப்பாளர்கள் உட்பட, இலவச வளங்களின் படைப்பாளிகளுக்கு பொருத்தமான இடங்களில் கடன் அளிக்க விரும்புகிறோம்!
- மொழிபெயர்க்கப்பட்ட படைப்புகளுக்கு, அசல் ஆசிரியர் கடன் பெற வேண்டும். ஆசிரியர்கள் தவிர மற்ற படைப்பாளிகளுக்கு கடன் அளிக்க நாங்கள் [MARC relators](https://loc.gov/marc/relators/relaterm.html) ஐப் பயன்படுத்த பரிந்துரைக்கிறோம், இந்த உதாரணத்தில் உள்ளது போல:

    ```markdown
    * [A Translated Book](http://example.com/book.html) - John Doe, `trl.:` Mike The Translator
    ```

    இங்கே, குறிப்பு `trl.:` "மொழிபெயர்ப்பாளர்" க்கான MARC relator குறியீட்டைப் பயன்படுத்துகிறது.
- ஆசிரியர் பட்டியலில் ஒவ்வொரு உருப்படியையும் பிரிக்க காற்புள்ளியைப் `,` பயன்படுத்தவும்.
- "`et al.`" கொண்டு ஆசிரியர் பட்டியல்களை சுருக்கலாம்.
- படைப்பாளிகளுக்கு இணைப்புகளை நாங்கள் அனுமதிக்கவில்லை.
- தொகுப்பு அல்லது ரீமிக்ஸ் செய்யப்பட்ட படைப்புகளுக்கு, "படைப்பாளர்" விளக்கம் தேவைப்படலாம். உதாரணமாக, "GoalKicker" அல்லது "RIP Tutorial" புத்தகங்கள் "`StackOverflow documentation இலிருந்து தொகுக்கப்பட்டது`" என கடன் அளிக்கப்படுகின்றன.
- நாங்கள் படைப்பாளர் பெயர்களில் "Prof." அல்லது "Dr." போன்ற கௌரவங்களை சேர்க்கவில்லை.


##### கால வரம்புள்ள பாடநெறிகள் மற்றும் சோதனைகள்

- ஆறு மாதங்களில் நாங்கள் அகற்ற வேண்டிய விஷயங்களை நாங்கள் பட்டியலிடவில்லை.
- ஒரு பாடநெறிக்கு வரையறுக்கப்பட்ட சேர்க்கை காலம் அல்லது காலம் இருந்தால், நாங்கள் அதை பட்டியலிட மாட்டோம்.
- குறிப்பிட்ட காலத்திற்கு இலவசமாக உள்ள வளங்களை நாங்கள் பட்டியலிட முடியாது.


##### தளங்கள் மற்றும் அணுகல் குறிப்புகள்

- படிப்புகள். குறிப்பாக எங்கள் பாடநெறி பட்டியல்களுக்கு, தளம் என்பது வள விளக்கத்தின் ஒரு முக்கிய பகுதியாகும். இதற்கு காரணம், பாடநெறி தளங்கள் வெவ்வேறு affordances மற்றும் அணுகல் மாடல்களைக் கொண்டுள்ளன. பதிவு தேவைப்படும் புத்தகத்தை நாங்கள் பொதுவாகப் பட்டியலிடாத போதிலும், பல பாடநெறித் தளங்களில் எந்தவொரு வகையான கணக்கு இல்லாமல் செயல்படாத affordances உள்ளன. உதாரணமான பாடநெறித் தளங்களில் Coursera, EdX, Udacity மற்றும் Udemy ஆகியவை அடங்கும். ஒரு பாடநெறி ஒரு தளத்தைச் சார்ந்திருக்கும் போது, தளத்தின் பெயர் அடைப்புக்குறிகளில் பட்டியலிடப்பட வேண்டும்.
- YouTube. YouTube பிளேலிஸ்ட்களைக் கொண்ட பல பாடநெறிகள் எங்களிடம் உள்ளன. நாங்கள் YouTube ஐ ஒரு தளமாகப் பட்டியலிடவில்லை, ஒரு துணை தளமாக இருக்கும் YouTube படைப்பாளரைப் பட்டியலிட முயற்சிக்கிறோம்.
- YouTube வீடியோக்கள். அவை ஒரு மணி நேரத்திற்கும் மேலாக இருந்து, ஒரு பாடநெறி அல்லது பயிற்சி போல வடிவமைக்கப்பட்டிருந்தால் தவிர, நாங்கள் பொதுவாக தனிப்பட்ட YouTube வீடியோக்களுக்கு இணைக்கமாட்டோம். அப்படி இருந்தால், அதை PR விளக்கத்தில் குறிப்பிடுவதை உறுதிசெய்க.
- குறுக்கப்பட்ட (அதாவது youtu.be/xxxx) இணைப்புகள் இல்லை!
- Leanpub. Leanpub பல்வேறு அணுகல் மாடல்களுடன் புத்தகங்களை ஹோஸ்ட் செய்கிறது. சில சமயங்களில் ஒரு புத்தகத்தை பதிவு இல்லாமல் படிக்க முடியும்; சில சமயங்களில் இலவச அணுகலுக்கு ஒரு Leanpub கணக்கு தேவைப்படும் புத்தகம். புத்தகங்களின் தரம் மற்றும் Leanpub அணுகல் மாடல்களின் கலவை மற்றும் திரவத்தன்மை காரணமாக, அணுகல் குறிப்புடன் `*(Leanpub கணக்கு அல்லது செல்லுபடியாகும் மின்னஞ்சல் கோரப்பட்டது)*` பின்னதைப் பட்டியலிட அனுமதிக்கிறோம்.


#### வகைகள்

ஒரு வளம் எந்த பட்டியலில் சேர்ந்தது என்பதைத் தீர்மானிப்பதில் முதல் விதி, வளம் எவ்வாறு தன்னைப் பற்றி விவரிக்கிறது என்பதைப் பார்ப்பது. அது தன்னை ஒரு புத்தகம் என்று அழைத்தால், ஒருவேளை அது ஒரு புத்தகமாக இருக்கலாம்.


##### நாங்கள் பட்டியலிடாத வகைகள்

இணையம் பரந்து விரிந்து இருப்பதால், எங்கள் பட்டியல்களில் நாங்கள் சேர்ப்பதில்லை:

- வலைப்பதிவுகள்
- வலைப்பதிவு இடுகைகள்
- கட்டுரைகள்
- இணையதளங்கள் (நாங்கள் பட்டியலிடும் பல பொருட்களை ஹோஸ்ட் செய்யும் வலைத்தளங்கள் தவிர).
- பாடநெறிகள் அல்லது திரைக்காட்சிகள் அல்லாத வீடியோக்கள்.
- புத்தக அத்தியாயங்கள்
- புத்தகங்களிலிருந்து ஈர்ப்பு மாதிரிகள்
- IRC அல்லது Telegram சேனல்கள்
- Slacks அல்லது மெயிலிங் பட்டியல்கள்

எங்கள் போட்டி நிரலாக்கப் பட்டியல்கள் இந்த விலக்குகள் குறித்து கடுமையாக இல்லை. repository-இன் நோக்கம் சமூகத்தால் தீர்மானிக்கப்படுகிறது; நோக்கத்தில் மாற்றம் அல்லது சேர்க்கையை நீங்கள் பரிந்துரைக்க விரும்பினால், அந்த பரிந்துரையைச் செய்ய Issue ஐப் பயன்படுத்தவும்.


##### புத்தகங்கள் vs. மற்ற விஷயங்கள்

புத்தக-தனம் பற்றி நாங்கள் அவ்வளவு குறுகிய கண்ணோட்டம் கொண்டவர்கள் அல்ல. ஒரு வளம் ஒரு புத்தகம் என்பதைக் குறிக்கும் சில பண்புகள் இங்கே:

- அதற்கு ISBN (சர்வதேச நிலையான புத்தக எண்) உள்ளது
- அதற்கு பொருளடக்க அட்டவணை உள்ளது
- பதிவிறக்கக்கூடிய பதிப்பு வழங்கப்படுகிறது, குறிப்பாக ePub கோப்புகள்.
- அதற்கு பதிப்புகள் உள்ளன
- அது ஊடாடும் உள்ளடக்கம் அல்லது வீடியோக்களை சார்ந்திருக்காது
- அது ஒரு தலைப்பை விரிவாக உள்ளடக்க முயற்சிக்கிறது
- இது சுய-உள்ளடக்கியது

இந்த பண்புகளைக் கொண்டிராத பல புத்தகங்களை நாங்கள் பட்டியலிடுகிறோம்; சூழலைப் பொறுத்து அது இருக்கலாம்.


##### புத்தகங்கள் vs. பாடநெறிகள்

சில நேரங்களில் இவற்றை வேறுபடுத்துவது கடினமாக இருக்கும்!

பாடநெறிகளுக்கு பொதுவாக எங்கள் புத்தக பட்டியல்களில் பட்டியலிடப்படும் தொடர்புடைய பாடப்புத்தகங்கள் உள்ளன. பாடநெறிகளில் விரிவுரைகள், பயிற்சிகள், சோதனைகள், குறிப்புகள் அல்லது பிற கல்வி உதவிகள் உள்ளன. ஒரு விரிவுரை அல்லது வீடியோ மட்டுமே ஒரு பாடநெறி அல்ல. ஒரு பவர்பாயின்ட் ஒரு பாடநெறி அல்ல.


##### ஊடாடும் பயிற்சிகள் vs. மற்ற விஷயங்கள்

நீங்கள் அதை அச்சிட்டு அதன் சாரத்தைத் தக்கவைத்துக் கொள்ள முடிந்தால், அது ஒரு ஊடாடும் பயிற்சி அல்ல.


### ஆட்டோமேஷன்

- வடிவமைப்பு விதிகள் அமலாக்கம் [fpb-lint](https://github.com/vhf/free-programming-books-lint) ஐப் பயன்படுத்தி [GitHub Actions](https://github.com/features/actions) மூலம் தானியங்குபடுத்தப்படுகிறது (பார்க்கவும் [`.github/workflows/fpb-lint.yml`](../.github/workflows/fpb-lint.yml))
- URL சரிபார்ப்பு [awesome_bot](https://github.com/dkhamsing/awesome_bot) ஐப் பயன்படுத்துகிறது
- URL சரிபார்ப்பைத் தூண்ட, `check_urls=file_to_check` என்ற கமிட் செய்தியைக் கொண்ட ஒரு கமிட்டை அனுப்பவும்:

    ```properties
    check_urls=free-programming-books.md free-programming-books-en.md
    ```

- ஒரு உள்ளீட்டைப் பிரிக்க ஒற்றை இடைவெளியைப் பயன்படுத்தி, சரிபார்க்க ஒன்றுக்கும் மேற்பட்ட கோப்பைக் குறிப்பிடலாம்.
- நீங்கள் ஒன்றுக்கும் மேற்பட்ட கோப்பைக் குறிப்பிட்டால், பில்டின் முடிவுகள் சரிபார்க்கப்படும் கடைசி கோப்பின் முடிவை அடிப்படையாகக் கொண்டுள்ளன. இதன் காரணமாக நீங்கள் பச்சை கட்டுமானங்களைப் பெறலாம் என்பதை நீங்கள் அறிந்திருக்க வேண்டும், எனவே "எல்லா சோதனைகளையும் காட்டு" -> "விவரங்கள்" என்பதைக் கிளிக் செய்வதன் மூலம் Pull Request இன் முடிவில் உள்ள பில்ட் பதிவைக் கவனமாகப் பார்க்கவும்.


### RTL/LTR லின்டர் பிழைகளை சரிசெய்தல்

RTL/LTR மார்க்டவுன் லின்டரை இயக்கினால் (`*-ar.md`, `*-he.md`, `*-fa.md`, `*-ur.md` கோப்புகளில்) மற்றும் பிழைகள் அல்லது எச்சரிக்கைகள் காண்பித்தால்:

- **LTR சொற்கள்** (எ.கா. "HTML", "JavaScript") RTL உரையில்: ஒவ்வொரு LTR பிரிவுக்கும் பிறகு உடனடியாக `&rlm;` இணைக்கவும்;
- **LTR சின்னங்கள்** (எ.கா. "C#", "C++"): ஒவ்வொரு LTR சின்னத்திற்கும் பிறகு உடனடியாக `&lrm;` இணைக்கவும்;

#### உதாரணங்கள்

**தவறு**
```html
<div dir="rtl" markdown="1">
* [كتاب الأمثلة في R](URL) - John Doe (PDF)
</div>
```
**சரி**
```html
<div dir="rtl" markdown="1">
* [كتاب الأمثلة في R&rlm;](URL) - John Doe&rlm; (PDF)
</div>
```
---
**தவறு**
```html
<div dir="rtl" markdown="1">
* [Tech Podcast - بودكاست المثال](URL) – Ahmad Hasan, محمد علي
</div>
```
**சரி**
```html
<div dir="rtl" markdown="1">
* [Tech Podcast - بودكاست المثال](URL) – Ahmad Hasan,&rlm; محمد علي
</div>
```
---
**தவறு**
```html
<div dir="rtl" markdown="1">
* [أساسيات C#](URL)
</div>
```
**சரி**
```html
<div dir="rtl" markdown="1">
* [أساسيات C#&lrm;](URL)
</div>
```
