# How-To at a glance

<div align="right" markdown="1">

*[Read this in other languages](README.md#translations)*

</div>

**Welcome to `Free-Programming-Books`!**

We welcome new contributors; even those making their very first Pull Request (PR) on GitHub. If you're one of those, here are some resources that might help:

* [About pull requests](https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests)
* [Creating a pull request](https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/creating-a-pull-request)
* [GitHub Hello World](https://docs.github.com/en/get-started/quickstart/hello-world)
* [YouTube - GitHub Tutorial For Beginners](https://www.youtube.com/watch?v=0fKg7e37bQE)
* [YouTube - How To Fork A GitHub Repo and Submit A Pull Request](https://www.youtube.com/watch?v=G1I3HF4YWEw)
* [YouTube - Markdown Crash Course](https://www.youtube.com/watch?v=HUBNt18RFbo)


Don't hesitate to ask questions; every contributor started with a first PR. So... why not join our [large, growing](https://www.apiseven.com/en/contributor-graph?chart=contributorOverTime&repo=ebookfoundation/free-programming-books) community.

<details align="center" markdown="1">
<summary>Click to see users vs. time graphs.</summary>

[![EbookFoundation/free-programming-books's Contributor over time Graph](https://contributor-overtime-api.apiseven.com/contributors-svg?chart=contributorOverTime&repo=ebookfoundation/free-programming-books)](https://www.apiseven.com/en/contributor-graph?chart=contributorOverTime&repo=ebookfoundation/free-programming-books)

[![EbookFoundation/free-programming-books's Monthly Active Contributors graph](https://contributor-overtime-api.apiseven.com/contributors-svg?chart=contributorMonthlyActivity&repo=ebookfoundation/free-programming-books)](https://www.apiseven.com/en/contributor-graph?chart=contributorMonthlyActivity&repo=ebookfoundation/free-programming-books)

</details>

Even if you're an experienced open source contributor, there are things that might trip you up. Once you've submitted your PR, ***GitHub Actions* will run a *linter*, often finding little issues with spacing or alphabetization**. If you get a green button, everything is ready for review; but if not, click "Details" under the check that failed to find out what the linter didn't like, and fix the problem adding a new commit to the branch from which your PR was opened.

Finally, if you're not sure that the resource you want to add is appropriate for `Free-Programming-Books`, read through the guidelines in [CONTRIBUTING](CONTRIBUTING.md) *([translations](README.md#translations) also available)*.
