# Contributing guidelines

These are the rules that applies to new pull requests:

- Use the following format: `[Item Name](link) - A short description ends with a period (Keep descriptions concise).`.
- Link additions should be added in alphabetical order of the relevant category.
- Should only have one level of nested lists.
- Don't add more than one link per line.
- Make an individual pull request for each suggestion.
- New categories or naming improvements to the existing categorization are welcome.
- Third-party tools/resources that can be combined or complements the ArcGIS Platform are welcome, they just need to have an open source or freemium version.

Keep in mind that this repository is mainly targeted to developers new to [ArcGIS Location Platform](https://location.arcgis.com) with no geographic information systems background. Because of this, we are not including advance tools like Desktop applications that requires a GIS background.

## Before submitting your PR

Run: `npm run lint` to verify you the styling rules are met.

## Check broken links (optional)

Run `npx markdown-link-check README.md` to ensure no other link is broken, if it is, please [open an issue](https://github.com/Esri/awesome-arcgis-developers/issues/new).

## Update toc

Run: `npm run toc` to update the table of contents.