# Colab Tutorial Notebooks

This page collects the official Colab notebooks for EvoAgentX.  
Click the **Open in Colab** badge to launch a runnable copy in your browser.

> Tip: Each notebook starts with an installation cell. Run cells in order.  
> For heavier workloads, you may switch Colab to a GPU runtime (optional).

---

## At a Glance

- **7 ready-to-run notebooks** covering core usage, workflows, tools, and optimization.
- **Zero local install** — everything runs in Colab.
- **Copy–paste friendly** snippets you can reuse in your own projects.

---

## Quickstart

[![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/EvoAgentX/EvoAgentX/blob/main/docs/ColabNotebook/tutorial_notebooks/quickstart.ipynb)
&nbsp;•&nbsp;[View on GitHub](https://github.com/EvoAgentX/EvoAgentX/blob/main/docs/ColabNotebook/tutorial_notebooks/quickstart.ipynb)

A minimal, end-to-end tour of EvoAgentX: install, configure, and run a tiny workflow in minutes.

---

## First Agent

[![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/EvoAgentX/EvoAgentX/blob/main/docs/ColabNotebook/tutorial_notebooks/first_agent.ipynb)
&nbsp;•&nbsp;[View on GitHub](https://github.com/EvoAgentX/EvoAgentX/blob/main/docs/ColabNotebook/tutorial_notebooks/first_agent.ipynb)

Build your first agent from scratch—key concepts, configuration, and reusable code patterns.

---

## First Workflow

[![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/EvoAgentX/EvoAgentX/blob/main/docs/ColabNotebook/tutorial_notebooks/first_workflow.ipynb)
&nbsp;•&nbsp;[View on GitHub](https://github.com/EvoAgentX/EvoAgentX/blob/main/docs/ColabNotebook/tutorial_notebooks/first_workflow.ipynb)

Compose multiple steps into a reusable workflow: nodes, dependencies, and data flow.

---

## Tools

[![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/EvoAgentX/EvoAgentX/blob/main/docs/ColabNotebook/tutorial_notebooks/tools.ipynb)
&nbsp;•&nbsp;[View on GitHub](https://github.com/EvoAgentX/EvoAgentX/blob/main/docs/ColabNotebook/tutorial_notebooks/tools.ipynb)

Attach and invoke tools (retrieval, compute, external APIs) from agents—plus common pitfalls to avoid.

---

## Benchmark & Evaluation

[![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/EvoAgentX/EvoAgentX/blob/main/docs/ColabNotebook/tutorial_notebooks/benchmark_and_evaluation.ipynb)
&nbsp;•&nbsp;[View on GitHub](https://github.com/EvoAgentX/EvoAgentX/blob/main/docs/ColabNotebook/tutorial_notebooks/benchmark_and_evaluation.ipynb)

Run reproducible evaluations for agents/workflows: datasets, metrics, experiment tracking, and result analysis.

---

## AFlow Optimizer

[![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/EvoAgentX/EvoAgentX/blob/main/docs/ColabNotebook/tutorial_notebooks/aflow_optimizer.ipynb)
&nbsp;•&nbsp;[View on GitHub](https://github.com/EvoAgentX/EvoAgentX/blob/main/docs/ColabNotebook/tutorial_notebooks/aflow_optimizer.ipynb)

Search configuration spaces and auto-tune strategies to improve performance and robustness.

---

## TextGrad Optimizer

[![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/EvoAgentX/EvoAgentX/blob/main/docs/ColabNotebook/tutorial_notebooks/textgrad_optimizer.ipynb)
&nbsp;•&nbsp;[View on GitHub](https://github.com/EvoAgentX/EvoAgentX/blob/main/docs/ColabNotebook/tutorial_notebooks/textgrad_optimizer.ipynb)

Iteratively refine prompts or policies using TextGrad-style updates—great for complex, evolving tasks.

---

## FAQ

**Do I need to install anything locally?**  
No. Everything runs in the browser. Just execute the first installation cell in each notebook.

**Is a GPU required?**  
Not for basic demos. For large models, retrieval, or heavy workloads, enabling a GPU can help.

**Can I run the notebooks locally?**  
Yes. Download the `.ipynb` and open it in Jupyter or VS Code. Install dependencies as shown at the top of each notebook.

