### Responsible Disclosure Policy

At Flowise, we prioritize security and continuously work to safeguard our systems. However, vulnerabilities can still exist. If you identify a security issue, please report it to us so we can address it promptly. Your cooperation helps us better protect our platform and users.

### Out of scope vulnerabilities

-   Clickjacking on pages without sensitive actions
-   CSRF on unauthenticated/logout/login pages
-   Attacks requiring MITM (Man-in-the-Middle) or physical device access
-   Social engineering attacks
-   Activities that cause service disruption (DoS)
-   Content spoofing and text injection without a valid attack vector
-   Email spoofing
-   Absence of DNSSEC, CAA, CSP headers
-   Missing Secure or HTTP-only flag on non-sensitive cookies
-   Deadlinks
-   User enumeration

### Reporting Guidelines

-   Submit your findings to https://github.com/FlowiseAI/Flowise/security
-   Provide clear details to help us reproduce and fix the issue quickly.

### Disclosure Guidelines

-   Do not publicly disclose vulnerabilities until we have assessed, resolved, and notified affected users.
-   If you plan to present your research (e.g., at a conference or in a blog), share a draft with us at least **30 days in advance** for review.
-   Avoid including:
    -   Data from any Flowise customer projects
    -   Flowise user/customer information
    -   Details about Flowise employees, contractors, or partners

### Response to Reports

-   We will acknowledge your report within **5 business days** and provide an estimated resolution timeline.
-   Your report will be kept **confidential**, and your details will not be shared without your consent.

We appreciate your efforts in helping us maintain a secure platform and look forward to working together to resolve any issues responsibly.
