# Contribution Guidelines

Please ensure your pull request adheres to the following guidelines:

- Please remember that only **open-source units/components** and **freeware tools** are considered. No commercial projects allowed!
- Dead projects are mainly ignored except for those which do not have alive analogs. Would be nice to mention if a project isn't maintained anymore.
- Search previous suggestions before making a new one, as yours may be a duplicate.
- Make sure your suggestion is useful before submitting. That implies it having enough content and every item a good succinct description.
- Make an individual pull request for each suggestion.
- Use the following format: ```[Title](link). `[Compiler1]` `[Compiler2]` Short author description <LineBreak> // *Your short comment*``` where:
	- `Title` is the official name of a project
	- `link` points to source repository or, *if absent*, any info/download page. If you feel necessary to add a link to some site and a repository info doesn't point to it (no README or whatever), you can add link(s) after the main one: `[Title](link) ([Docs](example.com), [Active fork](example.com), etc).`
	- `[Compiler]` shows which Pascal compilers or dialects a project supports officially. Note it must be enclosed in back quotes `` for visual accent and square brackets `[]` for searching. Currently these entries are allowed:
		- `Delphi`
		- `FPC` - FreePascal
		- `any` - every Pascal dialect
		- `unk` - unknown

	  Add a new dialect if it is missing, f.ex. `Oxygene`
	- `Short author description` strictly starts from a definition of a project. No **articles** or **project name repetitions** is allowed!
		- :white_check_mark: Good: `[Hello world](example.com). Classic minimal project.`
		- :x: Bad: `[Hello world](example.com). A classic minimal project.` (article)
		- :x: Bad: `[Hello world](example.com). Hello world is classic minimal project.` (project name repeated)
	- `Your short comment` (*optional*) is a really short comment that you're sure will be useful for others
- New items should be added to the bottom of the relevant category.
- New categories or improvements to the existing categorization are welcome. In most cases, new category should go **before** `Unit Testing` category as the end of the list is dedicated for developer tools and then various utilities.
- Check your spelling and grammar.
- The pull request and commit should have a useful title.

Thank you for your suggestions!
