# Audio

This directory contains notebooks and resources for working with audio data on Google Cloud, including music generation and speech synthesis.

## Music

The `music` directory contains resources for music generation.

**Notebooks:**

- [Lyria 2 Music Generation](music/getting-started/lyria2_music_generation.ipynb): Learn how to use the Vertex AI API to interact with Lyria 2 to generate music from text prompts.

## Speech

The `speech` directory contains resources for speech synthesis and processing.

**Notebooks:**

- [Get started with Chirp 3 instant custom voice](speech/getting-started/get_started_with_chirp3_instant_custom_voice.ipynb): A guide to creating instant custom voices with Chirp 3.
- [Get started with Chirp 2 SDK](speech/getting-started/get_started_with_chirp_2_sdk.ipynb): An introduction to the Chirp 2 SDK for speech synthesis.
- [Get started with Chirp 2 SDK features](speech/getting-started/get_started_with_chirp_2_sdk_features.ipynb): Explore the features of the Chirp 2 SDK.
- [Get started with Chirp 3 HD voices](speech/getting-started/get_started_with_chirp_3_hd_voices.ipynb): A guide to using high-definition voices with Chirp 3.
- [Get started with Gemini TTS voices](speech/getting-started/get_started_with_gemini_tts_voices.ipynb): Learn how to use Gemini's text-to-speech voices.
