# Function Calling in Gemini

<!-- markdownlint-disable MD036 -->

**YouTube Video: AI + your code: Function Calling**

<!-- markdownlint-enable MD036 -->

<!-- markdownlint-disable MD033 -->
<a href="https://www.youtube.com/watch?v=NbAGbXr4DME&list=PLIivdWyY5sqLvGdVLJZh2EMax97_T-OIB" target="_blank">
  <img src="https://img.youtube.com/vi/NbAGbXr4DME/maxresdefault.jpg" alt="AI + your code: Function Calling" width="500">
</a>
<!-- markdownlint-enable MD033 -->

[Function Calling in Gemini](https://cloud.google.com/vertex-ai/generative-ai/docs/multimodal/function-calling)
lets developers create a description of a function in their code, then pass that
description to a language model in a request. The response from the model
includes the name of a function that matches the description and the arguments
to call it with.

## Sample notebooks and apps

| Description                                                                    | Sample Name                                                                          |
| ------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------ |
| Intro to Function Calling in Gemini                                            | [intro_function_calling.ipynb](intro_function_calling.ipynb)                         |
| Working with Parallel Function Calls and Multiple Function Responses in Gemini | [parallel_function_calling.ipynb](parallel_function_calling.ipynb)                   |
| Working with Data Structures and Schemas in Gemini Function Calling            | [function_calling_data_structures.ipynb](function_calling_data_structures.ipynb)     |
| Forced Function Calling with Tool Configurations in Gemini                     | [forced_function_calling.ipynb](forced_function_calling.ipynb)                       |
| SQL Talk: Natural Language to BigQuery with Gemini's Function Calling          | [sql-talk-app](sql-talk-app)                                                         |
| Using Gemini Function Calling to get Real-Time Company News and Insights       | [use_case_company_news_and_insights.ipynb](use_case_company_news_and_insights.ipynb) |
| Intro to ReAct Agents with Gemini & Function Calling                           | [intro_diy_react_agent.ipynb](intro_diy_react_agent.ipynb)                           |
