# Getting Started with Gemini

This directory contains notebooks that will help you get started with the Gemini family of models on Google Cloud.

## Notebooks

- [Intro to Gemini 2.0 Flash](intro_gemini_2_0_flash.ipynb): Learn how to use the Gemini 2.0 Flash model with the Gemini API in Vertex AI and the Google Gen AI SDK for Python.
- [Intro to Gemini 2.0 Flash-Lite](intro_gemini_2_0_flash_lite.ipynb): Learn how to use the Gemini 2.0 Flash-Lite model, our fastest and most cost-efficient Flash model.
- [Gemini 2.0 Flash Image Generation in Vertex AI](intro_gemini_2_0_image_gen.ipynb): Learn how to use Gemini 2.0 Flash for image generation and editing in Vertex AI.
- [Gemini 2.0 Flash Image Generation in Vertex AI with REST API](intro_gemini_2_0_image_gen_rest_api.ipynb): Learn how to use the Gemini 2.0 Flash for image generation and editing in Vertex AI using the REST API.
- [Intro to Gemini 2.5 Flash](intro_gemini_2_5_flash.ipynb): Learn how to use the Gemini 2.5 Flash model, a hybrid reasoning model with extended thinking capabilities.
- [Intro to Gemini 2.5 Flash-Lite](intro_gemini_2_5_flash_lite.ipynb): Learn how to use Gemini 2.5 Flash-Lite, Google's most cost-effective Gemini 2.5 model for high-volume workloads.
- [Gemini 2.5 Flash Image (Nano Banana 🍌) Generation in Vertex AI](intro_gemini_2_5_image_gen.ipynb): Learn how to use Gemini 2.5 Flash Image for image generation and conversational image editing.
- [Gemini 3 Pro Image (Nano Banana Pro 🍌) Generation in Vertex AI](intro_gemini_3_image_gen.ipynb): Learn how to use Gemini 3 Pro Image for image generation and multi-turn image editing.
- [Intro to Gemini 2.5 Pro](intro_gemini_2_5_pro.ipynb): Learn how to use Gemini 2.5 Pro, Google's most advanced reasoning model, to solve complex problems.
- [Getting Started with Chat with Gemini](intro_gemini_chat.ipynb): Learn how to send chat prompts to the Gemini model using the Google Gen AI SDK for Python and LangChain.
- [Getting Started with the Gemini API in Vertex AI with cURL / REST API](intro_gemini_curl.ipynb): Learn how to use the Vertex AI REST API with cURL commands to interact with the Gemini 2.0 Flash model.
- [Getting started with Gemini using Vertex AI in Express Mode](intro_gemini_express.ipynb): Learn how to use Vertex AI in Express Mode to quickly try out core generative AI features.
- [Getting started with Google Generative AI using the Gen AI SDK](intro_genai_sdk.ipynb): Learn about the key features of the Google Gen AI SDK for Python to get started with Google generative AI services and models.
