# Vertex AI Search

This directory contains notebooks and resources for Vertex AI Search.

## Notebooks

- [Create a Vertex AI Datastore and Search Engine](create_datastore_and_search.ipynb): Learn how to create and populate a Vertex AI Search Datastore, create a search app connected to that datastore, and submit queries through the search engine.
- [Querying Blended Data Apps and Summarization with Gemini](search_data_blending_with_gemini_summarization.ipynb): Learn how to call a search app with mixed datastore, get search snippets and summarize the response using Gemini.
- [Vertex AI Search with Filters & Metadata](search_filters_metadata.ipynb): Learn how to use filters and metadata in search requests to Vertex AI Search.

## Samples

- [Gemini Enterprise](gemini-enterprise/): Learn how to use Gemini Enterprise with Vertex AI Search.
- [Bulk Question Answering](bulk-question-answering/): Learn how to perform bulk question answering with Vertex AI Search.
- [Cloud Function](cloud-function/): Learn how to access Vertex AI Search via Google Cloud Functions.
- [Custom Embeddings](custom-embeddings/): Learn how to use custom embeddings with Vertex AI Search.
- [Custom Ranking](custom-ranking/): Learn how to use custom ranking with Vertex AI Search.
- [Ranking API](ranking-api/): Learn how to use the Ranking API with Vertex AI Search.
- [Retrieval-Augmented Generation](retrieval-augmented-generation/): Learn how to use Google Cloud Vertex AI Search, PaLM and LangChain for Retrieval Augmented Generation.
- [Tuning](tuning/): Learn how to tune Vertex AI Search.
- [VAIS Building Blocks](vais-building-blocks/): A collection of notebooks that demonstrate how different functionalities within Vertex AI Search can be used as building blocks to achieve higher-level goals.
- [Vertex AI Search Options](vertexai-search-options/): Learn about the different options available for Vertex AI Search.
- [Web App](web-app/): A demo that illustrates how to search through a corpus of documents using Vertex AI Search.
