# Google Generative AI resources

A collection of resources that helps everyone learn more about Google Generative AI offerings.

Please submit additional resources via a PR.

## Generative AI on Google Cloud

- [Generative AI on Google Cloud](https://cloud.google.com/ai/generative-ai)
- [Overview of Generative AI on Vertex AI](https://cloud.google.com/vertex-ai/generative-ai/docs/learn/overview)
- [Certifications and security controls](https://cloud.google.com/vertex-ai/generative-ai/docs/security-controls)
- [Responsible AI best practices](https://cloud.google.com/vertex-ai/generative-ai/docs/learn/responsible-ai)
- [Quotas and Limits](https://cloud.google.com/vertex-ai/generative-ai/docs/quotas)
- [Pricing](https://cloud.google.com/vertex-ai/pricing#generative_ai_models)

## Products

### Vertex AI

- Use [Vertex AI](https://cloud.google.com/vertex-ai) to interact with, customize, and embed foundation models into your applications
- Access foundation models on [Model Garden](https://cloud.google.com/model-garden)
- Tune models via a simple UI on [Vertex AI Studio](https://cloud.google.com/generative-ai-studio)
- Use [Vertex AI Search](https://cloud.google.com/products/agent-builder), to build and deploy AI agents grounded in their data
- Google foundation models
  - [Gemini API models](https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#gemini-models)
  - [Imagen API models](https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#imagen-models)
  - [MedLM API models](https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models#medlm-models)

### Gemini Models

- [Gemini](https://cloud.google.com/vertex-ai/docs/generative-ai/multimodal/overview), a multimodal model from Google DeepMind, is capable of understanding virtually any input, combining different types of information, and generating almost any output.
- Prompt and test Gemini in [Vertex AI](https://console.cloud.google.com/freetrial/?redirectPath=%2Fvertex-ai%2Fgenerative%2Fmultimodal%2Fcreate%2Ftext) using text, images, video, or code.

### Gemini for Google Cloud

- [Gemini Code Assist](https://cloud.google.com/products/gemini/code-assist) offers AI-powered assistance to help developers build applications with higher velocity, quality, and security in popular code editors like VS Code and JetBrains, and on developer platforms like Firebase.
- [Gemini for Google Cloud](https://cloud.google.com/products/gemini) offerings assist users in working and coding more effectively, gaining deeper data insights, navigating security challenges, and more.

## Get Started

- Quickstart tutorial using [Vertex AI Studio](https://cloud.google.com/vertex-ai/generative-ai/docs/start/quickstarts/quickstart) or the [Vertex AI API](https://cloud.google.com/vertex-ai/generative-ai/docs/start/quickstarts/quickstart-multimodal)
- Explore pretrained models in [Model Garden](https://cloud.google.com/vertex-ai/docs/start/explore-models)
- [Tune a Foundation model](https://cloud.google.com/vertex-ai/generative-ai/docs/models/tune-models)

## Video Courses

- [Real Terms for AI](https://goo.gle/AIwordsExplained)
- [AI Guide for Cloud Developers](https://www.youtube.com/playlist?list=PLIivdWyY5sqJio2yeg1dlfILOUO2FoFRx)
- [Intro to Gen AI - Playlist](https://www.youtube.com/playlist?list=PLBgogxgQVM9sl-KnKywVEhkb3QtLHU4OK)
  - [Introduction to Generative AI](https://www.youtube.com/watch?v=cZaNf2rA30k&list=PLBgogxgQVM9sl-KnKywVEhkb3QtLHU4OK&index=1&pp=iAQB)
  - [Introduction to Large Language Models](https://www.youtube.com/watch?v=RBzXsQHjptQ&list=PLBgogxgQVM9sl-KnKywVEhkb3QtLHU4OK&index=2&pp=iAQB)
  - [Introduction to Responsible AI](https://www.youtube.com/watch?v=w_3L1Bf2P_g&list=PLBgogxgQVM9sl-KnKywVEhkb3QtLHU4OK&index=3&pp=iAQB)
  - [Intro to Gen AI training course from Google Cloud](https://www.youtube.com/watch?v=9Eh7gsIH5h4&list=PLBgogxgQVM9sl-KnKywVEhkb3QtLHU4OK&index=4&pp=iAQB)
- [Gen AI for Developers](https://www.youtube.com/watch?v=JR9Gdo-_lx8&list=PLBgogxgQVM9s0i9oloJwjIG-zj6Svsm20)
  - [Introduction to Image Generation](https://www.youtube.com/watch?v=JR9Gdo-_lx8&list=PLBgogxgQVM9s0i9oloJwjIG-zj6Svsm20&index=1&pp=iAQB)
  - [Attention Mechanism: Overview](https://www.youtube.com/watch?v=8PmOaVYVeKY&list=PLBgogxgQVM9s0i9oloJwjIG-zj6Svsm20&index=2&pp=iAQB)
  - [Encoder-Decoder Architecture: Overview](https://www.youtube.com/watch?v=671xny8iows&list=PLBgogxgQVM9s0i9oloJwjIG-zj6Svsm20&index=3&pp=iAQB)
  - [Transformer Models and BERT Model: Overview](https://www.youtube.com/watch?v=hsp1OAcoLBY&list=PLBgogxgQVM9s0i9oloJwjIG-zj6Svsm20&index=4&pp=iAQB)
  - [Create Image Captioning Models: Overview](https://www.youtube.com/watch?v=0BaIeMoFEoE&list=PLBgogxgQVM9s0i9oloJwjIG-zj6Svsm20&index=5&pp=iAQB)
  - [Introduction to Vertex AI Studio](https://www.youtube.com/watch?v=KWarqNq195M&list=PLBgogxgQVM9s0i9oloJwjIG-zj6Svsm20&index=6&pp=iAQB)
  - [Vector Search and Embeddings](https://www.youtube.com/watch?v=YlAWtEAJl9g&list=PLBgogxgQVM9s0i9oloJwjIG-zj6Svsm20&index=7&pp=iAQB)
- [Gemini for Google Cloud - Playlist](https://www.youtube.com/playlist?list=PLBgogxgQVM9vMyRWTvDqxc-N5pYp-a98F)
  - [Gemini for Application Developers](https://www.youtube.com/watch?v=WsXVGr0Q3C4&list=PLBgogxgQVM9vMyRWTvDqxc-N5pYp-a98F&index=1&pp=iAQB)
  - [Gemini for Cloud Architects](https://www.youtube.com/watch?v=y-dlxWHtfhQ&list=PLBgogxgQVM9vMyRWTvDqxc-N5pYp-a98F&index=2&pp=iAQB)
  - [Gemini for Data Scientists and Analysts](https://www.youtube.com/watch?v=0H7brO5JeCQ&list=PLBgogxgQVM9vMyRWTvDqxc-N5pYp-a98F&index=3&pp=iAQB)
  - [Gemini for Network Engineers](https://www.youtube.com/watch?v=RHla4EEleCE&list=PLBgogxgQVM9vMyRWTvDqxc-N5pYp-a98F&index=4&pp=iAQB)
  - [Gemini for Security Engineers](https://www.youtube.com/watch?v=08xeOzUUL-g&list=PLBgogxgQVM9vMyRWTvDqxc-N5pYp-a98F&index=5&pp=iAQB)
  - [Gemini for Cloud DevOps Engineers](https://www.youtube.com/watch?v=zaVTJVwtyzI&list=PLBgogxgQVM9vMyRWTvDqxc-N5pYp-a98F&index=6&pp=iAQB)
  - [Gemini end-to-end Software Development Lifecycle](https://www.youtube.com/watch?v=h41eoDraUzE&list=PLBgogxgQVM9vMyRWTvDqxc-N5pYp-a98F&index=7&pp=iAQB)
  - [Technical training courses in Generative AI from Google Cloud](https://www.youtube.com/watch?v=5FIlXPSmUUc&list=PLBgogxgQVM9vMyRWTvDqxc-N5pYp-a98F&index=8&pp=iAQB)

## Cloud Skills Boost

- [Beginner: Introduction to Generative AI Learning Path](https://www.cloudskillsboost.google/paths/118): This learning path provides an overview of generative AI concepts, from the fundamentals of large language models to responsible AI principles. This learning path currently has several courses listed below:

  - [Introduction to Generative AI](https://www.cloudskillsboost.google/course_templates/536)
  - [Introduction to Large Language Models](https://www.cloudskillsboost.google/course_templates/539)
  - [Introduction to Responsible AI](https://www.cloudskillsboost.google/course_templates/554)
  - [Prompt Design in Vertex AI](https://www.cloudskillsboost.google/paths/118/course_templates/976)
  - [Responsible AI: Applying AI Principles with Google Cloud](https://www.cloudskillsboost.google/paths/118/course_templates/388)

- [Intermediate: Gemini for Google Cloud Learning Path](https://www.cloudskillsboost.google/paths/236): The Gemini for Google Cloud learning path provides examples of how Gemini can help make engineers of all types more efficient in their daily activities.

  - [Gemini for Application Developers](https://www.cloudskillsboost.google/course_templates/881)
  - [Gemini for Cloud Architects](https://www.cloudskillsboost.google/paths/236/course_templates/878)
  - [Gemini for Data Scientists and Analysts](https://www.cloudskillsboost.google/paths/236/course_templates/879)
  - [Gemini for Network Engineers](https://www.cloudskillsboost.google/paths/236/course_templates/884)
  - [Gemini for Security Engineers](https://www.cloudskillsboost.google/paths/236/course_templates/886)
  - [Gemini for DevOps Engineers](https://www.cloudskillsboost.google/paths/236/course_templates/882)
  - [Gemini for end-to-end SDLC](https://www.cloudskillsboost.google/course_templates/885)
  - [Develop Gen AI Apps with Gemini and Streamlit](https://www.cloudskillsboost.google/paths/236/course_templates/978)

- [Advanced: Generative AI for Developers Learning Path](https://www.cloudskillsboost.google/paths/183): A Generative AI Learning Path with a technical focus, built for App Developers, Machine Learning Engineers, and Data Scientists. Recommended prerequisite: Introduction to Generative AI learning path.
  - [Introduction to Image Generation](https://www.cloudskillsboost.google/paths/183/course_templates/541)
  - [Attention Mechanism](https://www.cloudskillsboost.google/paths/183/course_templates/537)
  - [Encoder-Decoder Architecture](https://www.cloudskillsboost.google/paths/183/course_templates/543)
  - [Transformer Models and BERT Model](https://www.cloudskillsboost.google/paths/183/course_templates/538)
  - [Create Image Captioning Models](https://www.cloudskillsboost.google/paths/183/course_templates/542)
  - [Introduction to Vertex AI Studio](https://www.cloudskillsboost.google/paths/183/course_templates/552)
  - [Vector Search and Embeddings](https://www.cloudskillsboost.google/paths/183/course_templates/939)
  - [Inspect Rich Documents with Gemini Multimodality and Multimodal RAG](https://www.cloudskillsboost.google/paths/183/course_templates/981)
  - [Responsible AI for Developers: Fairness and Bias](https://www.cloudskillsboost.google/paths/183/course_templates/985)
  - [Responsible AI for Developers: Interpretability & Transparency](https://www.cloudskillsboost.google/paths/183/course_templates/989)
  - [Machine Learning Operations (MLOps) for Generative AI](https://www.cloudskillsboost.google/paths/183/course_templates/927)

## Google Cloud Playlists/Videos

- [Generative AI - Google Cloud Next 2024](https://www.youtube.com/watch?v=PyM3Vt6s1GI&list=PLIivdWyY5sqLHERDVwseyPGka96mCiwpq)
- [AI and Machine Learning with Google Cloud](https://www.youtube.com/watch?v=V6YTS5aofqU&list=PLIivdWyY5sqJdmVMjLI8iCul14XkTRosn)
