# [Generative AI](https://cloud.google.com/ai/generative-ai/)

## Gemini

<!-- markdownlint-disable MD036 -->

**YouTube Video: Introduction to Gemini on Vertex AI**

<!-- markdownlint-enable MD036 -->

<!-- markdownlint-disable MD033 -->
<a href="https://www.youtube.com/watch?v=YfiLUpNejpE&list=PLIivdWyY5sqJio2yeg1dlfILOUO2FoFRx" target="_blank">
  <img src="https://img.youtube.com/vi/YfiLUpNejpE/maxresdefault.jpg" alt="Introduction to Gemini on Vertex AI" width="500">
</a>
<!-- markdownlint-enable MD033 -->

[Gemini](https://deepmind.google/technologies/gemini) is a family of generative AI models developed by [Google DeepMind](https://deepmind.google) that is designed for multimodal use cases.

### Gemini API in Vertex AI

On Google Cloud, the Gemini API in Vertex AI provides a unified interface for interacting with multimodal Gemini models, such as:

![Gemini Models](https://storage.googleapis.com/github-repo/GeminiModels.png)

## Using this repository

<!-- markdownlint-disable MD033 -->
- [agent-engine/](agent-engine/): Learn how to use the Agent Engine with Gemini.
- [agents/](agents/): Samples of how to build agents with Gemini.
- [autocal/](autocal/): Learn about Autocal with Gemini.
- [batch-prediction/](batch-prediction/): Learn how to use batch prediction with Gemini.
- [chat-completions/](chat-completions/): Learn about chat completions with the Gemini API.
- [code-execution/](code-execution/): Learn about code execution with Gemini.
- [context-caching/](context-caching/): Learn about context caching with Gemini.
- [controlled-generation/](controlled-generation/): Learn about controlled generation with Gemini.
- [evaluation/](evaluation/): Learn how to evaluate Gemini models.
- [function-calling/](function-calling/): Learn how to use function calling with Gemini.
- [getting-started/](getting-started/): Get started with the Gemini API.
- [global-endpoint/](global-endpoint/): Learn how to use the global endpoint for Gemini.
- [grounding/](grounding/): Learn about grounding with Gemini.
- [logprobs/](logprobs/): Learn about logprobs with Gemini.
- [long-context/](long-context/): Learn about long context with Gemini.
- [mcp/](mcp/): Learn about the Multi-turn Conversation Platform (MCP) with Gemini.
- [model-optimizer/](model-optimizer/): Learn about the Model Optimizer for Gemini.
- [multimodal-dataset/](multimodal-dataset/): Learn how to work with multimodal datasets for Gemini.
- [multimodal-live-api/](multimodal-live-api/): Learn how to use the Multimodal Live API with Gemini.
- [nano-banana/](nano-banana/): Learn about Nano Banana with Gemini.
- [orchestration/](orchestration/): Learn about orchestration with Gemini.
- [prompts/](prompts/): Learn about prompt design for Gemini.
- [rag-engine/](rag-engine/): Learn about the RAG Engine with Gemini.
- [reasoning-engine/](reasoning-engine/): Learn about the Reasoning Engine with Gemini.
- [responsible-ai/](responsible-ai/): Learn about responsible AI with Gemini.
- [sample-apps/](sample-apps/): Sample applications using the Gemini API.
- [thinking/](thinking/): Learn about the thinking process of Gemini.
- [tuning/](tuning/): Learn how to tune Gemini models.
- [url-context/](url-context/): Learn how to use URL context with Gemini.
- [use-cases/](use-cases/): Explore various use cases for Gemini.
<!-- markdownlint-enable MD033 -->

## Contributing

Contributions welcome! See the [Contributing Guide](https://github.com/GoogleCloudPlatform/generative-ai/blob/main/CONTRIBUTING.md).

## Getting help

Please use the [issues page](https://github.com/GoogleCloudPlatform/generative-ai/issues) to provide suggestions, feedback or submit a bug report.

## Disclaimer

This repository itself is not an officially supported Google product. The code in this repository is for demonstrative purposes only.
