// Copyright 2026 Google LLC
// 
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// 
//     https://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import React from 'react';

const ProfileIcon = ({ className }: { className?: string }) => (
  <svg
    viewBox="0 0 24 24"
    fill="white"
    xmlns="http://www.w3.org/2000/svg"
    className={className}
  >
    <path d="M14.5547 12.9746C18.1356 12.9746 21.0531 15.8161 21.1758 19.3672L21.1797 19.5996V21.5996C21.1797 21.9448 20.8999 22.2246 20.5547 22.2246C20.2411 22.2244 19.9811 21.9936 19.9365 21.6924L19.9297 21.5996V19.5996C19.9295 16.7037 17.6396 14.3431 14.7715 14.2295L14.5547 14.2246H9.45508C6.55896 14.2246 4.19745 16.5155 4.08398 19.3838L4.08008 19.5996V21.5996C4.08008 21.9448 3.80026 22.2246 3.45508 22.2246C3.14129 22.2246 2.88157 21.9938 2.83691 21.6924L2.83008 21.5996V19.5996C2.83028 16.0188 5.67161 13.102 9.22266 12.9795L9.45508 12.9746H14.5547ZM17.1553 17.9404C17.5004 17.9405 17.7803 18.2203 17.7803 18.5654C17.7802 18.8791 17.5484 19.139 17.2471 19.1836L17.1553 19.1904H13.9551C13.61 19.1904 13.3302 18.9105 13.3301 18.5654C13.3301 18.2518 13.5611 17.9921 13.8623 17.9473L13.9551 17.9404H17.1553ZM12.0049 1.875C14.6973 1.875 16.8799 4.05761 16.8799 6.75C16.8799 9.44239 14.6973 11.625 12.0049 11.625C9.31258 11.6249 7.12988 9.44232 7.12988 6.75C7.12988 4.05768 9.31258 1.87511 12.0049 1.875ZM12.0049 3.125C10.0029 3.12511 8.37988 4.74803 8.37988 6.75C8.37988 8.75197 10.0029 10.3749 12.0049 10.375C14.0069 10.375 15.6299 8.75203 15.6299 6.75C15.6299 4.74797 14.0069 3.125 12.0049 3.125Z" />
  </svg>
);

export default ProfileIcon;