# Sample Applications

This directory contains sample applications that demonstrate how to use the Gemini API in Vertex AI.

## Applications

- [Accelerating Product Innovation](accelerating_product_innovation/): A solution for product category and brand owners to accelerate product innovation using Generative AI.
- [End-to-End Gen AI App Starter Pack](e2e-gen-ai-app-starter-pack/): This project has moved to https://github.com/GoogleCloudPlatform/agent-starter-pack.
- [Finance Advisor with Spanner](finance-advisor-spanner/): A demo application that showcases how to use Spanner and Vertex AI to build a financial advisor application.
- [FixMyCar](fixmycar/): A retrieval-augmented generation (RAG) sample application to troubleshoot your car using the owner's manual.
- [Gemini Hallucination Check](gemini-hallcheck/): A confidence-targeted, abstention-aware hallucination evaluator for Gemini.
- [Gemini with Mesop on Cloud Run](gemini-mesop-cloudrun/): A sample application that demonstrates how to use the Mesop UI framework with the Gemini API on Cloud Run.
- [Gemini with Quart on Cloud Run](gemini-quart-cloudrun/): A sample application that demonstrates non-blocking communication with Quart and the Gemini Live API on Cloud Run.
- [Gemini with Streamlit on Cloud Run](gemini-streamlit-cloudrun/): A sample application that demonstrates how to use the Streamlit framework with the Gemini API on Cloud Run.
- [GenWealth](genwealth/): A demo application for a fictional financial services company that showcases how to build trustworthy Gen AI features into existing applications using AlloyDB AI, Vertex AI, Cloud Run, and Cloud Functions.
- [Image Bash JAM](image-bash-jam/): A collection of bash scripts to test Gemini from the command line, including image and audio examples.
- [LlamaDeploy on Cloud Run](llamadeploy-on-cloud-run/): A LlamaIndex Workflow application that demonstrates how to deploy and interact with Llama workflows using the `llama-deploy` library and deploying the service on Cloud Run.
- [LlamaIndex RAG](llamaindex-rag/): An advanced Retrieval-Augmented Generation (RAG) system using LlamaIndex and Google Cloud Vertex AI for rapid prototyping and experimentation.
- [Photo Discovery](photo-discovery/): A demo that integrates a Vertex AI Agent with a multi-platform Flutter app to identify landmarks and merchandise from photos.
- [Quickbot](quickbot/): An innovative, out-of-the-box solution enabling users to deploy sophisticated AI Agents as full-stack cloud applications on their own Google Cloud Platform (GCP) accounts, entirely without requiring any coding expertise.
- [SWOT Agent](swot-agent/): A web application that performs automated SWOT analysis (Strengths, Weaknesses, Opportunities, Threats) using the Gemini 2.0 Flash model and the Pydantic AI agent framework.
