<img width="500" src="CymbalLogo.png" />

# Cymbal Starlight 2024: Owner's Manual

## **Chapter 1: Safety**

**Introduction**

Your safety and the safety of others is paramount. This chapter provides important information to help you operate your Cymbal Starlight 2024 safely and responsibly. Please read and understand this information thoroughly before operating your vehicle.

**Seat Belts**

- All occupants must wear seat belts at all times.
- Adjust the seat belt to fit snugly around your hips and across your chest.
- Never wear a seat belt under your arm or behind your back.
- Replace any seat belt that has been damaged or frayed.

**Airbags**

- Airbags are supplemental restraints and work in conjunction with seat belts to provide additional protection in the event of a collision.
- Do not place objects on or near the airbag deployment areas (e.g., dashboard, steering wheel, seat backs).
- Children under the age of 12 should never ride in the front seat.
- If the airbag warning light illuminates, have the vehicle inspected by a qualified technician immediately.

**Child Safety**

- Use age- and size-appropriate child restraints for all children.
- Install child restraints according to the manufacturer's instructions.
- Never leave a child unattended in the vehicle.
- Lock all doors and windows when leaving the vehicle parked.

**Vehicle Stability Control (VSC)**

- VSC is an electronic system that helps control the vehicle's stability during cornering and other maneuvers.
- VSC can be turned off by pressing the VSC OFF button on the dashboard. However, it is recommended to leave VSC on for optimal safety.

**Anti-Lock Braking System (ABS)**

- ABS prevents the wheels from locking during braking, allowing you to maintain control of the vehicle.
- ABS can be felt as a pulsation in the brake pedal during braking. Do not release the brake pedal; continue applying steady pressure until the vehicle comes to a stop.

**Tire Safety**

- Maintain proper tire pressure at all times (see the Tire Pressure Information label on the driver's door jamb).
- Check tire tread depth regularly and replace tires when they reach the minimum tread depth of 2/32 inches.
- Avoid sudden starts, stops, and turns that can cause excessive tire wear.

**Vehicle Inspection**

- Inspect your vehicle regularly for any signs of damage or malfunction, including:
  - Leaks under the vehicle
  - Unusual noises or vibrations
  - Dim or flickering lights
  - Worn or damaged tires
- If you notice any problems, have the vehicle inspected by a qualified technician immediately.

**Driving Safely**

- Always obey the speed limit and traffic laws.
- Avoid distractions while driving, such as using a cell phone or texting.
- Be aware of your surroundings and anticipate the actions of other drivers.
- Use caution when driving in inclement weather or on slippery roads.
- If you feel tired or unwell, pull over to a safe location and rest.

## **Chapter 2: Child Safety**

**Introduction**

The safety of your children is of paramount importance. This chapter provides important information on how to keep your children safe while traveling in your Cymbal Starlight 2024.

**Child Restraints**

- **Rear-facing car seats:** Children under the age of 2 should always ride in a rear-facing car seat. Rear-facing car seats provide the best protection for your child's head, neck, and spine in the event of a collision.
- **Forward-facing car seats:** Children who have outgrown their rear-facing car seat should ride in a forward-facing car seat with a harness. Forward-facing car seats should be used until your child reaches the maximum height and weight limits for the seat.
- **Booster seats:** Children who have outgrown their forward-facing car seat should ride in a booster seat. Booster seats help position the seat belt correctly across your child's body. Booster seats should be used until your child is at least 4 feet 9 inches tall and weighs at least 80 pounds.
- **Seat belt:** All children over the age of 8 should wear a seat belt. Seat belts should be adjusted to fit snugly around your child's hips and across their chest.

**Installing Child Restraints**

- Follow the manufacturer's instructions carefully when installing a child restraint.
- Use the LATCH (Lower Anchors and Tethers for Children) system or the vehicle's seat belt to secure the child restraint.
- Make sure that the child restraint is installed tightly and securely.
- Have the child restraint inspected by a qualified technician to ensure that it is installed correctly.

**Other Child Safety Tips**

- Never leave a child unattended in the vehicle.
- Lock all doors and windows when leaving the vehicle parked.
- Keep valuables out of sight to avoid tempting thieves.
- Teach your children about car safety, including the importance of wearing seat belts and never playing in or around the vehicle.
- Set a good example by always wearing your seat belt and obeying traffic laws.

By following these child safety tips, you can help keep your children safe while traveling in your Cymbal Starlight 2024.

**Additional Child Safety Features**

Your Cymbal Starlight 2024 comes equipped with the following child safety features:

- **Rear child door locks:** These locks prevent children from opening the rear doors from the inside.
- **Window locks:** These locks prevent children from opening the windows from the inside.
- **Child seat anchors:** These anchors are located on the rear seats and can be used to secure child restraints.

By using these child safety features in addition to the child safety tips outlined above, you can help ensure that your children are safe and secure while riding in your Cymbal Starlight 2024.

## **Chapter 3: Emergency Assistance**

**Introduction**

In the event of an emergency, it is important to know how to contact emergency services and how to use the safety features in your Cymbal Starlight 2024. This chapter provides important information on how to use the following emergency assistance features:

- Hazard lights
- Horn
- Emergency roadside assistance
- Tire repair kit

**Hazard Lights**

- The hazard lights are used to signal to other drivers that your vehicle is disabled or in an emergency situation.
- To activate the hazard lights, press the hazard light button located on the dashboard.
- The hazard lights will flash until you press the button again to turn them off.

**Horn**

- The horn is used to alert other drivers and pedestrians of your presence.
- To sound the horn, press the horn button located on the steering wheel.

**Emergency Roadside Assistance**

- Your Cymbal Starlight 2024 comes with 24/7 emergency roadside assistance.
- To contact emergency roadside assistance, call the following number: 1-800-555-1212.
- When you call, be prepared to provide the following information:
  - Your name and contact information
  - Your vehicle's make, model, and year
  - Your vehicle's location
  - The nature of the emergency

**Tire Repair Kit**

- Your Cymbal Starlight 2024 comes with a tire repair kit that can be used to temporarily repair a flat tire.
- The tire repair kit is located in the trunk of the vehicle.
- To use the tire repair kit, follow the instructions provided in the kit.

**Other Emergency Tips**

- If you are involved in an accident, remain calm and call 911 immediately.
- If you are able to move your vehicle, pull over to the side of the road and turn on your hazard lights.
- Stay in your vehicle and wait for emergency services to arrive.
- If you are stranded in a remote area, stay with your vehicle and try to attract attention by waving your arms or using a flashlight.

By following these emergency assistance tips, you can help ensure that you and your passengers are safe in the event of an emergency.

## **Chapter 4: Instrument Cluster**

**Introduction**

The instrument cluster is located directly in front of the driver and provides important information about the vehicle's operation. The instrument cluster in your Cymbal Starlight 2024 includes the following gauges and indicators:

- **Speedometer:** The speedometer indicates the vehicle's speed in miles per hour (mph).
- **Tachometer:** The tachometer indicates the engine's speed in revolutions per minute (rpm).
- **Fuel gauge:** The fuel gauge indicates the amount of fuel remaining in the fuel tank.
- **Odometer:** The odometer indicates the total number of miles the vehicle has traveled.
- **Trip computer:** The trip computer provides information about the vehicle's current trip, such as the trip distance, average fuel economy, and estimated time of arrival.

In addition to the gauges and indicators listed above, the instrument cluster also includes a number of warning lights and indicators. These lights and indicators are designed to alert the driver to potential problems with the vehicle.

**Warning Lights and Indicators**

The following is a list of the warning lights and indicators that may appear in the instrument cluster of your Cymbal Starlight 2024:

- **Check engine light:** The check engine light indicates a problem with the vehicle's engine or emissions system.
- **ABS warning light:** The ABS warning light indicates a problem with the vehicle's anti-lock braking system.
- **Traction control warning light:** The traction control warning light indicates a problem with the vehicle's traction control system.
- **Airbag warning light:** The airbag warning light indicates a problem with the vehicle's airbag system.
- **Tire pressure warning light:** The tire pressure warning light indicates that the tire pressure in one or more of the vehicle's tires is low.
- **Low fuel warning light:** The low fuel warning light indicates that the fuel level in the fuel tank is low.

If any of the warning lights or indicators in the instrument cluster illuminate, it is important to have the vehicle inspected by a qualified technician as soon as possible.

**Using the Instrument Cluster**

The instrument cluster is designed to be easy to read and use. The gauges and indicators are clearly labeled and the warning lights and indicators are easy to see.

To use the instrument cluster, simply glance at the gauges and indicators to get the information you need. If any of the warning lights or indicators illuminate, refer to the vehicle's owner's manual for more information.

By understanding the instrument cluster and the information it provides, you can stay informed about the operation of your Cymbal Starlight 2024 and help to ensure that it is operating safely and efficiently.

## **Chapter 5: Warning Lights**

**Introduction**

The warning lights in your Cymbal Starlight 2024 are designed to alert you to potential problems with the vehicle. It is important to pay attention to these warning lights and to have the vehicle inspected by a qualified technician as soon as possible if any of them illuminate.

**Engine Warning Lights**

The following engine warning lights may illuminate in the instrument cluster of your Cymbal Starlight 2024:

- **Check engine light:** The check engine light indicates a problem with the vehicle's engine or emissions system. This light may illuminate for a variety of reasons, including:
  - A loose or damaged gas cap
  - A faulty oxygen sensor
  - A problem with the catalytic converter
  - A misfire in the engine
- **Oil pressure warning light:** The oil pressure warning light indicates that the oil pressure in the engine is low. This light may illuminate for a variety of reasons, including:
  - A low oil level
  - A faulty oil pump
  - A leak in the oil system
- **Coolant temperature warning light:** The coolant temperature warning light indicates that the coolant temperature in the engine is high. This light may illuminate for a variety of reasons, including:
  - A low coolant level
  - A faulty thermostat
  - A leak in the cooling system

**Safety Warning Lights**

The following safety warning lights may illuminate in the instrument cluster of your Cymbal Starlight 2024:

- **ABS warning light:** The ABS warning light indicates a problem with the vehicle's anti-lock braking system. This light may illuminate for a variety of reasons, including:
  - A faulty ABS sensor
  - A problem with the ABS control module
  - A leak in the ABS hydraulic system
- **Traction control warning light:** The traction control warning light indicates a problem with the vehicle's traction control system. This light may illuminate for a variety of reasons, including:
  - A faulty traction control sensor
  - A problem with the traction control module
  - A loss of traction

**Other Warning Lights**

The following other warning lights may illuminate in the instrument cluster of your Cymbal Starlight 2024:

- **Airbag warning light:** The airbag warning light indicates a problem with the vehicle's airbag system. This light may illuminate for a variety of reasons, including:
  - A faulty airbag sensor
  - A problem with the airbag control module
  - A problem with the airbag wiring
- **Tire pressure warning light:** The tire pressure warning light indicates that the tire pressure in one or more of the vehicle's tires is low. This light may illuminate for a variety of reasons, including:
  - A low tire pressure
  - A faulty tire pressure sensor
  - A leak in the tire

**What to Do If a Warning Light Illuminates**

If any of the warning lights in your Cymbal Starlight 2024 illuminate, it is important to have the vehicle inspected by a qualified technician as soon as possible. Ignoring a warning light can lead to further damage to the vehicle and could compromise your safety.

By paying attention to the warning lights in your vehicle and having the vehicle inspected by a qualified technician as soon as possible, you can help to ensure that your Cymbal Starlight 2024 is operating safely and efficiently.

## **Chapter 6: Towing, Cargo, and Luggage**

**Towing**

Your Cymbal Starlight 2024 is not equipped to tow a trailer.

**Cargo**

The Cymbal Starlight 2024 has a cargo capacity of 13.5 cubic feet. The cargo area is located in the trunk of the vehicle.

To access the cargo area, open the trunk lid using the trunk release lever located in the driver's footwell.

When loading cargo into the trunk, be sure to distribute the weight evenly. Do not overload the trunk, as this could affect the vehicle's handling and stability.

**Luggage**

The Cymbal Starlight 2024 can accommodate up to two suitcases in the trunk. When packing luggage, be sure to use soft-sided luggage to maximize space.

To ensure that your luggage is secure while driving, use the cargo straps located in the trunk to tie down the luggage.

**Tips for Towing, Cargo, and Luggage**

- When towing a trailer, be sure to use a trailer that is compatible with your vehicle.
- Never overload the trailer or the vehicle.
- Distribute the weight evenly in the trailer and the vehicle.
- Drive slowly and carefully when towing a trailer.
- When loading cargo into the trunk, be sure to distribute the weight evenly.
- Do not overload the trunk, as this could affect the vehicle's handling and stability.
- When packing luggage, use soft-sided luggage to maximize space.
- Use the cargo straps located in the trunk to tie down the luggage to ensure that it is secure while driving.

By following these tips, you can safely and conveniently transport cargo and luggage in your Cymbal Starlight 2024.

## **Chapter 7: Driving Procedures with Automatic Transmission**

**Starting the Engine**

1. Sit in the driver's seat and adjust the seat and steering wheel to a comfortable position.
2. Make sure that the parking brake is engaged.
3. Shift the gear selector to the "P" (Park) position.
4. Insert the key into the ignition and turn it to the "ON" position.
5. Depress the brake pedal.
6. Turn the key to the "START" position and hold it there until the engine starts.
7. Release the key once the engine starts.

**Shifting Gears**

Your Cymbal Starlight 2024 is equipped with a six-speed automatic transmission. The transmission shifts gears automatically, but you can also shift gears manually if you wish.

To shift gears manually, move the gear selector to the desired gear position. The gear positions are as follows:

- **P (Park):** This position is used to park the vehicle.
- **R (Reverse):** This position is used to move the vehicle in reverse.
- **N (Neutral):** This position is used to put the transmission in neutral.
- **D (Drive):** This position is used for normal driving.
- **S (Sport):** This position is used for sportier driving.
- **L (Low):** This position is used for driving in low-speed conditions, such as when towing a trailer or driving up a steep hill.

**Driving**

Once you have started the engine and shifted into gear, you are ready to drive.

To drive, simply depress the accelerator pedal and the vehicle will begin to move. The transmission will automatically shift gears as needed.

To brake, simply depress the brake pedal. The harder you depress the brake pedal, the more quickly the vehicle will slow down or stop.

**Parking**

To park the vehicle, follow these steps:

1. Bring the vehicle to a complete stop.
2. Shift the gear selector to the "P" (Park) position.
3. Engage the parking brake.
4. Turn off the engine.

**Tips for Driving with Automatic Transmission**

- Avoid shifting into gear before the vehicle has come to a complete stop.
- Do not shift into "P" (Park) while the vehicle is moving.
- When driving in hilly terrain, use the "L" (Low) gear position to help control the vehicle's speed.
- When towing a trailer, use the "S" (Sport) gear position to provide additional power.

By following these tips, you can safely and efficiently operate your Cymbal Starlight 2024 with automatic transmission.

## **Chapter 8: Cruise Control and Automatic Support System**

**Cruise Control**

Cruise control is a feature that allows you to set and maintain a desired speed without having to keep your foot on the accelerator pedal. This can be useful on long highway drives, as it can help to reduce fatigue and improve fuel economy.

To activate cruise control, follow these steps:

1. Accelerate to the desired speed.
2. Press the "Cruise" button on the steering wheel.
3. Set the desired speed using the up and down arrows on the steering wheel.

Once cruise control is activated, the vehicle will maintain the set speed until you press the brake pedal, the "Cancel" button on the steering wheel, or the "Set/Accel" button on the steering wheel.

**Automatic Support System**

The automatic support system in your Cymbal Starlight 2024 is a suite of features that can help you to stay in your lane, maintain a safe following distance from the vehicle in front of you, and avoid collisions.

The following features are included in the automatic support system:

- **Lane departure warning:** This feature warns you if you are drifting out of your lane.
- **Lane keeping assist:** This feature helps to keep you in your lane by gently steering the vehicle back into the lane if you start to drift.
- **Adaptive cruise control:** This feature automatically adjusts your speed to maintain a safe following distance from the vehicle in front of you.
- **Forward collision warning:** This feature warns you if you are approaching another vehicle too quickly.
- **Automatic emergency braking:** This feature can automatically apply the brakes to avoid a collision.

**Using the Automatic Support System**

To use the automatic support system, simply activate the cruise control system. The automatic support system will then automatically activate and begin to monitor your driving.

If the automatic support system detects that you are drifting out of your lane, it will warn you with a chime and a visual alert. If you do not take corrective action, the lane keeping assist system will gently steer the vehicle back into the lane.

If the automatic support system detects that you are approaching another vehicle too quickly, it will warn you with a chime and a visual alert. If you do not take corrective action, the automatic emergency braking system can automatically apply the brakes to avoid a collision.

**Tips for Using Cruise Control and the Automatic Support System**

- Cruise control is not a substitute for attentive driving. Always be aware of your surroundings and be prepared to take control of the vehicle at any time.
- The automatic support system is designed to assist you in driving, but it does not replace the need for you to be attentive and in control of the vehicle.
- The automatic support system may not be able to detect all potential hazards. Always drive defensively and be prepared to react to unexpected situations.

By following these tips, you can safely and effectively use the cruise control and automatic support system in your Cymbal Starlight 2024.

In the event of an emergency, it is important to know how to contact emergency services and how to use the safety features in your Cymbal Starlight 2024. This chapter provides important information on how to use the following emergency assistance features:

- Hazard lights
- Horn
- Emergency roadside assistance
- Tire repair kit

**Hazard Lights**

- The hazard lights are used to signal to other drivers that your vehicle is disabled or in an emergency situation.
- To activate the hazard lights, press the hazard light button located on the dashboard.
- The hazard lights will flash until you press the button again to turn them off.

**Horn**

- The horn is used to alert other drivers and pedestrians of your presence.
- To sound the horn, press the horn button located on the steering wheel.

**Emergency Roadside Assistance**

- Your Cymbal Starlight 2024 comes with 24/7 emergency roadside assistance.
- To contact emergency roadside assistance, call the following number: 1-800-555-1212.
- When you call, be prepared to provide the following information:
  - Your name and contact information
  - Your vehicle's make, model, and year
  - Your vehicle's location
  - The nature of the emergency

**Tire Repair Kit**

- Your Cymbal Starlight 2024 comes with a tire repair kit that can be used to temporarily repair a flat tire.
- The tire repair kit is located in the trunk of the vehicle.
- To use the tire repair kit, follow the instructions provided in the kit.

**Other Emergency Tips**

- If you are involved in an accident, remain calm and call 911 immediately.
- If you are able to move your vehicle, pull over to the side of the road and turn on your hazard lights.
- Stay in your vehicle and wait for emergency services to arrive.
- If you are stranded in a remote area, stay with your vehicle and try to attract attention by waving your arms or using a flashlight.

By following these emergency assistance tips, you can help ensure that you and your passengers are safe in the event of an emergency.

## **Chapter 9: Instrument Cluster**

**Introduction**

The instrument cluster is located directly in front of the driver and provides important information about the vehicle's operation. The instrument cluster in your Cymbal Starlight 2024 includes the following gauges and indicators:

- **Speedometer:** The speedometer indicates the vehicle's speed in miles per hour (mph).
- **Tachometer:** The tachometer indicates the engine's speed in revolutions per minute (rpm).
- **Fuel gauge:** The fuel gauge indicates the amount of fuel remaining in the fuel tank.
- **Odometer:** The odometer indicates the total number of miles the vehicle has traveled.
- **Trip computer:** The trip computer provides information about the vehicle's current trip, such as the trip distance, average fuel economy, and estimated time of arrival.

In addition to the gauges and indicators listed above, the instrument cluster also includes a number of warning lights and indicators. These lights and indicators are designed to alert the driver to potential problems with the vehicle.

**Warning Lights and Indicators**

The following is a list of the warning lights and indicators that may appear in the instrument cluster of your Cymbal Starlight 2024:

- **Check engine light:** The check engine light indicates a problem with the vehicle's engine or emissions system.
- **ABS warning light:** The ABS warning light indicates a problem with the vehicle's anti-lock braking system.
- **Traction control warning light:** The traction control warning light indicates a problem with the vehicle's traction control system.
- **Airbag warning light:** The airbag warning light indicates a problem with the vehicle's airbag system.
- **Tire pressure warning light:** The tire pressure warning light indicates that the tire pressure in one or more of the vehicle's tires is low.
- **Low fuel warning light:** The low fuel warning light indicates that the fuel level in the fuel tank is low.

If any of the warning lights or indicators in the instrument cluster illuminate, it is important to have the vehicle inspected by a qualified technician as soon as possible.

**Using the Instrument Cluster**

The instrument cluster is designed to be easy to read and use. The gauges and indicators are clearly labeled and the warning lights and indicators are easy to see.

To use the instrument cluster, simply glance at the gauges and indicators to get the information you need. If any of the warning lights or indicators illuminate, refer to the vehicle's owner's manual for more information.

By understanding the instrument cluster and the information it provides, you can stay informed about the operation of your Cymbal Starlight 2024 and help to ensure that it is operating safely and efficiently.

## **Chapter 10: Warning Lights**

**Introduction**

The warning lights in your Cymbal Starlight 2024 are designed to alert you to potential problems with the vehicle. It is important to pay attention to these warning lights and to have the vehicle inspected by a qualified technician as soon as possible if any of them illuminate.

**Engine Warning Lights**

The following engine warning lights may illuminate in the instrument cluster of your Cymbal Starlight 2024:

- **Check engine light:** The check engine light indicates a problem with the vehicle's engine or emissions system. This light may illuminate for a variety of reasons, including:
  - A loose or damaged gas cap
  - A faulty oxygen sensor
  - A problem with the catalytic converter
  - A misfire in the engine
- **Oil pressure warning light:** The oil pressure warning light indicates that the oil pressure in the engine is low. This light may illuminate for a variety of reasons, including:
  - A low oil level
  - A faulty oil pump
  - A leak in the oil system
- **Coolant temperature warning light:** The coolant temperature warning light indicates that the coolant temperature in the engine is high. This light may illuminate for a variety of reasons, including:
  - A low coolant level
  - A faulty thermostat
  - A leak in the cooling system

**Safety Warning Lights**

The following safety warning lights may illuminate in the instrument cluster of your Cymbal Starlight 2024:

- **ABS warning light:** The ABS warning light indicates a problem with the vehicle's anti-lock braking system. This light may illuminate for a variety of reasons, including:
  - A faulty ABS sensor
  - A problem with the ABS control module
  - A leak in the ABS hydraulic system
- **Traction control warning light:** The traction control warning light indicates a problem with the vehicle's traction control system. This light may illuminate for a variety of reasons, including:
  - A faulty traction control sensor
  - A problem with the traction control module
  - A loss of traction

**Other Warning Lights**

The following other warning lights may illuminate in the instrument cluster of your Cymbal Starlight 2024:

- **Airbag warning light:** The airbag warning light indicates a problem with the vehicle's airbag system. This light may illuminate for a variety of reasons, including:
  - A faulty airbag sensor
  - A problem with the airbag control module
  - A problem with the airbag wiring
- **Tire pressure warning light:** The tire pressure warning light indicates that the tire pressure in one or more of the vehicle's tires is low. This light may illuminate for a variety of reasons, including:
  - A low tire pressure
  - A faulty tire pressure sensor
  - A leak in the tire

**What to Do If a Warning Light Illuminates**

If any of the warning lights in your Cymbal Starlight 2024 illuminate, it is important to have the vehicle inspected by a qualified technician as soon as possible. Ignoring a warning light can lead to further damage to the vehicle and could compromise your safety.

By paying attention to the warning lights in your vehicle and having the vehicle inspected by a qualified technician as soon as possible, you can help to ensure that your Cymbal Starlight 2024 is operating safely and efficiently.

## **Chapter 11: Doors, Windows, and Locks**

**Doors**

Your Cymbal Starlight 2024 has four doors: two front doors and two rear doors. The front doors can be opened from the inside or outside of the vehicle, while the rear doors can only be opened from the inside.

To open a door from the inside, simply pull on the interior door handle. To open a door from the outside, insert the key into the door lock and turn it clockwise.

To close a door, simply push it closed until it latches.

**Windows**

Your Cymbal Starlight 2024 has four windows: two front windows and two rear windows. The front windows can be opened and closed using the power window switches located on the driver's door and passenger's door. The rear windows can be opened and closed manually using the window cranks located on the rear doors.

To open a front window, simply press the down button on the corresponding power window switch. To close a front window, simply press the up button on the corresponding power window switch.

To open a rear window, simply turn the window crank clockwise. To close a rear window, simply turn the window crank counterclockwise.

**Locks**

Your Cymbal Starlight 2024 has a number of different locks, including:

- **Door locks:** The door locks can be used to lock and unlock the doors. The door locks can be operated using the key, the power door lock switches located on the driver's door and passenger's door, or the remote keyless entry system.
- **Trunk lock:** The trunk lock can be used to lock and unlock the trunk. The trunk lock can be operated using the key or the trunk release lever located in the driver's footwell.
- **Fuel door lock:** The fuel door lock can be used to lock and unlock the fuel door. The fuel door lock can be operated using the key.

**Using the Remote Keyless Entry System**

Your Cymbal Starlight 2024 comes equipped with a remote keyless entry system. The remote keyless entry system allows you to lock and unlock the doors and trunk, and to open the windows, without having to use the key.

To use the remote keyless entry system, simply press the lock button on the remote to lock the doors and trunk, or press the unlock button on the remote to unlock the doors and trunk. To open the windows, press and hold the unlock button on the remote for three seconds.

**Child Safety Locks**

Your Cymbal Starlight 2024 comes equipped with child safety locks on the rear doors. The child safety locks prevent children from opening the rear doors from the inside.

To activate the child safety locks, simply move the lever on the rear door edge to the "lock" position. To deactivate the child safety locks, simply move the lever to the "unlock" position.

By understanding how to use the doors, windows, and locks in your Cymbal Starlight 2024, you can ensure that your vehicle is secure and that your passengers are safe.

## **Chapter 12: Adjusting the Seats and Steering Wheel**

**Seats**

Your Cymbal Starlight 2024 has two front seats and two rear seats. The front seats can be adjusted in a variety of ways to ensure that you are comfortable while driving.

To adjust the driver's seat, use the following controls:

- **Seat height adjuster:** The seat height adjuster is located on the side of the seat. Use this control to raise or lower the seat.
- **Seatback recliner:** The seatback recliner is located on the side of the seat. Use this control to adjust the angle of the seatback.
- **Lumbar support adjuster:** The lumbar support adjuster is located on the side of the seat. Use this control to adjust the amount of support provided to your lower back.
- **Headrest adjuster:** The headrest adjuster is located on the top of the headrest. Use this control to raise or lower the headrest.

To adjust the passenger's seat, use the following controls:

- **Seat height adjuster:** The seat height adjuster is located on the side of the seat. Use this control to raise or lower the seat.
- **Seatback recliner:** The seatback recliner is located on the side of the seat. Use this control to adjust the angle of the seatback.
- **Headrest adjuster:** The headrest adjuster is located on the top of the headrest. Use this control to raise or lower the headrest.

**Steering Wheel**

The steering wheel in your Cymbal Starlight 2024 can be adjusted in two ways:

- **Tilt adjustment:** The tilt adjustment lever is located on the left side of the steering column. Use this lever to tilt the steering wheel up or down.
- **Telescopic adjustment:** The telescopic adjustment lever is located on the right side of the steering column. Use this lever to move the steering wheel closer to you or further away from you.

**To adjust the steering wheel, follow these steps:**

1. Loosen the tilt adjustment lever.
2. Tilt the steering wheel up or down to the desired position.
3. Tighten the tilt adjustment lever.
4. Loosen the telescopic adjustment lever.
5. Move the steering wheel closer to you or further away from you to the desired position.
6. Tighten the telescopic adjustment lever.

By adjusting the seats and steering wheel to the correct position, you can ensure that you are comfortable and in control while driving your Cymbal Starlight 2024.

## **Chapter 13: Lights and Windshield Wipers**

**Lights**

Your Cymbal Starlight 2024 is equipped with a variety of lights, including:

- **Headlights:** The headlights provide illumination for driving at night or in low-visibility conditions.
- **Taillights:** The taillights provide illumination for the rear of the vehicle, making it more visible to other drivers.
- **Brake lights:** The brake lights illuminate when the brake pedal is depressed, warning other drivers that you are slowing down or stopping.
- **Turn signals:** The turn signals indicate your intention to turn or change lanes.
- **Hazard lights:** The hazard lights flash all of the turn signals at the same time, and are used to warn other drivers of a hazard, such as a disabled vehicle.

To operate the lights, use the following controls:

- **Headlight switch:** The headlight switch is located on the dashboard. Use this control to turn the headlights on and off.
- **Taillight switch:** The taillight switch is located on the dashboard. Use this control to turn the taillights on and off.
- **Brake light switch:** The brake light switch is located on the brake pedal. When the brake pedal is depressed, the brake light switch activates the brake lights.
- **Turn signal lever:** The turn signal lever is located on the steering column. Use this lever to activate the turn signals.
- **Hazard light button:** The hazard light button is located on the dashboard. Use this button to activate the hazard lights.

**Windshield Wipers**

Your Cymbal Starlight 2024 is equipped with two windshield wipers. The windshield wipers are used to clear rain, snow, and other debris from the windshield.

To operate the windshield wipers, use the following controls:

- **Windshield wiper switch:** The windshield wiper switch is located on the steering column. Use this control to turn the windshield wipers on and off and to adjust the wiper speed.
- **Windshield washer switch:** The windshield washer switch is located on the steering column. Use this control to spray windshield washer fluid onto the windshield.

**Tips for Using Lights and Windshield Wipers**

- Always use your headlights when driving at night or in low-visibility conditions.
- Use your taillights whenever your headlights are on.
- Use your brake lights whenever you are slowing down or stopping.
- Use your turn signals whenever you are turning or changing lanes.
- Use your hazard lights whenever you are parked in a hazardous location or if your vehicle is disabled.
- Use your windshield wipers whenever there is rain, snow, or other debris on the windshield.
- Replace your windshield wiper blades regularly to ensure that they are working properly.

By following these tips, you can safely and effectively use the lights and windshield wipers in your Cymbal Starlight 2024.

## **Chapter 14: Refueling**

**Fuel Type**

Your Cymbal Starlight 2024 requires unleaded gasoline with an octane rating of 91 or higher.

**Fuel Capacity**

The fuel tank in your Cymbal Starlight 2024 has a capacity of 14.5 gallons.

**Refueling Procedure**

To refuel your Cymbal Starlight 2024, follow these steps:

1. Park your vehicle on a level surface.
2. Turn off the engine.
3. Open the fuel door using the fuel door release lever located in the driver's footwell.
4. Insert the fuel nozzle into the fuel filler neck.
5. Squeeze the trigger on the fuel nozzle to begin refueling.
6. Once the fuel tank is full, the fuel nozzle will automatically shut off.
7. Remove the fuel nozzle from the fuel filler neck.
8. Close the fuel door.

**Safety Tips**

- Never smoke or use a cell phone while refueling your vehicle.
- Do not overfill the fuel tank.
- If you spill fuel on your skin or clothing, wash it off immediately with soap and water.
- Keep fuel out of the reach of children.

**Fuel Economy**

The fuel economy of your Cymbal Starlight 2024 will vary depending on a number of factors, including:

- Driving habits
- Traffic conditions
- Tire pressure
- Vehicle weight
- Fuel quality

By following these tips, you can help to improve the fuel economy of your Cymbal Starlight 2024:

- Drive smoothly and avoid jackrabbit starts and stops.
- Avoid idling your vehicle for long periods of time.
- Keep your tires properly inflated.
- Reduce the weight of your vehicle by removing unnecessary items from the trunk.
- Use high-quality fuel.

**Fuel System Maintenance**

The fuel system in your Cymbal Starlight 2024 requires regular maintenance to ensure that it is operating properly. The following maintenance tasks should be performed at the intervals specified in the maintenance schedule in your vehicle's owner's manual:

- Replace the fuel filter
- Clean the fuel injectors
- Inspect the fuel lines and hoses for leaks

By following these maintenance tips, you can help to keep the fuel system in your Cymbal Starlight 2024 operating properly and efficiently.

## **Chapter 15: Audio and Bluetooth System**

**Audio System**

The audio system in your Cymbal Starlight 2024 includes a variety of features to keep you entertained while you drive. The system includes:

- AM/FM radio
- CD player
- MP3 player
- Bluetooth connectivity
- Satellite radio (optional)

**Operating the Audio System**

To operate the audio system, use the controls on the dashboard or the steering wheel. The following table describes the functions of the controls:

| Control            | Function                                                                       |
| ------------------ | ------------------------------------------------------------------------------ |
| Power button       | Turns the audio system on and off                                              |
| Volume knob        | Adjusts the volume                                                             |
| Tuning knob        | Tunes the radio                                                                |
| Source button      | Selects the audio source (e.g., AM/FM radio, CD player, MP3 player, Bluetooth) |
| Track skip buttons | Skips to the next or previous track                                            |
| Play/pause button  | Plays or pauses the current track                                              |

**Bluetooth Connectivity**

The Bluetooth system in your Cymbal Starlight 2024 allows you to connect your smartphone or other Bluetooth-enabled device to the audio system. This allows you to stream music, make hands-free phone calls, and control the audio system using your voice.

**Pairing a Bluetooth Device**

To pair a Bluetooth device with your Cymbal Starlight 2024, follow these steps:

1. Make sure that the Bluetooth device is turned on and discoverable.
2. Press the Source button on the audio system and select Bluetooth.
3. The audio system will begin searching for Bluetooth devices.
4. Select your Bluetooth device from the list of available devices.
5. Enter the PIN code for your Bluetooth device (if prompted).

Once your Bluetooth device is paired, you can stream music, make hands-free phone calls, and control the audio system using your voice.

**Using the Voice Control System**

The voice control system in your Cymbal Starlight 2024 allows you to control the audio system using your voice. To use the voice control system, simply press the voice control button on the steering wheel and speak your command.

The following are some examples of voice commands that you can use:

- "Play music"
- "Skip to the next track"
- "Pause the music"
- "Call home"
- "Answer the phone"

**Tips for Using the Audio and Bluetooth System**

- The Bluetooth system in your Cymbal Starlight 2024 has a range of approximately 30 feet.
- The voice control system in your Cymbal Starlight 2024 is designed to recognize natural speech. However, it is important to speak clearly and slowly when using the voice control system.
- If you are having trouble using the audio or Bluetooth system, refer to the owner's manual for more information.

By following these tips, you can get the most out of the audio and Bluetooth system in your Cymbal Starlight 2024.

## **Chapter 16: Heating and Air Conditioning**

**Heating System**

The heating system in your Cymbal Starlight 2024 is designed to keep you warm and comfortable during cold weather. The system includes:

- Heater core
- Blower motor
- Temperature control knob

**Operating the Heating System**

To operate the heating system, follow these steps:

1. Turn the temperature control knob to the desired temperature.
2. Turn the blower motor on to the desired fan speed.
3. Adjust the vents to direct the airflow where you want it.

**Air Conditioning System**

The air conditioning system in your Cymbal Starlight 2024 is designed to keep you cool and comfortable during hot weather. The system includes:

- Compressor
- Condenser
- Evaporator
- Expansion valve

**Operating the Air Conditioning System**

To operate the air conditioning system, follow these steps:

1. Turn the temperature control knob to the coldest setting.
2. Press the A/C button to turn on the air conditioning compressor.
3. Turn the blower motor on to the desired fan speed.
4. Adjust the vents to direct the airflow where you want it.

**Tips for Using the Heating and Air Conditioning System**

- The heating and air conditioning systems in your Cymbal Starlight 2024 are designed to be efficient. However, you can improve the efficiency of the systems by following these tips:
  - Park your vehicle in the shade whenever possible.
  - Use the recirculation mode on the air conditioning system to keep cool air inside the vehicle.
  - Avoid running the heating or air conditioning system at full blast.
- The heating and air conditioning systems in your Cymbal Starlight 2024 require regular maintenance to ensure that they are operating properly. The following maintenance tasks should be performed at the intervals specified in the maintenance schedule in your vehicle's owner's manual:
  - Replace the cabin air filter
  - Clean the condenser and evaporator coils
  - Check the refrigerant level

By following these tips, you can get the most out of the heating and air conditioning system in your Cymbal Starlight 2024 and keep your vehicle comfortable year-round.

## **Chapter 17: Maintenance and Care**

**Maintenance Schedule**

The following is a maintenance schedule for your Cymbal Starlight 2024. This schedule is based on normal driving conditions. If you drive in severe conditions, you may need to service your vehicle more frequently.

| Service                      | Interval                        |
| ---------------------------- | ------------------------------- |
| Oil change                   | Every 5,000 miles or 6 months   |
| Tire rotation                | Every 5,000 miles or 6 months   |
| Air filter replacement       | Every 10,000 miles or 12 months |
| Cabin air filter replacement | Every 15,000 miles or 12 months |
| Brake inspection             | Every 10,000 miles or 12 months |
| Battery inspection           | Every 20,000 miles or 24 months |
| Spark plug replacement       | Every 30,000 miles or 36 months |
| Fuel filter replacement      | Every 30,000 miles or 36 months |
| Timing belt replacement      | Every 60,000 miles or 60 months |

**Do-It-Yourself Maintenance**

Some maintenance tasks, such as changing the oil and rotating the tires, can be performed by do-it-yourselfers. However, it is important to consult your vehicle's owner's manual before performing any maintenance tasks yourself.

**Professional Maintenance**

It is important to have your Cymbal Starlight 2024 serviced by a qualified technician at least once a year. A qualified technician can perform a thorough inspection of your vehicle and identify any potential problems.

**Car Care Tips**

In addition to following the maintenance schedule, there are a number of things you can do to keep your Cymbal Starlight 2024 in good condition. These include:

- Wash your vehicle regularly to remove dirt and grime.
- Wax your vehicle twice a year to protect the paint.
- Check the tire pressure regularly and adjust it as needed.
- Inspect the brakes regularly for wear and tear.
- Keep the interior of your vehicle clean and free of debris.

By following these tips, you can help to keep your Cymbal Starlight 2024 in top condition for many years to come.

## **Chapter 18: Emergencies**

**Roadside Assistance**

If you experience a roadside emergency, such as a flat tire or a dead battery, you can call roadside assistance for help. Roadside assistance is available 24 hours a day, 7 days a week.

To call roadside assistance, dial the following number:

- 1-800-555-1212

When you call roadside assistance, be prepared to provide the following information:

- Your name and contact information
- Your vehicle's make, model, and year
- Your vehicle's location
- The nature of the emergency

**Flat Tire**

If you experience a flat tire, pull over to the side of the road in a safe location. Turn on your hazard lights and set out flares or reflective triangles to warn other drivers.

To change a flat tire, follow these steps:

1. Gather the necessary tools, including a jack, lug wrench, and spare tire.
2. Loosen the lug nuts on the flat tire, but do not remove them completely.
3. Position the jack next to the flat tire and raise the vehicle until there is approximately 6 inches of clearance between the ground and the flat tire.
4. Remove the lug nuts and take off the flat tire.
5. Mount the spare tire on the wheel studs and tighten the lug nuts.
6. Lower the vehicle to the ground and tighten the lug nuts further.
7. Stow the flat tire and tools in the trunk.

**Dead Battery**

If your battery is dead, you can jump-start your vehicle using another vehicle. To jump-start your vehicle, follow these steps:

1. Park the other vehicle close to yours.
2. Connect one end of the jumper cables to the positive terminal on your battery.
3. Connect the other end of the jumper cables to the positive terminal on the other vehicle's battery.
4. Connect one end of the remaining jumper cable to the negative terminal on the other vehicle's battery.
5. Connect the other end of the remaining jumper cable to an unpainted metal surface on your vehicle.
6. Start the other vehicle and let it run for a few minutes.
7. Attempt to start your vehicle.
8. Once your vehicle has started, remove the jumper cables in the reverse order that you connected them.
