# Gemini Use Cases

This directory contains notebooks and resources that demonstrate how to use Gemini for a variety of use cases.

## Notebooks

- [Gemini: An Overview of Multimodal Use Cases](intro_multimodal_use_cases.ipynb): Explore a variety of different use cases enabled by multimodality with Gemini.

## Use Cases

- [Applying LLMs to Data](applying-llms-to-data/): Learn how to apply LLMs to your data in BigQuery using Gemini.
- [Code](code/): Learn how to use Gemini for various code-related tasks like analysis, retrieval-augmented generation, and security scanning.
- [Customer Support](customer-support/): Learn how to build a customer support solution with Gemini.
- [Data Augmentation](data-augmentation/): Learn how to use Gemini for text data augmentation.
- [Data Generation](data-generation/): Learn how to generate synthetic data using Gemini.
- [Diarized Transcription Summarization](diarized-transcription-summarization/): Learn how to perform diarized transcription and summarization with Gemini.
- [Document Processing](document-processing/): Learn how to process and understand documents using Gemini.
- [Education](education/): Explore use cases for Gemini in the education sector.
- [Entity Extraction](entity-extraction/): A flexible solution for extracting structured information from documents using Gemini models via the Vertex AI API.
- [GraphRAG](graphrag/): Learn how to use GraphRAG with Gemini.
- [Healthcare](healthcare/): Learn how to use Gemini with healthcare APIs.
- [Know Your Customer (KYC)](kyc/): Learn how to perform Know Your Customer (KYC) with grounding.
- [Marketing](marketing/): Learn how to create marketing assets with Gemini.
- [Multimodal Data Curation](multimodal-data-curation/): A comprehensive solution for curating pre-training data for text-to-video models on Google Cloud.
- [Multimodal Sentiment Analysis](multimodal-sentiment-analysis/): Learn how to perform multimodal sentiment analysis with Gemini.
- [Productivity](productivity/): Learn how to use Gemini to boost your productivity.
- [Retail](retail/): Explore retail use cases for Gemini.
- [Retrieval-Augmented Generation](retrieval-augmented-generation/): Learn about Retrieval-Augmented Generation (RAG) with Gemini.
- [Sheets Integration](sheets-integration/): Learn how to integrate Gemini with Google Sheets.
- [Spatial Understanding](spatial-understanding/): Learn about spatial understanding with Gemini.
- [Video Analysis](video-analysis/): Learn how to perform video analysis with Gemini.
- [Video Thumbnail Generation](video-thumbnail-generation/): Learn how to generate video thumbnails with Gemini.
- [Vision Assistant](vision-assistant/): Learn how to build an enhanced vision assistant with Gemini.
