# Vision

This directory contains examples and guides for using Google Cloud's models for image and video generation, including [Imagen](https://docs.cloud.google.com/vertex-ai/generative-ai/docs/image/generate-images) for image generation and [Veo](https://docs.cloud.google.com/vertex-ai/generative-ai/docs/video/overview) for video generation.

If you're interested in using the Nano Banana models for image generation, check out these notebooks:
- [Nano Banana](../gemini/getting-started/intro_gemini_2_5_image_gen.ipynb): Learn how to generate and edit images with Gemini 2.5 Flash Image.
- [Nano Banana Pro](../gemini/getting-started/intro_gemini_3_image_gen.ipynb): Generate and edit images with Gemini 3 Pro Image.

## Getting Started

- [Image Segmentation on Vertex AI](getting-started/image_segmentation.ipynb): Segment images using various modes like foreground/background, semantic, and prompt-based segmentation.
- [Imagen Product Recontextualization](getting-started/imagen_product_recontext.ipynb): Recontextualize product images with Imagen.
- [Imagen 3 Customization](getting-started/imagen3_customization.ipynb): Generate customized images using few-shot learning with Imagen 3.
- [Imagen 3 Editing](getting-started/imagen3_editing.ipynb): Edit images with Imagen 3 using mask-based editing.
- [Imagen 4 Image Generation](getting-started/imagen4_image_generation.ipynb): Generate images with Imagen 4, Imagen 4 Fast, and Imagen 4 Ultra.
- [Imagen 4 Upscaling](getting-started/imagen4_upscale.ipynb): Upscale images with Imagen 4 by a factor of 2x, 3x, or 4x.
- [Veo 2 Editing](getting-started/veo2_editing.ipynb): Edit videos with Veo 2 by adding and removing objects.
- [Veo 2 Reference to Video](getting-started/veo2_reference_to_video.ipynb): Generate videos from an asset and style reference image with Veo 2.
- [Veo 3 Advanced Controls](getting-started/veo3_advanced_controls.ipynb): Explore advanced controls for Veo 3, like frame interpolation and video extension.
- [Veo 3 Reference to Video](getting-started/veo3_reference_to_video.ipynb): Generate videos from asset reference images with Veo 3.
- [Veo 3 Video Generation](getting-started/veo3_video_generation.ipynb): Generate videos with audio from text and image inputs with Veo 3.
- [Virtual Try-On](getting-started/virtual_try_on.ipynb): Perform virtual try-on by providing an image of a model and clothing items.

## Use Cases

- [Batch Virtual Try-On](use-cases/batch_virtual_try_on.ipynb): Learn how to perform batch virtual try-on.
- [HEY_LLM / IMAGEN](use-cases/hey_llm/README.md): Custom Google Sheets functions that bring the power of Gemini and Imagen right into your spreadsheets.

## Sample Apps

- [V-Start](sample-apps/V-Start/README.md): A sample application that helps users easily and quickly create effective prompts for Veo and evaluate how well generated videos align with their intended prompts.

## Video Overviews

**YouTube Video: Introduction to Image Editing on Vertex AI**

<!-- markdownlint-disable MD033 -->
<a href="https://www.youtube.com/watch?v=E_7P2SIdkIg" target="_blank">
  <img src="https://img.youtube.com/vi/E_7P2SIdkIg/maxresdefault.jpg" alt="Introduction to Image Editing on Vertex AI" width="500">
</a>
<!-- markdownlint-enable MD033 -->

**YouTube Video: Introduction to Video Editing on Vertex AI**

<!-- markdownlint-disable MD033 -->
<a href="https://www.youtube.com/watch?v=5_zahcDOohY" target="_blank">
  <img src="https://img.youtube.com/vi/5_zahcDOohY/maxresdefault.jpg" alt="Introduction to Video Editing on Vertex AI" width="500">
</a>
<!-- markdownlint-enable MD033 -->
