"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const decodeAscii_1 = require("../decodeAscii");
const v18_1 = require("./v18");
const hasBuffer = typeof Buffer !== 'undefined';
const utf8Slice = hasBuffer ? Buffer.prototype.utf8Slice : null;
const from = hasBuffer ? Buffer.from : null;
const shortDecoder = (buf, start, length) => { var _a; return (_a = (0, decodeAscii_1.decodeAsciiMax15)(buf, start, length)) !== null && _a !== void 0 ? _a : (0, v18_1.default)(buf, start, length); };
const midDecoder = (buf, start, length) => { var _a; return (_a = (0, decodeAscii_1.decodeAscii)(buf, start, length)) !== null && _a !== void 0 ? _a : (0, v18_1.default)(buf, start, length); };
const longDecoder = utf8Slice
    ? (buf, start, length) => utf8Slice.call(buf, start, start + length)
    : from
        ? (buf, start, length) => from(buf)
            .subarray(start, start + length)
            .toString('utf8')
        : v18_1.default;
const decoder = (buf, start, length) => {
    if (length < 16)
        return shortDecoder(buf, start, length);
    if (length < 32)
        return midDecoder(buf, start, length);
    return longDecoder(buf, start, length);
};
exports.default = decoder;
//# sourceMappingURL=v16.js.map