/*
 * This file is generated by jOOQ.
 */
package jooq.main.tables


import java.time.OffsetDateTime

import jooq.main.Public
import jooq.main.keys.ARTICLE_AUTHOR__ARTICLE_AUTHOR_ARTICLE_ID_FKEY
import jooq.main.keys.ARTICLE_KOTLIN_VERSION__ARTICLE_KOTLIN_VERSION_ARTICLE_ID_FKEY
import jooq.main.keys.ARTICLE_LIBRARY__ARTICLE_LIBRARY_ARTICLE_ID_FKEY
import jooq.main.keys.ARTICLE_PKEY
import jooq.main.keys.ARTICLE_TOPIC__ARTICLE_TOPIC_ARTICLE_ID_FKEY
import jooq.main.keys.ARTICLE__ARTICLE_CREATED_BY_FKEY
import jooq.main.keys.ARTICLE__ARTICLE_ORIGINAL_ID_FKEY
import jooq.main.keys.ARTICLE__ARTICLE_UPDATED_BY_FKEY
import jooq.main.tables.Article.ArticlePath
import jooq.main.tables.ArticleAuthor.ArticleAuthorPath
import jooq.main.tables.ArticleKotlinVersion.ArticleKotlinVersionPath
import jooq.main.tables.ArticleLibrary.ArticleLibraryPath
import jooq.main.tables.ArticleTopic.ArticleTopicPath
import jooq.main.tables.KotlinVersion.KotlinVersionPath
import jooq.main.tables.Kotliner.KotlinerPath
import jooq.main.tables.Library.LibraryPath
import jooq.main.tables.Topic.TopicPath
import jooq.main.tables.records.ArticleRecord

import kotlin.collections.Collection
import kotlin.collections.List

import org.jooq.Condition
import org.jooq.Field
import org.jooq.ForeignKey
import org.jooq.Identity
import org.jooq.InverseForeignKey
import org.jooq.Name
import org.jooq.Path
import org.jooq.PlainSQL
import org.jooq.QueryPart
import org.jooq.Record
import org.jooq.SQL
import org.jooq.Schema
import org.jooq.Select
import org.jooq.Stringly
import org.jooq.Table
import org.jooq.TableField
import org.jooq.TableOptions
import org.jooq.UniqueKey
import org.jooq.impl.DSL
import org.jooq.impl.Internal
import org.jooq.impl.SQLDataType
import org.jooq.impl.TableImpl


/**
 * This class is generated by jOOQ.
 */
@Suppress("UNCHECKED_CAST")
open class Article(
    alias: Name,
    path: Table<out Record>?,
    childPath: ForeignKey<out Record, ArticleRecord>?,
    parentPath: InverseForeignKey<out Record, ArticleRecord>?,
    aliased: Table<ArticleRecord>?,
    parameters: Array<Field<*>?>?,
    where: Condition?
): TableImpl<ArticleRecord>(
    alias,
    Public.PUBLIC,
    path,
    childPath,
    parentPath,
    aliased,
    parameters,
    DSL.comment(""),
    TableOptions.table(),
    where,
) {
    companion object {

        /**
         * The reference instance of <code>public.article</code>
         */
        val ARTICLE: Article = Article()
    }

    /**
     * The class holding records for this type
     */
    override fun getRecordType(): Class<ArticleRecord> = ArticleRecord::class.java

    /**
     * The column <code>public.article.id</code>.
     */
    val ID: TableField<ArticleRecord, Long?> = createField(DSL.name("id"), SQLDataType.BIGINT.nullable(false).identity(true), this, "")

    /**
     * The column <code>public.article.created</code>.
     */
    val CREATED: TableField<ArticleRecord, OffsetDateTime?> = createField(DSL.name("created"), SQLDataType.TIMESTAMPWITHTIMEZONE(6).nullable(false), this, "")

    /**
     * The column <code>public.article.updated</code>.
     */
    val UPDATED: TableField<ArticleRecord, OffsetDateTime?> = createField(DSL.name("updated"), SQLDataType.TIMESTAMPWITHTIMEZONE(6).nullable(false), this, "")

    /**
     * The column <code>public.article.updated_by</code>.
     */
    val UPDATED_BY: TableField<ArticleRecord, Long?> = createField(DSL.name("updated_by"), SQLDataType.BIGINT.nullable(false), this, "")

    /**
     * The column <code>public.article.created_by</code>.
     */
    val CREATED_BY: TableField<ArticleRecord, Long?> = createField(DSL.name("created_by"), SQLDataType.BIGINT.nullable(false), this, "")

    /**
     * The column <code>public.article.status</code>.
     */
    val STATUS: TableField<ArticleRecord, String?> = createField(DSL.name("status"), SQLDataType.VARCHAR(50).nullable(false), this, "")

    /**
     * The column <code>public.article.title</code>.
     */
    val TITLE: TableField<ArticleRecord, String?> = createField(DSL.name("title"), SQLDataType.VARCHAR(500).nullable(false), this, "")

    /**
     * The column <code>public.article.original_id</code>.
     */
    val ORIGINAL_ID: TableField<ArticleRecord, Long?> = createField(DSL.name("original_id"), SQLDataType.BIGINT, this, "")

    /**
     * The column <code>public.article.language</code>.
     */
    val LANGUAGE: TableField<ArticleRecord, String?> = createField(DSL.name("language"), SQLDataType.VARCHAR(50).nullable(false), this, "")

    /**
     * The column <code>public.article.url</code>.
     */
    val URL: TableField<ArticleRecord, String?> = createField(DSL.name("url"), SQLDataType.VARCHAR(2000).nullable(false), this, "")

    /**
     * The column <code>public.article.content</code>.
     */
    val CONTENT: TableField<ArticleRecord, String?> = createField(DSL.name("content"), SQLDataType.CLOB.nullable(false), this, "")

    /**
     * The column <code>public.article.thumbnail</code>.
     */
    val THUMBNAIL: TableField<ArticleRecord, String?> = createField(DSL.name("thumbnail"), SQLDataType.VARCHAR(500).nullable(false), this, "")

    /**
     * The column <code>public.article.published</code>.
     */
    val PUBLISHED: TableField<ArticleRecord, OffsetDateTime?> = createField(DSL.name("published"), SQLDataType.TIMESTAMPWITHTIMEZONE(6).nullable(false), this, "")

    /**
     * The column <code>public.article.version</code>.
     */
    val VERSION: TableField<ArticleRecord, Long?> = createField(DSL.name("version"), SQLDataType.BIGINT.nullable(false).defaultValue(DSL.field(DSL.raw("0"), SQLDataType.BIGINT)), this, "")

    private constructor(alias: Name, aliased: Table<ArticleRecord>?): this(alias, null, null, null, aliased, null, null)
    private constructor(alias: Name, aliased: Table<ArticleRecord>?, parameters: Array<Field<*>?>?): this(alias, null, null, null, aliased, parameters, null)
    private constructor(alias: Name, aliased: Table<ArticleRecord>?, where: Condition?): this(alias, null, null, null, aliased, null, where)

    /**
     * Create an aliased <code>public.article</code> table reference
     */
    constructor(alias: String): this(DSL.name(alias))

    /**
     * Create an aliased <code>public.article</code> table reference
     */
    constructor(alias: Name): this(alias, null)

    /**
     * Create a <code>public.article</code> table reference
     */
    constructor(): this(DSL.name("article"), null)

    constructor(path: Table<out Record>, childPath: ForeignKey<out Record, ArticleRecord>?, parentPath: InverseForeignKey<out Record, ArticleRecord>?): this(Internal.createPathAlias(path, childPath, parentPath), path, childPath, parentPath, ARTICLE, null, null)

    /**
     * A subtype implementing {@link Path} for simplified path-based joins.
     */
    open class ArticlePath : Article, Path<ArticleRecord> {
        constructor(path: Table<out Record>, childPath: ForeignKey<out Record, ArticleRecord>?, parentPath: InverseForeignKey<out Record, ArticleRecord>?): super(path, childPath, parentPath)
        private constructor(alias: Name, aliased: Table<ArticleRecord>): super(alias, aliased)
        override fun `as`(alias: String): ArticlePath = ArticlePath(DSL.name(alias), this)
        override fun `as`(alias: Name): ArticlePath = ArticlePath(alias, this)
        override fun `as`(alias: Table<*>): ArticlePath = ArticlePath(alias.qualifiedName, this)
    }
    override fun getSchema(): Schema? = if (aliased()) null else Public.PUBLIC
    override fun getIdentity(): Identity<ArticleRecord, Long?> = super.getIdentity() as Identity<ArticleRecord, Long?>
    override fun getPrimaryKey(): UniqueKey<ArticleRecord> = ARTICLE_PKEY
    override fun getReferences(): List<ForeignKey<ArticleRecord, *>> = listOf(ARTICLE__ARTICLE_UPDATED_BY_FKEY, ARTICLE__ARTICLE_CREATED_BY_FKEY, ARTICLE__ARTICLE_ORIGINAL_ID_FKEY)

    private lateinit var _articleUpdatedByFkey: KotlinerPath

    /**
     * Get the implicit join path to the <code>public.kotliner</code> table, via
     * the <code>article_updated_by_fkey</code> key.
     */
    fun articleUpdatedByFkey(): KotlinerPath {
        if (!this::_articleUpdatedByFkey.isInitialized)
            _articleUpdatedByFkey = KotlinerPath(this, ARTICLE__ARTICLE_UPDATED_BY_FKEY, null)

        return _articleUpdatedByFkey;
    }

    val articleUpdatedByFkey: KotlinerPath
        get(): KotlinerPath = articleUpdatedByFkey()

    private lateinit var _articleCreatedByFkey: KotlinerPath

    /**
     * Get the implicit join path to the <code>public.kotliner</code> table, via
     * the <code>article_created_by_fkey</code> key.
     */
    fun articleCreatedByFkey(): KotlinerPath {
        if (!this::_articleCreatedByFkey.isInitialized)
            _articleCreatedByFkey = KotlinerPath(this, ARTICLE__ARTICLE_CREATED_BY_FKEY, null)

        return _articleCreatedByFkey;
    }

    val articleCreatedByFkey: KotlinerPath
        get(): KotlinerPath = articleCreatedByFkey()

    private lateinit var _article: ArticlePath

    /**
     * Get the implicit join path to the <code>public.article</code> table.
     */
    fun article(): ArticlePath {
        if (!this::_article.isInitialized)
            _article = ArticlePath(this, ARTICLE__ARTICLE_ORIGINAL_ID_FKEY, null)

        return _article;
    }

    val article: ArticlePath
        get(): ArticlePath = article()

    private lateinit var _articleAuthor: ArticleAuthorPath

    /**
     * Get the implicit to-many join path to the
     * <code>public.article_author</code> table
     */
    fun articleAuthor(): ArticleAuthorPath {
        if (!this::_articleAuthor.isInitialized)
            _articleAuthor = ArticleAuthorPath(this, null, ARTICLE_AUTHOR__ARTICLE_AUTHOR_ARTICLE_ID_FKEY.inverseKey)

        return _articleAuthor;
    }

    val articleAuthor: ArticleAuthorPath
        get(): ArticleAuthorPath = articleAuthor()

    private lateinit var _articleKotlinVersion: ArticleKotlinVersionPath

    /**
     * Get the implicit to-many join path to the
     * <code>public.article_kotlin_version</code> table
     */
    fun articleKotlinVersion(): ArticleKotlinVersionPath {
        if (!this::_articleKotlinVersion.isInitialized)
            _articleKotlinVersion = ArticleKotlinVersionPath(this, null, ARTICLE_KOTLIN_VERSION__ARTICLE_KOTLIN_VERSION_ARTICLE_ID_FKEY.inverseKey)

        return _articleKotlinVersion;
    }

    val articleKotlinVersion: ArticleKotlinVersionPath
        get(): ArticleKotlinVersionPath = articleKotlinVersion()

    private lateinit var _articleLibrary: ArticleLibraryPath

    /**
     * Get the implicit to-many join path to the
     * <code>public.article_library</code> table
     */
    fun articleLibrary(): ArticleLibraryPath {
        if (!this::_articleLibrary.isInitialized)
            _articleLibrary = ArticleLibraryPath(this, null, ARTICLE_LIBRARY__ARTICLE_LIBRARY_ARTICLE_ID_FKEY.inverseKey)

        return _articleLibrary;
    }

    val articleLibrary: ArticleLibraryPath
        get(): ArticleLibraryPath = articleLibrary()

    private lateinit var _articleTopic: ArticleTopicPath

    /**
     * Get the implicit to-many join path to the
     * <code>public.article_topic</code> table
     */
    fun articleTopic(): ArticleTopicPath {
        if (!this::_articleTopic.isInitialized)
            _articleTopic = ArticleTopicPath(this, null, ARTICLE_TOPIC__ARTICLE_TOPIC_ARTICLE_ID_FKEY.inverseKey)

        return _articleTopic;
    }

    val articleTopic: ArticleTopicPath
        get(): ArticleTopicPath = articleTopic()

    /**
     * Get the implicit many-to-many join path to the
     * <code>public.kotliner</code> table
     */
    val kotliner: KotlinerPath
        get(): KotlinerPath = articleAuthor().kotliner()

    /**
     * Get the implicit many-to-many join path to the
     * <code>public.kotlin_version</code> table
     */
    val kotlinVersion: KotlinVersionPath
        get(): KotlinVersionPath = articleKotlinVersion().kotlinVersion()

    /**
     * Get the implicit many-to-many join path to the
     * <code>public.library</code> table
     */
    val library: LibraryPath
        get(): LibraryPath = articleLibrary().library()

    /**
     * Get the implicit many-to-many join path to the <code>public.topic</code>
     * table
     */
    val topic: TopicPath
        get(): TopicPath = articleTopic().topic()
    override fun `as`(alias: String): Article = Article(DSL.name(alias), this)
    override fun `as`(alias: Name): Article = Article(alias, this)
    override fun `as`(alias: Table<*>): Article = Article(alias.qualifiedName, this)

    /**
     * Rename this table
     */
    override fun rename(name: String): Article = Article(DSL.name(name), null)

    /**
     * Rename this table
     */
    override fun rename(name: Name): Article = Article(name, null)

    /**
     * Rename this table
     */
    override fun rename(name: Table<*>): Article = Article(name.qualifiedName, null)

    /**
     * Create an inline derived table from this table
     */
    override fun where(condition: Condition?): Article = Article(qualifiedName, if (aliased()) this else null, condition)

    /**
     * Create an inline derived table from this table
     */
    override fun where(conditions: Collection<Condition>): Article = where(DSL.and(conditions))

    /**
     * Create an inline derived table from this table
     */
    override fun where(vararg conditions: Condition?): Article = where(DSL.and(*conditions))

    /**
     * Create an inline derived table from this table
     */
    override fun where(condition: Field<Boolean?>?): Article = where(DSL.condition(condition))

    /**
     * Create an inline derived table from this table
     */
    @PlainSQL override fun where(condition: SQL): Article = where(DSL.condition(condition))

    /**
     * Create an inline derived table from this table
     */
    @PlainSQL override fun where(@Stringly.SQL condition: String): Article = where(DSL.condition(condition))

    /**
     * Create an inline derived table from this table
     */
    @PlainSQL override fun where(@Stringly.SQL condition: String, vararg binds: Any?): Article = where(DSL.condition(condition, *binds))

    /**
     * Create an inline derived table from this table
     */
    @PlainSQL override fun where(@Stringly.SQL condition: String, vararg parts: QueryPart): Article = where(DSL.condition(condition, *parts))

    /**
     * Create an inline derived table from this table
     */
    override fun whereExists(select: Select<*>): Article = where(DSL.exists(select))

    /**
     * Create an inline derived table from this table
     */
    override fun whereNotExists(select: Select<*>): Article = where(DSL.notExists(select))
}
