/*
 * This file is generated by jOOQ.
 */
package jooq.main.tables


import java.time.OffsetDateTime

import jooq.main.Public
import jooq.main.keys.BOOK_LIBRARY__BOOK_LIBRARY_BOOK_ID_FKEY
import jooq.main.keys.BOOK_PKEY
import jooq.main.keys.BOOK_SPEAKER__BOOK_SPEAKER_BOOK_ID_FKEY
import jooq.main.tables.BookLibrary.BookLibraryPath
import jooq.main.tables.BookSpeaker.BookSpeakerPath
import jooq.main.tables.Kotliner.KotlinerPath
import jooq.main.tables.Library.LibraryPath
import jooq.main.tables.records.BookRecord

import kotlin.collections.Collection

import org.jooq.Condition
import org.jooq.Field
import org.jooq.ForeignKey
import org.jooq.Identity
import org.jooq.InverseForeignKey
import org.jooq.Name
import org.jooq.Path
import org.jooq.PlainSQL
import org.jooq.QueryPart
import org.jooq.Record
import org.jooq.SQL
import org.jooq.Schema
import org.jooq.Select
import org.jooq.Stringly
import org.jooq.Table
import org.jooq.TableField
import org.jooq.TableOptions
import org.jooq.UniqueKey
import org.jooq.impl.DSL
import org.jooq.impl.Internal
import org.jooq.impl.SQLDataType
import org.jooq.impl.TableImpl


/**
 * This class is generated by jOOQ.
 */
@Suppress("UNCHECKED_CAST")
open class Book(
    alias: Name,
    path: Table<out Record>?,
    childPath: ForeignKey<out Record, BookRecord>?,
    parentPath: InverseForeignKey<out Record, BookRecord>?,
    aliased: Table<BookRecord>?,
    parameters: Array<Field<*>?>?,
    where: Condition?
): TableImpl<BookRecord>(
    alias,
    Public.PUBLIC,
    path,
    childPath,
    parentPath,
    aliased,
    parameters,
    DSL.comment(""),
    TableOptions.table(),
    where,
) {
    companion object {

        /**
         * The reference instance of <code>public.book</code>
         */
        val BOOK: Book = Book()
    }

    /**
     * The class holding records for this type
     */
    override fun getRecordType(): Class<BookRecord> = BookRecord::class.java

    /**
     * The column <code>public.book.id</code>.
     */
    val ID: TableField<BookRecord, Long?> = createField(DSL.name("id"), SQLDataType.BIGINT.nullable(false).identity(true), this, "")

    /**
     * The column <code>public.book.title</code>.
     */
    val TITLE: TableField<BookRecord, String?> = createField(DSL.name("title"), SQLDataType.VARCHAR(500).nullable(false), this, "")

    /**
     * The column <code>public.book.description</code>.
     */
    val DESCRIPTION: TableField<BookRecord, String?> = createField(DSL.name("description"), SQLDataType.CLOB.nullable(false), this, "")

    /**
     * The column <code>public.book.language</code>.
     */
    val LANGUAGE: TableField<BookRecord, String?> = createField(DSL.name("language"), SQLDataType.VARCHAR(50).nullable(false), this, "")

    /**
     * The column <code>public.book.price</code>.
     */
    val PRICE: TableField<BookRecord, Int?> = createField(DSL.name("price"), SQLDataType.INTEGER.nullable(false), this, "")

    /**
     * The column <code>public.book.url</code>.
     */
    val URL: TableField<BookRecord, String?> = createField(DSL.name("url"), SQLDataType.VARCHAR(500).nullable(false), this, "")

    /**
     * The column <code>public.book.thumbnail</code>.
     */
    val THUMBNAIL: TableField<BookRecord, String?> = createField(DSL.name("thumbnail"), SQLDataType.VARCHAR(500).nullable(false), this, "")

    /**
     * The column <code>public.book.created</code>.
     */
    val CREATED: TableField<BookRecord, OffsetDateTime?> = createField(DSL.name("created"), SQLDataType.TIMESTAMPWITHTIMEZONE(6).nullable(false), this, "")

    /**
     * The column <code>public.book.updated</code>.
     */
    val UPDATED: TableField<BookRecord, OffsetDateTime?> = createField(DSL.name("updated"), SQLDataType.TIMESTAMPWITHTIMEZONE(6).nullable(false), this, "")

    private constructor(alias: Name, aliased: Table<BookRecord>?): this(alias, null, null, null, aliased, null, null)
    private constructor(alias: Name, aliased: Table<BookRecord>?, parameters: Array<Field<*>?>?): this(alias, null, null, null, aliased, parameters, null)
    private constructor(alias: Name, aliased: Table<BookRecord>?, where: Condition?): this(alias, null, null, null, aliased, null, where)

    /**
     * Create an aliased <code>public.book</code> table reference
     */
    constructor(alias: String): this(DSL.name(alias))

    /**
     * Create an aliased <code>public.book</code> table reference
     */
    constructor(alias: Name): this(alias, null)

    /**
     * Create a <code>public.book</code> table reference
     */
    constructor(): this(DSL.name("book"), null)

    constructor(path: Table<out Record>, childPath: ForeignKey<out Record, BookRecord>?, parentPath: InverseForeignKey<out Record, BookRecord>?): this(Internal.createPathAlias(path, childPath, parentPath), path, childPath, parentPath, BOOK, null, null)

    /**
     * A subtype implementing {@link Path} for simplified path-based joins.
     */
    open class BookPath : Book, Path<BookRecord> {
        constructor(path: Table<out Record>, childPath: ForeignKey<out Record, BookRecord>?, parentPath: InverseForeignKey<out Record, BookRecord>?): super(path, childPath, parentPath)
        private constructor(alias: Name, aliased: Table<BookRecord>): super(alias, aliased)
        override fun `as`(alias: String): BookPath = BookPath(DSL.name(alias), this)
        override fun `as`(alias: Name): BookPath = BookPath(alias, this)
        override fun `as`(alias: Table<*>): BookPath = BookPath(alias.qualifiedName, this)
    }
    override fun getSchema(): Schema? = if (aliased()) null else Public.PUBLIC
    override fun getIdentity(): Identity<BookRecord, Long?> = super.getIdentity() as Identity<BookRecord, Long?>
    override fun getPrimaryKey(): UniqueKey<BookRecord> = BOOK_PKEY

    private lateinit var _bookLibrary: BookLibraryPath

    /**
     * Get the implicit to-many join path to the
     * <code>public.book_library</code> table
     */
    fun bookLibrary(): BookLibraryPath {
        if (!this::_bookLibrary.isInitialized)
            _bookLibrary = BookLibraryPath(this, null, BOOK_LIBRARY__BOOK_LIBRARY_BOOK_ID_FKEY.inverseKey)

        return _bookLibrary;
    }

    val bookLibrary: BookLibraryPath
        get(): BookLibraryPath = bookLibrary()

    private lateinit var _bookSpeaker: BookSpeakerPath

    /**
     * Get the implicit to-many join path to the
     * <code>public.book_speaker</code> table
     */
    fun bookSpeaker(): BookSpeakerPath {
        if (!this::_bookSpeaker.isInitialized)
            _bookSpeaker = BookSpeakerPath(this, null, BOOK_SPEAKER__BOOK_SPEAKER_BOOK_ID_FKEY.inverseKey)

        return _bookSpeaker;
    }

    val bookSpeaker: BookSpeakerPath
        get(): BookSpeakerPath = bookSpeaker()

    /**
     * Get the implicit many-to-many join path to the
     * <code>public.library</code> table
     */
    val library: LibraryPath
        get(): LibraryPath = bookLibrary().library()

    /**
     * Get the implicit many-to-many join path to the
     * <code>public.kotliner</code> table
     */
    val kotliner: KotlinerPath
        get(): KotlinerPath = bookSpeaker().kotliner()
    override fun `as`(alias: String): Book = Book(DSL.name(alias), this)
    override fun `as`(alias: Name): Book = Book(alias, this)
    override fun `as`(alias: Table<*>): Book = Book(alias.qualifiedName, this)

    /**
     * Rename this table
     */
    override fun rename(name: String): Book = Book(DSL.name(name), null)

    /**
     * Rename this table
     */
    override fun rename(name: Name): Book = Book(name, null)

    /**
     * Rename this table
     */
    override fun rename(name: Table<*>): Book = Book(name.qualifiedName, null)

    /**
     * Create an inline derived table from this table
     */
    override fun where(condition: Condition?): Book = Book(qualifiedName, if (aliased()) this else null, condition)

    /**
     * Create an inline derived table from this table
     */
    override fun where(conditions: Collection<Condition>): Book = where(DSL.and(conditions))

    /**
     * Create an inline derived table from this table
     */
    override fun where(vararg conditions: Condition?): Book = where(DSL.and(*conditions))

    /**
     * Create an inline derived table from this table
     */
    override fun where(condition: Field<Boolean?>?): Book = where(DSL.condition(condition))

    /**
     * Create an inline derived table from this table
     */
    @PlainSQL override fun where(condition: SQL): Book = where(DSL.condition(condition))

    /**
     * Create an inline derived table from this table
     */
    @PlainSQL override fun where(@Stringly.SQL condition: String): Book = where(DSL.condition(condition))

    /**
     * Create an inline derived table from this table
     */
    @PlainSQL override fun where(@Stringly.SQL condition: String, vararg binds: Any?): Book = where(DSL.condition(condition, *binds))

    /**
     * Create an inline derived table from this table
     */
    @PlainSQL override fun where(@Stringly.SQL condition: String, vararg parts: QueryPart): Book = where(DSL.condition(condition, *parts))

    /**
     * Create an inline derived table from this table
     */
    override fun whereExists(select: Select<*>): Book = where(DSL.exists(select))

    /**
     * Create an inline derived table from this table
     */
    override fun whereNotExists(select: Select<*>): Book = where(DSL.notExists(select))
}
