/*
 * This file is generated by jOOQ.
 */
package jooq.main.tables


import jooq.main.Public
import jooq.main.keys.ARTICLE_LIBRARY__ARTICLE_LIBRARY_LIBRARY_ID_FKEY
import jooq.main.keys.BOOK_LIBRARY__BOOK_LIBRARY_LIBRARY_ID_FKEY
import jooq.main.keys.COURSE_LIBRARY__COURSE_LIBRARY_LIBRARY_ID_FKEY
import jooq.main.keys.LIBRARY_PKEY
import jooq.main.keys.LIBRARY_VERSION__LIBRARY_VERSION_LIBRARY_ID_FKEY
import jooq.main.keys.VIDEO_LIBRARY__VIDEO_LIBRARY_LIBRARY_ID_FKEY
import jooq.main.tables.Article.ArticlePath
import jooq.main.tables.ArticleLibrary.ArticleLibraryPath
import jooq.main.tables.Book.BookPath
import jooq.main.tables.BookLibrary.BookLibraryPath
import jooq.main.tables.Course.CoursePath
import jooq.main.tables.CourseLibrary.CourseLibraryPath
import jooq.main.tables.LibraryVersion.LibraryVersionPath
import jooq.main.tables.Video.VideoPath
import jooq.main.tables.VideoLibrary.VideoLibraryPath
import jooq.main.tables.records.LibraryRecord

import kotlin.collections.Collection

import org.jooq.Condition
import org.jooq.Field
import org.jooq.ForeignKey
import org.jooq.Identity
import org.jooq.InverseForeignKey
import org.jooq.Name
import org.jooq.Path
import org.jooq.PlainSQL
import org.jooq.QueryPart
import org.jooq.Record
import org.jooq.SQL
import org.jooq.Schema
import org.jooq.Select
import org.jooq.Stringly
import org.jooq.Table
import org.jooq.TableField
import org.jooq.TableOptions
import org.jooq.UniqueKey
import org.jooq.impl.DSL
import org.jooq.impl.Internal
import org.jooq.impl.SQLDataType
import org.jooq.impl.TableImpl


/**
 * This class is generated by jOOQ.
 */
@Suppress("UNCHECKED_CAST")
open class Library(
    alias: Name,
    path: Table<out Record>?,
    childPath: ForeignKey<out Record, LibraryRecord>?,
    parentPath: InverseForeignKey<out Record, LibraryRecord>?,
    aliased: Table<LibraryRecord>?,
    parameters: Array<Field<*>?>?,
    where: Condition?
): TableImpl<LibraryRecord>(
    alias,
    Public.PUBLIC,
    path,
    childPath,
    parentPath,
    aliased,
    parameters,
    DSL.comment(""),
    TableOptions.table(),
    where,
) {
    companion object {

        /**
         * The reference instance of <code>public.library</code>
         */
        val LIBRARY: Library = Library()
    }

    /**
     * The class holding records for this type
     */
    override fun getRecordType(): Class<LibraryRecord> = LibraryRecord::class.java

    /**
     * The column <code>public.library.id</code>.
     */
    val ID: TableField<LibraryRecord, Long?> = createField(DSL.name("id"), SQLDataType.BIGINT.nullable(false).identity(true), this, "")

    /**
     * The column <code>public.library.title</code>.
     */
    val TITLE: TableField<LibraryRecord, String?> = createField(DSL.name("title"), SQLDataType.VARCHAR(500).nullable(false), this, "")

    private constructor(alias: Name, aliased: Table<LibraryRecord>?): this(alias, null, null, null, aliased, null, null)
    private constructor(alias: Name, aliased: Table<LibraryRecord>?, parameters: Array<Field<*>?>?): this(alias, null, null, null, aliased, parameters, null)
    private constructor(alias: Name, aliased: Table<LibraryRecord>?, where: Condition?): this(alias, null, null, null, aliased, null, where)

    /**
     * Create an aliased <code>public.library</code> table reference
     */
    constructor(alias: String): this(DSL.name(alias))

    /**
     * Create an aliased <code>public.library</code> table reference
     */
    constructor(alias: Name): this(alias, null)

    /**
     * Create a <code>public.library</code> table reference
     */
    constructor(): this(DSL.name("library"), null)

    constructor(path: Table<out Record>, childPath: ForeignKey<out Record, LibraryRecord>?, parentPath: InverseForeignKey<out Record, LibraryRecord>?): this(Internal.createPathAlias(path, childPath, parentPath), path, childPath, parentPath, LIBRARY, null, null)

    /**
     * A subtype implementing {@link Path} for simplified path-based joins.
     */
    open class LibraryPath : Library, Path<LibraryRecord> {
        constructor(path: Table<out Record>, childPath: ForeignKey<out Record, LibraryRecord>?, parentPath: InverseForeignKey<out Record, LibraryRecord>?): super(path, childPath, parentPath)
        private constructor(alias: Name, aliased: Table<LibraryRecord>): super(alias, aliased)
        override fun `as`(alias: String): LibraryPath = LibraryPath(DSL.name(alias), this)
        override fun `as`(alias: Name): LibraryPath = LibraryPath(alias, this)
        override fun `as`(alias: Table<*>): LibraryPath = LibraryPath(alias.qualifiedName, this)
    }
    override fun getSchema(): Schema? = if (aliased()) null else Public.PUBLIC
    override fun getIdentity(): Identity<LibraryRecord, Long?> = super.getIdentity() as Identity<LibraryRecord, Long?>
    override fun getPrimaryKey(): UniqueKey<LibraryRecord> = LIBRARY_PKEY

    private lateinit var _articleLibrary: ArticleLibraryPath

    /**
     * Get the implicit to-many join path to the
     * <code>public.article_library</code> table
     */
    fun articleLibrary(): ArticleLibraryPath {
        if (!this::_articleLibrary.isInitialized)
            _articleLibrary = ArticleLibraryPath(this, null, ARTICLE_LIBRARY__ARTICLE_LIBRARY_LIBRARY_ID_FKEY.inverseKey)

        return _articleLibrary;
    }

    val articleLibrary: ArticleLibraryPath
        get(): ArticleLibraryPath = articleLibrary()

    private lateinit var _bookLibrary: BookLibraryPath

    /**
     * Get the implicit to-many join path to the
     * <code>public.book_library</code> table
     */
    fun bookLibrary(): BookLibraryPath {
        if (!this::_bookLibrary.isInitialized)
            _bookLibrary = BookLibraryPath(this, null, BOOK_LIBRARY__BOOK_LIBRARY_LIBRARY_ID_FKEY.inverseKey)

        return _bookLibrary;
    }

    val bookLibrary: BookLibraryPath
        get(): BookLibraryPath = bookLibrary()

    private lateinit var _courseLibrary: CourseLibraryPath

    /**
     * Get the implicit to-many join path to the
     * <code>public.course_library</code> table
     */
    fun courseLibrary(): CourseLibraryPath {
        if (!this::_courseLibrary.isInitialized)
            _courseLibrary = CourseLibraryPath(this, null, COURSE_LIBRARY__COURSE_LIBRARY_LIBRARY_ID_FKEY.inverseKey)

        return _courseLibrary;
    }

    val courseLibrary: CourseLibraryPath
        get(): CourseLibraryPath = courseLibrary()

    private lateinit var _libraryVersion: LibraryVersionPath

    /**
     * Get the implicit to-many join path to the
     * <code>public.library_version</code> table
     */
    fun libraryVersion(): LibraryVersionPath {
        if (!this::_libraryVersion.isInitialized)
            _libraryVersion = LibraryVersionPath(this, null, LIBRARY_VERSION__LIBRARY_VERSION_LIBRARY_ID_FKEY.inverseKey)

        return _libraryVersion;
    }

    val libraryVersion: LibraryVersionPath
        get(): LibraryVersionPath = libraryVersion()

    private lateinit var _videoLibrary: VideoLibraryPath

    /**
     * Get the implicit to-many join path to the
     * <code>public.video_library</code> table
     */
    fun videoLibrary(): VideoLibraryPath {
        if (!this::_videoLibrary.isInitialized)
            _videoLibrary = VideoLibraryPath(this, null, VIDEO_LIBRARY__VIDEO_LIBRARY_LIBRARY_ID_FKEY.inverseKey)

        return _videoLibrary;
    }

    val videoLibrary: VideoLibraryPath
        get(): VideoLibraryPath = videoLibrary()

    /**
     * Get the implicit many-to-many join path to the
     * <code>public.article</code> table
     */
    val article: ArticlePath
        get(): ArticlePath = articleLibrary().article()

    /**
     * Get the implicit many-to-many join path to the <code>public.book</code>
     * table
     */
    val book: BookPath
        get(): BookPath = bookLibrary().book()

    /**
     * Get the implicit many-to-many join path to the <code>public.course</code>
     * table
     */
    val course: CoursePath
        get(): CoursePath = courseLibrary().course()

    /**
     * Get the implicit many-to-many join path to the <code>public.video</code>
     * table
     */
    val video: VideoPath
        get(): VideoPath = videoLibrary().video()
    override fun `as`(alias: String): Library = Library(DSL.name(alias), this)
    override fun `as`(alias: Name): Library = Library(alias, this)
    override fun `as`(alias: Table<*>): Library = Library(alias.qualifiedName, this)

    /**
     * Rename this table
     */
    override fun rename(name: String): Library = Library(DSL.name(name), null)

    /**
     * Rename this table
     */
    override fun rename(name: Name): Library = Library(name, null)

    /**
     * Rename this table
     */
    override fun rename(name: Table<*>): Library = Library(name.qualifiedName, null)

    /**
     * Create an inline derived table from this table
     */
    override fun where(condition: Condition?): Library = Library(qualifiedName, if (aliased()) this else null, condition)

    /**
     * Create an inline derived table from this table
     */
    override fun where(conditions: Collection<Condition>): Library = where(DSL.and(conditions))

    /**
     * Create an inline derived table from this table
     */
    override fun where(vararg conditions: Condition?): Library = where(DSL.and(*conditions))

    /**
     * Create an inline derived table from this table
     */
    override fun where(condition: Field<Boolean?>?): Library = where(DSL.condition(condition))

    /**
     * Create an inline derived table from this table
     */
    @PlainSQL override fun where(condition: SQL): Library = where(DSL.condition(condition))

    /**
     * Create an inline derived table from this table
     */
    @PlainSQL override fun where(@Stringly.SQL condition: String): Library = where(DSL.condition(condition))

    /**
     * Create an inline derived table from this table
     */
    @PlainSQL override fun where(@Stringly.SQL condition: String, vararg binds: Any?): Library = where(DSL.condition(condition, *binds))

    /**
     * Create an inline derived table from this table
     */
    @PlainSQL override fun where(@Stringly.SQL condition: String, vararg parts: QueryPart): Library = where(DSL.condition(condition, *parts))

    /**
     * Create an inline derived table from this table
     */
    override fun whereExists(select: Select<*>): Library = where(DSL.exists(select))

    /**
     * Create an inline derived table from this table
     */
    override fun whereNotExists(select: Select<*>): Library = where(DSL.notExists(select))
}
