
import link.kotlin.scripts.dsl.Article
import link.kotlin.scripts.dsl.LanguageCodes.RU
import link.kotlin.scripts.dsl.LinkType.article
import java.time.LocalDate

// language=Markdown
val body1 = """
Сегодня пятница, а пятница на хабре — это отличный день для чего-то необычного. Сегодня я предлагаю вашему вниманию интервью с **Дмитрием [yole](https://habrahabr.ru/users/yole/) Жемеровым**, человеком, который приложил руку и к IntelliJ IDEA, PyCharm, Kotlin и многим другим продуктам компании JetBrains.

О чем мы поговорили:

* как развивается IDEA, куда она движется
* в чем разница между IntelliJ и JetBrains
* зачем в компании два CEO
* что происходит в Kotlin'e
* с какими трудностями столкнулась команда Kotlin в процессе разработке языка
* что такое Language Design Review
* что представляет собой современный Google
* почему закрылся Google Code
* почему хабр важен для разработчиков IDE

<iframe src="https://www.youtube.com/embed/pr7faOqruQY?feature=oembed" allowfullscreen="" height="315" frameborder="0" width="560"></iframe>

— **Добрый день! Это «Без слайдов». У нас выпуск сегодня с Дмитрием Жемеровым, ветераном компании JetBrains. Дима, давай начнем с того, что ты чуть-чуть о себе расскажешь: что делал, и в JetBrains в том числе?**

В JetBrains я пришел в 2003 году. Я был 28-м или 29-м сотрудником, и за это время успел довольно много чем позаниматься. Я вначале был руководителем разработки проекта [Omea](https://www.jetbrains.com/omea/) – был такой information-агрегатор, то есть это программа, которая собирала информацию из разных источников типа почты, news’ов, RSS-фидов. Он позволял делать по ним всем поиск, это все организовывать, категоризовывать и так далее. Потом проект Omea был закрыт, и я перешел в команду IntelliJ IDEA. Можно сказать, стоял у истоков такой сущности, как IntelliJ-платформа, то есть занимался переводом монолитной среды разработки IntelliJ IDEA в платформу, на базе которой можно строить IDE для разных языков, а не только для Java. Понятно, что в этом много кто поучаствовал, но я тоже там довольно много сделал. Потом я занимался различными IDE на базе этой платформы: я успел позаниматься и RubyMine, и PyCharm, и WebStorm.

— **Куда, по-твоему, сейчас движется вообще IDEA как продукт, как платформа? Есть ощущение, что возникла некоторая стагнация: мне как пользователю IntelliJ IDEA кажется, что ничего не происходит. Выходят новые версии, они, может быть, быстрее работают, поддерживают новые framework'и. Так это, не так?**

Быстрее – это самое главное. Скорость – это такая фича, от которой никто никогда не отказывается. Мы уже довольно долгое время вкладываемся в качество пользовательских интерфейсов, юзабилити, в то, чтобы было все аккуратно, гладенько. Большие фичи, которые меняют ваш experience как девелопера, тоже появляются в каком-то количестве. Например, Inline Debugging, который у нас появился в 14ой версии. Когда вы step’аетесь по коду, вы сразу прямо в коде, в редакторе видите значение переменных, которые на этих строчках вычисляются. Или, например, незадолго до этого появилась поддержка нескольких кареток в редакторе – это тоже большая фича, которая для многих имеет значение. Что будет следующим, я сказать на самом деле не могу, потому что у нас процесс разработки не очень сильно далеко вперед планируется, и просто разработчику может внезапно прийти в голову идея: «Давайте-ка я займусь этой функциональностью. Давайте-ка я ее сделаю». Он пойдет и сделает, и она появится в релизе, и будет все здорово.

— **Около 3 лет назад Олег Степанов и Максим Шафиров стали CEO компании JetBrains. Во-первых, почему их два? Я не помню каких-то таких случаев, когда CEO сразу двое. Что изменилось за эти годы? Какие, может быть, задачи и цели перед ними ставились, если это открытая информация, и насколько это успешно? Что в компании изменилось?**

Два CEO — это довольно удобно оказалось, потому что два офиса. Олег живет в Мюнхене, Макс живет в Питере, и каждый из них отвечает в первую очередь за то, что происходит в их офисе. Там просто много работы, и они как-то эту работу между собой делят. Макс сейчас очень активно занимается вообще всей нашей инфраструктурой продаж, то есть нашей внутренней корпоративной информационной системой, если угодно, магазином. Тем, чтобы пользователи имели в этом месте хороший experience. Олег занимается довольно много нашими серверными инструментами, чтобы из нашего зоопарка в лице YouTrack, TeamCity и Upsource, сделать какое-то единое решение, которое можно просто поставить, и оно решит все проблемы с процессом разработки, которые есть в вашей в команде.

— **То есть, кроме разделения по офисам, есть еще разделение по продуктам?**

Это даже не столько по продуктам, сколько по областям деятельности. У нас, как и все в JetBrains, это как-то органически случается. Когда мы эту схему внедряли, у нас не было такого сразу, что давайте договоримся, кто за что отвечает – просто по ходу дела получается, что эта деятельность, ею надо заниматься, и, соответственно, тот человек, который может ее на себя взять, ее на себя берет.

— **Как ты оцениваешь эти 3 года? Что изменилось глобально?**

В плане организации работы в принципе, JetBrains остался тем же самым. Случились какие-то довольно большие проекты, например, переезд в наш новый офис на Васильевском острове, в котором Сергей Дмитриев, который до этого был руководителем компании, вообще никакого участия не принимал. Или, например, в организации продаж. Много чего изменилось за это время у нас внутри компании, какие-то вещи смогли сделать большие.

— **Два CEO — это такой эксперимент, который продолжается? Уже видны его результаты, или все еще в процессе? Или в принципе не ожидалось каких-то глобальных изменений?**

Нет, на самом деле просто в первую очередь мотивация для этого решения была очень простая. Сергей Дмитриев в какой-то момент сказал: «Я уже не молодой, грубо говоря. Я могу либо продолжать делать дальше JetBrains, либо я могу оставить JetBrains, который был сделан, каким-то другим людям из команды, и сам пойти заниматься какой-то другой деятельностью». Судя по тому, что он эти 3 года успешно занимается другой деятельностью, не отвлекаясь на JetBrains или очень мало отвлекаясь на JetBrains, то, в общем-то, все получилось. JetBrains за это время растет, успешно разется и так далее. Эта задача была в полной мере выполнена.

— **На твоем [старом сайте](http://yole.ru) есть запись, датированная 2003 годом, что ты устроился в IntelliJ Labs. Сейчас мы компанию знаем как JetBrains. Ты можешь немножко рассказать о связи JetBrains и IntelliJ Labs?**

Это очень просто. IntelliJ Labs – это название, под которым компания появилась. В 2000-2001 году первые версии IntelliJ IDEA были выпущены под маркой IntelliJ Software или IntelliJ Labs. Потом, когда стало понятно, что мы хотим делать продукты не только для Java, соответственно, название с буквой «J» нам не годится. Мы поставили букву «J» в начало и придумали название JetBrains. IntelliJ Labs до сих пор сохранилось в названии российского юридического лица нашей компании — ООО «ИНТЕЛЛИДЖЕЙ ЛАБС». «JetBrains» – это, соответственно, юрлицо headquarters компании.

— **JetBrains, который был в середине 2000-х, и JetBrains образца 2015 года — чувствуешь ли ты какую-то разницу между ними, и если да, то что тебе нравится, что тебе не нравится?**

Понятно, что в компании такого размера просто уже другой уровень личных связей. Когда я из Мюнхена приезжаю в Питер, я хожу по офису и вижу массу людей, про которых я часто даже не знаю: они работают у нас в компании, они зашли к кому-то в гости или они просто пиццу привезли. Это люди, которых я не знаю; я не знаю, чем они занимаются. Положительно то, что JetBrains очень долгое время был хронически understaffed, то есть все время было состояние, что работы было больше, чем людей, которые имеются, чтобы ее делать. Мне кажется, что в последнее время в очень многих проектах мы из этого состояния выходим – не во всех, но во многих. Грубо говоря, у нас столько людей, сколько нужно, чтобы реально продукты вперед двигать.

— **Сейчас у вас 300 человек, 400?**

400 с чем-то.

— **Это в основном Питер и Мюнхен, да?**

Да, у нас сейчас, наверное, 80 человек в Мюнхене и, соответственно, 400 с чем-то в Питере пока.

— **Сотни людей. Распределенность создает вам какие-то сложности?**

Мне не кажется, что создает. Как правило, в Мюнхен уезжают люди, которые уже какое-то время проработали в питерском офисе, которые уже знакомы с командой, с которой они вместе работают. Соответственно, нет такого, что у тебя появляется какой-то внезапный человек в другом офисе, с которым тебе нужно как-то налаживать отношения. Плюс к этому, мы часто друг к другу ездим.
— **Ты сам часто ездишь сюда?**

Каждые два-три месяца я точно в Питере бываю. Плюс к тому, у нас каждый день стендапы по видеоконференции, то есть каждый день есть какое-то количество личного общения через видеосвязь. Мне кажется, что у нас нет проблем из-за того, что мы распределенные.

Более того, я бы хотел, чтобы мы были более распределенными. Я бы хотел, чтобы мы имели возможность нанимать на работу людей, например, в Silicon Valley. Тех, которых там все устраивает, и они не хотят переезжать.

— **У вас рабочий язык английский, русский?**

Русский. Комментарии в коде всегда по-английски, всякая внутренняя коммуникация – стараемся всегда по-английски, а устное общение всегда по-русски, за исключением тех редких случаев. У нас все-таки есть некоторое количество не говорящих на русском сотрудников, и с ними, конечно, мы по-английски общаемся.

— **Понятно. Теперь еще одна интересная история. Буквально пару недель назад Андрей Бреслав выпустил [пост](http://megamozg.ru/p/15794/), на который очень многие обратили внимание, в котором, в общем, активно искал на самом деле product-менеджеров. Такой вопрос отсюда: вы недовольны своими product-менеджерами или просто ищите?**

Мы ищем людей на позицию, которая называется «Product Marketing Manager» (PMM). На самом деле, у нас очень хорошая команда подобралась. Насколько я знаю, мы довольны всеми, кто у нас сейчас на этой позиции работает. Андрей искал человека конкретно в Kotlin, где сейчас PMM просто нет. Или, например, в IntelliJ IDEA сейчас всего один человек, Андрей Чепцов, занимается продуктовым маркетингом. Это большой продукт, сложный, с большим количеством разных фич, и понятно, что там есть работа и на второго человека, и, может быть, на третьего тоже.

— **Около года назад в Kotlin пришел Илья Рыженков. Разве он не на позицию PMM пришел?**

Сейчас, по факту, получилось так, что Илья занимается в первую очередь библиотеками и инфраструктурой вокруг Kotlin'а. Он руководит командой, которая делает фреймворки для Kotlin’а, сам тоже код пишет. Мы постоянно экспериментируем с новыми фреймворками для Kotlin'а. Один у нас уже есть, но мы пробуем другие варианты, ищем, как можно было бы лучше сделать.

— **А Андрей Бреслав?**

Андрей, во-первых, главный дизайнер языка, а во-вторых, он до недавних пор был проектным менеджером всей команды. Я недавно у него забрал менеджмент IDE-команды — у нас уже есть 5 человек, которые занимаются плагинами для IntelliJ IDEA, и теперь я их руководитель. Программировать Андрей как раз решил перестать недавно, потому что не хватает на это все времени. Мы стремимся сделать релиз поскорее, и в данный момент просто есть какое-то количество открытых вопросов по дизайну языка. Мы хотим как можно скорее их закрыть, и Андрей в первую очередь сосредоточен сейчас на этом.

— **Пять человек — в одной только IDE? Когда я в последний раз плотно общался с командой Kotlin'а, это было пару лет назад, там было всего, по-моему, 9 человек. Видать, команда Kotlin’a с тех пор сильно выросла?**

Там больше 20 человек сейчас.

— **То есть, компания реально инвестирует в Kotlin?**

Да.

— **Два-три года назад складывалось ощущение, что выйдет Java 8, и все, дальше Kotlin будет не нужен. А вы сейчас только увеличили инвестиции. Вы делаете на него какую-то серьезную ставку? Пишете ли вы сами на нем?**

Да, у нас сейчас есть какое-то количество проектов, которые разрабатываются на Kotlin'e, но не так много, как мне лично бы хотелось. Например, следующая версия YouTrack пишется на Kotlin'е. У нас есть один не анонсированный продукт, он пишется тоже на Kotlin'е. Новая CRM-система, про которую я упоминал, вся на Kotlin'е от начала и до конца написана. Это business critical решение, через него все наши продажи проходят. Мы доверяем коду на Kotlin'е наши продажи, и это, как мне кажется, говорит о чем-то.

Ребята постоянно берут Kotlin из master'а, то есть они сидят не на релизных версиях, а каждые несколько дней апгрейдятся на самую последнюю версию Kotlin'а из свежесобранного. При этом довольны, все работает.

Насчет Kotlin vs. Java 8 — на самом деле, это некоторая распространенное заблуждение. В первую очередь, Java довольно сильно завязана на свое legacy. В [прошлом выпуске](http://habr.ru/p/255219/) «Без слайдов» это тоже обсуждалось. Сергей Куксенко говорил, что было бы здорово все выкинуть и написать с нуля. Он, наверное, скорее имел в виду библиотеку и виртуальную машину, но с точки зрения дизайна языка Java тоже есть решения, которые когда-то были приняты и которые будут с нами навсегда. Например, Raw Types, Wildcards, разделение на примитивные и непримитивные типы и так далее – это никуда не денется, и сколько бы Java не развивалась, эта legacy останется навсегда. Само по себе то, что мы не завязаны на эту обратную совместимость, нам уже развязывает руки, уже дает нам возможность делать какие-то интересные вещи.

Сейчас, когда я кому-то рассказываю о Kotlin'е, а я время от времени делаю доклады, я первые примерно 20 минут вообще никаких лямбд не упоминаю – просто показываю разные фичи Kotlin'а. Там есть очень много всего, что вообще не затрагивает тех изменений, которые произошли между седьмой и восьмой Jav'ой — просто вещи, в которых мы улучшаем ту часть Java, которая никак этим всем не затронута.

Потом уже, конечно, лямбды. У нас есть лямбды, и они лучше, чем в Java 8, потому что у нас есть на уровне языка поддержка инлайнинга. Смысл в том, что когда вы используете лямбду просто для того, чтобы пройтись по циклу какой-то очень простой функции – например, найти все элементы, которые больше, чем 8. Наивный способ это транслировать – сгенерировать inner class с одним методом, который проверяет, что число больше, чем 8. Потом у вас есть функция filter, которая, собственно, получает экземпляр этого класса и применяет его к каждому элементу коллекции, и есть код, из которого это все вызывается.

В Java все примерно так и работает. Там используется invokedynamic и method handle. Поэтому там часть этого генерируется во время исполнения. Как мы [узнали](https://vimeo.com/131394615) на конференции Geekout, Java на данный момент не умеет это все инлайнить. А у нас есть поддержка на уровне языка. Мы просто говорим, что функция Filter помещается в инлайн. Это означает, что этот код, который внутри самой лямбды, и само тело функции записываются прямо в место, где мы вызываем. Соответственно, получается, что у нас нет никакого оверхеда по перформансу. У нас нет создания отдельных объектов. У нас нет каких-то виртуальных вызовов, не дай бог, еще мегаморфных. Наш код делает ровно то же, что происходило бы, если бы вы написали все руками без использования лямбды.

— **Я так понимаю, что именно invokedynamic является какой-то помехой для инлайна?**

Нет, я бы не сказал, что именно в invokedynamic'е дело, но инлайнинг так работает, что он не умеет понимать, что сквозь лямбду и функцию, через которую она передается, можно это все заинлайнить. Возможно, когда-нибудь этот недостаток в JVM будет устранен. Насколько я понимаю, над этим ведется работа, но в Kotlin'е на уровне языка это решено.

— **Понятно. А сам Kotlin когда появился? Как вообще идея такая пришла в голову?**

Начинали мы, насколько я помню, примерно в конце 2010 года. Я не буду говорить, что это прямо я все придумал. В какой-то момент я пришел к Сергею Дмитриеву (одному из основателей JetBrains — прим. автора) и сказал, что было бы клево, если бы в JetBrains появился свой язык. Для меня это выглядело как естественное развитие. Наш слоган, —«Develop with pleasure», по-русски — «Разрабатывай с удовольствием». Мы довольно много делаем в области инструментов, чтобы люди действительно разрабатывали с удовольствием: рефакторинг, комплишен, подсветка ошибок – все, что мы очень хорошо умеем делать для 25 разных языков. Все равно мы видим, что IDE приходится делать затычки для недостатков языка.

Например, IDEA умеет анонимный класс показывать в виде лямбд. Если вы используете Java 6 или Java 7, вы пишете анонимные классы: new Instance, декларация метода, тело. В IDEA все это сворачивается в лямбду. Это в чистом виде затычка для недостатка языка. Мы решили, что мы можем попробовать просто сделать язык, в котором затычки будут не нужны, на котором будет просто приятно писать.

IDEA, конечно, все равно полезна и помогает, но она не является каким-то костылем. Было ощущение, что мы это сможем сделать, потому что у нас достаточно накоплен релевантный опыт с разработкой IDE-плагинов и поддержкой языков. Было ощущение, что у нас достаточно веса на рынке, чтобы народ это заинтересовало. Было ощущение, что это нам нужно самим, потому что мы так все там написали в поддержку того, сего, пятого, десятого, а сами программируем на Java.

Вся IDEA до сих пор написана на Java 6. Мы начали использовать Kotlin, но все остальное написано на Java 6. Было ощущение, что это то, что может выстрелить. Понятно было, что это история долгая, но наверное, я недооценивал, насколько она долгая.
Дальше это заронило какое-то зерно, там тоже это обсуждалось с разными другими людьми в разных других контекстах и так далее. Потом нам очень повезло познакомиться с Андреем Бреславом, и мы, собственно, начали делать сам язык. Я на начальном этапе тоже приложил руку — писал первую версию генератора байт-кода для JVM. Потом этим занимались другие люди, а я переключился на другие проекты. Я довольно долгое время Kotlin'ом не занимался и сейчас я вернулся именно в Kotlin.
А еще я название придумал. В какой-то момент пришел Дмитриев и сказал, что нужно название прямо сейчас. Типа, придумай название – и стоит над душой!

— **Нравится название?**

Поначалу мы немного смущались, потому что у нас немецкий офис есть, а в немецком языке словом Kot обозначают нечто не очень благозвучное. Но на самом деле ни немцы, ни кто-то другой – не слышали этого. Так что вначале это было как временное название, коднейм, «Project Kotlin». Мы лишь потом поняли, что нам никакое другое название не нужно, нам и так неплохо.

— **Буквально недавно анонсировалось, что вы со [Светой Исаковой](https://www.youtube.com/watch?v=-BvN0X5tqjw) будете писать книжку про Kotlin. Расскажи, пожалуйста, что за книжка, кто был инициатором этого проекта, и как вообще весь процесс написания технической книги про язык устроен?**

Мы хотим сделать книжку про Kotlin именно для Java-разработчиков. Kotlin, конечно, не ограничен одной только Java: в нем есть поддержка компиляции в JavaScript, но на данный момент мы просто не готовы говорить про это, потому что у нас там много чего не доделано и будет доделываться, скорее всего, после релиза 1.0. Сейчас мы сосредоточены на поддержке компиляции под JVM: cерверная разработка, веб-разработка, компиляция под Android. Android на самом деле — сейчас очень горячее направление для нас.
Соответственно, книжка будет для людей, которые уже умеют программировать на Javа, которые знают про Generics и про JVM. Наличие такой книги позволит им легко переключиться на Kotlin. Книга расскажет, как именно при помощи Kotlin'а решить их задачи, и в частности, как интегрировать Kotlin в существующий Java-проект.

Важное свойство Kotlin'а заключается в том, что вам не нужно ничего выкидывать или менять — вы просто берете один класс и переписываете на Kotlin'е. Он становится в полтора раза меньше, в два раза красивее. Потом вы повторяете процедуру, в общем-то, с любым кодом, который вам зачем-то нужно менять. Код, который вы написали на Java и не трогаете, может оставаться на Java: он никому не мешает, никому не вредит. Зачем лишний шум вносить? А код, который вы активно модифицируете, вы просто по мере модификации переписываете на Kotlin. Мы, собственно, в IDEA планируем ровно таким путем пойти.

Теперь насчет того, как появилась книжка. Хорошо известно, что книжка — это очень полезная штука для популярности языка. Про Scala есть книжка, которую тоже очень многие читали и хвалили, и популярность Ruby on Rails началась с книжки. Поэтому в какой-то момент я понял, что заняться написанием книги было бы самой значимой штукой, которую я мог бы сделать. Я поговорил с коллегами, и они одобрили эту идею. Света Исакова, инженер Kotlin’а, сказала, что ей тоже было бы интересно этим заниматься.
Мы почитали, как устроен процесс написания книги про язык программирования. Нужно иметь Table of Contents (оглавление) и иметь первую главу. С этим можно идти в издательство. Мы накидали какое-то оглавление и начали собираться писать первую главу. В этот момент параллельно пришло письмо от издательства Manning, довольно абстрактное, мол, давайте поговорим про Kotlin. Не то, что они прямо звали нас писать книжку. Мы сказали им, что мы собираемся писать книжку, и что если им интересно, то мол, давайте приступать. Они ответили, что им интересно. Так мы и начали работу.

— **Как будет называться книжка?**

«Kotlin in Action». In Action – это название серии их книг.

![](https://habrastorage.org/files/7d8/46b/e36/7d846be36989482a9d078dd573c64c9f.jpg)

— **А как Manning вас заметил в плане Kotlin'а? Они как-то мониторят информационное пространство?**

Да, есть такие люди, называются acquisition editors, обязанность которых заключается в том, чтобы выискивать темы, про которые было бы интересно издать книжку, и выискивают людей, которые могут такую книжку написать. Они на нас вышли, и мы с ними договорились. Тут взаимный интерес.

— **Тогда немного странный вопрос. Обычно, когда автор пишет книжку, ему за это платят гонорар. Тут вы пишете книгу про продукт, который разрабатывается не только вами, но вашей компанией. Как этот вопрос вообще решается? Какие есть подходы к этому?**

Мы просто пишем книжку, нам платят гонорар. У нас будет гонорар, у нас прописано в контракте – обычные совершенно условия royalty.

— **А JetBrains просто выделяет вам со Светой бюджет времени на это?**

Да. Дело в том, что у нас нет какого-то жесткого регламента, мол, можно вот этим заниматься Х часов в неделю. Книжка – это не единственное, чем я сейчас занимаюсь. Возможно, я об этом еще пожалею, но сейчас я книжку сочетаю с какой-то еще работой.

— **Есть люди типа Венката Субраманиама, для которых написание книг и тренинги – это вообще основное направление деятельности.**

Я все-таки программист, я не могу не программировать.

— **Понятно. У вас в какой-то момент это было вообще частью культуры**

До сих пор так, все программируют, оба CEO программируют.

— **Интересно, что язык Kotlin в том виде, в котором он будет зарелизен, это не все, о чем думают люди, которые его разрабатывают. Есть такое ощущение, что вы еще думаете на несколько лет вперед. Почему это ощущение возникло? Я услышал в одном из выступлений Ильи Рыженкова о процедуре Language Design Review. Он тогда объяснил, что это делается для того, чтобы вы примерно понимали, какие проблемы в будущем у вас могут возникнуть. Не мог бы ты поподробнее про этот момент рассказать?**

У нас есть в голове какое-то количество направлений, куда может развиваться язык. Понятно, за 5 лет у нас накопилось какое-то количество мыслей. Мы понимаем, что это и это хорошо было бы сделать. Мы примерно знаем, если мы это будем делать, в каком месте нам нужно будет менять язык. Соответственно, мы сейчас хотим зафиксировать синтаксис в таком состоянии, чтобы те направления изменений, которые мы планируем, не требовали от нас сломать обратную совместимость с кодом.

Это для компании JetBrains, на самом деле, совершенно новая тема. Те, кто занимался разработкой плагинов IntelliJ IDEA, с проблемой ломающегося API сталкивались постоянно. В Kotlin’е мы хотим избежать этих проблем. Более того, мы знаем, что ничего не получится, если у нас будет совместимость Kotlin'а на том же уровне, на котором существует совместимость плагинов в IDEA. Мы берем на себя commitment, что если вы напишете код для версии Kotlin'а 0.1, то следующая версия Kotlin'а 1.Х, а может быть, и 2.Х, если что-то такое когда-нибудь будет, будут продолжать этот код компилировать.

Насколько у нас получится, насколько мы сейчас подстилаем соломку в правильных местах, неизвестно. Жизнь покажет. Может быть, нам придется идти на какие-то корявые компромиссы, чтобы сделать какие-то вещи, которых у нас сейчас в голове вообще нет. По крайней мере, те вещи, которые мы хотим менять в будущем, мы стараемся зафиксировать в таком состоянии, чтобы у нас была возможность для развития.

— **Ты можешь какой-то пример привести? Или это трудно?**

Ну, например, мы думаем про то, чтобы сделать литералы для коллекций. И хотим в литералах для коллекций иметь возможность использовать символ двоеточия.

— **А что такое литералы для коллекций?**

Чтобы как в Python могли написать что-то в квадратных скобочках, просто. Не `new ArrayList` от параметров, а просто написать в квадратных скобочках что-то, и это был бы там `new ArrayList`. И, соответственно, мы резервируем символ двоеточия, например, чтобы его можно было в какой-то роли использовать.

— **То есть, свободный символ, это как раз пример такого зазора на будущее?**

Да, мы просто оставляем возможность для развития синтаксиса. И на самом деле, еще более насущно – мы просто понимаем, что мы вот сейчас в релизе 1.0 какие-то элементы оставим не в идеальном состоянии. Потому что мы не можем делать релиз вечно, нам нужно в этом году его выпустить. Соответственно, мы находим такой вариант функциональности, такое состояние, которое можно будет расширять, не ломая совместимость.

— **Правильно ли я услышал, что релиз будет в этом году?**

Очень хочется. У нас сейчас есть список задач, которые нужно до релиза делать. И мы пытаемся спланировать, сколько это все займет точно времени, чтобы точно понять, успеем ли мы до конца года зарелизить.

— **Интересная очень история, ты затронул – это история API для плагинов. В свое время очень долго команда NetBeans билась с этой проблемой, и решили они следующим образом: они взяли специальный фреймворк, кажется SigTest, и просто зафиксировали сигнатуры своих методов, API-шных, и ввели некие правила, по которым API может меняться. То есть, условно говоря, добавить метод можно, а удалить нельзя. И какие-то другие простые вещи. А как это делали вы?**

Мы очень долгое время ее не решали никак, и не могли решать. На сегодняшний день в IDEA нет Plugin API как отдельной сущности, нет фасада, который представляет некие функции, которыми вы пользуетесь. В очень многих местах у людей есть доступ непосредственно к внутренностям IDEA. То есть, плагинописатель может работать напрямую с теми классами, которые какую-то функциональность реализуют. И поэтому нам очень сложно иметь совместимость, потому что она будет сильно ограничивать развитие продукта.

Развитие кода за 15 лет было довольно феноменальное. Вначале это была монолитная Java IDE, у которой не было вообще никакого API. То есть когда делался релиз 1.0 мы поняли, что сделать API для плагинов – это два лишних месяца работы, а денег тогда было очень ограниченное количество. Надо было выпускать продукт, и получать деньги от продаж. Потом в версии 3.0 появился какой-то Plugin API, потом он постоянно расширялся. Потом появилась поддержка не только Java, но и других языков. В версии 5.0 появился JavaScript в частности. В итоге получилось сделать IDE, в которой про Java нет ничего.
В PyCharm нет ничего про Java внутри. Это стоило заметного количества усилий. Потом у нас появились компилятор Kotlin и Upsource. Код, который был распилен по одной оси, чтобы отделить Java от не Java, нужно было теперь распилить по другой оси, чтобы отделить UI от не-UI. В Kotlin’овском компиляторе нет никакого редактора. Там компилятор. Там есть файловая система, есть PSI, то есть, модель для работы с кодом. Есть еще несколько таких абстракций. Но там нет ничего визуального.
"""

val body2 = """
Соответственно, это была отдельная большая работа – сделать так, чтобы можно было сложить в такую кучку классы и платформы, чтобы они этим свойствам удовлетворяли. Не было никаких шансов сохранить совместимость API в процессе всех этих трансформаций.

— **Для этого все используют механизм версионности. Вы можете сказать, что внутри Major-версии у вас API фиксированный. От Major к Major менять API и сопровождать изменения гайдлайнами или туториалами.**

Это мы старались делать. Все большие пертурбации обычно происходили между major-релизами. Мы старались писать migration guides, когда у нас были большие пертурбации, правда, нам это не всегда удавалось. Конкретно сейчас стало заметно лучше, потому что сейчас вроде как все большие пертурбации завершены. У нас просто есть build-конфигурация на TeamCity, которая для каждого build'a IDEA берет все плагины из плагин-репозитория, и проверяет, что ни один из них не отвалился. — **Статические сигнатурные проверки?**

Да. Просто проверка, что там не будет NoSuchMethodError или еще чего-то в этом духе.

— **А идеи выносить все это в какой-то публичный API?**

Там есть какой-то API.

— **Там есть разделение насчет того, что вот это можно использовать, а вот это лучше нельзя?**

Нет, и я не очень верю, что оно когда-либо появится.

#### Год без JetBrains

— **Года два назад ты на какое-то время JetBrains покинул. Можешь ли ты про это немножко рассказать?**

Я уходил из JetBrains в Google. На тот момент я провел уже 10 лет в JetBrains. Хотелось чему-то новому научиться.

— **Чем ты занимался в тот момент, когда уходил?**

На тот момент я формально был CTO, но выполнять эту роль уже не очень получалось. Я скорее был тимлидом PyCharm и WebStorm. Это были две основные задачи, которыми я тогда занимался. И, кажется, это был довольно хороший момент, чтобы уйти, потому что какой-то большой следующей задачи, в которой мне надо было бы обязательно участвовать, не было. Было кому передать мои проекты.

Я хотел попробовать чего-то нового. И я был готов и к такому варианту, что я вернусь в JetBrains, и к тому варианту, что я останусь в Google. Я заранее обговаривал возможность вернуться, и мне сказали: Да, будем рады тебя видеть. В итоге, так и получилось.

— **Если не секрет, чем ты занимался в Google? В какой области ты работал?**

Я делал инструменты для разработки под Google Cloud Platform. Например, есть такая штука — Сloud Debugger: вы можете на своем production-приложении, на App engine, на compute engine ставить какие-то точки. Но это не точки останова, это точки снятия информации. Прямо в source code в этом месте у вас собирается call stack, собираются значения всех локальных переменных. И вам это все отсылается, и при этом не останавливается процесс. То есть это реально происходит в production’е. Вы там можете ставить условные breakpoint’ы. Наконец, это довольно эффективно по производительности, то есть, не приводит к какому-то заметному замедлению. Мы занимались фронтендом: возможностью в браузере смотреть call stack, значения переменных, source code

— **В итоге тебе там не понравилось? Или какие-то обстоятельства были, вынудившие тебя?**

Нет, меня ничего не вынуждало. В Google довольно важно найти свое правильное место. Google – компания большая, компания очень разная. У них есть слоган «do cool things that matter», то есть, «занимайся клевыми штуками, которые имеют значение». Но это верно совсем не для всех сотрудников компании Google. То есть, есть сотрудники, которые занимаются очень клевыми штуками, которые очень имеют большое значение, но есть сотрудники, которые занимаются просто разной работой, которая должна быть сделана.

— **Современный Google — это более 50 тысяч человек. А сколько там девелоперов?**

Тысяч 25-30.

— **Вокруг Google существует огромное количество мифов, вплоть до таких, что некоторые сотрудники жалуются, что не могут работать, потому что справа и слева от их рабочего места находятся на одинаковом расстоянии находятся два бассейна, и они мучаются от того, что не знают, какой выбрать. Насколько это соответствует действительности?**

На самом деле, не соответствует. То есть как сказать? В Google можно довольно долго искать себя. А заниматься этим можно с очень разной степенью продуктивности.

— **Ты решил пойти по другому пути, ты решил не искать. Ты решил вернуться.**

Если бы я был готов еще 3-4 года потратить на такие поиски, съездить в Mountain View на годик, попробовать разные команды, близко познакомиться с большим количеством разных людей, то у меня было бы все хорошо в Google через какое-то время. Но я просто понял, что сейчас, сегодня, есть Kotlin, с которого меня очень прет, и в который я могу прийти и начать делать, я очень хочу, чтобы у JetBrains с ним все получилось. И не надо ничего искать.

Там, опять же, это одни из самых сильных людей в JetBrains, с которыми я работал — Андрей Бреслав, Илья Рыженков и многие другие ребята в команде. Лучше я в JetBrains, чем в Google буду куда-то тыкаться. На самом деле, я очень рад, что сходил в Google, это был ценный опыт, я получил желаемую смену обстановки. И очень рад, что вернулся.

— **Ты затронул тему команды Kotlin. Она формировалась где-то в 2011ом году. Ребята, которые нанимались в тот период (я просто знаю довольно много людей из этой команды), фактически были на тот момент вчерашними выпускниками ВУЗов. И тут получается некоторый казус. С одной стороны, вы на всех углах тогда трубили, что мол, JetBrains накопила большой опыт по написанию компиляторов и поддержке языков, и поэтому сейчас будете делать свой язык. А с другой стороны, вы наняли на это вчерашних студентов в большом количестве, у которых очевидно такого опыта нет. Как так? Как этот факт вообще повлиял на разработку?**

Я думаю, что повлиял. Например, команде пришлось потратить какое-то время, прежде, чем performance плагина стал таким, чтобы можно с ним было нормально работать. С другой стороны, что какие-то из старожилов всегда участвовали в разработке. Например, Максим Шафиров участвовал и на самой ранней стадии. Да и сейчас он пользуется Kotlin, приходит на дизайн-митинги, дает feedback по поводу развития языка. А в целом, команда сейчас довольно молодая. То есть там есть несколько старожилов, например, Валя Кипятков, я, Илья Рыженков. И в принципе этого достаточно, как мне кажется, чтобы передавать опыт.

— **Были ли в этапе в жизненном в развитии Kotlin какие-то большие ошибки? То есть было ли такое, что вас куда-нибудь уносило не в ту сторону надолго? Или в принципе такого не было?**

Было. Я не буду говорить, что это ошибка, это скорее, поиски пути, которые заняли время. Одним из ключевых пунктов в дизайне языка было то, что мы хотим решить проблему nullability, чтобы мы всегда знали, где у нас значения могут быть null, а где они не могут.

— **[The billion dollar mistake.](https://en.wikipedia.org/wiki/Tony_Hoare#Apologies_and_retractions)**

Да-да, она самая. Мы живем на платформе Java, и в Java этих средств нет. Соответственно, нам нужно уметь работать с кодом на Java, в котором этой информации нет. Соответственно, для того, чтобы эту информацию для Java-класса получить, нам нужно что-то изобрести.

Изначально у нас была модель фиксированной аннотации: есть класс, и где-то рядышком для него лежит файлик, который откуда-то взялся, в котором в xml про каждый метод написано, что это метод, у которого два параметра: первый – not nullable, второй – nullable, и возвращаем значение nullable. Мы написали такой файлик для JDK и решили, что какие-то другие люди напишут такие файлики для известных библиотек. А если у вас свой проект, то вы можете для своего кода просто прямо в коде писать аннотации, обычные Java. Это не взлетело.

Потом мы придумали KAnnotator – решение, которое сканирует байткод и делает анализ. Например, если где-то передается параметр, который сразу же дереференсится, значит, он not nullable. И возвращаемые значение тоже трекаются. Соответственно, KAnnotator — это внешний инструмент, который генерирует вот эти же файлики с фиксированными аннотациями. Фактически, это глобальный data flow анализ в программе. Это оказалось штукой прикольной, но тоже не очень практичной. Потому что исходный код распадается на две независимых части — сам код и вот эти аннотации, которые могут потеряться или могут разъехаться по версиям. И мы в итоге признали, что это тоже не работает.

И теперь у нас более простое решение — платформенные типы. Это отдельные сущности, типы, для которых у нас нет nullability информации. Они пришли из Java. Когда человек имплементирует метод Java-интерфейса, он может у типов параметров написать любое nullability. То есть он сам знает, какая nullability правильная, и либо пишет вопросик, либо не пишет вопросик. И то, и другое компилятор разрешает. И ведет себя в соответствии с тем, что написал пользователь. Но при этом никакого отдельного файла, никакого осложнения workflow нет. Если хочется, в Java-коде можно написать аннотации Nullable и NotNullable — мы их по-прежнему понимаем.

Вся эта история с KAnnotator'ом отняла у нас довольно много сил и времени. Но с другой стороны, мы не знали, что это неработающий вариант, когда начинали.

— **Не каждый же день пишешь новый язык программирования. Я вот не уверен, что если бы команда была существенно более опытная, вас бы это спасло от всех ошибок.**

Может быть.

— **Если я правильно понял, вы теперь даете пользователям самим решать, где выстраивать периметр вот этой null-защиты?**

Периметр – это граница между Java и Kotlin кодом. То есть мы все равно генерим assertion, если там нет вопросиков. Просто конфигурация этого периметра задается пользователем самостоятельно.

— **То есть он сам может выбрать, где на стэке вызовов он будет это проверять?**

Это проверятся всегда на уровне перехода между Java и Kotlin.

— **Окей. Тогда, может быть, чуть-чуть возвращаясь к Google. Когда ты туда уходил, ты, наверное, ожидал чего-то. И насколько это совпало с тем, что ты реально увидел?**

Да, у меня были разного рода ожидания, и не все из них оправдались. Например, наивное ожидание, что у меня будет менеджер, которые меня будет «менеджерить», будет заботиться о моем развитии и совершенствовании. Нет.

— **Но ведь в JetBrains, я так понимаю, тоже такого не было?**

В JetBrains такого не было, и мне как раз хотелось посмотреть, как это.

— **Если не секрет, в JetBrains в каком возрасте попал примерно?**

Мне было 22, получается. Я работал до этого разных компаниях, я очень рано начал работать. Фактически, первая работа, за которую мне какие-то денежки платили – мне было лет 17.

— **Это было программирование?**

Да, программирование. А первая работа, за которую мне вообще платили деньги — переводы. Мне вообще 13 тогда было. Поэтому у меня какой-то опыт уже был на тот момент. У меня был успешный OpenSource-проект, например.

Возвращаясь к Google. Google делает обалденно фантастические вещи. Ты заходишь на их сайт, печатаешь, он тебе в реальном времени показывает результаты поиска того, что ты тут 100 миллисекунд назад печатал. Ты нажал клавишу, и через 100 миллисекунд ты видишь результаты поиска фразы с этой клавишей, с этой буковкой по всему мировому интернету. Это же реально очень круто.

И глядя на Google, ты думаешь, что вот, я туда приду, и там просто что-то совершенно волшебное, благодаря чему это все так работает, и на чем это все держится. Оказывается, нет. Оказывается, секретного ингредиента не существует. Рецепт, как я сформулировал для себя (наверное, это главное, что я вынес из Google) — это рецепт, как делать, чтобы так получалось.

Во-первых, очень важное значение имеет хорошая storage-система. С репликацией, с масштабированием. То есть система хранения данных — это действительно то, на чем все держится. Не зря сейчас появляются десятки стартапов, которые пишут свои NoSQL-хранилища.

— **Правильно ли я понимаю, что это ноу-хау Google? И что это, за счет чего компания вообще является технологическим лидером?**

Трудно сказать. На самом деле Google довольно много всего рассказывает. И про BigTable, на котором до сих пор дофига всего написано. Есть статья, в которой написано, как он работает. Потом новая система Spanner, на которую сейчас довольно много сервисов мигрирует внутри Google, которая делает вообще волшебные вещи — прозрачную репликацию между континентами. Про нее тоже статья есть о том, как она работает.

То есть большого секрета, как такового, нет, и слово «ноу-хау» не очень применимо. То, что написано в статье дальше это нужно правильно, хорошо, грамотно реализовать. А вот это дано не всем. Соответственно, если у вас хороший data storage, то вам можно и нужно запускать много копий вашего приложения. Если ты все что угодно запускаешь в Google, то по умолчанию ты запускаешь три экземпляра. Соответственно, по сравнению с этим, мне очень грустно смотреть на TeamCity, Youtrack, которые все такие монолитные, все, у Youtrack вообще встроенная база данных.

— **[Xodus](https://github.com/JetBrains/xodus).**

Xodus, да. Репликации нету, масштабирования нету... То есть понятно, что такое решение на каком-то этапе упрощает жизнь. Но я говорю, что мне на это смотреть грустно. Потому что понятно, что Youtrack не будет работать также хорошо, как Google поиск.

— **Вадим Гуров (бывший менеджер Youtrack — прим. автора) рассказывал, что как-то раз на одной из конференций они спросили ребят из Atlassian, сколько людей у них занимается поддержкой SaaS-версии JIRA. Оказалось, что 30 человек. А в Youtrack поддержкой SaaS-версии занимается всего один разработчик.**

Это история про understaffed, которую я упоминал. Может быть, с какой-то точки зрения она не настолько разрешилась, как мне кажется.

Cледующий ингредиент Google — это не стесняться использовать ресурсы. Оперативная память вообще не очень дорого стоит. Можно загрузить все данные в память, то есть, иметь столько оперативной памяти, чтобы, например, загрузить в нее всю базу данных боевого Youtrack, без attachment-ов. Можно поставить сервер, или несколько серверов, в которых будет столько оперативки, скольконужно. Потом сделать шардинг, репликацию, по науке. Следующий ингредиент, обязательный — это мониторинг производительности. То есть нужно обязательно всегда следить за тем, как это все работает. 95 перцентиль lanency, median latency — нужно за всем этим следить. И нужно просто постоянно работать над улучшением всего, что у вас есть. И, в конце концов, если это все сделать, то получается Google Search.

— **Иными словами, это не какая-то магия и волшебство, а просто отлаженный процесс. Этот процесс работает только в каких-то топовых продуктах типа поиска? Или эта культура распространяется по всей компании, по всем продуктам?**

По-разному. Всем рассказывают, как правильно. Даже не столько рассказывают, сколько показывают примеры. Но, например, настройка мониторинга, о которой я говорил, это довольно большая, сложная задача. Которая, причем, ни в какой момент не заканчивается. То есть мониторинг, alerting, что-то еще в этом духе — непрерывно подкручивается. Вот этот alert слишком шумный, он разбудил ночью программиста, чтобы он бежал чинить, а чинить ничего не надо. Было там, на самом деле, все хорошо, просто alert сработал не по тому условию. И есть проекты, которым помогают SRE (Site Reliability Engineers), это роль такая в Google, многие про это знают, много где рассказывали. Это одна из основных вещей, которыми они занимаются. Весь мониторинг, alerting, распределение ресурсов, правильное распределение по кластерам.

И если у вас SRE есть, то у вас все хорошо. Но есть много мелких сервисов, у которых просто SRE нету. То есть программисты сами занимаются поддержкой. И на самом деле, это занимает страшное количество времени и сил — поддержание сервисов в работающем состоянии. Что у сервиса всего хватает, что он не падает, что у него не кончилась storage quota, у него нормальный response time по всем запросам, которые к нему, что его никто не DoS-ит и так далее.

— **Из последнего, что было больно – это закрытие Google Сode. Что-то знаешь про это?**

Я собственно даже пытался спасти Google Code. История простая: Google Code просто был сделан на довольно старом, не поддерживаемом наборе фреймворков, как очень часто бывает в Google. Это проблема, которая автоматически случается, когда у вас в компании 20 000 программистов. Программисты – они программируют. Они любят делать всякие фреймворки, технологии, middleware какой-то. И потом на этом middleware строят продукты. А потом с этим middleware становится неинтересно, или люди, которые его делали, уходят и приходят другие люди и так далее. И появляется какое-то новое middleware, на котором теперь все полагается писать.

Google Code — продукт, написанный на довольно старом наборе технологий, который довольно долго и дорого переводить в состояние, чтобы его можно было нормально поддерживать и нормально сопровождать. И плюс к тому, это как сервис, который позволяет хостить всякие штуки в интернете, он всегда был большой мишенью для abuse разного рода. Раз туда можно залить файлики, давайте туда зальем порнушку, или, например, крякнутое какое-нибудь android-приложение, или еще что-то такое. И народ тратил много сил на то, чтобы с этим бороться. Там в какой-то момент функциональность download просто исчезла. Но были там другие способы abuse...

И вот это просто все тянулось, и было ощущение, что это, на самом деле, не нужно. Потому что GitHub победил, и все равно все, все равно жизнь вся там, и у Google на тот момент была куча своих проектов на GitHub. И поэтому решили Google Code закрыть.

— **Ты говоришь, что как-то пытался его реанимировать?**

Я решил, что нельзя же так, это же плохо и грустно. И решил поговорить с соответствующими людьми. Вроде я придумал, что можно сделать. Потом пришел к людям, но оказалось, что они про все это уже подумали, придумали, у них есть документ на 15 страниц, в котором написано почему это не сработает, и... «спасибо за ваш фидбек, но мы и сами все знаем». Если ты думаешь, что самый умный, то в Google это гарантировано не так. Если ты хочешь что-то предложить — с вероятностью 75% другие люди уже про это подумали. И либо поставили в план и собираются сделать, либо знают почему это не сработает, либо знают почему это не соответствует каким-то целям и так далее.

— **Это эффект большой компании или чего-еще?**

В Google все-таки хорошие люди, сильные работают. Это эффект гуглового рекрутинга.

#### ЖЖ и хабр

— **Пара вопросов, которые лично меня интересуют. ЖЖ-сообщество ru_java, ты участвовал в этом комьюнити. Сейчас пациент скорее мертв. Как ты думаешь, как так вышло? То есть эволюция того, то есть тот дискуcс, он куда-то сместился, отпала вообще необходимость в таких дискуссиях?** Я не то, чтобы там что-то активно делал, насколько я помню. Но я там отвечал на какие-то вопросы об IDEA. Сам ЖЖ — довольно странная платформа. А сейчас все перешло на хабр, как мне кажется.

— **Я ждал от тебя такого ответа. На хабре [твой последний пост](http://habrahabr.ru/post/134544/) датирован 2011 годом, а твой последний заход, внимание, залогиненый, на хабр, это конец 2013 года.**

Это странно, потому что мне приходит еженедельный newsletter с интересными материалами.

— **Но, тем не менее, видимо ты 2 года уже не логинишься и не отвечаешь на комментарии, и так далее.**

Да, я видимо не залогиненым читаю.

— **Писать в ближайшее время не собираешься? Другие люди у вас уже этим занимаются?**

Про хабр стоит сказать отдельно. Для PhpStorm, на его ранних стадиях, этот канал был крайне важен, как возможность для общения с пользователями. Мы постоянно рассказывали, что там появилось, что поменялось. Шла дискуссия, там всегда было много обсуждений, всегда разработчики отвечали. Мы с PyCharm тоже всегда активно участвовали в обсуждениях.

Наверное, надо туда постить что-нибудь и про Kotlin. Просто у нас никто специально не занимается сейчас промоушеном в соцсетях, скажем так. Мы пишем, на англоязычных ресурсах что-то, на Reddit у нас появляются дискуссии. Есть [subreddit про Kotlin](https://www.reddit.com/r/Kotlin), еще что-то. А на русскоязычное сообщество нам, наверное, просто не сил не хватает. И опять-же, я сейчас пишу книжку. Поэтому вписываться в то, что сейчас писать еще что-то большое, другое, я не очень хочу.

#### JUG и конференции

— **И такой, еще личный. У нас на [новом сайте JUG.ru](http://jug.ru/), есть кавер-фотография, я не знаю, ты видел или нет. На ней ты. Что рассказывал на старом JUG?**

[![](https://habrastorage.org/files/ea8/e53/a9e/ea8e53a9e1d54e1a8db6aaca95822e8b.jpg)](http://jug.ru/history)

На JUG я точно рассказывал про TeamCity, когда-то давно, еще в 2006, по-моему, году. И что-то я еще рассказывал, но сейчас не вспомню. Я знаком с Яшей Сироткиным довольно хорошо.

— **Я хочу сейчас официально пригласить в твой, наверное, следующий уже, или через следующий твой приезд в Питер. Да, обязательно что-нибудь у нас на JUG рассказать. И может быть выступить на ближайшей какой-то конференции. Это официальное приглашение перед всеми зрителями и читателями.**

Да, я с удовольствием расскажу.

* * *

_P.S.: И действительно расскажет:_

**Дмитрий Жемеров на Joker 2015**

**Опыт использования Kotlin в JetBrains**

![jemerov](https://habrastorage.org/files/0f7/9ea/71f/0f79ea71f8974a39ae5266c4cc9b9da5.jpg)
Kotlin — новый язык программирования для JVM, Android и JavaScript, который с 2010 года разрабатывается компанией JetBrains. Язык ориентирован на написание элегантного, компактного и безопасного кода, свободно интегрируется с существующим Java-кодом и имеет мощную поддержку в IDE. В последнее время язык все более активно используется как внутри JetBrains, так и внешними разработчиками.

В докладе Дмитрий расскажет об использовании Kotlin в двух проектах JetBrains — в системе поддержки продаж и менеджмента лицензий (это Web-приложение, целиком сделанное на Kotlin) и в IntelliJ IDEA (здесь Kotlin интегрируется в большой существующий проект). Будут показаны различные фреймворки, которые появились в процессе разработки и которые могут пригодиться и вам. Так же Дмитрий расскажет о том, какие плюсы они получили от внедрения Kotlin и с какими трудностями встретились.

* * *

Этот и другие доклады Joker 2015 — **[на сайте конференции](http://jokerconf.com/#talks)**.

"""

Article(
  title = "Без слайдов: интервью с Дмитрием Жемеровым из JetBrains",
  url = "https://habrahabr.ru/company/jugru/blog/263905/",
  categories = listOf(
    "Kotlin"
  ),
  type = article,
  lang = RU,
  author = "Алексей Фёдоров",
  date = LocalDate.of(2015, 7, 31),
  body = body1 + body2
)
