
import link.kotlin.scripts.dsl.Article
import link.kotlin.scripts.dsl.LanguageCodes
import link.kotlin.scripts.dsl.LinkType.webinar
import java.time.LocalDate

val body = """
The recording of our October 22nd webinar, **Functional Programming with Kotlin**, is now available on [JetBrainsTV YouTube channel](https://youtu.be/AhA-Q7MOre0).

In this talk, Mike Hearn provides a brief introduction to programming in Kotlin via practical example: creating a textfield with the autocomplete suggestions while typing. Demo project is available on [GitHub](https://github.com/mikehearn/KotlinFPWebinar).

Topics covered include:

*   Use of functional transforms
*   Immutability
*   Lazyness and working with lazy infinite sequences
*   The use of [funKTionale](https://github.com/MarioAriasC/funKTionale), a library that extends Kotlin with a few features known from Haskell
*   Pattern matching
*   Reactive user interfaces

<iframe src="https://www.youtube.com/embed/AhA-Q7MOre0" allowfullscreen="" height="480" frameborder="0" width="960"></iframe>

The video includes the time stamps following the [agenda announced](http://blog.jetbrains.com/kotlin/2015/10/join-live-webinar-functional-programming-with-kotlin/):
* `00:08` — Intoduction and demo application
* `05:00` — `apply` function
* `05:45` — Introduce NGram data class
* `08:22` — Creating extension methods
* `09:55` — Working with lazy infinite sequences
* `10:35` — `map` function
* `11:10` — `to` function and infix notation
* `14:35` — Destructuring of data classes
* `19:20` — `filter`, `let` and `all` functions
* `23:00` — Debug lazy code
* `24:20` — Add completions to UI
* `25:18` — Load data in a functional way
* `28:30` — Improve performance of the data loading
* `33:20` — Improve the UI responsiveness in RX style
* `40:05` — Using [Kovenant](https://github.com/mplatvoet/kovenant) library
* `42:03` — Using [funKTionale](https://github.com/MarioAriasC/funKTionale) library
* `44:10` — Currying
* `45:35` — Questions

About the Presenter:

![Mike Hearn](http://i2.wp.com/info.jetbrains.com/rs/426-QVD-114/images/Mike_Hearn_200x200.jpg?resize=100%2C100 "Mike Hearn") [Mike Hearn](http://plan99.net/~mike/) is a Java, Kotlin and C++ developer who works on digital currency related software. Prior to that he was a senior software engineer at Google, where he spent over seven years working on a range of products including Earth, Maps, Gmail and the accounts system.

Thanks to all the attendees for the questions! If you still have some, please, contact Mike or our team.

You are welcome to suggest themes for future webinars in comments.

_Let’s kotlin!_
"""

Article(
    title = "Functional Programming with Kotlin",
    url = "http://blog.jetbrains.com/kotlin/2015/11/webinar-recording-functional-programming-with-kotlin/",
    categories = listOf(
        "Kotlin",
        "Webinar",
        "Fp",
        "Functional"
    ),
    type = webinar,
    lang = LanguageCodes.EN,
    author = "Roman Belov",
    date = LocalDate.of(2015, 11, 5),
    body = body
)
