
import link.kotlin.scripts.dsl.Article
import link.kotlin.scripts.dsl.LinkType.*
import link.kotlin.scripts.dsl.LanguageCodes.*
import java.time.LocalDate

// language=Markdown
val body = """
The recording of our September 16th webinar, **Quasar: Efficient and Elegant Fibers, Channels and Actors**, is now available on [JetBrainsTV YouTube channel](https://youtu.be/Nmob2MB2Qo8).

In this webinar, Fabio Tudone shows how to use Quasar for creation of highly concurrent software. He covers basics of Kotlin syntax and shows how Quasar uses Kotlin strengths to offer concise and expressive API.

Demo project is available on [GitHub](https://github.com/circlespainter/quasar-kotlin-jetbrains-webinar/releases).

The video includes the time stamps following the [agenda announced](http://blog.jetbrains.com/kotlin/2015/09/join-live-webinar-quasar-and-kotlin/):
* `00:55` – What are Quasar and Fibers?
* `12:22` – What are Quasar Channels?
* `15:50` – What are and why using Quasar Fibers?
* `21:15` – From Async to efficient Fiber-Sync with Quasar
* `27:13` – Quasar Actors and Selective Receive
* `37:54` – Quasar Dataflow
* `45:19` – Pulsar: Quasar’s idiomatic API for Clojure
* `45:19` – Comsat: existing APIs on steroids with Quasar Fibers
* `47:07` – Comsat Web Actors for HTTP, SSE and WebSockets
* `49:58` – Capsule: deploy Quasar and any JVM applications

<iframe src="https://www.youtube.com/embed/Nmob2MB2Qo8" allowfullscreen="" height="480" frameborder="0" width="960"></iframe>

About the Presenter:

[Fabio Tudone](https://twitter.com/ftudone) works on Quasar, Pulsar and Comsat at Parallel Universe. He has been writing mostly JVM software during his entire career, and before joining [Parallel Universe](http://www.paralleluniverse.co/) he led the development of a cloud-based enterprise content governance platform. His interests include Dev and DevOps practices, scalability, concurrent and functional programming as well as runtime platforms at large.

Thanks to all the attendees for the questions! If you still have some, please, contact Fabio or our team.

You are welcome to suggest themes for future webinars in comments.

_Let’s kotlin!_

"""

Article(
  title = "Quasar: Efficient and Elegant Fibers, Channels and Actors",
  url = "http://blog.jetbrains.com/kotlin/2015/09/webinar-recording-quasar-efficient-and-elegant-fibers-channels-and-actors/",
  categories = listOf(
    "Kotlin",
    "Webinar",
    "Fibers",
    "Channels",
    "Actors"
  ),
  type = webinar,
  lang = EN,
  author = "Roman Belov",
  date = LocalDate.of(2015, 9, 21),
  body = body
)
