
import link.kotlin.scripts.dsl.Article
import link.kotlin.scripts.dsl.LinkType.*
import link.kotlin.scripts.dsl.LanguageCodes.*
import java.time.LocalDate

// language=Markdown
val body = """
After a long and winding road to development, pragmatic JVM and Android newcomer [Kotlin](http://blog.jetbrains.com/kotlin/2016/02/kotlin-1-0-released-pragmatic-language-for-jvm-and-android/) 1.0 is officially GA. The open source progeny of Java IDE supremo JetBrains (it was developed on [GitHub](https://github.com/JetBrains/kotlin) under the Apache 2.0 Open-Source license), Kotlin has been cooking since 2010, and as you’d expect, runs seamlessly on the company’s signature Java IDE, [IntelliJ](https://www.voxxed.com/blog/2015/09/partying-with-intellij-idea-dart-java-websocket-and-glassfish/) IDEA.

A key characteristic of Kotlin is its end user focus, and a steadfast effort has been made in its development to ensure features lists are sharp and concise. It’s also lightweight and fully interoperable with the Java language, making it a natural fit for mobile development.

Although originally intended to be a contemporary answer to the legacy issues Java brought in its wake, Kotlin could prove an excellent choice for Android developers in 2016 looking for a JVM alternative that reaches beyond the capabilities for version 6 of the platform. And thanks to the kotlin-android-extensions plugin in for the Kotlin compiler, developers can access views in a type-safe fashion without the need for extra user code or runtime libraries.

Moreover, as Antonio Leiva [notes](https://www.voxxed.com/blog/2016/01/kotlin-android-developers/), Kotlin’s library is small enough to let developers work without proguard during development. Then there’s the not-inconsequential fact that Android Studio (the official Android IDE) was constructed on top of IntelliJ.

Aside from its aptitude for Android development, lead language designer [Andrey Breslav](http://blog.jetbrains.com/kotlin/author/andrey-breslav/) highlights that, because Kotlin can run wherever Java runs – be that server-side applications, mobile applications (Android), or desktop applications, it plays nicely with most of the leading Java ecosystem tools, including things like Maven, Gradle and Ant, GitHub, Slack, and, as of today, officially supports [Spring Boot](https://spring.io/blog/2016/02/15/developing-spring-boot-applications-with-kotlin). And, because you can use libraries interchangeably between Java and Kotlin, you can keep bytecode footprints nice and small.

Breslav comments that, even before its official release, a number of companies have judged Kotlin fit for production, and JetBrains themselves have been utilising the language, along with its compiler and tooling projects, on extensive “real-life” projects for the past two years. In terms of adoption, over 11,000 people used Kotlin last month, and there are already two books – [Kotlin in Action](https://www.manning.com/books/kotlin-in-action) and [Kotlin for Android Developers](https://leanpub.com/kotlin-for-android-developers) – to get developers going with the language.

Going forward, JetBrains will look to make Kotlin development more transparent by establishing a centralized venue for design proposals and discussions. You can expect standardization efforts to happen in the near future too. Aside from bug fixes, plans for the roadmap ahead include formalised support for JavaScript (at the moment this is strictly experimental), performance improvements to the Kotlin toolchain, and support for generating Java 8 bytecode with things like optimized lambdas.

For a taste of what Kotlin has to offer, its creators recommend giving this online mini-IDE [try.kotl.in](https://try.kotlinlang.org/) a whirl and having a go at [Koans](http://try.kotlinlang.org/koans) — a set of introductory problems to guide you through the basics of the language.

To learn more about Kotlin and how it compares to fellow Java-botherer Ceylon, as well as Java itself, we suggest checking out this Devoxx UK 2015 session by Russel Winder:

[https://www.youtube.com/watch?v=Q_Z_8HXt68k](https://www.youtube.com/watch?v=Q_Z_8HXt68k)

"""

Article(
  title = "JVM Newcomer Kotlin 1.0 is GA",
  url = "https://www.voxxed.com/blog/2016/02/kotlin/",
  categories = listOf(
    "Kotlin",
    "JVM,"
  ),
  type = article,
  lang = EN,
  author = "Lucy Carey",
  date = LocalDate.of(2016, 2, 15),
  body = body
)
