
import link.kotlin.scripts.dsl.Article
import link.kotlin.scripts.dsl.LinkType.*
import link.kotlin.scripts.dsl.LanguageCodes.*
import java.time.LocalDate

// language=Markdown
val body = """
It’s been almost two months since Kotlin 1.0 was released, and the team is now switching from stabilisation and bug fixes to new feature work, so it’s a great time to talk about our plans for the future.

We’ve already published our [Android roadmap](http://blog.jetbrains.com/kotlin/2016/03/kotlins-android-roadmap/), but there are many other areas where we’re applying our efforts. Our current development is organised in two main branches:

* **Kotlin 1.0.x** which will be a series of releases containing bug fixes, updates to tooling, IDE support and other areas which do not affect the core language. 1.0.x releases will be published on a regular basis once every several weeks.
* **Kotlin 1.1** which will contain major new language features, along with all the improvements from the 1.0.x branch. This will be a feature-driven release, and we aren’t announcing any specific time frame for it.

Let’s look at the plans for each area in more detail, starting with the big ones.

## New Language Features

Before we can start talking about specific features, the **big disclaimer**: everything we’re talking about here is still in the design phase, and features may end up being changed dramatically or dropped entirely as we move forward with the design, implementation and feedback gathering process. So, no guarantees.

### async/await/yield

The most important feature that we’re designing right now is support for **coroutines** (async/await/yield). By now, the async/await pattern has found its way into many different languages, including C#, Python and Dart, and we want to support this in Kotlin as well. However, that’s not the end of the story: we want to put the specific code execution semantics into the library, rather than the compiler.

The compiler will take care of transforming the function used as a coroutine into a form allowing to suspend and resume its execution. The actual execution of a coroutine (the initial invocation, as well as resuming the execution after a suspension point) will be the responsibility of the support library. Therefore, the same mechanism will allow us to support many different patterns: generators (`yield`), asynchronously executed functions (`async`/`await`), Go-like channels and goroutines, as well as potentially others which haven’t even been invented yet.

Note that we’re still in the process of estimating the effort needed to implement this feature, and we don’t know whether it would be reasonable to support it in the 1.1 timeframe or it would be postponed to a later release.

### Other Language Features

We’ve received quite a lot of feedback from Kotlin 1.0, and we were quite happy to see that a lot of the requests were asking for the same features. We’ve chosen the ones that come up the most often, and have prioritised them for Kotlin 1.1. Those we’re reasonably sure about are:

*   **Data class hierarchy support** will remove many of the current restrictions on data class inheritance, for example, allowing you to represent an algebraic data type as a series of data classes nested in a sealed class:
    ```kotlin
    sealed class C {
        data class A(val x: X, val y: Y) : C() { ... }
    }
    ```
*   **Type aliases** will allow to assign a short name to a type (for example, a function type, or a generic type with a long signature):
    `typealias MouseEventHandler = (MouseEvent) -> Unit`
*   **Destructuring in lambdas** will allow you to easily unpack a data class instance or another object supporting the destructuring protocol when it’s passed as a parameter to a lambda:
    `myMap.forEach { (key, value) -> println(key+value) }`
*   **Bound method references** will allow to create a method reference that invokes a method on a specific object instance, and doesn’t require passing it as a parameter:
    `letters.filter("abc"::contains)`
*   **Local delegated properties** will allow you to define a local variable as a delegated property:
    `fun foo() { val x by lazy { ... } }`

## Java 8/9 Support

As of version 1.0, Kotlin targets Java 6 only. This means that the generated bytecode does not make use of any features added in Java 7 or 8, and the standard library only exposes the APIs that existed in Java 6.

Over the course of 1.0.x and 1.1 releases and beyond, we plan to remove these restrictions, and to give you the choice of the JVM version that you’re targeting. Java 6 is still going to be supported, but if you choose to target Java 8, we’ll make use of that. The standard library will let you use the new Java 8 APIs, such as the stream API, and the compiler will use the newer bytecode features, such as the support for default methods in interfaces. We also plan to support Project Jigsaw (the JDK 9 module system) by the time JDK 9 is released.

## JavaScript Support

When we started finalizing the 1.0 release, we decided to suspend work on JavaScript support and to focus on the JVM as the main supported platform for the release. Now that 1.0 is out, we’ve resumed work on JS, and we’re moving towards our goal of letting you write the business logic of your application only once and to run it both on the backend and in the user’s browser.

Our main priorities for the short term are filling in the missing language features and better integration with the overall JavaScript infrastructure (starting with support for JS module systems). We also plan to leverage the huge set of strongly-typed API definitions for most major JS libraries, which has been accumulated by the TypeScript community. We’ll provide a tool to convert those definitions into Kotlin code, letting you use the libraries from Kotlin with a fully typed API and very little effort spent on integration.

## IDE Features

In the IDE space, our current priorities are as follows:

* **Framework support**: We plan to extend the unparalleled level of Java enterprise framework support offered by IntelliJ IDEA Ultimate so that it works equally well for Kotlin. This will be a gradual process happening in parallel inside IntelliJ IDEA and inside the Kotlin plugin; the first batch of Spring support features is already available in Kotlin 1.0.2 EAP.
* **Intentions and Quickfixes:** In our view, one of the main roles of an IDE is teaching you how to use the language well and helping you get back to speed if you make a mistake, by providing code improvement suggestions and automatic quickfixes. Kotlin 1.0 already contains a nice set of tools in this area, and we’re going to expand on it in the 1.0.x and 1.1 updates. As one example, we’re building tools that can convert imperative-style loops into code written in the functional style, using functions such as map and filter.
* **Other Improvements:** Other things on our roadmap include new refactorings such as Inline Method, a more robust and flexible formatter, support for diagrams for Kotlin code, and more.

## Other Tooling Improvements

The Android roadmap post already mentioned some of the improvements that we plan to make in our tools, such as support for incremental compilation with Gradle and support for Android Lint checks. Both of these features are already available in Kotlin 1.0.2 EAP, and will receive further improvements later on.

## Summary

As you can see, there are quite a lot of exciting things coming, and there’s plenty of opportunity for you to get involved. Stop by our [Slack chat](http://kotlinslackin.herokuapp.com/), try out the [EAP builds](https://discuss.kotlinlang.org/c/eap), file [issues](http://youtrack.jetbrains.com/issues/KT) – the future of Kotlin depends on you, our users, and we’re always happy to hear anything that you have to say.

"""

Article(
  title = "Kotlin Post-1.0 Roadmap",
  url = "http://blog.jetbrains.com/kotlin/2016/04/kotlin-post-1-0-roadmap/",
  categories = listOf(
    "Kotlin"
  ),
  type = article,
  lang = EN,
  author = "Dmitry Jemerov",
  date = LocalDate.of(2016, 4, 14),
  body = body
)
